# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from .....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .bgp_view_prefix_parent import BgpViewPrefixParent


class BgpViewPrefix(UniversalBaseModel):
    """
    Bgp prefix information from BgpView API
    """

    prefix: str = pydantic.Field()
    """
    The IP prefix
    """

    ip: str = pydantic.Field()
    """
    The IP address
    """

    cidr: int = pydantic.Field()
    """
    CIDR notation length
    """

    roa_status: str = pydantic.Field()
    """
    Route Origin Authorization status
    """

    name: str = pydantic.Field()
    """
    Name of the prefix
    """

    description: str = pydantic.Field()
    """
    Description of the prefix
    """

    country_code: str = pydantic.Field()
    """
    Country code for the prefix
    """

    parent: typing.Optional[BgpViewPrefixParent] = pydantic.Field(default=None)
    """
    Parent prefix information
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow
