# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from .....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class CymruAsnResult(UniversalBaseModel):
    """
    Represents the parsed result from a Cymru ASN lookup
    """

    asns: typing.List[str] = pydantic.Field()
    """
    All Autonomous System Numbers associated with the IP (may be multiple for multi-homed networks)
    """

    bgp_prefix: str = pydantic.Field(alias="bgpPrefix")
    """
    The BGP prefix associated with the ASN
    """

    country_code: str = pydantic.Field(alias="countryCode")
    """
    The country code where the ASN is registered
    """

    registry: str = pydantic.Field()
    """
    The registry that allocated the ASN
    """

    alloc_date: str = pydantic.Field(alias="allocDate")
    """
    The date when the ASN was allocated
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow
