# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputePoolArgs', 'ComputePool']

@pulumi.input_type
class ComputePoolArgs:
    def __init__(__self__, *,
                 instance_family: pulumi.Input[_builtins.str],
                 max_nodes: pulumi.Input[_builtins.int],
                 min_nodes: pulumi.Input[_builtins.int],
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 for_application: Optional[pulumi.Input[_builtins.str]] = None,
                 initially_suspended: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ComputePool resource.
        :param pulumi.Input[_builtins.str] instance_family: Identifies the type of machine you want to provision for the nodes in the compute pool. Valid values are (case-insensitive): `CPU_X64_XS` | `CPU_X64_S` | `CPU_X64_M` | `CPU_X64_L` | `HIGHMEM_X64_S` | `HIGHMEM_X64_M` | `HIGHMEM_X64_L` | `HIGHMEM_X64_SL` | `GPU_NV_S` | `GPU_NV_M` | `GPU_NV_L` | `GPU_NV_XS` | `GPU_NV_SM` | `GPU_NV_2M` | `GPU_NV_3M` | `GPU_NV_SL`.
        :param pulumi.Input[_builtins.int] max_nodes: Specifies the maximum number of nodes for the compute pool.
        :param pulumi.Input[_builtins.int] min_nodes: Specifies the minimum number of nodes for the compute pool.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a compute pool when a service or job is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend_secs: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Number of seconds of inactivity after which you want Snowflake to automatically suspend the compute pool.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the compute pool.
        :param pulumi.Input[_builtins.str] for_application: Specifies the Snowflake Native App name.
        :param pulumi.Input[_builtins.str] initially_suspended: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether the compute pool is created initially in the suspended state. This field is used only when creating a compute pool. Changes on this field are ignored after creation.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the compute pool; must be unique for the account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        pulumi.set(__self__, "instance_family", instance_family)
        pulumi.set(__self__, "max_nodes", max_nodes)
        pulumi.set(__self__, "min_nodes", min_nodes)
        if auto_resume is not None:
            pulumi.set(__self__, "auto_resume", auto_resume)
        if auto_suspend_secs is not None:
            pulumi.set(__self__, "auto_suspend_secs", auto_suspend_secs)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if for_application is not None:
            pulumi.set(__self__, "for_application", for_application)
        if initially_suspended is not None:
            pulumi.set(__self__, "initially_suspended", initially_suspended)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="instanceFamily")
    def instance_family(self) -> pulumi.Input[_builtins.str]:
        """
        Identifies the type of machine you want to provision for the nodes in the compute pool. Valid values are (case-insensitive): `CPU_X64_XS` | `CPU_X64_S` | `CPU_X64_M` | `CPU_X64_L` | `HIGHMEM_X64_S` | `HIGHMEM_X64_M` | `HIGHMEM_X64_L` | `HIGHMEM_X64_SL` | `GPU_NV_S` | `GPU_NV_M` | `GPU_NV_L` | `GPU_NV_XS` | `GPU_NV_SM` | `GPU_NV_2M` | `GPU_NV_3M` | `GPU_NV_SL`.
        """
        return pulumi.get(self, "instance_family")

    @instance_family.setter
    def instance_family(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_family", value)

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the maximum number of nodes for the compute pool.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_nodes", value)

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the minimum number of nodes for the compute pool.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "min_nodes", value)

    @_builtins.property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a compute pool when a service or job is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "auto_resume")

    @auto_resume.setter
    def auto_resume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_resume", value)

    @_builtins.property
    @pulumi.getter(name="autoSuspendSecs")
    def auto_suspend_secs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Number of seconds of inactivity after which you want Snowflake to automatically suspend the compute pool.
        """
        return pulumi.get(self, "auto_suspend_secs")

    @auto_suspend_secs.setter
    def auto_suspend_secs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_suspend_secs", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the compute pool.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="forApplication")
    def for_application(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Snowflake Native App name.
        """
        return pulumi.get(self, "for_application")

    @for_application.setter
    def for_application(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "for_application", value)

    @_builtins.property
    @pulumi.getter(name="initiallySuspended")
    def initially_suspended(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether the compute pool is created initially in the suspended state. This field is used only when creating a compute pool. Changes on this field are ignored after creation.
        """
        return pulumi.get(self, "initially_suspended")

    @initially_suspended.setter
    def initially_suspended(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "initially_suspended", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the compute pool; must be unique for the account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ComputePoolState:
    def __init__(__self__, *,
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ComputePoolDescribeOutputArgs']]]] = None,
                 for_application: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 initially_suspended: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_family: Optional[pulumi.Input[_builtins.str]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ComputePoolShowOutputArgs']]]] = None):
        """
        Input properties used for looking up and filtering ComputePool resources.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a compute pool when a service or job is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend_secs: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Number of seconds of inactivity after which you want Snowflake to automatically suspend the compute pool.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the compute pool.
        :param pulumi.Input[Sequence[pulumi.Input['ComputePoolDescribeOutputArgs']]] describe_outputs: Outputs the result of `DESCRIBE COMPUTE POOL` for the given compute pool.
        :param pulumi.Input[_builtins.str] for_application: Specifies the Snowflake Native App name.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] initially_suspended: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether the compute pool is created initially in the suspended state. This field is used only when creating a compute pool. Changes on this field are ignored after creation.
        :param pulumi.Input[_builtins.str] instance_family: Identifies the type of machine you want to provision for the nodes in the compute pool. Valid values are (case-insensitive): `CPU_X64_XS` | `CPU_X64_S` | `CPU_X64_M` | `CPU_X64_L` | `HIGHMEM_X64_S` | `HIGHMEM_X64_M` | `HIGHMEM_X64_L` | `HIGHMEM_X64_SL` | `GPU_NV_S` | `GPU_NV_M` | `GPU_NV_L` | `GPU_NV_XS` | `GPU_NV_SM` | `GPU_NV_2M` | `GPU_NV_3M` | `GPU_NV_SL`.
        :param pulumi.Input[_builtins.int] max_nodes: Specifies the maximum number of nodes for the compute pool.
        :param pulumi.Input[_builtins.int] min_nodes: Specifies the minimum number of nodes for the compute pool.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the compute pool; must be unique for the account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['ComputePoolShowOutputArgs']]] show_outputs: Outputs the result of `SHOW COMPUTE POOLS` for the given compute pool.
        """
        if auto_resume is not None:
            pulumi.set(__self__, "auto_resume", auto_resume)
        if auto_suspend_secs is not None:
            pulumi.set(__self__, "auto_suspend_secs", auto_suspend_secs)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if describe_outputs is not None:
            pulumi.set(__self__, "describe_outputs", describe_outputs)
        if for_application is not None:
            pulumi.set(__self__, "for_application", for_application)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if initially_suspended is not None:
            pulumi.set(__self__, "initially_suspended", initially_suspended)
        if instance_family is not None:
            pulumi.set(__self__, "instance_family", instance_family)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)

    @_builtins.property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a compute pool when a service or job is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "auto_resume")

    @auto_resume.setter
    def auto_resume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_resume", value)

    @_builtins.property
    @pulumi.getter(name="autoSuspendSecs")
    def auto_suspend_secs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Number of seconds of inactivity after which you want Snowflake to automatically suspend the compute pool.
        """
        return pulumi.get(self, "auto_suspend_secs")

    @auto_suspend_secs.setter
    def auto_suspend_secs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_suspend_secs", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the compute pool.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputePoolDescribeOutputArgs']]]]:
        """
        Outputs the result of `DESCRIBE COMPUTE POOL` for the given compute pool.
        """
        return pulumi.get(self, "describe_outputs")

    @describe_outputs.setter
    def describe_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputePoolDescribeOutputArgs']]]]):
        pulumi.set(self, "describe_outputs", value)

    @_builtins.property
    @pulumi.getter(name="forApplication")
    def for_application(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Snowflake Native App name.
        """
        return pulumi.get(self, "for_application")

    @for_application.setter
    def for_application(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "for_application", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter(name="initiallySuspended")
    def initially_suspended(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether the compute pool is created initially in the suspended state. This field is used only when creating a compute pool. Changes on this field are ignored after creation.
        """
        return pulumi.get(self, "initially_suspended")

    @initially_suspended.setter
    def initially_suspended(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "initially_suspended", value)

    @_builtins.property
    @pulumi.getter(name="instanceFamily")
    def instance_family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the type of machine you want to provision for the nodes in the compute pool. Valid values are (case-insensitive): `CPU_X64_XS` | `CPU_X64_S` | `CPU_X64_M` | `CPU_X64_L` | `HIGHMEM_X64_S` | `HIGHMEM_X64_M` | `HIGHMEM_X64_L` | `HIGHMEM_X64_SL` | `GPU_NV_S` | `GPU_NV_M` | `GPU_NV_L` | `GPU_NV_XS` | `GPU_NV_SM` | `GPU_NV_2M` | `GPU_NV_3M` | `GPU_NV_SL`.
        """
        return pulumi.get(self, "instance_family")

    @instance_family.setter
    def instance_family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_family", value)

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of nodes for the compute pool.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_nodes", value)

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of nodes for the compute pool.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_nodes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the compute pool; must be unique for the account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputePoolShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW COMPUTE POOLS` for the given compute pool.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputePoolShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)


@pulumi.type_token("snowflake:index/computePool:ComputePool")
class ComputePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 for_application: Optional[pulumi.Input[_builtins.str]] = None,
                 initially_suspended: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_family: Optional[pulumi.Input[_builtins.str]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/computePool:ComputePool example '"<compute_pool_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a compute pool when a service or job is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend_secs: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Number of seconds of inactivity after which you want Snowflake to automatically suspend the compute pool.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the compute pool.
        :param pulumi.Input[_builtins.str] for_application: Specifies the Snowflake Native App name.
        :param pulumi.Input[_builtins.str] initially_suspended: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether the compute pool is created initially in the suspended state. This field is used only when creating a compute pool. Changes on this field are ignored after creation.
        :param pulumi.Input[_builtins.str] instance_family: Identifies the type of machine you want to provision for the nodes in the compute pool. Valid values are (case-insensitive): `CPU_X64_XS` | `CPU_X64_S` | `CPU_X64_M` | `CPU_X64_L` | `HIGHMEM_X64_S` | `HIGHMEM_X64_M` | `HIGHMEM_X64_L` | `HIGHMEM_X64_SL` | `GPU_NV_S` | `GPU_NV_M` | `GPU_NV_L` | `GPU_NV_XS` | `GPU_NV_SM` | `GPU_NV_2M` | `GPU_NV_3M` | `GPU_NV_SL`.
        :param pulumi.Input[_builtins.int] max_nodes: Specifies the maximum number of nodes for the compute pool.
        :param pulumi.Input[_builtins.int] min_nodes: Specifies the minimum number of nodes for the compute pool.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the compute pool; must be unique for the account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/computePool:ComputePool example '"<compute_pool_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param ComputePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 for_application: Optional[pulumi.Input[_builtins.str]] = None,
                 initially_suspended: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_family: Optional[pulumi.Input[_builtins.str]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputePoolArgs.__new__(ComputePoolArgs)

            __props__.__dict__["auto_resume"] = auto_resume
            __props__.__dict__["auto_suspend_secs"] = auto_suspend_secs
            __props__.__dict__["comment"] = comment
            __props__.__dict__["for_application"] = for_application
            __props__.__dict__["initially_suspended"] = initially_suspended
            if instance_family is None and not opts.urn:
                raise TypeError("Missing required property 'instance_family'")
            __props__.__dict__["instance_family"] = instance_family
            if max_nodes is None and not opts.urn:
                raise TypeError("Missing required property 'max_nodes'")
            __props__.__dict__["max_nodes"] = max_nodes
            if min_nodes is None and not opts.urn:
                raise TypeError("Missing required property 'min_nodes'")
            __props__.__dict__["min_nodes"] = min_nodes
            __props__.__dict__["name"] = name
            __props__.__dict__["describe_outputs"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["show_outputs"] = None
        super(ComputePool, __self__).__init__(
            'snowflake:index/computePool:ComputePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
            auto_suspend_secs: Optional[pulumi.Input[_builtins.int]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputePoolDescribeOutputArgs', 'ComputePoolDescribeOutputArgsDict']]]]] = None,
            for_application: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            initially_suspended: Optional[pulumi.Input[_builtins.str]] = None,
            instance_family: Optional[pulumi.Input[_builtins.str]] = None,
            max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputePoolShowOutputArgs', 'ComputePoolShowOutputArgsDict']]]]] = None) -> 'ComputePool':
        """
        Get an existing ComputePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a compute pool when a service or job is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend_secs: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Number of seconds of inactivity after which you want Snowflake to automatically suspend the compute pool.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the compute pool.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputePoolDescribeOutputArgs', 'ComputePoolDescribeOutputArgsDict']]]] describe_outputs: Outputs the result of `DESCRIBE COMPUTE POOL` for the given compute pool.
        :param pulumi.Input[_builtins.str] for_application: Specifies the Snowflake Native App name.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] initially_suspended: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether the compute pool is created initially in the suspended state. This field is used only when creating a compute pool. Changes on this field are ignored after creation.
        :param pulumi.Input[_builtins.str] instance_family: Identifies the type of machine you want to provision for the nodes in the compute pool. Valid values are (case-insensitive): `CPU_X64_XS` | `CPU_X64_S` | `CPU_X64_M` | `CPU_X64_L` | `HIGHMEM_X64_S` | `HIGHMEM_X64_M` | `HIGHMEM_X64_L` | `HIGHMEM_X64_SL` | `GPU_NV_S` | `GPU_NV_M` | `GPU_NV_L` | `GPU_NV_XS` | `GPU_NV_SM` | `GPU_NV_2M` | `GPU_NV_3M` | `GPU_NV_SL`.
        :param pulumi.Input[_builtins.int] max_nodes: Specifies the maximum number of nodes for the compute pool.
        :param pulumi.Input[_builtins.int] min_nodes: Specifies the minimum number of nodes for the compute pool.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the compute pool; must be unique for the account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputePoolShowOutputArgs', 'ComputePoolShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW COMPUTE POOLS` for the given compute pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputePoolState.__new__(_ComputePoolState)

        __props__.__dict__["auto_resume"] = auto_resume
        __props__.__dict__["auto_suspend_secs"] = auto_suspend_secs
        __props__.__dict__["comment"] = comment
        __props__.__dict__["describe_outputs"] = describe_outputs
        __props__.__dict__["for_application"] = for_application
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["initially_suspended"] = initially_suspended
        __props__.__dict__["instance_family"] = instance_family
        __props__.__dict__["max_nodes"] = max_nodes
        __props__.__dict__["min_nodes"] = min_nodes
        __props__.__dict__["name"] = name
        __props__.__dict__["show_outputs"] = show_outputs
        return ComputePool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a compute pool when a service or job is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "auto_resume")

    @_builtins.property
    @pulumi.getter(name="autoSuspendSecs")
    def auto_suspend_secs(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Number of seconds of inactivity after which you want Snowflake to automatically suspend the compute pool.
        """
        return pulumi.get(self, "auto_suspend_secs")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the compute pool.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> pulumi.Output[Sequence['outputs.ComputePoolDescribeOutput']]:
        """
        Outputs the result of `DESCRIBE COMPUTE POOL` for the given compute pool.
        """
        return pulumi.get(self, "describe_outputs")

    @_builtins.property
    @pulumi.getter(name="forApplication")
    def for_application(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Snowflake Native App name.
        """
        return pulumi.get(self, "for_application")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter(name="initiallySuspended")
    def initially_suspended(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether the compute pool is created initially in the suspended state. This field is used only when creating a compute pool. Changes on this field are ignored after creation.
        """
        return pulumi.get(self, "initially_suspended")

    @_builtins.property
    @pulumi.getter(name="instanceFamily")
    def instance_family(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies the type of machine you want to provision for the nodes in the compute pool. Valid values are (case-insensitive): `CPU_X64_XS` | `CPU_X64_S` | `CPU_X64_M` | `CPU_X64_L` | `HIGHMEM_X64_S` | `HIGHMEM_X64_M` | `HIGHMEM_X64_L` | `HIGHMEM_X64_SL` | `GPU_NV_S` | `GPU_NV_M` | `GPU_NV_L` | `GPU_NV_XS` | `GPU_NV_SM` | `GPU_NV_2M` | `GPU_NV_3M` | `GPU_NV_SL`.
        """
        return pulumi.get(self, "instance_family")

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum number of nodes for the compute pool.
        """
        return pulumi.get(self, "max_nodes")

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the minimum number of nodes for the compute pool.
        """
        return pulumi.get(self, "min_nodes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the compute pool; must be unique for the account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.ComputePoolShowOutput']]:
        """
        Outputs the result of `SHOW COMPUTE POOLS` for the given compute pool.
        """
        return pulumi.get(self, "show_outputs")

