# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalFunctionArgs', 'ExternalFunction']

@pulumi.input_type
class ExternalFunctionArgs:
    def __init__(__self__, *,
                 api_integration: pulumi.Input[_builtins.str],
                 database: pulumi.Input[_builtins.str],
                 return_behavior: pulumi.Input[_builtins.str],
                 return_type: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 url_of_proxy_and_resource: pulumi.Input[_builtins.str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 context_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]] = None,
                 max_batch_rows: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_input_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 request_translator: Optional[pulumi.Input[_builtins.str]] = None,
                 response_translator: Optional[pulumi.Input[_builtins.str]] = None,
                 return_null_allowed: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ExternalFunction resource.
        :param pulumi.Input[_builtins.str] api_integration: The name of the API integration object that should be used to authenticate the call to the proxy service.
        :param pulumi.Input[_builtins.str] database: The database in which to create the external function.
        :param pulumi.Input[_builtins.str] return_behavior: Specifies the behavior of the function when returning results
        :param pulumi.Input[_builtins.str] return_type: Specifies the data type returned by the external function.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the external function.
        :param pulumi.Input[_builtins.str] url_of_proxy_and_resource: This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]] args: Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        :param pulumi.Input[_builtins.str] comment: (Default: `user-defined function`) A description of the external function.
        :param pulumi.Input[_builtins.str] compression: (Default: `AUTO`) If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] context_headers: Binds Snowflake context function results to HTTP headers.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]] headers: Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        :param pulumi.Input[_builtins.int] max_batch_rows: This specifies the maximum number of rows in each batch sent to the proxy service.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        :param pulumi.Input[_builtins.str] null_input_behavior: (Default: `CALLED ON NULL INPUT`) Specifies the behavior of the external function when called with null inputs.
        :param pulumi.Input[_builtins.str] request_translator: This specifies the name of the request translator function
        :param pulumi.Input[_builtins.str] response_translator: This specifies the name of the response translator function.
        :param pulumi.Input[_builtins.bool] return_null_allowed: (Default: `true`) Indicates whether the function can return NULL values (true) or must return only NON-NULL values (false).
        """
        pulumi.set(__self__, "api_integration", api_integration)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "return_behavior", return_behavior)
        pulumi.set(__self__, "return_type", return_type)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "url_of_proxy_and_resource", url_of_proxy_and_resource)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if context_headers is not None:
            pulumi.set(__self__, "context_headers", context_headers)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if max_batch_rows is not None:
            pulumi.set(__self__, "max_batch_rows", max_batch_rows)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if null_input_behavior is not None:
            pulumi.set(__self__, "null_input_behavior", null_input_behavior)
        if request_translator is not None:
            pulumi.set(__self__, "request_translator", request_translator)
        if response_translator is not None:
            pulumi.set(__self__, "response_translator", response_translator)
        if return_null_allowed is not None:
            pulumi.set(__self__, "return_null_allowed", return_null_allowed)

    @_builtins.property
    @pulumi.getter(name="apiIntegration")
    def api_integration(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the API integration object that should be used to authenticate the call to the proxy service.
        """
        return pulumi.get(self, "api_integration")

    @api_integration.setter
    def api_integration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_integration", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the external function.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="returnBehavior")
    def return_behavior(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the behavior of the function when returning results
        """
        return pulumi.get(self, "return_behavior")

    @return_behavior.setter
    def return_behavior(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "return_behavior", value)

    @_builtins.property
    @pulumi.getter(name="returnType")
    def return_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the data type returned by the external function.
        """
        return pulumi.get(self, "return_type")

    @return_type.setter
    def return_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "return_type", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the external function.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="urlOfProxyAndResource")
    def url_of_proxy_and_resource(self) -> pulumi.Input[_builtins.str]:
        """
        This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        return pulumi.get(self, "url_of_proxy_and_resource")

    @url_of_proxy_and_resource.setter
    def url_of_proxy_and_resource(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url_of_proxy_and_resource", value)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]]:
        """
        Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]]):
        pulumi.set(self, "args", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `user-defined function`) A description of the external function.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `AUTO`) If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression", value)

    @_builtins.property
    @pulumi.getter(name="contextHeaders")
    def context_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Binds Snowflake context function results to HTTP headers.
        """
        return pulumi.get(self, "context_headers")

    @context_headers.setter
    def context_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "context_headers", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]]:
        """
        Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter(name="maxBatchRows")
    def max_batch_rows(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This specifies the maximum number of rows in each batch sent to the proxy service.
        """
        return pulumi.get(self, "max_batch_rows")

    @max_batch_rows.setter
    def max_batch_rows(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_batch_rows", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nullInputBehavior")
    def null_input_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `CALLED ON NULL INPUT`) Specifies the behavior of the external function when called with null inputs.
        """
        return pulumi.get(self, "null_input_behavior")

    @null_input_behavior.setter
    def null_input_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "null_input_behavior", value)

    @_builtins.property
    @pulumi.getter(name="requestTranslator")
    def request_translator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This specifies the name of the request translator function
        """
        return pulumi.get(self, "request_translator")

    @request_translator.setter
    def request_translator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_translator", value)

    @_builtins.property
    @pulumi.getter(name="responseTranslator")
    def response_translator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This specifies the name of the response translator function.
        """
        return pulumi.get(self, "response_translator")

    @response_translator.setter
    def response_translator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_translator", value)

    @_builtins.property
    @pulumi.getter(name="returnNullAllowed")
    def return_null_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `true`) Indicates whether the function can return NULL values (true) or must return only NON-NULL values (false).
        """
        return pulumi.get(self, "return_null_allowed")

    @return_null_allowed.setter
    def return_null_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "return_null_allowed", value)


@pulumi.input_type
class _ExternalFunctionState:
    def __init__(__self__, *,
                 api_integration: Optional[pulumi.Input[_builtins.str]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 context_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]] = None,
                 max_batch_rows: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_input_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 request_translator: Optional[pulumi.Input[_builtins.str]] = None,
                 response_translator: Optional[pulumi.Input[_builtins.str]] = None,
                 return_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 return_null_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 return_type: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 url_of_proxy_and_resource: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExternalFunction resources.
        :param pulumi.Input[_builtins.str] api_integration: The name of the API integration object that should be used to authenticate the call to the proxy service.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]] args: Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        :param pulumi.Input[_builtins.str] comment: (Default: `user-defined function`) A description of the external function.
        :param pulumi.Input[_builtins.str] compression: (Default: `AUTO`) If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] context_headers: Binds Snowflake context function results to HTTP headers.
        :param pulumi.Input[_builtins.str] created_on: Date and time when the external function was created.
        :param pulumi.Input[_builtins.str] database: The database in which to create the external function.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]] headers: Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        :param pulumi.Input[_builtins.int] max_batch_rows: This specifies the maximum number of rows in each batch sent to the proxy service.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        :param pulumi.Input[_builtins.str] null_input_behavior: (Default: `CALLED ON NULL INPUT`) Specifies the behavior of the external function when called with null inputs.
        :param pulumi.Input[_builtins.str] request_translator: This specifies the name of the request translator function
        :param pulumi.Input[_builtins.str] response_translator: This specifies the name of the response translator function.
        :param pulumi.Input[_builtins.str] return_behavior: Specifies the behavior of the function when returning results
        :param pulumi.Input[_builtins.bool] return_null_allowed: (Default: `true`) Indicates whether the function can return NULL values (true) or must return only NON-NULL values (false).
        :param pulumi.Input[_builtins.str] return_type: Specifies the data type returned by the external function.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the external function.
        :param pulumi.Input[_builtins.str] url_of_proxy_and_resource: This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        if api_integration is not None:
            pulumi.set(__self__, "api_integration", api_integration)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if context_headers is not None:
            pulumi.set(__self__, "context_headers", context_headers)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if max_batch_rows is not None:
            pulumi.set(__self__, "max_batch_rows", max_batch_rows)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if null_input_behavior is not None:
            pulumi.set(__self__, "null_input_behavior", null_input_behavior)
        if request_translator is not None:
            pulumi.set(__self__, "request_translator", request_translator)
        if response_translator is not None:
            pulumi.set(__self__, "response_translator", response_translator)
        if return_behavior is not None:
            pulumi.set(__self__, "return_behavior", return_behavior)
        if return_null_allowed is not None:
            pulumi.set(__self__, "return_null_allowed", return_null_allowed)
        if return_type is not None:
            pulumi.set(__self__, "return_type", return_type)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if url_of_proxy_and_resource is not None:
            pulumi.set(__self__, "url_of_proxy_and_resource", url_of_proxy_and_resource)

    @_builtins.property
    @pulumi.getter(name="apiIntegration")
    def api_integration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API integration object that should be used to authenticate the call to the proxy service.
        """
        return pulumi.get(self, "api_integration")

    @api_integration.setter
    def api_integration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_integration", value)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]]:
        """
        Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]]):
        pulumi.set(self, "args", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `user-defined function`) A description of the external function.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `AUTO`) If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression", value)

    @_builtins.property
    @pulumi.getter(name="contextHeaders")
    def context_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Binds Snowflake context function results to HTTP headers.
        """
        return pulumi.get(self, "context_headers")

    @context_headers.setter
    def context_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "context_headers", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time when the external function was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the external function.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]]:
        """
        Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter(name="maxBatchRows")
    def max_batch_rows(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This specifies the maximum number of rows in each batch sent to the proxy service.
        """
        return pulumi.get(self, "max_batch_rows")

    @max_batch_rows.setter
    def max_batch_rows(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_batch_rows", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nullInputBehavior")
    def null_input_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `CALLED ON NULL INPUT`) Specifies the behavior of the external function when called with null inputs.
        """
        return pulumi.get(self, "null_input_behavior")

    @null_input_behavior.setter
    def null_input_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "null_input_behavior", value)

    @_builtins.property
    @pulumi.getter(name="requestTranslator")
    def request_translator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This specifies the name of the request translator function
        """
        return pulumi.get(self, "request_translator")

    @request_translator.setter
    def request_translator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_translator", value)

    @_builtins.property
    @pulumi.getter(name="responseTranslator")
    def response_translator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This specifies the name of the response translator function.
        """
        return pulumi.get(self, "response_translator")

    @response_translator.setter
    def response_translator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_translator", value)

    @_builtins.property
    @pulumi.getter(name="returnBehavior")
    def return_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the behavior of the function when returning results
        """
        return pulumi.get(self, "return_behavior")

    @return_behavior.setter
    def return_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "return_behavior", value)

    @_builtins.property
    @pulumi.getter(name="returnNullAllowed")
    def return_null_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `true`) Indicates whether the function can return NULL values (true) or must return only NON-NULL values (false).
        """
        return pulumi.get(self, "return_null_allowed")

    @return_null_allowed.setter
    def return_null_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "return_null_allowed", value)

    @_builtins.property
    @pulumi.getter(name="returnType")
    def return_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the data type returned by the external function.
        """
        return pulumi.get(self, "return_type")

    @return_type.setter
    def return_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "return_type", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the external function.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="urlOfProxyAndResource")
    def url_of_proxy_and_resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        return pulumi.get(self, "url_of_proxy_and_resource")

    @url_of_proxy_and_resource.setter
    def url_of_proxy_and_resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_of_proxy_and_resource", value)


@pulumi.type_token("snowflake:index/externalFunction:ExternalFunction")
class ExternalFunction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_integration: Optional[pulumi.Input[_builtins.str]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalFunctionArgArgs', 'ExternalFunctionArgArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 context_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalFunctionHeaderArgs', 'ExternalFunctionHeaderArgsDict']]]]] = None,
                 max_batch_rows: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_input_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 request_translator: Optional[pulumi.Input[_builtins.str]] = None,
                 response_translator: Optional[pulumi.Input[_builtins.str]] = None,
                 return_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 return_null_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 return_type: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 url_of_proxy_and_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        format is <database_name>.<schema_name>.<external_function_name>(<arg types, separated with ','>)

        ```sh
        $ pulumi import snowflake:index/externalFunction:ExternalFunction example 'dbName.schemaName.externalFunctionName(varchar, varchar, varchar)'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_integration: The name of the API integration object that should be used to authenticate the call to the proxy service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalFunctionArgArgs', 'ExternalFunctionArgArgsDict']]]] args: Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        :param pulumi.Input[_builtins.str] comment: (Default: `user-defined function`) A description of the external function.
        :param pulumi.Input[_builtins.str] compression: (Default: `AUTO`) If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] context_headers: Binds Snowflake context function results to HTTP headers.
        :param pulumi.Input[_builtins.str] database: The database in which to create the external function.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalFunctionHeaderArgs', 'ExternalFunctionHeaderArgsDict']]]] headers: Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        :param pulumi.Input[_builtins.int] max_batch_rows: This specifies the maximum number of rows in each batch sent to the proxy service.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        :param pulumi.Input[_builtins.str] null_input_behavior: (Default: `CALLED ON NULL INPUT`) Specifies the behavior of the external function when called with null inputs.
        :param pulumi.Input[_builtins.str] request_translator: This specifies the name of the request translator function
        :param pulumi.Input[_builtins.str] response_translator: This specifies the name of the response translator function.
        :param pulumi.Input[_builtins.str] return_behavior: Specifies the behavior of the function when returning results
        :param pulumi.Input[_builtins.bool] return_null_allowed: (Default: `true`) Indicates whether the function can return NULL values (true) or must return only NON-NULL values (false).
        :param pulumi.Input[_builtins.str] return_type: Specifies the data type returned by the external function.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the external function.
        :param pulumi.Input[_builtins.str] url_of_proxy_and_resource: This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalFunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        format is <database_name>.<schema_name>.<external_function_name>(<arg types, separated with ','>)

        ```sh
        $ pulumi import snowflake:index/externalFunction:ExternalFunction example 'dbName.schemaName.externalFunctionName(varchar, varchar, varchar)'
        ```

        :param str resource_name: The name of the resource.
        :param ExternalFunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalFunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_integration: Optional[pulumi.Input[_builtins.str]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalFunctionArgArgs', 'ExternalFunctionArgArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 context_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalFunctionHeaderArgs', 'ExternalFunctionHeaderArgsDict']]]]] = None,
                 max_batch_rows: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_input_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 request_translator: Optional[pulumi.Input[_builtins.str]] = None,
                 response_translator: Optional[pulumi.Input[_builtins.str]] = None,
                 return_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 return_null_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 return_type: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 url_of_proxy_and_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalFunctionArgs.__new__(ExternalFunctionArgs)

            if api_integration is None and not opts.urn:
                raise TypeError("Missing required property 'api_integration'")
            __props__.__dict__["api_integration"] = api_integration
            __props__.__dict__["args"] = args
            __props__.__dict__["comment"] = comment
            __props__.__dict__["compression"] = compression
            __props__.__dict__["context_headers"] = context_headers
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["headers"] = headers
            __props__.__dict__["max_batch_rows"] = max_batch_rows
            __props__.__dict__["name"] = name
            __props__.__dict__["null_input_behavior"] = null_input_behavior
            __props__.__dict__["request_translator"] = request_translator
            __props__.__dict__["response_translator"] = response_translator
            if return_behavior is None and not opts.urn:
                raise TypeError("Missing required property 'return_behavior'")
            __props__.__dict__["return_behavior"] = return_behavior
            __props__.__dict__["return_null_allowed"] = return_null_allowed
            if return_type is None and not opts.urn:
                raise TypeError("Missing required property 'return_type'")
            __props__.__dict__["return_type"] = return_type
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            if url_of_proxy_and_resource is None and not opts.urn:
                raise TypeError("Missing required property 'url_of_proxy_and_resource'")
            __props__.__dict__["url_of_proxy_and_resource"] = url_of_proxy_and_resource
            __props__.__dict__["created_on"] = None
            __props__.__dict__["fully_qualified_name"] = None
        super(ExternalFunction, __self__).__init__(
            'snowflake:index/externalFunction:ExternalFunction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_integration: Optional[pulumi.Input[_builtins.str]] = None,
            args: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalFunctionArgArgs', 'ExternalFunctionArgArgsDict']]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            compression: Optional[pulumi.Input[_builtins.str]] = None,
            context_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalFunctionHeaderArgs', 'ExternalFunctionHeaderArgsDict']]]]] = None,
            max_batch_rows: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            null_input_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            request_translator: Optional[pulumi.Input[_builtins.str]] = None,
            response_translator: Optional[pulumi.Input[_builtins.str]] = None,
            return_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            return_null_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
            return_type: Optional[pulumi.Input[_builtins.str]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            url_of_proxy_and_resource: Optional[pulumi.Input[_builtins.str]] = None) -> 'ExternalFunction':
        """
        Get an existing ExternalFunction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_integration: The name of the API integration object that should be used to authenticate the call to the proxy service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalFunctionArgArgs', 'ExternalFunctionArgArgsDict']]]] args: Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        :param pulumi.Input[_builtins.str] comment: (Default: `user-defined function`) A description of the external function.
        :param pulumi.Input[_builtins.str] compression: (Default: `AUTO`) If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] context_headers: Binds Snowflake context function results to HTTP headers.
        :param pulumi.Input[_builtins.str] created_on: Date and time when the external function was created.
        :param pulumi.Input[_builtins.str] database: The database in which to create the external function.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalFunctionHeaderArgs', 'ExternalFunctionHeaderArgsDict']]]] headers: Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        :param pulumi.Input[_builtins.int] max_batch_rows: This specifies the maximum number of rows in each batch sent to the proxy service.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        :param pulumi.Input[_builtins.str] null_input_behavior: (Default: `CALLED ON NULL INPUT`) Specifies the behavior of the external function when called with null inputs.
        :param pulumi.Input[_builtins.str] request_translator: This specifies the name of the request translator function
        :param pulumi.Input[_builtins.str] response_translator: This specifies the name of the response translator function.
        :param pulumi.Input[_builtins.str] return_behavior: Specifies the behavior of the function when returning results
        :param pulumi.Input[_builtins.bool] return_null_allowed: (Default: `true`) Indicates whether the function can return NULL values (true) or must return only NON-NULL values (false).
        :param pulumi.Input[_builtins.str] return_type: Specifies the data type returned by the external function.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the external function.
        :param pulumi.Input[_builtins.str] url_of_proxy_and_resource: This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalFunctionState.__new__(_ExternalFunctionState)

        __props__.__dict__["api_integration"] = api_integration
        __props__.__dict__["args"] = args
        __props__.__dict__["comment"] = comment
        __props__.__dict__["compression"] = compression
        __props__.__dict__["context_headers"] = context_headers
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["database"] = database
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["headers"] = headers
        __props__.__dict__["max_batch_rows"] = max_batch_rows
        __props__.__dict__["name"] = name
        __props__.__dict__["null_input_behavior"] = null_input_behavior
        __props__.__dict__["request_translator"] = request_translator
        __props__.__dict__["response_translator"] = response_translator
        __props__.__dict__["return_behavior"] = return_behavior
        __props__.__dict__["return_null_allowed"] = return_null_allowed
        __props__.__dict__["return_type"] = return_type
        __props__.__dict__["schema"] = schema
        __props__.__dict__["url_of_proxy_and_resource"] = url_of_proxy_and_resource
        return ExternalFunction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiIntegration")
    def api_integration(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API integration object that should be used to authenticate the call to the proxy service.
        """
        return pulumi.get(self, "api_integration")

    @_builtins.property
    @pulumi.getter
    def args(self) -> pulumi.Output[Optional[Sequence['outputs.ExternalFunctionArg']]]:
        """
        Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: `user-defined function`) A description of the external function.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def compression(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: `AUTO`) If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        """
        return pulumi.get(self, "compression")

    @_builtins.property
    @pulumi.getter(name="contextHeaders")
    def context_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Binds Snowflake context function results to HTTP headers.
        """
        return pulumi.get(self, "context_headers")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time when the external function was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the external function.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[Sequence['outputs.ExternalFunctionHeader']]]:
        """
        Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter(name="maxBatchRows")
    def max_batch_rows(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        This specifies the maximum number of rows in each batch sent to the proxy service.
        """
        return pulumi.get(self, "max_batch_rows")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nullInputBehavior")
    def null_input_behavior(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: `CALLED ON NULL INPUT`) Specifies the behavior of the external function when called with null inputs.
        """
        return pulumi.get(self, "null_input_behavior")

    @_builtins.property
    @pulumi.getter(name="requestTranslator")
    def request_translator(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This specifies the name of the request translator function
        """
        return pulumi.get(self, "request_translator")

    @_builtins.property
    @pulumi.getter(name="responseTranslator")
    def response_translator(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This specifies the name of the response translator function.
        """
        return pulumi.get(self, "response_translator")

    @_builtins.property
    @pulumi.getter(name="returnBehavior")
    def return_behavior(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the behavior of the function when returning results
        """
        return pulumi.get(self, "return_behavior")

    @_builtins.property
    @pulumi.getter(name="returnNullAllowed")
    def return_null_allowed(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Default: `true`) Indicates whether the function can return NULL values (true) or must return only NON-NULL values (false).
        """
        return pulumi.get(self, "return_null_allowed")

    @_builtins.property
    @pulumi.getter(name="returnType")
    def return_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the data type returned by the external function.
        """
        return pulumi.get(self, "return_type")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the external function.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="urlOfProxyAndResource")
    def url_of_proxy_and_resource(self) -> pulumi.Output[_builtins.str]:
        """
        This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        return pulumi.get(self, "url_of_proxy_and_resource")

