# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalOauthIntegrationArgs', 'ExternalOauthIntegration']

@pulumi.input_type
class ExternalOauthIntegrationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 external_oauth_issuer: pulumi.Input[_builtins.str],
                 external_oauth_snowflake_user_mapping_attribute: pulumi.Input[_builtins.str],
                 external_oauth_token_user_mapping_claims: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 external_oauth_type: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_allowed_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_any_role_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_audience_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_blocked_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_jws_keys_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_rsa_public_key2: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_scope_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_scope_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ExternalOauthIntegration resource.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether to initiate operation of the integration or suspend it.
        :param pulumi.Input[_builtins.str] external_oauth_issuer: Specifies the URL to define the OAuth 2.0 authorization server.
        :param pulumi.Input[_builtins.str] external_oauth_snowflake_user_mapping_attribute: Indicates which Snowflake user record attribute should be used to map the access token to a Snowflake user record. Valid values are (case-insensitive): `LOGIN_NAME` | `EMAIL_ADDRESS`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_token_user_mapping_claims: Specifies the access token claim or claims that can be used to map the access token to a Snowflake user record. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_type: Specifies the OAuth 2.0 authorization server to be Okta, Microsoft Azure AD, Ping Identity PingFederate, or a Custom OAuth 2.0 authorization server. Valid values are (case-insensitive): `OKTA` | `AZURE` | `PING_FEDERATE` | `CUSTOM`.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the OAuth integration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_allowed_roles_lists: Specifies the list of roles that the client can set as the primary role. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] external_oauth_any_role_mode: Specifies whether the OAuth client or user can use a role that is not defined in the OAuth access token. Valid values are (case-insensitive): `DISABLE` | `ENABLE` | `ENABLE_FOR_PRIVILEGE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_audience_lists: Specifies additional values that can be used for the access token's audience validation on top of using the Customer's Snowflake Account URL
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_blocked_roles_lists: Specifies the list of roles that a client cannot set as the primary role. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the EXTERNAL*OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_jws_keys_urls: Specifies the endpoint or a list of endpoints from which to download public keys or certificates to validate an External OAuth access token. The maximum number of URLs that can be specified in the list is 3. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_rsa_public_key: Specifies a Base64-encoded RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_rsa_public_key2: Specifies a second RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. Used for key rotation. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_scope_delimiter: Specifies the scope delimiter in the authorization token.
        :param pulumi.Input[_builtins.str] external_oauth_scope_mapping_attribute: Specifies the access token claim to map the access token to an account role. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the External Oath integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "external_oauth_issuer", external_oauth_issuer)
        pulumi.set(__self__, "external_oauth_snowflake_user_mapping_attribute", external_oauth_snowflake_user_mapping_attribute)
        pulumi.set(__self__, "external_oauth_token_user_mapping_claims", external_oauth_token_user_mapping_claims)
        pulumi.set(__self__, "external_oauth_type", external_oauth_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if external_oauth_allowed_roles_lists is not None:
            pulumi.set(__self__, "external_oauth_allowed_roles_lists", external_oauth_allowed_roles_lists)
        if external_oauth_any_role_mode is not None:
            pulumi.set(__self__, "external_oauth_any_role_mode", external_oauth_any_role_mode)
        if external_oauth_audience_lists is not None:
            pulumi.set(__self__, "external_oauth_audience_lists", external_oauth_audience_lists)
        if external_oauth_blocked_roles_lists is not None:
            pulumi.set(__self__, "external_oauth_blocked_roles_lists", external_oauth_blocked_roles_lists)
        if external_oauth_jws_keys_urls is not None:
            pulumi.set(__self__, "external_oauth_jws_keys_urls", external_oauth_jws_keys_urls)
        if external_oauth_rsa_public_key is not None:
            pulumi.set(__self__, "external_oauth_rsa_public_key", external_oauth_rsa_public_key)
        if external_oauth_rsa_public_key2 is not None:
            pulumi.set(__self__, "external_oauth_rsa_public_key2", external_oauth_rsa_public_key2)
        if external_oauth_scope_delimiter is not None:
            pulumi.set(__self__, "external_oauth_scope_delimiter", external_oauth_scope_delimiter)
        if external_oauth_scope_mapping_attribute is not None:
            pulumi.set(__self__, "external_oauth_scope_mapping_attribute", external_oauth_scope_mapping_attribute)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether to initiate operation of the integration or suspend it.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthIssuer")
    def external_oauth_issuer(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the URL to define the OAuth 2.0 authorization server.
        """
        return pulumi.get(self, "external_oauth_issuer")

    @external_oauth_issuer.setter
    def external_oauth_issuer(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_oauth_issuer", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthSnowflakeUserMappingAttribute")
    def external_oauth_snowflake_user_mapping_attribute(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates which Snowflake user record attribute should be used to map the access token to a Snowflake user record. Valid values are (case-insensitive): `LOGIN_NAME` | `EMAIL_ADDRESS`.
        """
        return pulumi.get(self, "external_oauth_snowflake_user_mapping_attribute")

    @external_oauth_snowflake_user_mapping_attribute.setter
    def external_oauth_snowflake_user_mapping_attribute(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_oauth_snowflake_user_mapping_attribute", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthTokenUserMappingClaims")
    def external_oauth_token_user_mapping_claims(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the access token claim or claims that can be used to map the access token to a Snowflake user record. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_token_user_mapping_claims")

    @external_oauth_token_user_mapping_claims.setter
    def external_oauth_token_user_mapping_claims(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "external_oauth_token_user_mapping_claims", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthType")
    def external_oauth_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the OAuth 2.0 authorization server to be Okta, Microsoft Azure AD, Ping Identity PingFederate, or a Custom OAuth 2.0 authorization server. Valid values are (case-insensitive): `OKTA` | `AZURE` | `PING_FEDERATE` | `CUSTOM`.
        """
        return pulumi.get(self, "external_oauth_type")

    @external_oauth_type.setter
    def external_oauth_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_oauth_type", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the OAuth integration.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthAllowedRolesLists")
    def external_oauth_allowed_roles_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of roles that the client can set as the primary role. For more information about this resource, see docs.
        """
        return pulumi.get(self, "external_oauth_allowed_roles_lists")

    @external_oauth_allowed_roles_lists.setter
    def external_oauth_allowed_roles_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_oauth_allowed_roles_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthAnyRoleMode")
    def external_oauth_any_role_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the OAuth client or user can use a role that is not defined in the OAuth access token. Valid values are (case-insensitive): `DISABLE` | `ENABLE` | `ENABLE_FOR_PRIVILEGE`.
        """
        return pulumi.get(self, "external_oauth_any_role_mode")

    @external_oauth_any_role_mode.setter
    def external_oauth_any_role_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_any_role_mode", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthAudienceLists")
    def external_oauth_audience_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies additional values that can be used for the access token's audience validation on top of using the Customer's Snowflake Account URL
        """
        return pulumi.get(self, "external_oauth_audience_lists")

    @external_oauth_audience_lists.setter
    def external_oauth_audience_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_oauth_audience_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthBlockedRolesLists")
    def external_oauth_blocked_roles_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of roles that a client cannot set as the primary role. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the EXTERNAL*OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        """
        return pulumi.get(self, "external_oauth_blocked_roles_lists")

    @external_oauth_blocked_roles_lists.setter
    def external_oauth_blocked_roles_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_oauth_blocked_roles_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthJwsKeysUrls")
    def external_oauth_jws_keys_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the endpoint or a list of endpoints from which to download public keys or certificates to validate an External OAuth access token. The maximum number of URLs that can be specified in the list is 3. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_jws_keys_urls")

    @external_oauth_jws_keys_urls.setter
    def external_oauth_jws_keys_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_oauth_jws_keys_urls", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthRsaPublicKey")
    def external_oauth_rsa_public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a Base64-encoded RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_rsa_public_key")

    @external_oauth_rsa_public_key.setter
    def external_oauth_rsa_public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_rsa_public_key", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthRsaPublicKey2")
    def external_oauth_rsa_public_key2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a second RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. Used for key rotation. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_rsa_public_key2")

    @external_oauth_rsa_public_key2.setter
    def external_oauth_rsa_public_key2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_rsa_public_key2", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthScopeDelimiter")
    def external_oauth_scope_delimiter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scope delimiter in the authorization token.
        """
        return pulumi.get(self, "external_oauth_scope_delimiter")

    @external_oauth_scope_delimiter.setter
    def external_oauth_scope_delimiter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_scope_delimiter", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthScopeMappingAttribute")
    def external_oauth_scope_mapping_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the access token claim to map the access token to an account role. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_scope_mapping_attribute")

    @external_oauth_scope_mapping_attribute.setter
    def external_oauth_scope_mapping_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_scope_mapping_attribute", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the External Oath integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ExternalOauthIntegrationState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationDescribeOutputArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_oauth_allowed_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_any_role_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_audience_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_blocked_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_jws_keys_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_rsa_public_key2: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_scope_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_scope_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_snowflake_user_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_token_user_mapping_claims: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 related_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationRelatedParameterArgs']]]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationShowOutputArgs']]]] = None):
        """
        Input properties used for looking up and filtering ExternalOauthIntegration resources.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the OAuth integration.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationDescribeOutputArgs']]] describe_outputs: Outputs the result of `DESCRIBE SECURITY INTEGRATIONS` for the given security integration.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether to initiate operation of the integration or suspend it.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_allowed_roles_lists: Specifies the list of roles that the client can set as the primary role. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] external_oauth_any_role_mode: Specifies whether the OAuth client or user can use a role that is not defined in the OAuth access token. Valid values are (case-insensitive): `DISABLE` | `ENABLE` | `ENABLE_FOR_PRIVILEGE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_audience_lists: Specifies additional values that can be used for the access token's audience validation on top of using the Customer's Snowflake Account URL
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_blocked_roles_lists: Specifies the list of roles that a client cannot set as the primary role. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the EXTERNAL*OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] external_oauth_issuer: Specifies the URL to define the OAuth 2.0 authorization server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_jws_keys_urls: Specifies the endpoint or a list of endpoints from which to download public keys or certificates to validate an External OAuth access token. The maximum number of URLs that can be specified in the list is 3. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_rsa_public_key: Specifies a Base64-encoded RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_rsa_public_key2: Specifies a second RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. Used for key rotation. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_scope_delimiter: Specifies the scope delimiter in the authorization token.
        :param pulumi.Input[_builtins.str] external_oauth_scope_mapping_attribute: Specifies the access token claim to map the access token to an account role. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_snowflake_user_mapping_attribute: Indicates which Snowflake user record attribute should be used to map the access token to a Snowflake user record. Valid values are (case-insensitive): `LOGIN_NAME` | `EMAIL_ADDRESS`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_token_user_mapping_claims: Specifies the access token claim or claims that can be used to map the access token to a Snowflake user record. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_type: Specifies the OAuth 2.0 authorization server to be Okta, Microsoft Azure AD, Ping Identity PingFederate, or a Custom OAuth 2.0 authorization server. Valid values are (case-insensitive): `OKTA` | `AZURE` | `PING_FEDERATE` | `CUSTOM`.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the External Oath integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationRelatedParameterArgs']]] related_parameters: Parameters related to this security integration.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationShowOutputArgs']]] show_outputs: Outputs the result of `SHOW SECURITY INTEGRATIONS` for the given security integration.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if describe_outputs is not None:
            pulumi.set(__self__, "describe_outputs", describe_outputs)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if external_oauth_allowed_roles_lists is not None:
            pulumi.set(__self__, "external_oauth_allowed_roles_lists", external_oauth_allowed_roles_lists)
        if external_oauth_any_role_mode is not None:
            pulumi.set(__self__, "external_oauth_any_role_mode", external_oauth_any_role_mode)
        if external_oauth_audience_lists is not None:
            pulumi.set(__self__, "external_oauth_audience_lists", external_oauth_audience_lists)
        if external_oauth_blocked_roles_lists is not None:
            pulumi.set(__self__, "external_oauth_blocked_roles_lists", external_oauth_blocked_roles_lists)
        if external_oauth_issuer is not None:
            pulumi.set(__self__, "external_oauth_issuer", external_oauth_issuer)
        if external_oauth_jws_keys_urls is not None:
            pulumi.set(__self__, "external_oauth_jws_keys_urls", external_oauth_jws_keys_urls)
        if external_oauth_rsa_public_key is not None:
            pulumi.set(__self__, "external_oauth_rsa_public_key", external_oauth_rsa_public_key)
        if external_oauth_rsa_public_key2 is not None:
            pulumi.set(__self__, "external_oauth_rsa_public_key2", external_oauth_rsa_public_key2)
        if external_oauth_scope_delimiter is not None:
            pulumi.set(__self__, "external_oauth_scope_delimiter", external_oauth_scope_delimiter)
        if external_oauth_scope_mapping_attribute is not None:
            pulumi.set(__self__, "external_oauth_scope_mapping_attribute", external_oauth_scope_mapping_attribute)
        if external_oauth_snowflake_user_mapping_attribute is not None:
            pulumi.set(__self__, "external_oauth_snowflake_user_mapping_attribute", external_oauth_snowflake_user_mapping_attribute)
        if external_oauth_token_user_mapping_claims is not None:
            pulumi.set(__self__, "external_oauth_token_user_mapping_claims", external_oauth_token_user_mapping_claims)
        if external_oauth_type is not None:
            pulumi.set(__self__, "external_oauth_type", external_oauth_type)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if related_parameters is not None:
            pulumi.set(__self__, "related_parameters", related_parameters)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the OAuth integration.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationDescribeOutputArgs']]]]:
        """
        Outputs the result of `DESCRIBE SECURITY INTEGRATIONS` for the given security integration.
        """
        return pulumi.get(self, "describe_outputs")

    @describe_outputs.setter
    def describe_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationDescribeOutputArgs']]]]):
        pulumi.set(self, "describe_outputs", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to initiate operation of the integration or suspend it.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthAllowedRolesLists")
    def external_oauth_allowed_roles_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of roles that the client can set as the primary role. For more information about this resource, see docs.
        """
        return pulumi.get(self, "external_oauth_allowed_roles_lists")

    @external_oauth_allowed_roles_lists.setter
    def external_oauth_allowed_roles_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_oauth_allowed_roles_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthAnyRoleMode")
    def external_oauth_any_role_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the OAuth client or user can use a role that is not defined in the OAuth access token. Valid values are (case-insensitive): `DISABLE` | `ENABLE` | `ENABLE_FOR_PRIVILEGE`.
        """
        return pulumi.get(self, "external_oauth_any_role_mode")

    @external_oauth_any_role_mode.setter
    def external_oauth_any_role_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_any_role_mode", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthAudienceLists")
    def external_oauth_audience_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies additional values that can be used for the access token's audience validation on top of using the Customer's Snowflake Account URL
        """
        return pulumi.get(self, "external_oauth_audience_lists")

    @external_oauth_audience_lists.setter
    def external_oauth_audience_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_oauth_audience_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthBlockedRolesLists")
    def external_oauth_blocked_roles_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of roles that a client cannot set as the primary role. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the EXTERNAL*OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        """
        return pulumi.get(self, "external_oauth_blocked_roles_lists")

    @external_oauth_blocked_roles_lists.setter
    def external_oauth_blocked_roles_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_oauth_blocked_roles_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthIssuer")
    def external_oauth_issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the URL to define the OAuth 2.0 authorization server.
        """
        return pulumi.get(self, "external_oauth_issuer")

    @external_oauth_issuer.setter
    def external_oauth_issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_issuer", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthJwsKeysUrls")
    def external_oauth_jws_keys_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the endpoint or a list of endpoints from which to download public keys or certificates to validate an External OAuth access token. The maximum number of URLs that can be specified in the list is 3. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_jws_keys_urls")

    @external_oauth_jws_keys_urls.setter
    def external_oauth_jws_keys_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_oauth_jws_keys_urls", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthRsaPublicKey")
    def external_oauth_rsa_public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a Base64-encoded RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_rsa_public_key")

    @external_oauth_rsa_public_key.setter
    def external_oauth_rsa_public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_rsa_public_key", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthRsaPublicKey2")
    def external_oauth_rsa_public_key2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a second RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. Used for key rotation. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_rsa_public_key2")

    @external_oauth_rsa_public_key2.setter
    def external_oauth_rsa_public_key2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_rsa_public_key2", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthScopeDelimiter")
    def external_oauth_scope_delimiter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scope delimiter in the authorization token.
        """
        return pulumi.get(self, "external_oauth_scope_delimiter")

    @external_oauth_scope_delimiter.setter
    def external_oauth_scope_delimiter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_scope_delimiter", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthScopeMappingAttribute")
    def external_oauth_scope_mapping_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the access token claim to map the access token to an account role. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_scope_mapping_attribute")

    @external_oauth_scope_mapping_attribute.setter
    def external_oauth_scope_mapping_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_scope_mapping_attribute", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthSnowflakeUserMappingAttribute")
    def external_oauth_snowflake_user_mapping_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates which Snowflake user record attribute should be used to map the access token to a Snowflake user record. Valid values are (case-insensitive): `LOGIN_NAME` | `EMAIL_ADDRESS`.
        """
        return pulumi.get(self, "external_oauth_snowflake_user_mapping_attribute")

    @external_oauth_snowflake_user_mapping_attribute.setter
    def external_oauth_snowflake_user_mapping_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_snowflake_user_mapping_attribute", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthTokenUserMappingClaims")
    def external_oauth_token_user_mapping_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the access token claim or claims that can be used to map the access token to a Snowflake user record. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_token_user_mapping_claims")

    @external_oauth_token_user_mapping_claims.setter
    def external_oauth_token_user_mapping_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_oauth_token_user_mapping_claims", value)

    @_builtins.property
    @pulumi.getter(name="externalOauthType")
    def external_oauth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the OAuth 2.0 authorization server to be Okta, Microsoft Azure AD, Ping Identity PingFederate, or a Custom OAuth 2.0 authorization server. Valid values are (case-insensitive): `OKTA` | `AZURE` | `PING_FEDERATE` | `CUSTOM`.
        """
        return pulumi.get(self, "external_oauth_type")

    @external_oauth_type.setter
    def external_oauth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_oauth_type", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the External Oath integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="relatedParameters")
    def related_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationRelatedParameterArgs']]]]:
        """
        Parameters related to this security integration.
        """
        return pulumi.get(self, "related_parameters")

    @related_parameters.setter
    def related_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationRelatedParameterArgs']]]]):
        pulumi.set(self, "related_parameters", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW SECURITY INTEGRATIONS` for the given security integration.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalOauthIntegrationShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)


@pulumi.type_token("snowflake:index/externalOauthIntegration:ExternalOauthIntegration")
class ExternalOauthIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_oauth_allowed_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_any_role_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_audience_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_blocked_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_jws_keys_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_rsa_public_key2: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_scope_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_scope_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_snowflake_user_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_token_user_mapping_claims: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/externalOauthIntegration:ExternalOauthIntegration example '"<integration_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the OAuth integration.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether to initiate operation of the integration or suspend it.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_allowed_roles_lists: Specifies the list of roles that the client can set as the primary role. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] external_oauth_any_role_mode: Specifies whether the OAuth client or user can use a role that is not defined in the OAuth access token. Valid values are (case-insensitive): `DISABLE` | `ENABLE` | `ENABLE_FOR_PRIVILEGE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_audience_lists: Specifies additional values that can be used for the access token's audience validation on top of using the Customer's Snowflake Account URL
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_blocked_roles_lists: Specifies the list of roles that a client cannot set as the primary role. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the EXTERNAL*OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] external_oauth_issuer: Specifies the URL to define the OAuth 2.0 authorization server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_jws_keys_urls: Specifies the endpoint or a list of endpoints from which to download public keys or certificates to validate an External OAuth access token. The maximum number of URLs that can be specified in the list is 3. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_rsa_public_key: Specifies a Base64-encoded RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_rsa_public_key2: Specifies a second RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. Used for key rotation. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_scope_delimiter: Specifies the scope delimiter in the authorization token.
        :param pulumi.Input[_builtins.str] external_oauth_scope_mapping_attribute: Specifies the access token claim to map the access token to an account role. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_snowflake_user_mapping_attribute: Indicates which Snowflake user record attribute should be used to map the access token to a Snowflake user record. Valid values are (case-insensitive): `LOGIN_NAME` | `EMAIL_ADDRESS`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_token_user_mapping_claims: Specifies the access token claim or claims that can be used to map the access token to a Snowflake user record. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_type: Specifies the OAuth 2.0 authorization server to be Okta, Microsoft Azure AD, Ping Identity PingFederate, or a Custom OAuth 2.0 authorization server. Valid values are (case-insensitive): `OKTA` | `AZURE` | `PING_FEDERATE` | `CUSTOM`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the External Oath integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalOauthIntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/externalOauthIntegration:ExternalOauthIntegration example '"<integration_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param ExternalOauthIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalOauthIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_oauth_allowed_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_any_role_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_audience_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_blocked_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_jws_keys_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_rsa_public_key2: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_scope_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_scope_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_snowflake_user_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 external_oauth_token_user_mapping_claims: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_oauth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalOauthIntegrationArgs.__new__(ExternalOauthIntegrationArgs)

            __props__.__dict__["comment"] = comment
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["external_oauth_allowed_roles_lists"] = external_oauth_allowed_roles_lists
            __props__.__dict__["external_oauth_any_role_mode"] = external_oauth_any_role_mode
            __props__.__dict__["external_oauth_audience_lists"] = external_oauth_audience_lists
            __props__.__dict__["external_oauth_blocked_roles_lists"] = external_oauth_blocked_roles_lists
            if external_oauth_issuer is None and not opts.urn:
                raise TypeError("Missing required property 'external_oauth_issuer'")
            __props__.__dict__["external_oauth_issuer"] = external_oauth_issuer
            __props__.__dict__["external_oauth_jws_keys_urls"] = external_oauth_jws_keys_urls
            __props__.__dict__["external_oauth_rsa_public_key"] = external_oauth_rsa_public_key
            __props__.__dict__["external_oauth_rsa_public_key2"] = external_oauth_rsa_public_key2
            __props__.__dict__["external_oauth_scope_delimiter"] = external_oauth_scope_delimiter
            __props__.__dict__["external_oauth_scope_mapping_attribute"] = external_oauth_scope_mapping_attribute
            if external_oauth_snowflake_user_mapping_attribute is None and not opts.urn:
                raise TypeError("Missing required property 'external_oauth_snowflake_user_mapping_attribute'")
            __props__.__dict__["external_oauth_snowflake_user_mapping_attribute"] = external_oauth_snowflake_user_mapping_attribute
            if external_oauth_token_user_mapping_claims is None and not opts.urn:
                raise TypeError("Missing required property 'external_oauth_token_user_mapping_claims'")
            __props__.__dict__["external_oauth_token_user_mapping_claims"] = external_oauth_token_user_mapping_claims
            if external_oauth_type is None and not opts.urn:
                raise TypeError("Missing required property 'external_oauth_type'")
            __props__.__dict__["external_oauth_type"] = external_oauth_type
            __props__.__dict__["name"] = name
            __props__.__dict__["describe_outputs"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["related_parameters"] = None
            __props__.__dict__["show_outputs"] = None
        super(ExternalOauthIntegration, __self__).__init__(
            'snowflake:index/externalOauthIntegration:ExternalOauthIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalOauthIntegrationDescribeOutputArgs', 'ExternalOauthIntegrationDescribeOutputArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            external_oauth_allowed_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            external_oauth_any_role_mode: Optional[pulumi.Input[_builtins.str]] = None,
            external_oauth_audience_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            external_oauth_blocked_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            external_oauth_issuer: Optional[pulumi.Input[_builtins.str]] = None,
            external_oauth_jws_keys_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            external_oauth_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
            external_oauth_rsa_public_key2: Optional[pulumi.Input[_builtins.str]] = None,
            external_oauth_scope_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
            external_oauth_scope_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            external_oauth_snowflake_user_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            external_oauth_token_user_mapping_claims: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            external_oauth_type: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            related_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalOauthIntegrationRelatedParameterArgs', 'ExternalOauthIntegrationRelatedParameterArgsDict']]]]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalOauthIntegrationShowOutputArgs', 'ExternalOauthIntegrationShowOutputArgsDict']]]]] = None) -> 'ExternalOauthIntegration':
        """
        Get an existing ExternalOauthIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the OAuth integration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalOauthIntegrationDescribeOutputArgs', 'ExternalOauthIntegrationDescribeOutputArgsDict']]]] describe_outputs: Outputs the result of `DESCRIBE SECURITY INTEGRATIONS` for the given security integration.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether to initiate operation of the integration or suspend it.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_allowed_roles_lists: Specifies the list of roles that the client can set as the primary role. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] external_oauth_any_role_mode: Specifies whether the OAuth client or user can use a role that is not defined in the OAuth access token. Valid values are (case-insensitive): `DISABLE` | `ENABLE` | `ENABLE_FOR_PRIVILEGE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_audience_lists: Specifies additional values that can be used for the access token's audience validation on top of using the Customer's Snowflake Account URL
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_blocked_roles_lists: Specifies the list of roles that a client cannot set as the primary role. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the EXTERNAL*OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] external_oauth_issuer: Specifies the URL to define the OAuth 2.0 authorization server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_jws_keys_urls: Specifies the endpoint or a list of endpoints from which to download public keys or certificates to validate an External OAuth access token. The maximum number of URLs that can be specified in the list is 3. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_rsa_public_key: Specifies a Base64-encoded RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_rsa_public_key2: Specifies a second RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. Used for key rotation. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_scope_delimiter: Specifies the scope delimiter in the authorization token.
        :param pulumi.Input[_builtins.str] external_oauth_scope_mapping_attribute: Specifies the access token claim to map the access token to an account role. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_snowflake_user_mapping_attribute: Indicates which Snowflake user record attribute should be used to map the access token to a Snowflake user record. Valid values are (case-insensitive): `LOGIN_NAME` | `EMAIL_ADDRESS`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_oauth_token_user_mapping_claims: Specifies the access token claim or claims that can be used to map the access token to a Snowflake user record. If removed from the config, the resource is recreated.
        :param pulumi.Input[_builtins.str] external_oauth_type: Specifies the OAuth 2.0 authorization server to be Okta, Microsoft Azure AD, Ping Identity PingFederate, or a Custom OAuth 2.0 authorization server. Valid values are (case-insensitive): `OKTA` | `AZURE` | `PING_FEDERATE` | `CUSTOM`.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the External Oath integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalOauthIntegrationRelatedParameterArgs', 'ExternalOauthIntegrationRelatedParameterArgsDict']]]] related_parameters: Parameters related to this security integration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalOauthIntegrationShowOutputArgs', 'ExternalOauthIntegrationShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW SECURITY INTEGRATIONS` for the given security integration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalOauthIntegrationState.__new__(_ExternalOauthIntegrationState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["describe_outputs"] = describe_outputs
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["external_oauth_allowed_roles_lists"] = external_oauth_allowed_roles_lists
        __props__.__dict__["external_oauth_any_role_mode"] = external_oauth_any_role_mode
        __props__.__dict__["external_oauth_audience_lists"] = external_oauth_audience_lists
        __props__.__dict__["external_oauth_blocked_roles_lists"] = external_oauth_blocked_roles_lists
        __props__.__dict__["external_oauth_issuer"] = external_oauth_issuer
        __props__.__dict__["external_oauth_jws_keys_urls"] = external_oauth_jws_keys_urls
        __props__.__dict__["external_oauth_rsa_public_key"] = external_oauth_rsa_public_key
        __props__.__dict__["external_oauth_rsa_public_key2"] = external_oauth_rsa_public_key2
        __props__.__dict__["external_oauth_scope_delimiter"] = external_oauth_scope_delimiter
        __props__.__dict__["external_oauth_scope_mapping_attribute"] = external_oauth_scope_mapping_attribute
        __props__.__dict__["external_oauth_snowflake_user_mapping_attribute"] = external_oauth_snowflake_user_mapping_attribute
        __props__.__dict__["external_oauth_token_user_mapping_claims"] = external_oauth_token_user_mapping_claims
        __props__.__dict__["external_oauth_type"] = external_oauth_type
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["name"] = name
        __props__.__dict__["related_parameters"] = related_parameters
        __props__.__dict__["show_outputs"] = show_outputs
        return ExternalOauthIntegration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the OAuth integration.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> pulumi.Output[Sequence['outputs.ExternalOauthIntegrationDescribeOutput']]:
        """
        Outputs the result of `DESCRIBE SECURITY INTEGRATIONS` for the given security integration.
        """
        return pulumi.get(self, "describe_outputs")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to initiate operation of the integration or suspend it.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="externalOauthAllowedRolesLists")
    def external_oauth_allowed_roles_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the list of roles that the client can set as the primary role. For more information about this resource, see docs.
        """
        return pulumi.get(self, "external_oauth_allowed_roles_lists")

    @_builtins.property
    @pulumi.getter(name="externalOauthAnyRoleMode")
    def external_oauth_any_role_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether the OAuth client or user can use a role that is not defined in the OAuth access token. Valid values are (case-insensitive): `DISABLE` | `ENABLE` | `ENABLE_FOR_PRIVILEGE`.
        """
        return pulumi.get(self, "external_oauth_any_role_mode")

    @_builtins.property
    @pulumi.getter(name="externalOauthAudienceLists")
    def external_oauth_audience_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies additional values that can be used for the access token's audience validation on top of using the Customer's Snowflake Account URL
        """
        return pulumi.get(self, "external_oauth_audience_lists")

    @_builtins.property
    @pulumi.getter(name="externalOauthBlockedRolesLists")
    def external_oauth_blocked_roles_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the list of roles that a client cannot set as the primary role. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the EXTERNAL*OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        """
        return pulumi.get(self, "external_oauth_blocked_roles_lists")

    @_builtins.property
    @pulumi.getter(name="externalOauthIssuer")
    def external_oauth_issuer(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the URL to define the OAuth 2.0 authorization server.
        """
        return pulumi.get(self, "external_oauth_issuer")

    @_builtins.property
    @pulumi.getter(name="externalOauthJwsKeysUrls")
    def external_oauth_jws_keys_urls(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the endpoint or a list of endpoints from which to download public keys or certificates to validate an External OAuth access token. The maximum number of URLs that can be specified in the list is 3. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_jws_keys_urls")

    @_builtins.property
    @pulumi.getter(name="externalOauthRsaPublicKey")
    def external_oauth_rsa_public_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a Base64-encoded RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_rsa_public_key")

    @_builtins.property
    @pulumi.getter(name="externalOauthRsaPublicKey2")
    def external_oauth_rsa_public_key2(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a second RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. Used for key rotation. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_rsa_public_key2")

    @_builtins.property
    @pulumi.getter(name="externalOauthScopeDelimiter")
    def external_oauth_scope_delimiter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the scope delimiter in the authorization token.
        """
        return pulumi.get(self, "external_oauth_scope_delimiter")

    @_builtins.property
    @pulumi.getter(name="externalOauthScopeMappingAttribute")
    def external_oauth_scope_mapping_attribute(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the access token claim to map the access token to an account role. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_scope_mapping_attribute")

    @_builtins.property
    @pulumi.getter(name="externalOauthSnowflakeUserMappingAttribute")
    def external_oauth_snowflake_user_mapping_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates which Snowflake user record attribute should be used to map the access token to a Snowflake user record. Valid values are (case-insensitive): `LOGIN_NAME` | `EMAIL_ADDRESS`.
        """
        return pulumi.get(self, "external_oauth_snowflake_user_mapping_attribute")

    @_builtins.property
    @pulumi.getter(name="externalOauthTokenUserMappingClaims")
    def external_oauth_token_user_mapping_claims(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the access token claim or claims that can be used to map the access token to a Snowflake user record. If removed from the config, the resource is recreated.
        """
        return pulumi.get(self, "external_oauth_token_user_mapping_claims")

    @_builtins.property
    @pulumi.getter(name="externalOauthType")
    def external_oauth_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the OAuth 2.0 authorization server to be Okta, Microsoft Azure AD, Ping Identity PingFederate, or a Custom OAuth 2.0 authorization server. Valid values are (case-insensitive): `OKTA` | `AZURE` | `PING_FEDERATE` | `CUSTOM`.
        """
        return pulumi.get(self, "external_oauth_type")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the External Oath integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="relatedParameters")
    def related_parameters(self) -> pulumi.Output[Sequence['outputs.ExternalOauthIntegrationRelatedParameter']]:
        """
        Parameters related to this security integration.
        """
        return pulumi.get(self, "related_parameters")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.ExternalOauthIntegrationShowOutput']]:
        """
        Outputs the result of `SHOW SECURITY INTEGRATIONS` for the given security integration.
        """
        return pulumi.get(self, "show_outputs")

