# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FileFormatArgs', 'FileFormat']

@pulumi.input_type
class FileFormatArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 format_type: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 allow_duplicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_as_text: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_format: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 date_format: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_auto_convert: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_snowflake_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 empty_field_as_null: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_octal: Optional[pulumi.Input[_builtins.bool]] = None,
                 encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 error_on_column_count_mismatch: Optional[pulumi.Input[_builtins.bool]] = None,
                 escape: Optional[pulumi.Input[_builtins.str]] = None,
                 escape_unenclosed_field: Optional[pulumi.Input[_builtins.str]] = None,
                 field_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 field_optionally_enclosed_by: Optional[pulumi.Input[_builtins.str]] = None,
                 file_extension: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_utf8_errors: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_ifs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parse_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 preserve_space: Optional[pulumi.Input[_builtins.bool]] = None,
                 record_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_blank_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_byte_order_mark: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_header: Optional[pulumi.Input[_builtins.int]] = None,
                 strip_null_values: Optional[pulumi.Input[_builtins.bool]] = None,
                 strip_outer_array: Optional[pulumi.Input[_builtins.bool]] = None,
                 strip_outer_element: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_format: Optional[pulumi.Input[_builtins.str]] = None,
                 trim_space: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a FileFormat resource.
        :param pulumi.Input[_builtins.str] database: The database in which to create the file format.
        :param pulumi.Input[_builtins.str] format_type: Specifies the format of the input files (for data loading) or output files (for data unloading).
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the file format.
        :param pulumi.Input[_builtins.bool] allow_duplicate: Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        :param pulumi.Input[_builtins.bool] binary_as_text: Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        :param pulumi.Input[_builtins.str] binary_format: Defines the encoding format for binary input or output.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the file format.
        :param pulumi.Input[_builtins.str] compression: Specifies the current compression algorithm for the data file.
        :param pulumi.Input[_builtins.str] date_format: Defines the format of date values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.bool] disable_auto_convert: Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        :param pulumi.Input[_builtins.bool] disable_snowflake_data: Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        :param pulumi.Input[_builtins.bool] empty_field_as_null: Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        :param pulumi.Input[_builtins.bool] enable_octal: Boolean that enables parsing of octal numbers.
        :param pulumi.Input[_builtins.str] encoding: String (constant) that specifies the character set of the source data when loading data into a table.
        :param pulumi.Input[_builtins.bool] error_on_column_count_mismatch: Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        :param pulumi.Input[_builtins.str] escape: Single character string used as the escape character for field values.
        :param pulumi.Input[_builtins.str] escape_unenclosed_field: Single character string used as the escape character for unenclosed field values only.
        :param pulumi.Input[_builtins.str] field_delimiter: Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[_builtins.str] field_optionally_enclosed_by: Character used to enclose strings.
        :param pulumi.Input[_builtins.str] file_extension: Specifies the extension for files unloaded to a stage.
        :param pulumi.Input[_builtins.bool] ignore_utf8_errors: Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] null_ifs: String used to convert to and from SQL NULL.
        :param pulumi.Input[_builtins.bool] parse_header: Boolean that specifies whether to use the first row headers in the data files to determine column names.
        :param pulumi.Input[_builtins.bool] preserve_space: Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        :param pulumi.Input[_builtins.str] record_delimiter: Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[_builtins.bool] replace_invalid_characters: Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        :param pulumi.Input[_builtins.bool] skip_blank_lines: Boolean that specifies to skip any blank lines encountered in the data files.
        :param pulumi.Input[_builtins.bool] skip_byte_order_mark: Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        :param pulumi.Input[_builtins.int] skip_header: Number of lines at the start of the file to skip.
        :param pulumi.Input[_builtins.bool] strip_null_values: Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        :param pulumi.Input[_builtins.bool] strip_outer_array: Boolean that instructs the JSON parser to remove outer brackets.
        :param pulumi.Input[_builtins.bool] strip_outer_element: Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        :param pulumi.Input[_builtins.str] time_format: Defines the format of time values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.str] timestamp_format: Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.bool] trim_space: Boolean that specifies whether to remove white space from fields.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "format_type", format_type)
        pulumi.set(__self__, "schema", schema)
        if allow_duplicate is not None:
            pulumi.set(__self__, "allow_duplicate", allow_duplicate)
        if binary_as_text is not None:
            pulumi.set(__self__, "binary_as_text", binary_as_text)
        if binary_format is not None:
            pulumi.set(__self__, "binary_format", binary_format)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if disable_auto_convert is not None:
            pulumi.set(__self__, "disable_auto_convert", disable_auto_convert)
        if disable_snowflake_data is not None:
            pulumi.set(__self__, "disable_snowflake_data", disable_snowflake_data)
        if empty_field_as_null is not None:
            pulumi.set(__self__, "empty_field_as_null", empty_field_as_null)
        if enable_octal is not None:
            pulumi.set(__self__, "enable_octal", enable_octal)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if error_on_column_count_mismatch is not None:
            pulumi.set(__self__, "error_on_column_count_mismatch", error_on_column_count_mismatch)
        if escape is not None:
            pulumi.set(__self__, "escape", escape)
        if escape_unenclosed_field is not None:
            pulumi.set(__self__, "escape_unenclosed_field", escape_unenclosed_field)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if field_optionally_enclosed_by is not None:
            pulumi.set(__self__, "field_optionally_enclosed_by", field_optionally_enclosed_by)
        if file_extension is not None:
            pulumi.set(__self__, "file_extension", file_extension)
        if ignore_utf8_errors is not None:
            pulumi.set(__self__, "ignore_utf8_errors", ignore_utf8_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if null_ifs is not None:
            pulumi.set(__self__, "null_ifs", null_ifs)
        if parse_header is not None:
            pulumi.set(__self__, "parse_header", parse_header)
        if preserve_space is not None:
            pulumi.set(__self__, "preserve_space", preserve_space)
        if record_delimiter is not None:
            pulumi.set(__self__, "record_delimiter", record_delimiter)
        if replace_invalid_characters is not None:
            pulumi.set(__self__, "replace_invalid_characters", replace_invalid_characters)
        if skip_blank_lines is not None:
            pulumi.set(__self__, "skip_blank_lines", skip_blank_lines)
        if skip_byte_order_mark is not None:
            pulumi.set(__self__, "skip_byte_order_mark", skip_byte_order_mark)
        if skip_header is not None:
            pulumi.set(__self__, "skip_header", skip_header)
        if strip_null_values is not None:
            pulumi.set(__self__, "strip_null_values", strip_null_values)
        if strip_outer_array is not None:
            pulumi.set(__self__, "strip_outer_array", strip_outer_array)
        if strip_outer_element is not None:
            pulumi.set(__self__, "strip_outer_element", strip_outer_element)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if trim_space is not None:
            pulumi.set(__self__, "trim_space", trim_space)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the file format.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="formatType")
    def format_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the format of the input files (for data loading) or output files (for data unloading).
        """
        return pulumi.get(self, "format_type")

    @format_type.setter
    def format_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "format_type", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the file format.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="allowDuplicate")
    def allow_duplicate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        """
        return pulumi.get(self, "allow_duplicate")

    @allow_duplicate.setter
    def allow_duplicate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_duplicate", value)

    @_builtins.property
    @pulumi.getter(name="binaryAsText")
    def binary_as_text(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        """
        return pulumi.get(self, "binary_as_text")

    @binary_as_text.setter
    def binary_as_text(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "binary_as_text", value)

    @_builtins.property
    @pulumi.getter(name="binaryFormat")
    def binary_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the encoding format for binary input or output.
        """
        return pulumi.get(self, "binary_format")

    @binary_format.setter
    def binary_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binary_format", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the file format.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the current compression algorithm for the data file.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression", value)

    @_builtins.property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the format of date values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_format", value)

    @_builtins.property
    @pulumi.getter(name="disableAutoConvert")
    def disable_auto_convert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        """
        return pulumi.get(self, "disable_auto_convert")

    @disable_auto_convert.setter
    def disable_auto_convert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_auto_convert", value)

    @_builtins.property
    @pulumi.getter(name="disableSnowflakeData")
    def disable_snowflake_data(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        """
        return pulumi.get(self, "disable_snowflake_data")

    @disable_snowflake_data.setter
    def disable_snowflake_data(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_snowflake_data", value)

    @_builtins.property
    @pulumi.getter(name="emptyFieldAsNull")
    def empty_field_as_null(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        """
        return pulumi.get(self, "empty_field_as_null")

    @empty_field_as_null.setter
    def empty_field_as_null(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "empty_field_as_null", value)

    @_builtins.property
    @pulumi.getter(name="enableOctal")
    def enable_octal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that enables parsing of octal numbers.
        """
        return pulumi.get(self, "enable_octal")

    @enable_octal.setter
    def enable_octal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_octal", value)

    @_builtins.property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String (constant) that specifies the character set of the source data when loading data into a table.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encoding", value)

    @_builtins.property
    @pulumi.getter(name="errorOnColumnCountMismatch")
    def error_on_column_count_mismatch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        """
        return pulumi.get(self, "error_on_column_count_mismatch")

    @error_on_column_count_mismatch.setter
    def error_on_column_count_mismatch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "error_on_column_count_mismatch", value)

    @_builtins.property
    @pulumi.getter
    def escape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Single character string used as the escape character for field values.
        """
        return pulumi.get(self, "escape")

    @escape.setter
    def escape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "escape", value)

    @_builtins.property
    @pulumi.getter(name="escapeUnenclosedField")
    def escape_unenclosed_field(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Single character string used as the escape character for unenclosed field values only.
        """
        return pulumi.get(self, "escape_unenclosed_field")

    @escape_unenclosed_field.setter
    def escape_unenclosed_field(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "escape_unenclosed_field", value)

    @_builtins.property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "field_delimiter", value)

    @_builtins.property
    @pulumi.getter(name="fieldOptionallyEnclosedBy")
    def field_optionally_enclosed_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Character used to enclose strings.
        """
        return pulumi.get(self, "field_optionally_enclosed_by")

    @field_optionally_enclosed_by.setter
    def field_optionally_enclosed_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "field_optionally_enclosed_by", value)

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the extension for files unloaded to a stage.
        """
        return pulumi.get(self, "file_extension")

    @file_extension.setter
    def file_extension(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_extension", value)

    @_builtins.property
    @pulumi.getter(name="ignoreUtf8Errors")
    def ignore_utf8_errors(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        """
        return pulumi.get(self, "ignore_utf8_errors")

    @ignore_utf8_errors.setter
    def ignore_utf8_errors(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_utf8_errors", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nullIfs")
    def null_ifs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        String used to convert to and from SQL NULL.
        """
        return pulumi.get(self, "null_ifs")

    @null_ifs.setter
    def null_ifs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "null_ifs", value)

    @_builtins.property
    @pulumi.getter(name="parseHeader")
    def parse_header(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to use the first row headers in the data files to determine column names.
        """
        return pulumi.get(self, "parse_header")

    @parse_header.setter
    def parse_header(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "parse_header", value)

    @_builtins.property
    @pulumi.getter(name="preserveSpace")
    def preserve_space(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        """
        return pulumi.get(self, "preserve_space")

    @preserve_space.setter
    def preserve_space(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve_space", value)

    @_builtins.property
    @pulumi.getter(name="recordDelimiter")
    def record_delimiter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "record_delimiter")

    @record_delimiter.setter
    def record_delimiter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_delimiter", value)

    @_builtins.property
    @pulumi.getter(name="replaceInvalidCharacters")
    def replace_invalid_characters(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        """
        return pulumi.get(self, "replace_invalid_characters")

    @replace_invalid_characters.setter
    def replace_invalid_characters(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replace_invalid_characters", value)

    @_builtins.property
    @pulumi.getter(name="skipBlankLines")
    def skip_blank_lines(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies to skip any blank lines encountered in the data files.
        """
        return pulumi.get(self, "skip_blank_lines")

    @skip_blank_lines.setter
    def skip_blank_lines(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_blank_lines", value)

    @_builtins.property
    @pulumi.getter(name="skipByteOrderMark")
    def skip_byte_order_mark(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        """
        return pulumi.get(self, "skip_byte_order_mark")

    @skip_byte_order_mark.setter
    def skip_byte_order_mark(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_byte_order_mark", value)

    @_builtins.property
    @pulumi.getter(name="skipHeader")
    def skip_header(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of lines at the start of the file to skip.
        """
        return pulumi.get(self, "skip_header")

    @skip_header.setter
    def skip_header(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "skip_header", value)

    @_builtins.property
    @pulumi.getter(name="stripNullValues")
    def strip_null_values(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        """
        return pulumi.get(self, "strip_null_values")

    @strip_null_values.setter
    def strip_null_values(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strip_null_values", value)

    @_builtins.property
    @pulumi.getter(name="stripOuterArray")
    def strip_outer_array(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that instructs the JSON parser to remove outer brackets.
        """
        return pulumi.get(self, "strip_outer_array")

    @strip_outer_array.setter
    def strip_outer_array(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strip_outer_array", value)

    @_builtins.property
    @pulumi.getter(name="stripOuterElement")
    def strip_outer_element(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        """
        return pulumi.get(self, "strip_outer_element")

    @strip_outer_element.setter
    def strip_outer_element(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strip_outer_element", value)

    @_builtins.property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the format of time values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_format", value)

    @_builtins.property
    @pulumi.getter(name="trimSpace")
    def trim_space(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to remove white space from fields.
        """
        return pulumi.get(self, "trim_space")

    @trim_space.setter
    def trim_space(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trim_space", value)


@pulumi.input_type
class _FileFormatState:
    def __init__(__self__, *,
                 allow_duplicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_as_text: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_format: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 date_format: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_auto_convert: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_snowflake_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 empty_field_as_null: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_octal: Optional[pulumi.Input[_builtins.bool]] = None,
                 encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 error_on_column_count_mismatch: Optional[pulumi.Input[_builtins.bool]] = None,
                 escape: Optional[pulumi.Input[_builtins.str]] = None,
                 escape_unenclosed_field: Optional[pulumi.Input[_builtins.str]] = None,
                 field_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 field_optionally_enclosed_by: Optional[pulumi.Input[_builtins.str]] = None,
                 file_extension: Optional[pulumi.Input[_builtins.str]] = None,
                 format_type: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_utf8_errors: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_ifs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parse_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 preserve_space: Optional[pulumi.Input[_builtins.bool]] = None,
                 record_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_blank_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_byte_order_mark: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_header: Optional[pulumi.Input[_builtins.int]] = None,
                 strip_null_values: Optional[pulumi.Input[_builtins.bool]] = None,
                 strip_outer_array: Optional[pulumi.Input[_builtins.bool]] = None,
                 strip_outer_element: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_format: Optional[pulumi.Input[_builtins.str]] = None,
                 trim_space: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering FileFormat resources.
        :param pulumi.Input[_builtins.bool] allow_duplicate: Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        :param pulumi.Input[_builtins.bool] binary_as_text: Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        :param pulumi.Input[_builtins.str] binary_format: Defines the encoding format for binary input or output.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the file format.
        :param pulumi.Input[_builtins.str] compression: Specifies the current compression algorithm for the data file.
        :param pulumi.Input[_builtins.str] database: The database in which to create the file format.
        :param pulumi.Input[_builtins.str] date_format: Defines the format of date values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.bool] disable_auto_convert: Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        :param pulumi.Input[_builtins.bool] disable_snowflake_data: Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        :param pulumi.Input[_builtins.bool] empty_field_as_null: Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        :param pulumi.Input[_builtins.bool] enable_octal: Boolean that enables parsing of octal numbers.
        :param pulumi.Input[_builtins.str] encoding: String (constant) that specifies the character set of the source data when loading data into a table.
        :param pulumi.Input[_builtins.bool] error_on_column_count_mismatch: Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        :param pulumi.Input[_builtins.str] escape: Single character string used as the escape character for field values.
        :param pulumi.Input[_builtins.str] escape_unenclosed_field: Single character string used as the escape character for unenclosed field values only.
        :param pulumi.Input[_builtins.str] field_delimiter: Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[_builtins.str] field_optionally_enclosed_by: Character used to enclose strings.
        :param pulumi.Input[_builtins.str] file_extension: Specifies the extension for files unloaded to a stage.
        :param pulumi.Input[_builtins.str] format_type: Specifies the format of the input files (for data loading) or output files (for data unloading).
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.bool] ignore_utf8_errors: Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] null_ifs: String used to convert to and from SQL NULL.
        :param pulumi.Input[_builtins.bool] parse_header: Boolean that specifies whether to use the first row headers in the data files to determine column names.
        :param pulumi.Input[_builtins.bool] preserve_space: Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        :param pulumi.Input[_builtins.str] record_delimiter: Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[_builtins.bool] replace_invalid_characters: Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the file format.
        :param pulumi.Input[_builtins.bool] skip_blank_lines: Boolean that specifies to skip any blank lines encountered in the data files.
        :param pulumi.Input[_builtins.bool] skip_byte_order_mark: Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        :param pulumi.Input[_builtins.int] skip_header: Number of lines at the start of the file to skip.
        :param pulumi.Input[_builtins.bool] strip_null_values: Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        :param pulumi.Input[_builtins.bool] strip_outer_array: Boolean that instructs the JSON parser to remove outer brackets.
        :param pulumi.Input[_builtins.bool] strip_outer_element: Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        :param pulumi.Input[_builtins.str] time_format: Defines the format of time values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.str] timestamp_format: Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.bool] trim_space: Boolean that specifies whether to remove white space from fields.
        """
        if allow_duplicate is not None:
            pulumi.set(__self__, "allow_duplicate", allow_duplicate)
        if binary_as_text is not None:
            pulumi.set(__self__, "binary_as_text", binary_as_text)
        if binary_format is not None:
            pulumi.set(__self__, "binary_format", binary_format)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if disable_auto_convert is not None:
            pulumi.set(__self__, "disable_auto_convert", disable_auto_convert)
        if disable_snowflake_data is not None:
            pulumi.set(__self__, "disable_snowflake_data", disable_snowflake_data)
        if empty_field_as_null is not None:
            pulumi.set(__self__, "empty_field_as_null", empty_field_as_null)
        if enable_octal is not None:
            pulumi.set(__self__, "enable_octal", enable_octal)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if error_on_column_count_mismatch is not None:
            pulumi.set(__self__, "error_on_column_count_mismatch", error_on_column_count_mismatch)
        if escape is not None:
            pulumi.set(__self__, "escape", escape)
        if escape_unenclosed_field is not None:
            pulumi.set(__self__, "escape_unenclosed_field", escape_unenclosed_field)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if field_optionally_enclosed_by is not None:
            pulumi.set(__self__, "field_optionally_enclosed_by", field_optionally_enclosed_by)
        if file_extension is not None:
            pulumi.set(__self__, "file_extension", file_extension)
        if format_type is not None:
            pulumi.set(__self__, "format_type", format_type)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if ignore_utf8_errors is not None:
            pulumi.set(__self__, "ignore_utf8_errors", ignore_utf8_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if null_ifs is not None:
            pulumi.set(__self__, "null_ifs", null_ifs)
        if parse_header is not None:
            pulumi.set(__self__, "parse_header", parse_header)
        if preserve_space is not None:
            pulumi.set(__self__, "preserve_space", preserve_space)
        if record_delimiter is not None:
            pulumi.set(__self__, "record_delimiter", record_delimiter)
        if replace_invalid_characters is not None:
            pulumi.set(__self__, "replace_invalid_characters", replace_invalid_characters)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if skip_blank_lines is not None:
            pulumi.set(__self__, "skip_blank_lines", skip_blank_lines)
        if skip_byte_order_mark is not None:
            pulumi.set(__self__, "skip_byte_order_mark", skip_byte_order_mark)
        if skip_header is not None:
            pulumi.set(__self__, "skip_header", skip_header)
        if strip_null_values is not None:
            pulumi.set(__self__, "strip_null_values", strip_null_values)
        if strip_outer_array is not None:
            pulumi.set(__self__, "strip_outer_array", strip_outer_array)
        if strip_outer_element is not None:
            pulumi.set(__self__, "strip_outer_element", strip_outer_element)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if trim_space is not None:
            pulumi.set(__self__, "trim_space", trim_space)

    @_builtins.property
    @pulumi.getter(name="allowDuplicate")
    def allow_duplicate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        """
        return pulumi.get(self, "allow_duplicate")

    @allow_duplicate.setter
    def allow_duplicate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_duplicate", value)

    @_builtins.property
    @pulumi.getter(name="binaryAsText")
    def binary_as_text(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        """
        return pulumi.get(self, "binary_as_text")

    @binary_as_text.setter
    def binary_as_text(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "binary_as_text", value)

    @_builtins.property
    @pulumi.getter(name="binaryFormat")
    def binary_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the encoding format for binary input or output.
        """
        return pulumi.get(self, "binary_format")

    @binary_format.setter
    def binary_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binary_format", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the file format.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the current compression algorithm for the data file.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the file format.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the format of date values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_format", value)

    @_builtins.property
    @pulumi.getter(name="disableAutoConvert")
    def disable_auto_convert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        """
        return pulumi.get(self, "disable_auto_convert")

    @disable_auto_convert.setter
    def disable_auto_convert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_auto_convert", value)

    @_builtins.property
    @pulumi.getter(name="disableSnowflakeData")
    def disable_snowflake_data(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        """
        return pulumi.get(self, "disable_snowflake_data")

    @disable_snowflake_data.setter
    def disable_snowflake_data(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_snowflake_data", value)

    @_builtins.property
    @pulumi.getter(name="emptyFieldAsNull")
    def empty_field_as_null(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        """
        return pulumi.get(self, "empty_field_as_null")

    @empty_field_as_null.setter
    def empty_field_as_null(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "empty_field_as_null", value)

    @_builtins.property
    @pulumi.getter(name="enableOctal")
    def enable_octal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that enables parsing of octal numbers.
        """
        return pulumi.get(self, "enable_octal")

    @enable_octal.setter
    def enable_octal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_octal", value)

    @_builtins.property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String (constant) that specifies the character set of the source data when loading data into a table.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encoding", value)

    @_builtins.property
    @pulumi.getter(name="errorOnColumnCountMismatch")
    def error_on_column_count_mismatch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        """
        return pulumi.get(self, "error_on_column_count_mismatch")

    @error_on_column_count_mismatch.setter
    def error_on_column_count_mismatch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "error_on_column_count_mismatch", value)

    @_builtins.property
    @pulumi.getter
    def escape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Single character string used as the escape character for field values.
        """
        return pulumi.get(self, "escape")

    @escape.setter
    def escape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "escape", value)

    @_builtins.property
    @pulumi.getter(name="escapeUnenclosedField")
    def escape_unenclosed_field(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Single character string used as the escape character for unenclosed field values only.
        """
        return pulumi.get(self, "escape_unenclosed_field")

    @escape_unenclosed_field.setter
    def escape_unenclosed_field(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "escape_unenclosed_field", value)

    @_builtins.property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "field_delimiter", value)

    @_builtins.property
    @pulumi.getter(name="fieldOptionallyEnclosedBy")
    def field_optionally_enclosed_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Character used to enclose strings.
        """
        return pulumi.get(self, "field_optionally_enclosed_by")

    @field_optionally_enclosed_by.setter
    def field_optionally_enclosed_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "field_optionally_enclosed_by", value)

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the extension for files unloaded to a stage.
        """
        return pulumi.get(self, "file_extension")

    @file_extension.setter
    def file_extension(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_extension", value)

    @_builtins.property
    @pulumi.getter(name="formatType")
    def format_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the format of the input files (for data loading) or output files (for data unloading).
        """
        return pulumi.get(self, "format_type")

    @format_type.setter
    def format_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format_type", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter(name="ignoreUtf8Errors")
    def ignore_utf8_errors(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        """
        return pulumi.get(self, "ignore_utf8_errors")

    @ignore_utf8_errors.setter
    def ignore_utf8_errors(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_utf8_errors", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nullIfs")
    def null_ifs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        String used to convert to and from SQL NULL.
        """
        return pulumi.get(self, "null_ifs")

    @null_ifs.setter
    def null_ifs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "null_ifs", value)

    @_builtins.property
    @pulumi.getter(name="parseHeader")
    def parse_header(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to use the first row headers in the data files to determine column names.
        """
        return pulumi.get(self, "parse_header")

    @parse_header.setter
    def parse_header(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "parse_header", value)

    @_builtins.property
    @pulumi.getter(name="preserveSpace")
    def preserve_space(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        """
        return pulumi.get(self, "preserve_space")

    @preserve_space.setter
    def preserve_space(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve_space", value)

    @_builtins.property
    @pulumi.getter(name="recordDelimiter")
    def record_delimiter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "record_delimiter")

    @record_delimiter.setter
    def record_delimiter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_delimiter", value)

    @_builtins.property
    @pulumi.getter(name="replaceInvalidCharacters")
    def replace_invalid_characters(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        """
        return pulumi.get(self, "replace_invalid_characters")

    @replace_invalid_characters.setter
    def replace_invalid_characters(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replace_invalid_characters", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the file format.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="skipBlankLines")
    def skip_blank_lines(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies to skip any blank lines encountered in the data files.
        """
        return pulumi.get(self, "skip_blank_lines")

    @skip_blank_lines.setter
    def skip_blank_lines(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_blank_lines", value)

    @_builtins.property
    @pulumi.getter(name="skipByteOrderMark")
    def skip_byte_order_mark(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        """
        return pulumi.get(self, "skip_byte_order_mark")

    @skip_byte_order_mark.setter
    def skip_byte_order_mark(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_byte_order_mark", value)

    @_builtins.property
    @pulumi.getter(name="skipHeader")
    def skip_header(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of lines at the start of the file to skip.
        """
        return pulumi.get(self, "skip_header")

    @skip_header.setter
    def skip_header(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "skip_header", value)

    @_builtins.property
    @pulumi.getter(name="stripNullValues")
    def strip_null_values(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        """
        return pulumi.get(self, "strip_null_values")

    @strip_null_values.setter
    def strip_null_values(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strip_null_values", value)

    @_builtins.property
    @pulumi.getter(name="stripOuterArray")
    def strip_outer_array(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that instructs the JSON parser to remove outer brackets.
        """
        return pulumi.get(self, "strip_outer_array")

    @strip_outer_array.setter
    def strip_outer_array(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strip_outer_array", value)

    @_builtins.property
    @pulumi.getter(name="stripOuterElement")
    def strip_outer_element(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        """
        return pulumi.get(self, "strip_outer_element")

    @strip_outer_element.setter
    def strip_outer_element(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strip_outer_element", value)

    @_builtins.property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the format of time values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_format", value)

    @_builtins.property
    @pulumi.getter(name="trimSpace")
    def trim_space(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that specifies whether to remove white space from fields.
        """
        return pulumi.get(self, "trim_space")

    @trim_space.setter
    def trim_space(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trim_space", value)


@pulumi.type_token("snowflake:index/fileFormat:FileFormat")
class FileFormat(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_duplicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_as_text: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_format: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 date_format: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_auto_convert: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_snowflake_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 empty_field_as_null: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_octal: Optional[pulumi.Input[_builtins.bool]] = None,
                 encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 error_on_column_count_mismatch: Optional[pulumi.Input[_builtins.bool]] = None,
                 escape: Optional[pulumi.Input[_builtins.str]] = None,
                 escape_unenclosed_field: Optional[pulumi.Input[_builtins.str]] = None,
                 field_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 field_optionally_enclosed_by: Optional[pulumi.Input[_builtins.str]] = None,
                 file_extension: Optional[pulumi.Input[_builtins.str]] = None,
                 format_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_utf8_errors: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_ifs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parse_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 preserve_space: Optional[pulumi.Input[_builtins.bool]] = None,
                 record_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_blank_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_byte_order_mark: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_header: Optional[pulumi.Input[_builtins.int]] = None,
                 strip_null_values: Optional[pulumi.Input[_builtins.bool]] = None,
                 strip_outer_array: Optional[pulumi.Input[_builtins.bool]] = None,
                 strip_outer_element: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_format: Optional[pulumi.Input[_builtins.str]] = None,
                 trim_space: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Import

        format is database name | schema name | file format name

        ```sh
        $ pulumi import snowflake:index/fileFormat:FileFormat example 'dbName|schemaName|fileFormatName'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_duplicate: Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        :param pulumi.Input[_builtins.bool] binary_as_text: Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        :param pulumi.Input[_builtins.str] binary_format: Defines the encoding format for binary input or output.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the file format.
        :param pulumi.Input[_builtins.str] compression: Specifies the current compression algorithm for the data file.
        :param pulumi.Input[_builtins.str] database: The database in which to create the file format.
        :param pulumi.Input[_builtins.str] date_format: Defines the format of date values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.bool] disable_auto_convert: Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        :param pulumi.Input[_builtins.bool] disable_snowflake_data: Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        :param pulumi.Input[_builtins.bool] empty_field_as_null: Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        :param pulumi.Input[_builtins.bool] enable_octal: Boolean that enables parsing of octal numbers.
        :param pulumi.Input[_builtins.str] encoding: String (constant) that specifies the character set of the source data when loading data into a table.
        :param pulumi.Input[_builtins.bool] error_on_column_count_mismatch: Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        :param pulumi.Input[_builtins.str] escape: Single character string used as the escape character for field values.
        :param pulumi.Input[_builtins.str] escape_unenclosed_field: Single character string used as the escape character for unenclosed field values only.
        :param pulumi.Input[_builtins.str] field_delimiter: Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[_builtins.str] field_optionally_enclosed_by: Character used to enclose strings.
        :param pulumi.Input[_builtins.str] file_extension: Specifies the extension for files unloaded to a stage.
        :param pulumi.Input[_builtins.str] format_type: Specifies the format of the input files (for data loading) or output files (for data unloading).
        :param pulumi.Input[_builtins.bool] ignore_utf8_errors: Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] null_ifs: String used to convert to and from SQL NULL.
        :param pulumi.Input[_builtins.bool] parse_header: Boolean that specifies whether to use the first row headers in the data files to determine column names.
        :param pulumi.Input[_builtins.bool] preserve_space: Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        :param pulumi.Input[_builtins.str] record_delimiter: Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[_builtins.bool] replace_invalid_characters: Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the file format.
        :param pulumi.Input[_builtins.bool] skip_blank_lines: Boolean that specifies to skip any blank lines encountered in the data files.
        :param pulumi.Input[_builtins.bool] skip_byte_order_mark: Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        :param pulumi.Input[_builtins.int] skip_header: Number of lines at the start of the file to skip.
        :param pulumi.Input[_builtins.bool] strip_null_values: Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        :param pulumi.Input[_builtins.bool] strip_outer_array: Boolean that instructs the JSON parser to remove outer brackets.
        :param pulumi.Input[_builtins.bool] strip_outer_element: Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        :param pulumi.Input[_builtins.str] time_format: Defines the format of time values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.str] timestamp_format: Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.bool] trim_space: Boolean that specifies whether to remove white space from fields.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileFormatArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        format is database name | schema name | file format name

        ```sh
        $ pulumi import snowflake:index/fileFormat:FileFormat example 'dbName|schemaName|fileFormatName'
        ```

        :param str resource_name: The name of the resource.
        :param FileFormatArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileFormatArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_duplicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_as_text: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_format: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 date_format: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_auto_convert: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_snowflake_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 empty_field_as_null: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_octal: Optional[pulumi.Input[_builtins.bool]] = None,
                 encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 error_on_column_count_mismatch: Optional[pulumi.Input[_builtins.bool]] = None,
                 escape: Optional[pulumi.Input[_builtins.str]] = None,
                 escape_unenclosed_field: Optional[pulumi.Input[_builtins.str]] = None,
                 field_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 field_optionally_enclosed_by: Optional[pulumi.Input[_builtins.str]] = None,
                 file_extension: Optional[pulumi.Input[_builtins.str]] = None,
                 format_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_utf8_errors: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_ifs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parse_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 preserve_space: Optional[pulumi.Input[_builtins.bool]] = None,
                 record_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_blank_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_byte_order_mark: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_header: Optional[pulumi.Input[_builtins.int]] = None,
                 strip_null_values: Optional[pulumi.Input[_builtins.bool]] = None,
                 strip_outer_array: Optional[pulumi.Input[_builtins.bool]] = None,
                 strip_outer_element: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_format: Optional[pulumi.Input[_builtins.str]] = None,
                 trim_space: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileFormatArgs.__new__(FileFormatArgs)

            __props__.__dict__["allow_duplicate"] = allow_duplicate
            __props__.__dict__["binary_as_text"] = binary_as_text
            __props__.__dict__["binary_format"] = binary_format
            __props__.__dict__["comment"] = comment
            __props__.__dict__["compression"] = compression
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["date_format"] = date_format
            __props__.__dict__["disable_auto_convert"] = disable_auto_convert
            __props__.__dict__["disable_snowflake_data"] = disable_snowflake_data
            __props__.__dict__["empty_field_as_null"] = empty_field_as_null
            __props__.__dict__["enable_octal"] = enable_octal
            __props__.__dict__["encoding"] = encoding
            __props__.__dict__["error_on_column_count_mismatch"] = error_on_column_count_mismatch
            __props__.__dict__["escape"] = escape
            __props__.__dict__["escape_unenclosed_field"] = escape_unenclosed_field
            __props__.__dict__["field_delimiter"] = field_delimiter
            __props__.__dict__["field_optionally_enclosed_by"] = field_optionally_enclosed_by
            __props__.__dict__["file_extension"] = file_extension
            if format_type is None and not opts.urn:
                raise TypeError("Missing required property 'format_type'")
            __props__.__dict__["format_type"] = format_type
            __props__.__dict__["ignore_utf8_errors"] = ignore_utf8_errors
            __props__.__dict__["name"] = name
            __props__.__dict__["null_ifs"] = null_ifs
            __props__.__dict__["parse_header"] = parse_header
            __props__.__dict__["preserve_space"] = preserve_space
            __props__.__dict__["record_delimiter"] = record_delimiter
            __props__.__dict__["replace_invalid_characters"] = replace_invalid_characters
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["skip_blank_lines"] = skip_blank_lines
            __props__.__dict__["skip_byte_order_mark"] = skip_byte_order_mark
            __props__.__dict__["skip_header"] = skip_header
            __props__.__dict__["strip_null_values"] = strip_null_values
            __props__.__dict__["strip_outer_array"] = strip_outer_array
            __props__.__dict__["strip_outer_element"] = strip_outer_element
            __props__.__dict__["time_format"] = time_format
            __props__.__dict__["timestamp_format"] = timestamp_format
            __props__.__dict__["trim_space"] = trim_space
            __props__.__dict__["fully_qualified_name"] = None
        super(FileFormat, __self__).__init__(
            'snowflake:index/fileFormat:FileFormat',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_duplicate: Optional[pulumi.Input[_builtins.bool]] = None,
            binary_as_text: Optional[pulumi.Input[_builtins.bool]] = None,
            binary_format: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            compression: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            date_format: Optional[pulumi.Input[_builtins.str]] = None,
            disable_auto_convert: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_snowflake_data: Optional[pulumi.Input[_builtins.bool]] = None,
            empty_field_as_null: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_octal: Optional[pulumi.Input[_builtins.bool]] = None,
            encoding: Optional[pulumi.Input[_builtins.str]] = None,
            error_on_column_count_mismatch: Optional[pulumi.Input[_builtins.bool]] = None,
            escape: Optional[pulumi.Input[_builtins.str]] = None,
            escape_unenclosed_field: Optional[pulumi.Input[_builtins.str]] = None,
            field_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
            field_optionally_enclosed_by: Optional[pulumi.Input[_builtins.str]] = None,
            file_extension: Optional[pulumi.Input[_builtins.str]] = None,
            format_type: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            ignore_utf8_errors: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            null_ifs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            parse_header: Optional[pulumi.Input[_builtins.bool]] = None,
            preserve_space: Optional[pulumi.Input[_builtins.bool]] = None,
            record_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
            replace_invalid_characters: Optional[pulumi.Input[_builtins.bool]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            skip_blank_lines: Optional[pulumi.Input[_builtins.bool]] = None,
            skip_byte_order_mark: Optional[pulumi.Input[_builtins.bool]] = None,
            skip_header: Optional[pulumi.Input[_builtins.int]] = None,
            strip_null_values: Optional[pulumi.Input[_builtins.bool]] = None,
            strip_outer_array: Optional[pulumi.Input[_builtins.bool]] = None,
            strip_outer_element: Optional[pulumi.Input[_builtins.bool]] = None,
            time_format: Optional[pulumi.Input[_builtins.str]] = None,
            timestamp_format: Optional[pulumi.Input[_builtins.str]] = None,
            trim_space: Optional[pulumi.Input[_builtins.bool]] = None) -> 'FileFormat':
        """
        Get an existing FileFormat resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_duplicate: Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        :param pulumi.Input[_builtins.bool] binary_as_text: Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        :param pulumi.Input[_builtins.str] binary_format: Defines the encoding format for binary input or output.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the file format.
        :param pulumi.Input[_builtins.str] compression: Specifies the current compression algorithm for the data file.
        :param pulumi.Input[_builtins.str] database: The database in which to create the file format.
        :param pulumi.Input[_builtins.str] date_format: Defines the format of date values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.bool] disable_auto_convert: Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        :param pulumi.Input[_builtins.bool] disable_snowflake_data: Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        :param pulumi.Input[_builtins.bool] empty_field_as_null: Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        :param pulumi.Input[_builtins.bool] enable_octal: Boolean that enables parsing of octal numbers.
        :param pulumi.Input[_builtins.str] encoding: String (constant) that specifies the character set of the source data when loading data into a table.
        :param pulumi.Input[_builtins.bool] error_on_column_count_mismatch: Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        :param pulumi.Input[_builtins.str] escape: Single character string used as the escape character for field values.
        :param pulumi.Input[_builtins.str] escape_unenclosed_field: Single character string used as the escape character for unenclosed field values only.
        :param pulumi.Input[_builtins.str] field_delimiter: Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[_builtins.str] field_optionally_enclosed_by: Character used to enclose strings.
        :param pulumi.Input[_builtins.str] file_extension: Specifies the extension for files unloaded to a stage.
        :param pulumi.Input[_builtins.str] format_type: Specifies the format of the input files (for data loading) or output files (for data unloading).
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.bool] ignore_utf8_errors: Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] null_ifs: String used to convert to and from SQL NULL.
        :param pulumi.Input[_builtins.bool] parse_header: Boolean that specifies whether to use the first row headers in the data files to determine column names.
        :param pulumi.Input[_builtins.bool] preserve_space: Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        :param pulumi.Input[_builtins.str] record_delimiter: Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[_builtins.bool] replace_invalid_characters: Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the file format.
        :param pulumi.Input[_builtins.bool] skip_blank_lines: Boolean that specifies to skip any blank lines encountered in the data files.
        :param pulumi.Input[_builtins.bool] skip_byte_order_mark: Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        :param pulumi.Input[_builtins.int] skip_header: Number of lines at the start of the file to skip.
        :param pulumi.Input[_builtins.bool] strip_null_values: Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        :param pulumi.Input[_builtins.bool] strip_outer_array: Boolean that instructs the JSON parser to remove outer brackets.
        :param pulumi.Input[_builtins.bool] strip_outer_element: Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        :param pulumi.Input[_builtins.str] time_format: Defines the format of time values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.str] timestamp_format: Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[_builtins.bool] trim_space: Boolean that specifies whether to remove white space from fields.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileFormatState.__new__(_FileFormatState)

        __props__.__dict__["allow_duplicate"] = allow_duplicate
        __props__.__dict__["binary_as_text"] = binary_as_text
        __props__.__dict__["binary_format"] = binary_format
        __props__.__dict__["comment"] = comment
        __props__.__dict__["compression"] = compression
        __props__.__dict__["database"] = database
        __props__.__dict__["date_format"] = date_format
        __props__.__dict__["disable_auto_convert"] = disable_auto_convert
        __props__.__dict__["disable_snowflake_data"] = disable_snowflake_data
        __props__.__dict__["empty_field_as_null"] = empty_field_as_null
        __props__.__dict__["enable_octal"] = enable_octal
        __props__.__dict__["encoding"] = encoding
        __props__.__dict__["error_on_column_count_mismatch"] = error_on_column_count_mismatch
        __props__.__dict__["escape"] = escape
        __props__.__dict__["escape_unenclosed_field"] = escape_unenclosed_field
        __props__.__dict__["field_delimiter"] = field_delimiter
        __props__.__dict__["field_optionally_enclosed_by"] = field_optionally_enclosed_by
        __props__.__dict__["file_extension"] = file_extension
        __props__.__dict__["format_type"] = format_type
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["ignore_utf8_errors"] = ignore_utf8_errors
        __props__.__dict__["name"] = name
        __props__.__dict__["null_ifs"] = null_ifs
        __props__.__dict__["parse_header"] = parse_header
        __props__.__dict__["preserve_space"] = preserve_space
        __props__.__dict__["record_delimiter"] = record_delimiter
        __props__.__dict__["replace_invalid_characters"] = replace_invalid_characters
        __props__.__dict__["schema"] = schema
        __props__.__dict__["skip_blank_lines"] = skip_blank_lines
        __props__.__dict__["skip_byte_order_mark"] = skip_byte_order_mark
        __props__.__dict__["skip_header"] = skip_header
        __props__.__dict__["strip_null_values"] = strip_null_values
        __props__.__dict__["strip_outer_array"] = strip_outer_array
        __props__.__dict__["strip_outer_element"] = strip_outer_element
        __props__.__dict__["time_format"] = time_format
        __props__.__dict__["timestamp_format"] = timestamp_format
        __props__.__dict__["trim_space"] = trim_space
        return FileFormat(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowDuplicate")
    def allow_duplicate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        """
        return pulumi.get(self, "allow_duplicate")

    @_builtins.property
    @pulumi.getter(name="binaryAsText")
    def binary_as_text(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        """
        return pulumi.get(self, "binary_as_text")

    @_builtins.property
    @pulumi.getter(name="binaryFormat")
    def binary_format(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the encoding format for binary input or output.
        """
        return pulumi.get(self, "binary_format")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the file format.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def compression(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the current compression algorithm for the data file.
        """
        return pulumi.get(self, "compression")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the file format.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the format of date values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "date_format")

    @_builtins.property
    @pulumi.getter(name="disableAutoConvert")
    def disable_auto_convert(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        """
        return pulumi.get(self, "disable_auto_convert")

    @_builtins.property
    @pulumi.getter(name="disableSnowflakeData")
    def disable_snowflake_data(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        """
        return pulumi.get(self, "disable_snowflake_data")

    @_builtins.property
    @pulumi.getter(name="emptyFieldAsNull")
    def empty_field_as_null(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        """
        return pulumi.get(self, "empty_field_as_null")

    @_builtins.property
    @pulumi.getter(name="enableOctal")
    def enable_octal(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that enables parsing of octal numbers.
        """
        return pulumi.get(self, "enable_octal")

    @_builtins.property
    @pulumi.getter
    def encoding(self) -> pulumi.Output[_builtins.str]:
        """
        String (constant) that specifies the character set of the source data when loading data into a table.
        """
        return pulumi.get(self, "encoding")

    @_builtins.property
    @pulumi.getter(name="errorOnColumnCountMismatch")
    def error_on_column_count_mismatch(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        """
        return pulumi.get(self, "error_on_column_count_mismatch")

    @_builtins.property
    @pulumi.getter
    def escape(self) -> pulumi.Output[_builtins.str]:
        """
        Single character string used as the escape character for field values.
        """
        return pulumi.get(self, "escape")

    @_builtins.property
    @pulumi.getter(name="escapeUnenclosedField")
    def escape_unenclosed_field(self) -> pulumi.Output[_builtins.str]:
        """
        Single character string used as the escape character for unenclosed field values only.
        """
        return pulumi.get(self, "escape_unenclosed_field")

    @_builtins.property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "field_delimiter")

    @_builtins.property
    @pulumi.getter(name="fieldOptionallyEnclosedBy")
    def field_optionally_enclosed_by(self) -> pulumi.Output[_builtins.str]:
        """
        Character used to enclose strings.
        """
        return pulumi.get(self, "field_optionally_enclosed_by")

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the extension for files unloaded to a stage.
        """
        return pulumi.get(self, "file_extension")

    @_builtins.property
    @pulumi.getter(name="formatType")
    def format_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the format of the input files (for data loading) or output files (for data unloading).
        """
        return pulumi.get(self, "format_type")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter(name="ignoreUtf8Errors")
    def ignore_utf8_errors(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        """
        return pulumi.get(self, "ignore_utf8_errors")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nullIfs")
    def null_ifs(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        String used to convert to and from SQL NULL.
        """
        return pulumi.get(self, "null_ifs")

    @_builtins.property
    @pulumi.getter(name="parseHeader")
    def parse_header(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies whether to use the first row headers in the data files to determine column names.
        """
        return pulumi.get(self, "parse_header")

    @_builtins.property
    @pulumi.getter(name="preserveSpace")
    def preserve_space(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        """
        return pulumi.get(self, "preserve_space")

    @_builtins.property
    @pulumi.getter(name="recordDelimiter")
    def record_delimiter(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "record_delimiter")

    @_builtins.property
    @pulumi.getter(name="replaceInvalidCharacters")
    def replace_invalid_characters(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        """
        return pulumi.get(self, "replace_invalid_characters")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the file format.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="skipBlankLines")
    def skip_blank_lines(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies to skip any blank lines encountered in the data files.
        """
        return pulumi.get(self, "skip_blank_lines")

    @_builtins.property
    @pulumi.getter(name="skipByteOrderMark")
    def skip_byte_order_mark(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        """
        return pulumi.get(self, "skip_byte_order_mark")

    @_builtins.property
    @pulumi.getter(name="skipHeader")
    def skip_header(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of lines at the start of the file to skip.
        """
        return pulumi.get(self, "skip_header")

    @_builtins.property
    @pulumi.getter(name="stripNullValues")
    def strip_null_values(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        """
        return pulumi.get(self, "strip_null_values")

    @_builtins.property
    @pulumi.getter(name="stripOuterArray")
    def strip_outer_array(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that instructs the JSON parser to remove outer brackets.
        """
        return pulumi.get(self, "strip_outer_array")

    @_builtins.property
    @pulumi.getter(name="stripOuterElement")
    def strip_outer_element(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        """
        return pulumi.get(self, "strip_outer_element")

    @_builtins.property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the format of time values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "time_format")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "timestamp_format")

    @_builtins.property
    @pulumi.getter(name="trimSpace")
    def trim_space(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that specifies whether to remove white space from fields.
        """
        return pulumi.get(self, "trim_space")

