# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GrantPrivilegesToShareArgs', 'GrantPrivilegesToShare']

@pulumi.input_type
class GrantPrivilegesToShareArgs:
    def __init__(__self__, *,
                 privileges: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 to_share: pulumi.Input[_builtins.str],
                 on_all_tables_in_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 on_database: Optional[pulumi.Input[_builtins.str]] = None,
                 on_function: Optional[pulumi.Input[_builtins.str]] = None,
                 on_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 on_table: Optional[pulumi.Input[_builtins.str]] = None,
                 on_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 on_view: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GrantPrivilegesToShare resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] privileges: The privileges to grant on the share. See available list of privileges: https://docs.snowflake.com/en/sql-reference/sql/grant-privilege-share#syntax
        :param pulumi.Input[_builtins.str] to_share: The fully qualified name of the share on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_all_tables_in_schema: The fully qualified identifier for the schema for which the specified privilege will be granted for all tables.
        :param pulumi.Input[_builtins.str] on_database: The fully qualified name of the database on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_function: The fully qualified name of the function on which privileges will be granted.
        :param pulumi.Input[_builtins.str] on_schema: The fully qualified name of the schema on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_table: The fully qualified name of the table on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_tag: The fully qualified name of the tag on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_view: The fully qualified name of the view on which privileges will be granted. For more information about this resource, see docs.
        """
        pulumi.set(__self__, "privileges", privileges)
        pulumi.set(__self__, "to_share", to_share)
        if on_all_tables_in_schema is not None:
            pulumi.set(__self__, "on_all_tables_in_schema", on_all_tables_in_schema)
        if on_database is not None:
            pulumi.set(__self__, "on_database", on_database)
        if on_function is not None:
            pulumi.set(__self__, "on_function", on_function)
        if on_schema is not None:
            pulumi.set(__self__, "on_schema", on_schema)
        if on_table is not None:
            pulumi.set(__self__, "on_table", on_table)
        if on_tag is not None:
            pulumi.set(__self__, "on_tag", on_tag)
        if on_view is not None:
            pulumi.set(__self__, "on_view", on_view)

    @_builtins.property
    @pulumi.getter
    def privileges(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The privileges to grant on the share. See available list of privileges: https://docs.snowflake.com/en/sql-reference/sql/grant-privilege-share#syntax
        """
        return pulumi.get(self, "privileges")

    @privileges.setter
    def privileges(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "privileges", value)

    @_builtins.property
    @pulumi.getter(name="toShare")
    def to_share(self) -> pulumi.Input[_builtins.str]:
        """
        The fully qualified name of the share on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "to_share")

    @to_share.setter
    def to_share(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "to_share", value)

    @_builtins.property
    @pulumi.getter(name="onAllTablesInSchema")
    def on_all_tables_in_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified identifier for the schema for which the specified privilege will be granted for all tables.
        """
        return pulumi.get(self, "on_all_tables_in_schema")

    @on_all_tables_in_schema.setter
    def on_all_tables_in_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_all_tables_in_schema", value)

    @_builtins.property
    @pulumi.getter(name="onDatabase")
    def on_database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the database on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_database")

    @on_database.setter
    def on_database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_database", value)

    @_builtins.property
    @pulumi.getter(name="onFunction")
    def on_function(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the function on which privileges will be granted.
        """
        return pulumi.get(self, "on_function")

    @on_function.setter
    def on_function(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_function", value)

    @_builtins.property
    @pulumi.getter(name="onSchema")
    def on_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the schema on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_schema")

    @on_schema.setter
    def on_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_schema", value)

    @_builtins.property
    @pulumi.getter(name="onTable")
    def on_table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the table on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_table")

    @on_table.setter
    def on_table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_table", value)

    @_builtins.property
    @pulumi.getter(name="onTag")
    def on_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the tag on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_tag")

    @on_tag.setter
    def on_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_tag", value)

    @_builtins.property
    @pulumi.getter(name="onView")
    def on_view(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the view on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_view")

    @on_view.setter
    def on_view(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_view", value)


@pulumi.input_type
class _GrantPrivilegesToShareState:
    def __init__(__self__, *,
                 on_all_tables_in_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 on_database: Optional[pulumi.Input[_builtins.str]] = None,
                 on_function: Optional[pulumi.Input[_builtins.str]] = None,
                 on_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 on_table: Optional[pulumi.Input[_builtins.str]] = None,
                 on_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 on_view: Optional[pulumi.Input[_builtins.str]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 to_share: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GrantPrivilegesToShare resources.
        :param pulumi.Input[_builtins.str] on_all_tables_in_schema: The fully qualified identifier for the schema for which the specified privilege will be granted for all tables.
        :param pulumi.Input[_builtins.str] on_database: The fully qualified name of the database on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_function: The fully qualified name of the function on which privileges will be granted.
        :param pulumi.Input[_builtins.str] on_schema: The fully qualified name of the schema on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_table: The fully qualified name of the table on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_tag: The fully qualified name of the tag on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_view: The fully qualified name of the view on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] privileges: The privileges to grant on the share. See available list of privileges: https://docs.snowflake.com/en/sql-reference/sql/grant-privilege-share#syntax
        :param pulumi.Input[_builtins.str] to_share: The fully qualified name of the share on which privileges will be granted. For more information about this resource, see docs.
        """
        if on_all_tables_in_schema is not None:
            pulumi.set(__self__, "on_all_tables_in_schema", on_all_tables_in_schema)
        if on_database is not None:
            pulumi.set(__self__, "on_database", on_database)
        if on_function is not None:
            pulumi.set(__self__, "on_function", on_function)
        if on_schema is not None:
            pulumi.set(__self__, "on_schema", on_schema)
        if on_table is not None:
            pulumi.set(__self__, "on_table", on_table)
        if on_tag is not None:
            pulumi.set(__self__, "on_tag", on_tag)
        if on_view is not None:
            pulumi.set(__self__, "on_view", on_view)
        if privileges is not None:
            pulumi.set(__self__, "privileges", privileges)
        if to_share is not None:
            pulumi.set(__self__, "to_share", to_share)

    @_builtins.property
    @pulumi.getter(name="onAllTablesInSchema")
    def on_all_tables_in_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified identifier for the schema for which the specified privilege will be granted for all tables.
        """
        return pulumi.get(self, "on_all_tables_in_schema")

    @on_all_tables_in_schema.setter
    def on_all_tables_in_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_all_tables_in_schema", value)

    @_builtins.property
    @pulumi.getter(name="onDatabase")
    def on_database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the database on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_database")

    @on_database.setter
    def on_database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_database", value)

    @_builtins.property
    @pulumi.getter(name="onFunction")
    def on_function(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the function on which privileges will be granted.
        """
        return pulumi.get(self, "on_function")

    @on_function.setter
    def on_function(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_function", value)

    @_builtins.property
    @pulumi.getter(name="onSchema")
    def on_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the schema on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_schema")

    @on_schema.setter
    def on_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_schema", value)

    @_builtins.property
    @pulumi.getter(name="onTable")
    def on_table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the table on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_table")

    @on_table.setter
    def on_table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_table", value)

    @_builtins.property
    @pulumi.getter(name="onTag")
    def on_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the tag on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_tag")

    @on_tag.setter
    def on_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_tag", value)

    @_builtins.property
    @pulumi.getter(name="onView")
    def on_view(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the view on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_view")

    @on_view.setter
    def on_view(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_view", value)

    @_builtins.property
    @pulumi.getter
    def privileges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The privileges to grant on the share. See available list of privileges: https://docs.snowflake.com/en/sql-reference/sql/grant-privilege-share#syntax
        """
        return pulumi.get(self, "privileges")

    @privileges.setter
    def privileges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "privileges", value)

    @_builtins.property
    @pulumi.getter(name="toShare")
    def to_share(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the share on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "to_share")

    @to_share.setter
    def to_share(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "to_share", value)


@pulumi.type_token("snowflake:index/grantPrivilegesToShare:GrantPrivilegesToShare")
class GrantPrivilegesToShare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 on_all_tables_in_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 on_database: Optional[pulumi.Input[_builtins.str]] = None,
                 on_function: Optional[pulumi.Input[_builtins.str]] = None,
                 on_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 on_table: Optional[pulumi.Input[_builtins.str]] = None,
                 on_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 on_view: Optional[pulumi.Input[_builtins.str]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 to_share: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ### OnView

        ```sh
        $ pulumi import snowflake:index/grantPrivilegesToShare:GrantPrivilegesToShare example '<share_name>|<privileges>|OnView|<database_name>.<schema_name>.<view_name>'`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] on_all_tables_in_schema: The fully qualified identifier for the schema for which the specified privilege will be granted for all tables.
        :param pulumi.Input[_builtins.str] on_database: The fully qualified name of the database on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_function: The fully qualified name of the function on which privileges will be granted.
        :param pulumi.Input[_builtins.str] on_schema: The fully qualified name of the schema on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_table: The fully qualified name of the table on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_tag: The fully qualified name of the tag on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_view: The fully qualified name of the view on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] privileges: The privileges to grant on the share. See available list of privileges: https://docs.snowflake.com/en/sql-reference/sql/grant-privilege-share#syntax
        :param pulumi.Input[_builtins.str] to_share: The fully qualified name of the share on which privileges will be granted. For more information about this resource, see docs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrantPrivilegesToShareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ### OnView

        ```sh
        $ pulumi import snowflake:index/grantPrivilegesToShare:GrantPrivilegesToShare example '<share_name>|<privileges>|OnView|<database_name>.<schema_name>.<view_name>'`
        ```

        :param str resource_name: The name of the resource.
        :param GrantPrivilegesToShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrantPrivilegesToShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 on_all_tables_in_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 on_database: Optional[pulumi.Input[_builtins.str]] = None,
                 on_function: Optional[pulumi.Input[_builtins.str]] = None,
                 on_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 on_table: Optional[pulumi.Input[_builtins.str]] = None,
                 on_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 on_view: Optional[pulumi.Input[_builtins.str]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 to_share: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrantPrivilegesToShareArgs.__new__(GrantPrivilegesToShareArgs)

            __props__.__dict__["on_all_tables_in_schema"] = on_all_tables_in_schema
            __props__.__dict__["on_database"] = on_database
            __props__.__dict__["on_function"] = on_function
            __props__.__dict__["on_schema"] = on_schema
            __props__.__dict__["on_table"] = on_table
            __props__.__dict__["on_tag"] = on_tag
            __props__.__dict__["on_view"] = on_view
            if privileges is None and not opts.urn:
                raise TypeError("Missing required property 'privileges'")
            __props__.__dict__["privileges"] = privileges
            if to_share is None and not opts.urn:
                raise TypeError("Missing required property 'to_share'")
            __props__.__dict__["to_share"] = to_share
        super(GrantPrivilegesToShare, __self__).__init__(
            'snowflake:index/grantPrivilegesToShare:GrantPrivilegesToShare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            on_all_tables_in_schema: Optional[pulumi.Input[_builtins.str]] = None,
            on_database: Optional[pulumi.Input[_builtins.str]] = None,
            on_function: Optional[pulumi.Input[_builtins.str]] = None,
            on_schema: Optional[pulumi.Input[_builtins.str]] = None,
            on_table: Optional[pulumi.Input[_builtins.str]] = None,
            on_tag: Optional[pulumi.Input[_builtins.str]] = None,
            on_view: Optional[pulumi.Input[_builtins.str]] = None,
            privileges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            to_share: Optional[pulumi.Input[_builtins.str]] = None) -> 'GrantPrivilegesToShare':
        """
        Get an existing GrantPrivilegesToShare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] on_all_tables_in_schema: The fully qualified identifier for the schema for which the specified privilege will be granted for all tables.
        :param pulumi.Input[_builtins.str] on_database: The fully qualified name of the database on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_function: The fully qualified name of the function on which privileges will be granted.
        :param pulumi.Input[_builtins.str] on_schema: The fully qualified name of the schema on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_table: The fully qualified name of the table on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_tag: The fully qualified name of the tag on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] on_view: The fully qualified name of the view on which privileges will be granted. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] privileges: The privileges to grant on the share. See available list of privileges: https://docs.snowflake.com/en/sql-reference/sql/grant-privilege-share#syntax
        :param pulumi.Input[_builtins.str] to_share: The fully qualified name of the share on which privileges will be granted. For more information about this resource, see docs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrantPrivilegesToShareState.__new__(_GrantPrivilegesToShareState)

        __props__.__dict__["on_all_tables_in_schema"] = on_all_tables_in_schema
        __props__.__dict__["on_database"] = on_database
        __props__.__dict__["on_function"] = on_function
        __props__.__dict__["on_schema"] = on_schema
        __props__.__dict__["on_table"] = on_table
        __props__.__dict__["on_tag"] = on_tag
        __props__.__dict__["on_view"] = on_view
        __props__.__dict__["privileges"] = privileges
        __props__.__dict__["to_share"] = to_share
        return GrantPrivilegesToShare(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="onAllTablesInSchema")
    def on_all_tables_in_schema(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully qualified identifier for the schema for which the specified privilege will be granted for all tables.
        """
        return pulumi.get(self, "on_all_tables_in_schema")

    @_builtins.property
    @pulumi.getter(name="onDatabase")
    def on_database(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully qualified name of the database on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_database")

    @_builtins.property
    @pulumi.getter(name="onFunction")
    def on_function(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully qualified name of the function on which privileges will be granted.
        """
        return pulumi.get(self, "on_function")

    @_builtins.property
    @pulumi.getter(name="onSchema")
    def on_schema(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully qualified name of the schema on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_schema")

    @_builtins.property
    @pulumi.getter(name="onTable")
    def on_table(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully qualified name of the table on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_table")

    @_builtins.property
    @pulumi.getter(name="onTag")
    def on_tag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully qualified name of the tag on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_tag")

    @_builtins.property
    @pulumi.getter(name="onView")
    def on_view(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully qualified name of the view on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "on_view")

    @_builtins.property
    @pulumi.getter
    def privileges(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The privileges to grant on the share. See available list of privileges: https://docs.snowflake.com/en/sql-reference/sql/grant-privilege-share#syntax
        """
        return pulumi.get(self, "privileges")

    @_builtins.property
    @pulumi.getter(name="toShare")
    def to_share(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the share on which privileges will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "to_share")

