# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OauthIntegrationForCustomClientsArgs', 'OauthIntegrationForCustomClients']

@pulumi.input_type
class OauthIntegrationForCustomClientsArgs:
    def __init__(__self__, *,
                 oauth_client_type: pulumi.Input[_builtins.str],
                 oauth_redirect_uri: pulumi.Input[_builtins.str],
                 blocked_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_allow_non_tls_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_rsa_public_key2: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_enforce_pkce: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_issue_refresh_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_refresh_token_validity: Optional[pulumi.Input[_builtins.int]] = None,
                 oauth_use_secondary_roles: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_authorized_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a OauthIntegrationForCustomClients resource.
        :param pulumi.Input[_builtins.str] oauth_client_type: Specifies the type of client being registered. Snowflake supports both confidential and public clients. Valid options are: `PUBLIC` | `CONFIDENTIAL`.
        :param pulumi.Input[_builtins.str] oauth_redirect_uri: Specifies the client URI. After a user is authenticated, the web browser is redirected to this URI.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_roles_lists: A set of Snowflake roles that a user cannot explicitly consent to using after authenticating. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the OAuth integration.
        :param pulumi.Input[_builtins.str] enabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this OAuth integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the OAuth integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] network_policy: Specifies an existing network policy. This network policy controls network traffic that is attempting to exchange an authorization code for an access or refresh token or to use a refresh token to obtain a new access token. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] oauth_allow_non_tls_redirect_uri: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) If true, allows setting oauth*redirect*uri to a URI not protected by TLS. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] oauth_enforce_pkce: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Boolean that specifies whether Proof Key for Code Exchange (PKCE) should be required for the integration. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] oauth_issue_refresh_tokens: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to allow the client to exchange a refresh token for an access token when the current access token has expired. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] oauth_refresh_token_validity: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies how long refresh tokens should be valid (in seconds). OAUTH*ISSUE*REFRESH_TOKENS must be set to TRUE.
        :param pulumi.Input[_builtins.str] oauth_use_secondary_roles: Specifies whether default secondary roles set in the user properties are activated by default in the session being opened. Valid options are: `IMPLICIT` | `NONE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pre_authorized_roles_lists: A set of Snowflake roles that a user does not need to explicitly consent to using after authenticating. For more information about this resource, see docs.
        """
        pulumi.set(__self__, "oauth_client_type", oauth_client_type)
        pulumi.set(__self__, "oauth_redirect_uri", oauth_redirect_uri)
        if blocked_roles_lists is not None:
            pulumi.set(__self__, "blocked_roles_lists", blocked_roles_lists)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_policy is not None:
            pulumi.set(__self__, "network_policy", network_policy)
        if oauth_allow_non_tls_redirect_uri is not None:
            pulumi.set(__self__, "oauth_allow_non_tls_redirect_uri", oauth_allow_non_tls_redirect_uri)
        if oauth_client_rsa_public_key is not None:
            pulumi.set(__self__, "oauth_client_rsa_public_key", oauth_client_rsa_public_key)
        if oauth_client_rsa_public_key2 is not None:
            pulumi.set(__self__, "oauth_client_rsa_public_key2", oauth_client_rsa_public_key2)
        if oauth_enforce_pkce is not None:
            pulumi.set(__self__, "oauth_enforce_pkce", oauth_enforce_pkce)
        if oauth_issue_refresh_tokens is not None:
            pulumi.set(__self__, "oauth_issue_refresh_tokens", oauth_issue_refresh_tokens)
        if oauth_refresh_token_validity is not None:
            pulumi.set(__self__, "oauth_refresh_token_validity", oauth_refresh_token_validity)
        if oauth_use_secondary_roles is not None:
            pulumi.set(__self__, "oauth_use_secondary_roles", oauth_use_secondary_roles)
        if pre_authorized_roles_lists is not None:
            pulumi.set(__self__, "pre_authorized_roles_lists", pre_authorized_roles_lists)

    @_builtins.property
    @pulumi.getter(name="oauthClientType")
    def oauth_client_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of client being registered. Snowflake supports both confidential and public clients. Valid options are: `PUBLIC` | `CONFIDENTIAL`.
        """
        return pulumi.get(self, "oauth_client_type")

    @oauth_client_type.setter
    def oauth_client_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oauth_client_type", value)

    @_builtins.property
    @pulumi.getter(name="oauthRedirectUri")
    def oauth_redirect_uri(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the client URI. After a user is authenticated, the web browser is redirected to this URI.
        """
        return pulumi.get(self, "oauth_redirect_uri")

    @oauth_redirect_uri.setter
    def oauth_redirect_uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oauth_redirect_uri", value)

    @_builtins.property
    @pulumi.getter(name="blockedRolesLists")
    def blocked_roles_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of Snowflake roles that a user cannot explicitly consent to using after authenticating. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        """
        return pulumi.get(self, "blocked_roles_lists")

    @blocked_roles_lists.setter
    def blocked_roles_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blocked_roles_lists", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the OAuth integration.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this OAuth integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the OAuth integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an existing network policy. This network policy controls network traffic that is attempting to exchange an authorization code for an access or refresh token or to use a refresh token to obtain a new access token. For more information about this resource, see docs.
        """
        return pulumi.get(self, "network_policy")

    @network_policy.setter
    def network_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_policy", value)

    @_builtins.property
    @pulumi.getter(name="oauthAllowNonTlsRedirectUri")
    def oauth_allow_non_tls_redirect_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) If true, allows setting oauth*redirect*uri to a URI not protected by TLS. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "oauth_allow_non_tls_redirect_uri")

    @oauth_allow_non_tls_redirect_uri.setter
    def oauth_allow_non_tls_redirect_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_allow_non_tls_redirect_uri", value)

    @_builtins.property
    @pulumi.getter(name="oauthClientRsaPublicKey")
    def oauth_client_rsa_public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "oauth_client_rsa_public_key")

    @oauth_client_rsa_public_key.setter
    def oauth_client_rsa_public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_client_rsa_public_key", value)

    @_builtins.property
    @pulumi.getter(name="oauthClientRsaPublicKey2")
    def oauth_client_rsa_public_key2(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "oauth_client_rsa_public_key2")

    @oauth_client_rsa_public_key2.setter
    def oauth_client_rsa_public_key2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_client_rsa_public_key2", value)

    @_builtins.property
    @pulumi.getter(name="oauthEnforcePkce")
    def oauth_enforce_pkce(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Boolean that specifies whether Proof Key for Code Exchange (PKCE) should be required for the integration. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "oauth_enforce_pkce")

    @oauth_enforce_pkce.setter
    def oauth_enforce_pkce(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_enforce_pkce", value)

    @_builtins.property
    @pulumi.getter(name="oauthIssueRefreshTokens")
    def oauth_issue_refresh_tokens(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to allow the client to exchange a refresh token for an access token when the current access token has expired. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "oauth_issue_refresh_tokens")

    @oauth_issue_refresh_tokens.setter
    def oauth_issue_refresh_tokens(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_issue_refresh_tokens", value)

    @_builtins.property
    @pulumi.getter(name="oauthRefreshTokenValidity")
    def oauth_refresh_token_validity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies how long refresh tokens should be valid (in seconds). OAUTH*ISSUE*REFRESH_TOKENS must be set to TRUE.
        """
        return pulumi.get(self, "oauth_refresh_token_validity")

    @oauth_refresh_token_validity.setter
    def oauth_refresh_token_validity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "oauth_refresh_token_validity", value)

    @_builtins.property
    @pulumi.getter(name="oauthUseSecondaryRoles")
    def oauth_use_secondary_roles(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether default secondary roles set in the user properties are activated by default in the session being opened. Valid options are: `IMPLICIT` | `NONE`.
        """
        return pulumi.get(self, "oauth_use_secondary_roles")

    @oauth_use_secondary_roles.setter
    def oauth_use_secondary_roles(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_use_secondary_roles", value)

    @_builtins.property
    @pulumi.getter(name="preAuthorizedRolesLists")
    def pre_authorized_roles_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of Snowflake roles that a user does not need to explicitly consent to using after authenticating. For more information about this resource, see docs.
        """
        return pulumi.get(self, "pre_authorized_roles_lists")

    @pre_authorized_roles_lists.setter
    def pre_authorized_roles_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pre_authorized_roles_lists", value)


@pulumi.input_type
class _OauthIntegrationForCustomClientsState:
    def __init__(__self__, *,
                 blocked_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsDescribeOutputArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_allow_non_tls_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_rsa_public_key2: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_enforce_pkce: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_issue_refresh_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_refresh_token_validity: Optional[pulumi.Input[_builtins.int]] = None,
                 oauth_use_secondary_roles: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_authorized_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 related_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsRelatedParameterArgs']]]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsShowOutputArgs']]]] = None):
        """
        Input properties used for looking up and filtering OauthIntegrationForCustomClients resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_roles_lists: A set of Snowflake roles that a user cannot explicitly consent to using after authenticating. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the OAuth integration.
        :param pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsDescribeOutputArgs']]] describe_outputs: Outputs the result of `DESCRIBE SECURITY INTEGRATION` for the given integration.
        :param pulumi.Input[_builtins.str] enabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this OAuth integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the OAuth integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] network_policy: Specifies an existing network policy. This network policy controls network traffic that is attempting to exchange an authorization code for an access or refresh token or to use a refresh token to obtain a new access token. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] oauth_allow_non_tls_redirect_uri: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) If true, allows setting oauth*redirect*uri to a URI not protected by TLS. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] oauth_client_type: Specifies the type of client being registered. Snowflake supports both confidential and public clients. Valid options are: `PUBLIC` | `CONFIDENTIAL`.
        :param pulumi.Input[_builtins.str] oauth_enforce_pkce: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Boolean that specifies whether Proof Key for Code Exchange (PKCE) should be required for the integration. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] oauth_issue_refresh_tokens: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to allow the client to exchange a refresh token for an access token when the current access token has expired. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] oauth_redirect_uri: Specifies the client URI. After a user is authenticated, the web browser is redirected to this URI.
        :param pulumi.Input[_builtins.int] oauth_refresh_token_validity: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies how long refresh tokens should be valid (in seconds). OAUTH*ISSUE*REFRESH_TOKENS must be set to TRUE.
        :param pulumi.Input[_builtins.str] oauth_use_secondary_roles: Specifies whether default secondary roles set in the user properties are activated by default in the session being opened. Valid options are: `IMPLICIT` | `NONE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pre_authorized_roles_lists: A set of Snowflake roles that a user does not need to explicitly consent to using after authenticating. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsRelatedParameterArgs']]] related_parameters: Parameters related to this security integration.
        :param pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsShowOutputArgs']]] show_outputs: Outputs the result of `SHOW SECURITY INTEGRATION` for the given integration.
        """
        if blocked_roles_lists is not None:
            pulumi.set(__self__, "blocked_roles_lists", blocked_roles_lists)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if describe_outputs is not None:
            pulumi.set(__self__, "describe_outputs", describe_outputs)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_policy is not None:
            pulumi.set(__self__, "network_policy", network_policy)
        if oauth_allow_non_tls_redirect_uri is not None:
            pulumi.set(__self__, "oauth_allow_non_tls_redirect_uri", oauth_allow_non_tls_redirect_uri)
        if oauth_client_rsa_public_key is not None:
            pulumi.set(__self__, "oauth_client_rsa_public_key", oauth_client_rsa_public_key)
        if oauth_client_rsa_public_key2 is not None:
            pulumi.set(__self__, "oauth_client_rsa_public_key2", oauth_client_rsa_public_key2)
        if oauth_client_type is not None:
            pulumi.set(__self__, "oauth_client_type", oauth_client_type)
        if oauth_enforce_pkce is not None:
            pulumi.set(__self__, "oauth_enforce_pkce", oauth_enforce_pkce)
        if oauth_issue_refresh_tokens is not None:
            pulumi.set(__self__, "oauth_issue_refresh_tokens", oauth_issue_refresh_tokens)
        if oauth_redirect_uri is not None:
            pulumi.set(__self__, "oauth_redirect_uri", oauth_redirect_uri)
        if oauth_refresh_token_validity is not None:
            pulumi.set(__self__, "oauth_refresh_token_validity", oauth_refresh_token_validity)
        if oauth_use_secondary_roles is not None:
            pulumi.set(__self__, "oauth_use_secondary_roles", oauth_use_secondary_roles)
        if pre_authorized_roles_lists is not None:
            pulumi.set(__self__, "pre_authorized_roles_lists", pre_authorized_roles_lists)
        if related_parameters is not None:
            pulumi.set(__self__, "related_parameters", related_parameters)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)

    @_builtins.property
    @pulumi.getter(name="blockedRolesLists")
    def blocked_roles_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of Snowflake roles that a user cannot explicitly consent to using after authenticating. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        """
        return pulumi.get(self, "blocked_roles_lists")

    @blocked_roles_lists.setter
    def blocked_roles_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blocked_roles_lists", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the OAuth integration.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsDescribeOutputArgs']]]]:
        """
        Outputs the result of `DESCRIBE SECURITY INTEGRATION` for the given integration.
        """
        return pulumi.get(self, "describe_outputs")

    @describe_outputs.setter
    def describe_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsDescribeOutputArgs']]]]):
        pulumi.set(self, "describe_outputs", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this OAuth integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the OAuth integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an existing network policy. This network policy controls network traffic that is attempting to exchange an authorization code for an access or refresh token or to use a refresh token to obtain a new access token. For more information about this resource, see docs.
        """
        return pulumi.get(self, "network_policy")

    @network_policy.setter
    def network_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_policy", value)

    @_builtins.property
    @pulumi.getter(name="oauthAllowNonTlsRedirectUri")
    def oauth_allow_non_tls_redirect_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) If true, allows setting oauth*redirect*uri to a URI not protected by TLS. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "oauth_allow_non_tls_redirect_uri")

    @oauth_allow_non_tls_redirect_uri.setter
    def oauth_allow_non_tls_redirect_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_allow_non_tls_redirect_uri", value)

    @_builtins.property
    @pulumi.getter(name="oauthClientRsaPublicKey")
    def oauth_client_rsa_public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "oauth_client_rsa_public_key")

    @oauth_client_rsa_public_key.setter
    def oauth_client_rsa_public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_client_rsa_public_key", value)

    @_builtins.property
    @pulumi.getter(name="oauthClientRsaPublicKey2")
    def oauth_client_rsa_public_key2(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "oauth_client_rsa_public_key2")

    @oauth_client_rsa_public_key2.setter
    def oauth_client_rsa_public_key2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_client_rsa_public_key2", value)

    @_builtins.property
    @pulumi.getter(name="oauthClientType")
    def oauth_client_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of client being registered. Snowflake supports both confidential and public clients. Valid options are: `PUBLIC` | `CONFIDENTIAL`.
        """
        return pulumi.get(self, "oauth_client_type")

    @oauth_client_type.setter
    def oauth_client_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_client_type", value)

    @_builtins.property
    @pulumi.getter(name="oauthEnforcePkce")
    def oauth_enforce_pkce(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Boolean that specifies whether Proof Key for Code Exchange (PKCE) should be required for the integration. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "oauth_enforce_pkce")

    @oauth_enforce_pkce.setter
    def oauth_enforce_pkce(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_enforce_pkce", value)

    @_builtins.property
    @pulumi.getter(name="oauthIssueRefreshTokens")
    def oauth_issue_refresh_tokens(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to allow the client to exchange a refresh token for an access token when the current access token has expired. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "oauth_issue_refresh_tokens")

    @oauth_issue_refresh_tokens.setter
    def oauth_issue_refresh_tokens(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_issue_refresh_tokens", value)

    @_builtins.property
    @pulumi.getter(name="oauthRedirectUri")
    def oauth_redirect_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the client URI. After a user is authenticated, the web browser is redirected to this URI.
        """
        return pulumi.get(self, "oauth_redirect_uri")

    @oauth_redirect_uri.setter
    def oauth_redirect_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_redirect_uri", value)

    @_builtins.property
    @pulumi.getter(name="oauthRefreshTokenValidity")
    def oauth_refresh_token_validity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies how long refresh tokens should be valid (in seconds). OAUTH*ISSUE*REFRESH_TOKENS must be set to TRUE.
        """
        return pulumi.get(self, "oauth_refresh_token_validity")

    @oauth_refresh_token_validity.setter
    def oauth_refresh_token_validity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "oauth_refresh_token_validity", value)

    @_builtins.property
    @pulumi.getter(name="oauthUseSecondaryRoles")
    def oauth_use_secondary_roles(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether default secondary roles set in the user properties are activated by default in the session being opened. Valid options are: `IMPLICIT` | `NONE`.
        """
        return pulumi.get(self, "oauth_use_secondary_roles")

    @oauth_use_secondary_roles.setter
    def oauth_use_secondary_roles(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_use_secondary_roles", value)

    @_builtins.property
    @pulumi.getter(name="preAuthorizedRolesLists")
    def pre_authorized_roles_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of Snowflake roles that a user does not need to explicitly consent to using after authenticating. For more information about this resource, see docs.
        """
        return pulumi.get(self, "pre_authorized_roles_lists")

    @pre_authorized_roles_lists.setter
    def pre_authorized_roles_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pre_authorized_roles_lists", value)

    @_builtins.property
    @pulumi.getter(name="relatedParameters")
    def related_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsRelatedParameterArgs']]]]:
        """
        Parameters related to this security integration.
        """
        return pulumi.get(self, "related_parameters")

    @related_parameters.setter
    def related_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsRelatedParameterArgs']]]]):
        pulumi.set(self, "related_parameters", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW SECURITY INTEGRATION` for the given integration.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OauthIntegrationForCustomClientsShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)


@pulumi.type_token("snowflake:index/oauthIntegrationForCustomClients:OauthIntegrationForCustomClients")
class OauthIntegrationForCustomClients(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blocked_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_allow_non_tls_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_rsa_public_key2: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_enforce_pkce: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_issue_refresh_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_refresh_token_validity: Optional[pulumi.Input[_builtins.int]] = None,
                 oauth_use_secondary_roles: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_authorized_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/oauthIntegrationForCustomClients:OauthIntegrationForCustomClients example '"<integration_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_roles_lists: A set of Snowflake roles that a user cannot explicitly consent to using after authenticating. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the OAuth integration.
        :param pulumi.Input[_builtins.str] enabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this OAuth integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the OAuth integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] network_policy: Specifies an existing network policy. This network policy controls network traffic that is attempting to exchange an authorization code for an access or refresh token or to use a refresh token to obtain a new access token. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] oauth_allow_non_tls_redirect_uri: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) If true, allows setting oauth*redirect*uri to a URI not protected by TLS. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] oauth_client_type: Specifies the type of client being registered. Snowflake supports both confidential and public clients. Valid options are: `PUBLIC` | `CONFIDENTIAL`.
        :param pulumi.Input[_builtins.str] oauth_enforce_pkce: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Boolean that specifies whether Proof Key for Code Exchange (PKCE) should be required for the integration. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] oauth_issue_refresh_tokens: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to allow the client to exchange a refresh token for an access token when the current access token has expired. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] oauth_redirect_uri: Specifies the client URI. After a user is authenticated, the web browser is redirected to this URI.
        :param pulumi.Input[_builtins.int] oauth_refresh_token_validity: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies how long refresh tokens should be valid (in seconds). OAUTH*ISSUE*REFRESH_TOKENS must be set to TRUE.
        :param pulumi.Input[_builtins.str] oauth_use_secondary_roles: Specifies whether default secondary roles set in the user properties are activated by default in the session being opened. Valid options are: `IMPLICIT` | `NONE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pre_authorized_roles_lists: A set of Snowflake roles that a user does not need to explicitly consent to using after authenticating. For more information about this resource, see docs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OauthIntegrationForCustomClientsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/oauthIntegrationForCustomClients:OauthIntegrationForCustomClients example '"<integration_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param OauthIntegrationForCustomClientsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OauthIntegrationForCustomClientsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blocked_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_allow_non_tls_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_rsa_public_key2: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_enforce_pkce: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_issue_refresh_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_refresh_token_validity: Optional[pulumi.Input[_builtins.int]] = None,
                 oauth_use_secondary_roles: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_authorized_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OauthIntegrationForCustomClientsArgs.__new__(OauthIntegrationForCustomClientsArgs)

            __props__.__dict__["blocked_roles_lists"] = blocked_roles_lists
            __props__.__dict__["comment"] = comment
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["network_policy"] = network_policy
            __props__.__dict__["oauth_allow_non_tls_redirect_uri"] = oauth_allow_non_tls_redirect_uri
            __props__.__dict__["oauth_client_rsa_public_key"] = oauth_client_rsa_public_key
            __props__.__dict__["oauth_client_rsa_public_key2"] = oauth_client_rsa_public_key2
            if oauth_client_type is None and not opts.urn:
                raise TypeError("Missing required property 'oauth_client_type'")
            __props__.__dict__["oauth_client_type"] = oauth_client_type
            __props__.__dict__["oauth_enforce_pkce"] = oauth_enforce_pkce
            __props__.__dict__["oauth_issue_refresh_tokens"] = oauth_issue_refresh_tokens
            if oauth_redirect_uri is None and not opts.urn:
                raise TypeError("Missing required property 'oauth_redirect_uri'")
            __props__.__dict__["oauth_redirect_uri"] = None if oauth_redirect_uri is None else pulumi.Output.secret(oauth_redirect_uri)
            __props__.__dict__["oauth_refresh_token_validity"] = oauth_refresh_token_validity
            __props__.__dict__["oauth_use_secondary_roles"] = oauth_use_secondary_roles
            __props__.__dict__["pre_authorized_roles_lists"] = pre_authorized_roles_lists
            __props__.__dict__["describe_outputs"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["related_parameters"] = None
            __props__.__dict__["show_outputs"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["oauthRedirectUri"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OauthIntegrationForCustomClients, __self__).__init__(
            'snowflake:index/oauthIntegrationForCustomClients:OauthIntegrationForCustomClients',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            blocked_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OauthIntegrationForCustomClientsDescribeOutputArgs', 'OauthIntegrationForCustomClientsDescribeOutputArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_policy: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_allow_non_tls_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_client_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_client_rsa_public_key2: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_client_type: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_enforce_pkce: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_issue_refresh_tokens: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_refresh_token_validity: Optional[pulumi.Input[_builtins.int]] = None,
            oauth_use_secondary_roles: Optional[pulumi.Input[_builtins.str]] = None,
            pre_authorized_roles_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            related_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OauthIntegrationForCustomClientsRelatedParameterArgs', 'OauthIntegrationForCustomClientsRelatedParameterArgsDict']]]]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OauthIntegrationForCustomClientsShowOutputArgs', 'OauthIntegrationForCustomClientsShowOutputArgsDict']]]]] = None) -> 'OauthIntegrationForCustomClients':
        """
        Get an existing OauthIntegrationForCustomClients resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_roles_lists: A set of Snowflake roles that a user cannot explicitly consent to using after authenticating. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the OAuth integration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OauthIntegrationForCustomClientsDescribeOutputArgs', 'OauthIntegrationForCustomClientsDescribeOutputArgsDict']]]] describe_outputs: Outputs the result of `DESCRIBE SECURITY INTEGRATION` for the given integration.
        :param pulumi.Input[_builtins.str] enabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this OAuth integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the OAuth integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] network_policy: Specifies an existing network policy. This network policy controls network traffic that is attempting to exchange an authorization code for an access or refresh token or to use a refresh token to obtain a new access token. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] oauth_allow_non_tls_redirect_uri: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) If true, allows setting oauth*redirect*uri to a URI not protected by TLS. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] oauth_client_type: Specifies the type of client being registered. Snowflake supports both confidential and public clients. Valid options are: `PUBLIC` | `CONFIDENTIAL`.
        :param pulumi.Input[_builtins.str] oauth_enforce_pkce: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Boolean that specifies whether Proof Key for Code Exchange (PKCE) should be required for the integration. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] oauth_issue_refresh_tokens: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to allow the client to exchange a refresh token for an access token when the current access token has expired. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] oauth_redirect_uri: Specifies the client URI. After a user is authenticated, the web browser is redirected to this URI.
        :param pulumi.Input[_builtins.int] oauth_refresh_token_validity: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies how long refresh tokens should be valid (in seconds). OAUTH*ISSUE*REFRESH_TOKENS must be set to TRUE.
        :param pulumi.Input[_builtins.str] oauth_use_secondary_roles: Specifies whether default secondary roles set in the user properties are activated by default in the session being opened. Valid options are: `IMPLICIT` | `NONE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pre_authorized_roles_lists: A set of Snowflake roles that a user does not need to explicitly consent to using after authenticating. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OauthIntegrationForCustomClientsRelatedParameterArgs', 'OauthIntegrationForCustomClientsRelatedParameterArgsDict']]]] related_parameters: Parameters related to this security integration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OauthIntegrationForCustomClientsShowOutputArgs', 'OauthIntegrationForCustomClientsShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW SECURITY INTEGRATION` for the given integration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OauthIntegrationForCustomClientsState.__new__(_OauthIntegrationForCustomClientsState)

        __props__.__dict__["blocked_roles_lists"] = blocked_roles_lists
        __props__.__dict__["comment"] = comment
        __props__.__dict__["describe_outputs"] = describe_outputs
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["name"] = name
        __props__.__dict__["network_policy"] = network_policy
        __props__.__dict__["oauth_allow_non_tls_redirect_uri"] = oauth_allow_non_tls_redirect_uri
        __props__.__dict__["oauth_client_rsa_public_key"] = oauth_client_rsa_public_key
        __props__.__dict__["oauth_client_rsa_public_key2"] = oauth_client_rsa_public_key2
        __props__.__dict__["oauth_client_type"] = oauth_client_type
        __props__.__dict__["oauth_enforce_pkce"] = oauth_enforce_pkce
        __props__.__dict__["oauth_issue_refresh_tokens"] = oauth_issue_refresh_tokens
        __props__.__dict__["oauth_redirect_uri"] = oauth_redirect_uri
        __props__.__dict__["oauth_refresh_token_validity"] = oauth_refresh_token_validity
        __props__.__dict__["oauth_use_secondary_roles"] = oauth_use_secondary_roles
        __props__.__dict__["pre_authorized_roles_lists"] = pre_authorized_roles_lists
        __props__.__dict__["related_parameters"] = related_parameters
        __props__.__dict__["show_outputs"] = show_outputs
        return OauthIntegrationForCustomClients(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="blockedRolesLists")
    def blocked_roles_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A set of Snowflake roles that a user cannot explicitly consent to using after authenticating. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the OAUTH*ADD*PRIVILEGED*ROLES*TO*BLOCKED*LIST account parameter to FALSE. For more information about this resource, see docs.
        """
        return pulumi.get(self, "blocked_roles_lists")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the OAuth integration.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> pulumi.Output[Sequence['outputs.OauthIntegrationForCustomClientsDescribeOutput']]:
        """
        Outputs the result of `DESCRIBE SECURITY INTEGRATION` for the given integration.
        """
        return pulumi.get(self, "describe_outputs")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this OAuth integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the OAuth integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies an existing network policy. This network policy controls network traffic that is attempting to exchange an authorization code for an access or refresh token or to use a refresh token to obtain a new access token. For more information about this resource, see docs.
        """
        return pulumi.get(self, "network_policy")

    @_builtins.property
    @pulumi.getter(name="oauthAllowNonTlsRedirectUri")
    def oauth_allow_non_tls_redirect_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) If true, allows setting oauth*redirect*uri to a URI not protected by TLS. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "oauth_allow_non_tls_redirect_uri")

    @_builtins.property
    @pulumi.getter(name="oauthClientRsaPublicKey")
    def oauth_client_rsa_public_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "oauth_client_rsa_public_key")

    @_builtins.property
    @pulumi.getter(name="oauthClientRsaPublicKey2")
    def oauth_client_rsa_public_key2(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "oauth_client_rsa_public_key2")

    @_builtins.property
    @pulumi.getter(name="oauthClientType")
    def oauth_client_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of client being registered. Snowflake supports both confidential and public clients. Valid options are: `PUBLIC` | `CONFIDENTIAL`.
        """
        return pulumi.get(self, "oauth_client_type")

    @_builtins.property
    @pulumi.getter(name="oauthEnforcePkce")
    def oauth_enforce_pkce(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Boolean that specifies whether Proof Key for Code Exchange (PKCE) should be required for the integration. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "oauth_enforce_pkce")

    @_builtins.property
    @pulumi.getter(name="oauthIssueRefreshTokens")
    def oauth_issue_refresh_tokens(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to allow the client to exchange a refresh token for an access token when the current access token has expired. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "oauth_issue_refresh_tokens")

    @_builtins.property
    @pulumi.getter(name="oauthRedirectUri")
    def oauth_redirect_uri(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the client URI. After a user is authenticated, the web browser is redirected to this URI.
        """
        return pulumi.get(self, "oauth_redirect_uri")

    @_builtins.property
    @pulumi.getter(name="oauthRefreshTokenValidity")
    def oauth_refresh_token_validity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies how long refresh tokens should be valid (in seconds). OAUTH*ISSUE*REFRESH_TOKENS must be set to TRUE.
        """
        return pulumi.get(self, "oauth_refresh_token_validity")

    @_builtins.property
    @pulumi.getter(name="oauthUseSecondaryRoles")
    def oauth_use_secondary_roles(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether default secondary roles set in the user properties are activated by default in the session being opened. Valid options are: `IMPLICIT` | `NONE`.
        """
        return pulumi.get(self, "oauth_use_secondary_roles")

    @_builtins.property
    @pulumi.getter(name="preAuthorizedRolesLists")
    def pre_authorized_roles_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A set of Snowflake roles that a user does not need to explicitly consent to using after authenticating. For more information about this resource, see docs.
        """
        return pulumi.get(self, "pre_authorized_roles_lists")

    @_builtins.property
    @pulumi.getter(name="relatedParameters")
    def related_parameters(self) -> pulumi.Output[Sequence['outputs.OauthIntegrationForCustomClientsRelatedParameter']]:
        """
        Parameters related to this security integration.
        """
        return pulumi.get(self, "related_parameters")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.OauthIntegrationForCustomClientsShowOutput']]:
        """
        Outputs the result of `SHOW SECURITY INTEGRATION` for the given integration.
        """
        return pulumi.get(self, "show_outputs")

