# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamOnExternalTableArgs', 'StreamOnExternalTable']

@pulumi.input_type
class StreamOnExternalTableArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 external_table: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 at: Optional[pulumi.Input['StreamOnExternalTableAtArgs']] = None,
                 before: Optional[pulumi.Input['StreamOnExternalTableBeforeArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 insert_only: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StreamOnExternalTable resource.
        :param pulumi.Input[_builtins.str] database: The database in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] external_table: Specifies an identifier for the external table the stream will monitor. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the stream.
        :param pulumi.Input[_builtins.str] insert_only: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this is an insert-only stream. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the stream; must be unique for the database and schema in which the stream is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "external_table", external_table)
        pulumi.set(__self__, "schema", schema)
        if at is not None:
            pulumi.set(__self__, "at", at)
        if before is not None:
            pulumi.set(__self__, "before", before)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if copy_grants is not None:
            pulumi.set(__self__, "copy_grants", copy_grants)
        if insert_only is not None:
            pulumi.set(__self__, "insert_only", insert_only)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="externalTable")
    def external_table(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies an identifier for the external table the stream will monitor. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        """
        return pulumi.get(self, "external_table")

    @external_table.setter
    def external_table(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_table", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter
    def at(self) -> Optional[pulumi.Input['StreamOnExternalTableAtArgs']]:
        return pulumi.get(self, "at")

    @at.setter
    def at(self, value: Optional[pulumi.Input['StreamOnExternalTableAtArgs']]):
        pulumi.set(self, "at", value)

    @_builtins.property
    @pulumi.getter
    def before(self) -> Optional[pulumi.Input['StreamOnExternalTableBeforeArgs']]:
        return pulumi.get(self, "before")

    @before.setter
    def before(self, value: Optional[pulumi.Input['StreamOnExternalTableBeforeArgs']]):
        pulumi.set(self, "before", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the stream.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "copy_grants")

    @copy_grants.setter
    def copy_grants(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_grants", value)

    @_builtins.property
    @pulumi.getter(name="insertOnly")
    def insert_only(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this is an insert-only stream. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "insert_only")

    @insert_only.setter
    def insert_only(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "insert_only", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the stream; must be unique for the database and schema in which the stream is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _StreamOnExternalTableState:
    def __init__(__self__, *,
                 at: Optional[pulumi.Input['StreamOnExternalTableAtArgs']] = None,
                 before: Optional[pulumi.Input['StreamOnExternalTableBeforeArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['StreamOnExternalTableDescribeOutputArgs']]]] = None,
                 external_table: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 insert_only: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['StreamOnExternalTableShowOutputArgs']]]] = None,
                 stale: Optional[pulumi.Input[_builtins.bool]] = None,
                 stream_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StreamOnExternalTable resources.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the stream.
        :param pulumi.Input[_builtins.str] database: The database in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['StreamOnExternalTableDescribeOutputArgs']]] describe_outputs: Outputs the result of `DESCRIBE STREAM` for the given stream.
        :param pulumi.Input[_builtins.str] external_table: Specifies an identifier for the external table the stream will monitor. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] insert_only: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this is an insert-only stream. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the stream; must be unique for the database and schema in which the stream is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['StreamOnExternalTableShowOutputArgs']]] show_outputs: Outputs the result of `SHOW STREAMS` for the given stream.
        :param pulumi.Input[_builtins.str] stream_type: Specifies a type for the stream. This field is used for checking external changes and recreating the resources if needed.
        """
        if at is not None:
            pulumi.set(__self__, "at", at)
        if before is not None:
            pulumi.set(__self__, "before", before)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if copy_grants is not None:
            pulumi.set(__self__, "copy_grants", copy_grants)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if describe_outputs is not None:
            pulumi.set(__self__, "describe_outputs", describe_outputs)
        if external_table is not None:
            pulumi.set(__self__, "external_table", external_table)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if insert_only is not None:
            pulumi.set(__self__, "insert_only", insert_only)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)
        if stale is not None:
            pulumi.set(__self__, "stale", stale)
        if stream_type is not None:
            pulumi.set(__self__, "stream_type", stream_type)

    @_builtins.property
    @pulumi.getter
    def at(self) -> Optional[pulumi.Input['StreamOnExternalTableAtArgs']]:
        return pulumi.get(self, "at")

    @at.setter
    def at(self, value: Optional[pulumi.Input['StreamOnExternalTableAtArgs']]):
        pulumi.set(self, "at", value)

    @_builtins.property
    @pulumi.getter
    def before(self) -> Optional[pulumi.Input['StreamOnExternalTableBeforeArgs']]:
        return pulumi.get(self, "before")

    @before.setter
    def before(self, value: Optional[pulumi.Input['StreamOnExternalTableBeforeArgs']]):
        pulumi.set(self, "before", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the stream.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "copy_grants")

    @copy_grants.setter
    def copy_grants(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_grants", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StreamOnExternalTableDescribeOutputArgs']]]]:
        """
        Outputs the result of `DESCRIBE STREAM` for the given stream.
        """
        return pulumi.get(self, "describe_outputs")

    @describe_outputs.setter
    def describe_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StreamOnExternalTableDescribeOutputArgs']]]]):
        pulumi.set(self, "describe_outputs", value)

    @_builtins.property
    @pulumi.getter(name="externalTable")
    def external_table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an identifier for the external table the stream will monitor. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        """
        return pulumi.get(self, "external_table")

    @external_table.setter
    def external_table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_table", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter(name="insertOnly")
    def insert_only(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this is an insert-only stream. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "insert_only")

    @insert_only.setter
    def insert_only(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "insert_only", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the stream; must be unique for the database and schema in which the stream is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StreamOnExternalTableShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW STREAMS` for the given stream.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StreamOnExternalTableShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)

    @_builtins.property
    @pulumi.getter
    def stale(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "stale")

    @stale.setter
    def stale(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stale", value)

    @_builtins.property
    @pulumi.getter(name="streamType")
    def stream_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a type for the stream. This field is used for checking external changes and recreating the resources if needed.
        """
        return pulumi.get(self, "stream_type")

    @stream_type.setter
    def stream_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_type", value)


@pulumi.type_token("snowflake:index/streamOnExternalTable:StreamOnExternalTable")
class StreamOnExternalTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 at: Optional[pulumi.Input[Union['StreamOnExternalTableAtArgs', 'StreamOnExternalTableAtArgsDict']]] = None,
                 before: Optional[pulumi.Input[Union['StreamOnExternalTableBeforeArgs', 'StreamOnExternalTableBeforeArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 external_table: Optional[pulumi.Input[_builtins.str]] = None,
                 insert_only: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/streamOnExternalTable:StreamOnExternalTable example '"<database_name>"."<schema_name>"."<stream_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the stream.
        :param pulumi.Input[_builtins.str] database: The database in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] external_table: Specifies an identifier for the external table the stream will monitor. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] insert_only: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this is an insert-only stream. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the stream; must be unique for the database and schema in which the stream is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamOnExternalTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/streamOnExternalTable:StreamOnExternalTable example '"<database_name>"."<schema_name>"."<stream_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param StreamOnExternalTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamOnExternalTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 at: Optional[pulumi.Input[Union['StreamOnExternalTableAtArgs', 'StreamOnExternalTableAtArgsDict']]] = None,
                 before: Optional[pulumi.Input[Union['StreamOnExternalTableBeforeArgs', 'StreamOnExternalTableBeforeArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 external_table: Optional[pulumi.Input[_builtins.str]] = None,
                 insert_only: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamOnExternalTableArgs.__new__(StreamOnExternalTableArgs)

            __props__.__dict__["at"] = at
            __props__.__dict__["before"] = before
            __props__.__dict__["comment"] = comment
            __props__.__dict__["copy_grants"] = copy_grants
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            if external_table is None and not opts.urn:
                raise TypeError("Missing required property 'external_table'")
            __props__.__dict__["external_table"] = external_table
            __props__.__dict__["insert_only"] = insert_only
            __props__.__dict__["name"] = name
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["describe_outputs"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["show_outputs"] = None
            __props__.__dict__["stale"] = None
            __props__.__dict__["stream_type"] = None
        super(StreamOnExternalTable, __self__).__init__(
            'snowflake:index/streamOnExternalTable:StreamOnExternalTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            at: Optional[pulumi.Input[Union['StreamOnExternalTableAtArgs', 'StreamOnExternalTableAtArgsDict']]] = None,
            before: Optional[pulumi.Input[Union['StreamOnExternalTableBeforeArgs', 'StreamOnExternalTableBeforeArgsDict']]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamOnExternalTableDescribeOutputArgs', 'StreamOnExternalTableDescribeOutputArgsDict']]]]] = None,
            external_table: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            insert_only: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamOnExternalTableShowOutputArgs', 'StreamOnExternalTableShowOutputArgsDict']]]]] = None,
            stale: Optional[pulumi.Input[_builtins.bool]] = None,
            stream_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'StreamOnExternalTable':
        """
        Get an existing StreamOnExternalTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the stream.
        :param pulumi.Input[_builtins.str] database: The database in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StreamOnExternalTableDescribeOutputArgs', 'StreamOnExternalTableDescribeOutputArgsDict']]]] describe_outputs: Outputs the result of `DESCRIBE STREAM` for the given stream.
        :param pulumi.Input[_builtins.str] external_table: Specifies an identifier for the external table the stream will monitor. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] insert_only: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this is an insert-only stream. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the stream; must be unique for the database and schema in which the stream is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StreamOnExternalTableShowOutputArgs', 'StreamOnExternalTableShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW STREAMS` for the given stream.
        :param pulumi.Input[_builtins.str] stream_type: Specifies a type for the stream. This field is used for checking external changes and recreating the resources if needed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamOnExternalTableState.__new__(_StreamOnExternalTableState)

        __props__.__dict__["at"] = at
        __props__.__dict__["before"] = before
        __props__.__dict__["comment"] = comment
        __props__.__dict__["copy_grants"] = copy_grants
        __props__.__dict__["database"] = database
        __props__.__dict__["describe_outputs"] = describe_outputs
        __props__.__dict__["external_table"] = external_table
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["insert_only"] = insert_only
        __props__.__dict__["name"] = name
        __props__.__dict__["schema"] = schema
        __props__.__dict__["show_outputs"] = show_outputs
        __props__.__dict__["stale"] = stale
        __props__.__dict__["stream_type"] = stream_type
        return StreamOnExternalTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def at(self) -> pulumi.Output[Optional['outputs.StreamOnExternalTableAt']]:
        return pulumi.get(self, "at")

    @_builtins.property
    @pulumi.getter
    def before(self) -> pulumi.Output[Optional['outputs.StreamOnExternalTableBefore']]:
        return pulumi.get(self, "before")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the stream.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "copy_grants")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> pulumi.Output[Sequence['outputs.StreamOnExternalTableDescribeOutput']]:
        """
        Outputs the result of `DESCRIBE STREAM` for the given stream.
        """
        return pulumi.get(self, "describe_outputs")

    @_builtins.property
    @pulumi.getter(name="externalTable")
    def external_table(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies an identifier for the external table the stream will monitor. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        """
        return pulumi.get(self, "external_table")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter(name="insertOnly")
    def insert_only(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this is an insert-only stream. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "insert_only")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the stream; must be unique for the database and schema in which the stream is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the stream. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.StreamOnExternalTableShowOutput']]:
        """
        Outputs the result of `SHOW STREAMS` for the given stream.
        """
        return pulumi.get(self, "show_outputs")

    @_builtins.property
    @pulumi.getter
    def stale(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "stale")

    @_builtins.property
    @pulumi.getter(name="streamType")
    def stream_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a type for the stream. This field is used for checking external changes and recreating the resources if needed.
        """
        return pulumi.get(self, "stream_type")

