# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TaskArgs', 'Task']

@pulumi.input_type
class TaskArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 sql_statement: pulumi.Input[_builtins.str],
                 started: pulumi.Input[_builtins.bool],
                 abort_detached_query: Optional[pulumi.Input[_builtins.bool]] = None,
                 afters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allow_overlapping_execution: Optional[pulumi.Input[_builtins.str]] = None,
                 autocommit: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 binary_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 client_memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 client_metadata_request_use_connection_ctx: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_prefetch_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 client_result_chunk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 client_result_column_case_insensitive: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_session_keep_alive: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_session_keep_alive_heartbeat_frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 client_timestamp_type_mapping: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 date_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 date_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_unload_physical_type_optimization: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_integration: Optional[pulumi.Input[_builtins.str]] = None,
                 error_on_nondeterministic_merge: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_on_nondeterministic_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 finalize: Optional[pulumi.Input[_builtins.str]] = None,
                 geography_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 geometry_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_treat_timestamp_ntz_as_utc: Optional[pulumi.Input[_builtins.bool]] = None,
                 jdbc_use_session_timezone: Optional[pulumi.Input[_builtins.bool]] = None,
                 json_indent: Optional[pulumi.Input[_builtins.int]] = None,
                 lock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_statement_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 noorder_sequence_as_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 odbc_treat_decimal_as_int: Optional[pulumi.Input[_builtins.bool]] = None,
                 query_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 quoted_identifiers_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 rows_per_resultset: Optional[pulumi.Input[_builtins.int]] = None,
                 s3_stage_vpce_dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input['TaskScheduleArgs']] = None,
                 search_path: Optional[pulumi.Input[_builtins.str]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 strict_json_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 suspend_task_after_num_failures: Optional[pulumi.Input[_builtins.int]] = None,
                 task_auto_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 time_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 time_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_day_is_always24h: Optional[pulumi.Input[_builtins.bool]] = None,
                 timestamp_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_ltz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_ntz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_type_mapping: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_tz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None,
                 transaction_abort_on_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 transaction_default_isolation_level: Optional[pulumi.Input[_builtins.str]] = None,
                 two_digit_century_start: Optional[pulumi.Input[_builtins.int]] = None,
                 unsupported_ddl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 use_cached_result: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_minimum_trigger_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 week_of_year_policy: Optional[pulumi.Input[_builtins.int]] = None,
                 week_start: Optional[pulumi.Input[_builtins.int]] = None,
                 when: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Task resource.
        :param pulumi.Input[_builtins.str] database: The database in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] sql_statement: Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        :param pulumi.Input[_builtins.bool] started: Specifies if the task should be started or suspended.
        :param pulumi.Input[_builtins.bool] abort_detached_query: Specifies the action that Snowflake performs for in-progress queries if connectivity is lost due to abrupt termination of a session (e.g. network outage, browser termination, service interruption). For more information, check [ABORT*DETACHED*QUERY docs](https://docs.snowflake.com/en/sql-reference/parameters#abort-detached-query).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] afters: Specifies one or more predecessor tasks for the current task. Use this option to [create a DAG](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-task-dag) of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] allow_overlapping_execution: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.bool] autocommit: Specifies whether autocommit is enabled for the session. Autocommit determines whether a DML statement, when executed without an active transaction, is automatically committed after the statement successfully completes. For more information, see [Transactions](https://docs.snowflake.com/en/sql-reference/transactions). For more information, check [AUTOCOMMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#autocommit).
        :param pulumi.Input[_builtins.str] binary_input_format: The format of VARCHAR values passed as input to VARCHAR-to-BINARY conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-input-format).
        :param pulumi.Input[_builtins.str] binary_output_format: The format for VARCHAR values returned as output by BINARY-to-VARCHAR conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-output-format).
        :param pulumi.Input[_builtins.int] client_memory_limit: Parameter that specifies the maximum amount of memory the JDBC driver or ODBC driver should use for the result set from queries (in MB). For more information, check [CLIENT*MEMORY*LIMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#client-memory-limit).
        :param pulumi.Input[_builtins.bool] client_metadata_request_use_connection_ctx: For specific ODBC functions and JDBC methods, this parameter can change the default search scope from all databases/schemas to the current database/schema. The narrower search typically returns fewer rows and executes more quickly. For more information, check [CLIENT*METADATA*REQUEST*USE*CONNECTION_CTX docs](https://docs.snowflake.com/en/sql-reference/parameters#client-metadata-request-use-connection-ctx).
        :param pulumi.Input[_builtins.int] client_prefetch_threads: Parameter that specifies the number of threads used by the client to pre-fetch large result sets. The driver will attempt to honor the parameter value, but defines the minimum and maximum values (depending on your system’s resources) to improve performance. For more information, check [CLIENT*PREFETCH*THREADS docs](https://docs.snowflake.com/en/sql-reference/parameters#client-prefetch-threads).
        :param pulumi.Input[_builtins.int] client_result_chunk_size: Parameter that specifies the maximum size of each set (or chunk) of query results to download (in MB). The JDBC driver downloads query results in chunks. For more information, check [CLIENT*RESULT*CHUNK_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-chunk-size).
        :param pulumi.Input[_builtins.bool] client_result_column_case_insensitive: Parameter that indicates whether to match column name case-insensitively in ResultSet.get* methods in JDBC. For more information, check [CLIENT*RESULT*COLUMN*CASE*INSENSITIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-column-case-insensitive).
        :param pulumi.Input[_builtins.bool] client_session_keep_alive: Parameter that indicates whether to force a user to log in again after a period of inactivity in the session. For more information, check [CLIENT*SESSION*KEEP_ALIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive).
        :param pulumi.Input[_builtins.int] client_session_keep_alive_heartbeat_frequency: Number of seconds in-between client attempts to update the token for the session. For more information, check [CLIENT*SESSION*KEEP*ALIVE*HEARTBEAT_FREQUENCY docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive-heartbeat-frequency).
        :param pulumi.Input[_builtins.str] client_timestamp_type_mapping: Specifies the [TIMESTAMP_* variation](https://docs.snowflake.com/en/sql-reference/data-types-datetime.html#label-datatypes-timestamp-variations) to use when binding timestamp variables for JDBC or ODBC applications that use the bind API to load data. For more information, check [CLIENT*TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#client-timestamp-type-mapping).
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the task.
        :param pulumi.Input[_builtins.str] config: Specifies a string representation of key value pairs that can be accessed by all tasks in the task graph. Must be in JSON format.
        :param pulumi.Input[_builtins.str] date_input_format: Specifies the input format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-input-format).
        :param pulumi.Input[_builtins.str] date_output_format: Specifies the display format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-output-format).
        :param pulumi.Input[_builtins.bool] enable_unload_physical_type_optimization: Specifies whether to set the schema for unloaded Parquet files based on the logical column data types (i.e. the types in the unload SQL query or source table) or on the unloaded column values (i.e. the smallest data types and precision that support the values in the output columns of the unload SQL statement or source table). For more information, check [ENABLE*UNLOAD*PHYSICAL*TYPE*OPTIMIZATION docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unload-physical-type-optimization).
        :param pulumi.Input[_builtins.str] error_integration: Specifies the name of the notification integration used for error notifications. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.bool] error_on_nondeterministic_merge: Specifies whether to return an error when the [MERGE](https://docs.snowflake.com/en/sql-reference/sql/merge) command is used to update or delete a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_MERGE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-merge).
        :param pulumi.Input[_builtins.bool] error_on_nondeterministic_update: Specifies whether to return an error when the [UPDATE](https://docs.snowflake.com/en/sql-reference/sql/update) command is used to update a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_UPDATE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-update).
        :param pulumi.Input[_builtins.str] finalize: Specifies the name of a root task that the finalizer task is associated with. Finalizer tasks run after all other tasks in the task graph run to completion. You can define the SQL of a finalizer task to handle notifications and the release and cleanup of resources that a task graph uses. For more information, see [Release and cleanup of task graphs](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-finalizer-task). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] geography_output_format: Display format for [GEOGRAPHY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geography). For more information, check [GEOGRAPHY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geography-output-format).
        :param pulumi.Input[_builtins.str] geometry_output_format: Display format for [GEOMETRY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geometry). For more information, check [GEOMETRY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geometry-output-format).
        :param pulumi.Input[_builtins.bool] jdbc_treat_timestamp_ntz_as_utc: Specifies how JDBC processes TIMESTAMP*NTZ values. For more information, check [JDBC*TREAT*TIMESTAMP*NTZ*AS*UTC docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-timestamp-ntz-as-utc).
        :param pulumi.Input[_builtins.bool] jdbc_use_session_timezone: Specifies whether the JDBC Driver uses the time zone of the JVM or the time zone of the session (specified by the [TIMEZONE](https://docs.snowflake.com/en/sql-reference/parameters#label-timezone) parameter) for the getDate(), getTime(), and getTimestamp() methods of the ResultSet class. For more information, check [JDBC*USE*SESSION_TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-use-session-timezone).
        :param pulumi.Input[_builtins.int] json_indent: Specifies the number of blank spaces to indent each new element in JSON output in the session. Also specifies whether to insert newline characters after each element. For more information, check [JSON_INDENT docs](https://docs.snowflake.com/en/sql-reference/parameters#json-indent).
        :param pulumi.Input[_builtins.int] lock_timeout: Number of seconds to wait while trying to lock a resource, before timing out and aborting the statement. For more information, check [LOCK_TIMEOUT docs](https://docs.snowflake.com/en/sql-reference/parameters#lock-timeout).
        :param pulumi.Input[_builtins.str] log_level: Specifies the severity level of messages that should be ingested and made available in the active event table. Messages at the specified level (and at more severe levels) are ingested. For more information about log levels, see [Setting log level](https://docs.snowflake.com/en/developer-guide/logging-tracing/logging-log-level). For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        :param pulumi.Input[_builtins.int] multi_statement_count: Number of statements to execute when using the multi-statement capability. For more information, check [MULTI*STATEMENT*COUNT docs](https://docs.snowflake.com/en/sql-reference/parameters#multi-statement-count).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the task; must be unique for the database and schema in which the task is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.bool] noorder_sequence_as_default: Specifies whether the ORDER or NOORDER property is set by default when you create a new sequence or add a new table column. The ORDER and NOORDER properties determine whether or not the values are generated for the sequence or auto-incremented column in [increasing or decreasing order](https://docs.snowflake.com/en/user-guide/querying-sequences.html#label-querying-sequences-increasing-values). For more information, check [NOORDER*SEQUENCE*AS_DEFAULT docs](https://docs.snowflake.com/en/sql-reference/parameters#noorder-sequence-as-default).
        :param pulumi.Input[_builtins.bool] odbc_treat_decimal_as_int: Specifies how ODBC processes columns that have a scale of zero (0). For more information, check [ODBC*TREAT*DECIMAL*AS*INT docs](https://docs.snowflake.com/en/sql-reference/parameters#odbc-treat-decimal-as-int).
        :param pulumi.Input[_builtins.str] query_tag: Optional string that can be used to tag queries and other SQL statements executed within a session. The tags are displayed in the output of the [QUERY*HISTORY, QUERY*HISTORY*BY**](https://docs.snowflake.com/en/sql-reference/functions/query_history) functions. For more information, check [QUERY_TAG docs](https://docs.snowflake.com/en/sql-reference/parameters#query-tag).
        :param pulumi.Input[_builtins.bool] quoted_identifiers_ignore_case: Specifies whether letters in double-quoted object identifiers are stored and resolved as uppercase letters. By default, Snowflake preserves the case of alphabetic characters when storing and resolving double-quoted identifiers (see [Identifier resolution](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing)). You can use this parameter in situations in which [third-party applications always use double quotes around identifiers](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing-parameter). For more information, check [QUOTED*IDENTIFIERS*IGNORE_CASE docs](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        :param pulumi.Input[_builtins.int] rows_per_resultset: Specifies the maximum number of rows returned in a result set. A value of 0 specifies no maximum. For more information, check [ROWS*PER*RESULTSET docs](https://docs.snowflake.com/en/sql-reference/parameters#rows-per-resultset).
        :param pulumi.Input[_builtins.str] s3_stage_vpce_dns_name: Specifies the DNS name of an Amazon S3 interface endpoint. Requests sent to the internal stage of an account via [AWS PrivateLink for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/privatelink-interface-endpoints.html) use this endpoint to connect. For more information, see [Accessing Internal stages with dedicated interface endpoints](https://docs.snowflake.com/en/user-guide/private-internal-stages-aws.html#label-aws-privatelink-internal-stage-network-isolation). For more information, check [S3*STAGE*VPCE*DNS*NAME docs](https://docs.snowflake.com/en/sql-reference/parameters#s3-stage-vpce-dns-name).
        :param pulumi.Input['TaskScheduleArgs'] schedule: The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflicts with finalize and after; when set, one of the sub-fields `minutes` or `using_cron` should be set)
        :param pulumi.Input[_builtins.str] search_path: Specifies the path to search to resolve unqualified object names in queries. For more information, see [Name resolution in queries](https://docs.snowflake.com/en/sql-reference/name-resolution.html#label-object-name-resolution-search-path). Comma-separated list of identifiers. An identifier can be a fully or partially qualified schema name. For more information, check [SEARCH_PATH docs](https://docs.snowflake.com/en/sql-reference/parameters#search-path).
        :param pulumi.Input[_builtins.int] statement_queued_timeout_in_seconds: Amount of time, in seconds, a SQL statement (query, DDL, DML, etc.) remains queued for a warehouse before it is canceled by the system. This parameter can be used in conjunction with the [MAX*CONCURRENCY*LEVEL](https://docs.snowflake.com/en/sql-reference/parameters#label-max-concurrency-level) parameter to ensure a warehouse is never backlogged. For more information, check [STATEMENT*QUEUED*TIMEOUT*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-queued-timeout-in-seconds).
        :param pulumi.Input[_builtins.int] statement_timeout_in_seconds: Amount of time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system. For more information, check [STATEMENT*TIMEOUT*IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-timeout-in-seconds).
        :param pulumi.Input[_builtins.bool] strict_json_output: This parameter specifies whether JSON output in a session is compatible with the general standard (as described by [http://json.org](http://json.org)). By design, Snowflake allows JSON input that contains non-standard values; however, these non-standard values might result in Snowflake outputting JSON that is incompatible with other platforms and languages. This parameter, when enabled, ensures that Snowflake outputs valid/compatible JSON. For more information, check [STRICT*JSON*OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#strict-json-output).
        :param pulumi.Input[_builtins.int] suspend_task_after_num_failures: Specifies the number of consecutive failed task runs after which the current task is suspended automatically. The default is 0 (no automatic suspension). For more information, check [SUSPEND*TASK*AFTER*NUM*FAILURES docs](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        :param pulumi.Input[_builtins.int] task_auto_retry_attempts: Specifies the number of automatic task graph retry attempts. If any task graphs complete in a FAILED state, Snowflake can automatically retry the task graphs from the last task in the graph that failed. For more information, check [TASK*AUTO*RETRY_ATTEMPTS docs](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        :param pulumi.Input[_builtins.str] time_input_format: Specifies the input format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported time format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of times stored in the system during the session). For more information, check [TIME*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-input-format).
        :param pulumi.Input[_builtins.str] time_output_format: Specifies the display format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIME*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-output-format).
        :param pulumi.Input[_builtins.bool] timestamp_day_is_always24h: Specifies whether the [DATEADD](https://docs.snowflake.com/en/sql-reference/functions/dateadd) function (and its aliases) always consider a day to be exactly 24 hours for expressions that span multiple days. For more information, check [TIMESTAMP*DAY*IS*ALWAYS*24H docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-day-is-always-24h).
        :param pulumi.Input[_builtins.str] timestamp_input_format: Specifies the input format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported timestamp format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of timestamps stored in the system during the session). For more information, check [TIMESTAMP*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-input-format).
        :param pulumi.Input[_builtins.str] timestamp_ltz_output_format: Specifies the display format for the TIMESTAMP*LTZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*LTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ltz-output-format).
        :param pulumi.Input[_builtins.str] timestamp_ntz_output_format: Specifies the display format for the TIMESTAMP*NTZ data type. For more information, check [TIMESTAMP*NTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ntz-output-format).
        :param pulumi.Input[_builtins.str] timestamp_output_format: Specifies the display format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-output-format).
        :param pulumi.Input[_builtins.str] timestamp_type_mapping: Specifies the TIMESTAMP** variation that the TIMESTAMP data type alias maps to. For more information, check [TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-type-mapping).
        :param pulumi.Input[_builtins.str] timestamp_tz_output_format: Specifies the display format for the TIMESTAMP*TZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*TZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-tz-output-format).
        :param pulumi.Input[_builtins.str] timezone: Specifies the time zone for the session. You can specify a [time zone name](https://data.iana.org/time-zones/tzdb-2021a/zone1970.tab) or a [link name](https://data.iana.org/time-zones/tzdb-2021a/backward) from release 2021a of the [IANA Time Zone Database](https://www.iana.org/time-zones) (e.g. America/Los_Angeles, Europe/London, UTC, Etc/GMT, etc.). For more information, check [TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#timezone).
        :param pulumi.Input[_builtins.str] trace_level: Controls how trace events are ingested into the event table. For more information about trace levels, see [Setting trace level](https://docs.snowflake.com/en/developer-guide/logging-tracing/tracing-trace-level). For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        :param pulumi.Input[_builtins.bool] transaction_abort_on_error: Specifies the action to perform when a statement issued within a non-autocommit transaction returns with an error. For more information, check [TRANSACTION*ABORT*ON_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-abort-on-error).
        :param pulumi.Input[_builtins.str] transaction_default_isolation_level: Specifies the isolation level for transactions in the user session. For more information, check [TRANSACTION*DEFAULT*ISOLATION_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-default-isolation-level).
        :param pulumi.Input[_builtins.int] two_digit_century_start: Specifies the “century start” year for 2-digit years (i.e. the earliest year such dates can represent). This parameter prevents ambiguous dates when importing or converting data with the `YY` date format component (i.e. years represented as 2 digits). For more information, check [TWO*DIGIT*CENTURY_START docs](https://docs.snowflake.com/en/sql-reference/parameters#two-digit-century-start).
        :param pulumi.Input[_builtins.str] unsupported_ddl_action: Determines if an unsupported (i.e. non-default) value specified for a constraint property returns an error. For more information, check [UNSUPPORTED*DDL*ACTION docs](https://docs.snowflake.com/en/sql-reference/parameters#unsupported-ddl-action).
        :param pulumi.Input[_builtins.bool] use_cached_result: Specifies whether to reuse persisted query results, if available, when a matching query is submitted. For more information, check [USE*CACHED*RESULT docs](https://docs.snowflake.com/en/sql-reference/parameters#use-cached-result).
        :param pulumi.Input[_builtins.str] user_task_managed_initial_warehouse_size: Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. Valid values are (case-insensitive): %s. (Conflicts with warehouse). For more information about warehouses, see docs. For more information, check [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        :param pulumi.Input[_builtins.int] user_task_minimum_trigger_interval_in_seconds: Minimum amount of time between Triggered Task executions in seconds For more information, check [USER*TASK*MINIMUM*TRIGGER*INTERVAL*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-minimum-trigger-interval-in-seconds).
        :param pulumi.Input[_builtins.int] user_task_timeout_ms: Specifies the time limit on a single run of the task before it times out (in milliseconds). For more information, check [USER*TASK*TIMEOUT_MS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        :param pulumi.Input[_builtins.str] warehouse: The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. Due to Snowflake limitations warehouse identifier can consist of only upper-cased letters. (Conflicts with user*task*managed*initial*warehouse_size) For more information about this resource, see docs.
        :param pulumi.Input[_builtins.int] week_of_year_policy: Specifies how the weeks in a given year are computed. `0`: The semantics used are equivalent to the ISO semantics, in which a week belongs to a given year if at least 4 days of that week are in that year. `1`: January 1 is included in the first week of the year and December 31 is included in the last week of the year. For more information, check [WEEK*OF*YEAR_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#week-of-year-policy).
        :param pulumi.Input[_builtins.int] week_start: Specifies the first day of the week (used by week-related date functions). `0`: Legacy Snowflake behavior is used (i.e. ISO-like semantics). `1` (Monday) to `7` (Sunday): All the week-related functions use weeks that start on the specified day of the week. For more information, check [WEEK_START docs](https://docs.snowflake.com/en/sql-reference/parameters#week-start).
        :param pulumi.Input[_builtins.str] when: Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported. When a task is triggered (based on its SCHEDULE or AFTER setting), it validates the conditions of the expression to determine whether to execute. If the conditions of the expression are not met, then the task skips the current run. Any tasks that identify this task as a predecessor also don’t run.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "sql_statement", sql_statement)
        pulumi.set(__self__, "started", started)
        if abort_detached_query is not None:
            pulumi.set(__self__, "abort_detached_query", abort_detached_query)
        if afters is not None:
            pulumi.set(__self__, "afters", afters)
        if allow_overlapping_execution is not None:
            pulumi.set(__self__, "allow_overlapping_execution", allow_overlapping_execution)
        if autocommit is not None:
            pulumi.set(__self__, "autocommit", autocommit)
        if binary_input_format is not None:
            pulumi.set(__self__, "binary_input_format", binary_input_format)
        if binary_output_format is not None:
            pulumi.set(__self__, "binary_output_format", binary_output_format)
        if client_memory_limit is not None:
            pulumi.set(__self__, "client_memory_limit", client_memory_limit)
        if client_metadata_request_use_connection_ctx is not None:
            pulumi.set(__self__, "client_metadata_request_use_connection_ctx", client_metadata_request_use_connection_ctx)
        if client_prefetch_threads is not None:
            pulumi.set(__self__, "client_prefetch_threads", client_prefetch_threads)
        if client_result_chunk_size is not None:
            pulumi.set(__self__, "client_result_chunk_size", client_result_chunk_size)
        if client_result_column_case_insensitive is not None:
            pulumi.set(__self__, "client_result_column_case_insensitive", client_result_column_case_insensitive)
        if client_session_keep_alive is not None:
            pulumi.set(__self__, "client_session_keep_alive", client_session_keep_alive)
        if client_session_keep_alive_heartbeat_frequency is not None:
            pulumi.set(__self__, "client_session_keep_alive_heartbeat_frequency", client_session_keep_alive_heartbeat_frequency)
        if client_timestamp_type_mapping is not None:
            pulumi.set(__self__, "client_timestamp_type_mapping", client_timestamp_type_mapping)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if date_input_format is not None:
            pulumi.set(__self__, "date_input_format", date_input_format)
        if date_output_format is not None:
            pulumi.set(__self__, "date_output_format", date_output_format)
        if enable_unload_physical_type_optimization is not None:
            pulumi.set(__self__, "enable_unload_physical_type_optimization", enable_unload_physical_type_optimization)
        if error_integration is not None:
            pulumi.set(__self__, "error_integration", error_integration)
        if error_on_nondeterministic_merge is not None:
            pulumi.set(__self__, "error_on_nondeterministic_merge", error_on_nondeterministic_merge)
        if error_on_nondeterministic_update is not None:
            pulumi.set(__self__, "error_on_nondeterministic_update", error_on_nondeterministic_update)
        if finalize is not None:
            pulumi.set(__self__, "finalize", finalize)
        if geography_output_format is not None:
            pulumi.set(__self__, "geography_output_format", geography_output_format)
        if geometry_output_format is not None:
            pulumi.set(__self__, "geometry_output_format", geometry_output_format)
        if jdbc_treat_timestamp_ntz_as_utc is not None:
            pulumi.set(__self__, "jdbc_treat_timestamp_ntz_as_utc", jdbc_treat_timestamp_ntz_as_utc)
        if jdbc_use_session_timezone is not None:
            pulumi.set(__self__, "jdbc_use_session_timezone", jdbc_use_session_timezone)
        if json_indent is not None:
            pulumi.set(__self__, "json_indent", json_indent)
        if lock_timeout is not None:
            pulumi.set(__self__, "lock_timeout", lock_timeout)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if multi_statement_count is not None:
            pulumi.set(__self__, "multi_statement_count", multi_statement_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if noorder_sequence_as_default is not None:
            pulumi.set(__self__, "noorder_sequence_as_default", noorder_sequence_as_default)
        if odbc_treat_decimal_as_int is not None:
            pulumi.set(__self__, "odbc_treat_decimal_as_int", odbc_treat_decimal_as_int)
        if query_tag is not None:
            pulumi.set(__self__, "query_tag", query_tag)
        if quoted_identifiers_ignore_case is not None:
            pulumi.set(__self__, "quoted_identifiers_ignore_case", quoted_identifiers_ignore_case)
        if rows_per_resultset is not None:
            pulumi.set(__self__, "rows_per_resultset", rows_per_resultset)
        if s3_stage_vpce_dns_name is not None:
            pulumi.set(__self__, "s3_stage_vpce_dns_name", s3_stage_vpce_dns_name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if search_path is not None:
            pulumi.set(__self__, "search_path", search_path)
        if statement_queued_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_queued_timeout_in_seconds", statement_queued_timeout_in_seconds)
        if statement_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_timeout_in_seconds", statement_timeout_in_seconds)
        if strict_json_output is not None:
            pulumi.set(__self__, "strict_json_output", strict_json_output)
        if suspend_task_after_num_failures is not None:
            pulumi.set(__self__, "suspend_task_after_num_failures", suspend_task_after_num_failures)
        if task_auto_retry_attempts is not None:
            pulumi.set(__self__, "task_auto_retry_attempts", task_auto_retry_attempts)
        if time_input_format is not None:
            pulumi.set(__self__, "time_input_format", time_input_format)
        if time_output_format is not None:
            pulumi.set(__self__, "time_output_format", time_output_format)
        if timestamp_day_is_always24h is not None:
            pulumi.set(__self__, "timestamp_day_is_always24h", timestamp_day_is_always24h)
        if timestamp_input_format is not None:
            pulumi.set(__self__, "timestamp_input_format", timestamp_input_format)
        if timestamp_ltz_output_format is not None:
            pulumi.set(__self__, "timestamp_ltz_output_format", timestamp_ltz_output_format)
        if timestamp_ntz_output_format is not None:
            pulumi.set(__self__, "timestamp_ntz_output_format", timestamp_ntz_output_format)
        if timestamp_output_format is not None:
            pulumi.set(__self__, "timestamp_output_format", timestamp_output_format)
        if timestamp_type_mapping is not None:
            pulumi.set(__self__, "timestamp_type_mapping", timestamp_type_mapping)
        if timestamp_tz_output_format is not None:
            pulumi.set(__self__, "timestamp_tz_output_format", timestamp_tz_output_format)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if trace_level is not None:
            pulumi.set(__self__, "trace_level", trace_level)
        if transaction_abort_on_error is not None:
            pulumi.set(__self__, "transaction_abort_on_error", transaction_abort_on_error)
        if transaction_default_isolation_level is not None:
            pulumi.set(__self__, "transaction_default_isolation_level", transaction_default_isolation_level)
        if two_digit_century_start is not None:
            pulumi.set(__self__, "two_digit_century_start", two_digit_century_start)
        if unsupported_ddl_action is not None:
            pulumi.set(__self__, "unsupported_ddl_action", unsupported_ddl_action)
        if use_cached_result is not None:
            pulumi.set(__self__, "use_cached_result", use_cached_result)
        if user_task_managed_initial_warehouse_size is not None:
            pulumi.set(__self__, "user_task_managed_initial_warehouse_size", user_task_managed_initial_warehouse_size)
        if user_task_minimum_trigger_interval_in_seconds is not None:
            pulumi.set(__self__, "user_task_minimum_trigger_interval_in_seconds", user_task_minimum_trigger_interval_in_seconds)
        if user_task_timeout_ms is not None:
            pulumi.set(__self__, "user_task_timeout_ms", user_task_timeout_ms)
        if warehouse is not None:
            pulumi.set(__self__, "warehouse", warehouse)
        if week_of_year_policy is not None:
            pulumi.set(__self__, "week_of_year_policy", week_of_year_policy)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)
        if when is not None:
            pulumi.set(__self__, "when", when)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="sqlStatement")
    def sql_statement(self) -> pulumi.Input[_builtins.str]:
        """
        Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        """
        return pulumi.get(self, "sql_statement")

    @sql_statement.setter
    def sql_statement(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sql_statement", value)

    @_builtins.property
    @pulumi.getter
    def started(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies if the task should be started or suspended.
        """
        return pulumi.get(self, "started")

    @started.setter
    def started(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "started", value)

    @_builtins.property
    @pulumi.getter(name="abortDetachedQuery")
    def abort_detached_query(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the action that Snowflake performs for in-progress queries if connectivity is lost due to abrupt termination of a session (e.g. network outage, browser termination, service interruption). For more information, check [ABORT*DETACHED*QUERY docs](https://docs.snowflake.com/en/sql-reference/parameters#abort-detached-query).
        """
        return pulumi.get(self, "abort_detached_query")

    @abort_detached_query.setter
    def abort_detached_query(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "abort_detached_query", value)

    @_builtins.property
    @pulumi.getter
    def afters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies one or more predecessor tasks for the current task. Use this option to [create a DAG](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-task-dag) of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "afters")

    @afters.setter
    def afters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "afters", value)

    @_builtins.property
    @pulumi.getter(name="allowOverlappingExecution")
    def allow_overlapping_execution(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "allow_overlapping_execution")

    @allow_overlapping_execution.setter
    def allow_overlapping_execution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allow_overlapping_execution", value)

    @_builtins.property
    @pulumi.getter
    def autocommit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether autocommit is enabled for the session. Autocommit determines whether a DML statement, when executed without an active transaction, is automatically committed after the statement successfully completes. For more information, see [Transactions](https://docs.snowflake.com/en/sql-reference/transactions). For more information, check [AUTOCOMMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#autocommit).
        """
        return pulumi.get(self, "autocommit")

    @autocommit.setter
    def autocommit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autocommit", value)

    @_builtins.property
    @pulumi.getter(name="binaryInputFormat")
    def binary_input_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of VARCHAR values passed as input to VARCHAR-to-BINARY conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-input-format).
        """
        return pulumi.get(self, "binary_input_format")

    @binary_input_format.setter
    def binary_input_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binary_input_format", value)

    @_builtins.property
    @pulumi.getter(name="binaryOutputFormat")
    def binary_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format for VARCHAR values returned as output by BINARY-to-VARCHAR conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-output-format).
        """
        return pulumi.get(self, "binary_output_format")

    @binary_output_format.setter
    def binary_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binary_output_format", value)

    @_builtins.property
    @pulumi.getter(name="clientMemoryLimit")
    def client_memory_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Parameter that specifies the maximum amount of memory the JDBC driver or ODBC driver should use for the result set from queries (in MB). For more information, check [CLIENT*MEMORY*LIMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#client-memory-limit).
        """
        return pulumi.get(self, "client_memory_limit")

    @client_memory_limit.setter
    def client_memory_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_memory_limit", value)

    @_builtins.property
    @pulumi.getter(name="clientMetadataRequestUseConnectionCtx")
    def client_metadata_request_use_connection_ctx(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        For specific ODBC functions and JDBC methods, this parameter can change the default search scope from all databases/schemas to the current database/schema. The narrower search typically returns fewer rows and executes more quickly. For more information, check [CLIENT*METADATA*REQUEST*USE*CONNECTION_CTX docs](https://docs.snowflake.com/en/sql-reference/parameters#client-metadata-request-use-connection-ctx).
        """
        return pulumi.get(self, "client_metadata_request_use_connection_ctx")

    @client_metadata_request_use_connection_ctx.setter
    def client_metadata_request_use_connection_ctx(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_metadata_request_use_connection_ctx", value)

    @_builtins.property
    @pulumi.getter(name="clientPrefetchThreads")
    def client_prefetch_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Parameter that specifies the number of threads used by the client to pre-fetch large result sets. The driver will attempt to honor the parameter value, but defines the minimum and maximum values (depending on your system’s resources) to improve performance. For more information, check [CLIENT*PREFETCH*THREADS docs](https://docs.snowflake.com/en/sql-reference/parameters#client-prefetch-threads).
        """
        return pulumi.get(self, "client_prefetch_threads")

    @client_prefetch_threads.setter
    def client_prefetch_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_prefetch_threads", value)

    @_builtins.property
    @pulumi.getter(name="clientResultChunkSize")
    def client_result_chunk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Parameter that specifies the maximum size of each set (or chunk) of query results to download (in MB). The JDBC driver downloads query results in chunks. For more information, check [CLIENT*RESULT*CHUNK_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-chunk-size).
        """
        return pulumi.get(self, "client_result_chunk_size")

    @client_result_chunk_size.setter
    def client_result_chunk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_result_chunk_size", value)

    @_builtins.property
    @pulumi.getter(name="clientResultColumnCaseInsensitive")
    def client_result_column_case_insensitive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Parameter that indicates whether to match column name case-insensitively in ResultSet.get* methods in JDBC. For more information, check [CLIENT*RESULT*COLUMN*CASE*INSENSITIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-column-case-insensitive).
        """
        return pulumi.get(self, "client_result_column_case_insensitive")

    @client_result_column_case_insensitive.setter
    def client_result_column_case_insensitive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_result_column_case_insensitive", value)

    @_builtins.property
    @pulumi.getter(name="clientSessionKeepAlive")
    def client_session_keep_alive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Parameter that indicates whether to force a user to log in again after a period of inactivity in the session. For more information, check [CLIENT*SESSION*KEEP_ALIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive).
        """
        return pulumi.get(self, "client_session_keep_alive")

    @client_session_keep_alive.setter
    def client_session_keep_alive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_session_keep_alive", value)

    @_builtins.property
    @pulumi.getter(name="clientSessionKeepAliveHeartbeatFrequency")
    def client_session_keep_alive_heartbeat_frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds in-between client attempts to update the token for the session. For more information, check [CLIENT*SESSION*KEEP*ALIVE*HEARTBEAT_FREQUENCY docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive-heartbeat-frequency).
        """
        return pulumi.get(self, "client_session_keep_alive_heartbeat_frequency")

    @client_session_keep_alive_heartbeat_frequency.setter
    def client_session_keep_alive_heartbeat_frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_session_keep_alive_heartbeat_frequency", value)

    @_builtins.property
    @pulumi.getter(name="clientTimestampTypeMapping")
    def client_timestamp_type_mapping(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the [TIMESTAMP_* variation](https://docs.snowflake.com/en/sql-reference/data-types-datetime.html#label-datatypes-timestamp-variations) to use when binding timestamp variables for JDBC or ODBC applications that use the bind API to load data. For more information, check [CLIENT*TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#client-timestamp-type-mapping).
        """
        return pulumi.get(self, "client_timestamp_type_mapping")

    @client_timestamp_type_mapping.setter
    def client_timestamp_type_mapping(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_timestamp_type_mapping", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the task.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a string representation of key value pairs that can be accessed by all tasks in the task graph. Must be in JSON format.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="dateInputFormat")
    def date_input_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the input format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-input-format).
        """
        return pulumi.get(self, "date_input_format")

    @date_input_format.setter
    def date_input_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_input_format", value)

    @_builtins.property
    @pulumi.getter(name="dateOutputFormat")
    def date_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-output-format).
        """
        return pulumi.get(self, "date_output_format")

    @date_output_format.setter
    def date_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_output_format", value)

    @_builtins.property
    @pulumi.getter(name="enableUnloadPhysicalTypeOptimization")
    def enable_unload_physical_type_optimization(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to set the schema for unloaded Parquet files based on the logical column data types (i.e. the types in the unload SQL query or source table) or on the unloaded column values (i.e. the smallest data types and precision that support the values in the output columns of the unload SQL statement or source table). For more information, check [ENABLE*UNLOAD*PHYSICAL*TYPE*OPTIMIZATION docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unload-physical-type-optimization).
        """
        return pulumi.get(self, "enable_unload_physical_type_optimization")

    @enable_unload_physical_type_optimization.setter
    def enable_unload_physical_type_optimization(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_unload_physical_type_optimization", value)

    @_builtins.property
    @pulumi.getter(name="errorIntegration")
    def error_integration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the notification integration used for error notifications. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        """
        return pulumi.get(self, "error_integration")

    @error_integration.setter
    def error_integration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_integration", value)

    @_builtins.property
    @pulumi.getter(name="errorOnNondeterministicMerge")
    def error_on_nondeterministic_merge(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to return an error when the [MERGE](https://docs.snowflake.com/en/sql-reference/sql/merge) command is used to update or delete a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_MERGE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-merge).
        """
        return pulumi.get(self, "error_on_nondeterministic_merge")

    @error_on_nondeterministic_merge.setter
    def error_on_nondeterministic_merge(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "error_on_nondeterministic_merge", value)

    @_builtins.property
    @pulumi.getter(name="errorOnNondeterministicUpdate")
    def error_on_nondeterministic_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to return an error when the [UPDATE](https://docs.snowflake.com/en/sql-reference/sql/update) command is used to update a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_UPDATE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-update).
        """
        return pulumi.get(self, "error_on_nondeterministic_update")

    @error_on_nondeterministic_update.setter
    def error_on_nondeterministic_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "error_on_nondeterministic_update", value)

    @_builtins.property
    @pulumi.getter
    def finalize(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of a root task that the finalizer task is associated with. Finalizer tasks run after all other tasks in the task graph run to completion. You can define the SQL of a finalizer task to handle notifications and the release and cleanup of resources that a task graph uses. For more information, see [Release and cleanup of task graphs](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-finalizer-task). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "finalize")

    @finalize.setter
    def finalize(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "finalize", value)

    @_builtins.property
    @pulumi.getter(name="geographyOutputFormat")
    def geography_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display format for [GEOGRAPHY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geography). For more information, check [GEOGRAPHY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geography-output-format).
        """
        return pulumi.get(self, "geography_output_format")

    @geography_output_format.setter
    def geography_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geography_output_format", value)

    @_builtins.property
    @pulumi.getter(name="geometryOutputFormat")
    def geometry_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display format for [GEOMETRY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geometry). For more information, check [GEOMETRY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geometry-output-format).
        """
        return pulumi.get(self, "geometry_output_format")

    @geometry_output_format.setter
    def geometry_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geometry_output_format", value)

    @_builtins.property
    @pulumi.getter(name="jdbcTreatTimestampNtzAsUtc")
    def jdbc_treat_timestamp_ntz_as_utc(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies how JDBC processes TIMESTAMP*NTZ values. For more information, check [JDBC*TREAT*TIMESTAMP*NTZ*AS*UTC docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-timestamp-ntz-as-utc).
        """
        return pulumi.get(self, "jdbc_treat_timestamp_ntz_as_utc")

    @jdbc_treat_timestamp_ntz_as_utc.setter
    def jdbc_treat_timestamp_ntz_as_utc(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "jdbc_treat_timestamp_ntz_as_utc", value)

    @_builtins.property
    @pulumi.getter(name="jdbcUseSessionTimezone")
    def jdbc_use_session_timezone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the JDBC Driver uses the time zone of the JVM or the time zone of the session (specified by the [TIMEZONE](https://docs.snowflake.com/en/sql-reference/parameters#label-timezone) parameter) for the getDate(), getTime(), and getTimestamp() methods of the ResultSet class. For more information, check [JDBC*USE*SESSION_TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-use-session-timezone).
        """
        return pulumi.get(self, "jdbc_use_session_timezone")

    @jdbc_use_session_timezone.setter
    def jdbc_use_session_timezone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "jdbc_use_session_timezone", value)

    @_builtins.property
    @pulumi.getter(name="jsonIndent")
    def json_indent(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of blank spaces to indent each new element in JSON output in the session. Also specifies whether to insert newline characters after each element. For more information, check [JSON_INDENT docs](https://docs.snowflake.com/en/sql-reference/parameters#json-indent).
        """
        return pulumi.get(self, "json_indent")

    @json_indent.setter
    def json_indent(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "json_indent", value)

    @_builtins.property
    @pulumi.getter(name="lockTimeout")
    def lock_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds to wait while trying to lock a resource, before timing out and aborting the statement. For more information, check [LOCK_TIMEOUT docs](https://docs.snowflake.com/en/sql-reference/parameters#lock-timeout).
        """
        return pulumi.get(self, "lock_timeout")

    @lock_timeout.setter
    def lock_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lock_timeout", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the severity level of messages that should be ingested and made available in the active event table. Messages at the specified level (and at more severe levels) are ingested. For more information about log levels, see [Setting log level](https://docs.snowflake.com/en/developer-guide/logging-tracing/logging-log-level). For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter(name="multiStatementCount")
    def multi_statement_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of statements to execute when using the multi-statement capability. For more information, check [MULTI*STATEMENT*COUNT docs](https://docs.snowflake.com/en/sql-reference/parameters#multi-statement-count).
        """
        return pulumi.get(self, "multi_statement_count")

    @multi_statement_count.setter
    def multi_statement_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "multi_statement_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the task; must be unique for the database and schema in which the task is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="noorderSequenceAsDefault")
    def noorder_sequence_as_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the ORDER or NOORDER property is set by default when you create a new sequence or add a new table column. The ORDER and NOORDER properties determine whether or not the values are generated for the sequence or auto-incremented column in [increasing or decreasing order](https://docs.snowflake.com/en/user-guide/querying-sequences.html#label-querying-sequences-increasing-values). For more information, check [NOORDER*SEQUENCE*AS_DEFAULT docs](https://docs.snowflake.com/en/sql-reference/parameters#noorder-sequence-as-default).
        """
        return pulumi.get(self, "noorder_sequence_as_default")

    @noorder_sequence_as_default.setter
    def noorder_sequence_as_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "noorder_sequence_as_default", value)

    @_builtins.property
    @pulumi.getter(name="odbcTreatDecimalAsInt")
    def odbc_treat_decimal_as_int(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies how ODBC processes columns that have a scale of zero (0). For more information, check [ODBC*TREAT*DECIMAL*AS*INT docs](https://docs.snowflake.com/en/sql-reference/parameters#odbc-treat-decimal-as-int).
        """
        return pulumi.get(self, "odbc_treat_decimal_as_int")

    @odbc_treat_decimal_as_int.setter
    def odbc_treat_decimal_as_int(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "odbc_treat_decimal_as_int", value)

    @_builtins.property
    @pulumi.getter(name="queryTag")
    def query_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional string that can be used to tag queries and other SQL statements executed within a session. The tags are displayed in the output of the [QUERY*HISTORY, QUERY*HISTORY*BY**](https://docs.snowflake.com/en/sql-reference/functions/query_history) functions. For more information, check [QUERY_TAG docs](https://docs.snowflake.com/en/sql-reference/parameters#query-tag).
        """
        return pulumi.get(self, "query_tag")

    @query_tag.setter
    def query_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_tag", value)

    @_builtins.property
    @pulumi.getter(name="quotedIdentifiersIgnoreCase")
    def quoted_identifiers_ignore_case(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether letters in double-quoted object identifiers are stored and resolved as uppercase letters. By default, Snowflake preserves the case of alphabetic characters when storing and resolving double-quoted identifiers (see [Identifier resolution](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing)). You can use this parameter in situations in which [third-party applications always use double quotes around identifiers](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing-parameter). For more information, check [QUOTED*IDENTIFIERS*IGNORE_CASE docs](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        """
        return pulumi.get(self, "quoted_identifiers_ignore_case")

    @quoted_identifiers_ignore_case.setter
    def quoted_identifiers_ignore_case(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "quoted_identifiers_ignore_case", value)

    @_builtins.property
    @pulumi.getter(name="rowsPerResultset")
    def rows_per_resultset(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of rows returned in a result set. A value of 0 specifies no maximum. For more information, check [ROWS*PER*RESULTSET docs](https://docs.snowflake.com/en/sql-reference/parameters#rows-per-resultset).
        """
        return pulumi.get(self, "rows_per_resultset")

    @rows_per_resultset.setter
    def rows_per_resultset(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rows_per_resultset", value)

    @_builtins.property
    @pulumi.getter(name="s3StageVpceDnsName")
    def s3_stage_vpce_dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DNS name of an Amazon S3 interface endpoint. Requests sent to the internal stage of an account via [AWS PrivateLink for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/privatelink-interface-endpoints.html) use this endpoint to connect. For more information, see [Accessing Internal stages with dedicated interface endpoints](https://docs.snowflake.com/en/user-guide/private-internal-stages-aws.html#label-aws-privatelink-internal-stage-network-isolation). For more information, check [S3*STAGE*VPCE*DNS*NAME docs](https://docs.snowflake.com/en/sql-reference/parameters#s3-stage-vpce-dns-name).
        """
        return pulumi.get(self, "s3_stage_vpce_dns_name")

    @s3_stage_vpce_dns_name.setter
    def s3_stage_vpce_dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_stage_vpce_dns_name", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['TaskScheduleArgs']]:
        """
        The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflicts with finalize and after; when set, one of the sub-fields `minutes` or `using_cron` should be set)
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['TaskScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="searchPath")
    def search_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the path to search to resolve unqualified object names in queries. For more information, see [Name resolution in queries](https://docs.snowflake.com/en/sql-reference/name-resolution.html#label-object-name-resolution-search-path). Comma-separated list of identifiers. An identifier can be a fully or partially qualified schema name. For more information, check [SEARCH_PATH docs](https://docs.snowflake.com/en/sql-reference/parameters#search-path).
        """
        return pulumi.get(self, "search_path")

    @search_path.setter
    def search_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_path", value)

    @_builtins.property
    @pulumi.getter(name="statementQueuedTimeoutInSeconds")
    def statement_queued_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time, in seconds, a SQL statement (query, DDL, DML, etc.) remains queued for a warehouse before it is canceled by the system. This parameter can be used in conjunction with the [MAX*CONCURRENCY*LEVEL](https://docs.snowflake.com/en/sql-reference/parameters#label-max-concurrency-level) parameter to ensure a warehouse is never backlogged. For more information, check [STATEMENT*QUEUED*TIMEOUT*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-queued-timeout-in-seconds).
        """
        return pulumi.get(self, "statement_queued_timeout_in_seconds")

    @statement_queued_timeout_in_seconds.setter
    def statement_queued_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "statement_queued_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="statementTimeoutInSeconds")
    def statement_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system. For more information, check [STATEMENT*TIMEOUT*IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-timeout-in-seconds).
        """
        return pulumi.get(self, "statement_timeout_in_seconds")

    @statement_timeout_in_seconds.setter
    def statement_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "statement_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="strictJsonOutput")
    def strict_json_output(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter specifies whether JSON output in a session is compatible with the general standard (as described by [http://json.org](http://json.org)). By design, Snowflake allows JSON input that contains non-standard values; however, these non-standard values might result in Snowflake outputting JSON that is incompatible with other platforms and languages. This parameter, when enabled, ensures that Snowflake outputs valid/compatible JSON. For more information, check [STRICT*JSON*OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#strict-json-output).
        """
        return pulumi.get(self, "strict_json_output")

    @strict_json_output.setter
    def strict_json_output(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strict_json_output", value)

    @_builtins.property
    @pulumi.getter(name="suspendTaskAfterNumFailures")
    def suspend_task_after_num_failures(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of consecutive failed task runs after which the current task is suspended automatically. The default is 0 (no automatic suspension). For more information, check [SUSPEND*TASK*AFTER*NUM*FAILURES docs](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        """
        return pulumi.get(self, "suspend_task_after_num_failures")

    @suspend_task_after_num_failures.setter
    def suspend_task_after_num_failures(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "suspend_task_after_num_failures", value)

    @_builtins.property
    @pulumi.getter(name="taskAutoRetryAttempts")
    def task_auto_retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of automatic task graph retry attempts. If any task graphs complete in a FAILED state, Snowflake can automatically retry the task graphs from the last task in the graph that failed. For more information, check [TASK*AUTO*RETRY_ATTEMPTS docs](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        """
        return pulumi.get(self, "task_auto_retry_attempts")

    @task_auto_retry_attempts.setter
    def task_auto_retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "task_auto_retry_attempts", value)

    @_builtins.property
    @pulumi.getter(name="timeInputFormat")
    def time_input_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the input format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported time format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of times stored in the system during the session). For more information, check [TIME*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-input-format).
        """
        return pulumi.get(self, "time_input_format")

    @time_input_format.setter
    def time_input_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_input_format", value)

    @_builtins.property
    @pulumi.getter(name="timeOutputFormat")
    def time_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIME*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-output-format).
        """
        return pulumi.get(self, "time_output_format")

    @time_output_format.setter
    def time_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_output_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampDayIsAlways24h")
    def timestamp_day_is_always24h(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the [DATEADD](https://docs.snowflake.com/en/sql-reference/functions/dateadd) function (and its aliases) always consider a day to be exactly 24 hours for expressions that span multiple days. For more information, check [TIMESTAMP*DAY*IS*ALWAYS*24H docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-day-is-always-24h).
        """
        return pulumi.get(self, "timestamp_day_is_always24h")

    @timestamp_day_is_always24h.setter
    def timestamp_day_is_always24h(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "timestamp_day_is_always24h", value)

    @_builtins.property
    @pulumi.getter(name="timestampInputFormat")
    def timestamp_input_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the input format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported timestamp format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of timestamps stored in the system during the session). For more information, check [TIMESTAMP*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-input-format).
        """
        return pulumi.get(self, "timestamp_input_format")

    @timestamp_input_format.setter
    def timestamp_input_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_input_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampLtzOutputFormat")
    def timestamp_ltz_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the TIMESTAMP*LTZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*LTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ltz-output-format).
        """
        return pulumi.get(self, "timestamp_ltz_output_format")

    @timestamp_ltz_output_format.setter
    def timestamp_ltz_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_ltz_output_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampNtzOutputFormat")
    def timestamp_ntz_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the TIMESTAMP*NTZ data type. For more information, check [TIMESTAMP*NTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ntz-output-format).
        """
        return pulumi.get(self, "timestamp_ntz_output_format")

    @timestamp_ntz_output_format.setter
    def timestamp_ntz_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_ntz_output_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampOutputFormat")
    def timestamp_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-output-format).
        """
        return pulumi.get(self, "timestamp_output_format")

    @timestamp_output_format.setter
    def timestamp_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_output_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampTypeMapping")
    def timestamp_type_mapping(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the TIMESTAMP** variation that the TIMESTAMP data type alias maps to. For more information, check [TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-type-mapping).
        """
        return pulumi.get(self, "timestamp_type_mapping")

    @timestamp_type_mapping.setter
    def timestamp_type_mapping(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_type_mapping", value)

    @_builtins.property
    @pulumi.getter(name="timestampTzOutputFormat")
    def timestamp_tz_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the TIMESTAMP*TZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*TZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-tz-output-format).
        """
        return pulumi.get(self, "timestamp_tz_output_format")

    @timestamp_tz_output_format.setter
    def timestamp_tz_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_tz_output_format", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time zone for the session. You can specify a [time zone name](https://data.iana.org/time-zones/tzdb-2021a/zone1970.tab) or a [link name](https://data.iana.org/time-zones/tzdb-2021a/backward) from release 2021a of the [IANA Time Zone Database](https://www.iana.org/time-zones) (e.g. America/Los_Angeles, Europe/London, UTC, Etc/GMT, etc.). For more information, check [TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#timezone).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="traceLevel")
    def trace_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how trace events are ingested into the event table. For more information about trace levels, see [Setting trace level](https://docs.snowflake.com/en/developer-guide/logging-tracing/tracing-trace-level). For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        """
        return pulumi.get(self, "trace_level")

    @trace_level.setter
    def trace_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trace_level", value)

    @_builtins.property
    @pulumi.getter(name="transactionAbortOnError")
    def transaction_abort_on_error(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the action to perform when a statement issued within a non-autocommit transaction returns with an error. For more information, check [TRANSACTION*ABORT*ON_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-abort-on-error).
        """
        return pulumi.get(self, "transaction_abort_on_error")

    @transaction_abort_on_error.setter
    def transaction_abort_on_error(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transaction_abort_on_error", value)

    @_builtins.property
    @pulumi.getter(name="transactionDefaultIsolationLevel")
    def transaction_default_isolation_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the isolation level for transactions in the user session. For more information, check [TRANSACTION*DEFAULT*ISOLATION_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-default-isolation-level).
        """
        return pulumi.get(self, "transaction_default_isolation_level")

    @transaction_default_isolation_level.setter
    def transaction_default_isolation_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transaction_default_isolation_level", value)

    @_builtins.property
    @pulumi.getter(name="twoDigitCenturyStart")
    def two_digit_century_start(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the “century start” year for 2-digit years (i.e. the earliest year such dates can represent). This parameter prevents ambiguous dates when importing or converting data with the `YY` date format component (i.e. years represented as 2 digits). For more information, check [TWO*DIGIT*CENTURY_START docs](https://docs.snowflake.com/en/sql-reference/parameters#two-digit-century-start).
        """
        return pulumi.get(self, "two_digit_century_start")

    @two_digit_century_start.setter
    def two_digit_century_start(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "two_digit_century_start", value)

    @_builtins.property
    @pulumi.getter(name="unsupportedDdlAction")
    def unsupported_ddl_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines if an unsupported (i.e. non-default) value specified for a constraint property returns an error. For more information, check [UNSUPPORTED*DDL*ACTION docs](https://docs.snowflake.com/en/sql-reference/parameters#unsupported-ddl-action).
        """
        return pulumi.get(self, "unsupported_ddl_action")

    @unsupported_ddl_action.setter
    def unsupported_ddl_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unsupported_ddl_action", value)

    @_builtins.property
    @pulumi.getter(name="useCachedResult")
    def use_cached_result(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to reuse persisted query results, if available, when a matching query is submitted. For more information, check [USE*CACHED*RESULT docs](https://docs.snowflake.com/en/sql-reference/parameters#use-cached-result).
        """
        return pulumi.get(self, "use_cached_result")

    @use_cached_result.setter
    def use_cached_result(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_cached_result", value)

    @_builtins.property
    @pulumi.getter(name="userTaskManagedInitialWarehouseSize")
    def user_task_managed_initial_warehouse_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. Valid values are (case-insensitive): %s. (Conflicts with warehouse). For more information about warehouses, see docs. For more information, check [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        """
        return pulumi.get(self, "user_task_managed_initial_warehouse_size")

    @user_task_managed_initial_warehouse_size.setter
    def user_task_managed_initial_warehouse_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_task_managed_initial_warehouse_size", value)

    @_builtins.property
    @pulumi.getter(name="userTaskMinimumTriggerIntervalInSeconds")
    def user_task_minimum_trigger_interval_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum amount of time between Triggered Task executions in seconds For more information, check [USER*TASK*MINIMUM*TRIGGER*INTERVAL*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-minimum-trigger-interval-in-seconds).
        """
        return pulumi.get(self, "user_task_minimum_trigger_interval_in_seconds")

    @user_task_minimum_trigger_interval_in_seconds.setter
    def user_task_minimum_trigger_interval_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_task_minimum_trigger_interval_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="userTaskTimeoutMs")
    def user_task_timeout_ms(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the time limit on a single run of the task before it times out (in milliseconds). For more information, check [USER*TASK*TIMEOUT_MS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        """
        return pulumi.get(self, "user_task_timeout_ms")

    @user_task_timeout_ms.setter
    def user_task_timeout_ms(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_task_timeout_ms", value)

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. Due to Snowflake limitations warehouse identifier can consist of only upper-cased letters. (Conflicts with user*task*managed*initial*warehouse_size) For more information about this resource, see docs.
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse", value)

    @_builtins.property
    @pulumi.getter(name="weekOfYearPolicy")
    def week_of_year_policy(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how the weeks in a given year are computed. `0`: The semantics used are equivalent to the ISO semantics, in which a week belongs to a given year if at least 4 days of that week are in that year. `1`: January 1 is included in the first week of the year and December 31 is included in the last week of the year. For more information, check [WEEK*OF*YEAR_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#week-of-year-policy).
        """
        return pulumi.get(self, "week_of_year_policy")

    @week_of_year_policy.setter
    def week_of_year_policy(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "week_of_year_policy", value)

    @_builtins.property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the first day of the week (used by week-related date functions). `0`: Legacy Snowflake behavior is used (i.e. ISO-like semantics). `1` (Monday) to `7` (Sunday): All the week-related functions use weeks that start on the specified day of the week. For more information, check [WEEK_START docs](https://docs.snowflake.com/en/sql-reference/parameters#week-start).
        """
        return pulumi.get(self, "week_start")

    @week_start.setter
    def week_start(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "week_start", value)

    @_builtins.property
    @pulumi.getter
    def when(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported. When a task is triggered (based on its SCHEDULE or AFTER setting), it validates the conditions of the expression to determine whether to execute. If the conditions of the expression are not met, then the task skips the current run. Any tasks that identify this task as a predecessor also don’t run.
        """
        return pulumi.get(self, "when")

    @when.setter
    def when(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "when", value)


@pulumi.input_type
class _TaskState:
    def __init__(__self__, *,
                 abort_detached_query: Optional[pulumi.Input[_builtins.bool]] = None,
                 afters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allow_overlapping_execution: Optional[pulumi.Input[_builtins.str]] = None,
                 autocommit: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 binary_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 client_memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 client_metadata_request_use_connection_ctx: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_prefetch_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 client_result_chunk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 client_result_column_case_insensitive: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_session_keep_alive: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_session_keep_alive_heartbeat_frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 client_timestamp_type_mapping: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 date_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 date_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_unload_physical_type_optimization: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_integration: Optional[pulumi.Input[_builtins.str]] = None,
                 error_on_nondeterministic_merge: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_on_nondeterministic_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 finalize: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 geography_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 geometry_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_treat_timestamp_ntz_as_utc: Optional[pulumi.Input[_builtins.bool]] = None,
                 jdbc_use_session_timezone: Optional[pulumi.Input[_builtins.bool]] = None,
                 json_indent: Optional[pulumi.Input[_builtins.int]] = None,
                 lock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_statement_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 noorder_sequence_as_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 odbc_treat_decimal_as_int: Optional[pulumi.Input[_builtins.bool]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['TaskParameterArgs']]]] = None,
                 query_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 quoted_identifiers_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 rows_per_resultset: Optional[pulumi.Input[_builtins.int]] = None,
                 s3_stage_vpce_dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input['TaskScheduleArgs']] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 search_path: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['TaskShowOutputArgs']]]] = None,
                 sql_statement: Optional[pulumi.Input[_builtins.str]] = None,
                 started: Optional[pulumi.Input[_builtins.bool]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 strict_json_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 suspend_task_after_num_failures: Optional[pulumi.Input[_builtins.int]] = None,
                 task_auto_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 time_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 time_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_day_is_always24h: Optional[pulumi.Input[_builtins.bool]] = None,
                 timestamp_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_ltz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_ntz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_type_mapping: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_tz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None,
                 transaction_abort_on_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 transaction_default_isolation_level: Optional[pulumi.Input[_builtins.str]] = None,
                 two_digit_century_start: Optional[pulumi.Input[_builtins.int]] = None,
                 unsupported_ddl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 use_cached_result: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_minimum_trigger_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 week_of_year_policy: Optional[pulumi.Input[_builtins.int]] = None,
                 week_start: Optional[pulumi.Input[_builtins.int]] = None,
                 when: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Task resources.
        :param pulumi.Input[_builtins.bool] abort_detached_query: Specifies the action that Snowflake performs for in-progress queries if connectivity is lost due to abrupt termination of a session (e.g. network outage, browser termination, service interruption). For more information, check [ABORT*DETACHED*QUERY docs](https://docs.snowflake.com/en/sql-reference/parameters#abort-detached-query).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] afters: Specifies one or more predecessor tasks for the current task. Use this option to [create a DAG](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-task-dag) of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] allow_overlapping_execution: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.bool] autocommit: Specifies whether autocommit is enabled for the session. Autocommit determines whether a DML statement, when executed without an active transaction, is automatically committed after the statement successfully completes. For more information, see [Transactions](https://docs.snowflake.com/en/sql-reference/transactions). For more information, check [AUTOCOMMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#autocommit).
        :param pulumi.Input[_builtins.str] binary_input_format: The format of VARCHAR values passed as input to VARCHAR-to-BINARY conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-input-format).
        :param pulumi.Input[_builtins.str] binary_output_format: The format for VARCHAR values returned as output by BINARY-to-VARCHAR conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-output-format).
        :param pulumi.Input[_builtins.int] client_memory_limit: Parameter that specifies the maximum amount of memory the JDBC driver or ODBC driver should use for the result set from queries (in MB). For more information, check [CLIENT*MEMORY*LIMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#client-memory-limit).
        :param pulumi.Input[_builtins.bool] client_metadata_request_use_connection_ctx: For specific ODBC functions and JDBC methods, this parameter can change the default search scope from all databases/schemas to the current database/schema. The narrower search typically returns fewer rows and executes more quickly. For more information, check [CLIENT*METADATA*REQUEST*USE*CONNECTION_CTX docs](https://docs.snowflake.com/en/sql-reference/parameters#client-metadata-request-use-connection-ctx).
        :param pulumi.Input[_builtins.int] client_prefetch_threads: Parameter that specifies the number of threads used by the client to pre-fetch large result sets. The driver will attempt to honor the parameter value, but defines the minimum and maximum values (depending on your system’s resources) to improve performance. For more information, check [CLIENT*PREFETCH*THREADS docs](https://docs.snowflake.com/en/sql-reference/parameters#client-prefetch-threads).
        :param pulumi.Input[_builtins.int] client_result_chunk_size: Parameter that specifies the maximum size of each set (or chunk) of query results to download (in MB). The JDBC driver downloads query results in chunks. For more information, check [CLIENT*RESULT*CHUNK_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-chunk-size).
        :param pulumi.Input[_builtins.bool] client_result_column_case_insensitive: Parameter that indicates whether to match column name case-insensitively in ResultSet.get* methods in JDBC. For more information, check [CLIENT*RESULT*COLUMN*CASE*INSENSITIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-column-case-insensitive).
        :param pulumi.Input[_builtins.bool] client_session_keep_alive: Parameter that indicates whether to force a user to log in again after a period of inactivity in the session. For more information, check [CLIENT*SESSION*KEEP_ALIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive).
        :param pulumi.Input[_builtins.int] client_session_keep_alive_heartbeat_frequency: Number of seconds in-between client attempts to update the token for the session. For more information, check [CLIENT*SESSION*KEEP*ALIVE*HEARTBEAT_FREQUENCY docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive-heartbeat-frequency).
        :param pulumi.Input[_builtins.str] client_timestamp_type_mapping: Specifies the [TIMESTAMP_* variation](https://docs.snowflake.com/en/sql-reference/data-types-datetime.html#label-datatypes-timestamp-variations) to use when binding timestamp variables for JDBC or ODBC applications that use the bind API to load data. For more information, check [CLIENT*TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#client-timestamp-type-mapping).
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the task.
        :param pulumi.Input[_builtins.str] config: Specifies a string representation of key value pairs that can be accessed by all tasks in the task graph. Must be in JSON format.
        :param pulumi.Input[_builtins.str] database: The database in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] date_input_format: Specifies the input format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-input-format).
        :param pulumi.Input[_builtins.str] date_output_format: Specifies the display format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-output-format).
        :param pulumi.Input[_builtins.bool] enable_unload_physical_type_optimization: Specifies whether to set the schema for unloaded Parquet files based on the logical column data types (i.e. the types in the unload SQL query or source table) or on the unloaded column values (i.e. the smallest data types and precision that support the values in the output columns of the unload SQL statement or source table). For more information, check [ENABLE*UNLOAD*PHYSICAL*TYPE*OPTIMIZATION docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unload-physical-type-optimization).
        :param pulumi.Input[_builtins.str] error_integration: Specifies the name of the notification integration used for error notifications. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.bool] error_on_nondeterministic_merge: Specifies whether to return an error when the [MERGE](https://docs.snowflake.com/en/sql-reference/sql/merge) command is used to update or delete a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_MERGE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-merge).
        :param pulumi.Input[_builtins.bool] error_on_nondeterministic_update: Specifies whether to return an error when the [UPDATE](https://docs.snowflake.com/en/sql-reference/sql/update) command is used to update a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_UPDATE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-update).
        :param pulumi.Input[_builtins.str] finalize: Specifies the name of a root task that the finalizer task is associated with. Finalizer tasks run after all other tasks in the task graph run to completion. You can define the SQL of a finalizer task to handle notifications and the release and cleanup of resources that a task graph uses. For more information, see [Release and cleanup of task graphs](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-finalizer-task). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] geography_output_format: Display format for [GEOGRAPHY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geography). For more information, check [GEOGRAPHY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geography-output-format).
        :param pulumi.Input[_builtins.str] geometry_output_format: Display format for [GEOMETRY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geometry). For more information, check [GEOMETRY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geometry-output-format).
        :param pulumi.Input[_builtins.bool] jdbc_treat_timestamp_ntz_as_utc: Specifies how JDBC processes TIMESTAMP*NTZ values. For more information, check [JDBC*TREAT*TIMESTAMP*NTZ*AS*UTC docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-timestamp-ntz-as-utc).
        :param pulumi.Input[_builtins.bool] jdbc_use_session_timezone: Specifies whether the JDBC Driver uses the time zone of the JVM or the time zone of the session (specified by the [TIMEZONE](https://docs.snowflake.com/en/sql-reference/parameters#label-timezone) parameter) for the getDate(), getTime(), and getTimestamp() methods of the ResultSet class. For more information, check [JDBC*USE*SESSION_TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-use-session-timezone).
        :param pulumi.Input[_builtins.int] json_indent: Specifies the number of blank spaces to indent each new element in JSON output in the session. Also specifies whether to insert newline characters after each element. For more information, check [JSON_INDENT docs](https://docs.snowflake.com/en/sql-reference/parameters#json-indent).
        :param pulumi.Input[_builtins.int] lock_timeout: Number of seconds to wait while trying to lock a resource, before timing out and aborting the statement. For more information, check [LOCK_TIMEOUT docs](https://docs.snowflake.com/en/sql-reference/parameters#lock-timeout).
        :param pulumi.Input[_builtins.str] log_level: Specifies the severity level of messages that should be ingested and made available in the active event table. Messages at the specified level (and at more severe levels) are ingested. For more information about log levels, see [Setting log level](https://docs.snowflake.com/en/developer-guide/logging-tracing/logging-log-level). For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        :param pulumi.Input[_builtins.int] multi_statement_count: Number of statements to execute when using the multi-statement capability. For more information, check [MULTI*STATEMENT*COUNT docs](https://docs.snowflake.com/en/sql-reference/parameters#multi-statement-count).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the task; must be unique for the database and schema in which the task is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.bool] noorder_sequence_as_default: Specifies whether the ORDER or NOORDER property is set by default when you create a new sequence or add a new table column. The ORDER and NOORDER properties determine whether or not the values are generated for the sequence or auto-incremented column in [increasing or decreasing order](https://docs.snowflake.com/en/user-guide/querying-sequences.html#label-querying-sequences-increasing-values). For more information, check [NOORDER*SEQUENCE*AS_DEFAULT docs](https://docs.snowflake.com/en/sql-reference/parameters#noorder-sequence-as-default).
        :param pulumi.Input[_builtins.bool] odbc_treat_decimal_as_int: Specifies how ODBC processes columns that have a scale of zero (0). For more information, check [ODBC*TREAT*DECIMAL*AS*INT docs](https://docs.snowflake.com/en/sql-reference/parameters#odbc-treat-decimal-as-int).
        :param pulumi.Input[Sequence[pulumi.Input['TaskParameterArgs']]] parameters: Outputs the result of `SHOW PARAMETERS IN TASK` for the given task.
        :param pulumi.Input[_builtins.str] query_tag: Optional string that can be used to tag queries and other SQL statements executed within a session. The tags are displayed in the output of the [QUERY*HISTORY, QUERY*HISTORY*BY**](https://docs.snowflake.com/en/sql-reference/functions/query_history) functions. For more information, check [QUERY_TAG docs](https://docs.snowflake.com/en/sql-reference/parameters#query-tag).
        :param pulumi.Input[_builtins.bool] quoted_identifiers_ignore_case: Specifies whether letters in double-quoted object identifiers are stored and resolved as uppercase letters. By default, Snowflake preserves the case of alphabetic characters when storing and resolving double-quoted identifiers (see [Identifier resolution](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing)). You can use this parameter in situations in which [third-party applications always use double quotes around identifiers](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing-parameter). For more information, check [QUOTED*IDENTIFIERS*IGNORE_CASE docs](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        :param pulumi.Input[_builtins.int] rows_per_resultset: Specifies the maximum number of rows returned in a result set. A value of 0 specifies no maximum. For more information, check [ROWS*PER*RESULTSET docs](https://docs.snowflake.com/en/sql-reference/parameters#rows-per-resultset).
        :param pulumi.Input[_builtins.str] s3_stage_vpce_dns_name: Specifies the DNS name of an Amazon S3 interface endpoint. Requests sent to the internal stage of an account via [AWS PrivateLink for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/privatelink-interface-endpoints.html) use this endpoint to connect. For more information, see [Accessing Internal stages with dedicated interface endpoints](https://docs.snowflake.com/en/user-guide/private-internal-stages-aws.html#label-aws-privatelink-internal-stage-network-isolation). For more information, check [S3*STAGE*VPCE*DNS*NAME docs](https://docs.snowflake.com/en/sql-reference/parameters#s3-stage-vpce-dns-name).
        :param pulumi.Input['TaskScheduleArgs'] schedule: The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflicts with finalize and after; when set, one of the sub-fields `minutes` or `using_cron` should be set)
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] search_path: Specifies the path to search to resolve unqualified object names in queries. For more information, see [Name resolution in queries](https://docs.snowflake.com/en/sql-reference/name-resolution.html#label-object-name-resolution-search-path). Comma-separated list of identifiers. An identifier can be a fully or partially qualified schema name. For more information, check [SEARCH_PATH docs](https://docs.snowflake.com/en/sql-reference/parameters#search-path).
        :param pulumi.Input[Sequence[pulumi.Input['TaskShowOutputArgs']]] show_outputs: Outputs the result of `SHOW TASKS` for the given task.
        :param pulumi.Input[_builtins.str] sql_statement: Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        :param pulumi.Input[_builtins.bool] started: Specifies if the task should be started or suspended.
        :param pulumi.Input[_builtins.int] statement_queued_timeout_in_seconds: Amount of time, in seconds, a SQL statement (query, DDL, DML, etc.) remains queued for a warehouse before it is canceled by the system. This parameter can be used in conjunction with the [MAX*CONCURRENCY*LEVEL](https://docs.snowflake.com/en/sql-reference/parameters#label-max-concurrency-level) parameter to ensure a warehouse is never backlogged. For more information, check [STATEMENT*QUEUED*TIMEOUT*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-queued-timeout-in-seconds).
        :param pulumi.Input[_builtins.int] statement_timeout_in_seconds: Amount of time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system. For more information, check [STATEMENT*TIMEOUT*IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-timeout-in-seconds).
        :param pulumi.Input[_builtins.bool] strict_json_output: This parameter specifies whether JSON output in a session is compatible with the general standard (as described by [http://json.org](http://json.org)). By design, Snowflake allows JSON input that contains non-standard values; however, these non-standard values might result in Snowflake outputting JSON that is incompatible with other platforms and languages. This parameter, when enabled, ensures that Snowflake outputs valid/compatible JSON. For more information, check [STRICT*JSON*OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#strict-json-output).
        :param pulumi.Input[_builtins.int] suspend_task_after_num_failures: Specifies the number of consecutive failed task runs after which the current task is suspended automatically. The default is 0 (no automatic suspension). For more information, check [SUSPEND*TASK*AFTER*NUM*FAILURES docs](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        :param pulumi.Input[_builtins.int] task_auto_retry_attempts: Specifies the number of automatic task graph retry attempts. If any task graphs complete in a FAILED state, Snowflake can automatically retry the task graphs from the last task in the graph that failed. For more information, check [TASK*AUTO*RETRY_ATTEMPTS docs](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        :param pulumi.Input[_builtins.str] time_input_format: Specifies the input format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported time format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of times stored in the system during the session). For more information, check [TIME*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-input-format).
        :param pulumi.Input[_builtins.str] time_output_format: Specifies the display format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIME*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-output-format).
        :param pulumi.Input[_builtins.bool] timestamp_day_is_always24h: Specifies whether the [DATEADD](https://docs.snowflake.com/en/sql-reference/functions/dateadd) function (and its aliases) always consider a day to be exactly 24 hours for expressions that span multiple days. For more information, check [TIMESTAMP*DAY*IS*ALWAYS*24H docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-day-is-always-24h).
        :param pulumi.Input[_builtins.str] timestamp_input_format: Specifies the input format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported timestamp format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of timestamps stored in the system during the session). For more information, check [TIMESTAMP*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-input-format).
        :param pulumi.Input[_builtins.str] timestamp_ltz_output_format: Specifies the display format for the TIMESTAMP*LTZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*LTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ltz-output-format).
        :param pulumi.Input[_builtins.str] timestamp_ntz_output_format: Specifies the display format for the TIMESTAMP*NTZ data type. For more information, check [TIMESTAMP*NTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ntz-output-format).
        :param pulumi.Input[_builtins.str] timestamp_output_format: Specifies the display format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-output-format).
        :param pulumi.Input[_builtins.str] timestamp_type_mapping: Specifies the TIMESTAMP** variation that the TIMESTAMP data type alias maps to. For more information, check [TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-type-mapping).
        :param pulumi.Input[_builtins.str] timestamp_tz_output_format: Specifies the display format for the TIMESTAMP*TZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*TZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-tz-output-format).
        :param pulumi.Input[_builtins.str] timezone: Specifies the time zone for the session. You can specify a [time zone name](https://data.iana.org/time-zones/tzdb-2021a/zone1970.tab) or a [link name](https://data.iana.org/time-zones/tzdb-2021a/backward) from release 2021a of the [IANA Time Zone Database](https://www.iana.org/time-zones) (e.g. America/Los_Angeles, Europe/London, UTC, Etc/GMT, etc.). For more information, check [TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#timezone).
        :param pulumi.Input[_builtins.str] trace_level: Controls how trace events are ingested into the event table. For more information about trace levels, see [Setting trace level](https://docs.snowflake.com/en/developer-guide/logging-tracing/tracing-trace-level). For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        :param pulumi.Input[_builtins.bool] transaction_abort_on_error: Specifies the action to perform when a statement issued within a non-autocommit transaction returns with an error. For more information, check [TRANSACTION*ABORT*ON_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-abort-on-error).
        :param pulumi.Input[_builtins.str] transaction_default_isolation_level: Specifies the isolation level for transactions in the user session. For more information, check [TRANSACTION*DEFAULT*ISOLATION_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-default-isolation-level).
        :param pulumi.Input[_builtins.int] two_digit_century_start: Specifies the “century start” year for 2-digit years (i.e. the earliest year such dates can represent). This parameter prevents ambiguous dates when importing or converting data with the `YY` date format component (i.e. years represented as 2 digits). For more information, check [TWO*DIGIT*CENTURY_START docs](https://docs.snowflake.com/en/sql-reference/parameters#two-digit-century-start).
        :param pulumi.Input[_builtins.str] unsupported_ddl_action: Determines if an unsupported (i.e. non-default) value specified for a constraint property returns an error. For more information, check [UNSUPPORTED*DDL*ACTION docs](https://docs.snowflake.com/en/sql-reference/parameters#unsupported-ddl-action).
        :param pulumi.Input[_builtins.bool] use_cached_result: Specifies whether to reuse persisted query results, if available, when a matching query is submitted. For more information, check [USE*CACHED*RESULT docs](https://docs.snowflake.com/en/sql-reference/parameters#use-cached-result).
        :param pulumi.Input[_builtins.str] user_task_managed_initial_warehouse_size: Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. Valid values are (case-insensitive): %s. (Conflicts with warehouse). For more information about warehouses, see docs. For more information, check [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        :param pulumi.Input[_builtins.int] user_task_minimum_trigger_interval_in_seconds: Minimum amount of time between Triggered Task executions in seconds For more information, check [USER*TASK*MINIMUM*TRIGGER*INTERVAL*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-minimum-trigger-interval-in-seconds).
        :param pulumi.Input[_builtins.int] user_task_timeout_ms: Specifies the time limit on a single run of the task before it times out (in milliseconds). For more information, check [USER*TASK*TIMEOUT_MS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        :param pulumi.Input[_builtins.str] warehouse: The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. Due to Snowflake limitations warehouse identifier can consist of only upper-cased letters. (Conflicts with user*task*managed*initial*warehouse_size) For more information about this resource, see docs.
        :param pulumi.Input[_builtins.int] week_of_year_policy: Specifies how the weeks in a given year are computed. `0`: The semantics used are equivalent to the ISO semantics, in which a week belongs to a given year if at least 4 days of that week are in that year. `1`: January 1 is included in the first week of the year and December 31 is included in the last week of the year. For more information, check [WEEK*OF*YEAR_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#week-of-year-policy).
        :param pulumi.Input[_builtins.int] week_start: Specifies the first day of the week (used by week-related date functions). `0`: Legacy Snowflake behavior is used (i.e. ISO-like semantics). `1` (Monday) to `7` (Sunday): All the week-related functions use weeks that start on the specified day of the week. For more information, check [WEEK_START docs](https://docs.snowflake.com/en/sql-reference/parameters#week-start).
        :param pulumi.Input[_builtins.str] when: Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported. When a task is triggered (based on its SCHEDULE or AFTER setting), it validates the conditions of the expression to determine whether to execute. If the conditions of the expression are not met, then the task skips the current run. Any tasks that identify this task as a predecessor also don’t run.
        """
        if abort_detached_query is not None:
            pulumi.set(__self__, "abort_detached_query", abort_detached_query)
        if afters is not None:
            pulumi.set(__self__, "afters", afters)
        if allow_overlapping_execution is not None:
            pulumi.set(__self__, "allow_overlapping_execution", allow_overlapping_execution)
        if autocommit is not None:
            pulumi.set(__self__, "autocommit", autocommit)
        if binary_input_format is not None:
            pulumi.set(__self__, "binary_input_format", binary_input_format)
        if binary_output_format is not None:
            pulumi.set(__self__, "binary_output_format", binary_output_format)
        if client_memory_limit is not None:
            pulumi.set(__self__, "client_memory_limit", client_memory_limit)
        if client_metadata_request_use_connection_ctx is not None:
            pulumi.set(__self__, "client_metadata_request_use_connection_ctx", client_metadata_request_use_connection_ctx)
        if client_prefetch_threads is not None:
            pulumi.set(__self__, "client_prefetch_threads", client_prefetch_threads)
        if client_result_chunk_size is not None:
            pulumi.set(__self__, "client_result_chunk_size", client_result_chunk_size)
        if client_result_column_case_insensitive is not None:
            pulumi.set(__self__, "client_result_column_case_insensitive", client_result_column_case_insensitive)
        if client_session_keep_alive is not None:
            pulumi.set(__self__, "client_session_keep_alive", client_session_keep_alive)
        if client_session_keep_alive_heartbeat_frequency is not None:
            pulumi.set(__self__, "client_session_keep_alive_heartbeat_frequency", client_session_keep_alive_heartbeat_frequency)
        if client_timestamp_type_mapping is not None:
            pulumi.set(__self__, "client_timestamp_type_mapping", client_timestamp_type_mapping)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if date_input_format is not None:
            pulumi.set(__self__, "date_input_format", date_input_format)
        if date_output_format is not None:
            pulumi.set(__self__, "date_output_format", date_output_format)
        if enable_unload_physical_type_optimization is not None:
            pulumi.set(__self__, "enable_unload_physical_type_optimization", enable_unload_physical_type_optimization)
        if error_integration is not None:
            pulumi.set(__self__, "error_integration", error_integration)
        if error_on_nondeterministic_merge is not None:
            pulumi.set(__self__, "error_on_nondeterministic_merge", error_on_nondeterministic_merge)
        if error_on_nondeterministic_update is not None:
            pulumi.set(__self__, "error_on_nondeterministic_update", error_on_nondeterministic_update)
        if finalize is not None:
            pulumi.set(__self__, "finalize", finalize)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if geography_output_format is not None:
            pulumi.set(__self__, "geography_output_format", geography_output_format)
        if geometry_output_format is not None:
            pulumi.set(__self__, "geometry_output_format", geometry_output_format)
        if jdbc_treat_timestamp_ntz_as_utc is not None:
            pulumi.set(__self__, "jdbc_treat_timestamp_ntz_as_utc", jdbc_treat_timestamp_ntz_as_utc)
        if jdbc_use_session_timezone is not None:
            pulumi.set(__self__, "jdbc_use_session_timezone", jdbc_use_session_timezone)
        if json_indent is not None:
            pulumi.set(__self__, "json_indent", json_indent)
        if lock_timeout is not None:
            pulumi.set(__self__, "lock_timeout", lock_timeout)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if multi_statement_count is not None:
            pulumi.set(__self__, "multi_statement_count", multi_statement_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if noorder_sequence_as_default is not None:
            pulumi.set(__self__, "noorder_sequence_as_default", noorder_sequence_as_default)
        if odbc_treat_decimal_as_int is not None:
            pulumi.set(__self__, "odbc_treat_decimal_as_int", odbc_treat_decimal_as_int)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if query_tag is not None:
            pulumi.set(__self__, "query_tag", query_tag)
        if quoted_identifiers_ignore_case is not None:
            pulumi.set(__self__, "quoted_identifiers_ignore_case", quoted_identifiers_ignore_case)
        if rows_per_resultset is not None:
            pulumi.set(__self__, "rows_per_resultset", rows_per_resultset)
        if s3_stage_vpce_dns_name is not None:
            pulumi.set(__self__, "s3_stage_vpce_dns_name", s3_stage_vpce_dns_name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if search_path is not None:
            pulumi.set(__self__, "search_path", search_path)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)
        if sql_statement is not None:
            pulumi.set(__self__, "sql_statement", sql_statement)
        if started is not None:
            pulumi.set(__self__, "started", started)
        if statement_queued_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_queued_timeout_in_seconds", statement_queued_timeout_in_seconds)
        if statement_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_timeout_in_seconds", statement_timeout_in_seconds)
        if strict_json_output is not None:
            pulumi.set(__self__, "strict_json_output", strict_json_output)
        if suspend_task_after_num_failures is not None:
            pulumi.set(__self__, "suspend_task_after_num_failures", suspend_task_after_num_failures)
        if task_auto_retry_attempts is not None:
            pulumi.set(__self__, "task_auto_retry_attempts", task_auto_retry_attempts)
        if time_input_format is not None:
            pulumi.set(__self__, "time_input_format", time_input_format)
        if time_output_format is not None:
            pulumi.set(__self__, "time_output_format", time_output_format)
        if timestamp_day_is_always24h is not None:
            pulumi.set(__self__, "timestamp_day_is_always24h", timestamp_day_is_always24h)
        if timestamp_input_format is not None:
            pulumi.set(__self__, "timestamp_input_format", timestamp_input_format)
        if timestamp_ltz_output_format is not None:
            pulumi.set(__self__, "timestamp_ltz_output_format", timestamp_ltz_output_format)
        if timestamp_ntz_output_format is not None:
            pulumi.set(__self__, "timestamp_ntz_output_format", timestamp_ntz_output_format)
        if timestamp_output_format is not None:
            pulumi.set(__self__, "timestamp_output_format", timestamp_output_format)
        if timestamp_type_mapping is not None:
            pulumi.set(__self__, "timestamp_type_mapping", timestamp_type_mapping)
        if timestamp_tz_output_format is not None:
            pulumi.set(__self__, "timestamp_tz_output_format", timestamp_tz_output_format)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if trace_level is not None:
            pulumi.set(__self__, "trace_level", trace_level)
        if transaction_abort_on_error is not None:
            pulumi.set(__self__, "transaction_abort_on_error", transaction_abort_on_error)
        if transaction_default_isolation_level is not None:
            pulumi.set(__self__, "transaction_default_isolation_level", transaction_default_isolation_level)
        if two_digit_century_start is not None:
            pulumi.set(__self__, "two_digit_century_start", two_digit_century_start)
        if unsupported_ddl_action is not None:
            pulumi.set(__self__, "unsupported_ddl_action", unsupported_ddl_action)
        if use_cached_result is not None:
            pulumi.set(__self__, "use_cached_result", use_cached_result)
        if user_task_managed_initial_warehouse_size is not None:
            pulumi.set(__self__, "user_task_managed_initial_warehouse_size", user_task_managed_initial_warehouse_size)
        if user_task_minimum_trigger_interval_in_seconds is not None:
            pulumi.set(__self__, "user_task_minimum_trigger_interval_in_seconds", user_task_minimum_trigger_interval_in_seconds)
        if user_task_timeout_ms is not None:
            pulumi.set(__self__, "user_task_timeout_ms", user_task_timeout_ms)
        if warehouse is not None:
            pulumi.set(__self__, "warehouse", warehouse)
        if week_of_year_policy is not None:
            pulumi.set(__self__, "week_of_year_policy", week_of_year_policy)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)
        if when is not None:
            pulumi.set(__self__, "when", when)

    @_builtins.property
    @pulumi.getter(name="abortDetachedQuery")
    def abort_detached_query(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the action that Snowflake performs for in-progress queries if connectivity is lost due to abrupt termination of a session (e.g. network outage, browser termination, service interruption). For more information, check [ABORT*DETACHED*QUERY docs](https://docs.snowflake.com/en/sql-reference/parameters#abort-detached-query).
        """
        return pulumi.get(self, "abort_detached_query")

    @abort_detached_query.setter
    def abort_detached_query(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "abort_detached_query", value)

    @_builtins.property
    @pulumi.getter
    def afters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies one or more predecessor tasks for the current task. Use this option to [create a DAG](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-task-dag) of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "afters")

    @afters.setter
    def afters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "afters", value)

    @_builtins.property
    @pulumi.getter(name="allowOverlappingExecution")
    def allow_overlapping_execution(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "allow_overlapping_execution")

    @allow_overlapping_execution.setter
    def allow_overlapping_execution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allow_overlapping_execution", value)

    @_builtins.property
    @pulumi.getter
    def autocommit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether autocommit is enabled for the session. Autocommit determines whether a DML statement, when executed without an active transaction, is automatically committed after the statement successfully completes. For more information, see [Transactions](https://docs.snowflake.com/en/sql-reference/transactions). For more information, check [AUTOCOMMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#autocommit).
        """
        return pulumi.get(self, "autocommit")

    @autocommit.setter
    def autocommit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autocommit", value)

    @_builtins.property
    @pulumi.getter(name="binaryInputFormat")
    def binary_input_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of VARCHAR values passed as input to VARCHAR-to-BINARY conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-input-format).
        """
        return pulumi.get(self, "binary_input_format")

    @binary_input_format.setter
    def binary_input_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binary_input_format", value)

    @_builtins.property
    @pulumi.getter(name="binaryOutputFormat")
    def binary_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format for VARCHAR values returned as output by BINARY-to-VARCHAR conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-output-format).
        """
        return pulumi.get(self, "binary_output_format")

    @binary_output_format.setter
    def binary_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binary_output_format", value)

    @_builtins.property
    @pulumi.getter(name="clientMemoryLimit")
    def client_memory_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Parameter that specifies the maximum amount of memory the JDBC driver or ODBC driver should use for the result set from queries (in MB). For more information, check [CLIENT*MEMORY*LIMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#client-memory-limit).
        """
        return pulumi.get(self, "client_memory_limit")

    @client_memory_limit.setter
    def client_memory_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_memory_limit", value)

    @_builtins.property
    @pulumi.getter(name="clientMetadataRequestUseConnectionCtx")
    def client_metadata_request_use_connection_ctx(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        For specific ODBC functions and JDBC methods, this parameter can change the default search scope from all databases/schemas to the current database/schema. The narrower search typically returns fewer rows and executes more quickly. For more information, check [CLIENT*METADATA*REQUEST*USE*CONNECTION_CTX docs](https://docs.snowflake.com/en/sql-reference/parameters#client-metadata-request-use-connection-ctx).
        """
        return pulumi.get(self, "client_metadata_request_use_connection_ctx")

    @client_metadata_request_use_connection_ctx.setter
    def client_metadata_request_use_connection_ctx(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_metadata_request_use_connection_ctx", value)

    @_builtins.property
    @pulumi.getter(name="clientPrefetchThreads")
    def client_prefetch_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Parameter that specifies the number of threads used by the client to pre-fetch large result sets. The driver will attempt to honor the parameter value, but defines the minimum and maximum values (depending on your system’s resources) to improve performance. For more information, check [CLIENT*PREFETCH*THREADS docs](https://docs.snowflake.com/en/sql-reference/parameters#client-prefetch-threads).
        """
        return pulumi.get(self, "client_prefetch_threads")

    @client_prefetch_threads.setter
    def client_prefetch_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_prefetch_threads", value)

    @_builtins.property
    @pulumi.getter(name="clientResultChunkSize")
    def client_result_chunk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Parameter that specifies the maximum size of each set (or chunk) of query results to download (in MB). The JDBC driver downloads query results in chunks. For more information, check [CLIENT*RESULT*CHUNK_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-chunk-size).
        """
        return pulumi.get(self, "client_result_chunk_size")

    @client_result_chunk_size.setter
    def client_result_chunk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_result_chunk_size", value)

    @_builtins.property
    @pulumi.getter(name="clientResultColumnCaseInsensitive")
    def client_result_column_case_insensitive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Parameter that indicates whether to match column name case-insensitively in ResultSet.get* methods in JDBC. For more information, check [CLIENT*RESULT*COLUMN*CASE*INSENSITIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-column-case-insensitive).
        """
        return pulumi.get(self, "client_result_column_case_insensitive")

    @client_result_column_case_insensitive.setter
    def client_result_column_case_insensitive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_result_column_case_insensitive", value)

    @_builtins.property
    @pulumi.getter(name="clientSessionKeepAlive")
    def client_session_keep_alive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Parameter that indicates whether to force a user to log in again after a period of inactivity in the session. For more information, check [CLIENT*SESSION*KEEP_ALIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive).
        """
        return pulumi.get(self, "client_session_keep_alive")

    @client_session_keep_alive.setter
    def client_session_keep_alive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_session_keep_alive", value)

    @_builtins.property
    @pulumi.getter(name="clientSessionKeepAliveHeartbeatFrequency")
    def client_session_keep_alive_heartbeat_frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds in-between client attempts to update the token for the session. For more information, check [CLIENT*SESSION*KEEP*ALIVE*HEARTBEAT_FREQUENCY docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive-heartbeat-frequency).
        """
        return pulumi.get(self, "client_session_keep_alive_heartbeat_frequency")

    @client_session_keep_alive_heartbeat_frequency.setter
    def client_session_keep_alive_heartbeat_frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_session_keep_alive_heartbeat_frequency", value)

    @_builtins.property
    @pulumi.getter(name="clientTimestampTypeMapping")
    def client_timestamp_type_mapping(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the [TIMESTAMP_* variation](https://docs.snowflake.com/en/sql-reference/data-types-datetime.html#label-datatypes-timestamp-variations) to use when binding timestamp variables for JDBC or ODBC applications that use the bind API to load data. For more information, check [CLIENT*TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#client-timestamp-type-mapping).
        """
        return pulumi.get(self, "client_timestamp_type_mapping")

    @client_timestamp_type_mapping.setter
    def client_timestamp_type_mapping(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_timestamp_type_mapping", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the task.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a string representation of key value pairs that can be accessed by all tasks in the task graph. Must be in JSON format.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="dateInputFormat")
    def date_input_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the input format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-input-format).
        """
        return pulumi.get(self, "date_input_format")

    @date_input_format.setter
    def date_input_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_input_format", value)

    @_builtins.property
    @pulumi.getter(name="dateOutputFormat")
    def date_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-output-format).
        """
        return pulumi.get(self, "date_output_format")

    @date_output_format.setter
    def date_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_output_format", value)

    @_builtins.property
    @pulumi.getter(name="enableUnloadPhysicalTypeOptimization")
    def enable_unload_physical_type_optimization(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to set the schema for unloaded Parquet files based on the logical column data types (i.e. the types in the unload SQL query or source table) or on the unloaded column values (i.e. the smallest data types and precision that support the values in the output columns of the unload SQL statement or source table). For more information, check [ENABLE*UNLOAD*PHYSICAL*TYPE*OPTIMIZATION docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unload-physical-type-optimization).
        """
        return pulumi.get(self, "enable_unload_physical_type_optimization")

    @enable_unload_physical_type_optimization.setter
    def enable_unload_physical_type_optimization(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_unload_physical_type_optimization", value)

    @_builtins.property
    @pulumi.getter(name="errorIntegration")
    def error_integration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the notification integration used for error notifications. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        """
        return pulumi.get(self, "error_integration")

    @error_integration.setter
    def error_integration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_integration", value)

    @_builtins.property
    @pulumi.getter(name="errorOnNondeterministicMerge")
    def error_on_nondeterministic_merge(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to return an error when the [MERGE](https://docs.snowflake.com/en/sql-reference/sql/merge) command is used to update or delete a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_MERGE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-merge).
        """
        return pulumi.get(self, "error_on_nondeterministic_merge")

    @error_on_nondeterministic_merge.setter
    def error_on_nondeterministic_merge(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "error_on_nondeterministic_merge", value)

    @_builtins.property
    @pulumi.getter(name="errorOnNondeterministicUpdate")
    def error_on_nondeterministic_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to return an error when the [UPDATE](https://docs.snowflake.com/en/sql-reference/sql/update) command is used to update a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_UPDATE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-update).
        """
        return pulumi.get(self, "error_on_nondeterministic_update")

    @error_on_nondeterministic_update.setter
    def error_on_nondeterministic_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "error_on_nondeterministic_update", value)

    @_builtins.property
    @pulumi.getter
    def finalize(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of a root task that the finalizer task is associated with. Finalizer tasks run after all other tasks in the task graph run to completion. You can define the SQL of a finalizer task to handle notifications and the release and cleanup of resources that a task graph uses. For more information, see [Release and cleanup of task graphs](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-finalizer-task). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "finalize")

    @finalize.setter
    def finalize(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "finalize", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter(name="geographyOutputFormat")
    def geography_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display format for [GEOGRAPHY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geography). For more information, check [GEOGRAPHY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geography-output-format).
        """
        return pulumi.get(self, "geography_output_format")

    @geography_output_format.setter
    def geography_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geography_output_format", value)

    @_builtins.property
    @pulumi.getter(name="geometryOutputFormat")
    def geometry_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display format for [GEOMETRY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geometry). For more information, check [GEOMETRY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geometry-output-format).
        """
        return pulumi.get(self, "geometry_output_format")

    @geometry_output_format.setter
    def geometry_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geometry_output_format", value)

    @_builtins.property
    @pulumi.getter(name="jdbcTreatTimestampNtzAsUtc")
    def jdbc_treat_timestamp_ntz_as_utc(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies how JDBC processes TIMESTAMP*NTZ values. For more information, check [JDBC*TREAT*TIMESTAMP*NTZ*AS*UTC docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-timestamp-ntz-as-utc).
        """
        return pulumi.get(self, "jdbc_treat_timestamp_ntz_as_utc")

    @jdbc_treat_timestamp_ntz_as_utc.setter
    def jdbc_treat_timestamp_ntz_as_utc(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "jdbc_treat_timestamp_ntz_as_utc", value)

    @_builtins.property
    @pulumi.getter(name="jdbcUseSessionTimezone")
    def jdbc_use_session_timezone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the JDBC Driver uses the time zone of the JVM or the time zone of the session (specified by the [TIMEZONE](https://docs.snowflake.com/en/sql-reference/parameters#label-timezone) parameter) for the getDate(), getTime(), and getTimestamp() methods of the ResultSet class. For more information, check [JDBC*USE*SESSION_TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-use-session-timezone).
        """
        return pulumi.get(self, "jdbc_use_session_timezone")

    @jdbc_use_session_timezone.setter
    def jdbc_use_session_timezone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "jdbc_use_session_timezone", value)

    @_builtins.property
    @pulumi.getter(name="jsonIndent")
    def json_indent(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of blank spaces to indent each new element in JSON output in the session. Also specifies whether to insert newline characters after each element. For more information, check [JSON_INDENT docs](https://docs.snowflake.com/en/sql-reference/parameters#json-indent).
        """
        return pulumi.get(self, "json_indent")

    @json_indent.setter
    def json_indent(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "json_indent", value)

    @_builtins.property
    @pulumi.getter(name="lockTimeout")
    def lock_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds to wait while trying to lock a resource, before timing out and aborting the statement. For more information, check [LOCK_TIMEOUT docs](https://docs.snowflake.com/en/sql-reference/parameters#lock-timeout).
        """
        return pulumi.get(self, "lock_timeout")

    @lock_timeout.setter
    def lock_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lock_timeout", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the severity level of messages that should be ingested and made available in the active event table. Messages at the specified level (and at more severe levels) are ingested. For more information about log levels, see [Setting log level](https://docs.snowflake.com/en/developer-guide/logging-tracing/logging-log-level). For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter(name="multiStatementCount")
    def multi_statement_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of statements to execute when using the multi-statement capability. For more information, check [MULTI*STATEMENT*COUNT docs](https://docs.snowflake.com/en/sql-reference/parameters#multi-statement-count).
        """
        return pulumi.get(self, "multi_statement_count")

    @multi_statement_count.setter
    def multi_statement_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "multi_statement_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the task; must be unique for the database and schema in which the task is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="noorderSequenceAsDefault")
    def noorder_sequence_as_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the ORDER or NOORDER property is set by default when you create a new sequence or add a new table column. The ORDER and NOORDER properties determine whether or not the values are generated for the sequence or auto-incremented column in [increasing or decreasing order](https://docs.snowflake.com/en/user-guide/querying-sequences.html#label-querying-sequences-increasing-values). For more information, check [NOORDER*SEQUENCE*AS_DEFAULT docs](https://docs.snowflake.com/en/sql-reference/parameters#noorder-sequence-as-default).
        """
        return pulumi.get(self, "noorder_sequence_as_default")

    @noorder_sequence_as_default.setter
    def noorder_sequence_as_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "noorder_sequence_as_default", value)

    @_builtins.property
    @pulumi.getter(name="odbcTreatDecimalAsInt")
    def odbc_treat_decimal_as_int(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies how ODBC processes columns that have a scale of zero (0). For more information, check [ODBC*TREAT*DECIMAL*AS*INT docs](https://docs.snowflake.com/en/sql-reference/parameters#odbc-treat-decimal-as-int).
        """
        return pulumi.get(self, "odbc_treat_decimal_as_int")

    @odbc_treat_decimal_as_int.setter
    def odbc_treat_decimal_as_int(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "odbc_treat_decimal_as_int", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskParameterArgs']]]]:
        """
        Outputs the result of `SHOW PARAMETERS IN TASK` for the given task.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="queryTag")
    def query_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional string that can be used to tag queries and other SQL statements executed within a session. The tags are displayed in the output of the [QUERY*HISTORY, QUERY*HISTORY*BY**](https://docs.snowflake.com/en/sql-reference/functions/query_history) functions. For more information, check [QUERY_TAG docs](https://docs.snowflake.com/en/sql-reference/parameters#query-tag).
        """
        return pulumi.get(self, "query_tag")

    @query_tag.setter
    def query_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_tag", value)

    @_builtins.property
    @pulumi.getter(name="quotedIdentifiersIgnoreCase")
    def quoted_identifiers_ignore_case(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether letters in double-quoted object identifiers are stored and resolved as uppercase letters. By default, Snowflake preserves the case of alphabetic characters when storing and resolving double-quoted identifiers (see [Identifier resolution](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing)). You can use this parameter in situations in which [third-party applications always use double quotes around identifiers](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing-parameter). For more information, check [QUOTED*IDENTIFIERS*IGNORE_CASE docs](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        """
        return pulumi.get(self, "quoted_identifiers_ignore_case")

    @quoted_identifiers_ignore_case.setter
    def quoted_identifiers_ignore_case(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "quoted_identifiers_ignore_case", value)

    @_builtins.property
    @pulumi.getter(name="rowsPerResultset")
    def rows_per_resultset(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of rows returned in a result set. A value of 0 specifies no maximum. For more information, check [ROWS*PER*RESULTSET docs](https://docs.snowflake.com/en/sql-reference/parameters#rows-per-resultset).
        """
        return pulumi.get(self, "rows_per_resultset")

    @rows_per_resultset.setter
    def rows_per_resultset(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rows_per_resultset", value)

    @_builtins.property
    @pulumi.getter(name="s3StageVpceDnsName")
    def s3_stage_vpce_dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DNS name of an Amazon S3 interface endpoint. Requests sent to the internal stage of an account via [AWS PrivateLink for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/privatelink-interface-endpoints.html) use this endpoint to connect. For more information, see [Accessing Internal stages with dedicated interface endpoints](https://docs.snowflake.com/en/user-guide/private-internal-stages-aws.html#label-aws-privatelink-internal-stage-network-isolation). For more information, check [S3*STAGE*VPCE*DNS*NAME docs](https://docs.snowflake.com/en/sql-reference/parameters#s3-stage-vpce-dns-name).
        """
        return pulumi.get(self, "s3_stage_vpce_dns_name")

    @s3_stage_vpce_dns_name.setter
    def s3_stage_vpce_dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_stage_vpce_dns_name", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['TaskScheduleArgs']]:
        """
        The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflicts with finalize and after; when set, one of the sub-fields `minutes` or `using_cron` should be set)
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['TaskScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="searchPath")
    def search_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the path to search to resolve unqualified object names in queries. For more information, see [Name resolution in queries](https://docs.snowflake.com/en/sql-reference/name-resolution.html#label-object-name-resolution-search-path). Comma-separated list of identifiers. An identifier can be a fully or partially qualified schema name. For more information, check [SEARCH_PATH docs](https://docs.snowflake.com/en/sql-reference/parameters#search-path).
        """
        return pulumi.get(self, "search_path")

    @search_path.setter
    def search_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_path", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW TASKS` for the given task.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)

    @_builtins.property
    @pulumi.getter(name="sqlStatement")
    def sql_statement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        """
        return pulumi.get(self, "sql_statement")

    @sql_statement.setter
    def sql_statement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_statement", value)

    @_builtins.property
    @pulumi.getter
    def started(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the task should be started or suspended.
        """
        return pulumi.get(self, "started")

    @started.setter
    def started(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "started", value)

    @_builtins.property
    @pulumi.getter(name="statementQueuedTimeoutInSeconds")
    def statement_queued_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time, in seconds, a SQL statement (query, DDL, DML, etc.) remains queued for a warehouse before it is canceled by the system. This parameter can be used in conjunction with the [MAX*CONCURRENCY*LEVEL](https://docs.snowflake.com/en/sql-reference/parameters#label-max-concurrency-level) parameter to ensure a warehouse is never backlogged. For more information, check [STATEMENT*QUEUED*TIMEOUT*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-queued-timeout-in-seconds).
        """
        return pulumi.get(self, "statement_queued_timeout_in_seconds")

    @statement_queued_timeout_in_seconds.setter
    def statement_queued_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "statement_queued_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="statementTimeoutInSeconds")
    def statement_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system. For more information, check [STATEMENT*TIMEOUT*IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-timeout-in-seconds).
        """
        return pulumi.get(self, "statement_timeout_in_seconds")

    @statement_timeout_in_seconds.setter
    def statement_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "statement_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="strictJsonOutput")
    def strict_json_output(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter specifies whether JSON output in a session is compatible with the general standard (as described by [http://json.org](http://json.org)). By design, Snowflake allows JSON input that contains non-standard values; however, these non-standard values might result in Snowflake outputting JSON that is incompatible with other platforms and languages. This parameter, when enabled, ensures that Snowflake outputs valid/compatible JSON. For more information, check [STRICT*JSON*OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#strict-json-output).
        """
        return pulumi.get(self, "strict_json_output")

    @strict_json_output.setter
    def strict_json_output(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strict_json_output", value)

    @_builtins.property
    @pulumi.getter(name="suspendTaskAfterNumFailures")
    def suspend_task_after_num_failures(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of consecutive failed task runs after which the current task is suspended automatically. The default is 0 (no automatic suspension). For more information, check [SUSPEND*TASK*AFTER*NUM*FAILURES docs](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        """
        return pulumi.get(self, "suspend_task_after_num_failures")

    @suspend_task_after_num_failures.setter
    def suspend_task_after_num_failures(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "suspend_task_after_num_failures", value)

    @_builtins.property
    @pulumi.getter(name="taskAutoRetryAttempts")
    def task_auto_retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of automatic task graph retry attempts. If any task graphs complete in a FAILED state, Snowflake can automatically retry the task graphs from the last task in the graph that failed. For more information, check [TASK*AUTO*RETRY_ATTEMPTS docs](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        """
        return pulumi.get(self, "task_auto_retry_attempts")

    @task_auto_retry_attempts.setter
    def task_auto_retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "task_auto_retry_attempts", value)

    @_builtins.property
    @pulumi.getter(name="timeInputFormat")
    def time_input_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the input format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported time format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of times stored in the system during the session). For more information, check [TIME*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-input-format).
        """
        return pulumi.get(self, "time_input_format")

    @time_input_format.setter
    def time_input_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_input_format", value)

    @_builtins.property
    @pulumi.getter(name="timeOutputFormat")
    def time_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIME*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-output-format).
        """
        return pulumi.get(self, "time_output_format")

    @time_output_format.setter
    def time_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_output_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampDayIsAlways24h")
    def timestamp_day_is_always24h(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the [DATEADD](https://docs.snowflake.com/en/sql-reference/functions/dateadd) function (and its aliases) always consider a day to be exactly 24 hours for expressions that span multiple days. For more information, check [TIMESTAMP*DAY*IS*ALWAYS*24H docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-day-is-always-24h).
        """
        return pulumi.get(self, "timestamp_day_is_always24h")

    @timestamp_day_is_always24h.setter
    def timestamp_day_is_always24h(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "timestamp_day_is_always24h", value)

    @_builtins.property
    @pulumi.getter(name="timestampInputFormat")
    def timestamp_input_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the input format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported timestamp format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of timestamps stored in the system during the session). For more information, check [TIMESTAMP*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-input-format).
        """
        return pulumi.get(self, "timestamp_input_format")

    @timestamp_input_format.setter
    def timestamp_input_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_input_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampLtzOutputFormat")
    def timestamp_ltz_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the TIMESTAMP*LTZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*LTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ltz-output-format).
        """
        return pulumi.get(self, "timestamp_ltz_output_format")

    @timestamp_ltz_output_format.setter
    def timestamp_ltz_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_ltz_output_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampNtzOutputFormat")
    def timestamp_ntz_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the TIMESTAMP*NTZ data type. For more information, check [TIMESTAMP*NTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ntz-output-format).
        """
        return pulumi.get(self, "timestamp_ntz_output_format")

    @timestamp_ntz_output_format.setter
    def timestamp_ntz_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_ntz_output_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampOutputFormat")
    def timestamp_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-output-format).
        """
        return pulumi.get(self, "timestamp_output_format")

    @timestamp_output_format.setter
    def timestamp_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_output_format", value)

    @_builtins.property
    @pulumi.getter(name="timestampTypeMapping")
    def timestamp_type_mapping(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the TIMESTAMP** variation that the TIMESTAMP data type alias maps to. For more information, check [TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-type-mapping).
        """
        return pulumi.get(self, "timestamp_type_mapping")

    @timestamp_type_mapping.setter
    def timestamp_type_mapping(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_type_mapping", value)

    @_builtins.property
    @pulumi.getter(name="timestampTzOutputFormat")
    def timestamp_tz_output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display format for the TIMESTAMP*TZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*TZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-tz-output-format).
        """
        return pulumi.get(self, "timestamp_tz_output_format")

    @timestamp_tz_output_format.setter
    def timestamp_tz_output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp_tz_output_format", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time zone for the session. You can specify a [time zone name](https://data.iana.org/time-zones/tzdb-2021a/zone1970.tab) or a [link name](https://data.iana.org/time-zones/tzdb-2021a/backward) from release 2021a of the [IANA Time Zone Database](https://www.iana.org/time-zones) (e.g. America/Los_Angeles, Europe/London, UTC, Etc/GMT, etc.). For more information, check [TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#timezone).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="traceLevel")
    def trace_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how trace events are ingested into the event table. For more information about trace levels, see [Setting trace level](https://docs.snowflake.com/en/developer-guide/logging-tracing/tracing-trace-level). For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        """
        return pulumi.get(self, "trace_level")

    @trace_level.setter
    def trace_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trace_level", value)

    @_builtins.property
    @pulumi.getter(name="transactionAbortOnError")
    def transaction_abort_on_error(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the action to perform when a statement issued within a non-autocommit transaction returns with an error. For more information, check [TRANSACTION*ABORT*ON_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-abort-on-error).
        """
        return pulumi.get(self, "transaction_abort_on_error")

    @transaction_abort_on_error.setter
    def transaction_abort_on_error(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transaction_abort_on_error", value)

    @_builtins.property
    @pulumi.getter(name="transactionDefaultIsolationLevel")
    def transaction_default_isolation_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the isolation level for transactions in the user session. For more information, check [TRANSACTION*DEFAULT*ISOLATION_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-default-isolation-level).
        """
        return pulumi.get(self, "transaction_default_isolation_level")

    @transaction_default_isolation_level.setter
    def transaction_default_isolation_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transaction_default_isolation_level", value)

    @_builtins.property
    @pulumi.getter(name="twoDigitCenturyStart")
    def two_digit_century_start(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the “century start” year for 2-digit years (i.e. the earliest year such dates can represent). This parameter prevents ambiguous dates when importing or converting data with the `YY` date format component (i.e. years represented as 2 digits). For more information, check [TWO*DIGIT*CENTURY_START docs](https://docs.snowflake.com/en/sql-reference/parameters#two-digit-century-start).
        """
        return pulumi.get(self, "two_digit_century_start")

    @two_digit_century_start.setter
    def two_digit_century_start(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "two_digit_century_start", value)

    @_builtins.property
    @pulumi.getter(name="unsupportedDdlAction")
    def unsupported_ddl_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines if an unsupported (i.e. non-default) value specified for a constraint property returns an error. For more information, check [UNSUPPORTED*DDL*ACTION docs](https://docs.snowflake.com/en/sql-reference/parameters#unsupported-ddl-action).
        """
        return pulumi.get(self, "unsupported_ddl_action")

    @unsupported_ddl_action.setter
    def unsupported_ddl_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unsupported_ddl_action", value)

    @_builtins.property
    @pulumi.getter(name="useCachedResult")
    def use_cached_result(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to reuse persisted query results, if available, when a matching query is submitted. For more information, check [USE*CACHED*RESULT docs](https://docs.snowflake.com/en/sql-reference/parameters#use-cached-result).
        """
        return pulumi.get(self, "use_cached_result")

    @use_cached_result.setter
    def use_cached_result(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_cached_result", value)

    @_builtins.property
    @pulumi.getter(name="userTaskManagedInitialWarehouseSize")
    def user_task_managed_initial_warehouse_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. Valid values are (case-insensitive): %s. (Conflicts with warehouse). For more information about warehouses, see docs. For more information, check [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        """
        return pulumi.get(self, "user_task_managed_initial_warehouse_size")

    @user_task_managed_initial_warehouse_size.setter
    def user_task_managed_initial_warehouse_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_task_managed_initial_warehouse_size", value)

    @_builtins.property
    @pulumi.getter(name="userTaskMinimumTriggerIntervalInSeconds")
    def user_task_minimum_trigger_interval_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum amount of time between Triggered Task executions in seconds For more information, check [USER*TASK*MINIMUM*TRIGGER*INTERVAL*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-minimum-trigger-interval-in-seconds).
        """
        return pulumi.get(self, "user_task_minimum_trigger_interval_in_seconds")

    @user_task_minimum_trigger_interval_in_seconds.setter
    def user_task_minimum_trigger_interval_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_task_minimum_trigger_interval_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="userTaskTimeoutMs")
    def user_task_timeout_ms(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the time limit on a single run of the task before it times out (in milliseconds). For more information, check [USER*TASK*TIMEOUT_MS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        """
        return pulumi.get(self, "user_task_timeout_ms")

    @user_task_timeout_ms.setter
    def user_task_timeout_ms(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_task_timeout_ms", value)

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. Due to Snowflake limitations warehouse identifier can consist of only upper-cased letters. (Conflicts with user*task*managed*initial*warehouse_size) For more information about this resource, see docs.
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse", value)

    @_builtins.property
    @pulumi.getter(name="weekOfYearPolicy")
    def week_of_year_policy(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how the weeks in a given year are computed. `0`: The semantics used are equivalent to the ISO semantics, in which a week belongs to a given year if at least 4 days of that week are in that year. `1`: January 1 is included in the first week of the year and December 31 is included in the last week of the year. For more information, check [WEEK*OF*YEAR_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#week-of-year-policy).
        """
        return pulumi.get(self, "week_of_year_policy")

    @week_of_year_policy.setter
    def week_of_year_policy(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "week_of_year_policy", value)

    @_builtins.property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the first day of the week (used by week-related date functions). `0`: Legacy Snowflake behavior is used (i.e. ISO-like semantics). `1` (Monday) to `7` (Sunday): All the week-related functions use weeks that start on the specified day of the week. For more information, check [WEEK_START docs](https://docs.snowflake.com/en/sql-reference/parameters#week-start).
        """
        return pulumi.get(self, "week_start")

    @week_start.setter
    def week_start(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "week_start", value)

    @_builtins.property
    @pulumi.getter
    def when(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported. When a task is triggered (based on its SCHEDULE or AFTER setting), it validates the conditions of the expression to determine whether to execute. If the conditions of the expression are not met, then the task skips the current run. Any tasks that identify this task as a predecessor also don’t run.
        """
        return pulumi.get(self, "when")

    @when.setter
    def when(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "when", value)


@pulumi.type_token("snowflake:index/task:Task")
class Task(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 abort_detached_query: Optional[pulumi.Input[_builtins.bool]] = None,
                 afters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allow_overlapping_execution: Optional[pulumi.Input[_builtins.str]] = None,
                 autocommit: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 binary_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 client_memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 client_metadata_request_use_connection_ctx: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_prefetch_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 client_result_chunk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 client_result_column_case_insensitive: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_session_keep_alive: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_session_keep_alive_heartbeat_frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 client_timestamp_type_mapping: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 date_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 date_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_unload_physical_type_optimization: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_integration: Optional[pulumi.Input[_builtins.str]] = None,
                 error_on_nondeterministic_merge: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_on_nondeterministic_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 finalize: Optional[pulumi.Input[_builtins.str]] = None,
                 geography_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 geometry_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_treat_timestamp_ntz_as_utc: Optional[pulumi.Input[_builtins.bool]] = None,
                 jdbc_use_session_timezone: Optional[pulumi.Input[_builtins.bool]] = None,
                 json_indent: Optional[pulumi.Input[_builtins.int]] = None,
                 lock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_statement_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 noorder_sequence_as_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 odbc_treat_decimal_as_int: Optional[pulumi.Input[_builtins.bool]] = None,
                 query_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 quoted_identifiers_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 rows_per_resultset: Optional[pulumi.Input[_builtins.int]] = None,
                 s3_stage_vpce_dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['TaskScheduleArgs', 'TaskScheduleArgsDict']]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 search_path: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_statement: Optional[pulumi.Input[_builtins.str]] = None,
                 started: Optional[pulumi.Input[_builtins.bool]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 strict_json_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 suspend_task_after_num_failures: Optional[pulumi.Input[_builtins.int]] = None,
                 task_auto_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 time_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 time_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_day_is_always24h: Optional[pulumi.Input[_builtins.bool]] = None,
                 timestamp_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_ltz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_ntz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_type_mapping: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_tz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None,
                 transaction_abort_on_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 transaction_default_isolation_level: Optional[pulumi.Input[_builtins.str]] = None,
                 two_digit_century_start: Optional[pulumi.Input[_builtins.int]] = None,
                 unsupported_ddl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 use_cached_result: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_minimum_trigger_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 week_of_year_policy: Optional[pulumi.Input[_builtins.int]] = None,
                 week_start: Optional[pulumi.Input[_builtins.int]] = None,
                 when: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/task:Task example '"<database_name>"."<schema_name>"."<task_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] abort_detached_query: Specifies the action that Snowflake performs for in-progress queries if connectivity is lost due to abrupt termination of a session (e.g. network outage, browser termination, service interruption). For more information, check [ABORT*DETACHED*QUERY docs](https://docs.snowflake.com/en/sql-reference/parameters#abort-detached-query).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] afters: Specifies one or more predecessor tasks for the current task. Use this option to [create a DAG](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-task-dag) of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] allow_overlapping_execution: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.bool] autocommit: Specifies whether autocommit is enabled for the session. Autocommit determines whether a DML statement, when executed without an active transaction, is automatically committed after the statement successfully completes. For more information, see [Transactions](https://docs.snowflake.com/en/sql-reference/transactions). For more information, check [AUTOCOMMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#autocommit).
        :param pulumi.Input[_builtins.str] binary_input_format: The format of VARCHAR values passed as input to VARCHAR-to-BINARY conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-input-format).
        :param pulumi.Input[_builtins.str] binary_output_format: The format for VARCHAR values returned as output by BINARY-to-VARCHAR conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-output-format).
        :param pulumi.Input[_builtins.int] client_memory_limit: Parameter that specifies the maximum amount of memory the JDBC driver or ODBC driver should use for the result set from queries (in MB). For more information, check [CLIENT*MEMORY*LIMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#client-memory-limit).
        :param pulumi.Input[_builtins.bool] client_metadata_request_use_connection_ctx: For specific ODBC functions and JDBC methods, this parameter can change the default search scope from all databases/schemas to the current database/schema. The narrower search typically returns fewer rows and executes more quickly. For more information, check [CLIENT*METADATA*REQUEST*USE*CONNECTION_CTX docs](https://docs.snowflake.com/en/sql-reference/parameters#client-metadata-request-use-connection-ctx).
        :param pulumi.Input[_builtins.int] client_prefetch_threads: Parameter that specifies the number of threads used by the client to pre-fetch large result sets. The driver will attempt to honor the parameter value, but defines the minimum and maximum values (depending on your system’s resources) to improve performance. For more information, check [CLIENT*PREFETCH*THREADS docs](https://docs.snowflake.com/en/sql-reference/parameters#client-prefetch-threads).
        :param pulumi.Input[_builtins.int] client_result_chunk_size: Parameter that specifies the maximum size of each set (or chunk) of query results to download (in MB). The JDBC driver downloads query results in chunks. For more information, check [CLIENT*RESULT*CHUNK_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-chunk-size).
        :param pulumi.Input[_builtins.bool] client_result_column_case_insensitive: Parameter that indicates whether to match column name case-insensitively in ResultSet.get* methods in JDBC. For more information, check [CLIENT*RESULT*COLUMN*CASE*INSENSITIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-column-case-insensitive).
        :param pulumi.Input[_builtins.bool] client_session_keep_alive: Parameter that indicates whether to force a user to log in again after a period of inactivity in the session. For more information, check [CLIENT*SESSION*KEEP_ALIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive).
        :param pulumi.Input[_builtins.int] client_session_keep_alive_heartbeat_frequency: Number of seconds in-between client attempts to update the token for the session. For more information, check [CLIENT*SESSION*KEEP*ALIVE*HEARTBEAT_FREQUENCY docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive-heartbeat-frequency).
        :param pulumi.Input[_builtins.str] client_timestamp_type_mapping: Specifies the [TIMESTAMP_* variation](https://docs.snowflake.com/en/sql-reference/data-types-datetime.html#label-datatypes-timestamp-variations) to use when binding timestamp variables for JDBC or ODBC applications that use the bind API to load data. For more information, check [CLIENT*TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#client-timestamp-type-mapping).
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the task.
        :param pulumi.Input[_builtins.str] config: Specifies a string representation of key value pairs that can be accessed by all tasks in the task graph. Must be in JSON format.
        :param pulumi.Input[_builtins.str] database: The database in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] date_input_format: Specifies the input format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-input-format).
        :param pulumi.Input[_builtins.str] date_output_format: Specifies the display format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-output-format).
        :param pulumi.Input[_builtins.bool] enable_unload_physical_type_optimization: Specifies whether to set the schema for unloaded Parquet files based on the logical column data types (i.e. the types in the unload SQL query or source table) or on the unloaded column values (i.e. the smallest data types and precision that support the values in the output columns of the unload SQL statement or source table). For more information, check [ENABLE*UNLOAD*PHYSICAL*TYPE*OPTIMIZATION docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unload-physical-type-optimization).
        :param pulumi.Input[_builtins.str] error_integration: Specifies the name of the notification integration used for error notifications. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.bool] error_on_nondeterministic_merge: Specifies whether to return an error when the [MERGE](https://docs.snowflake.com/en/sql-reference/sql/merge) command is used to update or delete a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_MERGE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-merge).
        :param pulumi.Input[_builtins.bool] error_on_nondeterministic_update: Specifies whether to return an error when the [UPDATE](https://docs.snowflake.com/en/sql-reference/sql/update) command is used to update a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_UPDATE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-update).
        :param pulumi.Input[_builtins.str] finalize: Specifies the name of a root task that the finalizer task is associated with. Finalizer tasks run after all other tasks in the task graph run to completion. You can define the SQL of a finalizer task to handle notifications and the release and cleanup of resources that a task graph uses. For more information, see [Release and cleanup of task graphs](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-finalizer-task). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] geography_output_format: Display format for [GEOGRAPHY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geography). For more information, check [GEOGRAPHY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geography-output-format).
        :param pulumi.Input[_builtins.str] geometry_output_format: Display format for [GEOMETRY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geometry). For more information, check [GEOMETRY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geometry-output-format).
        :param pulumi.Input[_builtins.bool] jdbc_treat_timestamp_ntz_as_utc: Specifies how JDBC processes TIMESTAMP*NTZ values. For more information, check [JDBC*TREAT*TIMESTAMP*NTZ*AS*UTC docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-timestamp-ntz-as-utc).
        :param pulumi.Input[_builtins.bool] jdbc_use_session_timezone: Specifies whether the JDBC Driver uses the time zone of the JVM or the time zone of the session (specified by the [TIMEZONE](https://docs.snowflake.com/en/sql-reference/parameters#label-timezone) parameter) for the getDate(), getTime(), and getTimestamp() methods of the ResultSet class. For more information, check [JDBC*USE*SESSION_TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-use-session-timezone).
        :param pulumi.Input[_builtins.int] json_indent: Specifies the number of blank spaces to indent each new element in JSON output in the session. Also specifies whether to insert newline characters after each element. For more information, check [JSON_INDENT docs](https://docs.snowflake.com/en/sql-reference/parameters#json-indent).
        :param pulumi.Input[_builtins.int] lock_timeout: Number of seconds to wait while trying to lock a resource, before timing out and aborting the statement. For more information, check [LOCK_TIMEOUT docs](https://docs.snowflake.com/en/sql-reference/parameters#lock-timeout).
        :param pulumi.Input[_builtins.str] log_level: Specifies the severity level of messages that should be ingested and made available in the active event table. Messages at the specified level (and at more severe levels) are ingested. For more information about log levels, see [Setting log level](https://docs.snowflake.com/en/developer-guide/logging-tracing/logging-log-level). For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        :param pulumi.Input[_builtins.int] multi_statement_count: Number of statements to execute when using the multi-statement capability. For more information, check [MULTI*STATEMENT*COUNT docs](https://docs.snowflake.com/en/sql-reference/parameters#multi-statement-count).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the task; must be unique for the database and schema in which the task is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.bool] noorder_sequence_as_default: Specifies whether the ORDER or NOORDER property is set by default when you create a new sequence or add a new table column. The ORDER and NOORDER properties determine whether or not the values are generated for the sequence or auto-incremented column in [increasing or decreasing order](https://docs.snowflake.com/en/user-guide/querying-sequences.html#label-querying-sequences-increasing-values). For more information, check [NOORDER*SEQUENCE*AS_DEFAULT docs](https://docs.snowflake.com/en/sql-reference/parameters#noorder-sequence-as-default).
        :param pulumi.Input[_builtins.bool] odbc_treat_decimal_as_int: Specifies how ODBC processes columns that have a scale of zero (0). For more information, check [ODBC*TREAT*DECIMAL*AS*INT docs](https://docs.snowflake.com/en/sql-reference/parameters#odbc-treat-decimal-as-int).
        :param pulumi.Input[_builtins.str] query_tag: Optional string that can be used to tag queries and other SQL statements executed within a session. The tags are displayed in the output of the [QUERY*HISTORY, QUERY*HISTORY*BY**](https://docs.snowflake.com/en/sql-reference/functions/query_history) functions. For more information, check [QUERY_TAG docs](https://docs.snowflake.com/en/sql-reference/parameters#query-tag).
        :param pulumi.Input[_builtins.bool] quoted_identifiers_ignore_case: Specifies whether letters in double-quoted object identifiers are stored and resolved as uppercase letters. By default, Snowflake preserves the case of alphabetic characters when storing and resolving double-quoted identifiers (see [Identifier resolution](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing)). You can use this parameter in situations in which [third-party applications always use double quotes around identifiers](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing-parameter). For more information, check [QUOTED*IDENTIFIERS*IGNORE_CASE docs](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        :param pulumi.Input[_builtins.int] rows_per_resultset: Specifies the maximum number of rows returned in a result set. A value of 0 specifies no maximum. For more information, check [ROWS*PER*RESULTSET docs](https://docs.snowflake.com/en/sql-reference/parameters#rows-per-resultset).
        :param pulumi.Input[_builtins.str] s3_stage_vpce_dns_name: Specifies the DNS name of an Amazon S3 interface endpoint. Requests sent to the internal stage of an account via [AWS PrivateLink for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/privatelink-interface-endpoints.html) use this endpoint to connect. For more information, see [Accessing Internal stages with dedicated interface endpoints](https://docs.snowflake.com/en/user-guide/private-internal-stages-aws.html#label-aws-privatelink-internal-stage-network-isolation). For more information, check [S3*STAGE*VPCE*DNS*NAME docs](https://docs.snowflake.com/en/sql-reference/parameters#s3-stage-vpce-dns-name).
        :param pulumi.Input[Union['TaskScheduleArgs', 'TaskScheduleArgsDict']] schedule: The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflicts with finalize and after; when set, one of the sub-fields `minutes` or `using_cron` should be set)
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] search_path: Specifies the path to search to resolve unqualified object names in queries. For more information, see [Name resolution in queries](https://docs.snowflake.com/en/sql-reference/name-resolution.html#label-object-name-resolution-search-path). Comma-separated list of identifiers. An identifier can be a fully or partially qualified schema name. For more information, check [SEARCH_PATH docs](https://docs.snowflake.com/en/sql-reference/parameters#search-path).
        :param pulumi.Input[_builtins.str] sql_statement: Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        :param pulumi.Input[_builtins.bool] started: Specifies if the task should be started or suspended.
        :param pulumi.Input[_builtins.int] statement_queued_timeout_in_seconds: Amount of time, in seconds, a SQL statement (query, DDL, DML, etc.) remains queued for a warehouse before it is canceled by the system. This parameter can be used in conjunction with the [MAX*CONCURRENCY*LEVEL](https://docs.snowflake.com/en/sql-reference/parameters#label-max-concurrency-level) parameter to ensure a warehouse is never backlogged. For more information, check [STATEMENT*QUEUED*TIMEOUT*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-queued-timeout-in-seconds).
        :param pulumi.Input[_builtins.int] statement_timeout_in_seconds: Amount of time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system. For more information, check [STATEMENT*TIMEOUT*IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-timeout-in-seconds).
        :param pulumi.Input[_builtins.bool] strict_json_output: This parameter specifies whether JSON output in a session is compatible with the general standard (as described by [http://json.org](http://json.org)). By design, Snowflake allows JSON input that contains non-standard values; however, these non-standard values might result in Snowflake outputting JSON that is incompatible with other platforms and languages. This parameter, when enabled, ensures that Snowflake outputs valid/compatible JSON. For more information, check [STRICT*JSON*OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#strict-json-output).
        :param pulumi.Input[_builtins.int] suspend_task_after_num_failures: Specifies the number of consecutive failed task runs after which the current task is suspended automatically. The default is 0 (no automatic suspension). For more information, check [SUSPEND*TASK*AFTER*NUM*FAILURES docs](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        :param pulumi.Input[_builtins.int] task_auto_retry_attempts: Specifies the number of automatic task graph retry attempts. If any task graphs complete in a FAILED state, Snowflake can automatically retry the task graphs from the last task in the graph that failed. For more information, check [TASK*AUTO*RETRY_ATTEMPTS docs](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        :param pulumi.Input[_builtins.str] time_input_format: Specifies the input format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported time format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of times stored in the system during the session). For more information, check [TIME*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-input-format).
        :param pulumi.Input[_builtins.str] time_output_format: Specifies the display format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIME*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-output-format).
        :param pulumi.Input[_builtins.bool] timestamp_day_is_always24h: Specifies whether the [DATEADD](https://docs.snowflake.com/en/sql-reference/functions/dateadd) function (and its aliases) always consider a day to be exactly 24 hours for expressions that span multiple days. For more information, check [TIMESTAMP*DAY*IS*ALWAYS*24H docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-day-is-always-24h).
        :param pulumi.Input[_builtins.str] timestamp_input_format: Specifies the input format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported timestamp format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of timestamps stored in the system during the session). For more information, check [TIMESTAMP*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-input-format).
        :param pulumi.Input[_builtins.str] timestamp_ltz_output_format: Specifies the display format for the TIMESTAMP*LTZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*LTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ltz-output-format).
        :param pulumi.Input[_builtins.str] timestamp_ntz_output_format: Specifies the display format for the TIMESTAMP*NTZ data type. For more information, check [TIMESTAMP*NTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ntz-output-format).
        :param pulumi.Input[_builtins.str] timestamp_output_format: Specifies the display format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-output-format).
        :param pulumi.Input[_builtins.str] timestamp_type_mapping: Specifies the TIMESTAMP** variation that the TIMESTAMP data type alias maps to. For more information, check [TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-type-mapping).
        :param pulumi.Input[_builtins.str] timestamp_tz_output_format: Specifies the display format for the TIMESTAMP*TZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*TZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-tz-output-format).
        :param pulumi.Input[_builtins.str] timezone: Specifies the time zone for the session. You can specify a [time zone name](https://data.iana.org/time-zones/tzdb-2021a/zone1970.tab) or a [link name](https://data.iana.org/time-zones/tzdb-2021a/backward) from release 2021a of the [IANA Time Zone Database](https://www.iana.org/time-zones) (e.g. America/Los_Angeles, Europe/London, UTC, Etc/GMT, etc.). For more information, check [TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#timezone).
        :param pulumi.Input[_builtins.str] trace_level: Controls how trace events are ingested into the event table. For more information about trace levels, see [Setting trace level](https://docs.snowflake.com/en/developer-guide/logging-tracing/tracing-trace-level). For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        :param pulumi.Input[_builtins.bool] transaction_abort_on_error: Specifies the action to perform when a statement issued within a non-autocommit transaction returns with an error. For more information, check [TRANSACTION*ABORT*ON_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-abort-on-error).
        :param pulumi.Input[_builtins.str] transaction_default_isolation_level: Specifies the isolation level for transactions in the user session. For more information, check [TRANSACTION*DEFAULT*ISOLATION_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-default-isolation-level).
        :param pulumi.Input[_builtins.int] two_digit_century_start: Specifies the “century start” year for 2-digit years (i.e. the earliest year such dates can represent). This parameter prevents ambiguous dates when importing or converting data with the `YY` date format component (i.e. years represented as 2 digits). For more information, check [TWO*DIGIT*CENTURY_START docs](https://docs.snowflake.com/en/sql-reference/parameters#two-digit-century-start).
        :param pulumi.Input[_builtins.str] unsupported_ddl_action: Determines if an unsupported (i.e. non-default) value specified for a constraint property returns an error. For more information, check [UNSUPPORTED*DDL*ACTION docs](https://docs.snowflake.com/en/sql-reference/parameters#unsupported-ddl-action).
        :param pulumi.Input[_builtins.bool] use_cached_result: Specifies whether to reuse persisted query results, if available, when a matching query is submitted. For more information, check [USE*CACHED*RESULT docs](https://docs.snowflake.com/en/sql-reference/parameters#use-cached-result).
        :param pulumi.Input[_builtins.str] user_task_managed_initial_warehouse_size: Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. Valid values are (case-insensitive): %s. (Conflicts with warehouse). For more information about warehouses, see docs. For more information, check [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        :param pulumi.Input[_builtins.int] user_task_minimum_trigger_interval_in_seconds: Minimum amount of time between Triggered Task executions in seconds For more information, check [USER*TASK*MINIMUM*TRIGGER*INTERVAL*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-minimum-trigger-interval-in-seconds).
        :param pulumi.Input[_builtins.int] user_task_timeout_ms: Specifies the time limit on a single run of the task before it times out (in milliseconds). For more information, check [USER*TASK*TIMEOUT_MS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        :param pulumi.Input[_builtins.str] warehouse: The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. Due to Snowflake limitations warehouse identifier can consist of only upper-cased letters. (Conflicts with user*task*managed*initial*warehouse_size) For more information about this resource, see docs.
        :param pulumi.Input[_builtins.int] week_of_year_policy: Specifies how the weeks in a given year are computed. `0`: The semantics used are equivalent to the ISO semantics, in which a week belongs to a given year if at least 4 days of that week are in that year. `1`: January 1 is included in the first week of the year and December 31 is included in the last week of the year. For more information, check [WEEK*OF*YEAR_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#week-of-year-policy).
        :param pulumi.Input[_builtins.int] week_start: Specifies the first day of the week (used by week-related date functions). `0`: Legacy Snowflake behavior is used (i.e. ISO-like semantics). `1` (Monday) to `7` (Sunday): All the week-related functions use weeks that start on the specified day of the week. For more information, check [WEEK_START docs](https://docs.snowflake.com/en/sql-reference/parameters#week-start).
        :param pulumi.Input[_builtins.str] when: Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported. When a task is triggered (based on its SCHEDULE or AFTER setting), it validates the conditions of the expression to determine whether to execute. If the conditions of the expression are not met, then the task skips the current run. Any tasks that identify this task as a predecessor also don’t run.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/task:Task example '"<database_name>"."<schema_name>"."<task_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param TaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 abort_detached_query: Optional[pulumi.Input[_builtins.bool]] = None,
                 afters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allow_overlapping_execution: Optional[pulumi.Input[_builtins.str]] = None,
                 autocommit: Optional[pulumi.Input[_builtins.bool]] = None,
                 binary_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 binary_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 client_memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 client_metadata_request_use_connection_ctx: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_prefetch_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 client_result_chunk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 client_result_column_case_insensitive: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_session_keep_alive: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_session_keep_alive_heartbeat_frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 client_timestamp_type_mapping: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 date_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 date_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_unload_physical_type_optimization: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_integration: Optional[pulumi.Input[_builtins.str]] = None,
                 error_on_nondeterministic_merge: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_on_nondeterministic_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 finalize: Optional[pulumi.Input[_builtins.str]] = None,
                 geography_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 geometry_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_treat_timestamp_ntz_as_utc: Optional[pulumi.Input[_builtins.bool]] = None,
                 jdbc_use_session_timezone: Optional[pulumi.Input[_builtins.bool]] = None,
                 json_indent: Optional[pulumi.Input[_builtins.int]] = None,
                 lock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_statement_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 noorder_sequence_as_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 odbc_treat_decimal_as_int: Optional[pulumi.Input[_builtins.bool]] = None,
                 query_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 quoted_identifiers_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 rows_per_resultset: Optional[pulumi.Input[_builtins.int]] = None,
                 s3_stage_vpce_dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['TaskScheduleArgs', 'TaskScheduleArgsDict']]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 search_path: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_statement: Optional[pulumi.Input[_builtins.str]] = None,
                 started: Optional[pulumi.Input[_builtins.bool]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 strict_json_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 suspend_task_after_num_failures: Optional[pulumi.Input[_builtins.int]] = None,
                 task_auto_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 time_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 time_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_day_is_always24h: Optional[pulumi.Input[_builtins.bool]] = None,
                 timestamp_input_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_ltz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_ntz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_type_mapping: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_tz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None,
                 transaction_abort_on_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 transaction_default_isolation_level: Optional[pulumi.Input[_builtins.str]] = None,
                 two_digit_century_start: Optional[pulumi.Input[_builtins.int]] = None,
                 unsupported_ddl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 use_cached_result: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_minimum_trigger_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 week_of_year_policy: Optional[pulumi.Input[_builtins.int]] = None,
                 week_start: Optional[pulumi.Input[_builtins.int]] = None,
                 when: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TaskArgs.__new__(TaskArgs)

            __props__.__dict__["abort_detached_query"] = abort_detached_query
            __props__.__dict__["afters"] = afters
            __props__.__dict__["allow_overlapping_execution"] = allow_overlapping_execution
            __props__.__dict__["autocommit"] = autocommit
            __props__.__dict__["binary_input_format"] = binary_input_format
            __props__.__dict__["binary_output_format"] = binary_output_format
            __props__.__dict__["client_memory_limit"] = client_memory_limit
            __props__.__dict__["client_metadata_request_use_connection_ctx"] = client_metadata_request_use_connection_ctx
            __props__.__dict__["client_prefetch_threads"] = client_prefetch_threads
            __props__.__dict__["client_result_chunk_size"] = client_result_chunk_size
            __props__.__dict__["client_result_column_case_insensitive"] = client_result_column_case_insensitive
            __props__.__dict__["client_session_keep_alive"] = client_session_keep_alive
            __props__.__dict__["client_session_keep_alive_heartbeat_frequency"] = client_session_keep_alive_heartbeat_frequency
            __props__.__dict__["client_timestamp_type_mapping"] = client_timestamp_type_mapping
            __props__.__dict__["comment"] = comment
            __props__.__dict__["config"] = config
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["date_input_format"] = date_input_format
            __props__.__dict__["date_output_format"] = date_output_format
            __props__.__dict__["enable_unload_physical_type_optimization"] = enable_unload_physical_type_optimization
            __props__.__dict__["error_integration"] = error_integration
            __props__.__dict__["error_on_nondeterministic_merge"] = error_on_nondeterministic_merge
            __props__.__dict__["error_on_nondeterministic_update"] = error_on_nondeterministic_update
            __props__.__dict__["finalize"] = finalize
            __props__.__dict__["geography_output_format"] = geography_output_format
            __props__.__dict__["geometry_output_format"] = geometry_output_format
            __props__.__dict__["jdbc_treat_timestamp_ntz_as_utc"] = jdbc_treat_timestamp_ntz_as_utc
            __props__.__dict__["jdbc_use_session_timezone"] = jdbc_use_session_timezone
            __props__.__dict__["json_indent"] = json_indent
            __props__.__dict__["lock_timeout"] = lock_timeout
            __props__.__dict__["log_level"] = log_level
            __props__.__dict__["multi_statement_count"] = multi_statement_count
            __props__.__dict__["name"] = name
            __props__.__dict__["noorder_sequence_as_default"] = noorder_sequence_as_default
            __props__.__dict__["odbc_treat_decimal_as_int"] = odbc_treat_decimal_as_int
            __props__.__dict__["query_tag"] = query_tag
            __props__.__dict__["quoted_identifiers_ignore_case"] = quoted_identifiers_ignore_case
            __props__.__dict__["rows_per_resultset"] = rows_per_resultset
            __props__.__dict__["s3_stage_vpce_dns_name"] = s3_stage_vpce_dns_name
            __props__.__dict__["schedule"] = schedule
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["search_path"] = search_path
            if sql_statement is None and not opts.urn:
                raise TypeError("Missing required property 'sql_statement'")
            __props__.__dict__["sql_statement"] = sql_statement
            if started is None and not opts.urn:
                raise TypeError("Missing required property 'started'")
            __props__.__dict__["started"] = started
            __props__.__dict__["statement_queued_timeout_in_seconds"] = statement_queued_timeout_in_seconds
            __props__.__dict__["statement_timeout_in_seconds"] = statement_timeout_in_seconds
            __props__.__dict__["strict_json_output"] = strict_json_output
            __props__.__dict__["suspend_task_after_num_failures"] = suspend_task_after_num_failures
            __props__.__dict__["task_auto_retry_attempts"] = task_auto_retry_attempts
            __props__.__dict__["time_input_format"] = time_input_format
            __props__.__dict__["time_output_format"] = time_output_format
            __props__.__dict__["timestamp_day_is_always24h"] = timestamp_day_is_always24h
            __props__.__dict__["timestamp_input_format"] = timestamp_input_format
            __props__.__dict__["timestamp_ltz_output_format"] = timestamp_ltz_output_format
            __props__.__dict__["timestamp_ntz_output_format"] = timestamp_ntz_output_format
            __props__.__dict__["timestamp_output_format"] = timestamp_output_format
            __props__.__dict__["timestamp_type_mapping"] = timestamp_type_mapping
            __props__.__dict__["timestamp_tz_output_format"] = timestamp_tz_output_format
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["trace_level"] = trace_level
            __props__.__dict__["transaction_abort_on_error"] = transaction_abort_on_error
            __props__.__dict__["transaction_default_isolation_level"] = transaction_default_isolation_level
            __props__.__dict__["two_digit_century_start"] = two_digit_century_start
            __props__.__dict__["unsupported_ddl_action"] = unsupported_ddl_action
            __props__.__dict__["use_cached_result"] = use_cached_result
            __props__.__dict__["user_task_managed_initial_warehouse_size"] = user_task_managed_initial_warehouse_size
            __props__.__dict__["user_task_minimum_trigger_interval_in_seconds"] = user_task_minimum_trigger_interval_in_seconds
            __props__.__dict__["user_task_timeout_ms"] = user_task_timeout_ms
            __props__.__dict__["warehouse"] = warehouse
            __props__.__dict__["week_of_year_policy"] = week_of_year_policy
            __props__.__dict__["week_start"] = week_start
            __props__.__dict__["when"] = when
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["parameters"] = None
            __props__.__dict__["show_outputs"] = None
        super(Task, __self__).__init__(
            'snowflake:index/task:Task',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            abort_detached_query: Optional[pulumi.Input[_builtins.bool]] = None,
            afters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allow_overlapping_execution: Optional[pulumi.Input[_builtins.str]] = None,
            autocommit: Optional[pulumi.Input[_builtins.bool]] = None,
            binary_input_format: Optional[pulumi.Input[_builtins.str]] = None,
            binary_output_format: Optional[pulumi.Input[_builtins.str]] = None,
            client_memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
            client_metadata_request_use_connection_ctx: Optional[pulumi.Input[_builtins.bool]] = None,
            client_prefetch_threads: Optional[pulumi.Input[_builtins.int]] = None,
            client_result_chunk_size: Optional[pulumi.Input[_builtins.int]] = None,
            client_result_column_case_insensitive: Optional[pulumi.Input[_builtins.bool]] = None,
            client_session_keep_alive: Optional[pulumi.Input[_builtins.bool]] = None,
            client_session_keep_alive_heartbeat_frequency: Optional[pulumi.Input[_builtins.int]] = None,
            client_timestamp_type_mapping: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            config: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            date_input_format: Optional[pulumi.Input[_builtins.str]] = None,
            date_output_format: Optional[pulumi.Input[_builtins.str]] = None,
            enable_unload_physical_type_optimization: Optional[pulumi.Input[_builtins.bool]] = None,
            error_integration: Optional[pulumi.Input[_builtins.str]] = None,
            error_on_nondeterministic_merge: Optional[pulumi.Input[_builtins.bool]] = None,
            error_on_nondeterministic_update: Optional[pulumi.Input[_builtins.bool]] = None,
            finalize: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            geography_output_format: Optional[pulumi.Input[_builtins.str]] = None,
            geometry_output_format: Optional[pulumi.Input[_builtins.str]] = None,
            jdbc_treat_timestamp_ntz_as_utc: Optional[pulumi.Input[_builtins.bool]] = None,
            jdbc_use_session_timezone: Optional[pulumi.Input[_builtins.bool]] = None,
            json_indent: Optional[pulumi.Input[_builtins.int]] = None,
            lock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            log_level: Optional[pulumi.Input[_builtins.str]] = None,
            multi_statement_count: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            noorder_sequence_as_default: Optional[pulumi.Input[_builtins.bool]] = None,
            odbc_treat_decimal_as_int: Optional[pulumi.Input[_builtins.bool]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskParameterArgs', 'TaskParameterArgsDict']]]]] = None,
            query_tag: Optional[pulumi.Input[_builtins.str]] = None,
            quoted_identifiers_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
            rows_per_resultset: Optional[pulumi.Input[_builtins.int]] = None,
            s3_stage_vpce_dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            schedule: Optional[pulumi.Input[Union['TaskScheduleArgs', 'TaskScheduleArgsDict']]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            search_path: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskShowOutputArgs', 'TaskShowOutputArgsDict']]]]] = None,
            sql_statement: Optional[pulumi.Input[_builtins.str]] = None,
            started: Optional[pulumi.Input[_builtins.bool]] = None,
            statement_queued_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            statement_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            strict_json_output: Optional[pulumi.Input[_builtins.bool]] = None,
            suspend_task_after_num_failures: Optional[pulumi.Input[_builtins.int]] = None,
            task_auto_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
            time_input_format: Optional[pulumi.Input[_builtins.str]] = None,
            time_output_format: Optional[pulumi.Input[_builtins.str]] = None,
            timestamp_day_is_always24h: Optional[pulumi.Input[_builtins.bool]] = None,
            timestamp_input_format: Optional[pulumi.Input[_builtins.str]] = None,
            timestamp_ltz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
            timestamp_ntz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
            timestamp_output_format: Optional[pulumi.Input[_builtins.str]] = None,
            timestamp_type_mapping: Optional[pulumi.Input[_builtins.str]] = None,
            timestamp_tz_output_format: Optional[pulumi.Input[_builtins.str]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            trace_level: Optional[pulumi.Input[_builtins.str]] = None,
            transaction_abort_on_error: Optional[pulumi.Input[_builtins.bool]] = None,
            transaction_default_isolation_level: Optional[pulumi.Input[_builtins.str]] = None,
            two_digit_century_start: Optional[pulumi.Input[_builtins.int]] = None,
            unsupported_ddl_action: Optional[pulumi.Input[_builtins.str]] = None,
            use_cached_result: Optional[pulumi.Input[_builtins.bool]] = None,
            user_task_managed_initial_warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
            user_task_minimum_trigger_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            user_task_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
            warehouse: Optional[pulumi.Input[_builtins.str]] = None,
            week_of_year_policy: Optional[pulumi.Input[_builtins.int]] = None,
            week_start: Optional[pulumi.Input[_builtins.int]] = None,
            when: Optional[pulumi.Input[_builtins.str]] = None) -> 'Task':
        """
        Get an existing Task resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] abort_detached_query: Specifies the action that Snowflake performs for in-progress queries if connectivity is lost due to abrupt termination of a session (e.g. network outage, browser termination, service interruption). For more information, check [ABORT*DETACHED*QUERY docs](https://docs.snowflake.com/en/sql-reference/parameters#abort-detached-query).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] afters: Specifies one or more predecessor tasks for the current task. Use this option to [create a DAG](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-task-dag) of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] allow_overlapping_execution: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.bool] autocommit: Specifies whether autocommit is enabled for the session. Autocommit determines whether a DML statement, when executed without an active transaction, is automatically committed after the statement successfully completes. For more information, see [Transactions](https://docs.snowflake.com/en/sql-reference/transactions). For more information, check [AUTOCOMMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#autocommit).
        :param pulumi.Input[_builtins.str] binary_input_format: The format of VARCHAR values passed as input to VARCHAR-to-BINARY conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-input-format).
        :param pulumi.Input[_builtins.str] binary_output_format: The format for VARCHAR values returned as output by BINARY-to-VARCHAR conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-output-format).
        :param pulumi.Input[_builtins.int] client_memory_limit: Parameter that specifies the maximum amount of memory the JDBC driver or ODBC driver should use for the result set from queries (in MB). For more information, check [CLIENT*MEMORY*LIMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#client-memory-limit).
        :param pulumi.Input[_builtins.bool] client_metadata_request_use_connection_ctx: For specific ODBC functions and JDBC methods, this parameter can change the default search scope from all databases/schemas to the current database/schema. The narrower search typically returns fewer rows and executes more quickly. For more information, check [CLIENT*METADATA*REQUEST*USE*CONNECTION_CTX docs](https://docs.snowflake.com/en/sql-reference/parameters#client-metadata-request-use-connection-ctx).
        :param pulumi.Input[_builtins.int] client_prefetch_threads: Parameter that specifies the number of threads used by the client to pre-fetch large result sets. The driver will attempt to honor the parameter value, but defines the minimum and maximum values (depending on your system’s resources) to improve performance. For more information, check [CLIENT*PREFETCH*THREADS docs](https://docs.snowflake.com/en/sql-reference/parameters#client-prefetch-threads).
        :param pulumi.Input[_builtins.int] client_result_chunk_size: Parameter that specifies the maximum size of each set (or chunk) of query results to download (in MB). The JDBC driver downloads query results in chunks. For more information, check [CLIENT*RESULT*CHUNK_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-chunk-size).
        :param pulumi.Input[_builtins.bool] client_result_column_case_insensitive: Parameter that indicates whether to match column name case-insensitively in ResultSet.get* methods in JDBC. For more information, check [CLIENT*RESULT*COLUMN*CASE*INSENSITIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-column-case-insensitive).
        :param pulumi.Input[_builtins.bool] client_session_keep_alive: Parameter that indicates whether to force a user to log in again after a period of inactivity in the session. For more information, check [CLIENT*SESSION*KEEP_ALIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive).
        :param pulumi.Input[_builtins.int] client_session_keep_alive_heartbeat_frequency: Number of seconds in-between client attempts to update the token for the session. For more information, check [CLIENT*SESSION*KEEP*ALIVE*HEARTBEAT_FREQUENCY docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive-heartbeat-frequency).
        :param pulumi.Input[_builtins.str] client_timestamp_type_mapping: Specifies the [TIMESTAMP_* variation](https://docs.snowflake.com/en/sql-reference/data-types-datetime.html#label-datatypes-timestamp-variations) to use when binding timestamp variables for JDBC or ODBC applications that use the bind API to load data. For more information, check [CLIENT*TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#client-timestamp-type-mapping).
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the task.
        :param pulumi.Input[_builtins.str] config: Specifies a string representation of key value pairs that can be accessed by all tasks in the task graph. Must be in JSON format.
        :param pulumi.Input[_builtins.str] database: The database in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] date_input_format: Specifies the input format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-input-format).
        :param pulumi.Input[_builtins.str] date_output_format: Specifies the display format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-output-format).
        :param pulumi.Input[_builtins.bool] enable_unload_physical_type_optimization: Specifies whether to set the schema for unloaded Parquet files based on the logical column data types (i.e. the types in the unload SQL query or source table) or on the unloaded column values (i.e. the smallest data types and precision that support the values in the output columns of the unload SQL statement or source table). For more information, check [ENABLE*UNLOAD*PHYSICAL*TYPE*OPTIMIZATION docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unload-physical-type-optimization).
        :param pulumi.Input[_builtins.str] error_integration: Specifies the name of the notification integration used for error notifications. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.bool] error_on_nondeterministic_merge: Specifies whether to return an error when the [MERGE](https://docs.snowflake.com/en/sql-reference/sql/merge) command is used to update or delete a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_MERGE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-merge).
        :param pulumi.Input[_builtins.bool] error_on_nondeterministic_update: Specifies whether to return an error when the [UPDATE](https://docs.snowflake.com/en/sql-reference/sql/update) command is used to update a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_UPDATE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-update).
        :param pulumi.Input[_builtins.str] finalize: Specifies the name of a root task that the finalizer task is associated with. Finalizer tasks run after all other tasks in the task graph run to completion. You can define the SQL of a finalizer task to handle notifications and the release and cleanup of resources that a task graph uses. For more information, see [Release and cleanup of task graphs](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-finalizer-task). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] geography_output_format: Display format for [GEOGRAPHY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geography). For more information, check [GEOGRAPHY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geography-output-format).
        :param pulumi.Input[_builtins.str] geometry_output_format: Display format for [GEOMETRY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geometry). For more information, check [GEOMETRY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geometry-output-format).
        :param pulumi.Input[_builtins.bool] jdbc_treat_timestamp_ntz_as_utc: Specifies how JDBC processes TIMESTAMP*NTZ values. For more information, check [JDBC*TREAT*TIMESTAMP*NTZ*AS*UTC docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-timestamp-ntz-as-utc).
        :param pulumi.Input[_builtins.bool] jdbc_use_session_timezone: Specifies whether the JDBC Driver uses the time zone of the JVM or the time zone of the session (specified by the [TIMEZONE](https://docs.snowflake.com/en/sql-reference/parameters#label-timezone) parameter) for the getDate(), getTime(), and getTimestamp() methods of the ResultSet class. For more information, check [JDBC*USE*SESSION_TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-use-session-timezone).
        :param pulumi.Input[_builtins.int] json_indent: Specifies the number of blank spaces to indent each new element in JSON output in the session. Also specifies whether to insert newline characters after each element. For more information, check [JSON_INDENT docs](https://docs.snowflake.com/en/sql-reference/parameters#json-indent).
        :param pulumi.Input[_builtins.int] lock_timeout: Number of seconds to wait while trying to lock a resource, before timing out and aborting the statement. For more information, check [LOCK_TIMEOUT docs](https://docs.snowflake.com/en/sql-reference/parameters#lock-timeout).
        :param pulumi.Input[_builtins.str] log_level: Specifies the severity level of messages that should be ingested and made available in the active event table. Messages at the specified level (and at more severe levels) are ingested. For more information about log levels, see [Setting log level](https://docs.snowflake.com/en/developer-guide/logging-tracing/logging-log-level). For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        :param pulumi.Input[_builtins.int] multi_statement_count: Number of statements to execute when using the multi-statement capability. For more information, check [MULTI*STATEMENT*COUNT docs](https://docs.snowflake.com/en/sql-reference/parameters#multi-statement-count).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the task; must be unique for the database and schema in which the task is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.bool] noorder_sequence_as_default: Specifies whether the ORDER or NOORDER property is set by default when you create a new sequence or add a new table column. The ORDER and NOORDER properties determine whether or not the values are generated for the sequence or auto-incremented column in [increasing or decreasing order](https://docs.snowflake.com/en/user-guide/querying-sequences.html#label-querying-sequences-increasing-values). For more information, check [NOORDER*SEQUENCE*AS_DEFAULT docs](https://docs.snowflake.com/en/sql-reference/parameters#noorder-sequence-as-default).
        :param pulumi.Input[_builtins.bool] odbc_treat_decimal_as_int: Specifies how ODBC processes columns that have a scale of zero (0). For more information, check [ODBC*TREAT*DECIMAL*AS*INT docs](https://docs.snowflake.com/en/sql-reference/parameters#odbc-treat-decimal-as-int).
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskParameterArgs', 'TaskParameterArgsDict']]]] parameters: Outputs the result of `SHOW PARAMETERS IN TASK` for the given task.
        :param pulumi.Input[_builtins.str] query_tag: Optional string that can be used to tag queries and other SQL statements executed within a session. The tags are displayed in the output of the [QUERY*HISTORY, QUERY*HISTORY*BY**](https://docs.snowflake.com/en/sql-reference/functions/query_history) functions. For more information, check [QUERY_TAG docs](https://docs.snowflake.com/en/sql-reference/parameters#query-tag).
        :param pulumi.Input[_builtins.bool] quoted_identifiers_ignore_case: Specifies whether letters in double-quoted object identifiers are stored and resolved as uppercase letters. By default, Snowflake preserves the case of alphabetic characters when storing and resolving double-quoted identifiers (see [Identifier resolution](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing)). You can use this parameter in situations in which [third-party applications always use double quotes around identifiers](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing-parameter). For more information, check [QUOTED*IDENTIFIERS*IGNORE_CASE docs](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        :param pulumi.Input[_builtins.int] rows_per_resultset: Specifies the maximum number of rows returned in a result set. A value of 0 specifies no maximum. For more information, check [ROWS*PER*RESULTSET docs](https://docs.snowflake.com/en/sql-reference/parameters#rows-per-resultset).
        :param pulumi.Input[_builtins.str] s3_stage_vpce_dns_name: Specifies the DNS name of an Amazon S3 interface endpoint. Requests sent to the internal stage of an account via [AWS PrivateLink for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/privatelink-interface-endpoints.html) use this endpoint to connect. For more information, see [Accessing Internal stages with dedicated interface endpoints](https://docs.snowflake.com/en/user-guide/private-internal-stages-aws.html#label-aws-privatelink-internal-stage-network-isolation). For more information, check [S3*STAGE*VPCE*DNS*NAME docs](https://docs.snowflake.com/en/sql-reference/parameters#s3-stage-vpce-dns-name).
        :param pulumi.Input[Union['TaskScheduleArgs', 'TaskScheduleArgsDict']] schedule: The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflicts with finalize and after; when set, one of the sub-fields `minutes` or `using_cron` should be set)
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] search_path: Specifies the path to search to resolve unqualified object names in queries. For more information, see [Name resolution in queries](https://docs.snowflake.com/en/sql-reference/name-resolution.html#label-object-name-resolution-search-path). Comma-separated list of identifiers. An identifier can be a fully or partially qualified schema name. For more information, check [SEARCH_PATH docs](https://docs.snowflake.com/en/sql-reference/parameters#search-path).
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskShowOutputArgs', 'TaskShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW TASKS` for the given task.
        :param pulumi.Input[_builtins.str] sql_statement: Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        :param pulumi.Input[_builtins.bool] started: Specifies if the task should be started or suspended.
        :param pulumi.Input[_builtins.int] statement_queued_timeout_in_seconds: Amount of time, in seconds, a SQL statement (query, DDL, DML, etc.) remains queued for a warehouse before it is canceled by the system. This parameter can be used in conjunction with the [MAX*CONCURRENCY*LEVEL](https://docs.snowflake.com/en/sql-reference/parameters#label-max-concurrency-level) parameter to ensure a warehouse is never backlogged. For more information, check [STATEMENT*QUEUED*TIMEOUT*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-queued-timeout-in-seconds).
        :param pulumi.Input[_builtins.int] statement_timeout_in_seconds: Amount of time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system. For more information, check [STATEMENT*TIMEOUT*IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-timeout-in-seconds).
        :param pulumi.Input[_builtins.bool] strict_json_output: This parameter specifies whether JSON output in a session is compatible with the general standard (as described by [http://json.org](http://json.org)). By design, Snowflake allows JSON input that contains non-standard values; however, these non-standard values might result in Snowflake outputting JSON that is incompatible with other platforms and languages. This parameter, when enabled, ensures that Snowflake outputs valid/compatible JSON. For more information, check [STRICT*JSON*OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#strict-json-output).
        :param pulumi.Input[_builtins.int] suspend_task_after_num_failures: Specifies the number of consecutive failed task runs after which the current task is suspended automatically. The default is 0 (no automatic suspension). For more information, check [SUSPEND*TASK*AFTER*NUM*FAILURES docs](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        :param pulumi.Input[_builtins.int] task_auto_retry_attempts: Specifies the number of automatic task graph retry attempts. If any task graphs complete in a FAILED state, Snowflake can automatically retry the task graphs from the last task in the graph that failed. For more information, check [TASK*AUTO*RETRY_ATTEMPTS docs](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        :param pulumi.Input[_builtins.str] time_input_format: Specifies the input format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported time format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of times stored in the system during the session). For more information, check [TIME*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-input-format).
        :param pulumi.Input[_builtins.str] time_output_format: Specifies the display format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIME*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-output-format).
        :param pulumi.Input[_builtins.bool] timestamp_day_is_always24h: Specifies whether the [DATEADD](https://docs.snowflake.com/en/sql-reference/functions/dateadd) function (and its aliases) always consider a day to be exactly 24 hours for expressions that span multiple days. For more information, check [TIMESTAMP*DAY*IS*ALWAYS*24H docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-day-is-always-24h).
        :param pulumi.Input[_builtins.str] timestamp_input_format: Specifies the input format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported timestamp format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of timestamps stored in the system during the session). For more information, check [TIMESTAMP*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-input-format).
        :param pulumi.Input[_builtins.str] timestamp_ltz_output_format: Specifies the display format for the TIMESTAMP*LTZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*LTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ltz-output-format).
        :param pulumi.Input[_builtins.str] timestamp_ntz_output_format: Specifies the display format for the TIMESTAMP*NTZ data type. For more information, check [TIMESTAMP*NTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ntz-output-format).
        :param pulumi.Input[_builtins.str] timestamp_output_format: Specifies the display format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-output-format).
        :param pulumi.Input[_builtins.str] timestamp_type_mapping: Specifies the TIMESTAMP** variation that the TIMESTAMP data type alias maps to. For more information, check [TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-type-mapping).
        :param pulumi.Input[_builtins.str] timestamp_tz_output_format: Specifies the display format for the TIMESTAMP*TZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*TZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-tz-output-format).
        :param pulumi.Input[_builtins.str] timezone: Specifies the time zone for the session. You can specify a [time zone name](https://data.iana.org/time-zones/tzdb-2021a/zone1970.tab) or a [link name](https://data.iana.org/time-zones/tzdb-2021a/backward) from release 2021a of the [IANA Time Zone Database](https://www.iana.org/time-zones) (e.g. America/Los_Angeles, Europe/London, UTC, Etc/GMT, etc.). For more information, check [TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#timezone).
        :param pulumi.Input[_builtins.str] trace_level: Controls how trace events are ingested into the event table. For more information about trace levels, see [Setting trace level](https://docs.snowflake.com/en/developer-guide/logging-tracing/tracing-trace-level). For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        :param pulumi.Input[_builtins.bool] transaction_abort_on_error: Specifies the action to perform when a statement issued within a non-autocommit transaction returns with an error. For more information, check [TRANSACTION*ABORT*ON_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-abort-on-error).
        :param pulumi.Input[_builtins.str] transaction_default_isolation_level: Specifies the isolation level for transactions in the user session. For more information, check [TRANSACTION*DEFAULT*ISOLATION_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-default-isolation-level).
        :param pulumi.Input[_builtins.int] two_digit_century_start: Specifies the “century start” year for 2-digit years (i.e. the earliest year such dates can represent). This parameter prevents ambiguous dates when importing or converting data with the `YY` date format component (i.e. years represented as 2 digits). For more information, check [TWO*DIGIT*CENTURY_START docs](https://docs.snowflake.com/en/sql-reference/parameters#two-digit-century-start).
        :param pulumi.Input[_builtins.str] unsupported_ddl_action: Determines if an unsupported (i.e. non-default) value specified for a constraint property returns an error. For more information, check [UNSUPPORTED*DDL*ACTION docs](https://docs.snowflake.com/en/sql-reference/parameters#unsupported-ddl-action).
        :param pulumi.Input[_builtins.bool] use_cached_result: Specifies whether to reuse persisted query results, if available, when a matching query is submitted. For more information, check [USE*CACHED*RESULT docs](https://docs.snowflake.com/en/sql-reference/parameters#use-cached-result).
        :param pulumi.Input[_builtins.str] user_task_managed_initial_warehouse_size: Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. Valid values are (case-insensitive): %s. (Conflicts with warehouse). For more information about warehouses, see docs. For more information, check [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        :param pulumi.Input[_builtins.int] user_task_minimum_trigger_interval_in_seconds: Minimum amount of time between Triggered Task executions in seconds For more information, check [USER*TASK*MINIMUM*TRIGGER*INTERVAL*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-minimum-trigger-interval-in-seconds).
        :param pulumi.Input[_builtins.int] user_task_timeout_ms: Specifies the time limit on a single run of the task before it times out (in milliseconds). For more information, check [USER*TASK*TIMEOUT_MS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        :param pulumi.Input[_builtins.str] warehouse: The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. Due to Snowflake limitations warehouse identifier can consist of only upper-cased letters. (Conflicts with user*task*managed*initial*warehouse_size) For more information about this resource, see docs.
        :param pulumi.Input[_builtins.int] week_of_year_policy: Specifies how the weeks in a given year are computed. `0`: The semantics used are equivalent to the ISO semantics, in which a week belongs to a given year if at least 4 days of that week are in that year. `1`: January 1 is included in the first week of the year and December 31 is included in the last week of the year. For more information, check [WEEK*OF*YEAR_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#week-of-year-policy).
        :param pulumi.Input[_builtins.int] week_start: Specifies the first day of the week (used by week-related date functions). `0`: Legacy Snowflake behavior is used (i.e. ISO-like semantics). `1` (Monday) to `7` (Sunday): All the week-related functions use weeks that start on the specified day of the week. For more information, check [WEEK_START docs](https://docs.snowflake.com/en/sql-reference/parameters#week-start).
        :param pulumi.Input[_builtins.str] when: Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported. When a task is triggered (based on its SCHEDULE or AFTER setting), it validates the conditions of the expression to determine whether to execute. If the conditions of the expression are not met, then the task skips the current run. Any tasks that identify this task as a predecessor also don’t run.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TaskState.__new__(_TaskState)

        __props__.__dict__["abort_detached_query"] = abort_detached_query
        __props__.__dict__["afters"] = afters
        __props__.__dict__["allow_overlapping_execution"] = allow_overlapping_execution
        __props__.__dict__["autocommit"] = autocommit
        __props__.__dict__["binary_input_format"] = binary_input_format
        __props__.__dict__["binary_output_format"] = binary_output_format
        __props__.__dict__["client_memory_limit"] = client_memory_limit
        __props__.__dict__["client_metadata_request_use_connection_ctx"] = client_metadata_request_use_connection_ctx
        __props__.__dict__["client_prefetch_threads"] = client_prefetch_threads
        __props__.__dict__["client_result_chunk_size"] = client_result_chunk_size
        __props__.__dict__["client_result_column_case_insensitive"] = client_result_column_case_insensitive
        __props__.__dict__["client_session_keep_alive"] = client_session_keep_alive
        __props__.__dict__["client_session_keep_alive_heartbeat_frequency"] = client_session_keep_alive_heartbeat_frequency
        __props__.__dict__["client_timestamp_type_mapping"] = client_timestamp_type_mapping
        __props__.__dict__["comment"] = comment
        __props__.__dict__["config"] = config
        __props__.__dict__["database"] = database
        __props__.__dict__["date_input_format"] = date_input_format
        __props__.__dict__["date_output_format"] = date_output_format
        __props__.__dict__["enable_unload_physical_type_optimization"] = enable_unload_physical_type_optimization
        __props__.__dict__["error_integration"] = error_integration
        __props__.__dict__["error_on_nondeterministic_merge"] = error_on_nondeterministic_merge
        __props__.__dict__["error_on_nondeterministic_update"] = error_on_nondeterministic_update
        __props__.__dict__["finalize"] = finalize
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["geography_output_format"] = geography_output_format
        __props__.__dict__["geometry_output_format"] = geometry_output_format
        __props__.__dict__["jdbc_treat_timestamp_ntz_as_utc"] = jdbc_treat_timestamp_ntz_as_utc
        __props__.__dict__["jdbc_use_session_timezone"] = jdbc_use_session_timezone
        __props__.__dict__["json_indent"] = json_indent
        __props__.__dict__["lock_timeout"] = lock_timeout
        __props__.__dict__["log_level"] = log_level
        __props__.__dict__["multi_statement_count"] = multi_statement_count
        __props__.__dict__["name"] = name
        __props__.__dict__["noorder_sequence_as_default"] = noorder_sequence_as_default
        __props__.__dict__["odbc_treat_decimal_as_int"] = odbc_treat_decimal_as_int
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["query_tag"] = query_tag
        __props__.__dict__["quoted_identifiers_ignore_case"] = quoted_identifiers_ignore_case
        __props__.__dict__["rows_per_resultset"] = rows_per_resultset
        __props__.__dict__["s3_stage_vpce_dns_name"] = s3_stage_vpce_dns_name
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["schema"] = schema
        __props__.__dict__["search_path"] = search_path
        __props__.__dict__["show_outputs"] = show_outputs
        __props__.__dict__["sql_statement"] = sql_statement
        __props__.__dict__["started"] = started
        __props__.__dict__["statement_queued_timeout_in_seconds"] = statement_queued_timeout_in_seconds
        __props__.__dict__["statement_timeout_in_seconds"] = statement_timeout_in_seconds
        __props__.__dict__["strict_json_output"] = strict_json_output
        __props__.__dict__["suspend_task_after_num_failures"] = suspend_task_after_num_failures
        __props__.__dict__["task_auto_retry_attempts"] = task_auto_retry_attempts
        __props__.__dict__["time_input_format"] = time_input_format
        __props__.__dict__["time_output_format"] = time_output_format
        __props__.__dict__["timestamp_day_is_always24h"] = timestamp_day_is_always24h
        __props__.__dict__["timestamp_input_format"] = timestamp_input_format
        __props__.__dict__["timestamp_ltz_output_format"] = timestamp_ltz_output_format
        __props__.__dict__["timestamp_ntz_output_format"] = timestamp_ntz_output_format
        __props__.__dict__["timestamp_output_format"] = timestamp_output_format
        __props__.__dict__["timestamp_type_mapping"] = timestamp_type_mapping
        __props__.__dict__["timestamp_tz_output_format"] = timestamp_tz_output_format
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["trace_level"] = trace_level
        __props__.__dict__["transaction_abort_on_error"] = transaction_abort_on_error
        __props__.__dict__["transaction_default_isolation_level"] = transaction_default_isolation_level
        __props__.__dict__["two_digit_century_start"] = two_digit_century_start
        __props__.__dict__["unsupported_ddl_action"] = unsupported_ddl_action
        __props__.__dict__["use_cached_result"] = use_cached_result
        __props__.__dict__["user_task_managed_initial_warehouse_size"] = user_task_managed_initial_warehouse_size
        __props__.__dict__["user_task_minimum_trigger_interval_in_seconds"] = user_task_minimum_trigger_interval_in_seconds
        __props__.__dict__["user_task_timeout_ms"] = user_task_timeout_ms
        __props__.__dict__["warehouse"] = warehouse
        __props__.__dict__["week_of_year_policy"] = week_of_year_policy
        __props__.__dict__["week_start"] = week_start
        __props__.__dict__["when"] = when
        return Task(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="abortDetachedQuery")
    def abort_detached_query(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies the action that Snowflake performs for in-progress queries if connectivity is lost due to abrupt termination of a session (e.g. network outage, browser termination, service interruption). For more information, check [ABORT*DETACHED*QUERY docs](https://docs.snowflake.com/en/sql-reference/parameters#abort-detached-query).
        """
        return pulumi.get(self, "abort_detached_query")

    @_builtins.property
    @pulumi.getter
    def afters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies one or more predecessor tasks for the current task. Use this option to [create a DAG](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-task-dag) of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "afters")

    @_builtins.property
    @pulumi.getter(name="allowOverlappingExecution")
    def allow_overlapping_execution(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "allow_overlapping_execution")

    @_builtins.property
    @pulumi.getter
    def autocommit(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether autocommit is enabled for the session. Autocommit determines whether a DML statement, when executed without an active transaction, is automatically committed after the statement successfully completes. For more information, see [Transactions](https://docs.snowflake.com/en/sql-reference/transactions). For more information, check [AUTOCOMMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#autocommit).
        """
        return pulumi.get(self, "autocommit")

    @_builtins.property
    @pulumi.getter(name="binaryInputFormat")
    def binary_input_format(self) -> pulumi.Output[_builtins.str]:
        """
        The format of VARCHAR values passed as input to VARCHAR-to-BINARY conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-input-format).
        """
        return pulumi.get(self, "binary_input_format")

    @_builtins.property
    @pulumi.getter(name="binaryOutputFormat")
    def binary_output_format(self) -> pulumi.Output[_builtins.str]:
        """
        The format for VARCHAR values returned as output by BINARY-to-VARCHAR conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-output-format).
        """
        return pulumi.get(self, "binary_output_format")

    @_builtins.property
    @pulumi.getter(name="clientMemoryLimit")
    def client_memory_limit(self) -> pulumi.Output[_builtins.int]:
        """
        Parameter that specifies the maximum amount of memory the JDBC driver or ODBC driver should use for the result set from queries (in MB). For more information, check [CLIENT*MEMORY*LIMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#client-memory-limit).
        """
        return pulumi.get(self, "client_memory_limit")

    @_builtins.property
    @pulumi.getter(name="clientMetadataRequestUseConnectionCtx")
    def client_metadata_request_use_connection_ctx(self) -> pulumi.Output[_builtins.bool]:
        """
        For specific ODBC functions and JDBC methods, this parameter can change the default search scope from all databases/schemas to the current database/schema. The narrower search typically returns fewer rows and executes more quickly. For more information, check [CLIENT*METADATA*REQUEST*USE*CONNECTION_CTX docs](https://docs.snowflake.com/en/sql-reference/parameters#client-metadata-request-use-connection-ctx).
        """
        return pulumi.get(self, "client_metadata_request_use_connection_ctx")

    @_builtins.property
    @pulumi.getter(name="clientPrefetchThreads")
    def client_prefetch_threads(self) -> pulumi.Output[_builtins.int]:
        """
        Parameter that specifies the number of threads used by the client to pre-fetch large result sets. The driver will attempt to honor the parameter value, but defines the minimum and maximum values (depending on your system’s resources) to improve performance. For more information, check [CLIENT*PREFETCH*THREADS docs](https://docs.snowflake.com/en/sql-reference/parameters#client-prefetch-threads).
        """
        return pulumi.get(self, "client_prefetch_threads")

    @_builtins.property
    @pulumi.getter(name="clientResultChunkSize")
    def client_result_chunk_size(self) -> pulumi.Output[_builtins.int]:
        """
        Parameter that specifies the maximum size of each set (or chunk) of query results to download (in MB). The JDBC driver downloads query results in chunks. For more information, check [CLIENT*RESULT*CHUNK_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-chunk-size).
        """
        return pulumi.get(self, "client_result_chunk_size")

    @_builtins.property
    @pulumi.getter(name="clientResultColumnCaseInsensitive")
    def client_result_column_case_insensitive(self) -> pulumi.Output[_builtins.bool]:
        """
        Parameter that indicates whether to match column name case-insensitively in ResultSet.get* methods in JDBC. For more information, check [CLIENT*RESULT*COLUMN*CASE*INSENSITIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-column-case-insensitive).
        """
        return pulumi.get(self, "client_result_column_case_insensitive")

    @_builtins.property
    @pulumi.getter(name="clientSessionKeepAlive")
    def client_session_keep_alive(self) -> pulumi.Output[_builtins.bool]:
        """
        Parameter that indicates whether to force a user to log in again after a period of inactivity in the session. For more information, check [CLIENT*SESSION*KEEP_ALIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive).
        """
        return pulumi.get(self, "client_session_keep_alive")

    @_builtins.property
    @pulumi.getter(name="clientSessionKeepAliveHeartbeatFrequency")
    def client_session_keep_alive_heartbeat_frequency(self) -> pulumi.Output[_builtins.int]:
        """
        Number of seconds in-between client attempts to update the token for the session. For more information, check [CLIENT*SESSION*KEEP*ALIVE*HEARTBEAT_FREQUENCY docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive-heartbeat-frequency).
        """
        return pulumi.get(self, "client_session_keep_alive_heartbeat_frequency")

    @_builtins.property
    @pulumi.getter(name="clientTimestampTypeMapping")
    def client_timestamp_type_mapping(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the [TIMESTAMP_* variation](https://docs.snowflake.com/en/sql-reference/data-types-datetime.html#label-datatypes-timestamp-variations) to use when binding timestamp variables for JDBC or ODBC applications that use the bind API to load data. For more information, check [CLIENT*TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#client-timestamp-type-mapping).
        """
        return pulumi.get(self, "client_timestamp_type_mapping")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the task.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a string representation of key value pairs that can be accessed by all tasks in the task graph. Must be in JSON format.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="dateInputFormat")
    def date_input_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the input format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-input-format).
        """
        return pulumi.get(self, "date_input_format")

    @_builtins.property
    @pulumi.getter(name="dateOutputFormat")
    def date_output_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the display format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-output-format).
        """
        return pulumi.get(self, "date_output_format")

    @_builtins.property
    @pulumi.getter(name="enableUnloadPhysicalTypeOptimization")
    def enable_unload_physical_type_optimization(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to set the schema for unloaded Parquet files based on the logical column data types (i.e. the types in the unload SQL query or source table) or on the unloaded column values (i.e. the smallest data types and precision that support the values in the output columns of the unload SQL statement or source table). For more information, check [ENABLE*UNLOAD*PHYSICAL*TYPE*OPTIMIZATION docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unload-physical-type-optimization).
        """
        return pulumi.get(self, "enable_unload_physical_type_optimization")

    @_builtins.property
    @pulumi.getter(name="errorIntegration")
    def error_integration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the notification integration used for error notifications. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see docs.
        """
        return pulumi.get(self, "error_integration")

    @_builtins.property
    @pulumi.getter(name="errorOnNondeterministicMerge")
    def error_on_nondeterministic_merge(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to return an error when the [MERGE](https://docs.snowflake.com/en/sql-reference/sql/merge) command is used to update or delete a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_MERGE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-merge).
        """
        return pulumi.get(self, "error_on_nondeterministic_merge")

    @_builtins.property
    @pulumi.getter(name="errorOnNondeterministicUpdate")
    def error_on_nondeterministic_update(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to return an error when the [UPDATE](https://docs.snowflake.com/en/sql-reference/sql/update) command is used to update a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR*ON*NONDETERMINISTIC_UPDATE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-update).
        """
        return pulumi.get(self, "error_on_nondeterministic_update")

    @_builtins.property
    @pulumi.getter
    def finalize(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of a root task that the finalizer task is associated with. Finalizer tasks run after all other tasks in the task graph run to completion. You can define the SQL of a finalizer task to handle notifications and the release and cleanup of resources that a task graph uses. For more information, see [Release and cleanup of task graphs](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-finalizer-task). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "finalize")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter(name="geographyOutputFormat")
    def geography_output_format(self) -> pulumi.Output[_builtins.str]:
        """
        Display format for [GEOGRAPHY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geography). For more information, check [GEOGRAPHY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geography-output-format).
        """
        return pulumi.get(self, "geography_output_format")

    @_builtins.property
    @pulumi.getter(name="geometryOutputFormat")
    def geometry_output_format(self) -> pulumi.Output[_builtins.str]:
        """
        Display format for [GEOMETRY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geometry). For more information, check [GEOMETRY*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geometry-output-format).
        """
        return pulumi.get(self, "geometry_output_format")

    @_builtins.property
    @pulumi.getter(name="jdbcTreatTimestampNtzAsUtc")
    def jdbc_treat_timestamp_ntz_as_utc(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies how JDBC processes TIMESTAMP*NTZ values. For more information, check [JDBC*TREAT*TIMESTAMP*NTZ*AS*UTC docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-timestamp-ntz-as-utc).
        """
        return pulumi.get(self, "jdbc_treat_timestamp_ntz_as_utc")

    @_builtins.property
    @pulumi.getter(name="jdbcUseSessionTimezone")
    def jdbc_use_session_timezone(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether the JDBC Driver uses the time zone of the JVM or the time zone of the session (specified by the [TIMEZONE](https://docs.snowflake.com/en/sql-reference/parameters#label-timezone) parameter) for the getDate(), getTime(), and getTimestamp() methods of the ResultSet class. For more information, check [JDBC*USE*SESSION_TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-use-session-timezone).
        """
        return pulumi.get(self, "jdbc_use_session_timezone")

    @_builtins.property
    @pulumi.getter(name="jsonIndent")
    def json_indent(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of blank spaces to indent each new element in JSON output in the session. Also specifies whether to insert newline characters after each element. For more information, check [JSON_INDENT docs](https://docs.snowflake.com/en/sql-reference/parameters#json-indent).
        """
        return pulumi.get(self, "json_indent")

    @_builtins.property
    @pulumi.getter(name="lockTimeout")
    def lock_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Number of seconds to wait while trying to lock a resource, before timing out and aborting the statement. For more information, check [LOCK_TIMEOUT docs](https://docs.snowflake.com/en/sql-reference/parameters#lock-timeout).
        """
        return pulumi.get(self, "lock_timeout")

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the severity level of messages that should be ingested and made available in the active event table. Messages at the specified level (and at more severe levels) are ingested. For more information about log levels, see [Setting log level](https://docs.snowflake.com/en/developer-guide/logging-tracing/logging-log-level). For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        """
        return pulumi.get(self, "log_level")

    @_builtins.property
    @pulumi.getter(name="multiStatementCount")
    def multi_statement_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of statements to execute when using the multi-statement capability. For more information, check [MULTI*STATEMENT*COUNT docs](https://docs.snowflake.com/en/sql-reference/parameters#multi-statement-count).
        """
        return pulumi.get(self, "multi_statement_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the task; must be unique for the database and schema in which the task is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="noorderSequenceAsDefault")
    def noorder_sequence_as_default(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether the ORDER or NOORDER property is set by default when you create a new sequence or add a new table column. The ORDER and NOORDER properties determine whether or not the values are generated for the sequence or auto-incremented column in [increasing or decreasing order](https://docs.snowflake.com/en/user-guide/querying-sequences.html#label-querying-sequences-increasing-values). For more information, check [NOORDER*SEQUENCE*AS_DEFAULT docs](https://docs.snowflake.com/en/sql-reference/parameters#noorder-sequence-as-default).
        """
        return pulumi.get(self, "noorder_sequence_as_default")

    @_builtins.property
    @pulumi.getter(name="odbcTreatDecimalAsInt")
    def odbc_treat_decimal_as_int(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies how ODBC processes columns that have a scale of zero (0). For more information, check [ODBC*TREAT*DECIMAL*AS*INT docs](https://docs.snowflake.com/en/sql-reference/parameters#odbc-treat-decimal-as-int).
        """
        return pulumi.get(self, "odbc_treat_decimal_as_int")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.TaskParameter']]:
        """
        Outputs the result of `SHOW PARAMETERS IN TASK` for the given task.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="queryTag")
    def query_tag(self) -> pulumi.Output[_builtins.str]:
        """
        Optional string that can be used to tag queries and other SQL statements executed within a session. The tags are displayed in the output of the [QUERY*HISTORY, QUERY*HISTORY*BY**](https://docs.snowflake.com/en/sql-reference/functions/query_history) functions. For more information, check [QUERY_TAG docs](https://docs.snowflake.com/en/sql-reference/parameters#query-tag).
        """
        return pulumi.get(self, "query_tag")

    @_builtins.property
    @pulumi.getter(name="quotedIdentifiersIgnoreCase")
    def quoted_identifiers_ignore_case(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether letters in double-quoted object identifiers are stored and resolved as uppercase letters. By default, Snowflake preserves the case of alphabetic characters when storing and resolving double-quoted identifiers (see [Identifier resolution](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing)). You can use this parameter in situations in which [third-party applications always use double quotes around identifiers](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing-parameter). For more information, check [QUOTED*IDENTIFIERS*IGNORE_CASE docs](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        """
        return pulumi.get(self, "quoted_identifiers_ignore_case")

    @_builtins.property
    @pulumi.getter(name="rowsPerResultset")
    def rows_per_resultset(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum number of rows returned in a result set. A value of 0 specifies no maximum. For more information, check [ROWS*PER*RESULTSET docs](https://docs.snowflake.com/en/sql-reference/parameters#rows-per-resultset).
        """
        return pulumi.get(self, "rows_per_resultset")

    @_builtins.property
    @pulumi.getter(name="s3StageVpceDnsName")
    def s3_stage_vpce_dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the DNS name of an Amazon S3 interface endpoint. Requests sent to the internal stage of an account via [AWS PrivateLink for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/privatelink-interface-endpoints.html) use this endpoint to connect. For more information, see [Accessing Internal stages with dedicated interface endpoints](https://docs.snowflake.com/en/user-guide/private-internal-stages-aws.html#label-aws-privatelink-internal-stage-network-isolation). For more information, check [S3*STAGE*VPCE*DNS*NAME docs](https://docs.snowflake.com/en/sql-reference/parameters#s3-stage-vpce-dns-name).
        """
        return pulumi.get(self, "s3_stage_vpce_dns_name")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.TaskSchedule']]:
        """
        The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflicts with finalize and after; when set, one of the sub-fields `minutes` or `using_cron` should be set)
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the task. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="searchPath")
    def search_path(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the path to search to resolve unqualified object names in queries. For more information, see [Name resolution in queries](https://docs.snowflake.com/en/sql-reference/name-resolution.html#label-object-name-resolution-search-path). Comma-separated list of identifiers. An identifier can be a fully or partially qualified schema name. For more information, check [SEARCH_PATH docs](https://docs.snowflake.com/en/sql-reference/parameters#search-path).
        """
        return pulumi.get(self, "search_path")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.TaskShowOutput']]:
        """
        Outputs the result of `SHOW TASKS` for the given task.
        """
        return pulumi.get(self, "show_outputs")

    @_builtins.property
    @pulumi.getter(name="sqlStatement")
    def sql_statement(self) -> pulumi.Output[_builtins.str]:
        """
        Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        """
        return pulumi.get(self, "sql_statement")

    @_builtins.property
    @pulumi.getter
    def started(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies if the task should be started or suspended.
        """
        return pulumi.get(self, "started")

    @_builtins.property
    @pulumi.getter(name="statementQueuedTimeoutInSeconds")
    def statement_queued_timeout_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Amount of time, in seconds, a SQL statement (query, DDL, DML, etc.) remains queued for a warehouse before it is canceled by the system. This parameter can be used in conjunction with the [MAX*CONCURRENCY*LEVEL](https://docs.snowflake.com/en/sql-reference/parameters#label-max-concurrency-level) parameter to ensure a warehouse is never backlogged. For more information, check [STATEMENT*QUEUED*TIMEOUT*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-queued-timeout-in-seconds).
        """
        return pulumi.get(self, "statement_queued_timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="statementTimeoutInSeconds")
    def statement_timeout_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Amount of time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system. For more information, check [STATEMENT*TIMEOUT*IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-timeout-in-seconds).
        """
        return pulumi.get(self, "statement_timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="strictJsonOutput")
    def strict_json_output(self) -> pulumi.Output[_builtins.bool]:
        """
        This parameter specifies whether JSON output in a session is compatible with the general standard (as described by [http://json.org](http://json.org)). By design, Snowflake allows JSON input that contains non-standard values; however, these non-standard values might result in Snowflake outputting JSON that is incompatible with other platforms and languages. This parameter, when enabled, ensures that Snowflake outputs valid/compatible JSON. For more information, check [STRICT*JSON*OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#strict-json-output).
        """
        return pulumi.get(self, "strict_json_output")

    @_builtins.property
    @pulumi.getter(name="suspendTaskAfterNumFailures")
    def suspend_task_after_num_failures(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of consecutive failed task runs after which the current task is suspended automatically. The default is 0 (no automatic suspension). For more information, check [SUSPEND*TASK*AFTER*NUM*FAILURES docs](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        """
        return pulumi.get(self, "suspend_task_after_num_failures")

    @_builtins.property
    @pulumi.getter(name="taskAutoRetryAttempts")
    def task_auto_retry_attempts(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of automatic task graph retry attempts. If any task graphs complete in a FAILED state, Snowflake can automatically retry the task graphs from the last task in the graph that failed. For more information, check [TASK*AUTO*RETRY_ATTEMPTS docs](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        """
        return pulumi.get(self, "task_auto_retry_attempts")

    @_builtins.property
    @pulumi.getter(name="timeInputFormat")
    def time_input_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the input format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported time format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of times stored in the system during the session). For more information, check [TIME*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-input-format).
        """
        return pulumi.get(self, "time_input_format")

    @_builtins.property
    @pulumi.getter(name="timeOutputFormat")
    def time_output_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the display format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIME*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-output-format).
        """
        return pulumi.get(self, "time_output_format")

    @_builtins.property
    @pulumi.getter(name="timestampDayIsAlways24h")
    def timestamp_day_is_always24h(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether the [DATEADD](https://docs.snowflake.com/en/sql-reference/functions/dateadd) function (and its aliases) always consider a day to be exactly 24 hours for expressions that span multiple days. For more information, check [TIMESTAMP*DAY*IS*ALWAYS*24H docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-day-is-always-24h).
        """
        return pulumi.get(self, "timestamp_day_is_always24h")

    @_builtins.property
    @pulumi.getter(name="timestampInputFormat")
    def timestamp_input_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the input format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported timestamp format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of timestamps stored in the system during the session). For more information, check [TIMESTAMP*INPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-input-format).
        """
        return pulumi.get(self, "timestamp_input_format")

    @_builtins.property
    @pulumi.getter(name="timestampLtzOutputFormat")
    def timestamp_ltz_output_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the display format for the TIMESTAMP*LTZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*LTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ltz-output-format).
        """
        return pulumi.get(self, "timestamp_ltz_output_format")

    @_builtins.property
    @pulumi.getter(name="timestampNtzOutputFormat")
    def timestamp_ntz_output_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the display format for the TIMESTAMP*NTZ data type. For more information, check [TIMESTAMP*NTZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ntz-output-format).
        """
        return pulumi.get(self, "timestamp_ntz_output_format")

    @_builtins.property
    @pulumi.getter(name="timestampOutputFormat")
    def timestamp_output_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the display format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-output-format).
        """
        return pulumi.get(self, "timestamp_output_format")

    @_builtins.property
    @pulumi.getter(name="timestampTypeMapping")
    def timestamp_type_mapping(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the TIMESTAMP** variation that the TIMESTAMP data type alias maps to. For more information, check [TIMESTAMP*TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-type-mapping).
        """
        return pulumi.get(self, "timestamp_type_mapping")

    @_builtins.property
    @pulumi.getter(name="timestampTzOutputFormat")
    def timestamp_tz_output_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the display format for the TIMESTAMP*TZ data type. If no format is specified, defaults to [TIMESTAMP*OUTPUT*FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP*TZ*OUTPUT*FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-tz-output-format).
        """
        return pulumi.get(self, "timestamp_tz_output_format")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the time zone for the session. You can specify a [time zone name](https://data.iana.org/time-zones/tzdb-2021a/zone1970.tab) or a [link name](https://data.iana.org/time-zones/tzdb-2021a/backward) from release 2021a of the [IANA Time Zone Database](https://www.iana.org/time-zones) (e.g. America/Los_Angeles, Europe/London, UTC, Etc/GMT, etc.). For more information, check [TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#timezone).
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="traceLevel")
    def trace_level(self) -> pulumi.Output[_builtins.str]:
        """
        Controls how trace events are ingested into the event table. For more information about trace levels, see [Setting trace level](https://docs.snowflake.com/en/developer-guide/logging-tracing/tracing-trace-level). For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        """
        return pulumi.get(self, "trace_level")

    @_builtins.property
    @pulumi.getter(name="transactionAbortOnError")
    def transaction_abort_on_error(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies the action to perform when a statement issued within a non-autocommit transaction returns with an error. For more information, check [TRANSACTION*ABORT*ON_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-abort-on-error).
        """
        return pulumi.get(self, "transaction_abort_on_error")

    @_builtins.property
    @pulumi.getter(name="transactionDefaultIsolationLevel")
    def transaction_default_isolation_level(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the isolation level for transactions in the user session. For more information, check [TRANSACTION*DEFAULT*ISOLATION_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-default-isolation-level).
        """
        return pulumi.get(self, "transaction_default_isolation_level")

    @_builtins.property
    @pulumi.getter(name="twoDigitCenturyStart")
    def two_digit_century_start(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the “century start” year for 2-digit years (i.e. the earliest year such dates can represent). This parameter prevents ambiguous dates when importing or converting data with the `YY` date format component (i.e. years represented as 2 digits). For more information, check [TWO*DIGIT*CENTURY_START docs](https://docs.snowflake.com/en/sql-reference/parameters#two-digit-century-start).
        """
        return pulumi.get(self, "two_digit_century_start")

    @_builtins.property
    @pulumi.getter(name="unsupportedDdlAction")
    def unsupported_ddl_action(self) -> pulumi.Output[_builtins.str]:
        """
        Determines if an unsupported (i.e. non-default) value specified for a constraint property returns an error. For more information, check [UNSUPPORTED*DDL*ACTION docs](https://docs.snowflake.com/en/sql-reference/parameters#unsupported-ddl-action).
        """
        return pulumi.get(self, "unsupported_ddl_action")

    @_builtins.property
    @pulumi.getter(name="useCachedResult")
    def use_cached_result(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to reuse persisted query results, if available, when a matching query is submitted. For more information, check [USE*CACHED*RESULT docs](https://docs.snowflake.com/en/sql-reference/parameters#use-cached-result).
        """
        return pulumi.get(self, "use_cached_result")

    @_builtins.property
    @pulumi.getter(name="userTaskManagedInitialWarehouseSize")
    def user_task_managed_initial_warehouse_size(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. Valid values are (case-insensitive): %s. (Conflicts with warehouse). For more information about warehouses, see docs. For more information, check [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        """
        return pulumi.get(self, "user_task_managed_initial_warehouse_size")

    @_builtins.property
    @pulumi.getter(name="userTaskMinimumTriggerIntervalInSeconds")
    def user_task_minimum_trigger_interval_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum amount of time between Triggered Task executions in seconds For more information, check [USER*TASK*MINIMUM*TRIGGER*INTERVAL*IN*SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-minimum-trigger-interval-in-seconds).
        """
        return pulumi.get(self, "user_task_minimum_trigger_interval_in_seconds")

    @_builtins.property
    @pulumi.getter(name="userTaskTimeoutMs")
    def user_task_timeout_ms(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the time limit on a single run of the task before it times out (in milliseconds). For more information, check [USER*TASK*TIMEOUT_MS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        """
        return pulumi.get(self, "user_task_timeout_ms")

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. Due to Snowflake limitations warehouse identifier can consist of only upper-cased letters. (Conflicts with user*task*managed*initial*warehouse_size) For more information about this resource, see docs.
        """
        return pulumi.get(self, "warehouse")

    @_builtins.property
    @pulumi.getter(name="weekOfYearPolicy")
    def week_of_year_policy(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies how the weeks in a given year are computed. `0`: The semantics used are equivalent to the ISO semantics, in which a week belongs to a given year if at least 4 days of that week are in that year. `1`: January 1 is included in the first week of the year and December 31 is included in the last week of the year. For more information, check [WEEK*OF*YEAR_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#week-of-year-policy).
        """
        return pulumi.get(self, "week_of_year_policy")

    @_builtins.property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the first day of the week (used by week-related date functions). `0`: Legacy Snowflake behavior is used (i.e. ISO-like semantics). `1` (Monday) to `7` (Sunday): All the week-related functions use weeks that start on the specified day of the week. For more information, check [WEEK_START docs](https://docs.snowflake.com/en/sql-reference/parameters#week-start).
        """
        return pulumi.get(self, "week_start")

    @_builtins.property
    @pulumi.getter
    def when(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported. When a task is triggered (based on its SCHEDULE or AFTER setting), it validates the conditions of the expression to determine whether to execute. If the conditions of the expression are not met, then the task skips the current run. Any tasks that identify this task as a predecessor also don’t run.
        """
        return pulumi.get(self, "when")

