# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WarehouseArgs', 'Warehouse']

@pulumi.input_type
class WarehouseArgs:
    def __init__(__self__, *,
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_query_acceleration: Optional[pulumi.Input[_builtins.str]] = None,
                 generation: Optional[pulumi.Input[_builtins.str]] = None,
                 initially_suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_cluster_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_concurrency_level: Optional[pulumi.Input[_builtins.int]] = None,
                 min_cluster_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_acceleration_max_scale_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_constraint: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Warehouse resource.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the warehouse.
        :param pulumi.Input[_builtins.str] enable_query_acceleration: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] generation: Specifies the generation for the warehouse. Only available for standard warehouses. Valid values are (case-insensitive): `1` | `2`.
        :param pulumi.Input[_builtins.bool] initially_suspended: Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        :param pulumi.Input[_builtins.int] max_cluster_count: Specifies the maximum number of server clusters for the warehouse.
        :param pulumi.Input[_builtins.int] max_concurrency_level: Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        :param pulumi.Input[_builtins.int] min_cluster_count: Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        :param pulumi.Input[_builtins.str] name: Identifier for the virtual warehouse; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.int] query_acceleration_max_scale_factor: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        :param pulumi.Input[_builtins.str] resource_constraint: Specifies the resource constraint for the warehouse. Only available for snowpark-optimized warehouses. For setting generation please use the `generation` field. Please check [Snowflake documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for required warehouse sizes for each resource constraint. Valid values are (case-insensitive): `MEMORY_1X` | `MEMORY_1X_x86` | `MEMORY_16X` | `MEMORY_16X_x86` | `MEMORY_64X` | `MEMORY_64X_x86`.
        :param pulumi.Input[_builtins.str] resource_monitor: Specifies the name of a resource monitor that is explicitly assigned to the warehouse. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] scaling_policy: Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode. Valid values are (case-insensitive): `STANDARD` | `ECONOMY`.
        :param pulumi.Input[_builtins.int] statement_queued_timeout_in_seconds: Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        :param pulumi.Input[_builtins.int] statement_timeout_in_seconds: Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        :param pulumi.Input[_builtins.str] warehouse_size: Specifies the size of the virtual warehouse. Valid values are (case-insensitive): `XSMALL` | `X-SMALL` | `SMALL` | `MEDIUM` | `LARGE` | `XLARGE` | `X-LARGE` | `XXLARGE` | `X2LARGE` | `2X-LARGE` | `XXXLARGE` | `X3LARGE` | `3X-LARGE` | `X4LARGE` | `4X-LARGE` | `X5LARGE` | `5X-LARGE` | `X6LARGE` | `6X-LARGE`. Consult [warehouse documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for the details. Note: removing the size from config will result in the resource recreation.
        :param pulumi.Input[_builtins.str] warehouse_type: Specifies warehouse type. Valid values are (case-insensitive): `STANDARD` | `SNOWPARK-OPTIMIZED`. Warehouse needs to be suspended to change its type. Provider will handle automatic suspension and resumption if needed.
        """
        if auto_resume is not None:
            pulumi.set(__self__, "auto_resume", auto_resume)
        if auto_suspend is not None:
            pulumi.set(__self__, "auto_suspend", auto_suspend)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if enable_query_acceleration is not None:
            pulumi.set(__self__, "enable_query_acceleration", enable_query_acceleration)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if initially_suspended is not None:
            pulumi.set(__self__, "initially_suspended", initially_suspended)
        if max_cluster_count is not None:
            pulumi.set(__self__, "max_cluster_count", max_cluster_count)
        if max_concurrency_level is not None:
            pulumi.set(__self__, "max_concurrency_level", max_concurrency_level)
        if min_cluster_count is not None:
            pulumi.set(__self__, "min_cluster_count", min_cluster_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_acceleration_max_scale_factor is not None:
            pulumi.set(__self__, "query_acceleration_max_scale_factor", query_acceleration_max_scale_factor)
        if resource_constraint is not None:
            pulumi.set(__self__, "resource_constraint", resource_constraint)
        if resource_monitor is not None:
            pulumi.set(__self__, "resource_monitor", resource_monitor)
        if scaling_policy is not None:
            pulumi.set(__self__, "scaling_policy", scaling_policy)
        if statement_queued_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_queued_timeout_in_seconds", statement_queued_timeout_in_seconds)
        if statement_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_timeout_in_seconds", statement_timeout_in_seconds)
        if warehouse_size is not None:
            pulumi.set(__self__, "warehouse_size", warehouse_size)
        if warehouse_type is not None:
            pulumi.set(__self__, "warehouse_type", warehouse_type)

    @_builtins.property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "auto_resume")

    @auto_resume.setter
    def auto_resume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_resume", value)

    @_builtins.property
    @pulumi.getter(name="autoSuspend")
    def auto_suspend(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        """
        return pulumi.get(self, "auto_suspend")

    @auto_suspend.setter
    def auto_suspend(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_suspend", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the warehouse.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="enableQueryAcceleration")
    def enable_query_acceleration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "enable_query_acceleration")

    @enable_query_acceleration.setter
    def enable_query_acceleration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_query_acceleration", value)

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the generation for the warehouse. Only available for standard warehouses. Valid values are (case-insensitive): `1` | `2`.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generation", value)

    @_builtins.property
    @pulumi.getter(name="initiallySuspended")
    def initially_suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        """
        return pulumi.get(self, "initially_suspended")

    @initially_suspended.setter
    def initially_suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "initially_suspended", value)

    @_builtins.property
    @pulumi.getter(name="maxClusterCount")
    def max_cluster_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of server clusters for the warehouse.
        """
        return pulumi.get(self, "max_cluster_count")

    @max_cluster_count.setter
    def max_cluster_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_cluster_count", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrencyLevel")
    def max_concurrency_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        """
        return pulumi.get(self, "max_concurrency_level")

    @max_concurrency_level.setter
    def max_concurrency_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_concurrency_level", value)

    @_builtins.property
    @pulumi.getter(name="minClusterCount")
    def min_cluster_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        """
        return pulumi.get(self, "min_cluster_count")

    @min_cluster_count.setter
    def min_cluster_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_cluster_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the virtual warehouse; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryAccelerationMaxScaleFactor")
    def query_acceleration_max_scale_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        """
        return pulumi.get(self, "query_acceleration_max_scale_factor")

    @query_acceleration_max_scale_factor.setter
    def query_acceleration_max_scale_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "query_acceleration_max_scale_factor", value)

    @_builtins.property
    @pulumi.getter(name="resourceConstraint")
    def resource_constraint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the resource constraint for the warehouse. Only available for snowpark-optimized warehouses. For setting generation please use the `generation` field. Please check [Snowflake documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for required warehouse sizes for each resource constraint. Valid values are (case-insensitive): `MEMORY_1X` | `MEMORY_1X_x86` | `MEMORY_16X` | `MEMORY_16X_x86` | `MEMORY_64X` | `MEMORY_64X_x86`.
        """
        return pulumi.get(self, "resource_constraint")

    @resource_constraint.setter
    def resource_constraint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_constraint", value)

    @_builtins.property
    @pulumi.getter(name="resourceMonitor")
    def resource_monitor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of a resource monitor that is explicitly assigned to the warehouse. For more information about this resource, see docs.
        """
        return pulumi.get(self, "resource_monitor")

    @resource_monitor.setter
    def resource_monitor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_monitor", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode. Valid values are (case-insensitive): `STANDARD` | `ECONOMY`.
        """
        return pulumi.get(self, "scaling_policy")

    @scaling_policy.setter
    def scaling_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_policy", value)

    @_builtins.property
    @pulumi.getter(name="statementQueuedTimeoutInSeconds")
    def statement_queued_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        """
        return pulumi.get(self, "statement_queued_timeout_in_seconds")

    @statement_queued_timeout_in_seconds.setter
    def statement_queued_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "statement_queued_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="statementTimeoutInSeconds")
    def statement_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        """
        return pulumi.get(self, "statement_timeout_in_seconds")

    @statement_timeout_in_seconds.setter
    def statement_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "statement_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="warehouseSize")
    def warehouse_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the size of the virtual warehouse. Valid values are (case-insensitive): `XSMALL` | `X-SMALL` | `SMALL` | `MEDIUM` | `LARGE` | `XLARGE` | `X-LARGE` | `XXLARGE` | `X2LARGE` | `2X-LARGE` | `XXXLARGE` | `X3LARGE` | `3X-LARGE` | `X4LARGE` | `4X-LARGE` | `X5LARGE` | `5X-LARGE` | `X6LARGE` | `6X-LARGE`. Consult [warehouse documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for the details. Note: removing the size from config will result in the resource recreation.
        """
        return pulumi.get(self, "warehouse_size")

    @warehouse_size.setter
    def warehouse_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse_size", value)

    @_builtins.property
    @pulumi.getter(name="warehouseType")
    def warehouse_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies warehouse type. Valid values are (case-insensitive): `STANDARD` | `SNOWPARK-OPTIMIZED`. Warehouse needs to be suspended to change its type. Provider will handle automatic suspension and resumption if needed.
        """
        return pulumi.get(self, "warehouse_type")

    @warehouse_type.setter
    def warehouse_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse_type", value)


@pulumi.input_type
class _WarehouseState:
    def __init__(__self__, *,
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_query_acceleration: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 generation: Optional[pulumi.Input[_builtins.str]] = None,
                 initially_suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_cluster_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_concurrency_level: Optional[pulumi.Input[_builtins.int]] = None,
                 min_cluster_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['WarehouseParameterArgs']]]] = None,
                 query_acceleration_max_scale_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_constraint: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['WarehouseShowOutputArgs']]]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Warehouse resources.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the warehouse.
        :param pulumi.Input[_builtins.str] enable_query_acceleration: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] generation: Specifies the generation for the warehouse. Only available for standard warehouses. Valid values are (case-insensitive): `1` | `2`.
        :param pulumi.Input[_builtins.bool] initially_suspended: Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        :param pulumi.Input[_builtins.int] max_cluster_count: Specifies the maximum number of server clusters for the warehouse.
        :param pulumi.Input[_builtins.int] max_concurrency_level: Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        :param pulumi.Input[_builtins.int] min_cluster_count: Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        :param pulumi.Input[_builtins.str] name: Identifier for the virtual warehouse; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['WarehouseParameterArgs']]] parameters: Outputs the result of `SHOW PARAMETERS IN WAREHOUSE` for the given warehouse.
        :param pulumi.Input[_builtins.int] query_acceleration_max_scale_factor: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        :param pulumi.Input[_builtins.str] resource_constraint: Specifies the resource constraint for the warehouse. Only available for snowpark-optimized warehouses. For setting generation please use the `generation` field. Please check [Snowflake documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for required warehouse sizes for each resource constraint. Valid values are (case-insensitive): `MEMORY_1X` | `MEMORY_1X_x86` | `MEMORY_16X` | `MEMORY_16X_x86` | `MEMORY_64X` | `MEMORY_64X_x86`.
        :param pulumi.Input[_builtins.str] resource_monitor: Specifies the name of a resource monitor that is explicitly assigned to the warehouse. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] scaling_policy: Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode. Valid values are (case-insensitive): `STANDARD` | `ECONOMY`.
        :param pulumi.Input[Sequence[pulumi.Input['WarehouseShowOutputArgs']]] show_outputs: Outputs the result of `SHOW WAREHOUSES` for the given warehouse.
        :param pulumi.Input[_builtins.int] statement_queued_timeout_in_seconds: Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        :param pulumi.Input[_builtins.int] statement_timeout_in_seconds: Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        :param pulumi.Input[_builtins.str] warehouse_size: Specifies the size of the virtual warehouse. Valid values are (case-insensitive): `XSMALL` | `X-SMALL` | `SMALL` | `MEDIUM` | `LARGE` | `XLARGE` | `X-LARGE` | `XXLARGE` | `X2LARGE` | `2X-LARGE` | `XXXLARGE` | `X3LARGE` | `3X-LARGE` | `X4LARGE` | `4X-LARGE` | `X5LARGE` | `5X-LARGE` | `X6LARGE` | `6X-LARGE`. Consult [warehouse documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for the details. Note: removing the size from config will result in the resource recreation.
        :param pulumi.Input[_builtins.str] warehouse_type: Specifies warehouse type. Valid values are (case-insensitive): `STANDARD` | `SNOWPARK-OPTIMIZED`. Warehouse needs to be suspended to change its type. Provider will handle automatic suspension and resumption if needed.
        """
        if auto_resume is not None:
            pulumi.set(__self__, "auto_resume", auto_resume)
        if auto_suspend is not None:
            pulumi.set(__self__, "auto_suspend", auto_suspend)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if enable_query_acceleration is not None:
            pulumi.set(__self__, "enable_query_acceleration", enable_query_acceleration)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if initially_suspended is not None:
            pulumi.set(__self__, "initially_suspended", initially_suspended)
        if max_cluster_count is not None:
            pulumi.set(__self__, "max_cluster_count", max_cluster_count)
        if max_concurrency_level is not None:
            pulumi.set(__self__, "max_concurrency_level", max_concurrency_level)
        if min_cluster_count is not None:
            pulumi.set(__self__, "min_cluster_count", min_cluster_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if query_acceleration_max_scale_factor is not None:
            pulumi.set(__self__, "query_acceleration_max_scale_factor", query_acceleration_max_scale_factor)
        if resource_constraint is not None:
            pulumi.set(__self__, "resource_constraint", resource_constraint)
        if resource_monitor is not None:
            pulumi.set(__self__, "resource_monitor", resource_monitor)
        if scaling_policy is not None:
            pulumi.set(__self__, "scaling_policy", scaling_policy)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)
        if statement_queued_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_queued_timeout_in_seconds", statement_queued_timeout_in_seconds)
        if statement_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_timeout_in_seconds", statement_timeout_in_seconds)
        if warehouse_size is not None:
            pulumi.set(__self__, "warehouse_size", warehouse_size)
        if warehouse_type is not None:
            pulumi.set(__self__, "warehouse_type", warehouse_type)

    @_builtins.property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "auto_resume")

    @auto_resume.setter
    def auto_resume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_resume", value)

    @_builtins.property
    @pulumi.getter(name="autoSuspend")
    def auto_suspend(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        """
        return pulumi.get(self, "auto_suspend")

    @auto_suspend.setter
    def auto_suspend(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_suspend", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the warehouse.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="enableQueryAcceleration")
    def enable_query_acceleration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "enable_query_acceleration")

    @enable_query_acceleration.setter
    def enable_query_acceleration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_query_acceleration", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the generation for the warehouse. Only available for standard warehouses. Valid values are (case-insensitive): `1` | `2`.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generation", value)

    @_builtins.property
    @pulumi.getter(name="initiallySuspended")
    def initially_suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        """
        return pulumi.get(self, "initially_suspended")

    @initially_suspended.setter
    def initially_suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "initially_suspended", value)

    @_builtins.property
    @pulumi.getter(name="maxClusterCount")
    def max_cluster_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of server clusters for the warehouse.
        """
        return pulumi.get(self, "max_cluster_count")

    @max_cluster_count.setter
    def max_cluster_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_cluster_count", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrencyLevel")
    def max_concurrency_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        """
        return pulumi.get(self, "max_concurrency_level")

    @max_concurrency_level.setter
    def max_concurrency_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_concurrency_level", value)

    @_builtins.property
    @pulumi.getter(name="minClusterCount")
    def min_cluster_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        """
        return pulumi.get(self, "min_cluster_count")

    @min_cluster_count.setter
    def min_cluster_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_cluster_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the virtual warehouse; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WarehouseParameterArgs']]]]:
        """
        Outputs the result of `SHOW PARAMETERS IN WAREHOUSE` for the given warehouse.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WarehouseParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="queryAccelerationMaxScaleFactor")
    def query_acceleration_max_scale_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        """
        return pulumi.get(self, "query_acceleration_max_scale_factor")

    @query_acceleration_max_scale_factor.setter
    def query_acceleration_max_scale_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "query_acceleration_max_scale_factor", value)

    @_builtins.property
    @pulumi.getter(name="resourceConstraint")
    def resource_constraint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the resource constraint for the warehouse. Only available for snowpark-optimized warehouses. For setting generation please use the `generation` field. Please check [Snowflake documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for required warehouse sizes for each resource constraint. Valid values are (case-insensitive): `MEMORY_1X` | `MEMORY_1X_x86` | `MEMORY_16X` | `MEMORY_16X_x86` | `MEMORY_64X` | `MEMORY_64X_x86`.
        """
        return pulumi.get(self, "resource_constraint")

    @resource_constraint.setter
    def resource_constraint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_constraint", value)

    @_builtins.property
    @pulumi.getter(name="resourceMonitor")
    def resource_monitor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of a resource monitor that is explicitly assigned to the warehouse. For more information about this resource, see docs.
        """
        return pulumi.get(self, "resource_monitor")

    @resource_monitor.setter
    def resource_monitor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_monitor", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode. Valid values are (case-insensitive): `STANDARD` | `ECONOMY`.
        """
        return pulumi.get(self, "scaling_policy")

    @scaling_policy.setter
    def scaling_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_policy", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WarehouseShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW WAREHOUSES` for the given warehouse.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WarehouseShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)

    @_builtins.property
    @pulumi.getter(name="statementQueuedTimeoutInSeconds")
    def statement_queued_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        """
        return pulumi.get(self, "statement_queued_timeout_in_seconds")

    @statement_queued_timeout_in_seconds.setter
    def statement_queued_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "statement_queued_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="statementTimeoutInSeconds")
    def statement_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        """
        return pulumi.get(self, "statement_timeout_in_seconds")

    @statement_timeout_in_seconds.setter
    def statement_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "statement_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="warehouseSize")
    def warehouse_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the size of the virtual warehouse. Valid values are (case-insensitive): `XSMALL` | `X-SMALL` | `SMALL` | `MEDIUM` | `LARGE` | `XLARGE` | `X-LARGE` | `XXLARGE` | `X2LARGE` | `2X-LARGE` | `XXXLARGE` | `X3LARGE` | `3X-LARGE` | `X4LARGE` | `4X-LARGE` | `X5LARGE` | `5X-LARGE` | `X6LARGE` | `6X-LARGE`. Consult [warehouse documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for the details. Note: removing the size from config will result in the resource recreation.
        """
        return pulumi.get(self, "warehouse_size")

    @warehouse_size.setter
    def warehouse_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse_size", value)

    @_builtins.property
    @pulumi.getter(name="warehouseType")
    def warehouse_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies warehouse type. Valid values are (case-insensitive): `STANDARD` | `SNOWPARK-OPTIMIZED`. Warehouse needs to be suspended to change its type. Provider will handle automatic suspension and resumption if needed.
        """
        return pulumi.get(self, "warehouse_type")

    @warehouse_type.setter
    def warehouse_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse_type", value)


@pulumi.type_token("snowflake:index/warehouse:Warehouse")
class Warehouse(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_query_acceleration: Optional[pulumi.Input[_builtins.str]] = None,
                 generation: Optional[pulumi.Input[_builtins.str]] = None,
                 initially_suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_cluster_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_concurrency_level: Optional[pulumi.Input[_builtins.int]] = None,
                 min_cluster_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_acceleration_max_scale_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_constraint: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/warehouse:Warehouse example '"<warehouse_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the warehouse.
        :param pulumi.Input[_builtins.str] enable_query_acceleration: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] generation: Specifies the generation for the warehouse. Only available for standard warehouses. Valid values are (case-insensitive): `1` | `2`.
        :param pulumi.Input[_builtins.bool] initially_suspended: Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        :param pulumi.Input[_builtins.int] max_cluster_count: Specifies the maximum number of server clusters for the warehouse.
        :param pulumi.Input[_builtins.int] max_concurrency_level: Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        :param pulumi.Input[_builtins.int] min_cluster_count: Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        :param pulumi.Input[_builtins.str] name: Identifier for the virtual warehouse; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.int] query_acceleration_max_scale_factor: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        :param pulumi.Input[_builtins.str] resource_constraint: Specifies the resource constraint for the warehouse. Only available for snowpark-optimized warehouses. For setting generation please use the `generation` field. Please check [Snowflake documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for required warehouse sizes for each resource constraint. Valid values are (case-insensitive): `MEMORY_1X` | `MEMORY_1X_x86` | `MEMORY_16X` | `MEMORY_16X_x86` | `MEMORY_64X` | `MEMORY_64X_x86`.
        :param pulumi.Input[_builtins.str] resource_monitor: Specifies the name of a resource monitor that is explicitly assigned to the warehouse. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] scaling_policy: Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode. Valid values are (case-insensitive): `STANDARD` | `ECONOMY`.
        :param pulumi.Input[_builtins.int] statement_queued_timeout_in_seconds: Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        :param pulumi.Input[_builtins.int] statement_timeout_in_seconds: Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        :param pulumi.Input[_builtins.str] warehouse_size: Specifies the size of the virtual warehouse. Valid values are (case-insensitive): `XSMALL` | `X-SMALL` | `SMALL` | `MEDIUM` | `LARGE` | `XLARGE` | `X-LARGE` | `XXLARGE` | `X2LARGE` | `2X-LARGE` | `XXXLARGE` | `X3LARGE` | `3X-LARGE` | `X4LARGE` | `4X-LARGE` | `X5LARGE` | `5X-LARGE` | `X6LARGE` | `6X-LARGE`. Consult [warehouse documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for the details. Note: removing the size from config will result in the resource recreation.
        :param pulumi.Input[_builtins.str] warehouse_type: Specifies warehouse type. Valid values are (case-insensitive): `STANDARD` | `SNOWPARK-OPTIMIZED`. Warehouse needs to be suspended to change its type. Provider will handle automatic suspension and resumption if needed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[WarehouseArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/warehouse:Warehouse example '"<warehouse_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param WarehouseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WarehouseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_query_acceleration: Optional[pulumi.Input[_builtins.str]] = None,
                 generation: Optional[pulumi.Input[_builtins.str]] = None,
                 initially_suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_cluster_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_concurrency_level: Optional[pulumi.Input[_builtins.int]] = None,
                 min_cluster_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_acceleration_max_scale_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_constraint: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WarehouseArgs.__new__(WarehouseArgs)

            __props__.__dict__["auto_resume"] = auto_resume
            __props__.__dict__["auto_suspend"] = auto_suspend
            __props__.__dict__["comment"] = comment
            __props__.__dict__["enable_query_acceleration"] = enable_query_acceleration
            __props__.__dict__["generation"] = generation
            __props__.__dict__["initially_suspended"] = initially_suspended
            __props__.__dict__["max_cluster_count"] = max_cluster_count
            __props__.__dict__["max_concurrency_level"] = max_concurrency_level
            __props__.__dict__["min_cluster_count"] = min_cluster_count
            __props__.__dict__["name"] = name
            __props__.__dict__["query_acceleration_max_scale_factor"] = query_acceleration_max_scale_factor
            __props__.__dict__["resource_constraint"] = resource_constraint
            __props__.__dict__["resource_monitor"] = resource_monitor
            __props__.__dict__["scaling_policy"] = scaling_policy
            __props__.__dict__["statement_queued_timeout_in_seconds"] = statement_queued_timeout_in_seconds
            __props__.__dict__["statement_timeout_in_seconds"] = statement_timeout_in_seconds
            __props__.__dict__["warehouse_size"] = warehouse_size
            __props__.__dict__["warehouse_type"] = warehouse_type
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["parameters"] = None
            __props__.__dict__["show_outputs"] = None
        super(Warehouse, __self__).__init__(
            'snowflake:index/warehouse:Warehouse',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
            auto_suspend: Optional[pulumi.Input[_builtins.int]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            enable_query_acceleration: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            generation: Optional[pulumi.Input[_builtins.str]] = None,
            initially_suspended: Optional[pulumi.Input[_builtins.bool]] = None,
            max_cluster_count: Optional[pulumi.Input[_builtins.int]] = None,
            max_concurrency_level: Optional[pulumi.Input[_builtins.int]] = None,
            min_cluster_count: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WarehouseParameterArgs', 'WarehouseParameterArgsDict']]]]] = None,
            query_acceleration_max_scale_factor: Optional[pulumi.Input[_builtins.int]] = None,
            resource_constraint: Optional[pulumi.Input[_builtins.str]] = None,
            resource_monitor: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WarehouseShowOutputArgs', 'WarehouseShowOutputArgsDict']]]]] = None,
            statement_queued_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            statement_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
            warehouse_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Warehouse':
        """
        Get an existing Warehouse resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the warehouse.
        :param pulumi.Input[_builtins.str] enable_query_acceleration: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] generation: Specifies the generation for the warehouse. Only available for standard warehouses. Valid values are (case-insensitive): `1` | `2`.
        :param pulumi.Input[_builtins.bool] initially_suspended: Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        :param pulumi.Input[_builtins.int] max_cluster_count: Specifies the maximum number of server clusters for the warehouse.
        :param pulumi.Input[_builtins.int] max_concurrency_level: Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        :param pulumi.Input[_builtins.int] min_cluster_count: Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        :param pulumi.Input[_builtins.str] name: Identifier for the virtual warehouse; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WarehouseParameterArgs', 'WarehouseParameterArgsDict']]]] parameters: Outputs the result of `SHOW PARAMETERS IN WAREHOUSE` for the given warehouse.
        :param pulumi.Input[_builtins.int] query_acceleration_max_scale_factor: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        :param pulumi.Input[_builtins.str] resource_constraint: Specifies the resource constraint for the warehouse. Only available for snowpark-optimized warehouses. For setting generation please use the `generation` field. Please check [Snowflake documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for required warehouse sizes for each resource constraint. Valid values are (case-insensitive): `MEMORY_1X` | `MEMORY_1X_x86` | `MEMORY_16X` | `MEMORY_16X_x86` | `MEMORY_64X` | `MEMORY_64X_x86`.
        :param pulumi.Input[_builtins.str] resource_monitor: Specifies the name of a resource monitor that is explicitly assigned to the warehouse. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] scaling_policy: Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode. Valid values are (case-insensitive): `STANDARD` | `ECONOMY`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WarehouseShowOutputArgs', 'WarehouseShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW WAREHOUSES` for the given warehouse.
        :param pulumi.Input[_builtins.int] statement_queued_timeout_in_seconds: Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        :param pulumi.Input[_builtins.int] statement_timeout_in_seconds: Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        :param pulumi.Input[_builtins.str] warehouse_size: Specifies the size of the virtual warehouse. Valid values are (case-insensitive): `XSMALL` | `X-SMALL` | `SMALL` | `MEDIUM` | `LARGE` | `XLARGE` | `X-LARGE` | `XXLARGE` | `X2LARGE` | `2X-LARGE` | `XXXLARGE` | `X3LARGE` | `3X-LARGE` | `X4LARGE` | `4X-LARGE` | `X5LARGE` | `5X-LARGE` | `X6LARGE` | `6X-LARGE`. Consult [warehouse documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for the details. Note: removing the size from config will result in the resource recreation.
        :param pulumi.Input[_builtins.str] warehouse_type: Specifies warehouse type. Valid values are (case-insensitive): `STANDARD` | `SNOWPARK-OPTIMIZED`. Warehouse needs to be suspended to change its type. Provider will handle automatic suspension and resumption if needed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WarehouseState.__new__(_WarehouseState)

        __props__.__dict__["auto_resume"] = auto_resume
        __props__.__dict__["auto_suspend"] = auto_suspend
        __props__.__dict__["comment"] = comment
        __props__.__dict__["enable_query_acceleration"] = enable_query_acceleration
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["generation"] = generation
        __props__.__dict__["initially_suspended"] = initially_suspended
        __props__.__dict__["max_cluster_count"] = max_cluster_count
        __props__.__dict__["max_concurrency_level"] = max_concurrency_level
        __props__.__dict__["min_cluster_count"] = min_cluster_count
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["query_acceleration_max_scale_factor"] = query_acceleration_max_scale_factor
        __props__.__dict__["resource_constraint"] = resource_constraint
        __props__.__dict__["resource_monitor"] = resource_monitor
        __props__.__dict__["scaling_policy"] = scaling_policy
        __props__.__dict__["show_outputs"] = show_outputs
        __props__.__dict__["statement_queued_timeout_in_seconds"] = statement_queued_timeout_in_seconds
        __props__.__dict__["statement_timeout_in_seconds"] = statement_timeout_in_seconds
        __props__.__dict__["warehouse_size"] = warehouse_size
        __props__.__dict__["warehouse_type"] = warehouse_type
        return Warehouse(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "auto_resume")

    @_builtins.property
    @pulumi.getter(name="autoSuspend")
    def auto_suspend(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        """
        return pulumi.get(self, "auto_suspend")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the warehouse.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="enableQueryAcceleration")
    def enable_query_acceleration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "enable_query_acceleration")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the generation for the warehouse. Only available for standard warehouses. Valid values are (case-insensitive): `1` | `2`.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter(name="initiallySuspended")
    def initially_suspended(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        """
        return pulumi.get(self, "initially_suspended")

    @_builtins.property
    @pulumi.getter(name="maxClusterCount")
    def max_cluster_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the maximum number of server clusters for the warehouse.
        """
        return pulumi.get(self, "max_cluster_count")

    @_builtins.property
    @pulumi.getter(name="maxConcurrencyLevel")
    def max_concurrency_level(self) -> pulumi.Output[_builtins.int]:
        """
        Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        """
        return pulumi.get(self, "max_concurrency_level")

    @_builtins.property
    @pulumi.getter(name="minClusterCount")
    def min_cluster_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        """
        return pulumi.get(self, "min_cluster_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier for the virtual warehouse; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.WarehouseParameter']]:
        """
        Outputs the result of `SHOW PARAMETERS IN WAREHOUSE` for the given warehouse.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="queryAccelerationMaxScaleFactor")
    def query_acceleration_max_scale_factor(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        """
        return pulumi.get(self, "query_acceleration_max_scale_factor")

    @_builtins.property
    @pulumi.getter(name="resourceConstraint")
    def resource_constraint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the resource constraint for the warehouse. Only available for snowpark-optimized warehouses. For setting generation please use the `generation` field. Please check [Snowflake documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for required warehouse sizes for each resource constraint. Valid values are (case-insensitive): `MEMORY_1X` | `MEMORY_1X_x86` | `MEMORY_16X` | `MEMORY_16X_x86` | `MEMORY_64X` | `MEMORY_64X_x86`.
        """
        return pulumi.get(self, "resource_constraint")

    @_builtins.property
    @pulumi.getter(name="resourceMonitor")
    def resource_monitor(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of a resource monitor that is explicitly assigned to the warehouse. For more information about this resource, see docs.
        """
        return pulumi.get(self, "resource_monitor")

    @_builtins.property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode. Valid values are (case-insensitive): `STANDARD` | `ECONOMY`.
        """
        return pulumi.get(self, "scaling_policy")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.WarehouseShowOutput']]:
        """
        Outputs the result of `SHOW WAREHOUSES` for the given warehouse.
        """
        return pulumi.get(self, "show_outputs")

    @_builtins.property
    @pulumi.getter(name="statementQueuedTimeoutInSeconds")
    def statement_queued_timeout_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        """
        return pulumi.get(self, "statement_queued_timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="statementTimeoutInSeconds")
    def statement_timeout_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        """
        return pulumi.get(self, "statement_timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="warehouseSize")
    def warehouse_size(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the size of the virtual warehouse. Valid values are (case-insensitive): `XSMALL` | `X-SMALL` | `SMALL` | `MEDIUM` | `LARGE` | `XLARGE` | `X-LARGE` | `XXLARGE` | `X2LARGE` | `2X-LARGE` | `XXXLARGE` | `X3LARGE` | `3X-LARGE` | `X4LARGE` | `4X-LARGE` | `X5LARGE` | `5X-LARGE` | `X6LARGE` | `6X-LARGE`. Consult [warehouse documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for the details. Note: removing the size from config will result in the resource recreation.
        """
        return pulumi.get(self, "warehouse_size")

    @_builtins.property
    @pulumi.getter(name="warehouseType")
    def warehouse_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies warehouse type. Valid values are (case-insensitive): `STANDARD` | `SNOWPARK-OPTIMIZED`. Warehouse needs to be suspended to change its type. Provider will handle automatic suspension and resumption if needed.
        """
        return pulumi.get(self, "warehouse_type")

