# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_ecd20200930 import models as ecd_20200930_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._signature_algorithm = 'v2'
        self._endpoint_rule = 'regional'
        self.check_config(config)
        self._endpoint = self.get_endpoint('ecd', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def activate_office_site_with_options(
        self,
        request: ecd_20200930_models.ActivateOfficeSiteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ActivateOfficeSiteResponse:
        """
        @summary Unlocks a convenience office network that is automatically locked due to a long idle period of time.
        
        @description If you do not create any cloud computer in a convenience office network within 15 days, the office network is automatically locked and virtual private cloud (VPC) resources are released. If you want to resume the office network, you can call this operation to unlock the office network.
        
        @param request: ActivateOfficeSiteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ActivateOfficeSiteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActivateOfficeSite',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ActivateOfficeSiteResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ActivateOfficeSiteResponse(),
                self.execute(params, req, runtime)
            )

    async def activate_office_site_with_options_async(
        self,
        request: ecd_20200930_models.ActivateOfficeSiteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ActivateOfficeSiteResponse:
        """
        @summary Unlocks a convenience office network that is automatically locked due to a long idle period of time.
        
        @description If you do not create any cloud computer in a convenience office network within 15 days, the office network is automatically locked and virtual private cloud (VPC) resources are released. If you want to resume the office network, you can call this operation to unlock the office network.
        
        @param request: ActivateOfficeSiteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ActivateOfficeSiteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActivateOfficeSite',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ActivateOfficeSiteResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ActivateOfficeSiteResponse(),
                await self.execute_async(params, req, runtime)
            )

    def activate_office_site(
        self,
        request: ecd_20200930_models.ActivateOfficeSiteRequest,
    ) -> ecd_20200930_models.ActivateOfficeSiteResponse:
        """
        @summary Unlocks a convenience office network that is automatically locked due to a long idle period of time.
        
        @description If you do not create any cloud computer in a convenience office network within 15 days, the office network is automatically locked and virtual private cloud (VPC) resources are released. If you want to resume the office network, you can call this operation to unlock the office network.
        
        @param request: ActivateOfficeSiteRequest
        @return: ActivateOfficeSiteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.activate_office_site_with_options(request, runtime)

    async def activate_office_site_async(
        self,
        request: ecd_20200930_models.ActivateOfficeSiteRequest,
    ) -> ecd_20200930_models.ActivateOfficeSiteResponse:
        """
        @summary Unlocks a convenience office network that is automatically locked due to a long idle period of time.
        
        @description If you do not create any cloud computer in a convenience office network within 15 days, the office network is automatically locked and virtual private cloud (VPC) resources are released. If you want to resume the office network, you can call this operation to unlock the office network.
        
        @param request: ActivateOfficeSiteRequest
        @return: ActivateOfficeSiteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.activate_office_site_with_options_async(request, runtime)

    def add_desktop_oversold_user_group_with_options(
        self,
        request: ecd_20200930_models.AddDesktopOversoldUserGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AddDesktopOversoldUserGroupResponse:
        """
        @summary 添加桌面超卖用户组
        
        @param request: AddDesktopOversoldUserGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddDesktopOversoldUserGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddDesktopOversoldUserGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AddDesktopOversoldUserGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AddDesktopOversoldUserGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def add_desktop_oversold_user_group_with_options_async(
        self,
        request: ecd_20200930_models.AddDesktopOversoldUserGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AddDesktopOversoldUserGroupResponse:
        """
        @summary 添加桌面超卖用户组
        
        @param request: AddDesktopOversoldUserGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddDesktopOversoldUserGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddDesktopOversoldUserGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AddDesktopOversoldUserGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AddDesktopOversoldUserGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def add_desktop_oversold_user_group(
        self,
        request: ecd_20200930_models.AddDesktopOversoldUserGroupRequest,
    ) -> ecd_20200930_models.AddDesktopOversoldUserGroupResponse:
        """
        @summary 添加桌面超卖用户组
        
        @param request: AddDesktopOversoldUserGroupRequest
        @return: AddDesktopOversoldUserGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_desktop_oversold_user_group_with_options(request, runtime)

    async def add_desktop_oversold_user_group_async(
        self,
        request: ecd_20200930_models.AddDesktopOversoldUserGroupRequest,
    ) -> ecd_20200930_models.AddDesktopOversoldUserGroupResponse:
        """
        @summary 添加桌面超卖用户组
        
        @param request: AddDesktopOversoldUserGroupRequest
        @return: AddDesktopOversoldUserGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_desktop_oversold_user_group_with_options_async(request, runtime)

    def add_devices_with_options(
        self,
        request: ecd_20200930_models.AddDevicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AddDevicesResponse:
        """
        @summary Adds trusted devices.
        
        @description Each device can be registered in only one Alibaba Cloud account. If you register a device that has been registered in another Alibaba Cloud account, an error is reported.
        
        @param request: AddDevicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddDevicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.device_ids):
            query['DeviceIds'] = request.device_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddDevices',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AddDevicesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AddDevicesResponse(),
                self.execute(params, req, runtime)
            )

    async def add_devices_with_options_async(
        self,
        request: ecd_20200930_models.AddDevicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AddDevicesResponse:
        """
        @summary Adds trusted devices.
        
        @description Each device can be registered in only one Alibaba Cloud account. If you register a device that has been registered in another Alibaba Cloud account, an error is reported.
        
        @param request: AddDevicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddDevicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.device_ids):
            query['DeviceIds'] = request.device_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddDevices',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AddDevicesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AddDevicesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def add_devices(
        self,
        request: ecd_20200930_models.AddDevicesRequest,
    ) -> ecd_20200930_models.AddDevicesResponse:
        """
        @summary Adds trusted devices.
        
        @description Each device can be registered in only one Alibaba Cloud account. If you register a device that has been registered in another Alibaba Cloud account, an error is reported.
        
        @param request: AddDevicesRequest
        @return: AddDevicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_devices_with_options(request, runtime)

    async def add_devices_async(
        self,
        request: ecd_20200930_models.AddDevicesRequest,
    ) -> ecd_20200930_models.AddDevicesResponse:
        """
        @summary Adds trusted devices.
        
        @description Each device can be registered in only one Alibaba Cloud account. If you register a device that has been registered in another Alibaba Cloud account, an error is reported.
        
        @param request: AddDevicesRequest
        @return: AddDevicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_devices_with_options_async(request, runtime)

    def add_file_permission_with_options(
        self,
        tmp_req: ecd_20200930_models.AddFilePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AddFilePermissionResponse:
        """
        @summary Shares a folder of a cloud disk with other users.
        
        @description You can call this operation to share a specific folder with other users. You can also configure the folder permissions.
        
        @param tmp_req: AddFilePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddFilePermissionResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ecd_20200930_models.AddFilePermissionShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.member_list):
            request.member_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.member_list, 'MemberList', 'json')
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.member_list_shrink):
            query['MemberList'] = request.member_list_shrink
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddFilePermission',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AddFilePermissionResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AddFilePermissionResponse(),
                self.execute(params, req, runtime)
            )

    async def add_file_permission_with_options_async(
        self,
        tmp_req: ecd_20200930_models.AddFilePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AddFilePermissionResponse:
        """
        @summary Shares a folder of a cloud disk with other users.
        
        @description You can call this operation to share a specific folder with other users. You can also configure the folder permissions.
        
        @param tmp_req: AddFilePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddFilePermissionResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ecd_20200930_models.AddFilePermissionShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.member_list):
            request.member_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.member_list, 'MemberList', 'json')
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.member_list_shrink):
            query['MemberList'] = request.member_list_shrink
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddFilePermission',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AddFilePermissionResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AddFilePermissionResponse(),
                await self.execute_async(params, req, runtime)
            )

    def add_file_permission(
        self,
        request: ecd_20200930_models.AddFilePermissionRequest,
    ) -> ecd_20200930_models.AddFilePermissionResponse:
        """
        @summary Shares a folder of a cloud disk with other users.
        
        @description You can call this operation to share a specific folder with other users. You can also configure the folder permissions.
        
        @param request: AddFilePermissionRequest
        @return: AddFilePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_file_permission_with_options(request, runtime)

    async def add_file_permission_async(
        self,
        request: ecd_20200930_models.AddFilePermissionRequest,
    ) -> ecd_20200930_models.AddFilePermissionResponse:
        """
        @summary Shares a folder of a cloud disk with other users.
        
        @description You can call this operation to share a specific folder with other users. You can also configure the folder permissions.
        
        @param request: AddFilePermissionRequest
        @return: AddFilePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_file_permission_with_options_async(request, runtime)

    def add_user_to_desktop_group_with_options(
        self,
        request: ecd_20200930_models.AddUserToDesktopGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AddUserToDesktopGroupResponse:
        """
        @summary Adds authorized end users of a desktop group.
        
        @param request: AddUserToDesktopGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddUserToDesktopGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_group_ids):
            query['DesktopGroupIds'] = request.desktop_group_ids
        if not UtilClient.is_unset(request.end_user_ids):
            query['EndUserIds'] = request.end_user_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddUserToDesktopGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AddUserToDesktopGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AddUserToDesktopGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def add_user_to_desktop_group_with_options_async(
        self,
        request: ecd_20200930_models.AddUserToDesktopGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AddUserToDesktopGroupResponse:
        """
        @summary Adds authorized end users of a desktop group.
        
        @param request: AddUserToDesktopGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddUserToDesktopGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_group_ids):
            query['DesktopGroupIds'] = request.desktop_group_ids
        if not UtilClient.is_unset(request.end_user_ids):
            query['EndUserIds'] = request.end_user_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddUserToDesktopGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AddUserToDesktopGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AddUserToDesktopGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def add_user_to_desktop_group(
        self,
        request: ecd_20200930_models.AddUserToDesktopGroupRequest,
    ) -> ecd_20200930_models.AddUserToDesktopGroupResponse:
        """
        @summary Adds authorized end users of a desktop group.
        
        @param request: AddUserToDesktopGroupRequest
        @return: AddUserToDesktopGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_user_to_desktop_group_with_options(request, runtime)

    async def add_user_to_desktop_group_async(
        self,
        request: ecd_20200930_models.AddUserToDesktopGroupRequest,
    ) -> ecd_20200930_models.AddUserToDesktopGroupResponse:
        """
        @summary Adds authorized end users of a desktop group.
        
        @param request: AddUserToDesktopGroupRequest
        @return: AddUserToDesktopGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_user_to_desktop_group_with_options_async(request, runtime)

    def add_user_to_desktop_oversold_user_group_with_options(
        self,
        request: ecd_20200930_models.AddUserToDesktopOversoldUserGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AddUserToDesktopOversoldUserGroupResponse:
        """
        @summary 添加用户到超卖用户组
        
        @param request: AddUserToDesktopOversoldUserGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddUserToDesktopOversoldUserGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.add_user_amount):
            query['AddUserAmount'] = request.add_user_amount
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.user_group_id):
            query['UserGroupId'] = request.user_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddUserToDesktopOversoldUserGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AddUserToDesktopOversoldUserGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AddUserToDesktopOversoldUserGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def add_user_to_desktop_oversold_user_group_with_options_async(
        self,
        request: ecd_20200930_models.AddUserToDesktopOversoldUserGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AddUserToDesktopOversoldUserGroupResponse:
        """
        @summary 添加用户到超卖用户组
        
        @param request: AddUserToDesktopOversoldUserGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddUserToDesktopOversoldUserGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.add_user_amount):
            query['AddUserAmount'] = request.add_user_amount
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.user_group_id):
            query['UserGroupId'] = request.user_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddUserToDesktopOversoldUserGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AddUserToDesktopOversoldUserGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AddUserToDesktopOversoldUserGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def add_user_to_desktop_oversold_user_group(
        self,
        request: ecd_20200930_models.AddUserToDesktopOversoldUserGroupRequest,
    ) -> ecd_20200930_models.AddUserToDesktopOversoldUserGroupResponse:
        """
        @summary 添加用户到超卖用户组
        
        @param request: AddUserToDesktopOversoldUserGroupRequest
        @return: AddUserToDesktopOversoldUserGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_user_to_desktop_oversold_user_group_with_options(request, runtime)

    async def add_user_to_desktop_oversold_user_group_async(
        self,
        request: ecd_20200930_models.AddUserToDesktopOversoldUserGroupRequest,
    ) -> ecd_20200930_models.AddUserToDesktopOversoldUserGroupResponse:
        """
        @summary 添加用户到超卖用户组
        
        @param request: AddUserToDesktopOversoldUserGroupRequest
        @return: AddUserToDesktopOversoldUserGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_user_to_desktop_oversold_user_group_with_options_async(request, runtime)

    def apply_auto_snapshot_policy_with_options(
        self,
        request: ecd_20200930_models.ApplyAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ApplyAutoSnapshotPolicyResponse:
        """
        @summary Apply an automatic snapshot policy to cloud computers. After the automatic snapshot policy is applied to the cloud computers, Elastic Desktop Service automatically creates snapshots for the cloud computers based on the time specified in the automatic snapshot policy.
        
        @description You can also associate an automatic snapshot policy with a cloud desktop in the Elastic Desktop Service (EDS) console. To do so, perform the following steps: 1. Log on to the EDS console. 2. Choose Desktops and Groups > Desktops in the left-side navigation pane. 3. Find the cloud desktop that you want to manage on the Cloud Desktops page and choose More > Change Automatic Snapshot Policy in the Actions column. 4. Configure a policy for the cloud desktop as prompted in the Change Automatic Snapshot Policy panel.
        After you associate an automatic snapshot policy with the cloud desktop, the system creates snapshots for the cloud desktop based on the policy.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ApplyAutoSnapshotPolicyResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ApplyAutoSnapshotPolicyResponse(),
                self.execute(params, req, runtime)
            )

    async def apply_auto_snapshot_policy_with_options_async(
        self,
        request: ecd_20200930_models.ApplyAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ApplyAutoSnapshotPolicyResponse:
        """
        @summary Apply an automatic snapshot policy to cloud computers. After the automatic snapshot policy is applied to the cloud computers, Elastic Desktop Service automatically creates snapshots for the cloud computers based on the time specified in the automatic snapshot policy.
        
        @description You can also associate an automatic snapshot policy with a cloud desktop in the Elastic Desktop Service (EDS) console. To do so, perform the following steps: 1. Log on to the EDS console. 2. Choose Desktops and Groups > Desktops in the left-side navigation pane. 3. Find the cloud desktop that you want to manage on the Cloud Desktops page and choose More > Change Automatic Snapshot Policy in the Actions column. 4. Configure a policy for the cloud desktop as prompted in the Change Automatic Snapshot Policy panel.
        After you associate an automatic snapshot policy with the cloud desktop, the system creates snapshots for the cloud desktop based on the policy.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ApplyAutoSnapshotPolicyResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ApplyAutoSnapshotPolicyResponse(),
                await self.execute_async(params, req, runtime)
            )

    def apply_auto_snapshot_policy(
        self,
        request: ecd_20200930_models.ApplyAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.ApplyAutoSnapshotPolicyResponse:
        """
        @summary Apply an automatic snapshot policy to cloud computers. After the automatic snapshot policy is applied to the cloud computers, Elastic Desktop Service automatically creates snapshots for the cloud computers based on the time specified in the automatic snapshot policy.
        
        @description You can also associate an automatic snapshot policy with a cloud desktop in the Elastic Desktop Service (EDS) console. To do so, perform the following steps: 1. Log on to the EDS console. 2. Choose Desktops and Groups > Desktops in the left-side navigation pane. 3. Find the cloud desktop that you want to manage on the Cloud Desktops page and choose More > Change Automatic Snapshot Policy in the Actions column. 4. Configure a policy for the cloud desktop as prompted in the Change Automatic Snapshot Policy panel.
        After you associate an automatic snapshot policy with the cloud desktop, the system creates snapshots for the cloud desktop based on the policy.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @return: ApplyAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.apply_auto_snapshot_policy_with_options(request, runtime)

    async def apply_auto_snapshot_policy_async(
        self,
        request: ecd_20200930_models.ApplyAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.ApplyAutoSnapshotPolicyResponse:
        """
        @summary Apply an automatic snapshot policy to cloud computers. After the automatic snapshot policy is applied to the cloud computers, Elastic Desktop Service automatically creates snapshots for the cloud computers based on the time specified in the automatic snapshot policy.
        
        @description You can also associate an automatic snapshot policy with a cloud desktop in the Elastic Desktop Service (EDS) console. To do so, perform the following steps: 1. Log on to the EDS console. 2. Choose Desktops and Groups > Desktops in the left-side navigation pane. 3. Find the cloud desktop that you want to manage on the Cloud Desktops page and choose More > Change Automatic Snapshot Policy in the Actions column. 4. Configure a policy for the cloud desktop as prompted in the Change Automatic Snapshot Policy panel.
        After you associate an automatic snapshot policy with the cloud desktop, the system creates snapshots for the cloud desktop based on the policy.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @return: ApplyAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.apply_auto_snapshot_policy_with_options_async(request, runtime)

    def apply_coordinate_privilege_with_options(
        self,
        request: ecd_20200930_models.ApplyCoordinatePrivilegeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ApplyCoordinatePrivilegeResponse:
        """
        @summary Applies for the coordinate permissions.
        
        @param request: ApplyCoordinatePrivilegeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyCoordinatePrivilegeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.co_id):
            query['CoId'] = request.co_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyCoordinatePrivilege',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ApplyCoordinatePrivilegeResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ApplyCoordinatePrivilegeResponse(),
                self.execute(params, req, runtime)
            )

    async def apply_coordinate_privilege_with_options_async(
        self,
        request: ecd_20200930_models.ApplyCoordinatePrivilegeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ApplyCoordinatePrivilegeResponse:
        """
        @summary Applies for the coordinate permissions.
        
        @param request: ApplyCoordinatePrivilegeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyCoordinatePrivilegeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.co_id):
            query['CoId'] = request.co_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyCoordinatePrivilege',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ApplyCoordinatePrivilegeResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ApplyCoordinatePrivilegeResponse(),
                await self.execute_async(params, req, runtime)
            )

    def apply_coordinate_privilege(
        self,
        request: ecd_20200930_models.ApplyCoordinatePrivilegeRequest,
    ) -> ecd_20200930_models.ApplyCoordinatePrivilegeResponse:
        """
        @summary Applies for the coordinate permissions.
        
        @param request: ApplyCoordinatePrivilegeRequest
        @return: ApplyCoordinatePrivilegeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.apply_coordinate_privilege_with_options(request, runtime)

    async def apply_coordinate_privilege_async(
        self,
        request: ecd_20200930_models.ApplyCoordinatePrivilegeRequest,
    ) -> ecd_20200930_models.ApplyCoordinatePrivilegeResponse:
        """
        @summary Applies for the coordinate permissions.
        
        @param request: ApplyCoordinatePrivilegeRequest
        @return: ApplyCoordinatePrivilegeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.apply_coordinate_privilege_with_options_async(request, runtime)

    def apply_coordination_for_monitoring_with_options(
        self,
        request: ecd_20200930_models.ApplyCoordinationForMonitoringRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ApplyCoordinationForMonitoringResponse:
        """
        @summary Applies for coordination monitoring. This operation is mainly used in administrator assistance scenarios and education scenarios.
        
        @param request: ApplyCoordinationForMonitoringRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyCoordinationForMonitoringResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.coordinate_policy_type):
            query['CoordinatePolicyType'] = request.coordinate_policy_type
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.initiator_type):
            query['InitiatorType'] = request.initiator_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_candidates):
            query['ResourceCandidates'] = request.resource_candidates
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyCoordinationForMonitoring',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ApplyCoordinationForMonitoringResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ApplyCoordinationForMonitoringResponse(),
                self.execute(params, req, runtime)
            )

    async def apply_coordination_for_monitoring_with_options_async(
        self,
        request: ecd_20200930_models.ApplyCoordinationForMonitoringRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ApplyCoordinationForMonitoringResponse:
        """
        @summary Applies for coordination monitoring. This operation is mainly used in administrator assistance scenarios and education scenarios.
        
        @param request: ApplyCoordinationForMonitoringRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyCoordinationForMonitoringResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.coordinate_policy_type):
            query['CoordinatePolicyType'] = request.coordinate_policy_type
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.initiator_type):
            query['InitiatorType'] = request.initiator_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_candidates):
            query['ResourceCandidates'] = request.resource_candidates
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyCoordinationForMonitoring',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ApplyCoordinationForMonitoringResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ApplyCoordinationForMonitoringResponse(),
                await self.execute_async(params, req, runtime)
            )

    def apply_coordination_for_monitoring(
        self,
        request: ecd_20200930_models.ApplyCoordinationForMonitoringRequest,
    ) -> ecd_20200930_models.ApplyCoordinationForMonitoringResponse:
        """
        @summary Applies for coordination monitoring. This operation is mainly used in administrator assistance scenarios and education scenarios.
        
        @param request: ApplyCoordinationForMonitoringRequest
        @return: ApplyCoordinationForMonitoringResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.apply_coordination_for_monitoring_with_options(request, runtime)

    async def apply_coordination_for_monitoring_async(
        self,
        request: ecd_20200930_models.ApplyCoordinationForMonitoringRequest,
    ) -> ecd_20200930_models.ApplyCoordinationForMonitoringResponse:
        """
        @summary Applies for coordination monitoring. This operation is mainly used in administrator assistance scenarios and education scenarios.
        
        @param request: ApplyCoordinationForMonitoringRequest
        @return: ApplyCoordinationForMonitoringResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.apply_coordination_for_monitoring_with_options_async(request, runtime)

    def approve_fota_update_with_options(
        self,
        request: ecd_20200930_models.ApproveFotaUpdateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ApproveFotaUpdateResponse:
        """
        @summary Allows you to upgrade images.
        
        @description The cloud computers for which you want to allow image updates must be in the Running state.
        
        @param request: ApproveFotaUpdateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApproveFotaUpdateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_version):
            query['AppVersion'] = request.app_version
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApproveFotaUpdate',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ApproveFotaUpdateResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ApproveFotaUpdateResponse(),
                self.execute(params, req, runtime)
            )

    async def approve_fota_update_with_options_async(
        self,
        request: ecd_20200930_models.ApproveFotaUpdateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ApproveFotaUpdateResponse:
        """
        @summary Allows you to upgrade images.
        
        @description The cloud computers for which you want to allow image updates must be in the Running state.
        
        @param request: ApproveFotaUpdateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApproveFotaUpdateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_version):
            query['AppVersion'] = request.app_version
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApproveFotaUpdate',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ApproveFotaUpdateResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ApproveFotaUpdateResponse(),
                await self.execute_async(params, req, runtime)
            )

    def approve_fota_update(
        self,
        request: ecd_20200930_models.ApproveFotaUpdateRequest,
    ) -> ecd_20200930_models.ApproveFotaUpdateResponse:
        """
        @summary Allows you to upgrade images.
        
        @description The cloud computers for which you want to allow image updates must be in the Running state.
        
        @param request: ApproveFotaUpdateRequest
        @return: ApproveFotaUpdateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.approve_fota_update_with_options(request, runtime)

    async def approve_fota_update_async(
        self,
        request: ecd_20200930_models.ApproveFotaUpdateRequest,
    ) -> ecd_20200930_models.ApproveFotaUpdateResponse:
        """
        @summary Allows you to upgrade images.
        
        @description The cloud computers for which you want to allow image updates must be in the Running state.
        
        @param request: ApproveFotaUpdateRequest
        @return: ApproveFotaUpdateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.approve_fota_update_with_options_async(request, runtime)

    def associate_network_package_with_options(
        self,
        request: ecd_20200930_models.AssociateNetworkPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AssociateNetworkPackageResponse:
        """
        @summary Binds a premium bandwidth plan to an office network. A premium bandwidth plan is used together with only one office network.
        
        @param request: AssociateNetworkPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateNetworkPackageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_package_id):
            query['NetworkPackageId'] = request.network_package_id
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateNetworkPackage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AssociateNetworkPackageResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AssociateNetworkPackageResponse(),
                self.execute(params, req, runtime)
            )

    async def associate_network_package_with_options_async(
        self,
        request: ecd_20200930_models.AssociateNetworkPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AssociateNetworkPackageResponse:
        """
        @summary Binds a premium bandwidth plan to an office network. A premium bandwidth plan is used together with only one office network.
        
        @param request: AssociateNetworkPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateNetworkPackageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_package_id):
            query['NetworkPackageId'] = request.network_package_id
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateNetworkPackage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AssociateNetworkPackageResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AssociateNetworkPackageResponse(),
                await self.execute_async(params, req, runtime)
            )

    def associate_network_package(
        self,
        request: ecd_20200930_models.AssociateNetworkPackageRequest,
    ) -> ecd_20200930_models.AssociateNetworkPackageResponse:
        """
        @summary Binds a premium bandwidth plan to an office network. A premium bandwidth plan is used together with only one office network.
        
        @param request: AssociateNetworkPackageRequest
        @return: AssociateNetworkPackageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_network_package_with_options(request, runtime)

    async def associate_network_package_async(
        self,
        request: ecd_20200930_models.AssociateNetworkPackageRequest,
    ) -> ecd_20200930_models.AssociateNetworkPackageResponse:
        """
        @summary Binds a premium bandwidth plan to an office network. A premium bandwidth plan is used together with only one office network.
        
        @param request: AssociateNetworkPackageRequest
        @return: AssociateNetworkPackageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_network_package_with_options_async(request, runtime)

    def attach_cen_with_options(
        self,
        request: ecd_20200930_models.AttachCenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AttachCenResponse:
        """
        @summary Binds an advanced office network to a Cloud Enterprise Network (CEN) instance.
        
        @description Prerequisites
        A CEN instance is created.
        The office network is an advanced office network, and the account system type is convenient account.
        >  The office network is added to the CEN instance when you create the instance. An office network can be added to only one CEN instance.
        
        @param request: AttachCenRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachCenResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.cen_owner_id):
            query['CenOwnerId'] = request.cen_owner_id
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.verify_code):
            query['VerifyCode'] = request.verify_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachCen',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AttachCenResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AttachCenResponse(),
                self.execute(params, req, runtime)
            )

    async def attach_cen_with_options_async(
        self,
        request: ecd_20200930_models.AttachCenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AttachCenResponse:
        """
        @summary Binds an advanced office network to a Cloud Enterprise Network (CEN) instance.
        
        @description Prerequisites
        A CEN instance is created.
        The office network is an advanced office network, and the account system type is convenient account.
        >  The office network is added to the CEN instance when you create the instance. An office network can be added to only one CEN instance.
        
        @param request: AttachCenRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachCenResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.cen_owner_id):
            query['CenOwnerId'] = request.cen_owner_id
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.verify_code):
            query['VerifyCode'] = request.verify_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachCen',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AttachCenResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AttachCenResponse(),
                await self.execute_async(params, req, runtime)
            )

    def attach_cen(
        self,
        request: ecd_20200930_models.AttachCenRequest,
    ) -> ecd_20200930_models.AttachCenResponse:
        """
        @summary Binds an advanced office network to a Cloud Enterprise Network (CEN) instance.
        
        @description Prerequisites
        A CEN instance is created.
        The office network is an advanced office network, and the account system type is convenient account.
        >  The office network is added to the CEN instance when you create the instance. An office network can be added to only one CEN instance.
        
        @param request: AttachCenRequest
        @return: AttachCenResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_cen_with_options(request, runtime)

    async def attach_cen_async(
        self,
        request: ecd_20200930_models.AttachCenRequest,
    ) -> ecd_20200930_models.AttachCenResponse:
        """
        @summary Binds an advanced office network to a Cloud Enterprise Network (CEN) instance.
        
        @description Prerequisites
        A CEN instance is created.
        The office network is an advanced office network, and the account system type is convenient account.
        >  The office network is added to the CEN instance when you create the instance. An office network can be added to only one CEN instance.
        
        @param request: AttachCenRequest
        @return: AttachCenResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_cen_with_options_async(request, runtime)

    def attach_end_user_with_options(
        self,
        request: ecd_20200930_models.AttachEndUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AttachEndUserResponse:
        """
        @summary Binds a hardware client to a user.
        
        @param request: AttachEndUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachEndUserResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_domain):
            query['AdDomain'] = request.ad_domain
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.device_id):
            query['DeviceId'] = request.device_id
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachEndUser',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AttachEndUserResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AttachEndUserResponse(),
                self.execute(params, req, runtime)
            )

    async def attach_end_user_with_options_async(
        self,
        request: ecd_20200930_models.AttachEndUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.AttachEndUserResponse:
        """
        @summary Binds a hardware client to a user.
        
        @param request: AttachEndUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachEndUserResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_domain):
            query['AdDomain'] = request.ad_domain
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.device_id):
            query['DeviceId'] = request.device_id
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachEndUser',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.AttachEndUserResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.AttachEndUserResponse(),
                await self.execute_async(params, req, runtime)
            )

    def attach_end_user(
        self,
        request: ecd_20200930_models.AttachEndUserRequest,
    ) -> ecd_20200930_models.AttachEndUserResponse:
        """
        @summary Binds a hardware client to a user.
        
        @param request: AttachEndUserRequest
        @return: AttachEndUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_end_user_with_options(request, runtime)

    async def attach_end_user_async(
        self,
        request: ecd_20200930_models.AttachEndUserRequest,
    ) -> ecd_20200930_models.AttachEndUserResponse:
        """
        @summary Binds a hardware client to a user.
        
        @param request: AttachEndUserRequest
        @return: AttachEndUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_end_user_with_options_async(request, runtime)

    def bind_config_group_with_options(
        self,
        request: ecd_20200930_models.BindConfigGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.BindConfigGroupResponse:
        """
        @summary Binds a configuration group to resources.
        
        @param request: BindConfigGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BindConfigGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_infos):
            query['ResourceInfos'] = request.resource_infos
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindConfigGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.BindConfigGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.BindConfigGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def bind_config_group_with_options_async(
        self,
        request: ecd_20200930_models.BindConfigGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.BindConfigGroupResponse:
        """
        @summary Binds a configuration group to resources.
        
        @param request: BindConfigGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BindConfigGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_infos):
            query['ResourceInfos'] = request.resource_infos
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindConfigGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.BindConfigGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.BindConfigGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def bind_config_group(
        self,
        request: ecd_20200930_models.BindConfigGroupRequest,
    ) -> ecd_20200930_models.BindConfigGroupResponse:
        """
        @summary Binds a configuration group to resources.
        
        @param request: BindConfigGroupRequest
        @return: BindConfigGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.bind_config_group_with_options(request, runtime)

    async def bind_config_group_async(
        self,
        request: ecd_20200930_models.BindConfigGroupRequest,
    ) -> ecd_20200930_models.BindConfigGroupResponse:
        """
        @summary Binds a configuration group to resources.
        
        @param request: BindConfigGroupRequest
        @return: BindConfigGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.bind_config_group_with_options_async(request, runtime)

    def cancel_auto_snapshot_policy_with_options(
        self,
        request: ecd_20200930_models.CancelAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CancelAutoSnapshotPolicyResponse:
        """
        @summary Cancels an automatic snapshot policy for cloud computers.
        
        @param request: CancelAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CancelAutoSnapshotPolicyResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CancelAutoSnapshotPolicyResponse(),
                self.execute(params, req, runtime)
            )

    async def cancel_auto_snapshot_policy_with_options_async(
        self,
        request: ecd_20200930_models.CancelAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CancelAutoSnapshotPolicyResponse:
        """
        @summary Cancels an automatic snapshot policy for cloud computers.
        
        @param request: CancelAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CancelAutoSnapshotPolicyResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CancelAutoSnapshotPolicyResponse(),
                await self.execute_async(params, req, runtime)
            )

    def cancel_auto_snapshot_policy(
        self,
        request: ecd_20200930_models.CancelAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.CancelAutoSnapshotPolicyResponse:
        """
        @summary Cancels an automatic snapshot policy for cloud computers.
        
        @param request: CancelAutoSnapshotPolicyRequest
        @return: CancelAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_auto_snapshot_policy_with_options(request, runtime)

    async def cancel_auto_snapshot_policy_async(
        self,
        request: ecd_20200930_models.CancelAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.CancelAutoSnapshotPolicyResponse:
        """
        @summary Cancels an automatic snapshot policy for cloud computers.
        
        @param request: CancelAutoSnapshotPolicyRequest
        @return: CancelAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_auto_snapshot_policy_with_options_async(request, runtime)

    def cancel_cds_file_share_link_with_options(
        self,
        request: ecd_20200930_models.CancelCdsFileShareLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CancelCdsFileShareLinkResponse:
        """
        @summary Cancels a file sharing task.
        
        @param request: CancelCdsFileShareLinkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCdsFileShareLinkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.share_id):
            query['ShareId'] = request.share_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCdsFileShareLink',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CancelCdsFileShareLinkResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CancelCdsFileShareLinkResponse(),
                self.execute(params, req, runtime)
            )

    async def cancel_cds_file_share_link_with_options_async(
        self,
        request: ecd_20200930_models.CancelCdsFileShareLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CancelCdsFileShareLinkResponse:
        """
        @summary Cancels a file sharing task.
        
        @param request: CancelCdsFileShareLinkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCdsFileShareLinkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.share_id):
            query['ShareId'] = request.share_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCdsFileShareLink',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CancelCdsFileShareLinkResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CancelCdsFileShareLinkResponse(),
                await self.execute_async(params, req, runtime)
            )

    def cancel_cds_file_share_link(
        self,
        request: ecd_20200930_models.CancelCdsFileShareLinkRequest,
    ) -> ecd_20200930_models.CancelCdsFileShareLinkResponse:
        """
        @summary Cancels a file sharing task.
        
        @param request: CancelCdsFileShareLinkRequest
        @return: CancelCdsFileShareLinkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_cds_file_share_link_with_options(request, runtime)

    async def cancel_cds_file_share_link_async(
        self,
        request: ecd_20200930_models.CancelCdsFileShareLinkRequest,
    ) -> ecd_20200930_models.CancelCdsFileShareLinkResponse:
        """
        @summary Cancels a file sharing task.
        
        @param request: CancelCdsFileShareLinkRequest
        @return: CancelCdsFileShareLinkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_cds_file_share_link_with_options_async(request, runtime)

    def cancel_coordination_for_monitoring_with_options(
        self,
        request: ecd_20200930_models.CancelCoordinationForMonitoringRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CancelCoordinationForMonitoringResponse:
        """
        @summary Cancels monitoring on stream collaboration.
        
        @param request: CancelCoordinationForMonitoringRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCoordinationForMonitoringResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.co_ids):
            query['CoIds'] = request.co_ids
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCoordinationForMonitoring',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CancelCoordinationForMonitoringResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CancelCoordinationForMonitoringResponse(),
                self.execute(params, req, runtime)
            )

    async def cancel_coordination_for_monitoring_with_options_async(
        self,
        request: ecd_20200930_models.CancelCoordinationForMonitoringRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CancelCoordinationForMonitoringResponse:
        """
        @summary Cancels monitoring on stream collaboration.
        
        @param request: CancelCoordinationForMonitoringRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCoordinationForMonitoringResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.co_ids):
            query['CoIds'] = request.co_ids
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCoordinationForMonitoring',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CancelCoordinationForMonitoringResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CancelCoordinationForMonitoringResponse(),
                await self.execute_async(params, req, runtime)
            )

    def cancel_coordination_for_monitoring(
        self,
        request: ecd_20200930_models.CancelCoordinationForMonitoringRequest,
    ) -> ecd_20200930_models.CancelCoordinationForMonitoringResponse:
        """
        @summary Cancels monitoring on stream collaboration.
        
        @param request: CancelCoordinationForMonitoringRequest
        @return: CancelCoordinationForMonitoringResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_coordination_for_monitoring_with_options(request, runtime)

    async def cancel_coordination_for_monitoring_async(
        self,
        request: ecd_20200930_models.CancelCoordinationForMonitoringRequest,
    ) -> ecd_20200930_models.CancelCoordinationForMonitoringResponse:
        """
        @summary Cancels monitoring on stream collaboration.
        
        @param request: CancelCoordinationForMonitoringRequest
        @return: CancelCoordinationForMonitoringResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_coordination_for_monitoring_with_options_async(request, runtime)

    def cancel_copy_image_with_options(
        self,
        request: ecd_20200930_models.CancelCopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CancelCopyImageResponse:
        """
        @summary Cancels the operation of copying an image to another region.
        
        @param request: CancelCopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCopyImage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CancelCopyImageResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CancelCopyImageResponse(),
                self.execute(params, req, runtime)
            )

    async def cancel_copy_image_with_options_async(
        self,
        request: ecd_20200930_models.CancelCopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CancelCopyImageResponse:
        """
        @summary Cancels the operation of copying an image to another region.
        
        @param request: CancelCopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCopyImage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CancelCopyImageResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CancelCopyImageResponse(),
                await self.execute_async(params, req, runtime)
            )

    def cancel_copy_image(
        self,
        request: ecd_20200930_models.CancelCopyImageRequest,
    ) -> ecd_20200930_models.CancelCopyImageResponse:
        """
        @summary Cancels the operation of copying an image to another region.
        
        @param request: CancelCopyImageRequest
        @return: CancelCopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_copy_image_with_options(request, runtime)

    async def cancel_copy_image_async(
        self,
        request: ecd_20200930_models.CancelCopyImageRequest,
    ) -> ecd_20200930_models.CancelCopyImageResponse:
        """
        @summary Cancels the operation of copying an image to another region.
        
        @param request: CancelCopyImageRequest
        @return: CancelCopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_copy_image_with_options_async(request, runtime)

    def clone_policy_group_with_options(
        self,
        request: ecd_20200930_models.ClonePolicyGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ClonePolicyGroupResponse:
        """
        @summary Clones an existing policy to quickly create a policy.
        
        @param request: ClonePolicyGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ClonePolicyGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ClonePolicyGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ClonePolicyGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ClonePolicyGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def clone_policy_group_with_options_async(
        self,
        request: ecd_20200930_models.ClonePolicyGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ClonePolicyGroupResponse:
        """
        @summary Clones an existing policy to quickly create a policy.
        
        @param request: ClonePolicyGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ClonePolicyGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ClonePolicyGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ClonePolicyGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ClonePolicyGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def clone_policy_group(
        self,
        request: ecd_20200930_models.ClonePolicyGroupRequest,
    ) -> ecd_20200930_models.ClonePolicyGroupResponse:
        """
        @summary Clones an existing policy to quickly create a policy.
        
        @param request: ClonePolicyGroupRequest
        @return: ClonePolicyGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.clone_policy_group_with_options(request, runtime)

    async def clone_policy_group_async(
        self,
        request: ecd_20200930_models.ClonePolicyGroupRequest,
    ) -> ecd_20200930_models.ClonePolicyGroupResponse:
        """
        @summary Clones an existing policy to quickly create a policy.
        
        @param request: ClonePolicyGroupRequest
        @return: ClonePolicyGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.clone_policy_group_with_options_async(request, runtime)

    def complete_cds_file_with_options(
        self,
        request: ecd_20200930_models.CompleteCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CompleteCdsFileResponse:
        """
        @summary Completes a file uploading task.
        
        @param request: CompleteCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CompleteCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.upload_id):
            query['UploadId'] = request.upload_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CompleteCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CompleteCdsFileResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CompleteCdsFileResponse(),
                self.execute(params, req, runtime)
            )

    async def complete_cds_file_with_options_async(
        self,
        request: ecd_20200930_models.CompleteCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CompleteCdsFileResponse:
        """
        @summary Completes a file uploading task.
        
        @param request: CompleteCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CompleteCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.upload_id):
            query['UploadId'] = request.upload_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CompleteCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CompleteCdsFileResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CompleteCdsFileResponse(),
                await self.execute_async(params, req, runtime)
            )

    def complete_cds_file(
        self,
        request: ecd_20200930_models.CompleteCdsFileRequest,
    ) -> ecd_20200930_models.CompleteCdsFileResponse:
        """
        @summary Completes a file uploading task.
        
        @param request: CompleteCdsFileRequest
        @return: CompleteCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.complete_cds_file_with_options(request, runtime)

    async def complete_cds_file_async(
        self,
        request: ecd_20200930_models.CompleteCdsFileRequest,
    ) -> ecd_20200930_models.CompleteCdsFileResponse:
        """
        @summary Completes a file uploading task.
        
        @param request: CompleteCdsFileRequest
        @return: CompleteCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.complete_cds_file_with_options_async(request, runtime)

    def config_adconnector_trust_with_options(
        self,
        request: ecd_20200930_models.ConfigADConnectorTrustRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ConfigADConnectorTrustResponse:
        """
        @summary Configures a conditional forwarder and trust relationship for a high-definition experience (HDX)-based office network (formerly workspace). You can call the operation to configure a trust relationship for an enterprise Active Directory (AD) office network.
        
        @param request: ConfigADConnectorTrustRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConfigADConnectorTrustResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.rds_license_domain):
            query['RdsLicenseDomain'] = request.rds_license_domain
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.trust_key):
            query['TrustKey'] = request.trust_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfigADConnectorTrust',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ConfigADConnectorTrustResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ConfigADConnectorTrustResponse(),
                self.execute(params, req, runtime)
            )

    async def config_adconnector_trust_with_options_async(
        self,
        request: ecd_20200930_models.ConfigADConnectorTrustRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ConfigADConnectorTrustResponse:
        """
        @summary Configures a conditional forwarder and trust relationship for a high-definition experience (HDX)-based office network (formerly workspace). You can call the operation to configure a trust relationship for an enterprise Active Directory (AD) office network.
        
        @param request: ConfigADConnectorTrustRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConfigADConnectorTrustResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.rds_license_domain):
            query['RdsLicenseDomain'] = request.rds_license_domain
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.trust_key):
            query['TrustKey'] = request.trust_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfigADConnectorTrust',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ConfigADConnectorTrustResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ConfigADConnectorTrustResponse(),
                await self.execute_async(params, req, runtime)
            )

    def config_adconnector_trust(
        self,
        request: ecd_20200930_models.ConfigADConnectorTrustRequest,
    ) -> ecd_20200930_models.ConfigADConnectorTrustResponse:
        """
        @summary Configures a conditional forwarder and trust relationship for a high-definition experience (HDX)-based office network (formerly workspace). You can call the operation to configure a trust relationship for an enterprise Active Directory (AD) office network.
        
        @param request: ConfigADConnectorTrustRequest
        @return: ConfigADConnectorTrustResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.config_adconnector_trust_with_options(request, runtime)

    async def config_adconnector_trust_async(
        self,
        request: ecd_20200930_models.ConfigADConnectorTrustRequest,
    ) -> ecd_20200930_models.ConfigADConnectorTrustResponse:
        """
        @summary Configures a conditional forwarder and trust relationship for a high-definition experience (HDX)-based office network (formerly workspace). You can call the operation to configure a trust relationship for an enterprise Active Directory (AD) office network.
        
        @param request: ConfigADConnectorTrustRequest
        @return: ConfigADConnectorTrustResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.config_adconnector_trust_with_options_async(request, runtime)

    def config_adconnector_user_with_options(
        self,
        request: ecd_20200930_models.ConfigADConnectorUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ConfigADConnectorUserResponse:
        """
        @param request: ConfigADConnectorUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConfigADConnectorUserResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_password):
            query['DomainPassword'] = request.domain_password
        if not UtilClient.is_unset(request.domain_user_name):
            query['DomainUserName'] = request.domain_user_name
        if not UtilClient.is_unset(request.ouname):
            query['OUName'] = request.ouname
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfigADConnectorUser',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ConfigADConnectorUserResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ConfigADConnectorUserResponse(),
                self.execute(params, req, runtime)
            )

    async def config_adconnector_user_with_options_async(
        self,
        request: ecd_20200930_models.ConfigADConnectorUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ConfigADConnectorUserResponse:
        """
        @param request: ConfigADConnectorUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConfigADConnectorUserResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_password):
            query['DomainPassword'] = request.domain_password
        if not UtilClient.is_unset(request.domain_user_name):
            query['DomainUserName'] = request.domain_user_name
        if not UtilClient.is_unset(request.ouname):
            query['OUName'] = request.ouname
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfigADConnectorUser',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ConfigADConnectorUserResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ConfigADConnectorUserResponse(),
                await self.execute_async(params, req, runtime)
            )

    def config_adconnector_user(
        self,
        request: ecd_20200930_models.ConfigADConnectorUserRequest,
    ) -> ecd_20200930_models.ConfigADConnectorUserResponse:
        """
        @param request: ConfigADConnectorUserRequest
        @return: ConfigADConnectorUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.config_adconnector_user_with_options(request, runtime)

    async def config_adconnector_user_async(
        self,
        request: ecd_20200930_models.ConfigADConnectorUserRequest,
    ) -> ecd_20200930_models.ConfigADConnectorUserResponse:
        """
        @param request: ConfigADConnectorUserRequest
        @return: ConfigADConnectorUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.config_adconnector_user_with_options_async(request, runtime)

    def copy_cds_file_with_options(
        self,
        request: ecd_20200930_models.CopyCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CopyCdsFileResponse:
        """
        @summary Copies a file or a directory.
        
        @param request: CopyCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_rename):
            query['AutoRename'] = request.auto_rename
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.file_receiver_id):
            query['FileReceiverId'] = request.file_receiver_id
        if not UtilClient.is_unset(request.file_receiver_type):
            query['FileReceiverType'] = request.file_receiver_type
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.parent_folder_id):
            query['ParentFolderId'] = request.parent_folder_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CopyCdsFileResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CopyCdsFileResponse(),
                self.execute(params, req, runtime)
            )

    async def copy_cds_file_with_options_async(
        self,
        request: ecd_20200930_models.CopyCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CopyCdsFileResponse:
        """
        @summary Copies a file or a directory.
        
        @param request: CopyCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_rename):
            query['AutoRename'] = request.auto_rename
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.file_receiver_id):
            query['FileReceiverId'] = request.file_receiver_id
        if not UtilClient.is_unset(request.file_receiver_type):
            query['FileReceiverType'] = request.file_receiver_type
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.parent_folder_id):
            query['ParentFolderId'] = request.parent_folder_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CopyCdsFileResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CopyCdsFileResponse(),
                await self.execute_async(params, req, runtime)
            )

    def copy_cds_file(
        self,
        request: ecd_20200930_models.CopyCdsFileRequest,
    ) -> ecd_20200930_models.CopyCdsFileResponse:
        """
        @summary Copies a file or a directory.
        
        @param request: CopyCdsFileRequest
        @return: CopyCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_cds_file_with_options(request, runtime)

    async def copy_cds_file_async(
        self,
        request: ecd_20200930_models.CopyCdsFileRequest,
    ) -> ecd_20200930_models.CopyCdsFileResponse:
        """
        @summary Copies a file or a directory.
        
        @param request: CopyCdsFileRequest
        @return: CopyCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_cds_file_with_options_async(request, runtime)

    def copy_image_with_options(
        self,
        request: ecd_20200930_models.CopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CopyImageResponse:
        """
        @summary Copy an image to another region. If you want to share an image across regions, you can call this operation to copy the image to the destination region and then share the image.
        
        @param request: CopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_description):
            query['DestinationDescription'] = request.destination_description
        if not UtilClient.is_unset(request.destination_image_name):
            query['DestinationImageName'] = request.destination_image_name
        if not UtilClient.is_unset(request.destination_region_id):
            query['DestinationRegionId'] = request.destination_region_id
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyImage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CopyImageResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CopyImageResponse(),
                self.execute(params, req, runtime)
            )

    async def copy_image_with_options_async(
        self,
        request: ecd_20200930_models.CopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CopyImageResponse:
        """
        @summary Copy an image to another region. If you want to share an image across regions, you can call this operation to copy the image to the destination region and then share the image.
        
        @param request: CopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_description):
            query['DestinationDescription'] = request.destination_description
        if not UtilClient.is_unset(request.destination_image_name):
            query['DestinationImageName'] = request.destination_image_name
        if not UtilClient.is_unset(request.destination_region_id):
            query['DestinationRegionId'] = request.destination_region_id
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyImage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CopyImageResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CopyImageResponse(),
                await self.execute_async(params, req, runtime)
            )

    def copy_image(
        self,
        request: ecd_20200930_models.CopyImageRequest,
    ) -> ecd_20200930_models.CopyImageResponse:
        """
        @summary Copy an image to another region. If you want to share an image across regions, you can call this operation to copy the image to the destination region and then share the image.
        
        @param request: CopyImageRequest
        @return: CopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_image_with_options(request, runtime)

    async def copy_image_async(
        self,
        request: ecd_20200930_models.CopyImageRequest,
    ) -> ecd_20200930_models.CopyImageResponse:
        """
        @summary Copy an image to another region. If you want to share an image across regions, you can call this operation to copy the image to the destination region and then share the image.
        
        @param request: CopyImageRequest
        @return: CopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_image_with_options_async(request, runtime)

    def create_adconnector_directory_with_options(
        self,
        request: ecd_20200930_models.CreateADConnectorDirectoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateADConnectorDirectoryResponse:
        """
        @summary Creates a directory of the Active Directory (AD) type.
        
        @description An AD directory is used to connect to an enterprise\\"s existing Active Directory and is suitable for large-scale cloud computer deployment. You are charged directory fees when you connect your AD to cloud computers. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        
        @param request: CreateADConnectorDirectoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateADConnectorDirectoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_access_type):
            query['DesktopAccessType'] = request.desktop_access_type
        if not UtilClient.is_unset(request.directory_name):
            query['DirectoryName'] = request.directory_name
        if not UtilClient.is_unset(request.dns_address):
            query['DnsAddress'] = request.dns_address
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_password):
            query['DomainPassword'] = request.domain_password
        if not UtilClient.is_unset(request.domain_user_name):
            query['DomainUserName'] = request.domain_user_name
        if not UtilClient.is_unset(request.enable_admin_access):
            query['EnableAdminAccess'] = request.enable_admin_access
        if not UtilClient.is_unset(request.mfa_enabled):
            query['MfaEnabled'] = request.mfa_enabled
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.specification):
            query['Specification'] = request.specification
        if not UtilClient.is_unset(request.sub_domain_dns_address):
            query['SubDomainDnsAddress'] = request.sub_domain_dns_address
        if not UtilClient.is_unset(request.sub_domain_name):
            query['SubDomainName'] = request.sub_domain_name
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateADConnectorDirectory',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateADConnectorDirectoryResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateADConnectorDirectoryResponse(),
                self.execute(params, req, runtime)
            )

    async def create_adconnector_directory_with_options_async(
        self,
        request: ecd_20200930_models.CreateADConnectorDirectoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateADConnectorDirectoryResponse:
        """
        @summary Creates a directory of the Active Directory (AD) type.
        
        @description An AD directory is used to connect to an enterprise\\"s existing Active Directory and is suitable for large-scale cloud computer deployment. You are charged directory fees when you connect your AD to cloud computers. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        
        @param request: CreateADConnectorDirectoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateADConnectorDirectoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_access_type):
            query['DesktopAccessType'] = request.desktop_access_type
        if not UtilClient.is_unset(request.directory_name):
            query['DirectoryName'] = request.directory_name
        if not UtilClient.is_unset(request.dns_address):
            query['DnsAddress'] = request.dns_address
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_password):
            query['DomainPassword'] = request.domain_password
        if not UtilClient.is_unset(request.domain_user_name):
            query['DomainUserName'] = request.domain_user_name
        if not UtilClient.is_unset(request.enable_admin_access):
            query['EnableAdminAccess'] = request.enable_admin_access
        if not UtilClient.is_unset(request.mfa_enabled):
            query['MfaEnabled'] = request.mfa_enabled
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.specification):
            query['Specification'] = request.specification
        if not UtilClient.is_unset(request.sub_domain_dns_address):
            query['SubDomainDnsAddress'] = request.sub_domain_dns_address
        if not UtilClient.is_unset(request.sub_domain_name):
            query['SubDomainName'] = request.sub_domain_name
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateADConnectorDirectory',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateADConnectorDirectoryResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateADConnectorDirectoryResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_adconnector_directory(
        self,
        request: ecd_20200930_models.CreateADConnectorDirectoryRequest,
    ) -> ecd_20200930_models.CreateADConnectorDirectoryResponse:
        """
        @summary Creates a directory of the Active Directory (AD) type.
        
        @description An AD directory is used to connect to an enterprise\\"s existing Active Directory and is suitable for large-scale cloud computer deployment. You are charged directory fees when you connect your AD to cloud computers. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        
        @param request: CreateADConnectorDirectoryRequest
        @return: CreateADConnectorDirectoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_adconnector_directory_with_options(request, runtime)

    async def create_adconnector_directory_async(
        self,
        request: ecd_20200930_models.CreateADConnectorDirectoryRequest,
    ) -> ecd_20200930_models.CreateADConnectorDirectoryResponse:
        """
        @summary Creates a directory of the Active Directory (AD) type.
        
        @description An AD directory is used to connect to an enterprise\\"s existing Active Directory and is suitable for large-scale cloud computer deployment. You are charged directory fees when you connect your AD to cloud computers. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        
        @param request: CreateADConnectorDirectoryRequest
        @return: CreateADConnectorDirectoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_adconnector_directory_with_options_async(request, runtime)

    def create_adconnector_office_site_with_options(
        self,
        request: ecd_20200930_models.CreateADConnectorOfficeSiteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateADConnectorOfficeSiteResponse:
        """
        @summary Creates an enterprise Active Directory (AD) office network (formerly workspace). Elastic Desktop Service supports the following types of accounts: convenience accounts and enterprise AD accounts.
        
        @description When you create an enterprise AD office network, the system automatically creates an AD connector to connect to an enterprise AD. You are charged for the AD connector. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        After you call this operation to create an AD office network, you must perform the following steps to complete AD domain setting:
        1.  Configure a conditional forwarder in a Domain Name System (DNS) server.
        2.  Configure a trust relationship in an AD domain controller and call the [ConfigADConnectorTrust](https://help.aliyun.com/document_detail/311258.html) operation to configure the trust relationship with the AD office network.
        3.  Call the [ListUserAdOrganizationUnits](https://help.aliyun.com/document_detail/311259.html) operation to query a list of organizational units (OUs) of the AD domain, and call the [ConfigADConnectorUser](https://help.aliyun.com/document_detail/311262.html) operation to specify an OU and administrator for the AD office network.
        >  When you create the AD office network, take note of the DomainUserName and DomainPassword parameters. If you specify the parameters, you need to only configure a conditional forwarder. If you do not specify the parameters, you must configure a conditional forwarder, trust relationship, and OU as prompted.
        For more information, see [Create and manage enterprise AD office networks](https://help.aliyun.com/document_detail/214469.html).
        
        @param request: CreateADConnectorOfficeSiteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateADConnectorOfficeSiteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_hostname):
            query['AdHostname'] = request.ad_hostname
        if not UtilClient.is_unset(request.backup_dchostname):
            query['BackupDCHostname'] = request.backup_dchostname
        if not UtilClient.is_unset(request.backup_dns):
            query['BackupDns'] = request.backup_dns
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.cen_owner_id):
            query['CenOwnerId'] = request.cen_owner_id
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.desktop_access_type):
            query['DesktopAccessType'] = request.desktop_access_type
        if not UtilClient.is_unset(request.dns_address):
            query['DnsAddress'] = request.dns_address
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_password):
            query['DomainPassword'] = request.domain_password
        if not UtilClient.is_unset(request.domain_user_name):
            query['DomainUserName'] = request.domain_user_name
        if not UtilClient.is_unset(request.enable_admin_access):
            query['EnableAdminAccess'] = request.enable_admin_access
        if not UtilClient.is_unset(request.enable_internet_access):
            query['EnableInternetAccess'] = request.enable_internet_access
        if not UtilClient.is_unset(request.mfa_enabled):
            query['MfaEnabled'] = request.mfa_enabled
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.specification):
            query['Specification'] = request.specification
        if not UtilClient.is_unset(request.sub_domain_dns_address):
            query['SubDomainDnsAddress'] = request.sub_domain_dns_address
        if not UtilClient.is_unset(request.sub_domain_name):
            query['SubDomainName'] = request.sub_domain_name
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.verify_code):
            query['VerifyCode'] = request.verify_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateADConnectorOfficeSite',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateADConnectorOfficeSiteResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateADConnectorOfficeSiteResponse(),
                self.execute(params, req, runtime)
            )

    async def create_adconnector_office_site_with_options_async(
        self,
        request: ecd_20200930_models.CreateADConnectorOfficeSiteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateADConnectorOfficeSiteResponse:
        """
        @summary Creates an enterprise Active Directory (AD) office network (formerly workspace). Elastic Desktop Service supports the following types of accounts: convenience accounts and enterprise AD accounts.
        
        @description When you create an enterprise AD office network, the system automatically creates an AD connector to connect to an enterprise AD. You are charged for the AD connector. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        After you call this operation to create an AD office network, you must perform the following steps to complete AD domain setting:
        1.  Configure a conditional forwarder in a Domain Name System (DNS) server.
        2.  Configure a trust relationship in an AD domain controller and call the [ConfigADConnectorTrust](https://help.aliyun.com/document_detail/311258.html) operation to configure the trust relationship with the AD office network.
        3.  Call the [ListUserAdOrganizationUnits](https://help.aliyun.com/document_detail/311259.html) operation to query a list of organizational units (OUs) of the AD domain, and call the [ConfigADConnectorUser](https://help.aliyun.com/document_detail/311262.html) operation to specify an OU and administrator for the AD office network.
        >  When you create the AD office network, take note of the DomainUserName and DomainPassword parameters. If you specify the parameters, you need to only configure a conditional forwarder. If you do not specify the parameters, you must configure a conditional forwarder, trust relationship, and OU as prompted.
        For more information, see [Create and manage enterprise AD office networks](https://help.aliyun.com/document_detail/214469.html).
        
        @param request: CreateADConnectorOfficeSiteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateADConnectorOfficeSiteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_hostname):
            query['AdHostname'] = request.ad_hostname
        if not UtilClient.is_unset(request.backup_dchostname):
            query['BackupDCHostname'] = request.backup_dchostname
        if not UtilClient.is_unset(request.backup_dns):
            query['BackupDns'] = request.backup_dns
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.cen_owner_id):
            query['CenOwnerId'] = request.cen_owner_id
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.desktop_access_type):
            query['DesktopAccessType'] = request.desktop_access_type
        if not UtilClient.is_unset(request.dns_address):
            query['DnsAddress'] = request.dns_address
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_password):
            query['DomainPassword'] = request.domain_password
        if not UtilClient.is_unset(request.domain_user_name):
            query['DomainUserName'] = request.domain_user_name
        if not UtilClient.is_unset(request.enable_admin_access):
            query['EnableAdminAccess'] = request.enable_admin_access
        if not UtilClient.is_unset(request.enable_internet_access):
            query['EnableInternetAccess'] = request.enable_internet_access
        if not UtilClient.is_unset(request.mfa_enabled):
            query['MfaEnabled'] = request.mfa_enabled
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.specification):
            query['Specification'] = request.specification
        if not UtilClient.is_unset(request.sub_domain_dns_address):
            query['SubDomainDnsAddress'] = request.sub_domain_dns_address
        if not UtilClient.is_unset(request.sub_domain_name):
            query['SubDomainName'] = request.sub_domain_name
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.verify_code):
            query['VerifyCode'] = request.verify_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateADConnectorOfficeSite',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateADConnectorOfficeSiteResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateADConnectorOfficeSiteResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_adconnector_office_site(
        self,
        request: ecd_20200930_models.CreateADConnectorOfficeSiteRequest,
    ) -> ecd_20200930_models.CreateADConnectorOfficeSiteResponse:
        """
        @summary Creates an enterprise Active Directory (AD) office network (formerly workspace). Elastic Desktop Service supports the following types of accounts: convenience accounts and enterprise AD accounts.
        
        @description When you create an enterprise AD office network, the system automatically creates an AD connector to connect to an enterprise AD. You are charged for the AD connector. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        After you call this operation to create an AD office network, you must perform the following steps to complete AD domain setting:
        1.  Configure a conditional forwarder in a Domain Name System (DNS) server.
        2.  Configure a trust relationship in an AD domain controller and call the [ConfigADConnectorTrust](https://help.aliyun.com/document_detail/311258.html) operation to configure the trust relationship with the AD office network.
        3.  Call the [ListUserAdOrganizationUnits](https://help.aliyun.com/document_detail/311259.html) operation to query a list of organizational units (OUs) of the AD domain, and call the [ConfigADConnectorUser](https://help.aliyun.com/document_detail/311262.html) operation to specify an OU and administrator for the AD office network.
        >  When you create the AD office network, take note of the DomainUserName and DomainPassword parameters. If you specify the parameters, you need to only configure a conditional forwarder. If you do not specify the parameters, you must configure a conditional forwarder, trust relationship, and OU as prompted.
        For more information, see [Create and manage enterprise AD office networks](https://help.aliyun.com/document_detail/214469.html).
        
        @param request: CreateADConnectorOfficeSiteRequest
        @return: CreateADConnectorOfficeSiteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_adconnector_office_site_with_options(request, runtime)

    async def create_adconnector_office_site_async(
        self,
        request: ecd_20200930_models.CreateADConnectorOfficeSiteRequest,
    ) -> ecd_20200930_models.CreateADConnectorOfficeSiteResponse:
        """
        @summary Creates an enterprise Active Directory (AD) office network (formerly workspace). Elastic Desktop Service supports the following types of accounts: convenience accounts and enterprise AD accounts.
        
        @description When you create an enterprise AD office network, the system automatically creates an AD connector to connect to an enterprise AD. You are charged for the AD connector. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        After you call this operation to create an AD office network, you must perform the following steps to complete AD domain setting:
        1.  Configure a conditional forwarder in a Domain Name System (DNS) server.
        2.  Configure a trust relationship in an AD domain controller and call the [ConfigADConnectorTrust](https://help.aliyun.com/document_detail/311258.html) operation to configure the trust relationship with the AD office network.
        3.  Call the [ListUserAdOrganizationUnits](https://help.aliyun.com/document_detail/311259.html) operation to query a list of organizational units (OUs) of the AD domain, and call the [ConfigADConnectorUser](https://help.aliyun.com/document_detail/311262.html) operation to specify an OU and administrator for the AD office network.
        >  When you create the AD office network, take note of the DomainUserName and DomainPassword parameters. If you specify the parameters, you need to only configure a conditional forwarder. If you do not specify the parameters, you must configure a conditional forwarder, trust relationship, and OU as prompted.
        For more information, see [Create and manage enterprise AD office networks](https://help.aliyun.com/document_detail/214469.html).
        
        @param request: CreateADConnectorOfficeSiteRequest
        @return: CreateADConnectorOfficeSiteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_adconnector_office_site_with_options_async(request, runtime)

    def create_and_bind_nas_file_system_with_options(
        self,
        request: ecd_20200930_models.CreateAndBindNasFileSystemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateAndBindNasFileSystemResponse:
        """
        @summary Creates a File Storage NAS (NAS) file system and mount the file system to the workspace in which a desktop group resides.
        
        @param request: CreateAndBindNasFileSystemRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAndBindNasFileSystemResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.encrypt_type):
            query['EncryptType'] = request.encrypt_type
        if not UtilClient.is_unset(request.end_user_ids):
            query['EndUserIds'] = request.end_user_ids
        if not UtilClient.is_unset(request.file_system_name):
            query['FileSystemName'] = request.file_system_name
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAndBindNasFileSystem',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateAndBindNasFileSystemResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateAndBindNasFileSystemResponse(),
                self.execute(params, req, runtime)
            )

    async def create_and_bind_nas_file_system_with_options_async(
        self,
        request: ecd_20200930_models.CreateAndBindNasFileSystemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateAndBindNasFileSystemResponse:
        """
        @summary Creates a File Storage NAS (NAS) file system and mount the file system to the workspace in which a desktop group resides.
        
        @param request: CreateAndBindNasFileSystemRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAndBindNasFileSystemResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.encrypt_type):
            query['EncryptType'] = request.encrypt_type
        if not UtilClient.is_unset(request.end_user_ids):
            query['EndUserIds'] = request.end_user_ids
        if not UtilClient.is_unset(request.file_system_name):
            query['FileSystemName'] = request.file_system_name
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAndBindNasFileSystem',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateAndBindNasFileSystemResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateAndBindNasFileSystemResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_and_bind_nas_file_system(
        self,
        request: ecd_20200930_models.CreateAndBindNasFileSystemRequest,
    ) -> ecd_20200930_models.CreateAndBindNasFileSystemResponse:
        """
        @summary Creates a File Storage NAS (NAS) file system and mount the file system to the workspace in which a desktop group resides.
        
        @param request: CreateAndBindNasFileSystemRequest
        @return: CreateAndBindNasFileSystemResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_and_bind_nas_file_system_with_options(request, runtime)

    async def create_and_bind_nas_file_system_async(
        self,
        request: ecd_20200930_models.CreateAndBindNasFileSystemRequest,
    ) -> ecd_20200930_models.CreateAndBindNasFileSystemResponse:
        """
        @summary Creates a File Storage NAS (NAS) file system and mount the file system to the workspace in which a desktop group resides.
        
        @param request: CreateAndBindNasFileSystemRequest
        @return: CreateAndBindNasFileSystemResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_and_bind_nas_file_system_with_options_async(request, runtime)

    def create_auto_snapshot_policy_with_options(
        self,
        request: ecd_20200930_models.CreateAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateAutoSnapshotPolicyResponse:
        """
        @summary Creates an automatic snapshot policy. WUYING WorkSpace automatically creates snapshots based on the time specified by the cron expression in the automatic snapshot policy.
        
        @description You can call the operation to create an automatic snapshot policy based on a CRON expression. Then, the system automatically creates snapshots of a cloud desktop based on the policy.
        
        @param request: CreateAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cron_expression):
            query['CronExpression'] = request.cron_expression
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateAutoSnapshotPolicyResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateAutoSnapshotPolicyResponse(),
                self.execute(params, req, runtime)
            )

    async def create_auto_snapshot_policy_with_options_async(
        self,
        request: ecd_20200930_models.CreateAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateAutoSnapshotPolicyResponse:
        """
        @summary Creates an automatic snapshot policy. WUYING WorkSpace automatically creates snapshots based on the time specified by the cron expression in the automatic snapshot policy.
        
        @description You can call the operation to create an automatic snapshot policy based on a CRON expression. Then, the system automatically creates snapshots of a cloud desktop based on the policy.
        
        @param request: CreateAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cron_expression):
            query['CronExpression'] = request.cron_expression
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateAutoSnapshotPolicyResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateAutoSnapshotPolicyResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_auto_snapshot_policy(
        self,
        request: ecd_20200930_models.CreateAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.CreateAutoSnapshotPolicyResponse:
        """
        @summary Creates an automatic snapshot policy. WUYING WorkSpace automatically creates snapshots based on the time specified by the cron expression in the automatic snapshot policy.
        
        @description You can call the operation to create an automatic snapshot policy based on a CRON expression. Then, the system automatically creates snapshots of a cloud desktop based on the policy.
        
        @param request: CreateAutoSnapshotPolicyRequest
        @return: CreateAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_auto_snapshot_policy_with_options(request, runtime)

    async def create_auto_snapshot_policy_async(
        self,
        request: ecd_20200930_models.CreateAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.CreateAutoSnapshotPolicyResponse:
        """
        @summary Creates an automatic snapshot policy. WUYING WorkSpace automatically creates snapshots based on the time specified by the cron expression in the automatic snapshot policy.
        
        @description You can call the operation to create an automatic snapshot policy based on a CRON expression. Then, the system automatically creates snapshots of a cloud desktop based on the policy.
        
        @param request: CreateAutoSnapshotPolicyRequest
        @return: CreateAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_auto_snapshot_policy_with_options_async(request, runtime)

    def create_bandwidth_resource_packages_with_options(
        self,
        request: ecd_20200930_models.CreateBandwidthResourcePackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateBandwidthResourcePackagesResponse:
        """
        @summary Creates data transfer plans.
        
        @param request: CreateBandwidthResourcePackagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBandwidthResourcePackagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.package_size):
            query['PackageSize'] = request.package_size
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBandwidthResourcePackages',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateBandwidthResourcePackagesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateBandwidthResourcePackagesResponse(),
                self.execute(params, req, runtime)
            )

    async def create_bandwidth_resource_packages_with_options_async(
        self,
        request: ecd_20200930_models.CreateBandwidthResourcePackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateBandwidthResourcePackagesResponse:
        """
        @summary Creates data transfer plans.
        
        @param request: CreateBandwidthResourcePackagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBandwidthResourcePackagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.package_size):
            query['PackageSize'] = request.package_size
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBandwidthResourcePackages',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateBandwidthResourcePackagesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateBandwidthResourcePackagesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_bandwidth_resource_packages(
        self,
        request: ecd_20200930_models.CreateBandwidthResourcePackagesRequest,
    ) -> ecd_20200930_models.CreateBandwidthResourcePackagesResponse:
        """
        @summary Creates data transfer plans.
        
        @param request: CreateBandwidthResourcePackagesRequest
        @return: CreateBandwidthResourcePackagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_bandwidth_resource_packages_with_options(request, runtime)

    async def create_bandwidth_resource_packages_async(
        self,
        request: ecd_20200930_models.CreateBandwidthResourcePackagesRequest,
    ) -> ecd_20200930_models.CreateBandwidthResourcePackagesResponse:
        """
        @summary Creates data transfer plans.
        
        @param request: CreateBandwidthResourcePackagesRequest
        @return: CreateBandwidthResourcePackagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_bandwidth_resource_packages_with_options_async(request, runtime)

    def create_bundle_with_options(
        self,
        request: ecd_20200930_models.CreateBundleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateBundleResponse:
        """
        @summary Creates a custom cloud computer template.
        
        @description Cloud computer templates include system templates and custom templates. A system template is the default template provided by Alibaba Cloud. You can call this operation to create a custom template.
        
        @param request: CreateBundleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBundleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bundle_name):
            query['BundleName'] = request.bundle_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.desktop_type):
            query['DesktopType'] = request.desktop_type
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.root_disk_performance_level):
            query['RootDiskPerformanceLevel'] = request.root_disk_performance_level
        if not UtilClient.is_unset(request.root_disk_size_gib):
            query['RootDiskSizeGib'] = request.root_disk_size_gib
        if not UtilClient.is_unset(request.user_disk_performance_level):
            query['UserDiskPerformanceLevel'] = request.user_disk_performance_level
        if not UtilClient.is_unset(request.user_disk_size_gib):
            query['UserDiskSizeGib'] = request.user_disk_size_gib
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBundle',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateBundleResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateBundleResponse(),
                self.execute(params, req, runtime)
            )

    async def create_bundle_with_options_async(
        self,
        request: ecd_20200930_models.CreateBundleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateBundleResponse:
        """
        @summary Creates a custom cloud computer template.
        
        @description Cloud computer templates include system templates and custom templates. A system template is the default template provided by Alibaba Cloud. You can call this operation to create a custom template.
        
        @param request: CreateBundleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBundleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bundle_name):
            query['BundleName'] = request.bundle_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.desktop_type):
            query['DesktopType'] = request.desktop_type
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.root_disk_performance_level):
            query['RootDiskPerformanceLevel'] = request.root_disk_performance_level
        if not UtilClient.is_unset(request.root_disk_size_gib):
            query['RootDiskSizeGib'] = request.root_disk_size_gib
        if not UtilClient.is_unset(request.user_disk_performance_level):
            query['UserDiskPerformanceLevel'] = request.user_disk_performance_level
        if not UtilClient.is_unset(request.user_disk_size_gib):
            query['UserDiskSizeGib'] = request.user_disk_size_gib
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBundle',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateBundleResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateBundleResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_bundle(
        self,
        request: ecd_20200930_models.CreateBundleRequest,
    ) -> ecd_20200930_models.CreateBundleResponse:
        """
        @summary Creates a custom cloud computer template.
        
        @description Cloud computer templates include system templates and custom templates. A system template is the default template provided by Alibaba Cloud. You can call this operation to create a custom template.
        
        @param request: CreateBundleRequest
        @return: CreateBundleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_bundle_with_options(request, runtime)

    async def create_bundle_async(
        self,
        request: ecd_20200930_models.CreateBundleRequest,
    ) -> ecd_20200930_models.CreateBundleResponse:
        """
        @summary Creates a custom cloud computer template.
        
        @description Cloud computer templates include system templates and custom templates. A system template is the default template provided by Alibaba Cloud. You can call this operation to create a custom template.
        
        @param request: CreateBundleRequest
        @return: CreateBundleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_bundle_with_options_async(request, runtime)

    def create_cds_file_with_options(
        self,
        request: ecd_20200930_models.CreateCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateCdsFileResponse:
        """
        @summary Uploads a file to a cloud disk.
        
        @description After the RAM permissions are authenticated, you can call the CreateCdsFile operation to obtain the upload URL of a file and upload the file to a cloud disk.
        
        @param request: CreateCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.conflict_policy):
            query['ConflictPolicy'] = request.conflict_policy
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_hash):
            query['FileHash'] = request.file_hash
        if not UtilClient.is_unset(request.file_length):
            query['FileLength'] = request.file_length
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.file_type):
            query['FileType'] = request.file_type
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.parent_file_id):
            query['ParentFileId'] = request.parent_file_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateCdsFileResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateCdsFileResponse(),
                self.execute(params, req, runtime)
            )

    async def create_cds_file_with_options_async(
        self,
        request: ecd_20200930_models.CreateCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateCdsFileResponse:
        """
        @summary Uploads a file to a cloud disk.
        
        @description After the RAM permissions are authenticated, you can call the CreateCdsFile operation to obtain the upload URL of a file and upload the file to a cloud disk.
        
        @param request: CreateCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.conflict_policy):
            query['ConflictPolicy'] = request.conflict_policy
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_hash):
            query['FileHash'] = request.file_hash
        if not UtilClient.is_unset(request.file_length):
            query['FileLength'] = request.file_length
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.file_type):
            query['FileType'] = request.file_type
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.parent_file_id):
            query['ParentFileId'] = request.parent_file_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateCdsFileResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateCdsFileResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_cds_file(
        self,
        request: ecd_20200930_models.CreateCdsFileRequest,
    ) -> ecd_20200930_models.CreateCdsFileResponse:
        """
        @summary Uploads a file to a cloud disk.
        
        @description After the RAM permissions are authenticated, you can call the CreateCdsFile operation to obtain the upload URL of a file and upload the file to a cloud disk.
        
        @param request: CreateCdsFileRequest
        @return: CreateCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_cds_file_with_options(request, runtime)

    async def create_cds_file_async(
        self,
        request: ecd_20200930_models.CreateCdsFileRequest,
    ) -> ecd_20200930_models.CreateCdsFileResponse:
        """
        @summary Uploads a file to a cloud disk.
        
        @description After the RAM permissions are authenticated, you can call the CreateCdsFile operation to obtain the upload URL of a file and upload the file to a cloud disk.
        
        @param request: CreateCdsFileRequest
        @return: CreateCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_cds_file_with_options_async(request, runtime)

    def create_cds_file_share_link_with_options(
        self,
        request: ecd_20200930_models.CreateCdsFileShareLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateCdsFileShareLinkResponse:
        """
        @summary Creates a file sharing task.
        
        @param request: CreateCdsFileShareLinkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCdsFileShareLinkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disable_download):
            query['DisableDownload'] = request.disable_download
        if not UtilClient.is_unset(request.disable_preview):
            query['DisablePreview'] = request.disable_preview
        if not UtilClient.is_unset(request.disable_save):
            query['DisableSave'] = request.disable_save
        if not UtilClient.is_unset(request.download_limit):
            query['DownloadLimit'] = request.download_limit
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.expiration):
            query['Expiration'] = request.expiration
        if not UtilClient.is_unset(request.file_ids):
            query['FileIds'] = request.file_ids
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.preview_limit):
            query['PreviewLimit'] = request.preview_limit
        if not UtilClient.is_unset(request.save_limit):
            query['SaveLimit'] = request.save_limit
        if not UtilClient.is_unset(request.share_name):
            query['ShareName'] = request.share_name
        if not UtilClient.is_unset(request.share_pwd):
            query['SharePwd'] = request.share_pwd
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCdsFileShareLink',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateCdsFileShareLinkResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateCdsFileShareLinkResponse(),
                self.execute(params, req, runtime)
            )

    async def create_cds_file_share_link_with_options_async(
        self,
        request: ecd_20200930_models.CreateCdsFileShareLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateCdsFileShareLinkResponse:
        """
        @summary Creates a file sharing task.
        
        @param request: CreateCdsFileShareLinkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCdsFileShareLinkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disable_download):
            query['DisableDownload'] = request.disable_download
        if not UtilClient.is_unset(request.disable_preview):
            query['DisablePreview'] = request.disable_preview
        if not UtilClient.is_unset(request.disable_save):
            query['DisableSave'] = request.disable_save
        if not UtilClient.is_unset(request.download_limit):
            query['DownloadLimit'] = request.download_limit
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.expiration):
            query['Expiration'] = request.expiration
        if not UtilClient.is_unset(request.file_ids):
            query['FileIds'] = request.file_ids
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.preview_limit):
            query['PreviewLimit'] = request.preview_limit
        if not UtilClient.is_unset(request.save_limit):
            query['SaveLimit'] = request.save_limit
        if not UtilClient.is_unset(request.share_name):
            query['ShareName'] = request.share_name
        if not UtilClient.is_unset(request.share_pwd):
            query['SharePwd'] = request.share_pwd
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCdsFileShareLink',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateCdsFileShareLinkResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateCdsFileShareLinkResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_cds_file_share_link(
        self,
        request: ecd_20200930_models.CreateCdsFileShareLinkRequest,
    ) -> ecd_20200930_models.CreateCdsFileShareLinkResponse:
        """
        @summary Creates a file sharing task.
        
        @param request: CreateCdsFileShareLinkRequest
        @return: CreateCdsFileShareLinkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_cds_file_share_link_with_options(request, runtime)

    async def create_cds_file_share_link_async(
        self,
        request: ecd_20200930_models.CreateCdsFileShareLinkRequest,
    ) -> ecd_20200930_models.CreateCdsFileShareLinkResponse:
        """
        @summary Creates a file sharing task.
        
        @param request: CreateCdsFileShareLinkRequest
        @return: CreateCdsFileShareLinkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_cds_file_share_link_with_options_async(request, runtime)

    def create_cloud_drive_service_with_options(
        self,
        request: ecd_20200930_models.CreateCloudDriveServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateCloudDriveServiceResponse:
        """
        @summary Creates a cloud disk.
        
        @param request: CreateCloudDriveServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCloudDriveServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.biz_type):
            query['BizType'] = request.biz_type
        if not UtilClient.is_unset(request.cds_charge_type):
            query['CdsChargeType'] = request.cds_charge_type
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_size):
            query['MaxSize'] = request.max_size
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_type):
            query['OfficeSiteType'] = request.office_site_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.solution_id):
            query['SolutionId'] = request.solution_id
        if not UtilClient.is_unset(request.user_count):
            query['UserCount'] = request.user_count
        if not UtilClient.is_unset(request.user_max_size):
            query['UserMaxSize'] = request.user_max_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCloudDriveService',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateCloudDriveServiceResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateCloudDriveServiceResponse(),
                self.execute(params, req, runtime)
            )

    async def create_cloud_drive_service_with_options_async(
        self,
        request: ecd_20200930_models.CreateCloudDriveServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateCloudDriveServiceResponse:
        """
        @summary Creates a cloud disk.
        
        @param request: CreateCloudDriveServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCloudDriveServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.biz_type):
            query['BizType'] = request.biz_type
        if not UtilClient.is_unset(request.cds_charge_type):
            query['CdsChargeType'] = request.cds_charge_type
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_size):
            query['MaxSize'] = request.max_size
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_type):
            query['OfficeSiteType'] = request.office_site_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.solution_id):
            query['SolutionId'] = request.solution_id
        if not UtilClient.is_unset(request.user_count):
            query['UserCount'] = request.user_count
        if not UtilClient.is_unset(request.user_max_size):
            query['UserMaxSize'] = request.user_max_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCloudDriveService',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateCloudDriveServiceResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateCloudDriveServiceResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_cloud_drive_service(
        self,
        request: ecd_20200930_models.CreateCloudDriveServiceRequest,
    ) -> ecd_20200930_models.CreateCloudDriveServiceResponse:
        """
        @summary Creates a cloud disk.
        
        @param request: CreateCloudDriveServiceRequest
        @return: CreateCloudDriveServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_cloud_drive_service_with_options(request, runtime)

    async def create_cloud_drive_service_async(
        self,
        request: ecd_20200930_models.CreateCloudDriveServiceRequest,
    ) -> ecd_20200930_models.CreateCloudDriveServiceResponse:
        """
        @summary Creates a cloud disk.
        
        @param request: CreateCloudDriveServiceRequest
        @return: CreateCloudDriveServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_cloud_drive_service_with_options_async(request, runtime)

    def create_cloud_drive_users_with_options(
        self,
        request: ecd_20200930_models.CreateCloudDriveUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateCloudDriveUsersResponse:
        """
        @summary Creates the users of a cloud disk.
        
        @param request: CreateCloudDriveUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCloudDriveUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.user_max_size):
            query['UserMaxSize'] = request.user_max_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCloudDriveUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateCloudDriveUsersResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateCloudDriveUsersResponse(),
                self.execute(params, req, runtime)
            )

    async def create_cloud_drive_users_with_options_async(
        self,
        request: ecd_20200930_models.CreateCloudDriveUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateCloudDriveUsersResponse:
        """
        @summary Creates the users of a cloud disk.
        
        @param request: CreateCloudDriveUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCloudDriveUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.user_max_size):
            query['UserMaxSize'] = request.user_max_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCloudDriveUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateCloudDriveUsersResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateCloudDriveUsersResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_cloud_drive_users(
        self,
        request: ecd_20200930_models.CreateCloudDriveUsersRequest,
    ) -> ecd_20200930_models.CreateCloudDriveUsersResponse:
        """
        @summary Creates the users of a cloud disk.
        
        @param request: CreateCloudDriveUsersRequest
        @return: CreateCloudDriveUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_cloud_drive_users_with_options(request, runtime)

    async def create_cloud_drive_users_async(
        self,
        request: ecd_20200930_models.CreateCloudDriveUsersRequest,
    ) -> ecd_20200930_models.CreateCloudDriveUsersResponse:
        """
        @summary Creates the users of a cloud disk.
        
        @param request: CreateCloudDriveUsersRequest
        @return: CreateCloudDriveUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_cloud_drive_users_with_options_async(request, runtime)

    def create_config_group_with_options(
        self,
        request: ecd_20200930_models.CreateConfigGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateConfigGroupResponse:
        """
        @summary Creates a configuration group. A configuration group stores the setup details for scheduled tasks on cloud computers.
        
        @param request: CreateConfigGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateConfigGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_timers):
            query['ConfigTimers'] = request.config_timers
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.product_type):
            query['ProductType'] = request.product_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateConfigGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateConfigGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateConfigGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def create_config_group_with_options_async(
        self,
        request: ecd_20200930_models.CreateConfigGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateConfigGroupResponse:
        """
        @summary Creates a configuration group. A configuration group stores the setup details for scheduled tasks on cloud computers.
        
        @param request: CreateConfigGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateConfigGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_timers):
            query['ConfigTimers'] = request.config_timers
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.product_type):
            query['ProductType'] = request.product_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateConfigGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateConfigGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateConfigGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_config_group(
        self,
        request: ecd_20200930_models.CreateConfigGroupRequest,
    ) -> ecd_20200930_models.CreateConfigGroupResponse:
        """
        @summary Creates a configuration group. A configuration group stores the setup details for scheduled tasks on cloud computers.
        
        @param request: CreateConfigGroupRequest
        @return: CreateConfigGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_config_group_with_options(request, runtime)

    async def create_config_group_async(
        self,
        request: ecd_20200930_models.CreateConfigGroupRequest,
    ) -> ecd_20200930_models.CreateConfigGroupResponse:
        """
        @summary Creates a configuration group. A configuration group stores the setup details for scheduled tasks on cloud computers.
        
        @param request: CreateConfigGroupRequest
        @return: CreateConfigGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_config_group_with_options_async(request, runtime)

    def create_desktop_group_with_options(
        self,
        request: ecd_20200930_models.CreateDesktopGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateDesktopGroupResponse:
        """
        @summary Creates a shared group.
        
        @description    To learn about the features, application scenarios, usage limits, scaling policies, and other details of shared groups, refer to [Overview](https://help.aliyun.com/document_detail/290959.html).
        Before you call this operation, make sure that the required resources, such as the office network, cloud computer template, and policies, are created.
        
        @param request: CreateDesktopGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDesktopGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.all_classify_users):
            query['AllClassifyUsers'] = request.all_classify_users
        if not UtilClient.is_unset(request.allow_auto_setup):
            query['AllowAutoSetup'] = request.allow_auto_setup
        if not UtilClient.is_unset(request.allow_buffer_count):
            query['AllowBufferCount'] = request.allow_buffer_count
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.bind_amount):
            query['BindAmount'] = request.bind_amount
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.buy_desktops_count):
            query['BuyDesktopsCount'] = request.buy_desktops_count
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.classify):
            query['Classify'] = request.classify
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.comments):
            query['Comments'] = request.comments
        if not UtilClient.is_unset(request.connect_duration):
            query['ConnectDuration'] = request.connect_duration
        if not UtilClient.is_unset(request.data_disk_category):
            query['DataDiskCategory'] = request.data_disk_category
        if not UtilClient.is_unset(request.data_disk_per_level):
            query['DataDiskPerLevel'] = request.data_disk_per_level
        if not UtilClient.is_unset(request.data_disk_size):
            query['DataDiskSize'] = request.data_disk_size
        if not UtilClient.is_unset(request.default_init_desktop_count):
            query['DefaultInitDesktopCount'] = request.default_init_desktop_count
        if not UtilClient.is_unset(request.default_language):
            query['DefaultLanguage'] = request.default_language
        if not UtilClient.is_unset(request.desktop_group_name):
            query['DesktopGroupName'] = request.desktop_group_name
        if not UtilClient.is_unset(request.desktop_type):
            query['DesktopType'] = request.desktop_type
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_ids):
            query['EndUserIds'] = request.end_user_ids
        if not UtilClient.is_unset(request.exclusive_type):
            query['ExclusiveType'] = request.exclusive_type
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.group_amount):
            query['GroupAmount'] = request.group_amount
        if not UtilClient.is_unset(request.group_version):
            query['GroupVersion'] = request.group_version
        if not UtilClient.is_unset(request.hostname):
            query['Hostname'] = request.hostname
        if not UtilClient.is_unset(request.idle_disconnect_duration):
            query['IdleDisconnectDuration'] = request.idle_disconnect_duration
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.keep_duration):
            query['KeepDuration'] = request.keep_duration
        if not UtilClient.is_unset(request.load_policy):
            query['LoadPolicy'] = request.load_policy
        if not UtilClient.is_unset(request.max_desktops_count):
            query['MaxDesktopsCount'] = request.max_desktops_count
        if not UtilClient.is_unset(request.min_desktops_count):
            query['MinDesktopsCount'] = request.min_desktops_count
        if not UtilClient.is_unset(request.multi_resource):
            query['MultiResource'] = request.multi_resource
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.own_type):
            query['OwnType'] = request.own_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.profile_follow_switch):
            query['ProfileFollowSwitch'] = request.profile_follow_switch
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.ratio_threshold):
            query['RatioThreshold'] = request.ratio_threshold
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.reset_type):
            query['ResetType'] = request.reset_type
        if not UtilClient.is_unset(request.scale_strategy_id):
            query['ScaleStrategyId'] = request.scale_strategy_id
        if not UtilClient.is_unset(request.session_type):
            query['SessionType'] = request.session_type
        if not UtilClient.is_unset(request.snapshot_policy_id):
            query['SnapshotPolicyId'] = request.snapshot_policy_id
        if not UtilClient.is_unset(request.stop_duration):
            query['StopDuration'] = request.stop_duration
        if not UtilClient.is_unset(request.system_disk_category):
            query['SystemDiskCategory'] = request.system_disk_category
        if not UtilClient.is_unset(request.system_disk_per_level):
            query['SystemDiskPerLevel'] = request.system_disk_per_level
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.timer_group_id):
            query['TimerGroupId'] = request.timer_group_id
        if not UtilClient.is_unset(request.volume_encryption_enabled):
            query['VolumeEncryptionEnabled'] = request.volume_encryption_enabled
        if not UtilClient.is_unset(request.volume_encryption_key):
            query['VolumeEncryptionKey'] = request.volume_encryption_key
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDesktopGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def create_desktop_group_with_options_async(
        self,
        request: ecd_20200930_models.CreateDesktopGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateDesktopGroupResponse:
        """
        @summary Creates a shared group.
        
        @description    To learn about the features, application scenarios, usage limits, scaling policies, and other details of shared groups, refer to [Overview](https://help.aliyun.com/document_detail/290959.html).
        Before you call this operation, make sure that the required resources, such as the office network, cloud computer template, and policies, are created.
        
        @param request: CreateDesktopGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDesktopGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.all_classify_users):
            query['AllClassifyUsers'] = request.all_classify_users
        if not UtilClient.is_unset(request.allow_auto_setup):
            query['AllowAutoSetup'] = request.allow_auto_setup
        if not UtilClient.is_unset(request.allow_buffer_count):
            query['AllowBufferCount'] = request.allow_buffer_count
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.bind_amount):
            query['BindAmount'] = request.bind_amount
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.buy_desktops_count):
            query['BuyDesktopsCount'] = request.buy_desktops_count
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.classify):
            query['Classify'] = request.classify
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.comments):
            query['Comments'] = request.comments
        if not UtilClient.is_unset(request.connect_duration):
            query['ConnectDuration'] = request.connect_duration
        if not UtilClient.is_unset(request.data_disk_category):
            query['DataDiskCategory'] = request.data_disk_category
        if not UtilClient.is_unset(request.data_disk_per_level):
            query['DataDiskPerLevel'] = request.data_disk_per_level
        if not UtilClient.is_unset(request.data_disk_size):
            query['DataDiskSize'] = request.data_disk_size
        if not UtilClient.is_unset(request.default_init_desktop_count):
            query['DefaultInitDesktopCount'] = request.default_init_desktop_count
        if not UtilClient.is_unset(request.default_language):
            query['DefaultLanguage'] = request.default_language
        if not UtilClient.is_unset(request.desktop_group_name):
            query['DesktopGroupName'] = request.desktop_group_name
        if not UtilClient.is_unset(request.desktop_type):
            query['DesktopType'] = request.desktop_type
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_ids):
            query['EndUserIds'] = request.end_user_ids
        if not UtilClient.is_unset(request.exclusive_type):
            query['ExclusiveType'] = request.exclusive_type
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.group_amount):
            query['GroupAmount'] = request.group_amount
        if not UtilClient.is_unset(request.group_version):
            query['GroupVersion'] = request.group_version
        if not UtilClient.is_unset(request.hostname):
            query['Hostname'] = request.hostname
        if not UtilClient.is_unset(request.idle_disconnect_duration):
            query['IdleDisconnectDuration'] = request.idle_disconnect_duration
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.keep_duration):
            query['KeepDuration'] = request.keep_duration
        if not UtilClient.is_unset(request.load_policy):
            query['LoadPolicy'] = request.load_policy
        if not UtilClient.is_unset(request.max_desktops_count):
            query['MaxDesktopsCount'] = request.max_desktops_count
        if not UtilClient.is_unset(request.min_desktops_count):
            query['MinDesktopsCount'] = request.min_desktops_count
        if not UtilClient.is_unset(request.multi_resource):
            query['MultiResource'] = request.multi_resource
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.own_type):
            query['OwnType'] = request.own_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.profile_follow_switch):
            query['ProfileFollowSwitch'] = request.profile_follow_switch
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.ratio_threshold):
            query['RatioThreshold'] = request.ratio_threshold
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.reset_type):
            query['ResetType'] = request.reset_type
        if not UtilClient.is_unset(request.scale_strategy_id):
            query['ScaleStrategyId'] = request.scale_strategy_id
        if not UtilClient.is_unset(request.session_type):
            query['SessionType'] = request.session_type
        if not UtilClient.is_unset(request.snapshot_policy_id):
            query['SnapshotPolicyId'] = request.snapshot_policy_id
        if not UtilClient.is_unset(request.stop_duration):
            query['StopDuration'] = request.stop_duration
        if not UtilClient.is_unset(request.system_disk_category):
            query['SystemDiskCategory'] = request.system_disk_category
        if not UtilClient.is_unset(request.system_disk_per_level):
            query['SystemDiskPerLevel'] = request.system_disk_per_level
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.timer_group_id):
            query['TimerGroupId'] = request.timer_group_id
        if not UtilClient.is_unset(request.volume_encryption_enabled):
            query['VolumeEncryptionEnabled'] = request.volume_encryption_enabled
        if not UtilClient.is_unset(request.volume_encryption_key):
            query['VolumeEncryptionKey'] = request.volume_encryption_key
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDesktopGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_desktop_group(
        self,
        request: ecd_20200930_models.CreateDesktopGroupRequest,
    ) -> ecd_20200930_models.CreateDesktopGroupResponse:
        """
        @summary Creates a shared group.
        
        @description    To learn about the features, application scenarios, usage limits, scaling policies, and other details of shared groups, refer to [Overview](https://help.aliyun.com/document_detail/290959.html).
        Before you call this operation, make sure that the required resources, such as the office network, cloud computer template, and policies, are created.
        
        @param request: CreateDesktopGroupRequest
        @return: CreateDesktopGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_desktop_group_with_options(request, runtime)

    async def create_desktop_group_async(
        self,
        request: ecd_20200930_models.CreateDesktopGroupRequest,
    ) -> ecd_20200930_models.CreateDesktopGroupResponse:
        """
        @summary Creates a shared group.
        
        @description    To learn about the features, application scenarios, usage limits, scaling policies, and other details of shared groups, refer to [Overview](https://help.aliyun.com/document_detail/290959.html).
        Before you call this operation, make sure that the required resources, such as the office network, cloud computer template, and policies, are created.
        
        @param request: CreateDesktopGroupRequest
        @return: CreateDesktopGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_desktop_group_with_options_async(request, runtime)

    def create_desktop_oversold_group_with_options(
        self,
        request: ecd_20200930_models.CreateDesktopOversoldGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateDesktopOversoldGroupResponse:
        """
        @summary 创建桌面超卖组
        
        @param request: CreateDesktopOversoldGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDesktopOversoldGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.concurrence_count):
            query['ConcurrenceCount'] = request.concurrence_count
        if not UtilClient.is_unset(request.data_disk_size):
            query['DataDiskSize'] = request.data_disk_size
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.desktop_type):
            query['DesktopType'] = request.desktop_type
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.idle_disconnect_duration):
            query['IdleDisconnectDuration'] = request.idle_disconnect_duration
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.keep_duration):
            query['KeepDuration'] = request.keep_duration
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.oversold_user_count):
            query['OversoldUserCount'] = request.oversold_user_count
        if not UtilClient.is_unset(request.oversold_warn):
            query['OversoldWarn'] = request.oversold_warn
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.stop_duration):
            query['StopDuration'] = request.stop_duration
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDesktopOversoldGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopOversoldGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopOversoldGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def create_desktop_oversold_group_with_options_async(
        self,
        request: ecd_20200930_models.CreateDesktopOversoldGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateDesktopOversoldGroupResponse:
        """
        @summary 创建桌面超卖组
        
        @param request: CreateDesktopOversoldGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDesktopOversoldGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.concurrence_count):
            query['ConcurrenceCount'] = request.concurrence_count
        if not UtilClient.is_unset(request.data_disk_size):
            query['DataDiskSize'] = request.data_disk_size
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.desktop_type):
            query['DesktopType'] = request.desktop_type
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.idle_disconnect_duration):
            query['IdleDisconnectDuration'] = request.idle_disconnect_duration
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.keep_duration):
            query['KeepDuration'] = request.keep_duration
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.oversold_user_count):
            query['OversoldUserCount'] = request.oversold_user_count
        if not UtilClient.is_unset(request.oversold_warn):
            query['OversoldWarn'] = request.oversold_warn
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.stop_duration):
            query['StopDuration'] = request.stop_duration
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDesktopOversoldGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopOversoldGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopOversoldGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_desktop_oversold_group(
        self,
        request: ecd_20200930_models.CreateDesktopOversoldGroupRequest,
    ) -> ecd_20200930_models.CreateDesktopOversoldGroupResponse:
        """
        @summary 创建桌面超卖组
        
        @param request: CreateDesktopOversoldGroupRequest
        @return: CreateDesktopOversoldGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_desktop_oversold_group_with_options(request, runtime)

    async def create_desktop_oversold_group_async(
        self,
        request: ecd_20200930_models.CreateDesktopOversoldGroupRequest,
    ) -> ecd_20200930_models.CreateDesktopOversoldGroupResponse:
        """
        @summary 创建桌面超卖组
        
        @param request: CreateDesktopOversoldGroupRequest
        @return: CreateDesktopOversoldGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_desktop_oversold_group_with_options_async(request, runtime)

    def create_desktops_with_options(
        self,
        tmp_req: ecd_20200930_models.CreateDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateDesktopsResponse:
        """
        @summary Creates cloud computers. If you specify end users when you create cloud computers, the cloud computers are assigned to the end users after the cloud computers are created.
        
        @description Before you create cloud computers, complete the following preparations:
        An office network (formerly called workspace) and users are created. For more information, see:
        Convenience office network: [CreateSimpleOfficeSite](https://help.aliyun.com/document_detail/215416.html) and [CreateUsers](https://help.aliyun.com/document_detail/437832.html).
        Active Directory (AD) office network: [CreateADConnectorOfficeSite](https://help.aliyun.com/document_detail/215417.html) and [Create an AD user](https://help.aliyun.com/document_detail/188619.html).
        Make sure a cloud computer template exists. If no cloud computer template exists, call the [CreateBundle](https://help.aliyun.com/document_detail/188883.html) operation to create a template.
        Make sure a policy exists. If no policy exists, call the [CreatePolicyGroup](https://help.aliyun.com/document_detail/188889.html) operation to create a policy.
        If you want the cloud computers to automatically execute a custom command script, you can use the `UserCommands` field to configure a custom command.
        
        @param tmp_req: CreateDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDesktopsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ecd_20200930_models.CreateDesktopsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.desktop_attachment):
            request.desktop_attachment_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.desktop_attachment, 'DesktopAttachment', 'json')
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.bundle_models):
            query['BundleModels'] = request.bundle_models
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.desktop_attachment_shrink):
            query['DesktopAttachment'] = request.desktop_attachment_shrink
        if not UtilClient.is_unset(request.desktop_member_ip):
            query['DesktopMemberIp'] = request.desktop_member_ip
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.desktop_name_suffix):
            query['DesktopNameSuffix'] = request.desktop_name_suffix
        if not UtilClient.is_unset(request.desktop_timers):
            query['DesktopTimers'] = request.desktop_timers
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.hostname):
            query['Hostname'] = request.hostname
        if not UtilClient.is_unset(request.month_desktop_setting):
            query['MonthDesktopSetting'] = request.month_desktop_setting
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.saving_plan_id):
            query['SavingPlanId'] = request.saving_plan_id
        if not UtilClient.is_unset(request.snapshot_policy_id):
            query['SnapshotPolicyId'] = request.snapshot_policy_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.timer_group_id):
            query['TimerGroupId'] = request.timer_group_id
        if not UtilClient.is_unset(request.user_assign_mode):
            query['UserAssignMode'] = request.user_assign_mode
        if not UtilClient.is_unset(request.user_commands):
            query['UserCommands'] = request.user_commands
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        if not UtilClient.is_unset(request.volume_encryption_enabled):
            query['VolumeEncryptionEnabled'] = request.volume_encryption_enabled
        if not UtilClient.is_unset(request.volume_encryption_key):
            query['VolumeEncryptionKey'] = request.volume_encryption_key
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopsResponse(),
                self.execute(params, req, runtime)
            )

    async def create_desktops_with_options_async(
        self,
        tmp_req: ecd_20200930_models.CreateDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateDesktopsResponse:
        """
        @summary Creates cloud computers. If you specify end users when you create cloud computers, the cloud computers are assigned to the end users after the cloud computers are created.
        
        @description Before you create cloud computers, complete the following preparations:
        An office network (formerly called workspace) and users are created. For more information, see:
        Convenience office network: [CreateSimpleOfficeSite](https://help.aliyun.com/document_detail/215416.html) and [CreateUsers](https://help.aliyun.com/document_detail/437832.html).
        Active Directory (AD) office network: [CreateADConnectorOfficeSite](https://help.aliyun.com/document_detail/215417.html) and [Create an AD user](https://help.aliyun.com/document_detail/188619.html).
        Make sure a cloud computer template exists. If no cloud computer template exists, call the [CreateBundle](https://help.aliyun.com/document_detail/188883.html) operation to create a template.
        Make sure a policy exists. If no policy exists, call the [CreatePolicyGroup](https://help.aliyun.com/document_detail/188889.html) operation to create a policy.
        If you want the cloud computers to automatically execute a custom command script, you can use the `UserCommands` field to configure a custom command.
        
        @param tmp_req: CreateDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDesktopsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ecd_20200930_models.CreateDesktopsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.desktop_attachment):
            request.desktop_attachment_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.desktop_attachment, 'DesktopAttachment', 'json')
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.bundle_models):
            query['BundleModels'] = request.bundle_models
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.desktop_attachment_shrink):
            query['DesktopAttachment'] = request.desktop_attachment_shrink
        if not UtilClient.is_unset(request.desktop_member_ip):
            query['DesktopMemberIp'] = request.desktop_member_ip
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.desktop_name_suffix):
            query['DesktopNameSuffix'] = request.desktop_name_suffix
        if not UtilClient.is_unset(request.desktop_timers):
            query['DesktopTimers'] = request.desktop_timers
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.hostname):
            query['Hostname'] = request.hostname
        if not UtilClient.is_unset(request.month_desktop_setting):
            query['MonthDesktopSetting'] = request.month_desktop_setting
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.saving_plan_id):
            query['SavingPlanId'] = request.saving_plan_id
        if not UtilClient.is_unset(request.snapshot_policy_id):
            query['SnapshotPolicyId'] = request.snapshot_policy_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.timer_group_id):
            query['TimerGroupId'] = request.timer_group_id
        if not UtilClient.is_unset(request.user_assign_mode):
            query['UserAssignMode'] = request.user_assign_mode
        if not UtilClient.is_unset(request.user_commands):
            query['UserCommands'] = request.user_commands
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        if not UtilClient.is_unset(request.volume_encryption_enabled):
            query['VolumeEncryptionEnabled'] = request.volume_encryption_enabled
        if not UtilClient.is_unset(request.volume_encryption_key):
            query['VolumeEncryptionKey'] = request.volume_encryption_key
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateDesktopsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_desktops(
        self,
        request: ecd_20200930_models.CreateDesktopsRequest,
    ) -> ecd_20200930_models.CreateDesktopsResponse:
        """
        @summary Creates cloud computers. If you specify end users when you create cloud computers, the cloud computers are assigned to the end users after the cloud computers are created.
        
        @description Before you create cloud computers, complete the following preparations:
        An office network (formerly called workspace) and users are created. For more information, see:
        Convenience office network: [CreateSimpleOfficeSite](https://help.aliyun.com/document_detail/215416.html) and [CreateUsers](https://help.aliyun.com/document_detail/437832.html).
        Active Directory (AD) office network: [CreateADConnectorOfficeSite](https://help.aliyun.com/document_detail/215417.html) and [Create an AD user](https://help.aliyun.com/document_detail/188619.html).
        Make sure a cloud computer template exists. If no cloud computer template exists, call the [CreateBundle](https://help.aliyun.com/document_detail/188883.html) operation to create a template.
        Make sure a policy exists. If no policy exists, call the [CreatePolicyGroup](https://help.aliyun.com/document_detail/188889.html) operation to create a policy.
        If you want the cloud computers to automatically execute a custom command script, you can use the `UserCommands` field to configure a custom command.
        
        @param request: CreateDesktopsRequest
        @return: CreateDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_desktops_with_options(request, runtime)

    async def create_desktops_async(
        self,
        request: ecd_20200930_models.CreateDesktopsRequest,
    ) -> ecd_20200930_models.CreateDesktopsResponse:
        """
        @summary Creates cloud computers. If you specify end users when you create cloud computers, the cloud computers are assigned to the end users after the cloud computers are created.
        
        @description Before you create cloud computers, complete the following preparations:
        An office network (formerly called workspace) and users are created. For more information, see:
        Convenience office network: [CreateSimpleOfficeSite](https://help.aliyun.com/document_detail/215416.html) and [CreateUsers](https://help.aliyun.com/document_detail/437832.html).
        Active Directory (AD) office network: [CreateADConnectorOfficeSite](https://help.aliyun.com/document_detail/215417.html) and [Create an AD user](https://help.aliyun.com/document_detail/188619.html).
        Make sure a cloud computer template exists. If no cloud computer template exists, call the [CreateBundle](https://help.aliyun.com/document_detail/188883.html) operation to create a template.
        Make sure a policy exists. If no policy exists, call the [CreatePolicyGroup](https://help.aliyun.com/document_detail/188889.html) operation to create a policy.
        If you want the cloud computers to automatically execute a custom command script, you can use the `UserCommands` field to configure a custom command.
        
        @param request: CreateDesktopsRequest
        @return: CreateDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_desktops_with_options_async(request, runtime)

    def create_disk_encryption_service_with_options(
        self,
        request: ecd_20200930_models.CreateDiskEncryptionServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateDiskEncryptionServiceResponse:
        """
        @summary Enables the disk encryption feature and adds the service-linked role that is encrypted by Cloud Drive Service to a Resource Access Management (RAM) user.
        
        @param request: CreateDiskEncryptionServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiskEncryptionServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDiskEncryptionService',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateDiskEncryptionServiceResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateDiskEncryptionServiceResponse(),
                self.execute(params, req, runtime)
            )

    async def create_disk_encryption_service_with_options_async(
        self,
        request: ecd_20200930_models.CreateDiskEncryptionServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateDiskEncryptionServiceResponse:
        """
        @summary Enables the disk encryption feature and adds the service-linked role that is encrypted by Cloud Drive Service to a Resource Access Management (RAM) user.
        
        @param request: CreateDiskEncryptionServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiskEncryptionServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDiskEncryptionService',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateDiskEncryptionServiceResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateDiskEncryptionServiceResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_disk_encryption_service(
        self,
        request: ecd_20200930_models.CreateDiskEncryptionServiceRequest,
    ) -> ecd_20200930_models.CreateDiskEncryptionServiceResponse:
        """
        @summary Enables the disk encryption feature and adds the service-linked role that is encrypted by Cloud Drive Service to a Resource Access Management (RAM) user.
        
        @param request: CreateDiskEncryptionServiceRequest
        @return: CreateDiskEncryptionServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_disk_encryption_service_with_options(request, runtime)

    async def create_disk_encryption_service_async(
        self,
        request: ecd_20200930_models.CreateDiskEncryptionServiceRequest,
    ) -> ecd_20200930_models.CreateDiskEncryptionServiceResponse:
        """
        @summary Enables the disk encryption feature and adds the service-linked role that is encrypted by Cloud Drive Service to a Resource Access Management (RAM) user.
        
        @param request: CreateDiskEncryptionServiceRequest
        @return: CreateDiskEncryptionServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_disk_encryption_service_with_options_async(request, runtime)

    def create_image_with_options(
        self,
        request: ecd_20200930_models.CreateImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateImageResponse:
        """
        @summary Creates a custom image based on a deployed cloud computer. Then, you can use the custom image to create cloud computers that have the same configurations. This prevents the repeated settings when you create cloud computers.
        
        @param request: CreateImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_clean_userdata):
            query['AutoCleanUserdata'] = request.auto_clean_userdata
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.disk_type):
            query['DiskType'] = request.disk_type
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.image_resource_type):
            query['ImageResourceType'] = request.image_resource_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.snapshot_ids):
            query['SnapshotIds'] = request.snapshot_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateImageResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateImageResponse(),
                self.execute(params, req, runtime)
            )

    async def create_image_with_options_async(
        self,
        request: ecd_20200930_models.CreateImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateImageResponse:
        """
        @summary Creates a custom image based on a deployed cloud computer. Then, you can use the custom image to create cloud computers that have the same configurations. This prevents the repeated settings when you create cloud computers.
        
        @param request: CreateImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_clean_userdata):
            query['AutoCleanUserdata'] = request.auto_clean_userdata
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.disk_type):
            query['DiskType'] = request.disk_type
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.image_resource_type):
            query['ImageResourceType'] = request.image_resource_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.snapshot_ids):
            query['SnapshotIds'] = request.snapshot_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateImageResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateImageResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_image(
        self,
        request: ecd_20200930_models.CreateImageRequest,
    ) -> ecd_20200930_models.CreateImageResponse:
        """
        @summary Creates a custom image based on a deployed cloud computer. Then, you can use the custom image to create cloud computers that have the same configurations. This prevents the repeated settings when you create cloud computers.
        
        @param request: CreateImageRequest
        @return: CreateImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_image_with_options(request, runtime)

    async def create_image_async(
        self,
        request: ecd_20200930_models.CreateImageRequest,
    ) -> ecd_20200930_models.CreateImageResponse:
        """
        @summary Creates a custom image based on a deployed cloud computer. Then, you can use the custom image to create cloud computers that have the same configurations. This prevents the repeated settings when you create cloud computers.
        
        @param request: CreateImageRequest
        @return: CreateImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_image_with_options_async(request, runtime)

    def create_nasfile_system_with_options(
        self,
        request: ecd_20200930_models.CreateNASFileSystemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateNASFileSystemResponse:
        """
        @summary Create a NAS file system.
        
        @description <props="china">
        - Each standard workspace can create one NAS file system to meet the need for sharing files between cloud desktops in the workspace.
        - The system will automatically create a general-purpose NAS file system (with storage specifications of Capacity and Performance, with capacities of 10 PiB and 1 PiB respectively) and generate a default mount point.
        - The NAS file system uses pay-as-you-go by default. You need to pay for the actual storage usage. You can also purchase resource packages to offset the storage usage.
        For more information, see [Creating Shared Storage NAS](https://help.aliyun.com/document_detail/214481.html).
        <props="intl">
        - Each standard workspace can create one NAS file system to meet the need for sharing files between cloud desktops in the workspace.
        - The system will automatically create a general-purpose NAS file system (with storage specifications of Capacity and Performance, with capacities of 10 PiB and 1 PiB respectively) and generate a default mount point.
        - The NAS file system uses pay-as-you-go by default. You need to pay for the actual storage usage. You can also purchase storage packages to offset the storage usage.
        For more information, see [Creating Shared Storage NAS](https://help.aliyun.com/document_detail/214481.html).
        
        @param request: CreateNASFileSystemRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNASFileSystemResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.encrypt_type):
            query['EncryptType'] = request.encrypt_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNASFileSystem',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateNASFileSystemResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateNASFileSystemResponse(),
                self.execute(params, req, runtime)
            )

    async def create_nasfile_system_with_options_async(
        self,
        request: ecd_20200930_models.CreateNASFileSystemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateNASFileSystemResponse:
        """
        @summary Create a NAS file system.
        
        @description <props="china">
        - Each standard workspace can create one NAS file system to meet the need for sharing files between cloud desktops in the workspace.
        - The system will automatically create a general-purpose NAS file system (with storage specifications of Capacity and Performance, with capacities of 10 PiB and 1 PiB respectively) and generate a default mount point.
        - The NAS file system uses pay-as-you-go by default. You need to pay for the actual storage usage. You can also purchase resource packages to offset the storage usage.
        For more information, see [Creating Shared Storage NAS](https://help.aliyun.com/document_detail/214481.html).
        <props="intl">
        - Each standard workspace can create one NAS file system to meet the need for sharing files between cloud desktops in the workspace.
        - The system will automatically create a general-purpose NAS file system (with storage specifications of Capacity and Performance, with capacities of 10 PiB and 1 PiB respectively) and generate a default mount point.
        - The NAS file system uses pay-as-you-go by default. You need to pay for the actual storage usage. You can also purchase storage packages to offset the storage usage.
        For more information, see [Creating Shared Storage NAS](https://help.aliyun.com/document_detail/214481.html).
        
        @param request: CreateNASFileSystemRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNASFileSystemResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.encrypt_type):
            query['EncryptType'] = request.encrypt_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNASFileSystem',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateNASFileSystemResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateNASFileSystemResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_nasfile_system(
        self,
        request: ecd_20200930_models.CreateNASFileSystemRequest,
    ) -> ecd_20200930_models.CreateNASFileSystemResponse:
        """
        @summary Create a NAS file system.
        
        @description <props="china">
        - Each standard workspace can create one NAS file system to meet the need for sharing files between cloud desktops in the workspace.
        - The system will automatically create a general-purpose NAS file system (with storage specifications of Capacity and Performance, with capacities of 10 PiB and 1 PiB respectively) and generate a default mount point.
        - The NAS file system uses pay-as-you-go by default. You need to pay for the actual storage usage. You can also purchase resource packages to offset the storage usage.
        For more information, see [Creating Shared Storage NAS](https://help.aliyun.com/document_detail/214481.html).
        <props="intl">
        - Each standard workspace can create one NAS file system to meet the need for sharing files between cloud desktops in the workspace.
        - The system will automatically create a general-purpose NAS file system (with storage specifications of Capacity and Performance, with capacities of 10 PiB and 1 PiB respectively) and generate a default mount point.
        - The NAS file system uses pay-as-you-go by default. You need to pay for the actual storage usage. You can also purchase storage packages to offset the storage usage.
        For more information, see [Creating Shared Storage NAS](https://help.aliyun.com/document_detail/214481.html).
        
        @param request: CreateNASFileSystemRequest
        @return: CreateNASFileSystemResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nasfile_system_with_options(request, runtime)

    async def create_nasfile_system_async(
        self,
        request: ecd_20200930_models.CreateNASFileSystemRequest,
    ) -> ecd_20200930_models.CreateNASFileSystemResponse:
        """
        @summary Create a NAS file system.
        
        @description <props="china">
        - Each standard workspace can create one NAS file system to meet the need for sharing files between cloud desktops in the workspace.
        - The system will automatically create a general-purpose NAS file system (with storage specifications of Capacity and Performance, with capacities of 10 PiB and 1 PiB respectively) and generate a default mount point.
        - The NAS file system uses pay-as-you-go by default. You need to pay for the actual storage usage. You can also purchase resource packages to offset the storage usage.
        For more information, see [Creating Shared Storage NAS](https://help.aliyun.com/document_detail/214481.html).
        <props="intl">
        - Each standard workspace can create one NAS file system to meet the need for sharing files between cloud desktops in the workspace.
        - The system will automatically create a general-purpose NAS file system (with storage specifications of Capacity and Performance, with capacities of 10 PiB and 1 PiB respectively) and generate a default mount point.
        - The NAS file system uses pay-as-you-go by default. You need to pay for the actual storage usage. You can also purchase storage packages to offset the storage usage.
        For more information, see [Creating Shared Storage NAS](https://help.aliyun.com/document_detail/214481.html).
        
        @param request: CreateNASFileSystemRequest
        @return: CreateNASFileSystemResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nasfile_system_with_options_async(request, runtime)

    def create_network_package_with_options(
        self,
        request: ecd_20200930_models.CreateNetworkPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateNetworkPackageResponse:
        """
        @summary Creates a premium bandwidth plan for an office network.
        
        @param request: CreateNetworkPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkPackageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkPackage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateNetworkPackageResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateNetworkPackageResponse(),
                self.execute(params, req, runtime)
            )

    async def create_network_package_with_options_async(
        self,
        request: ecd_20200930_models.CreateNetworkPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateNetworkPackageResponse:
        """
        @summary Creates a premium bandwidth plan for an office network.
        
        @param request: CreateNetworkPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkPackageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkPackage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateNetworkPackageResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateNetworkPackageResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_network_package(
        self,
        request: ecd_20200930_models.CreateNetworkPackageRequest,
    ) -> ecd_20200930_models.CreateNetworkPackageResponse:
        """
        @summary Creates a premium bandwidth plan for an office network.
        
        @param request: CreateNetworkPackageRequest
        @return: CreateNetworkPackageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_network_package_with_options(request, runtime)

    async def create_network_package_async(
        self,
        request: ecd_20200930_models.CreateNetworkPackageRequest,
    ) -> ecd_20200930_models.CreateNetworkPackageResponse:
        """
        @summary Creates a premium bandwidth plan for an office network.
        
        @param request: CreateNetworkPackageRequest
        @return: CreateNetworkPackageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_network_package_with_options_async(request, runtime)

    def create_policy_group_with_options(
        self,
        request: ecd_20200930_models.CreatePolicyGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreatePolicyGroupResponse:
        """
        @summary Creates a cloud computer policy.
        
        @description A cloud computer policy is a collection of rules to manage cloud computers in performance and security. For example, you can create a basic policy that involves the disk mapping, USB redirection, watermarking features and rules such as DNS rules. For more information, see [Policy overview](https://help.aliyun.com/document_detail/189345.html).
        
        @param request: CreatePolicyGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePolicyGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.admin_access):
            query['AdminAccess'] = request.admin_access
        if not UtilClient.is_unset(request.app_content_protection):
            query['AppContentProtection'] = request.app_content_protection
        if not UtilClient.is_unset(request.authorize_access_policy_rule):
            query['AuthorizeAccessPolicyRule'] = request.authorize_access_policy_rule
        if not UtilClient.is_unset(request.authorize_security_policy_rule):
            query['AuthorizeSecurityPolicyRule'] = request.authorize_security_policy_rule
        if not UtilClient.is_unset(request.camera_redirect):
            query['CameraRedirect'] = request.camera_redirect
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.clipboard):
            query['Clipboard'] = request.clipboard
        if not UtilClient.is_unset(request.device_redirects):
            query['DeviceRedirects'] = request.device_redirects
        if not UtilClient.is_unset(request.device_rules):
            query['DeviceRules'] = request.device_rules
        if not UtilClient.is_unset(request.domain_list):
            query['DomainList'] = request.domain_list
        if not UtilClient.is_unset(request.domain_resolve_rule):
            query['DomainResolveRule'] = request.domain_resolve_rule
        if not UtilClient.is_unset(request.domain_resolve_rule_type):
            query['DomainResolveRuleType'] = request.domain_resolve_rule_type
        if not UtilClient.is_unset(request.end_user_apply_admin_coordinate):
            query['EndUserApplyAdminCoordinate'] = request.end_user_apply_admin_coordinate
        if not UtilClient.is_unset(request.end_user_group_coordinate):
            query['EndUserGroupCoordinate'] = request.end_user_group_coordinate
        if not UtilClient.is_unset(request.gpu_acceleration):
            query['GpuAcceleration'] = request.gpu_acceleration
        if not UtilClient.is_unset(request.html_5access):
            query['Html5Access'] = request.html_5access
        if not UtilClient.is_unset(request.html_5file_transfer):
            query['Html5FileTransfer'] = request.html_5file_transfer
        if not UtilClient.is_unset(request.internet_communication_protocol):
            query['InternetCommunicationProtocol'] = request.internet_communication_protocol
        if not UtilClient.is_unset(request.local_drive):
            query['LocalDrive'] = request.local_drive
        if not UtilClient.is_unset(request.max_reconnect_time):
            query['MaxReconnectTime'] = request.max_reconnect_time
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.net_redirect):
            query['NetRedirect'] = request.net_redirect
        if not UtilClient.is_unset(request.preempt_login):
            query['PreemptLogin'] = request.preempt_login
        if not UtilClient.is_unset(request.preempt_login_user):
            query['PreemptLoginUser'] = request.preempt_login_user
        if not UtilClient.is_unset(request.printer_redirection):
            query['PrinterRedirection'] = request.printer_redirection
        if not UtilClient.is_unset(request.record_content):
            query['RecordContent'] = request.record_content
        if not UtilClient.is_unset(request.record_content_expires):
            query['RecordContentExpires'] = request.record_content_expires
        if not UtilClient.is_unset(request.recording):
            query['Recording'] = request.recording
        if not UtilClient.is_unset(request.recording_audio):
            query['RecordingAudio'] = request.recording_audio
        if not UtilClient.is_unset(request.recording_duration):
            query['RecordingDuration'] = request.recording_duration
        if not UtilClient.is_unset(request.recording_end_time):
            query['RecordingEndTime'] = request.recording_end_time
        if not UtilClient.is_unset(request.recording_expires):
            query['RecordingExpires'] = request.recording_expires
        if not UtilClient.is_unset(request.recording_fps):
            query['RecordingFps'] = request.recording_fps
        if not UtilClient.is_unset(request.recording_start_time):
            query['RecordingStartTime'] = request.recording_start_time
        if not UtilClient.is_unset(request.recording_user_notify):
            query['RecordingUserNotify'] = request.recording_user_notify
        if not UtilClient.is_unset(request.recording_user_notify_message):
            query['RecordingUserNotifyMessage'] = request.recording_user_notify_message
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remote_coordinate):
            query['RemoteCoordinate'] = request.remote_coordinate
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.scope_value):
            query['ScopeValue'] = request.scope_value
        if not UtilClient.is_unset(request.usb_redirect):
            query['UsbRedirect'] = request.usb_redirect
        if not UtilClient.is_unset(request.usb_supply_redirect_rule):
            query['UsbSupplyRedirectRule'] = request.usb_supply_redirect_rule
        if not UtilClient.is_unset(request.video_redirect):
            query['VideoRedirect'] = request.video_redirect
        if not UtilClient.is_unset(request.visual_quality):
            query['VisualQuality'] = request.visual_quality
        if not UtilClient.is_unset(request.watermark):
            query['Watermark'] = request.watermark
        if not UtilClient.is_unset(request.watermark_anti_cam):
            query['WatermarkAntiCam'] = request.watermark_anti_cam
        if not UtilClient.is_unset(request.watermark_color):
            query['WatermarkColor'] = request.watermark_color
        if not UtilClient.is_unset(request.watermark_degree):
            query['WatermarkDegree'] = request.watermark_degree
        if not UtilClient.is_unset(request.watermark_font_size):
            query['WatermarkFontSize'] = request.watermark_font_size
        if not UtilClient.is_unset(request.watermark_font_style):
            query['WatermarkFontStyle'] = request.watermark_font_style
        if not UtilClient.is_unset(request.watermark_power):
            query['WatermarkPower'] = request.watermark_power
        if not UtilClient.is_unset(request.watermark_row_amount):
            query['WatermarkRowAmount'] = request.watermark_row_amount
        if not UtilClient.is_unset(request.watermark_security):
            query['WatermarkSecurity'] = request.watermark_security
        if not UtilClient.is_unset(request.watermark_transparency):
            query['WatermarkTransparency'] = request.watermark_transparency
        if not UtilClient.is_unset(request.watermark_transparency_value):
            query['WatermarkTransparencyValue'] = request.watermark_transparency_value
        if not UtilClient.is_unset(request.watermark_type):
            query['WatermarkType'] = request.watermark_type
        if not UtilClient.is_unset(request.wy_assistant):
            query['WyAssistant'] = request.wy_assistant
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePolicyGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreatePolicyGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreatePolicyGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def create_policy_group_with_options_async(
        self,
        request: ecd_20200930_models.CreatePolicyGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreatePolicyGroupResponse:
        """
        @summary Creates a cloud computer policy.
        
        @description A cloud computer policy is a collection of rules to manage cloud computers in performance and security. For example, you can create a basic policy that involves the disk mapping, USB redirection, watermarking features and rules such as DNS rules. For more information, see [Policy overview](https://help.aliyun.com/document_detail/189345.html).
        
        @param request: CreatePolicyGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePolicyGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.admin_access):
            query['AdminAccess'] = request.admin_access
        if not UtilClient.is_unset(request.app_content_protection):
            query['AppContentProtection'] = request.app_content_protection
        if not UtilClient.is_unset(request.authorize_access_policy_rule):
            query['AuthorizeAccessPolicyRule'] = request.authorize_access_policy_rule
        if not UtilClient.is_unset(request.authorize_security_policy_rule):
            query['AuthorizeSecurityPolicyRule'] = request.authorize_security_policy_rule
        if not UtilClient.is_unset(request.camera_redirect):
            query['CameraRedirect'] = request.camera_redirect
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.clipboard):
            query['Clipboard'] = request.clipboard
        if not UtilClient.is_unset(request.device_redirects):
            query['DeviceRedirects'] = request.device_redirects
        if not UtilClient.is_unset(request.device_rules):
            query['DeviceRules'] = request.device_rules
        if not UtilClient.is_unset(request.domain_list):
            query['DomainList'] = request.domain_list
        if not UtilClient.is_unset(request.domain_resolve_rule):
            query['DomainResolveRule'] = request.domain_resolve_rule
        if not UtilClient.is_unset(request.domain_resolve_rule_type):
            query['DomainResolveRuleType'] = request.domain_resolve_rule_type
        if not UtilClient.is_unset(request.end_user_apply_admin_coordinate):
            query['EndUserApplyAdminCoordinate'] = request.end_user_apply_admin_coordinate
        if not UtilClient.is_unset(request.end_user_group_coordinate):
            query['EndUserGroupCoordinate'] = request.end_user_group_coordinate
        if not UtilClient.is_unset(request.gpu_acceleration):
            query['GpuAcceleration'] = request.gpu_acceleration
        if not UtilClient.is_unset(request.html_5access):
            query['Html5Access'] = request.html_5access
        if not UtilClient.is_unset(request.html_5file_transfer):
            query['Html5FileTransfer'] = request.html_5file_transfer
        if not UtilClient.is_unset(request.internet_communication_protocol):
            query['InternetCommunicationProtocol'] = request.internet_communication_protocol
        if not UtilClient.is_unset(request.local_drive):
            query['LocalDrive'] = request.local_drive
        if not UtilClient.is_unset(request.max_reconnect_time):
            query['MaxReconnectTime'] = request.max_reconnect_time
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.net_redirect):
            query['NetRedirect'] = request.net_redirect
        if not UtilClient.is_unset(request.preempt_login):
            query['PreemptLogin'] = request.preempt_login
        if not UtilClient.is_unset(request.preempt_login_user):
            query['PreemptLoginUser'] = request.preempt_login_user
        if not UtilClient.is_unset(request.printer_redirection):
            query['PrinterRedirection'] = request.printer_redirection
        if not UtilClient.is_unset(request.record_content):
            query['RecordContent'] = request.record_content
        if not UtilClient.is_unset(request.record_content_expires):
            query['RecordContentExpires'] = request.record_content_expires
        if not UtilClient.is_unset(request.recording):
            query['Recording'] = request.recording
        if not UtilClient.is_unset(request.recording_audio):
            query['RecordingAudio'] = request.recording_audio
        if not UtilClient.is_unset(request.recording_duration):
            query['RecordingDuration'] = request.recording_duration
        if not UtilClient.is_unset(request.recording_end_time):
            query['RecordingEndTime'] = request.recording_end_time
        if not UtilClient.is_unset(request.recording_expires):
            query['RecordingExpires'] = request.recording_expires
        if not UtilClient.is_unset(request.recording_fps):
            query['RecordingFps'] = request.recording_fps
        if not UtilClient.is_unset(request.recording_start_time):
            query['RecordingStartTime'] = request.recording_start_time
        if not UtilClient.is_unset(request.recording_user_notify):
            query['RecordingUserNotify'] = request.recording_user_notify
        if not UtilClient.is_unset(request.recording_user_notify_message):
            query['RecordingUserNotifyMessage'] = request.recording_user_notify_message
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remote_coordinate):
            query['RemoteCoordinate'] = request.remote_coordinate
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.scope_value):
            query['ScopeValue'] = request.scope_value
        if not UtilClient.is_unset(request.usb_redirect):
            query['UsbRedirect'] = request.usb_redirect
        if not UtilClient.is_unset(request.usb_supply_redirect_rule):
            query['UsbSupplyRedirectRule'] = request.usb_supply_redirect_rule
        if not UtilClient.is_unset(request.video_redirect):
            query['VideoRedirect'] = request.video_redirect
        if not UtilClient.is_unset(request.visual_quality):
            query['VisualQuality'] = request.visual_quality
        if not UtilClient.is_unset(request.watermark):
            query['Watermark'] = request.watermark
        if not UtilClient.is_unset(request.watermark_anti_cam):
            query['WatermarkAntiCam'] = request.watermark_anti_cam
        if not UtilClient.is_unset(request.watermark_color):
            query['WatermarkColor'] = request.watermark_color
        if not UtilClient.is_unset(request.watermark_degree):
            query['WatermarkDegree'] = request.watermark_degree
        if not UtilClient.is_unset(request.watermark_font_size):
            query['WatermarkFontSize'] = request.watermark_font_size
        if not UtilClient.is_unset(request.watermark_font_style):
            query['WatermarkFontStyle'] = request.watermark_font_style
        if not UtilClient.is_unset(request.watermark_power):
            query['WatermarkPower'] = request.watermark_power
        if not UtilClient.is_unset(request.watermark_row_amount):
            query['WatermarkRowAmount'] = request.watermark_row_amount
        if not UtilClient.is_unset(request.watermark_security):
            query['WatermarkSecurity'] = request.watermark_security
        if not UtilClient.is_unset(request.watermark_transparency):
            query['WatermarkTransparency'] = request.watermark_transparency
        if not UtilClient.is_unset(request.watermark_transparency_value):
            query['WatermarkTransparencyValue'] = request.watermark_transparency_value
        if not UtilClient.is_unset(request.watermark_type):
            query['WatermarkType'] = request.watermark_type
        if not UtilClient.is_unset(request.wy_assistant):
            query['WyAssistant'] = request.wy_assistant
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePolicyGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreatePolicyGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreatePolicyGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_policy_group(
        self,
        request: ecd_20200930_models.CreatePolicyGroupRequest,
    ) -> ecd_20200930_models.CreatePolicyGroupResponse:
        """
        @summary Creates a cloud computer policy.
        
        @description A cloud computer policy is a collection of rules to manage cloud computers in performance and security. For example, you can create a basic policy that involves the disk mapping, USB redirection, watermarking features and rules such as DNS rules. For more information, see [Policy overview](https://help.aliyun.com/document_detail/189345.html).
        
        @param request: CreatePolicyGroupRequest
        @return: CreatePolicyGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_policy_group_with_options(request, runtime)

    async def create_policy_group_async(
        self,
        request: ecd_20200930_models.CreatePolicyGroupRequest,
    ) -> ecd_20200930_models.CreatePolicyGroupResponse:
        """
        @summary Creates a cloud computer policy.
        
        @description A cloud computer policy is a collection of rules to manage cloud computers in performance and security. For example, you can create a basic policy that involves the disk mapping, USB redirection, watermarking features and rules such as DNS rules. For more information, see [Policy overview](https://help.aliyun.com/document_detail/189345.html).
        
        @param request: CreatePolicyGroupRequest
        @return: CreatePolicyGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_policy_group_with_options_async(request, runtime)

    def create_ramdirectory_with_options(
        self,
        request: ecd_20200930_models.CreateRAMDirectoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateRAMDirectoryResponse:
        """
        @summary Creates a Resource Access Management (RAM) directory.
        
        @description Before you create a RAM directory, complete the following preparations:
        Call the `CreateVpc` operation to create a virtual private cloud (VPC) in a region supported by Elastic Desktop Service.
        Call the `CreateVSwitch` operation to create a vSwitch in the VPC. The vSwitch is in a zone that is supported by Elastic Desktop Service. You can call the [DescribeZones](https://help.aliyun.com/document_detail/196648.html) operation to obtain the most recent zone list for a region supported by Elastic Desktop Service
        
        @param request: CreateRAMDirectoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRAMDirectoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_access_type):
            query['DesktopAccessType'] = request.desktop_access_type
        if not UtilClient.is_unset(request.directory_name):
            query['DirectoryName'] = request.directory_name
        if not UtilClient.is_unset(request.enable_admin_access):
            query['EnableAdminAccess'] = request.enable_admin_access
        if not UtilClient.is_unset(request.enable_internet_access):
            query['EnableInternetAccess'] = request.enable_internet_access
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRAMDirectory',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateRAMDirectoryResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateRAMDirectoryResponse(),
                self.execute(params, req, runtime)
            )

    async def create_ramdirectory_with_options_async(
        self,
        request: ecd_20200930_models.CreateRAMDirectoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateRAMDirectoryResponse:
        """
        @summary Creates a Resource Access Management (RAM) directory.
        
        @description Before you create a RAM directory, complete the following preparations:
        Call the `CreateVpc` operation to create a virtual private cloud (VPC) in a region supported by Elastic Desktop Service.
        Call the `CreateVSwitch` operation to create a vSwitch in the VPC. The vSwitch is in a zone that is supported by Elastic Desktop Service. You can call the [DescribeZones](https://help.aliyun.com/document_detail/196648.html) operation to obtain the most recent zone list for a region supported by Elastic Desktop Service
        
        @param request: CreateRAMDirectoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRAMDirectoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_access_type):
            query['DesktopAccessType'] = request.desktop_access_type
        if not UtilClient.is_unset(request.directory_name):
            query['DirectoryName'] = request.directory_name
        if not UtilClient.is_unset(request.enable_admin_access):
            query['EnableAdminAccess'] = request.enable_admin_access
        if not UtilClient.is_unset(request.enable_internet_access):
            query['EnableInternetAccess'] = request.enable_internet_access
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRAMDirectory',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateRAMDirectoryResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateRAMDirectoryResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_ramdirectory(
        self,
        request: ecd_20200930_models.CreateRAMDirectoryRequest,
    ) -> ecd_20200930_models.CreateRAMDirectoryResponse:
        """
        @summary Creates a Resource Access Management (RAM) directory.
        
        @description Before you create a RAM directory, complete the following preparations:
        Call the `CreateVpc` operation to create a virtual private cloud (VPC) in a region supported by Elastic Desktop Service.
        Call the `CreateVSwitch` operation to create a vSwitch in the VPC. The vSwitch is in a zone that is supported by Elastic Desktop Service. You can call the [DescribeZones](https://help.aliyun.com/document_detail/196648.html) operation to obtain the most recent zone list for a region supported by Elastic Desktop Service
        
        @param request: CreateRAMDirectoryRequest
        @return: CreateRAMDirectoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ramdirectory_with_options(request, runtime)

    async def create_ramdirectory_async(
        self,
        request: ecd_20200930_models.CreateRAMDirectoryRequest,
    ) -> ecd_20200930_models.CreateRAMDirectoryResponse:
        """
        @summary Creates a Resource Access Management (RAM) directory.
        
        @description Before you create a RAM directory, complete the following preparations:
        Call the `CreateVpc` operation to create a virtual private cloud (VPC) in a region supported by Elastic Desktop Service.
        Call the `CreateVSwitch` operation to create a vSwitch in the VPC. The vSwitch is in a zone that is supported by Elastic Desktop Service. You can call the [DescribeZones](https://help.aliyun.com/document_detail/196648.html) operation to obtain the most recent zone list for a region supported by Elastic Desktop Service
        
        @param request: CreateRAMDirectoryRequest
        @return: CreateRAMDirectoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ramdirectory_with_options_async(request, runtime)

    def create_simple_office_site_with_options(
        self,
        request: ecd_20200930_models.CreateSimpleOfficeSiteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateSimpleOfficeSiteResponse:
        """
        @summary Creates an office network of the convenience account type. Elastic Desktop Service supports the following types of accounts: convenience accounts and enterprise AD accounts.
        
        @param request: CreateSimpleOfficeSiteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSimpleOfficeSiteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.cen_owner_id):
            query['CenOwnerId'] = request.cen_owner_id
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.cloud_box_office_site):
            query['CloudBoxOfficeSite'] = request.cloud_box_office_site
        if not UtilClient.is_unset(request.desktop_access_type):
            query['DesktopAccessType'] = request.desktop_access_type
        if not UtilClient.is_unset(request.enable_admin_access):
            query['EnableAdminAccess'] = request.enable_admin_access
        if not UtilClient.is_unset(request.enable_internet_access):
            query['EnableInternetAccess'] = request.enable_internet_access
        if not UtilClient.is_unset(request.need_verify_zero_device):
            query['NeedVerifyZeroDevice'] = request.need_verify_zero_device
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.verify_code):
            query['VerifyCode'] = request.verify_code
        if not UtilClient.is_unset(request.vpc_type):
            query['VpcType'] = request.vpc_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSimpleOfficeSite',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateSimpleOfficeSiteResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateSimpleOfficeSiteResponse(),
                self.execute(params, req, runtime)
            )

    async def create_simple_office_site_with_options_async(
        self,
        request: ecd_20200930_models.CreateSimpleOfficeSiteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateSimpleOfficeSiteResponse:
        """
        @summary Creates an office network of the convenience account type. Elastic Desktop Service supports the following types of accounts: convenience accounts and enterprise AD accounts.
        
        @param request: CreateSimpleOfficeSiteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSimpleOfficeSiteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.cen_owner_id):
            query['CenOwnerId'] = request.cen_owner_id
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.cloud_box_office_site):
            query['CloudBoxOfficeSite'] = request.cloud_box_office_site
        if not UtilClient.is_unset(request.desktop_access_type):
            query['DesktopAccessType'] = request.desktop_access_type
        if not UtilClient.is_unset(request.enable_admin_access):
            query['EnableAdminAccess'] = request.enable_admin_access
        if not UtilClient.is_unset(request.enable_internet_access):
            query['EnableInternetAccess'] = request.enable_internet_access
        if not UtilClient.is_unset(request.need_verify_zero_device):
            query['NeedVerifyZeroDevice'] = request.need_verify_zero_device
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.verify_code):
            query['VerifyCode'] = request.verify_code
        if not UtilClient.is_unset(request.vpc_type):
            query['VpcType'] = request.vpc_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSimpleOfficeSite',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateSimpleOfficeSiteResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateSimpleOfficeSiteResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_simple_office_site(
        self,
        request: ecd_20200930_models.CreateSimpleOfficeSiteRequest,
    ) -> ecd_20200930_models.CreateSimpleOfficeSiteResponse:
        """
        @summary Creates an office network of the convenience account type. Elastic Desktop Service supports the following types of accounts: convenience accounts and enterprise AD accounts.
        
        @param request: CreateSimpleOfficeSiteRequest
        @return: CreateSimpleOfficeSiteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_simple_office_site_with_options(request, runtime)

    async def create_simple_office_site_async(
        self,
        request: ecd_20200930_models.CreateSimpleOfficeSiteRequest,
    ) -> ecd_20200930_models.CreateSimpleOfficeSiteResponse:
        """
        @summary Creates an office network of the convenience account type. Elastic Desktop Service supports the following types of accounts: convenience accounts and enterprise AD accounts.
        
        @param request: CreateSimpleOfficeSiteRequest
        @return: CreateSimpleOfficeSiteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_simple_office_site_with_options_async(request, runtime)

    def create_snapshot_with_options(
        self,
        request: ecd_20200930_models.CreateSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateSnapshotResponse:
        """
        @summary Create a snapshot for a disk of a cloud computer to back up or restore the data on the disk.
        
        @description The cloud computer must be in the *Running** or **Stopped** state.
        
        @param request: CreateSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        if not UtilClient.is_unset(request.source_disk_type):
            query['SourceDiskType'] = request.source_disk_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshot',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateSnapshotResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateSnapshotResponse(),
                self.execute(params, req, runtime)
            )

    async def create_snapshot_with_options_async(
        self,
        request: ecd_20200930_models.CreateSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.CreateSnapshotResponse:
        """
        @summary Create a snapshot for a disk of a cloud computer to back up or restore the data on the disk.
        
        @description The cloud computer must be in the *Running** or **Stopped** state.
        
        @param request: CreateSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        if not UtilClient.is_unset(request.source_disk_type):
            query['SourceDiskType'] = request.source_disk_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshot',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.CreateSnapshotResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.CreateSnapshotResponse(),
                await self.execute_async(params, req, runtime)
            )

    def create_snapshot(
        self,
        request: ecd_20200930_models.CreateSnapshotRequest,
    ) -> ecd_20200930_models.CreateSnapshotResponse:
        """
        @summary Create a snapshot for a disk of a cloud computer to back up or restore the data on the disk.
        
        @description The cloud computer must be in the *Running** or **Stopped** state.
        
        @param request: CreateSnapshotRequest
        @return: CreateSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_snapshot_with_options(request, runtime)

    async def create_snapshot_async(
        self,
        request: ecd_20200930_models.CreateSnapshotRequest,
    ) -> ecd_20200930_models.CreateSnapshotResponse:
        """
        @summary Create a snapshot for a disk of a cloud computer to back up or restore the data on the disk.
        
        @description The cloud computer must be in the *Running** or **Stopped** state.
        
        @param request: CreateSnapshotRequest
        @return: CreateSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_snapshot_with_options_async(request, runtime)

    def delete_auto_snapshot_policy_with_options(
        self,
        request: ecd_20200930_models.DeleteAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteAutoSnapshotPolicyResponse:
        """
        @summary Deletes an automatic snapshot policy.
        
        @param request: DeleteAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteAutoSnapshotPolicyResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteAutoSnapshotPolicyResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_auto_snapshot_policy_with_options_async(
        self,
        request: ecd_20200930_models.DeleteAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteAutoSnapshotPolicyResponse:
        """
        @summary Deletes an automatic snapshot policy.
        
        @param request: DeleteAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteAutoSnapshotPolicyResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteAutoSnapshotPolicyResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_auto_snapshot_policy(
        self,
        request: ecd_20200930_models.DeleteAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.DeleteAutoSnapshotPolicyResponse:
        """
        @summary Deletes an automatic snapshot policy.
        
        @param request: DeleteAutoSnapshotPolicyRequest
        @return: DeleteAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_auto_snapshot_policy_with_options(request, runtime)

    async def delete_auto_snapshot_policy_async(
        self,
        request: ecd_20200930_models.DeleteAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.DeleteAutoSnapshotPolicyResponse:
        """
        @summary Deletes an automatic snapshot policy.
        
        @param request: DeleteAutoSnapshotPolicyRequest
        @return: DeleteAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_auto_snapshot_policy_with_options_async(request, runtime)

    def delete_bundles_with_options(
        self,
        request: ecd_20200930_models.DeleteBundlesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteBundlesResponse:
        """
        @summary Deletes custom cloud computer templates.
        
        @param request: DeleteBundlesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBundlesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBundles',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteBundlesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteBundlesResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_bundles_with_options_async(
        self,
        request: ecd_20200930_models.DeleteBundlesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteBundlesResponse:
        """
        @summary Deletes custom cloud computer templates.
        
        @param request: DeleteBundlesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBundlesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBundles',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteBundlesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteBundlesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_bundles(
        self,
        request: ecd_20200930_models.DeleteBundlesRequest,
    ) -> ecd_20200930_models.DeleteBundlesResponse:
        """
        @summary Deletes custom cloud computer templates.
        
        @param request: DeleteBundlesRequest
        @return: DeleteBundlesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_bundles_with_options(request, runtime)

    async def delete_bundles_async(
        self,
        request: ecd_20200930_models.DeleteBundlesRequest,
    ) -> ecd_20200930_models.DeleteBundlesResponse:
        """
        @summary Deletes custom cloud computer templates.
        
        @param request: DeleteBundlesRequest
        @return: DeleteBundlesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_bundles_with_options_async(request, runtime)

    def delete_cds_file_with_options(
        self,
        request: ecd_20200930_models.DeleteCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteCdsFileResponse:
        """
        @summary Deletes a file from a cloud disk in Cloud Drive Service.
        
        @param request: DeleteCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCdsFileResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCdsFileResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_cds_file_with_options_async(
        self,
        request: ecd_20200930_models.DeleteCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteCdsFileResponse:
        """
        @summary Deletes a file from a cloud disk in Cloud Drive Service.
        
        @param request: DeleteCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCdsFileResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCdsFileResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_cds_file(
        self,
        request: ecd_20200930_models.DeleteCdsFileRequest,
    ) -> ecd_20200930_models.DeleteCdsFileResponse:
        """
        @summary Deletes a file from a cloud disk in Cloud Drive Service.
        
        @param request: DeleteCdsFileRequest
        @return: DeleteCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_cds_file_with_options(request, runtime)

    async def delete_cds_file_async(
        self,
        request: ecd_20200930_models.DeleteCdsFileRequest,
    ) -> ecd_20200930_models.DeleteCdsFileResponse:
        """
        @summary Deletes a file from a cloud disk in Cloud Drive Service.
        
        @param request: DeleteCdsFileRequest
        @return: DeleteCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_cds_file_with_options_async(request, runtime)

    def delete_cloud_drive_groups_with_options(
        self,
        request: ecd_20200930_models.DeleteCloudDriveGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteCloudDriveGroupsResponse:
        """
        @summary Deletes team spaces.
        
        @param request: DeleteCloudDriveGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCloudDriveGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCloudDriveGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCloudDriveGroupsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCloudDriveGroupsResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_cloud_drive_groups_with_options_async(
        self,
        request: ecd_20200930_models.DeleteCloudDriveGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteCloudDriveGroupsResponse:
        """
        @summary Deletes team spaces.
        
        @param request: DeleteCloudDriveGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCloudDriveGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCloudDriveGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCloudDriveGroupsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCloudDriveGroupsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_cloud_drive_groups(
        self,
        request: ecd_20200930_models.DeleteCloudDriveGroupsRequest,
    ) -> ecd_20200930_models.DeleteCloudDriveGroupsResponse:
        """
        @summary Deletes team spaces.
        
        @param request: DeleteCloudDriveGroupsRequest
        @return: DeleteCloudDriveGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_cloud_drive_groups_with_options(request, runtime)

    async def delete_cloud_drive_groups_async(
        self,
        request: ecd_20200930_models.DeleteCloudDriveGroupsRequest,
    ) -> ecd_20200930_models.DeleteCloudDriveGroupsResponse:
        """
        @summary Deletes team spaces.
        
        @param request: DeleteCloudDriveGroupsRequest
        @return: DeleteCloudDriveGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_cloud_drive_groups_with_options_async(request, runtime)

    def delete_cloud_drive_users_with_options(
        self,
        request: ecd_20200930_models.DeleteCloudDriveUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteCloudDriveUsersResponse:
        """
        @summary 删除无影网盘中的终端用户
        
        @param request: DeleteCloudDriveUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCloudDriveUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCloudDriveUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCloudDriveUsersResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCloudDriveUsersResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_cloud_drive_users_with_options_async(
        self,
        request: ecd_20200930_models.DeleteCloudDriveUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteCloudDriveUsersResponse:
        """
        @summary 删除无影网盘中的终端用户
        
        @param request: DeleteCloudDriveUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCloudDriveUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCloudDriveUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCloudDriveUsersResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteCloudDriveUsersResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_cloud_drive_users(
        self,
        request: ecd_20200930_models.DeleteCloudDriveUsersRequest,
    ) -> ecd_20200930_models.DeleteCloudDriveUsersResponse:
        """
        @summary 删除无影网盘中的终端用户
        
        @param request: DeleteCloudDriveUsersRequest
        @return: DeleteCloudDriveUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_cloud_drive_users_with_options(request, runtime)

    async def delete_cloud_drive_users_async(
        self,
        request: ecd_20200930_models.DeleteCloudDriveUsersRequest,
    ) -> ecd_20200930_models.DeleteCloudDriveUsersResponse:
        """
        @summary 删除无影网盘中的终端用户
        
        @param request: DeleteCloudDriveUsersRequest
        @return: DeleteCloudDriveUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_cloud_drive_users_with_options_async(request, runtime)

    def delete_config_group_with_options(
        self,
        request: ecd_20200930_models.DeleteConfigGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteConfigGroupResponse:
        """
        @summary Deletes a configuration group.
        
        @param request: DeleteConfigGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteConfigGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_ids):
            query['GroupIds'] = request.group_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteConfigGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteConfigGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteConfigGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_config_group_with_options_async(
        self,
        request: ecd_20200930_models.DeleteConfigGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteConfigGroupResponse:
        """
        @summary Deletes a configuration group.
        
        @param request: DeleteConfigGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteConfigGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_ids):
            query['GroupIds'] = request.group_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteConfigGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteConfigGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteConfigGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_config_group(
        self,
        request: ecd_20200930_models.DeleteConfigGroupRequest,
    ) -> ecd_20200930_models.DeleteConfigGroupResponse:
        """
        @summary Deletes a configuration group.
        
        @param request: DeleteConfigGroupRequest
        @return: DeleteConfigGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_config_group_with_options(request, runtime)

    async def delete_config_group_async(
        self,
        request: ecd_20200930_models.DeleteConfigGroupRequest,
    ) -> ecd_20200930_models.DeleteConfigGroupResponse:
        """
        @summary Deletes a configuration group.
        
        @param request: DeleteConfigGroupRequest
        @return: DeleteConfigGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_config_group_with_options_async(request, runtime)

    def delete_desktop_group_with_options(
        self,
        request: ecd_20200930_models.DeleteDesktopGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteDesktopGroupResponse:
        """
        @summary Releases a desktop group.
        
        @description    Before you delete a desktop group, make sure that cloud desktops in the desktop group are not connected and no users are authorized to use the cloud desktops.
        You cannot delete a subscription desktop group when cloud desktops in the group are in valid period.
        If you delete a pay-as-you-go desktop group, cloud desktops in the group are deleted.
        
        @param request: DeleteDesktopGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDesktopGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDesktopGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDesktopGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDesktopGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_desktop_group_with_options_async(
        self,
        request: ecd_20200930_models.DeleteDesktopGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteDesktopGroupResponse:
        """
        @summary Releases a desktop group.
        
        @description    Before you delete a desktop group, make sure that cloud desktops in the desktop group are not connected and no users are authorized to use the cloud desktops.
        You cannot delete a subscription desktop group when cloud desktops in the group are in valid period.
        If you delete a pay-as-you-go desktop group, cloud desktops in the group are deleted.
        
        @param request: DeleteDesktopGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDesktopGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDesktopGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDesktopGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDesktopGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_desktop_group(
        self,
        request: ecd_20200930_models.DeleteDesktopGroupRequest,
    ) -> ecd_20200930_models.DeleteDesktopGroupResponse:
        """
        @summary Releases a desktop group.
        
        @description    Before you delete a desktop group, make sure that cloud desktops in the desktop group are not connected and no users are authorized to use the cloud desktops.
        You cannot delete a subscription desktop group when cloud desktops in the group are in valid period.
        If you delete a pay-as-you-go desktop group, cloud desktops in the group are deleted.
        
        @param request: DeleteDesktopGroupRequest
        @return: DeleteDesktopGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_desktop_group_with_options(request, runtime)

    async def delete_desktop_group_async(
        self,
        request: ecd_20200930_models.DeleteDesktopGroupRequest,
    ) -> ecd_20200930_models.DeleteDesktopGroupResponse:
        """
        @summary Releases a desktop group.
        
        @description    Before you delete a desktop group, make sure that cloud desktops in the desktop group are not connected and no users are authorized to use the cloud desktops.
        You cannot delete a subscription desktop group when cloud desktops in the group are in valid period.
        If you delete a pay-as-you-go desktop group, cloud desktops in the group are deleted.
        
        @param request: DeleteDesktopGroupRequest
        @return: DeleteDesktopGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_desktop_group_with_options_async(request, runtime)

    def delete_desktops_with_options(
        self,
        request: ecd_20200930_models.DeleteDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteDesktopsResponse:
        """
        @summary Releases pay-as-you-go cloud computers or expired subscription cloud computers.
        
        @param request: DeleteDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDesktopsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDesktopsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDesktopsResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_desktops_with_options_async(
        self,
        request: ecd_20200930_models.DeleteDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteDesktopsResponse:
        """
        @summary Releases pay-as-you-go cloud computers or expired subscription cloud computers.
        
        @param request: DeleteDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDesktopsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDesktopsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDesktopsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_desktops(
        self,
        request: ecd_20200930_models.DeleteDesktopsRequest,
    ) -> ecd_20200930_models.DeleteDesktopsResponse:
        """
        @summary Releases pay-as-you-go cloud computers or expired subscription cloud computers.
        
        @param request: DeleteDesktopsRequest
        @return: DeleteDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_desktops_with_options(request, runtime)

    async def delete_desktops_async(
        self,
        request: ecd_20200930_models.DeleteDesktopsRequest,
    ) -> ecd_20200930_models.DeleteDesktopsResponse:
        """
        @summary Releases pay-as-you-go cloud computers or expired subscription cloud computers.
        
        @param request: DeleteDesktopsRequest
        @return: DeleteDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_desktops_with_options_async(request, runtime)

    def delete_devices_with_options(
        self,
        request: ecd_20200930_models.DeleteDevicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteDevicesResponse:
        """
        @summary Deletes trusted devices.
        
        @description You can call the operation to manage client devices.
        
        @param request: DeleteDevicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDevicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.device_ids):
            query['DeviceIds'] = request.device_ids
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDevices',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDevicesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDevicesResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_devices_with_options_async(
        self,
        request: ecd_20200930_models.DeleteDevicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteDevicesResponse:
        """
        @summary Deletes trusted devices.
        
        @description You can call the operation to manage client devices.
        
        @param request: DeleteDevicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDevicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.device_ids):
            query['DeviceIds'] = request.device_ids
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDevices',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDevicesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDevicesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_devices(
        self,
        request: ecd_20200930_models.DeleteDevicesRequest,
    ) -> ecd_20200930_models.DeleteDevicesResponse:
        """
        @summary Deletes trusted devices.
        
        @description You can call the operation to manage client devices.
        
        @param request: DeleteDevicesRequest
        @return: DeleteDevicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_devices_with_options(request, runtime)

    async def delete_devices_async(
        self,
        request: ecd_20200930_models.DeleteDevicesRequest,
    ) -> ecd_20200930_models.DeleteDevicesResponse:
        """
        @summary Deletes trusted devices.
        
        @description You can call the operation to manage client devices.
        
        @param request: DeleteDevicesRequest
        @return: DeleteDevicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_devices_with_options_async(request, runtime)

    def delete_directories_with_options(
        self,
        request: ecd_20200930_models.DeleteDirectoriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteDirectoriesResponse:
        """
        @summary Deletes one or more directories.
        
        @description You cannot delete a directory that has a cloud computer or is used by a cloud computer.
        
        @param request: DeleteDirectoriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDirectoriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDirectories',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDirectoriesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDirectoriesResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_directories_with_options_async(
        self,
        request: ecd_20200930_models.DeleteDirectoriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteDirectoriesResponse:
        """
        @summary Deletes one or more directories.
        
        @description You cannot delete a directory that has a cloud computer or is used by a cloud computer.
        
        @param request: DeleteDirectoriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDirectoriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDirectories',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDirectoriesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteDirectoriesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_directories(
        self,
        request: ecd_20200930_models.DeleteDirectoriesRequest,
    ) -> ecd_20200930_models.DeleteDirectoriesResponse:
        """
        @summary Deletes one or more directories.
        
        @description You cannot delete a directory that has a cloud computer or is used by a cloud computer.
        
        @param request: DeleteDirectoriesRequest
        @return: DeleteDirectoriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_directories_with_options(request, runtime)

    async def delete_directories_async(
        self,
        request: ecd_20200930_models.DeleteDirectoriesRequest,
    ) -> ecd_20200930_models.DeleteDirectoriesResponse:
        """
        @summary Deletes one or more directories.
        
        @description You cannot delete a directory that has a cloud computer or is used by a cloud computer.
        
        @param request: DeleteDirectoriesRequest
        @return: DeleteDirectoriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_directories_with_options_async(request, runtime)

    def delete_edu_room_with_options(
        self,
        request: ecd_20200930_models.DeleteEduRoomRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteEduRoomResponse:
        """
        @param request: DeleteEduRoomRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEduRoomResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.edu_room_id):
            query['EduRoomId'] = request.edu_room_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEduRoom',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteEduRoomResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteEduRoomResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_edu_room_with_options_async(
        self,
        request: ecd_20200930_models.DeleteEduRoomRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteEduRoomResponse:
        """
        @param request: DeleteEduRoomRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEduRoomResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.edu_room_id):
            query['EduRoomId'] = request.edu_room_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEduRoom',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteEduRoomResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteEduRoomResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_edu_room(
        self,
        request: ecd_20200930_models.DeleteEduRoomRequest,
    ) -> ecd_20200930_models.DeleteEduRoomResponse:
        """
        @param request: DeleteEduRoomRequest
        @return: DeleteEduRoomResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_edu_room_with_options(request, runtime)

    async def delete_edu_room_async(
        self,
        request: ecd_20200930_models.DeleteEduRoomRequest,
    ) -> ecd_20200930_models.DeleteEduRoomResponse:
        """
        @param request: DeleteEduRoomRequest
        @return: DeleteEduRoomResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_edu_room_with_options_async(request, runtime)

    def delete_images_with_options(
        self,
        request: ecd_20200930_models.DeleteImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteImagesResponse:
        """
        @summary Deletes one or more custom images.
        
        @description    Images include system images and custom images. System images cannot be deleted.
        If an image that you want to delete is referenced by a cloud computer template, call the [DeleteBundles](https://help.aliyun.com/document_detail/436972.html) operation to delete the cloud computer template before you delete the image.
        
        @param request: DeleteImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_cascaded_bundle):
            query['DeleteCascadedBundle'] = request.delete_cascaded_bundle
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImages',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteImagesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteImagesResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_images_with_options_async(
        self,
        request: ecd_20200930_models.DeleteImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteImagesResponse:
        """
        @summary Deletes one or more custom images.
        
        @description    Images include system images and custom images. System images cannot be deleted.
        If an image that you want to delete is referenced by a cloud computer template, call the [DeleteBundles](https://help.aliyun.com/document_detail/436972.html) operation to delete the cloud computer template before you delete the image.
        
        @param request: DeleteImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_cascaded_bundle):
            query['DeleteCascadedBundle'] = request.delete_cascaded_bundle
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImages',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteImagesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteImagesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_images(
        self,
        request: ecd_20200930_models.DeleteImagesRequest,
    ) -> ecd_20200930_models.DeleteImagesResponse:
        """
        @summary Deletes one or more custom images.
        
        @description    Images include system images and custom images. System images cannot be deleted.
        If an image that you want to delete is referenced by a cloud computer template, call the [DeleteBundles](https://help.aliyun.com/document_detail/436972.html) operation to delete the cloud computer template before you delete the image.
        
        @param request: DeleteImagesRequest
        @return: DeleteImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_images_with_options(request, runtime)

    async def delete_images_async(
        self,
        request: ecd_20200930_models.DeleteImagesRequest,
    ) -> ecd_20200930_models.DeleteImagesResponse:
        """
        @summary Deletes one or more custom images.
        
        @description    Images include system images and custom images. System images cannot be deleted.
        If an image that you want to delete is referenced by a cloud computer template, call the [DeleteBundles](https://help.aliyun.com/document_detail/436972.html) operation to delete the cloud computer template before you delete the image.
        
        @param request: DeleteImagesRequest
        @return: DeleteImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_images_with_options_async(request, runtime)

    def delete_nasfile_systems_with_options(
        self,
        request: ecd_20200930_models.DeleteNASFileSystemsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteNASFileSystemsResponse:
        """
        @summary Deletes NAS file systems.
        
        @description Before you delete a File Storage NAS (NAS) file system, make sure that the data you want to retain is backed up.
        >Warning: If a NAS file system is deleted, data stored in the NAS file system cannot be restored. Proceed with caution when you delete NAS file systems.
        
        @param request: DeleteNASFileSystemsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNASFileSystemsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNASFileSystems',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteNASFileSystemsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteNASFileSystemsResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_nasfile_systems_with_options_async(
        self,
        request: ecd_20200930_models.DeleteNASFileSystemsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteNASFileSystemsResponse:
        """
        @summary Deletes NAS file systems.
        
        @description Before you delete a File Storage NAS (NAS) file system, make sure that the data you want to retain is backed up.
        >Warning: If a NAS file system is deleted, data stored in the NAS file system cannot be restored. Proceed with caution when you delete NAS file systems.
        
        @param request: DeleteNASFileSystemsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNASFileSystemsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNASFileSystems',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteNASFileSystemsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteNASFileSystemsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_nasfile_systems(
        self,
        request: ecd_20200930_models.DeleteNASFileSystemsRequest,
    ) -> ecd_20200930_models.DeleteNASFileSystemsResponse:
        """
        @summary Deletes NAS file systems.
        
        @description Before you delete a File Storage NAS (NAS) file system, make sure that the data you want to retain is backed up.
        >Warning: If a NAS file system is deleted, data stored in the NAS file system cannot be restored. Proceed with caution when you delete NAS file systems.
        
        @param request: DeleteNASFileSystemsRequest
        @return: DeleteNASFileSystemsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nasfile_systems_with_options(request, runtime)

    async def delete_nasfile_systems_async(
        self,
        request: ecd_20200930_models.DeleteNASFileSystemsRequest,
    ) -> ecd_20200930_models.DeleteNASFileSystemsResponse:
        """
        @summary Deletes NAS file systems.
        
        @description Before you delete a File Storage NAS (NAS) file system, make sure that the data you want to retain is backed up.
        >Warning: If a NAS file system is deleted, data stored in the NAS file system cannot be restored. Proceed with caution when you delete NAS file systems.
        
        @param request: DeleteNASFileSystemsRequest
        @return: DeleteNASFileSystemsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nasfile_systems_with_options_async(request, runtime)

    def delete_network_packages_with_options(
        self,
        request: ecd_20200930_models.DeleteNetworkPackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteNetworkPackagesResponse:
        """
        @summary Deletes one or more premium bandwidth plans.
        
        @param request: DeleteNetworkPackagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkPackagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_package_id):
            query['NetworkPackageId'] = request.network_package_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkPackages',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteNetworkPackagesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteNetworkPackagesResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_network_packages_with_options_async(
        self,
        request: ecd_20200930_models.DeleteNetworkPackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteNetworkPackagesResponse:
        """
        @summary Deletes one or more premium bandwidth plans.
        
        @param request: DeleteNetworkPackagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkPackagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_package_id):
            query['NetworkPackageId'] = request.network_package_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkPackages',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteNetworkPackagesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteNetworkPackagesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_network_packages(
        self,
        request: ecd_20200930_models.DeleteNetworkPackagesRequest,
    ) -> ecd_20200930_models.DeleteNetworkPackagesResponse:
        """
        @summary Deletes one or more premium bandwidth plans.
        
        @param request: DeleteNetworkPackagesRequest
        @return: DeleteNetworkPackagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_network_packages_with_options(request, runtime)

    async def delete_network_packages_async(
        self,
        request: ecd_20200930_models.DeleteNetworkPackagesRequest,
    ) -> ecd_20200930_models.DeleteNetworkPackagesResponse:
        """
        @summary Deletes one or more premium bandwidth plans.
        
        @param request: DeleteNetworkPackagesRequest
        @return: DeleteNetworkPackagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_packages_with_options_async(request, runtime)

    def delete_office_sites_with_options(
        self,
        request: ecd_20200930_models.DeleteOfficeSitesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteOfficeSitesResponse:
        """
        @summary Deletes office networks (formerly workspaces).
        
        @description Before you delete an office network, make sure that the following operations are complete:
        All cloud computers in the office network are released.
        The data that you want to retain is backed up.
        >  Resources and data on cloud computers in an office network cannot be restored after you delete it. Proceed with caution.
        
        @param request: DeleteOfficeSitesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteOfficeSitesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteOfficeSites',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteOfficeSitesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteOfficeSitesResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_office_sites_with_options_async(
        self,
        request: ecd_20200930_models.DeleteOfficeSitesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteOfficeSitesResponse:
        """
        @summary Deletes office networks (formerly workspaces).
        
        @description Before you delete an office network, make sure that the following operations are complete:
        All cloud computers in the office network are released.
        The data that you want to retain is backed up.
        >  Resources and data on cloud computers in an office network cannot be restored after you delete it. Proceed with caution.
        
        @param request: DeleteOfficeSitesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteOfficeSitesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteOfficeSites',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteOfficeSitesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteOfficeSitesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_office_sites(
        self,
        request: ecd_20200930_models.DeleteOfficeSitesRequest,
    ) -> ecd_20200930_models.DeleteOfficeSitesResponse:
        """
        @summary Deletes office networks (formerly workspaces).
        
        @description Before you delete an office network, make sure that the following operations are complete:
        All cloud computers in the office network are released.
        The data that you want to retain is backed up.
        >  Resources and data on cloud computers in an office network cannot be restored after you delete it. Proceed with caution.
        
        @param request: DeleteOfficeSitesRequest
        @return: DeleteOfficeSitesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_office_sites_with_options(request, runtime)

    async def delete_office_sites_async(
        self,
        request: ecd_20200930_models.DeleteOfficeSitesRequest,
    ) -> ecd_20200930_models.DeleteOfficeSitesResponse:
        """
        @summary Deletes office networks (formerly workspaces).
        
        @description Before you delete an office network, make sure that the following operations are complete:
        All cloud computers in the office network are released.
        The data that you want to retain is backed up.
        >  Resources and data on cloud computers in an office network cannot be restored after you delete it. Proceed with caution.
        
        @param request: DeleteOfficeSitesRequest
        @return: DeleteOfficeSitesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_office_sites_with_options_async(request, runtime)

    def delete_policy_groups_with_options(
        self,
        request: ecd_20200930_models.DeletePolicyGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeletePolicyGroupsResponse:
        """
        @summary Deletes one or more custom cloud computer policies.
        
        @description    You cannot delete the cloud computer policy created by the Elastic Desktop Service (EDS) system.
        You cannot delete the cloud computer policies that are associated with cloud computers.
        
        @param request: DeletePolicyGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePolicyGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePolicyGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeletePolicyGroupsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeletePolicyGroupsResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_policy_groups_with_options_async(
        self,
        request: ecd_20200930_models.DeletePolicyGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeletePolicyGroupsResponse:
        """
        @summary Deletes one or more custom cloud computer policies.
        
        @description    You cannot delete the cloud computer policy created by the Elastic Desktop Service (EDS) system.
        You cannot delete the cloud computer policies that are associated with cloud computers.
        
        @param request: DeletePolicyGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePolicyGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePolicyGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeletePolicyGroupsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeletePolicyGroupsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_policy_groups(
        self,
        request: ecd_20200930_models.DeletePolicyGroupsRequest,
    ) -> ecd_20200930_models.DeletePolicyGroupsResponse:
        """
        @summary Deletes one or more custom cloud computer policies.
        
        @description    You cannot delete the cloud computer policy created by the Elastic Desktop Service (EDS) system.
        You cannot delete the cloud computer policies that are associated with cloud computers.
        
        @param request: DeletePolicyGroupsRequest
        @return: DeletePolicyGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_policy_groups_with_options(request, runtime)

    async def delete_policy_groups_async(
        self,
        request: ecd_20200930_models.DeletePolicyGroupsRequest,
    ) -> ecd_20200930_models.DeletePolicyGroupsResponse:
        """
        @summary Deletes one or more custom cloud computer policies.
        
        @description    You cannot delete the cloud computer policy created by the Elastic Desktop Service (EDS) system.
        You cannot delete the cloud computer policies that are associated with cloud computers.
        
        @param request: DeletePolicyGroupsRequest
        @return: DeletePolicyGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_policy_groups_with_options_async(request, runtime)

    def delete_snapshot_with_options(
        self,
        request: ecd_20200930_models.DeleteSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteSnapshotResponse:
        """
        @summary Deletes one or more snapshots.
        
        @description If the IDs of the snapshots that you specify do not exist, requests are ignored.
        
        @param request: DeleteSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshot',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteSnapshotResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteSnapshotResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_snapshot_with_options_async(
        self,
        request: ecd_20200930_models.DeleteSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteSnapshotResponse:
        """
        @summary Deletes one or more snapshots.
        
        @description If the IDs of the snapshots that you specify do not exist, requests are ignored.
        
        @param request: DeleteSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshot',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteSnapshotResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteSnapshotResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_snapshot(
        self,
        request: ecd_20200930_models.DeleteSnapshotRequest,
    ) -> ecd_20200930_models.DeleteSnapshotResponse:
        """
        @summary Deletes one or more snapshots.
        
        @description If the IDs of the snapshots that you specify do not exist, requests are ignored.
        
        @param request: DeleteSnapshotRequest
        @return: DeleteSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_snapshot_with_options(request, runtime)

    async def delete_snapshot_async(
        self,
        request: ecd_20200930_models.DeleteSnapshotRequest,
    ) -> ecd_20200930_models.DeleteSnapshotResponse:
        """
        @summary Deletes one or more snapshots.
        
        @description If the IDs of the snapshots that you specify do not exist, requests are ignored.
        
        @param request: DeleteSnapshotRequest
        @return: DeleteSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_snapshot_with_options_async(request, runtime)

    def delete_virtual_mfadevice_with_options(
        self,
        request: ecd_20200930_models.DeleteVirtualMFADeviceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteVirtualMFADeviceResponse:
        """
        @summary Delete virtual multi-factor authentication (MFA) devices.
        
        @description If an MFA device is deleted, the device is unbound, reset, and disabled. When an Active Directory (AD) user wants to connect to the cloud desktop that is bound to the MFA device, the AD user must bind a new MFA device.
        
        @param request: DeleteVirtualMFADeviceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVirtualMFADeviceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.serial_number):
            query['SerialNumber'] = request.serial_number
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVirtualMFADevice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteVirtualMFADeviceResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteVirtualMFADeviceResponse(),
                self.execute(params, req, runtime)
            )

    async def delete_virtual_mfadevice_with_options_async(
        self,
        request: ecd_20200930_models.DeleteVirtualMFADeviceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DeleteVirtualMFADeviceResponse:
        """
        @summary Delete virtual multi-factor authentication (MFA) devices.
        
        @description If an MFA device is deleted, the device is unbound, reset, and disabled. When an Active Directory (AD) user wants to connect to the cloud desktop that is bound to the MFA device, the AD user must bind a new MFA device.
        
        @param request: DeleteVirtualMFADeviceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVirtualMFADeviceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.serial_number):
            query['SerialNumber'] = request.serial_number
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVirtualMFADevice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DeleteVirtualMFADeviceResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DeleteVirtualMFADeviceResponse(),
                await self.execute_async(params, req, runtime)
            )

    def delete_virtual_mfadevice(
        self,
        request: ecd_20200930_models.DeleteVirtualMFADeviceRequest,
    ) -> ecd_20200930_models.DeleteVirtualMFADeviceResponse:
        """
        @summary Delete virtual multi-factor authentication (MFA) devices.
        
        @description If an MFA device is deleted, the device is unbound, reset, and disabled. When an Active Directory (AD) user wants to connect to the cloud desktop that is bound to the MFA device, the AD user must bind a new MFA device.
        
        @param request: DeleteVirtualMFADeviceRequest
        @return: DeleteVirtualMFADeviceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_virtual_mfadevice_with_options(request, runtime)

    async def delete_virtual_mfadevice_async(
        self,
        request: ecd_20200930_models.DeleteVirtualMFADeviceRequest,
    ) -> ecd_20200930_models.DeleteVirtualMFADeviceResponse:
        """
        @summary Delete virtual multi-factor authentication (MFA) devices.
        
        @description If an MFA device is deleted, the device is unbound, reset, and disabled. When an Active Directory (AD) user wants to connect to the cloud desktop that is bound to the MFA device, the AD user must bind a new MFA device.
        
        @param request: DeleteVirtualMFADeviceRequest
        @return: DeleteVirtualMFADeviceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_virtual_mfadevice_with_options_async(request, runtime)

    def describe_acl_entries_with_options(
        self,
        request: ecd_20200930_models.DescribeAclEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeAclEntriesResponse:
        """
        @summary Queries the details of an access control list (ACL) of an office network or a cloud computer.
        
        @param request: DescribeAclEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclEntries',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeAclEntriesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeAclEntriesResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_acl_entries_with_options_async(
        self,
        request: ecd_20200930_models.DescribeAclEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeAclEntriesResponse:
        """
        @summary Queries the details of an access control list (ACL) of an office network or a cloud computer.
        
        @param request: DescribeAclEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclEntries',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeAclEntriesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeAclEntriesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_acl_entries(
        self,
        request: ecd_20200930_models.DescribeAclEntriesRequest,
    ) -> ecd_20200930_models.DescribeAclEntriesResponse:
        """
        @summary Queries the details of an access control list (ACL) of an office network or a cloud computer.
        
        @param request: DescribeAclEntriesRequest
        @return: DescribeAclEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_acl_entries_with_options(request, runtime)

    async def describe_acl_entries_async(
        self,
        request: ecd_20200930_models.DescribeAclEntriesRequest,
    ) -> ecd_20200930_models.DescribeAclEntriesResponse:
        """
        @summary Queries the details of an access control list (ACL) of an office network or a cloud computer.
        
        @param request: DescribeAclEntriesRequest
        @return: DescribeAclEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_acl_entries_with_options_async(request, runtime)

    def describe_auto_snapshot_policy_with_options(
        self,
        request: ecd_20200930_models.DescribeAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeAutoSnapshotPolicyResponse:
        """
        @summary Queries the automatic snapshot policy.
        
        @description You can view an automatic snapshot policy that is associated with a cloud desktop in the Elastic Desktop Service (EDS) console. To view the automatic snapshot policy, you can go to the EDS console, choose Deployment > Snapshots in the left-side navigation pane, and then view an automatic snapshot policy on the Snapshots page.
        
        @param request: DescribeAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeAutoSnapshotPolicyResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeAutoSnapshotPolicyResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_auto_snapshot_policy_with_options_async(
        self,
        request: ecd_20200930_models.DescribeAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeAutoSnapshotPolicyResponse:
        """
        @summary Queries the automatic snapshot policy.
        
        @description You can view an automatic snapshot policy that is associated with a cloud desktop in the Elastic Desktop Service (EDS) console. To view the automatic snapshot policy, you can go to the EDS console, choose Deployment > Snapshots in the left-side navigation pane, and then view an automatic snapshot policy on the Snapshots page.
        
        @param request: DescribeAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeAutoSnapshotPolicyResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeAutoSnapshotPolicyResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_auto_snapshot_policy(
        self,
        request: ecd_20200930_models.DescribeAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.DescribeAutoSnapshotPolicyResponse:
        """
        @summary Queries the automatic snapshot policy.
        
        @description You can view an automatic snapshot policy that is associated with a cloud desktop in the Elastic Desktop Service (EDS) console. To view the automatic snapshot policy, you can go to the EDS console, choose Deployment > Snapshots in the left-side navigation pane, and then view an automatic snapshot policy on the Snapshots page.
        
        @param request: DescribeAutoSnapshotPolicyRequest
        @return: DescribeAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_auto_snapshot_policy_with_options(request, runtime)

    async def describe_auto_snapshot_policy_async(
        self,
        request: ecd_20200930_models.DescribeAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.DescribeAutoSnapshotPolicyResponse:
        """
        @summary Queries the automatic snapshot policy.
        
        @description You can view an automatic snapshot policy that is associated with a cloud desktop in the Elastic Desktop Service (EDS) console. To view the automatic snapshot policy, you can go to the EDS console, choose Deployment > Snapshots in the left-side navigation pane, and then view an automatic snapshot policy on the Snapshots page.
        
        @param request: DescribeAutoSnapshotPolicyRequest
        @return: DescribeAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_auto_snapshot_policy_with_options_async(request, runtime)

    def describe_bundles_with_options(
        self,
        request: ecd_20200930_models.DescribeBundlesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeBundlesResponse:
        """
        @summary Queries the details of cloud computer templates.
        
        @param request: DescribeBundlesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBundlesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.bundle_type):
            query['BundleType'] = request.bundle_type
        if not UtilClient.is_unset(request.check_stock):
            query['CheckStock'] = request.check_stock
        if not UtilClient.is_unset(request.cpu_count):
            query['CpuCount'] = request.cpu_count
        if not UtilClient.is_unset(request.desktop_type_family):
            query['DesktopTypeFamily'] = request.desktop_type_family
        if not UtilClient.is_unset(request.fota_channel):
            query['FotaChannel'] = request.fota_channel
        if not UtilClient.is_unset(request.from_desktop_group):
            query['FromDesktopGroup'] = request.from_desktop_group
        if not UtilClient.is_unset(request.gpu_count):
            query['GpuCount'] = request.gpu_count
        if not UtilClient.is_unset(request.gpu_driver_type):
            query['GpuDriverType'] = request.gpu_driver_type
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.memory_size):
            query['MemorySize'] = request.memory_size
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.os_type):
            query['OsType'] = request.os_type
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.selected_bundle):
            query['SelectedBundle'] = request.selected_bundle
        if not UtilClient.is_unset(request.session_type):
            query['SessionType'] = request.session_type
        if not UtilClient.is_unset(request.support_multi_session):
            query['SupportMultiSession'] = request.support_multi_session
        if not UtilClient.is_unset(request.volume_encryption_enabled):
            query['VolumeEncryptionEnabled'] = request.volume_encryption_enabled
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBundles',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeBundlesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeBundlesResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_bundles_with_options_async(
        self,
        request: ecd_20200930_models.DescribeBundlesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeBundlesResponse:
        """
        @summary Queries the details of cloud computer templates.
        
        @param request: DescribeBundlesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBundlesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.bundle_type):
            query['BundleType'] = request.bundle_type
        if not UtilClient.is_unset(request.check_stock):
            query['CheckStock'] = request.check_stock
        if not UtilClient.is_unset(request.cpu_count):
            query['CpuCount'] = request.cpu_count
        if not UtilClient.is_unset(request.desktop_type_family):
            query['DesktopTypeFamily'] = request.desktop_type_family
        if not UtilClient.is_unset(request.fota_channel):
            query['FotaChannel'] = request.fota_channel
        if not UtilClient.is_unset(request.from_desktop_group):
            query['FromDesktopGroup'] = request.from_desktop_group
        if not UtilClient.is_unset(request.gpu_count):
            query['GpuCount'] = request.gpu_count
        if not UtilClient.is_unset(request.gpu_driver_type):
            query['GpuDriverType'] = request.gpu_driver_type
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.memory_size):
            query['MemorySize'] = request.memory_size
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.os_type):
            query['OsType'] = request.os_type
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.selected_bundle):
            query['SelectedBundle'] = request.selected_bundle
        if not UtilClient.is_unset(request.session_type):
            query['SessionType'] = request.session_type
        if not UtilClient.is_unset(request.support_multi_session):
            query['SupportMultiSession'] = request.support_multi_session
        if not UtilClient.is_unset(request.volume_encryption_enabled):
            query['VolumeEncryptionEnabled'] = request.volume_encryption_enabled
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBundles',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeBundlesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeBundlesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_bundles(
        self,
        request: ecd_20200930_models.DescribeBundlesRequest,
    ) -> ecd_20200930_models.DescribeBundlesResponse:
        """
        @summary Queries the details of cloud computer templates.
        
        @param request: DescribeBundlesRequest
        @return: DescribeBundlesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_bundles_with_options(request, runtime)

    async def describe_bundles_async(
        self,
        request: ecd_20200930_models.DescribeBundlesRequest,
    ) -> ecd_20200930_models.DescribeBundlesResponse:
        """
        @summary Queries the details of cloud computer templates.
        
        @param request: DescribeBundlesRequest
        @return: DescribeBundlesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_bundles_with_options_async(request, runtime)

    def describe_cds_file_share_links_with_options(
        self,
        request: ecd_20200930_models.DescribeCdsFileShareLinksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCdsFileShareLinksResponse:
        """
        @summary Queries file sharing links of a cloud disk in Cloud Drive Service.
        
        @param request: DescribeCdsFileShareLinksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCdsFileShareLinksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.creators):
            query['Creators'] = request.creators
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.share_id):
            query['ShareId'] = request.share_id
        if not UtilClient.is_unset(request.share_name):
            query['ShareName'] = request.share_name
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCdsFileShareLinks',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCdsFileShareLinksResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCdsFileShareLinksResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_cds_file_share_links_with_options_async(
        self,
        request: ecd_20200930_models.DescribeCdsFileShareLinksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCdsFileShareLinksResponse:
        """
        @summary Queries file sharing links of a cloud disk in Cloud Drive Service.
        
        @param request: DescribeCdsFileShareLinksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCdsFileShareLinksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.creators):
            query['Creators'] = request.creators
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.share_id):
            query['ShareId'] = request.share_id
        if not UtilClient.is_unset(request.share_name):
            query['ShareName'] = request.share_name
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCdsFileShareLinks',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCdsFileShareLinksResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCdsFileShareLinksResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_cds_file_share_links(
        self,
        request: ecd_20200930_models.DescribeCdsFileShareLinksRequest,
    ) -> ecd_20200930_models.DescribeCdsFileShareLinksResponse:
        """
        @summary Queries file sharing links of a cloud disk in Cloud Drive Service.
        
        @param request: DescribeCdsFileShareLinksRequest
        @return: DescribeCdsFileShareLinksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cds_file_share_links_with_options(request, runtime)

    async def describe_cds_file_share_links_async(
        self,
        request: ecd_20200930_models.DescribeCdsFileShareLinksRequest,
    ) -> ecd_20200930_models.DescribeCdsFileShareLinksResponse:
        """
        @summary Queries file sharing links of a cloud disk in Cloud Drive Service.
        
        @param request: DescribeCdsFileShareLinksRequest
        @return: DescribeCdsFileShareLinksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cds_file_share_links_with_options_async(request, runtime)

    def describe_cens_with_options(
        self,
        request: ecd_20200930_models.DescribeCensRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCensResponse:
        """
        @summary Queries the details of all Cloud Enterprise Network (CEN) instances within an Alibaba Cloud account.
        
        @param request: DescribeCensRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCensResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCens',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCensResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCensResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_cens_with_options_async(
        self,
        request: ecd_20200930_models.DescribeCensRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCensResponse:
        """
        @summary Queries the details of all Cloud Enterprise Network (CEN) instances within an Alibaba Cloud account.
        
        @param request: DescribeCensRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCensResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCens',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCensResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCensResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_cens(
        self,
        request: ecd_20200930_models.DescribeCensRequest,
    ) -> ecd_20200930_models.DescribeCensResponse:
        """
        @summary Queries the details of all Cloud Enterprise Network (CEN) instances within an Alibaba Cloud account.
        
        @param request: DescribeCensRequest
        @return: DescribeCensResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cens_with_options(request, runtime)

    async def describe_cens_async(
        self,
        request: ecd_20200930_models.DescribeCensRequest,
    ) -> ecd_20200930_models.DescribeCensResponse:
        """
        @summary Queries the details of all Cloud Enterprise Network (CEN) instances within an Alibaba Cloud account.
        
        @param request: DescribeCensRequest
        @return: DescribeCensResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cens_with_options_async(request, runtime)

    def describe_client_events_with_options(
        self,
        request: ecd_20200930_models.DescribeClientEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeClientEventsResponse:
        """
        @summary Queries the operation logs of end users. For example, the logs record the events that end users start and stop cloud desktops, and disconnect desktop sessions.
        
        @description You can audit the operation logs of regular users to improve security. The operation logs record events such as desktop startup, shutdown, and session disconnection.
        
        @param request: DescribeClientEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClientEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_ip):
            query['DesktopIp'] = request.desktop_ip
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.event_types):
            query['EventTypes'] = request.event_types
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientEvents',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeClientEventsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeClientEventsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_client_events_with_options_async(
        self,
        request: ecd_20200930_models.DescribeClientEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeClientEventsResponse:
        """
        @summary Queries the operation logs of end users. For example, the logs record the events that end users start and stop cloud desktops, and disconnect desktop sessions.
        
        @description You can audit the operation logs of regular users to improve security. The operation logs record events such as desktop startup, shutdown, and session disconnection.
        
        @param request: DescribeClientEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClientEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_ip):
            query['DesktopIp'] = request.desktop_ip
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.event_types):
            query['EventTypes'] = request.event_types
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientEvents',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeClientEventsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeClientEventsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_client_events(
        self,
        request: ecd_20200930_models.DescribeClientEventsRequest,
    ) -> ecd_20200930_models.DescribeClientEventsResponse:
        """
        @summary Queries the operation logs of end users. For example, the logs record the events that end users start and stop cloud desktops, and disconnect desktop sessions.
        
        @description You can audit the operation logs of regular users to improve security. The operation logs record events such as desktop startup, shutdown, and session disconnection.
        
        @param request: DescribeClientEventsRequest
        @return: DescribeClientEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_client_events_with_options(request, runtime)

    async def describe_client_events_async(
        self,
        request: ecd_20200930_models.DescribeClientEventsRequest,
    ) -> ecd_20200930_models.DescribeClientEventsResponse:
        """
        @summary Queries the operation logs of end users. For example, the logs record the events that end users start and stop cloud desktops, and disconnect desktop sessions.
        
        @description You can audit the operation logs of regular users to improve security. The operation logs record events such as desktop startup, shutdown, and session disconnection.
        
        @param request: DescribeClientEventsRequest
        @return: DescribeClientEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_client_events_with_options_async(request, runtime)

    def describe_cloud_drive_groups_with_options(
        self,
        request: ecd_20200930_models.DescribeCloudDriveGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCloudDriveGroupsResponse:
        """
        @summary Queries a list of authorized team spaces.
        
        @param request: DescribeCloudDriveGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudDriveGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.directory_name):
            query['DirectoryName'] = request.directory_name
        if not UtilClient.is_unset(request.drive_status):
            query['DriveStatus'] = request.drive_status
        if not UtilClient.is_unset(request.drive_type):
            query['DriveType'] = request.drive_type
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.group_type):
            query['GroupType'] = request.group_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.parent_group_id):
            query['ParentGroupId'] = request.parent_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudDriveGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDriveGroupsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDriveGroupsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_cloud_drive_groups_with_options_async(
        self,
        request: ecd_20200930_models.DescribeCloudDriveGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCloudDriveGroupsResponse:
        """
        @summary Queries a list of authorized team spaces.
        
        @param request: DescribeCloudDriveGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudDriveGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.directory_name):
            query['DirectoryName'] = request.directory_name
        if not UtilClient.is_unset(request.drive_status):
            query['DriveStatus'] = request.drive_status
        if not UtilClient.is_unset(request.drive_type):
            query['DriveType'] = request.drive_type
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.group_type):
            query['GroupType'] = request.group_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.parent_group_id):
            query['ParentGroupId'] = request.parent_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudDriveGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDriveGroupsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDriveGroupsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_cloud_drive_groups(
        self,
        request: ecd_20200930_models.DescribeCloudDriveGroupsRequest,
    ) -> ecd_20200930_models.DescribeCloudDriveGroupsResponse:
        """
        @summary Queries a list of authorized team spaces.
        
        @param request: DescribeCloudDriveGroupsRequest
        @return: DescribeCloudDriveGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_drive_groups_with_options(request, runtime)

    async def describe_cloud_drive_groups_async(
        self,
        request: ecd_20200930_models.DescribeCloudDriveGroupsRequest,
    ) -> ecd_20200930_models.DescribeCloudDriveGroupsResponse:
        """
        @summary Queries a list of authorized team spaces.
        
        @param request: DescribeCloudDriveGroupsRequest
        @return: DescribeCloudDriveGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_drive_groups_with_options_async(request, runtime)

    def describe_cloud_drive_permissions_with_options(
        self,
        request: ecd_20200930_models.DescribeCloudDrivePermissionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCloudDrivePermissionsResponse:
        """
        @summary 查询pds用户权限
        
        @param request: DescribeCloudDrivePermissionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudDrivePermissionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudDrivePermissions',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDrivePermissionsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDrivePermissionsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_cloud_drive_permissions_with_options_async(
        self,
        request: ecd_20200930_models.DescribeCloudDrivePermissionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCloudDrivePermissionsResponse:
        """
        @summary 查询pds用户权限
        
        @param request: DescribeCloudDrivePermissionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudDrivePermissionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudDrivePermissions',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDrivePermissionsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDrivePermissionsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_cloud_drive_permissions(
        self,
        request: ecd_20200930_models.DescribeCloudDrivePermissionsRequest,
    ) -> ecd_20200930_models.DescribeCloudDrivePermissionsResponse:
        """
        @summary 查询pds用户权限
        
        @param request: DescribeCloudDrivePermissionsRequest
        @return: DescribeCloudDrivePermissionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_drive_permissions_with_options(request, runtime)

    async def describe_cloud_drive_permissions_async(
        self,
        request: ecd_20200930_models.DescribeCloudDrivePermissionsRequest,
    ) -> ecd_20200930_models.DescribeCloudDrivePermissionsResponse:
        """
        @summary 查询pds用户权限
        
        @param request: DescribeCloudDrivePermissionsRequest
        @return: DescribeCloudDrivePermissionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_drive_permissions_with_options_async(request, runtime)

    def describe_cloud_drive_users_with_options(
        self,
        request: ecd_20200930_models.DescribeCloudDriveUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCloudDriveUsersResponse:
        """
        @summary 查询所有无影网盘终端用户的信息
        
        @param request: DescribeCloudDriveUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudDriveUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudDriveUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDriveUsersResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDriveUsersResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_cloud_drive_users_with_options_async(
        self,
        request: ecd_20200930_models.DescribeCloudDriveUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCloudDriveUsersResponse:
        """
        @summary 查询所有无影网盘终端用户的信息
        
        @param request: DescribeCloudDriveUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudDriveUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudDriveUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDriveUsersResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCloudDriveUsersResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_cloud_drive_users(
        self,
        request: ecd_20200930_models.DescribeCloudDriveUsersRequest,
    ) -> ecd_20200930_models.DescribeCloudDriveUsersResponse:
        """
        @summary 查询所有无影网盘终端用户的信息
        
        @param request: DescribeCloudDriveUsersRequest
        @return: DescribeCloudDriveUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_drive_users_with_options(request, runtime)

    async def describe_cloud_drive_users_async(
        self,
        request: ecd_20200930_models.DescribeCloudDriveUsersRequest,
    ) -> ecd_20200930_models.DescribeCloudDriveUsersResponse:
        """
        @summary 查询所有无影网盘终端用户的信息
        
        @param request: DescribeCloudDriveUsersRequest
        @return: DescribeCloudDriveUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_drive_users_with_options_async(request, runtime)

    def describe_config_group_with_options(
        self,
        request: ecd_20200930_models.DescribeConfigGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeConfigGroupResponse:
        """
        @summary Queries configuration groups.
        
        @param request: DescribeConfigGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeConfigGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.group_ids):
            query['GroupIds'] = request.group_ids
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.product_type):
            query['ProductType'] = request.product_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.statuses):
            query['Statuses'] = request.statuses
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeConfigGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeConfigGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeConfigGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_config_group_with_options_async(
        self,
        request: ecd_20200930_models.DescribeConfigGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeConfigGroupResponse:
        """
        @summary Queries configuration groups.
        
        @param request: DescribeConfigGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeConfigGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.group_ids):
            query['GroupIds'] = request.group_ids
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.product_type):
            query['ProductType'] = request.product_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.statuses):
            query['Statuses'] = request.statuses
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeConfigGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeConfigGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeConfigGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_config_group(
        self,
        request: ecd_20200930_models.DescribeConfigGroupRequest,
    ) -> ecd_20200930_models.DescribeConfigGroupResponse:
        """
        @summary Queries configuration groups.
        
        @param request: DescribeConfigGroupRequest
        @return: DescribeConfigGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_config_group_with_options(request, runtime)

    async def describe_config_group_async(
        self,
        request: ecd_20200930_models.DescribeConfigGroupRequest,
    ) -> ecd_20200930_models.DescribeConfigGroupResponse:
        """
        @summary Queries configuration groups.
        
        @param request: DescribeConfigGroupRequest
        @return: DescribeConfigGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_config_group_with_options_async(request, runtime)

    def describe_customized_list_headers_with_options(
        self,
        request: ecd_20200930_models.DescribeCustomizedListHeadersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCustomizedListHeadersResponse:
        """
        @param request: DescribeCustomizedListHeadersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCustomizedListHeadersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang_type):
            query['LangType'] = request.lang_type
        if not UtilClient.is_unset(request.list_type):
            query['ListType'] = request.list_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCustomizedListHeaders',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCustomizedListHeadersResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCustomizedListHeadersResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_customized_list_headers_with_options_async(
        self,
        request: ecd_20200930_models.DescribeCustomizedListHeadersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeCustomizedListHeadersResponse:
        """
        @param request: DescribeCustomizedListHeadersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCustomizedListHeadersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang_type):
            query['LangType'] = request.lang_type
        if not UtilClient.is_unset(request.list_type):
            query['ListType'] = request.list_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCustomizedListHeaders',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCustomizedListHeadersResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeCustomizedListHeadersResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_customized_list_headers(
        self,
        request: ecd_20200930_models.DescribeCustomizedListHeadersRequest,
    ) -> ecd_20200930_models.DescribeCustomizedListHeadersResponse:
        """
        @param request: DescribeCustomizedListHeadersRequest
        @return: DescribeCustomizedListHeadersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_customized_list_headers_with_options(request, runtime)

    async def describe_customized_list_headers_async(
        self,
        request: ecd_20200930_models.DescribeCustomizedListHeadersRequest,
    ) -> ecd_20200930_models.DescribeCustomizedListHeadersResponse:
        """
        @param request: DescribeCustomizedListHeadersRequest
        @return: DescribeCustomizedListHeadersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_customized_list_headers_with_options_async(request, runtime)

    def describe_desktop_group_sessions_with_options(
        self,
        request: ecd_20200930_models.DescribeDesktopGroupSessionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopGroupSessionsResponse:
        """
        @summary Queries sessions in a desktop group.
        
        @param request: DescribeDesktopGroupSessionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopGroupSessionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.own_type):
            query['OwnType'] = request.own_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.session_status):
            query['SessionStatus'] = request.session_status
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopGroupSessions',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopGroupSessionsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopGroupSessionsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_desktop_group_sessions_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDesktopGroupSessionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopGroupSessionsResponse:
        """
        @summary Queries sessions in a desktop group.
        
        @param request: DescribeDesktopGroupSessionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopGroupSessionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.own_type):
            query['OwnType'] = request.own_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.session_status):
            query['SessionStatus'] = request.session_status
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopGroupSessions',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopGroupSessionsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopGroupSessionsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_desktop_group_sessions(
        self,
        request: ecd_20200930_models.DescribeDesktopGroupSessionsRequest,
    ) -> ecd_20200930_models.DescribeDesktopGroupSessionsResponse:
        """
        @summary Queries sessions in a desktop group.
        
        @param request: DescribeDesktopGroupSessionsRequest
        @return: DescribeDesktopGroupSessionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_desktop_group_sessions_with_options(request, runtime)

    async def describe_desktop_group_sessions_async(
        self,
        request: ecd_20200930_models.DescribeDesktopGroupSessionsRequest,
    ) -> ecd_20200930_models.DescribeDesktopGroupSessionsResponse:
        """
        @summary Queries sessions in a desktop group.
        
        @param request: DescribeDesktopGroupSessionsRequest
        @return: DescribeDesktopGroupSessionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_desktop_group_sessions_with_options_async(request, runtime)

    def describe_desktop_groups_with_options(
        self,
        request: ecd_20200930_models.DescribeDesktopGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopGroupsResponse:
        """
        @summary Queries a list of desktop groups.
        
        @param request: DescribeDesktopGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_group_ids):
            query['DesktopGroupIds'] = request.desktop_group_ids
        if not UtilClient.is_unset(request.desktop_group_name):
            query['DesktopGroupName'] = request.desktop_group_name
        if not UtilClient.is_unset(request.end_user_ids):
            query['EndUserIds'] = request.end_user_ids
        if not UtilClient.is_unset(request.excluded_end_user_ids):
            query['ExcludedEndUserIds'] = request.excluded_end_user_ids
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.multi_resource):
            query['MultiResource'] = request.multi_resource
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.own_type):
            query['OwnType'] = request.own_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopGroupsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopGroupsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_desktop_groups_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDesktopGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopGroupsResponse:
        """
        @summary Queries a list of desktop groups.
        
        @param request: DescribeDesktopGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_group_ids):
            query['DesktopGroupIds'] = request.desktop_group_ids
        if not UtilClient.is_unset(request.desktop_group_name):
            query['DesktopGroupName'] = request.desktop_group_name
        if not UtilClient.is_unset(request.end_user_ids):
            query['EndUserIds'] = request.end_user_ids
        if not UtilClient.is_unset(request.excluded_end_user_ids):
            query['ExcludedEndUserIds'] = request.excluded_end_user_ids
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.multi_resource):
            query['MultiResource'] = request.multi_resource
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.own_type):
            query['OwnType'] = request.own_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopGroupsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopGroupsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_desktop_groups(
        self,
        request: ecd_20200930_models.DescribeDesktopGroupsRequest,
    ) -> ecd_20200930_models.DescribeDesktopGroupsResponse:
        """
        @summary Queries a list of desktop groups.
        
        @param request: DescribeDesktopGroupsRequest
        @return: DescribeDesktopGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_desktop_groups_with_options(request, runtime)

    async def describe_desktop_groups_async(
        self,
        request: ecd_20200930_models.DescribeDesktopGroupsRequest,
    ) -> ecd_20200930_models.DescribeDesktopGroupsResponse:
        """
        @summary Queries a list of desktop groups.
        
        @param request: DescribeDesktopGroupsRequest
        @return: DescribeDesktopGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_desktop_groups_with_options_async(request, runtime)

    def describe_desktop_info_with_options(
        self,
        request: ecd_20200930_models.DescribeDesktopInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopInfoResponse:
        """
        @summary Queries the basic information about cloud computers.
        
        @param request: DescribeDesktopInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopInfo',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopInfoResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopInfoResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_desktop_info_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDesktopInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopInfoResponse:
        """
        @summary Queries the basic information about cloud computers.
        
        @param request: DescribeDesktopInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopInfo',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopInfoResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopInfoResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_desktop_info(
        self,
        request: ecd_20200930_models.DescribeDesktopInfoRequest,
    ) -> ecd_20200930_models.DescribeDesktopInfoResponse:
        """
        @summary Queries the basic information about cloud computers.
        
        @param request: DescribeDesktopInfoRequest
        @return: DescribeDesktopInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_desktop_info_with_options(request, runtime)

    async def describe_desktop_info_async(
        self,
        request: ecd_20200930_models.DescribeDesktopInfoRequest,
    ) -> ecd_20200930_models.DescribeDesktopInfoResponse:
        """
        @summary Queries the basic information about cloud computers.
        
        @param request: DescribeDesktopInfoRequest
        @return: DescribeDesktopInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_desktop_info_with_options_async(request, runtime)

    def describe_desktop_oversold_group_with_options(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopOversoldGroupResponse:
        """
        @summary 查询超卖组
        
        @param request: DescribeDesktopOversoldGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopOversoldGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oversold_group_ids):
            query['OversoldGroupIds'] = request.oversold_group_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopOversoldGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_desktop_oversold_group_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopOversoldGroupResponse:
        """
        @summary 查询超卖组
        
        @param request: DescribeDesktopOversoldGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopOversoldGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oversold_group_ids):
            query['OversoldGroupIds'] = request.oversold_group_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopOversoldGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_desktop_oversold_group(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldGroupRequest,
    ) -> ecd_20200930_models.DescribeDesktopOversoldGroupResponse:
        """
        @summary 查询超卖组
        
        @param request: DescribeDesktopOversoldGroupRequest
        @return: DescribeDesktopOversoldGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_desktop_oversold_group_with_options(request, runtime)

    async def describe_desktop_oversold_group_async(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldGroupRequest,
    ) -> ecd_20200930_models.DescribeDesktopOversoldGroupResponse:
        """
        @summary 查询超卖组
        
        @param request: DescribeDesktopOversoldGroupRequest
        @return: DescribeDesktopOversoldGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_desktop_oversold_group_with_options_async(request, runtime)

    def describe_desktop_oversold_user_with_options(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopOversoldUserResponse:
        """
        @summary 查询超卖组用户
        
        @param request: DescribeDesktopOversoldUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopOversoldUserResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.user_desktop_ids):
            query['UserDesktopIds'] = request.user_desktop_ids
        if not UtilClient.is_unset(request.user_group_id):
            query['UserGroupId'] = request.user_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopOversoldUser',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldUserResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldUserResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_desktop_oversold_user_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopOversoldUserResponse:
        """
        @summary 查询超卖组用户
        
        @param request: DescribeDesktopOversoldUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopOversoldUserResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.user_desktop_ids):
            query['UserDesktopIds'] = request.user_desktop_ids
        if not UtilClient.is_unset(request.user_group_id):
            query['UserGroupId'] = request.user_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopOversoldUser',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldUserResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldUserResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_desktop_oversold_user(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldUserRequest,
    ) -> ecd_20200930_models.DescribeDesktopOversoldUserResponse:
        """
        @summary 查询超卖组用户
        
        @param request: DescribeDesktopOversoldUserRequest
        @return: DescribeDesktopOversoldUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_desktop_oversold_user_with_options(request, runtime)

    async def describe_desktop_oversold_user_async(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldUserRequest,
    ) -> ecd_20200930_models.DescribeDesktopOversoldUserResponse:
        """
        @summary 查询超卖组用户
        
        @param request: DescribeDesktopOversoldUserRequest
        @return: DescribeDesktopOversoldUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_desktop_oversold_user_with_options_async(request, runtime)

    def describe_desktop_oversold_user_group_with_options(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldUserGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopOversoldUserGroupResponse:
        """
        @summary 查询超卖用户组
        
        @param request: DescribeDesktopOversoldUserGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopOversoldUserGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.user_group_ids):
            query['UserGroupIds'] = request.user_group_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopOversoldUserGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldUserGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldUserGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_desktop_oversold_user_group_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldUserGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopOversoldUserGroupResponse:
        """
        @summary 查询超卖用户组
        
        @param request: DescribeDesktopOversoldUserGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopOversoldUserGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.user_group_ids):
            query['UserGroupIds'] = request.user_group_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopOversoldUserGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldUserGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopOversoldUserGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_desktop_oversold_user_group(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldUserGroupRequest,
    ) -> ecd_20200930_models.DescribeDesktopOversoldUserGroupResponse:
        """
        @summary 查询超卖用户组
        
        @param request: DescribeDesktopOversoldUserGroupRequest
        @return: DescribeDesktopOversoldUserGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_desktop_oversold_user_group_with_options(request, runtime)

    async def describe_desktop_oversold_user_group_async(
        self,
        request: ecd_20200930_models.DescribeDesktopOversoldUserGroupRequest,
    ) -> ecd_20200930_models.DescribeDesktopOversoldUserGroupResponse:
        """
        @summary 查询超卖用户组
        
        @param request: DescribeDesktopOversoldUserGroupRequest
        @return: DescribeDesktopOversoldUserGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_desktop_oversold_user_group_with_options_async(request, runtime)

    def describe_desktop_sessions_with_options(
        self,
        request: ecd_20200930_models.DescribeDesktopSessionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopSessionsResponse:
        """
        @summary Queries the detailed session information of a cloud computer.
        
        @description You can only query data within the last 30 days.
        
        @param request: DescribeDesktopSessionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopSessionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_os_session):
            query['CheckOsSession'] = request.check_os_session
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.end_user_id_filter):
            query['EndUserIdFilter'] = request.end_user_id_filter
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.session_status):
            query['SessionStatus'] = request.session_status
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.sub_pay_type):
            query['SubPayType'] = request.sub_pay_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopSessions',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopSessionsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopSessionsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_desktop_sessions_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDesktopSessionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopSessionsResponse:
        """
        @summary Queries the detailed session information of a cloud computer.
        
        @description You can only query data within the last 30 days.
        
        @param request: DescribeDesktopSessionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopSessionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_os_session):
            query['CheckOsSession'] = request.check_os_session
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.end_user_id_filter):
            query['EndUserIdFilter'] = request.end_user_id_filter
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.session_status):
            query['SessionStatus'] = request.session_status
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.sub_pay_type):
            query['SubPayType'] = request.sub_pay_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopSessions',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopSessionsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopSessionsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_desktop_sessions(
        self,
        request: ecd_20200930_models.DescribeDesktopSessionsRequest,
    ) -> ecd_20200930_models.DescribeDesktopSessionsResponse:
        """
        @summary Queries the detailed session information of a cloud computer.
        
        @description You can only query data within the last 30 days.
        
        @param request: DescribeDesktopSessionsRequest
        @return: DescribeDesktopSessionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_desktop_sessions_with_options(request, runtime)

    async def describe_desktop_sessions_async(
        self,
        request: ecd_20200930_models.DescribeDesktopSessionsRequest,
    ) -> ecd_20200930_models.DescribeDesktopSessionsResponse:
        """
        @summary Queries the detailed session information of a cloud computer.
        
        @description You can only query data within the last 30 days.
        
        @param request: DescribeDesktopSessionsRequest
        @return: DescribeDesktopSessionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_desktop_sessions_with_options_async(request, runtime)

    def describe_desktop_types_with_options(
        self,
        request: ecd_20200930_models.DescribeDesktopTypesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopTypesResponse:
        """
        @summary Queries the instance types of cloud computers.
        
        @description When no values are specified for the `InstanceTypeFamily` and `DesktopTypeId` parameters for a cloud desktop, all types of cloud desktops are queried.
        
        @param request: DescribeDesktopTypesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopTypesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.applied_scope):
            query['AppliedScope'] = request.applied_scope
        if not UtilClient.is_unset(request.cpu_count):
            query['CpuCount'] = request.cpu_count
        if not UtilClient.is_unset(request.desktop_group_id_for_modify):
            query['DesktopGroupIdForModify'] = request.desktop_group_id_for_modify
        if not UtilClient.is_unset(request.desktop_id_for_modify):
            query['DesktopIdForModify'] = request.desktop_id_for_modify
        if not UtilClient.is_unset(request.desktop_type_id):
            query['DesktopTypeId'] = request.desktop_type_id
        if not UtilClient.is_unset(request.desktop_type_id_list):
            query['DesktopTypeIdList'] = request.desktop_type_id_list
        if not UtilClient.is_unset(request.gpu_count):
            query['GpuCount'] = request.gpu_count
        if not UtilClient.is_unset(request.gpu_driver_type):
            query['GpuDriverType'] = request.gpu_driver_type
        if not UtilClient.is_unset(request.gpu_memory):
            query['GpuMemory'] = request.gpu_memory
        if not UtilClient.is_unset(request.instance_type_family):
            query['InstanceTypeFamily'] = request.instance_type_family
        if not UtilClient.is_unset(request.memory_size):
            query['MemorySize'] = request.memory_size
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.sort_type):
            query['SortType'] = request.sort_type
        if not UtilClient.is_unset(request.support_min_session_count):
            query['SupportMinSessionCount'] = request.support_min_session_count
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopTypes',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopTypesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopTypesResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_desktop_types_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDesktopTypesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopTypesResponse:
        """
        @summary Queries the instance types of cloud computers.
        
        @description When no values are specified for the `InstanceTypeFamily` and `DesktopTypeId` parameters for a cloud desktop, all types of cloud desktops are queried.
        
        @param request: DescribeDesktopTypesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopTypesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.applied_scope):
            query['AppliedScope'] = request.applied_scope
        if not UtilClient.is_unset(request.cpu_count):
            query['CpuCount'] = request.cpu_count
        if not UtilClient.is_unset(request.desktop_group_id_for_modify):
            query['DesktopGroupIdForModify'] = request.desktop_group_id_for_modify
        if not UtilClient.is_unset(request.desktop_id_for_modify):
            query['DesktopIdForModify'] = request.desktop_id_for_modify
        if not UtilClient.is_unset(request.desktop_type_id):
            query['DesktopTypeId'] = request.desktop_type_id
        if not UtilClient.is_unset(request.desktop_type_id_list):
            query['DesktopTypeIdList'] = request.desktop_type_id_list
        if not UtilClient.is_unset(request.gpu_count):
            query['GpuCount'] = request.gpu_count
        if not UtilClient.is_unset(request.gpu_driver_type):
            query['GpuDriverType'] = request.gpu_driver_type
        if not UtilClient.is_unset(request.gpu_memory):
            query['GpuMemory'] = request.gpu_memory
        if not UtilClient.is_unset(request.instance_type_family):
            query['InstanceTypeFamily'] = request.instance_type_family
        if not UtilClient.is_unset(request.memory_size):
            query['MemorySize'] = request.memory_size
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.sort_type):
            query['SortType'] = request.sort_type
        if not UtilClient.is_unset(request.support_min_session_count):
            query['SupportMinSessionCount'] = request.support_min_session_count
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopTypes',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopTypesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopTypesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_desktop_types(
        self,
        request: ecd_20200930_models.DescribeDesktopTypesRequest,
    ) -> ecd_20200930_models.DescribeDesktopTypesResponse:
        """
        @summary Queries the instance types of cloud computers.
        
        @description When no values are specified for the `InstanceTypeFamily` and `DesktopTypeId` parameters for a cloud desktop, all types of cloud desktops are queried.
        
        @param request: DescribeDesktopTypesRequest
        @return: DescribeDesktopTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_desktop_types_with_options(request, runtime)

    async def describe_desktop_types_async(
        self,
        request: ecd_20200930_models.DescribeDesktopTypesRequest,
    ) -> ecd_20200930_models.DescribeDesktopTypesResponse:
        """
        @summary Queries the instance types of cloud computers.
        
        @description When no values are specified for the `InstanceTypeFamily` and `DesktopTypeId` parameters for a cloud desktop, all types of cloud desktops are queried.
        
        @param request: DescribeDesktopTypesRequest
        @return: DescribeDesktopTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_desktop_types_with_options_async(request, runtime)

    def describe_desktops_with_options(
        self,
        request: ecd_20200930_models.DescribeDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopsResponse:
        """
        @summary Queries the details of cloud computers.
        
        @param request: DescribeDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.desktop_status):
            query['DesktopStatus'] = request.desktop_status
        if not UtilClient.is_unset(request.desktop_status_list):
            query['DesktopStatusList'] = request.desktop_status_list
        if not UtilClient.is_unset(request.desktop_type):
            query['DesktopType'] = request.desktop_type
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.excluded_end_user_id):
            query['ExcludedEndUserId'] = request.excluded_end_user_id
        if not UtilClient.is_unset(request.expired_time):
            query['ExpiredTime'] = request.expired_time
        if not UtilClient.is_unset(request.fill_resource_group):
            query['FillResourceGroup'] = request.fill_resource_group
        if not UtilClient.is_unset(request.filter_desktop_group):
            query['FilterDesktopGroup'] = request.filter_desktop_group
        if not UtilClient.is_unset(request.gpu_instance_group_id):
            query['GpuInstanceGroupId'] = request.gpu_instance_group_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.management_flag):
            query['ManagementFlag'] = request.management_flag
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.multi_resource):
            query['MultiResource'] = request.multi_resource
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.only_desktop_group):
            query['OnlyDesktopGroup'] = request.only_desktop_group
        if not UtilClient.is_unset(request.os_types):
            query['OsTypes'] = request.os_types
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.qos_rule_id):
            query['QosRuleId'] = request.qos_rule_id
        if not UtilClient.is_unset(request.query_fota_update):
            query['QueryFotaUpdate'] = request.query_fota_update
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.snapshot_policy_id):
            query['SnapshotPolicyId'] = request.snapshot_policy_id
        if not UtilClient.is_unset(request.sub_pay_type):
            query['SubPayType'] = request.sub_pay_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_desktops_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopsResponse:
        """
        @summary Queries the details of cloud computers.
        
        @param request: DescribeDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.desktop_status):
            query['DesktopStatus'] = request.desktop_status
        if not UtilClient.is_unset(request.desktop_status_list):
            query['DesktopStatusList'] = request.desktop_status_list
        if not UtilClient.is_unset(request.desktop_type):
            query['DesktopType'] = request.desktop_type
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.excluded_end_user_id):
            query['ExcludedEndUserId'] = request.excluded_end_user_id
        if not UtilClient.is_unset(request.expired_time):
            query['ExpiredTime'] = request.expired_time
        if not UtilClient.is_unset(request.fill_resource_group):
            query['FillResourceGroup'] = request.fill_resource_group
        if not UtilClient.is_unset(request.filter_desktop_group):
            query['FilterDesktopGroup'] = request.filter_desktop_group
        if not UtilClient.is_unset(request.gpu_instance_group_id):
            query['GpuInstanceGroupId'] = request.gpu_instance_group_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.management_flag):
            query['ManagementFlag'] = request.management_flag
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.multi_resource):
            query['MultiResource'] = request.multi_resource
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.only_desktop_group):
            query['OnlyDesktopGroup'] = request.only_desktop_group
        if not UtilClient.is_unset(request.os_types):
            query['OsTypes'] = request.os_types
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.qos_rule_id):
            query['QosRuleId'] = request.qos_rule_id
        if not UtilClient.is_unset(request.query_fota_update):
            query['QueryFotaUpdate'] = request.query_fota_update
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.snapshot_policy_id):
            query['SnapshotPolicyId'] = request.snapshot_policy_id
        if not UtilClient.is_unset(request.sub_pay_type):
            query['SubPayType'] = request.sub_pay_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_desktops(
        self,
        request: ecd_20200930_models.DescribeDesktopsRequest,
    ) -> ecd_20200930_models.DescribeDesktopsResponse:
        """
        @summary Queries the details of cloud computers.
        
        @param request: DescribeDesktopsRequest
        @return: DescribeDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_desktops_with_options(request, runtime)

    async def describe_desktops_async(
        self,
        request: ecd_20200930_models.DescribeDesktopsRequest,
    ) -> ecd_20200930_models.DescribeDesktopsResponse:
        """
        @summary Queries the details of cloud computers.
        
        @param request: DescribeDesktopsRequest
        @return: DescribeDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_desktops_with_options_async(request, runtime)

    def describe_desktops_in_group_with_options(
        self,
        request: ecd_20200930_models.DescribeDesktopsInGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopsInGroupResponse:
        """
        @summary Queries the cloud computers in a cloud computer pool by billing method.
        
        @param request: DescribeDesktopsInGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopsInGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.custom_end_time_period):
            query['CustomEndTimePeriod'] = request.custom_end_time_period
        if not UtilClient.is_unset(request.custom_start_time_period):
            query['CustomStartTimePeriod'] = request.custom_start_time_period
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.ignore_deleted):
            query['IgnoreDeleted'] = request.ignore_deleted
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopsInGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopsInGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopsInGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_desktops_in_group_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDesktopsInGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDesktopsInGroupResponse:
        """
        @summary Queries the cloud computers in a cloud computer pool by billing method.
        
        @param request: DescribeDesktopsInGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDesktopsInGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.custom_end_time_period):
            query['CustomEndTimePeriod'] = request.custom_end_time_period
        if not UtilClient.is_unset(request.custom_start_time_period):
            query['CustomStartTimePeriod'] = request.custom_start_time_period
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.ignore_deleted):
            query['IgnoreDeleted'] = request.ignore_deleted
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDesktopsInGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopsInGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDesktopsInGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_desktops_in_group(
        self,
        request: ecd_20200930_models.DescribeDesktopsInGroupRequest,
    ) -> ecd_20200930_models.DescribeDesktopsInGroupResponse:
        """
        @summary Queries the cloud computers in a cloud computer pool by billing method.
        
        @param request: DescribeDesktopsInGroupRequest
        @return: DescribeDesktopsInGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_desktops_in_group_with_options(request, runtime)

    async def describe_desktops_in_group_async(
        self,
        request: ecd_20200930_models.DescribeDesktopsInGroupRequest,
    ) -> ecd_20200930_models.DescribeDesktopsInGroupResponse:
        """
        @summary Queries the cloud computers in a cloud computer pool by billing method.
        
        @param request: DescribeDesktopsInGroupRequest
        @return: DescribeDesktopsInGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_desktops_in_group_with_options_async(request, runtime)

    def describe_devices_with_options(
        self,
        request: ecd_20200930_models.DescribeDevicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDevicesResponse:
        """
        @summary Queries the list of trusted devices.
        
        @param request: DescribeDevicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDevicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_domain):
            query['AdDomain'] = request.ad_domain
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.device_id):
            query['DeviceId'] = request.device_id
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDevices',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDevicesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDevicesResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_devices_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDevicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDevicesResponse:
        """
        @summary Queries the list of trusted devices.
        
        @param request: DescribeDevicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDevicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_domain):
            query['AdDomain'] = request.ad_domain
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.device_id):
            query['DeviceId'] = request.device_id
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDevices',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDevicesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDevicesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_devices(
        self,
        request: ecd_20200930_models.DescribeDevicesRequest,
    ) -> ecd_20200930_models.DescribeDevicesResponse:
        """
        @summary Queries the list of trusted devices.
        
        @param request: DescribeDevicesRequest
        @return: DescribeDevicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_devices_with_options(request, runtime)

    async def describe_devices_async(
        self,
        request: ecd_20200930_models.DescribeDevicesRequest,
    ) -> ecd_20200930_models.DescribeDevicesResponse:
        """
        @summary Queries the list of trusted devices.
        
        @param request: DescribeDevicesRequest
        @return: DescribeDevicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_devices_with_options_async(request, runtime)

    def describe_directories_with_options(
        self,
        request: ecd_20200930_models.DescribeDirectoriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDirectoriesResponse:
        """
        @summary Queries the details of directories.
        
        @param request: DescribeDirectoriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDirectoriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.directory_status):
            query['DirectoryStatus'] = request.directory_status
        if not UtilClient.is_unset(request.directory_type):
            query['DirectoryType'] = request.directory_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDirectories',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDirectoriesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDirectoriesResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_directories_with_options_async(
        self,
        request: ecd_20200930_models.DescribeDirectoriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeDirectoriesResponse:
        """
        @summary Queries the details of directories.
        
        @param request: DescribeDirectoriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDirectoriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.directory_status):
            query['DirectoryStatus'] = request.directory_status
        if not UtilClient.is_unset(request.directory_type):
            query['DirectoryType'] = request.directory_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDirectories',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDirectoriesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeDirectoriesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_directories(
        self,
        request: ecd_20200930_models.DescribeDirectoriesRequest,
    ) -> ecd_20200930_models.DescribeDirectoriesResponse:
        """
        @summary Queries the details of directories.
        
        @param request: DescribeDirectoriesRequest
        @return: DescribeDirectoriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_directories_with_options(request, runtime)

    async def describe_directories_async(
        self,
        request: ecd_20200930_models.DescribeDirectoriesRequest,
    ) -> ecd_20200930_models.DescribeDirectoriesResponse:
        """
        @summary Queries the details of directories.
        
        @param request: DescribeDirectoriesRequest
        @return: DescribeDirectoriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_directories_with_options_async(request, runtime)

    def describe_flow_metric_with_options(
        self,
        request: ecd_20200930_models.DescribeFlowMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeFlowMetricResponse:
        """
        @param request: DescribeFlowMetricRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFlowMetricResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.metric_type):
            query['MetricType'] = request.metric_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFlowMetric',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFlowMetricResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFlowMetricResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_flow_metric_with_options_async(
        self,
        request: ecd_20200930_models.DescribeFlowMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeFlowMetricResponse:
        """
        @param request: DescribeFlowMetricRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFlowMetricResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.metric_type):
            query['MetricType'] = request.metric_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFlowMetric',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFlowMetricResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFlowMetricResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_flow_metric(
        self,
        request: ecd_20200930_models.DescribeFlowMetricRequest,
    ) -> ecd_20200930_models.DescribeFlowMetricResponse:
        """
        @param request: DescribeFlowMetricRequest
        @return: DescribeFlowMetricResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_flow_metric_with_options(request, runtime)

    async def describe_flow_metric_async(
        self,
        request: ecd_20200930_models.DescribeFlowMetricRequest,
    ) -> ecd_20200930_models.DescribeFlowMetricResponse:
        """
        @param request: DescribeFlowMetricRequest
        @return: DescribeFlowMetricResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_flow_metric_with_options_async(request, runtime)

    def describe_flow_statistic_with_options(
        self,
        request: ecd_20200930_models.DescribeFlowStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeFlowStatisticResponse:
        """
        @summary Queries cloud computer-level traffic statistics of a single office network.
        
        @description > You can query only the traffic data in the last 90 days.
        
        @param request: DescribeFlowStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFlowStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFlowStatistic',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFlowStatisticResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFlowStatisticResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_flow_statistic_with_options_async(
        self,
        request: ecd_20200930_models.DescribeFlowStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeFlowStatisticResponse:
        """
        @summary Queries cloud computer-level traffic statistics of a single office network.
        
        @description > You can query only the traffic data in the last 90 days.
        
        @param request: DescribeFlowStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFlowStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFlowStatistic',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFlowStatisticResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFlowStatisticResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_flow_statistic(
        self,
        request: ecd_20200930_models.DescribeFlowStatisticRequest,
    ) -> ecd_20200930_models.DescribeFlowStatisticResponse:
        """
        @summary Queries cloud computer-level traffic statistics of a single office network.
        
        @description > You can query only the traffic data in the last 90 days.
        
        @param request: DescribeFlowStatisticRequest
        @return: DescribeFlowStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_flow_statistic_with_options(request, runtime)

    async def describe_flow_statistic_async(
        self,
        request: ecd_20200930_models.DescribeFlowStatisticRequest,
    ) -> ecd_20200930_models.DescribeFlowStatisticResponse:
        """
        @summary Queries cloud computer-level traffic statistics of a single office network.
        
        @description > You can query only the traffic data in the last 90 days.
        
        @param request: DescribeFlowStatisticRequest
        @return: DescribeFlowStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_flow_statistic_with_options_async(request, runtime)

    def describe_fota_pending_desktops_with_options(
        self,
        request: ecd_20200930_models.DescribeFotaPendingDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeFotaPendingDesktopsResponse:
        """
        @summary Queries information about the cloud computers whose images can be and are pending to be updated to the specified version.
        
        @param request: DescribeFotaPendingDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFotaPendingDesktopsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.task_uid):
            query['TaskUid'] = request.task_uid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFotaPendingDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFotaPendingDesktopsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFotaPendingDesktopsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_fota_pending_desktops_with_options_async(
        self,
        request: ecd_20200930_models.DescribeFotaPendingDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeFotaPendingDesktopsResponse:
        """
        @summary Queries information about the cloud computers whose images can be and are pending to be updated to the specified version.
        
        @param request: DescribeFotaPendingDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFotaPendingDesktopsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.task_uid):
            query['TaskUid'] = request.task_uid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFotaPendingDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFotaPendingDesktopsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFotaPendingDesktopsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_fota_pending_desktops(
        self,
        request: ecd_20200930_models.DescribeFotaPendingDesktopsRequest,
    ) -> ecd_20200930_models.DescribeFotaPendingDesktopsResponse:
        """
        @summary Queries information about the cloud computers whose images can be and are pending to be updated to the specified version.
        
        @param request: DescribeFotaPendingDesktopsRequest
        @return: DescribeFotaPendingDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_fota_pending_desktops_with_options(request, runtime)

    async def describe_fota_pending_desktops_async(
        self,
        request: ecd_20200930_models.DescribeFotaPendingDesktopsRequest,
    ) -> ecd_20200930_models.DescribeFotaPendingDesktopsResponse:
        """
        @summary Queries information about the cloud computers whose images can be and are pending to be updated to the specified version.
        
        @param request: DescribeFotaPendingDesktopsRequest
        @return: DescribeFotaPendingDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_fota_pending_desktops_with_options_async(request, runtime)

    def describe_fota_tasks_with_options(
        self,
        request: ecd_20200930_models.DescribeFotaTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeFotaTasksResponse:
        """
        @summary Queries a list of update tasks.
        
        @param request: DescribeFotaTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFotaTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.fota_status):
            query['FotaStatus'] = request.fota_status
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.task_uid):
            query['TaskUid'] = request.task_uid
        if not UtilClient.is_unset(request.user_status):
            query['UserStatus'] = request.user_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFotaTasks',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFotaTasksResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFotaTasksResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_fota_tasks_with_options_async(
        self,
        request: ecd_20200930_models.DescribeFotaTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeFotaTasksResponse:
        """
        @summary Queries a list of update tasks.
        
        @param request: DescribeFotaTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFotaTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.fota_status):
            query['FotaStatus'] = request.fota_status
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.task_uid):
            query['TaskUid'] = request.task_uid
        if not UtilClient.is_unset(request.user_status):
            query['UserStatus'] = request.user_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFotaTasks',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFotaTasksResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeFotaTasksResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_fota_tasks(
        self,
        request: ecd_20200930_models.DescribeFotaTasksRequest,
    ) -> ecd_20200930_models.DescribeFotaTasksResponse:
        """
        @summary Queries a list of update tasks.
        
        @param request: DescribeFotaTasksRequest
        @return: DescribeFotaTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_fota_tasks_with_options(request, runtime)

    async def describe_fota_tasks_async(
        self,
        request: ecd_20200930_models.DescribeFotaTasksRequest,
    ) -> ecd_20200930_models.DescribeFotaTasksResponse:
        """
        @summary Queries a list of update tasks.
        
        @param request: DescribeFotaTasksRequest
        @return: DescribeFotaTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_fota_tasks_with_options_async(request, runtime)

    def describe_guest_applications_with_options(
        self,
        request: ecd_20200930_models.DescribeGuestApplicationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeGuestApplicationsResponse:
        """
        @summary Queries the applications and their processes of an end user.
        
        @param request: DescribeGuestApplicationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGuestApplicationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGuestApplications',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeGuestApplicationsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeGuestApplicationsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_guest_applications_with_options_async(
        self,
        request: ecd_20200930_models.DescribeGuestApplicationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeGuestApplicationsResponse:
        """
        @summary Queries the applications and their processes of an end user.
        
        @param request: DescribeGuestApplicationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGuestApplicationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGuestApplications',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeGuestApplicationsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeGuestApplicationsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_guest_applications(
        self,
        request: ecd_20200930_models.DescribeGuestApplicationsRequest,
    ) -> ecd_20200930_models.DescribeGuestApplicationsResponse:
        """
        @summary Queries the applications and their processes of an end user.
        
        @param request: DescribeGuestApplicationsRequest
        @return: DescribeGuestApplicationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_guest_applications_with_options(request, runtime)

    async def describe_guest_applications_async(
        self,
        request: ecd_20200930_models.DescribeGuestApplicationsRequest,
    ) -> ecd_20200930_models.DescribeGuestApplicationsResponse:
        """
        @summary Queries the applications and their processes of an end user.
        
        @param request: DescribeGuestApplicationsRequest
        @return: DescribeGuestApplicationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_guest_applications_with_options_async(request, runtime)

    def describe_image_modified_records_with_options(
        self,
        request: ecd_20200930_models.DescribeImageModifiedRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeImageModifiedRecordsResponse:
        """
        @summary Queries the image modification records of cloud computers.
        
        @param request: DescribeImageModifiedRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImageModifiedRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageModifiedRecords',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImageModifiedRecordsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImageModifiedRecordsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_image_modified_records_with_options_async(
        self,
        request: ecd_20200930_models.DescribeImageModifiedRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeImageModifiedRecordsResponse:
        """
        @summary Queries the image modification records of cloud computers.
        
        @param request: DescribeImageModifiedRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImageModifiedRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageModifiedRecords',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImageModifiedRecordsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImageModifiedRecordsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_image_modified_records(
        self,
        request: ecd_20200930_models.DescribeImageModifiedRecordsRequest,
    ) -> ecd_20200930_models.DescribeImageModifiedRecordsResponse:
        """
        @summary Queries the image modification records of cloud computers.
        
        @param request: DescribeImageModifiedRecordsRequest
        @return: DescribeImageModifiedRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_image_modified_records_with_options(request, runtime)

    async def describe_image_modified_records_async(
        self,
        request: ecd_20200930_models.DescribeImageModifiedRecordsRequest,
    ) -> ecd_20200930_models.DescribeImageModifiedRecordsResponse:
        """
        @summary Queries the image modification records of cloud computers.
        
        @param request: DescribeImageModifiedRecordsRequest
        @return: DescribeImageModifiedRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_modified_records_with_options_async(request, runtime)

    def describe_image_permission_with_options(
        self,
        request: ecd_20200930_models.DescribeImagePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeImagePermissionResponse:
        """
        @summary Queries the recipient Alibaba Cloud accounts with which an image is shared.
        
        @description You can call the [ModifyImagePermission](https://help.aliyun.com/document_detail/436982.html) operation to share an image with another cloud computer user or unshare an image. You can call the DescribeImagePermission operation to obtain the Alibaba Cloud accounts with which the current image is shared.
        
        @param request: DescribeImagePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImagePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImagePermission',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImagePermissionResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImagePermissionResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_image_permission_with_options_async(
        self,
        request: ecd_20200930_models.DescribeImagePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeImagePermissionResponse:
        """
        @summary Queries the recipient Alibaba Cloud accounts with which an image is shared.
        
        @description You can call the [ModifyImagePermission](https://help.aliyun.com/document_detail/436982.html) operation to share an image with another cloud computer user or unshare an image. You can call the DescribeImagePermission operation to obtain the Alibaba Cloud accounts with which the current image is shared.
        
        @param request: DescribeImagePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImagePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImagePermission',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImagePermissionResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImagePermissionResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_image_permission(
        self,
        request: ecd_20200930_models.DescribeImagePermissionRequest,
    ) -> ecd_20200930_models.DescribeImagePermissionResponse:
        """
        @summary Queries the recipient Alibaba Cloud accounts with which an image is shared.
        
        @description You can call the [ModifyImagePermission](https://help.aliyun.com/document_detail/436982.html) operation to share an image with another cloud computer user or unshare an image. You can call the DescribeImagePermission operation to obtain the Alibaba Cloud accounts with which the current image is shared.
        
        @param request: DescribeImagePermissionRequest
        @return: DescribeImagePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_image_permission_with_options(request, runtime)

    async def describe_image_permission_async(
        self,
        request: ecd_20200930_models.DescribeImagePermissionRequest,
    ) -> ecd_20200930_models.DescribeImagePermissionResponse:
        """
        @summary Queries the recipient Alibaba Cloud accounts with which an image is shared.
        
        @description You can call the [ModifyImagePermission](https://help.aliyun.com/document_detail/436982.html) operation to share an image with another cloud computer user or unshare an image. You can call the DescribeImagePermission operation to obtain the Alibaba Cloud accounts with which the current image is shared.
        
        @param request: DescribeImagePermissionRequest
        @return: DescribeImagePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_permission_with_options_async(request, runtime)

    def describe_images_with_options(
        self,
        request: ecd_20200930_models.DescribeImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeImagesResponse:
        """
        @summary Queries the information about images.
        
        @param request: DescribeImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_instance_type):
            query['DesktopInstanceType'] = request.desktop_instance_type
        if not UtilClient.is_unset(request.fota_version):
            query['FotaVersion'] = request.fota_version
        if not UtilClient.is_unset(request.gpu_category):
            query['GpuCategory'] = request.gpu_category
        if not UtilClient.is_unset(request.gpu_driver_version):
            query['GpuDriverVersion'] = request.gpu_driver_version
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.image_status):
            query['ImageStatus'] = request.image_status
        if not UtilClient.is_unset(request.image_type):
            query['ImageType'] = request.image_type
        if not UtilClient.is_unset(request.language_type):
            query['LanguageType'] = request.language_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.os_type):
            query['OsType'] = request.os_type
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.session_type):
            query['SessionType'] = request.session_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImages',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImagesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImagesResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_images_with_options_async(
        self,
        request: ecd_20200930_models.DescribeImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeImagesResponse:
        """
        @summary Queries the information about images.
        
        @param request: DescribeImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_instance_type):
            query['DesktopInstanceType'] = request.desktop_instance_type
        if not UtilClient.is_unset(request.fota_version):
            query['FotaVersion'] = request.fota_version
        if not UtilClient.is_unset(request.gpu_category):
            query['GpuCategory'] = request.gpu_category
        if not UtilClient.is_unset(request.gpu_driver_version):
            query['GpuDriverVersion'] = request.gpu_driver_version
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.image_status):
            query['ImageStatus'] = request.image_status
        if not UtilClient.is_unset(request.image_type):
            query['ImageType'] = request.image_type
        if not UtilClient.is_unset(request.language_type):
            query['LanguageType'] = request.language_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.os_type):
            query['OsType'] = request.os_type
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.session_type):
            query['SessionType'] = request.session_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImages',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImagesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeImagesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_images(
        self,
        request: ecd_20200930_models.DescribeImagesRequest,
    ) -> ecd_20200930_models.DescribeImagesResponse:
        """
        @summary Queries the information about images.
        
        @param request: DescribeImagesRequest
        @return: DescribeImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_images_with_options(request, runtime)

    async def describe_images_async(
        self,
        request: ecd_20200930_models.DescribeImagesRequest,
    ) -> ecd_20200930_models.DescribeImagesResponse:
        """
        @summary Queries the information about images.
        
        @param request: DescribeImagesRequest
        @return: DescribeImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_images_with_options_async(request, runtime)

    def describe_invocations_with_options(
        self,
        request: ecd_20200930_models.DescribeInvocationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeInvocationsResponse:
        """
        @description    After you run a command, it may not succeed. You can call this operation to query the execution result.
        You can query the information about execution in the last two weeks. A maximum of 100,000 lines of execution information can be retained.
        
        @param request: DescribeInvocationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvocationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_type):
            query['CommandType'] = request.command_type
        if not UtilClient.is_unset(request.content_encoding):
            query['ContentEncoding'] = request.content_encoding
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_ids):
            query['DesktopIds'] = request.desktop_ids
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.include_invoke_desktops):
            query['IncludeInvokeDesktops'] = request.include_invoke_desktops
        if not UtilClient.is_unset(request.include_output):
            query['IncludeOutput'] = request.include_output
        if not UtilClient.is_unset(request.invoke_id):
            query['InvokeId'] = request.invoke_id
        if not UtilClient.is_unset(request.invoke_status):
            query['InvokeStatus'] = request.invoke_status
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvocations',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeInvocationsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeInvocationsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_invocations_with_options_async(
        self,
        request: ecd_20200930_models.DescribeInvocationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeInvocationsResponse:
        """
        @description    After you run a command, it may not succeed. You can call this operation to query the execution result.
        You can query the information about execution in the last two weeks. A maximum of 100,000 lines of execution information can be retained.
        
        @param request: DescribeInvocationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvocationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_type):
            query['CommandType'] = request.command_type
        if not UtilClient.is_unset(request.content_encoding):
            query['ContentEncoding'] = request.content_encoding
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_ids):
            query['DesktopIds'] = request.desktop_ids
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.include_invoke_desktops):
            query['IncludeInvokeDesktops'] = request.include_invoke_desktops
        if not UtilClient.is_unset(request.include_output):
            query['IncludeOutput'] = request.include_output
        if not UtilClient.is_unset(request.invoke_id):
            query['InvokeId'] = request.invoke_id
        if not UtilClient.is_unset(request.invoke_status):
            query['InvokeStatus'] = request.invoke_status
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvocations',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeInvocationsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeInvocationsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_invocations(
        self,
        request: ecd_20200930_models.DescribeInvocationsRequest,
    ) -> ecd_20200930_models.DescribeInvocationsResponse:
        """
        @description    After you run a command, it may not succeed. You can call this operation to query the execution result.
        You can query the information about execution in the last two weeks. A maximum of 100,000 lines of execution information can be retained.
        
        @param request: DescribeInvocationsRequest
        @return: DescribeInvocationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_invocations_with_options(request, runtime)

    async def describe_invocations_async(
        self,
        request: ecd_20200930_models.DescribeInvocationsRequest,
    ) -> ecd_20200930_models.DescribeInvocationsResponse:
        """
        @description    After you run a command, it may not succeed. You can call this operation to query the execution result.
        You can query the information about execution in the last two weeks. A maximum of 100,000 lines of execution information can be retained.
        
        @param request: DescribeInvocationsRequest
        @return: DescribeInvocationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_invocations_with_options_async(request, runtime)

    def describe_kms_keys_with_options(
        self,
        request: ecd_20200930_models.DescribeKmsKeysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeKmsKeysResponse:
        """
        @summary Queries Key Management Service (KMS) keys of users. The first time you call this operation, you can try to create a service key for Elastic Desktop Service (EDS) and call the operation to return results.
        
        @param request: DescribeKmsKeysRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeKmsKeysResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeKmsKeys',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeKmsKeysResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeKmsKeysResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_kms_keys_with_options_async(
        self,
        request: ecd_20200930_models.DescribeKmsKeysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeKmsKeysResponse:
        """
        @summary Queries Key Management Service (KMS) keys of users. The first time you call this operation, you can try to create a service key for Elastic Desktop Service (EDS) and call the operation to return results.
        
        @param request: DescribeKmsKeysRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeKmsKeysResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeKmsKeys',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeKmsKeysResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeKmsKeysResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_kms_keys(
        self,
        request: ecd_20200930_models.DescribeKmsKeysRequest,
    ) -> ecd_20200930_models.DescribeKmsKeysResponse:
        """
        @summary Queries Key Management Service (KMS) keys of users. The first time you call this operation, you can try to create a service key for Elastic Desktop Service (EDS) and call the operation to return results.
        
        @param request: DescribeKmsKeysRequest
        @return: DescribeKmsKeysResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_kms_keys_with_options(request, runtime)

    async def describe_kms_keys_async(
        self,
        request: ecd_20200930_models.DescribeKmsKeysRequest,
    ) -> ecd_20200930_models.DescribeKmsKeysResponse:
        """
        @summary Queries Key Management Service (KMS) keys of users. The first time you call this operation, you can try to create a service key for Elastic Desktop Service (EDS) and call the operation to return results.
        
        @param request: DescribeKmsKeysRequest
        @return: DescribeKmsKeysResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_kms_keys_with_options_async(request, runtime)

    def describe_modification_price_with_options(
        self,
        request: ecd_20200930_models.DescribeModificationPriceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeModificationPriceResponse:
        """
        @param request: DescribeModificationPriceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeModificationPriceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.root_disk_size_gib):
            query['RootDiskSizeGib'] = request.root_disk_size_gib
        if not UtilClient.is_unset(request.user_disk_size_gib):
            query['UserDiskSizeGib'] = request.user_disk_size_gib
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeModificationPrice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeModificationPriceResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeModificationPriceResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_modification_price_with_options_async(
        self,
        request: ecd_20200930_models.DescribeModificationPriceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeModificationPriceResponse:
        """
        @param request: DescribeModificationPriceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeModificationPriceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.root_disk_size_gib):
            query['RootDiskSizeGib'] = request.root_disk_size_gib
        if not UtilClient.is_unset(request.user_disk_size_gib):
            query['UserDiskSizeGib'] = request.user_disk_size_gib
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeModificationPrice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeModificationPriceResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeModificationPriceResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_modification_price(
        self,
        request: ecd_20200930_models.DescribeModificationPriceRequest,
    ) -> ecd_20200930_models.DescribeModificationPriceResponse:
        """
        @param request: DescribeModificationPriceRequest
        @return: DescribeModificationPriceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_modification_price_with_options(request, runtime)

    async def describe_modification_price_async(
        self,
        request: ecd_20200930_models.DescribeModificationPriceRequest,
    ) -> ecd_20200930_models.DescribeModificationPriceResponse:
        """
        @param request: DescribeModificationPriceRequest
        @return: DescribeModificationPriceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_modification_price_with_options_async(request, runtime)

    def describe_nasfile_systems_with_options(
        self,
        request: ecd_20200930_models.DescribeNASFileSystemsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeNASFileSystemsResponse:
        """
        @summary Queries the information about File Storage NAS (NAS) file systems.
        
        @param request: DescribeNASFileSystemsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNASFileSystemsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.match_compatible_profile):
            query['MatchCompatibleProfile'] = request.match_compatible_profile
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNASFileSystems',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeNASFileSystemsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeNASFileSystemsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_nasfile_systems_with_options_async(
        self,
        request: ecd_20200930_models.DescribeNASFileSystemsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeNASFileSystemsResponse:
        """
        @summary Queries the information about File Storage NAS (NAS) file systems.
        
        @param request: DescribeNASFileSystemsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNASFileSystemsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.match_compatible_profile):
            query['MatchCompatibleProfile'] = request.match_compatible_profile
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNASFileSystems',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeNASFileSystemsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeNASFileSystemsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_nasfile_systems(
        self,
        request: ecd_20200930_models.DescribeNASFileSystemsRequest,
    ) -> ecd_20200930_models.DescribeNASFileSystemsResponse:
        """
        @summary Queries the information about File Storage NAS (NAS) file systems.
        
        @param request: DescribeNASFileSystemsRequest
        @return: DescribeNASFileSystemsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nasfile_systems_with_options(request, runtime)

    async def describe_nasfile_systems_async(
        self,
        request: ecd_20200930_models.DescribeNASFileSystemsRequest,
    ) -> ecd_20200930_models.DescribeNASFileSystemsResponse:
        """
        @summary Queries the information about File Storage NAS (NAS) file systems.
        
        @param request: DescribeNASFileSystemsRequest
        @return: DescribeNASFileSystemsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nasfile_systems_with_options_async(request, runtime)

    def describe_network_packages_with_options(
        self,
        request: ecd_20200930_models.DescribeNetworkPackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeNetworkPackagesResponse:
        """
        @summary Queries the details of one or more premium bandwidth plans.
        
        @param request: DescribeNetworkPackagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkPackagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.network_package_id):
            query['NetworkPackageId'] = request.network_package_id
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkPackages',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeNetworkPackagesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeNetworkPackagesResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_network_packages_with_options_async(
        self,
        request: ecd_20200930_models.DescribeNetworkPackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeNetworkPackagesResponse:
        """
        @summary Queries the details of one or more premium bandwidth plans.
        
        @param request: DescribeNetworkPackagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkPackagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.network_package_id):
            query['NetworkPackageId'] = request.network_package_id
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkPackages',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeNetworkPackagesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeNetworkPackagesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_network_packages(
        self,
        request: ecd_20200930_models.DescribeNetworkPackagesRequest,
    ) -> ecd_20200930_models.DescribeNetworkPackagesResponse:
        """
        @summary Queries the details of one or more premium bandwidth plans.
        
        @param request: DescribeNetworkPackagesRequest
        @return: DescribeNetworkPackagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_network_packages_with_options(request, runtime)

    async def describe_network_packages_async(
        self,
        request: ecd_20200930_models.DescribeNetworkPackagesRequest,
    ) -> ecd_20200930_models.DescribeNetworkPackagesResponse:
        """
        @summary Queries the details of one or more premium bandwidth plans.
        
        @param request: DescribeNetworkPackagesRequest
        @return: DescribeNetworkPackagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_packages_with_options_async(request, runtime)

    def describe_office_sites_with_options(
        self,
        request: ecd_20200930_models.DescribeOfficeSitesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeOfficeSitesResponse:
        """
        @summary Queries office network properties, including office network ID, name, status, and creation time.
        
        @param request: DescribeOfficeSitesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOfficeSitesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_type):
            query['OfficeSiteType'] = request.office_site_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.security_protection):
            query['SecurityProtection'] = request.security_protection
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOfficeSites',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeOfficeSitesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeOfficeSitesResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_office_sites_with_options_async(
        self,
        request: ecd_20200930_models.DescribeOfficeSitesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeOfficeSitesResponse:
        """
        @summary Queries office network properties, including office network ID, name, status, and creation time.
        
        @param request: DescribeOfficeSitesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOfficeSitesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_type):
            query['OfficeSiteType'] = request.office_site_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.security_protection):
            query['SecurityProtection'] = request.security_protection
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOfficeSites',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeOfficeSitesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeOfficeSitesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_office_sites(
        self,
        request: ecd_20200930_models.DescribeOfficeSitesRequest,
    ) -> ecd_20200930_models.DescribeOfficeSitesResponse:
        """
        @summary Queries office network properties, including office network ID, name, status, and creation time.
        
        @param request: DescribeOfficeSitesRequest
        @return: DescribeOfficeSitesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_office_sites_with_options(request, runtime)

    async def describe_office_sites_async(
        self,
        request: ecd_20200930_models.DescribeOfficeSitesRequest,
    ) -> ecd_20200930_models.DescribeOfficeSitesResponse:
        """
        @summary Queries office network properties, including office network ID, name, status, and creation time.
        
        @param request: DescribeOfficeSitesRequest
        @return: DescribeOfficeSitesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_office_sites_with_options_async(request, runtime)

    def describe_policy_groups_with_options(
        self,
        request: ecd_20200930_models.DescribePolicyGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribePolicyGroupsResponse:
        """
        @summary Queries the details of a cloud computer policy.
        
        @param request: DescribePolicyGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolicyGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_policy_group_ids):
            query['ExternalPolicyGroupIds'] = request.external_policy_group_ids
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolicyGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribePolicyGroupsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribePolicyGroupsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_policy_groups_with_options_async(
        self,
        request: ecd_20200930_models.DescribePolicyGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribePolicyGroupsResponse:
        """
        @summary Queries the details of a cloud computer policy.
        
        @param request: DescribePolicyGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolicyGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_policy_group_ids):
            query['ExternalPolicyGroupIds'] = request.external_policy_group_ids
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolicyGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribePolicyGroupsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribePolicyGroupsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_policy_groups(
        self,
        request: ecd_20200930_models.DescribePolicyGroupsRequest,
    ) -> ecd_20200930_models.DescribePolicyGroupsResponse:
        """
        @summary Queries the details of a cloud computer policy.
        
        @param request: DescribePolicyGroupsRequest
        @return: DescribePolicyGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_policy_groups_with_options(request, runtime)

    async def describe_policy_groups_async(
        self,
        request: ecd_20200930_models.DescribePolicyGroupsRequest,
    ) -> ecd_20200930_models.DescribePolicyGroupsResponse:
        """
        @summary Queries the details of a cloud computer policy.
        
        @param request: DescribePolicyGroupsRequest
        @return: DescribePolicyGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_policy_groups_with_options_async(request, runtime)

    def describe_price_with_options(
        self,
        request: ecd_20200930_models.DescribePriceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribePriceResponse:
        """
        @summary Queries the prices of Elastic Desktop Service (EDS) resources.
        
        @description ## Usage notes
        The request parameters vary based on the type of desktop resources whose price you want to query. Take note of the following items:
        If you set ResourceType to OfficeSite, you must specify InstanceType.
        If you set ResourceType to Bandwidth, the pay-by-data-transfer metering method is used for network billing.
        If you set ResourceType to Desktop, you must specify InstanceType, RootDiskSizeGib, and UserDiskSizeGib. You can specify OsType, PeriodUnit, Period, and Amount based on your business requirements.
        > Before you call this operation to query the prices of cloud desktops by setting ResourceType to Desktop, you must know the desktop types and disk sizes that EDS provides. The disk sizes vary based on the desktop types. For more information, see [Cloud desktop types](https://help.aliyun.com/document_detail/188609.html).
        
        @param request: DescribePriceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePriceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.group_desktop_count):
            query['GroupDesktopCount'] = request.group_desktop_count
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.os_type):
            query['OsType'] = request.os_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.root_disk_category):
            query['RootDiskCategory'] = request.root_disk_category
        if not UtilClient.is_unset(request.root_disk_size_gib):
            query['RootDiskSizeGib'] = request.root_disk_size_gib
        if not UtilClient.is_unset(request.user_disk_category):
            query['UserDiskCategory'] = request.user_disk_category
        if not UtilClient.is_unset(request.user_disk_size_gib):
            query['UserDiskSizeGib'] = request.user_disk_size_gib
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_price_with_options_async(
        self,
        request: ecd_20200930_models.DescribePriceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribePriceResponse:
        """
        @summary Queries the prices of Elastic Desktop Service (EDS) resources.
        
        @description ## Usage notes
        The request parameters vary based on the type of desktop resources whose price you want to query. Take note of the following items:
        If you set ResourceType to OfficeSite, you must specify InstanceType.
        If you set ResourceType to Bandwidth, the pay-by-data-transfer metering method is used for network billing.
        If you set ResourceType to Desktop, you must specify InstanceType, RootDiskSizeGib, and UserDiskSizeGib. You can specify OsType, PeriodUnit, Period, and Amount based on your business requirements.
        > Before you call this operation to query the prices of cloud desktops by setting ResourceType to Desktop, you must know the desktop types and disk sizes that EDS provides. The disk sizes vary based on the desktop types. For more information, see [Cloud desktop types](https://help.aliyun.com/document_detail/188609.html).
        
        @param request: DescribePriceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePriceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.group_desktop_count):
            query['GroupDesktopCount'] = request.group_desktop_count
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.os_type):
            query['OsType'] = request.os_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.root_disk_category):
            query['RootDiskCategory'] = request.root_disk_category
        if not UtilClient.is_unset(request.root_disk_size_gib):
            query['RootDiskSizeGib'] = request.root_disk_size_gib
        if not UtilClient.is_unset(request.user_disk_category):
            query['UserDiskCategory'] = request.user_disk_category
        if not UtilClient.is_unset(request.user_disk_size_gib):
            query['UserDiskSizeGib'] = request.user_disk_size_gib
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_price(
        self,
        request: ecd_20200930_models.DescribePriceRequest,
    ) -> ecd_20200930_models.DescribePriceResponse:
        """
        @summary Queries the prices of Elastic Desktop Service (EDS) resources.
        
        @description ## Usage notes
        The request parameters vary based on the type of desktop resources whose price you want to query. Take note of the following items:
        If you set ResourceType to OfficeSite, you must specify InstanceType.
        If you set ResourceType to Bandwidth, the pay-by-data-transfer metering method is used for network billing.
        If you set ResourceType to Desktop, you must specify InstanceType, RootDiskSizeGib, and UserDiskSizeGib. You can specify OsType, PeriodUnit, Period, and Amount based on your business requirements.
        > Before you call this operation to query the prices of cloud desktops by setting ResourceType to Desktop, you must know the desktop types and disk sizes that EDS provides. The disk sizes vary based on the desktop types. For more information, see [Cloud desktop types](https://help.aliyun.com/document_detail/188609.html).
        
        @param request: DescribePriceRequest
        @return: DescribePriceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_price_with_options(request, runtime)

    async def describe_price_async(
        self,
        request: ecd_20200930_models.DescribePriceRequest,
    ) -> ecd_20200930_models.DescribePriceResponse:
        """
        @summary Queries the prices of Elastic Desktop Service (EDS) resources.
        
        @description ## Usage notes
        The request parameters vary based on the type of desktop resources whose price you want to query. Take note of the following items:
        If you set ResourceType to OfficeSite, you must specify InstanceType.
        If you set ResourceType to Bandwidth, the pay-by-data-transfer metering method is used for network billing.
        If you set ResourceType to Desktop, you must specify InstanceType, RootDiskSizeGib, and UserDiskSizeGib. You can specify OsType, PeriodUnit, Period, and Amount based on your business requirements.
        > Before you call this operation to query the prices of cloud desktops by setting ResourceType to Desktop, you must know the desktop types and disk sizes that EDS provides. The disk sizes vary based on the desktop types. For more information, see [Cloud desktop types](https://help.aliyun.com/document_detail/188609.html).
        
        @param request: DescribePriceRequest
        @return: DescribePriceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_price_with_options_async(request, runtime)

    def describe_price_for_create_desktop_oversold_group_with_options(
        self,
        request: ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupResponse:
        """
        @summary 查询价格用于创建超卖组
        
        @param request: DescribePriceForCreateDesktopOversoldGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePriceForCreateDesktopOversoldGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.concurrence_count):
            query['ConcurrenceCount'] = request.concurrence_count
        if not UtilClient.is_unset(request.data_disk_size):
            query['DataDiskSize'] = request.data_disk_size
        if not UtilClient.is_unset(request.desktop_type):
            query['DesktopType'] = request.desktop_type
        if not UtilClient.is_unset(request.oversold_user_count):
            query['OversoldUserCount'] = request.oversold_user_count
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePriceForCreateDesktopOversoldGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_price_for_create_desktop_oversold_group_with_options_async(
        self,
        request: ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupResponse:
        """
        @summary 查询价格用于创建超卖组
        
        @param request: DescribePriceForCreateDesktopOversoldGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePriceForCreateDesktopOversoldGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.concurrence_count):
            query['ConcurrenceCount'] = request.concurrence_count
        if not UtilClient.is_unset(request.data_disk_size):
            query['DataDiskSize'] = request.data_disk_size
        if not UtilClient.is_unset(request.desktop_type):
            query['DesktopType'] = request.desktop_type
        if not UtilClient.is_unset(request.oversold_user_count):
            query['OversoldUserCount'] = request.oversold_user_count
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePriceForCreateDesktopOversoldGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_price_for_create_desktop_oversold_group(
        self,
        request: ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupRequest,
    ) -> ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupResponse:
        """
        @summary 查询价格用于创建超卖组
        
        @param request: DescribePriceForCreateDesktopOversoldGroupRequest
        @return: DescribePriceForCreateDesktopOversoldGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_price_for_create_desktop_oversold_group_with_options(request, runtime)

    async def describe_price_for_create_desktop_oversold_group_async(
        self,
        request: ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupRequest,
    ) -> ecd_20200930_models.DescribePriceForCreateDesktopOversoldGroupResponse:
        """
        @summary 查询价格用于创建超卖组
        
        @param request: DescribePriceForCreateDesktopOversoldGroupRequest
        @return: DescribePriceForCreateDesktopOversoldGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_price_for_create_desktop_oversold_group_with_options_async(request, runtime)

    def describe_price_for_modify_desktop_oversold_group_sale_with_options(
        self,
        request: ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleResponse:
        """
        @summary 查询价格用于变配超卖组
        
        @param request: DescribePriceForModifyDesktopOversoldGroupSaleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePriceForModifyDesktopOversoldGroupSaleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.concurrence_count):
            query['ConcurrenceCount'] = request.concurrence_count
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.oversold_user_count):
            query['OversoldUserCount'] = request.oversold_user_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePriceForModifyDesktopOversoldGroupSale',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_price_for_modify_desktop_oversold_group_sale_with_options_async(
        self,
        request: ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleResponse:
        """
        @summary 查询价格用于变配超卖组
        
        @param request: DescribePriceForModifyDesktopOversoldGroupSaleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePriceForModifyDesktopOversoldGroupSaleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.concurrence_count):
            query['ConcurrenceCount'] = request.concurrence_count
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.oversold_user_count):
            query['OversoldUserCount'] = request.oversold_user_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePriceForModifyDesktopOversoldGroupSale',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_price_for_modify_desktop_oversold_group_sale(
        self,
        request: ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleRequest,
    ) -> ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleResponse:
        """
        @summary 查询价格用于变配超卖组
        
        @param request: DescribePriceForModifyDesktopOversoldGroupSaleRequest
        @return: DescribePriceForModifyDesktopOversoldGroupSaleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_price_for_modify_desktop_oversold_group_sale_with_options(request, runtime)

    async def describe_price_for_modify_desktop_oversold_group_sale_async(
        self,
        request: ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleRequest,
    ) -> ecd_20200930_models.DescribePriceForModifyDesktopOversoldGroupSaleResponse:
        """
        @summary 查询价格用于变配超卖组
        
        @param request: DescribePriceForModifyDesktopOversoldGroupSaleRequest
        @return: DescribePriceForModifyDesktopOversoldGroupSaleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_price_for_modify_desktop_oversold_group_sale_with_options_async(request, runtime)

    def describe_price_for_renew_desktop_oversold_group_with_options(
        self,
        request: ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupResponse:
        """
        @summary 查询价格用于续费超卖组
        
        @param request: DescribePriceForRenewDesktopOversoldGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePriceForRenewDesktopOversoldGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePriceForRenewDesktopOversoldGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_price_for_renew_desktop_oversold_group_with_options_async(
        self,
        request: ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupResponse:
        """
        @summary 查询价格用于续费超卖组
        
        @param request: DescribePriceForRenewDesktopOversoldGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePriceForRenewDesktopOversoldGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePriceForRenewDesktopOversoldGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_price_for_renew_desktop_oversold_group(
        self,
        request: ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupRequest,
    ) -> ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupResponse:
        """
        @summary 查询价格用于续费超卖组
        
        @param request: DescribePriceForRenewDesktopOversoldGroupRequest
        @return: DescribePriceForRenewDesktopOversoldGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_price_for_renew_desktop_oversold_group_with_options(request, runtime)

    async def describe_price_for_renew_desktop_oversold_group_async(
        self,
        request: ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupRequest,
    ) -> ecd_20200930_models.DescribePriceForRenewDesktopOversoldGroupResponse:
        """
        @summary 查询价格用于续费超卖组
        
        @param request: DescribePriceForRenewDesktopOversoldGroupRequest
        @return: DescribePriceForRenewDesktopOversoldGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_price_for_renew_desktop_oversold_group_with_options_async(request, runtime)

    def describe_recordings_with_options(
        self,
        request: ecd_20200930_models.DescribeRecordingsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeRecordingsResponse:
        """
        @param request: DescribeRecordingsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRecordingsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.need_signed_url):
            query['NeedSignedUrl'] = request.need_signed_url
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.signed_url_expire_minutes):
            query['SignedUrlExpireMinutes'] = request.signed_url_expire_minutes
        if not UtilClient.is_unset(request.standard_end_time):
            query['StandardEndTime'] = request.standard_end_time
        if not UtilClient.is_unset(request.standard_start_time):
            query['StandardStartTime'] = request.standard_start_time
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRecordings',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRecordingsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRecordingsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_recordings_with_options_async(
        self,
        request: ecd_20200930_models.DescribeRecordingsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeRecordingsResponse:
        """
        @param request: DescribeRecordingsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRecordingsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.need_signed_url):
            query['NeedSignedUrl'] = request.need_signed_url
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.signed_url_expire_minutes):
            query['SignedUrlExpireMinutes'] = request.signed_url_expire_minutes
        if not UtilClient.is_unset(request.standard_end_time):
            query['StandardEndTime'] = request.standard_end_time
        if not UtilClient.is_unset(request.standard_start_time):
            query['StandardStartTime'] = request.standard_start_time
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRecordings',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRecordingsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRecordingsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_recordings(
        self,
        request: ecd_20200930_models.DescribeRecordingsRequest,
    ) -> ecd_20200930_models.DescribeRecordingsResponse:
        """
        @param request: DescribeRecordingsRequest
        @return: DescribeRecordingsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_recordings_with_options(request, runtime)

    async def describe_recordings_async(
        self,
        request: ecd_20200930_models.DescribeRecordingsRequest,
    ) -> ecd_20200930_models.DescribeRecordingsResponse:
        """
        @param request: DescribeRecordingsRequest
        @return: DescribeRecordingsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_recordings_with_options_async(request, runtime)

    def describe_refund_price_with_options(
        self,
        request: ecd_20200930_models.DescribeRefundPriceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeRefundPriceResponse:
        """
        @summary Queries the refund amount for unsubscribing from a cloud computer.
        
        @param request: DescribeRefundPriceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRefundPriceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.refund_type):
            query['RefundType'] = request.refund_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRefundPrice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRefundPriceResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRefundPriceResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_refund_price_with_options_async(
        self,
        request: ecd_20200930_models.DescribeRefundPriceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeRefundPriceResponse:
        """
        @summary Queries the refund amount for unsubscribing from a cloud computer.
        
        @param request: DescribeRefundPriceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRefundPriceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.refund_type):
            query['RefundType'] = request.refund_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRefundPrice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRefundPriceResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRefundPriceResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_refund_price(
        self,
        request: ecd_20200930_models.DescribeRefundPriceRequest,
    ) -> ecd_20200930_models.DescribeRefundPriceResponse:
        """
        @summary Queries the refund amount for unsubscribing from a cloud computer.
        
        @param request: DescribeRefundPriceRequest
        @return: DescribeRefundPriceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_refund_price_with_options(request, runtime)

    async def describe_refund_price_async(
        self,
        request: ecd_20200930_models.DescribeRefundPriceRequest,
    ) -> ecd_20200930_models.DescribeRefundPriceResponse:
        """
        @summary Queries the refund amount for unsubscribing from a cloud computer.
        
        @param request: DescribeRefundPriceRequest
        @return: DescribeRefundPriceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_refund_price_with_options_async(request, runtime)

    def describe_regions_with_options(
        self,
        request: ecd_20200930_models.DescribeRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeRegionsResponse:
        """
        @summary Queries the Alibaba Cloud regions that are available for Elastic Desktop Service (EDS).
        
        @param request: DescribeRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegions',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRegionsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRegionsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_regions_with_options_async(
        self,
        request: ecd_20200930_models.DescribeRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeRegionsResponse:
        """
        @summary Queries the Alibaba Cloud regions that are available for Elastic Desktop Service (EDS).
        
        @param request: DescribeRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegions',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRegionsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRegionsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_regions(
        self,
        request: ecd_20200930_models.DescribeRegionsRequest,
    ) -> ecd_20200930_models.DescribeRegionsResponse:
        """
        @summary Queries the Alibaba Cloud regions that are available for Elastic Desktop Service (EDS).
        
        @param request: DescribeRegionsRequest
        @return: DescribeRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_regions_with_options(request, runtime)

    async def describe_regions_async(
        self,
        request: ecd_20200930_models.DescribeRegionsRequest,
    ) -> ecd_20200930_models.DescribeRegionsResponse:
        """
        @summary Queries the Alibaba Cloud regions that are available for Elastic Desktop Service (EDS).
        
        @param request: DescribeRegionsRequest
        @return: DescribeRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_regions_with_options_async(request, runtime)

    def describe_renewal_price_with_options(
        self,
        request: ecd_20200930_models.DescribeRenewalPriceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeRenewalPriceResponse:
        """
        @param request: DescribeRenewalPriceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRenewalPriceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRenewalPrice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRenewalPriceResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRenewalPriceResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_renewal_price_with_options_async(
        self,
        request: ecd_20200930_models.DescribeRenewalPriceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeRenewalPriceResponse:
        """
        @param request: DescribeRenewalPriceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRenewalPriceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRenewalPrice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRenewalPriceResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeRenewalPriceResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_renewal_price(
        self,
        request: ecd_20200930_models.DescribeRenewalPriceRequest,
    ) -> ecd_20200930_models.DescribeRenewalPriceResponse:
        """
        @param request: DescribeRenewalPriceRequest
        @return: DescribeRenewalPriceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_renewal_price_with_options(request, runtime)

    async def describe_renewal_price_async(
        self,
        request: ecd_20200930_models.DescribeRenewalPriceRequest,
    ) -> ecd_20200930_models.DescribeRenewalPriceResponse:
        """
        @param request: DescribeRenewalPriceRequest
        @return: DescribeRenewalPriceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_renewal_price_with_options_async(request, runtime)

    def describe_session_statistic_with_options(
        self,
        request: ecd_20200930_models.DescribeSessionStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeSessionStatisticResponse:
        """
        @summary Queries the session statistics of a region.
        
        @description    This is a central operation and can be called only by using services in the China (Shanghai) region.
        You can query session statistics for the past hour.
        
        @param request: DescribeSessionStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSessionStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.search_region_id):
            query['SearchRegionId'] = request.search_region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSessionStatistic',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeSessionStatisticResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeSessionStatisticResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_session_statistic_with_options_async(
        self,
        request: ecd_20200930_models.DescribeSessionStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeSessionStatisticResponse:
        """
        @summary Queries the session statistics of a region.
        
        @description    This is a central operation and can be called only by using services in the China (Shanghai) region.
        You can query session statistics for the past hour.
        
        @param request: DescribeSessionStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSessionStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.search_region_id):
            query['SearchRegionId'] = request.search_region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSessionStatistic',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeSessionStatisticResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeSessionStatisticResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_session_statistic(
        self,
        request: ecd_20200930_models.DescribeSessionStatisticRequest,
    ) -> ecd_20200930_models.DescribeSessionStatisticResponse:
        """
        @summary Queries the session statistics of a region.
        
        @description    This is a central operation and can be called only by using services in the China (Shanghai) region.
        You can query session statistics for the past hour.
        
        @param request: DescribeSessionStatisticRequest
        @return: DescribeSessionStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_session_statistic_with_options(request, runtime)

    async def describe_session_statistic_async(
        self,
        request: ecd_20200930_models.DescribeSessionStatisticRequest,
    ) -> ecd_20200930_models.DescribeSessionStatisticResponse:
        """
        @summary Queries the session statistics of a region.
        
        @description    This is a central operation and can be called only by using services in the China (Shanghai) region.
        You can query session statistics for the past hour.
        
        @param request: DescribeSessionStatisticRequest
        @return: DescribeSessionStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_session_statistic_with_options_async(request, runtime)

    def describe_snapshots_with_options(
        self,
        request: ecd_20200930_models.DescribeSnapshotsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeSnapshotsResponse:
        """
        @summary Queries the snapshots that are created based on a cloud computer and the details of the snapshots.
        
        @param request: DescribeSnapshotsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSnapshotsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.creator):
            query['Creator'] = request.creator
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        if not UtilClient.is_unset(request.snapshot_type):
            query['SnapshotType'] = request.snapshot_type
        if not UtilClient.is_unset(request.source_disk_type):
            query['SourceDiskType'] = request.source_disk_type
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnapshots',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeSnapshotsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeSnapshotsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_snapshots_with_options_async(
        self,
        request: ecd_20200930_models.DescribeSnapshotsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeSnapshotsResponse:
        """
        @summary Queries the snapshots that are created based on a cloud computer and the details of the snapshots.
        
        @param request: DescribeSnapshotsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSnapshotsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.creator):
            query['Creator'] = request.creator
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        if not UtilClient.is_unset(request.snapshot_type):
            query['SnapshotType'] = request.snapshot_type
        if not UtilClient.is_unset(request.source_disk_type):
            query['SourceDiskType'] = request.source_disk_type
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnapshots',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeSnapshotsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeSnapshotsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_snapshots(
        self,
        request: ecd_20200930_models.DescribeSnapshotsRequest,
    ) -> ecd_20200930_models.DescribeSnapshotsResponse:
        """
        @summary Queries the snapshots that are created based on a cloud computer and the details of the snapshots.
        
        @param request: DescribeSnapshotsRequest
        @return: DescribeSnapshotsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_snapshots_with_options(request, runtime)

    async def describe_snapshots_async(
        self,
        request: ecd_20200930_models.DescribeSnapshotsRequest,
    ) -> ecd_20200930_models.DescribeSnapshotsResponse:
        """
        @summary Queries the snapshots that are created based on a cloud computer and the details of the snapshots.
        
        @param request: DescribeSnapshotsRequest
        @return: DescribeSnapshotsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_snapshots_with_options_async(request, runtime)

    def describe_timer_group_with_options(
        self,
        request: ecd_20200930_models.DescribeTimerGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeTimerGroupResponse:
        """
        @summary Queries a scheduled task configuration group.
        
        @param request: DescribeTimerGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTimerGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTimerGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeTimerGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeTimerGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_timer_group_with_options_async(
        self,
        request: ecd_20200930_models.DescribeTimerGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeTimerGroupResponse:
        """
        @summary Queries a scheduled task configuration group.
        
        @param request: DescribeTimerGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTimerGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTimerGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeTimerGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeTimerGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_timer_group(
        self,
        request: ecd_20200930_models.DescribeTimerGroupRequest,
    ) -> ecd_20200930_models.DescribeTimerGroupResponse:
        """
        @summary Queries a scheduled task configuration group.
        
        @param request: DescribeTimerGroupRequest
        @return: DescribeTimerGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_timer_group_with_options(request, runtime)

    async def describe_timer_group_async(
        self,
        request: ecd_20200930_models.DescribeTimerGroupRequest,
    ) -> ecd_20200930_models.DescribeTimerGroupResponse:
        """
        @summary Queries a scheduled task configuration group.
        
        @param request: DescribeTimerGroupRequest
        @return: DescribeTimerGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_timer_group_with_options_async(request, runtime)

    def describe_user_connect_time_with_options(
        self,
        request: ecd_20200930_models.DescribeUserConnectTimeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeUserConnectTimeResponse:
        """
        @summary 查询超卖组中用户连接数据
        
        @param request: DescribeUserConnectTimeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserConnectTimeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user_desktop_id):
            query['UserDesktopId'] = request.user_desktop_id
        if not UtilClient.is_unset(request.user_group_id):
            query['UserGroupId'] = request.user_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserConnectTime',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserConnectTimeResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserConnectTimeResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_user_connect_time_with_options_async(
        self,
        request: ecd_20200930_models.DescribeUserConnectTimeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeUserConnectTimeResponse:
        """
        @summary 查询超卖组中用户连接数据
        
        @param request: DescribeUserConnectTimeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserConnectTimeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user_desktop_id):
            query['UserDesktopId'] = request.user_desktop_id
        if not UtilClient.is_unset(request.user_group_id):
            query['UserGroupId'] = request.user_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserConnectTime',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserConnectTimeResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserConnectTimeResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_user_connect_time(
        self,
        request: ecd_20200930_models.DescribeUserConnectTimeRequest,
    ) -> ecd_20200930_models.DescribeUserConnectTimeResponse:
        """
        @summary 查询超卖组中用户连接数据
        
        @param request: DescribeUserConnectTimeRequest
        @return: DescribeUserConnectTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_user_connect_time_with_options(request, runtime)

    async def describe_user_connect_time_async(
        self,
        request: ecd_20200930_models.DescribeUserConnectTimeRequest,
    ) -> ecd_20200930_models.DescribeUserConnectTimeResponse:
        """
        @summary 查询超卖组中用户连接数据
        
        @param request: DescribeUserConnectTimeRequest
        @return: DescribeUserConnectTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_connect_time_with_options_async(request, runtime)

    def describe_user_connection_records_with_options(
        self,
        request: ecd_20200930_models.DescribeUserConnectionRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeUserConnectionRecordsResponse:
        """
        @summary Queries the connection records of an authorized user to cloud computers in a cloud computer pool.
        
        @param request: DescribeUserConnectionRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserConnectionRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connect_duration_from):
            query['ConnectDurationFrom'] = request.connect_duration_from
        if not UtilClient.is_unset(request.connect_duration_to):
            query['ConnectDurationTo'] = request.connect_duration_to
        if not UtilClient.is_unset(request.connect_end_time_from):
            query['ConnectEndTimeFrom'] = request.connect_end_time_from
        if not UtilClient.is_unset(request.connect_end_time_to):
            query['ConnectEndTimeTo'] = request.connect_end_time_to
        if not UtilClient.is_unset(request.connect_start_time_from):
            query['ConnectStartTimeFrom'] = request.connect_start_time_from
        if not UtilClient.is_unset(request.connect_start_time_to):
            query['ConnectStartTimeTo'] = request.connect_start_time_to
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.end_user_type):
            query['EndUserType'] = request.end_user_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserConnectionRecords',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserConnectionRecordsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserConnectionRecordsResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_user_connection_records_with_options_async(
        self,
        request: ecd_20200930_models.DescribeUserConnectionRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeUserConnectionRecordsResponse:
        """
        @summary Queries the connection records of an authorized user to cloud computers in a cloud computer pool.
        
        @param request: DescribeUserConnectionRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserConnectionRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connect_duration_from):
            query['ConnectDurationFrom'] = request.connect_duration_from
        if not UtilClient.is_unset(request.connect_duration_to):
            query['ConnectDurationTo'] = request.connect_duration_to
        if not UtilClient.is_unset(request.connect_end_time_from):
            query['ConnectEndTimeFrom'] = request.connect_end_time_from
        if not UtilClient.is_unset(request.connect_end_time_to):
            query['ConnectEndTimeTo'] = request.connect_end_time_to
        if not UtilClient.is_unset(request.connect_start_time_from):
            query['ConnectStartTimeFrom'] = request.connect_start_time_from
        if not UtilClient.is_unset(request.connect_start_time_to):
            query['ConnectStartTimeTo'] = request.connect_start_time_to
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.end_user_type):
            query['EndUserType'] = request.end_user_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserConnectionRecords',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserConnectionRecordsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserConnectionRecordsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_user_connection_records(
        self,
        request: ecd_20200930_models.DescribeUserConnectionRecordsRequest,
    ) -> ecd_20200930_models.DescribeUserConnectionRecordsResponse:
        """
        @summary Queries the connection records of an authorized user to cloud computers in a cloud computer pool.
        
        @param request: DescribeUserConnectionRecordsRequest
        @return: DescribeUserConnectionRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_user_connection_records_with_options(request, runtime)

    async def describe_user_connection_records_async(
        self,
        request: ecd_20200930_models.DescribeUserConnectionRecordsRequest,
    ) -> ecd_20200930_models.DescribeUserConnectionRecordsResponse:
        """
        @summary Queries the connection records of an authorized user to cloud computers in a cloud computer pool.
        
        @param request: DescribeUserConnectionRecordsRequest
        @return: DescribeUserConnectionRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_connection_records_with_options_async(request, runtime)

    def describe_user_profile_path_rules_with_options(
        self,
        request: ecd_20200930_models.DescribeUserProfilePathRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeUserProfilePathRulesResponse:
        """
        @summary Queries the configurations of the user profile management (UPM) directory blacklist and whitelist.
        
        @param request: DescribeUserProfilePathRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserProfilePathRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserProfilePathRules',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserProfilePathRulesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserProfilePathRulesResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_user_profile_path_rules_with_options_async(
        self,
        request: ecd_20200930_models.DescribeUserProfilePathRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeUserProfilePathRulesResponse:
        """
        @summary Queries the configurations of the user profile management (UPM) directory blacklist and whitelist.
        
        @param request: DescribeUserProfilePathRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserProfilePathRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserProfilePathRules',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserProfilePathRulesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUserProfilePathRulesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_user_profile_path_rules(
        self,
        request: ecd_20200930_models.DescribeUserProfilePathRulesRequest,
    ) -> ecd_20200930_models.DescribeUserProfilePathRulesResponse:
        """
        @summary Queries the configurations of the user profile management (UPM) directory blacklist and whitelist.
        
        @param request: DescribeUserProfilePathRulesRequest
        @return: DescribeUserProfilePathRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_user_profile_path_rules_with_options(request, runtime)

    async def describe_user_profile_path_rules_async(
        self,
        request: ecd_20200930_models.DescribeUserProfilePathRulesRequest,
    ) -> ecd_20200930_models.DescribeUserProfilePathRulesResponse:
        """
        @summary Queries the configurations of the user profile management (UPM) directory blacklist and whitelist.
        
        @param request: DescribeUserProfilePathRulesRequest
        @return: DescribeUserProfilePathRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_profile_path_rules_with_options_async(request, runtime)

    def describe_users_in_group_with_options(
        self,
        request: ecd_20200930_models.DescribeUsersInGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeUsersInGroupResponse:
        """
        @summary Queries the information about authorized users in a cloud computer pool, including the usernames, email addresses, mobile numbers, and cloud computer IDs.
        
        @param request: DescribeUsersInGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUsersInGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connect_state):
            query['ConnectState'] = request.connect_state
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.end_user_ids):
            query['EndUserIds'] = request.end_user_ids
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.org_id):
            query['OrgId'] = request.org_id
        if not UtilClient.is_unset(request.query_user_detail):
            query['QueryUserDetail'] = request.query_user_detail
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUsersInGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUsersInGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUsersInGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_users_in_group_with_options_async(
        self,
        request: ecd_20200930_models.DescribeUsersInGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeUsersInGroupResponse:
        """
        @summary Queries the information about authorized users in a cloud computer pool, including the usernames, email addresses, mobile numbers, and cloud computer IDs.
        
        @param request: DescribeUsersInGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUsersInGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connect_state):
            query['ConnectState'] = request.connect_state
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.end_user_ids):
            query['EndUserIds'] = request.end_user_ids
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.org_id):
            query['OrgId'] = request.org_id
        if not UtilClient.is_unset(request.query_user_detail):
            query['QueryUserDetail'] = request.query_user_detail
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUsersInGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUsersInGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUsersInGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_users_in_group(
        self,
        request: ecd_20200930_models.DescribeUsersInGroupRequest,
    ) -> ecd_20200930_models.DescribeUsersInGroupResponse:
        """
        @summary Queries the information about authorized users in a cloud computer pool, including the usernames, email addresses, mobile numbers, and cloud computer IDs.
        
        @param request: DescribeUsersInGroupRequest
        @return: DescribeUsersInGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_users_in_group_with_options(request, runtime)

    async def describe_users_in_group_async(
        self,
        request: ecd_20200930_models.DescribeUsersInGroupRequest,
    ) -> ecd_20200930_models.DescribeUsersInGroupResponse:
        """
        @summary Queries the information about authorized users in a cloud computer pool, including the usernames, email addresses, mobile numbers, and cloud computer IDs.
        
        @param request: DescribeUsersInGroupRequest
        @return: DescribeUsersInGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_users_in_group_with_options_async(request, runtime)

    def describe_users_password_with_options(
        self,
        request: ecd_20200930_models.DescribeUsersPasswordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeUsersPasswordResponse:
        """
        @summary Queries the passwords of authorized users of a cloud computer.
        
        @param request: DescribeUsersPasswordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUsersPasswordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUsersPassword',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUsersPasswordResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUsersPasswordResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_users_password_with_options_async(
        self,
        request: ecd_20200930_models.DescribeUsersPasswordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeUsersPasswordResponse:
        """
        @summary Queries the passwords of authorized users of a cloud computer.
        
        @param request: DescribeUsersPasswordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUsersPasswordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUsersPassword',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUsersPasswordResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeUsersPasswordResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_users_password(
        self,
        request: ecd_20200930_models.DescribeUsersPasswordRequest,
    ) -> ecd_20200930_models.DescribeUsersPasswordResponse:
        """
        @summary Queries the passwords of authorized users of a cloud computer.
        
        @param request: DescribeUsersPasswordRequest
        @return: DescribeUsersPasswordResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_users_password_with_options(request, runtime)

    async def describe_users_password_async(
        self,
        request: ecd_20200930_models.DescribeUsersPasswordRequest,
    ) -> ecd_20200930_models.DescribeUsersPasswordResponse:
        """
        @summary Queries the passwords of authorized users of a cloud computer.
        
        @param request: DescribeUsersPasswordRequest
        @return: DescribeUsersPasswordResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_users_password_with_options_async(request, runtime)

    def describe_virtual_mfadevices_with_options(
        self,
        request: ecd_20200930_models.DescribeVirtualMFADevicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeVirtualMFADevicesResponse:
        """
        @summary Queries multi-factor authentication (MFA) devices that are bound to an Active Directory (AD) account.
        
        @param request: DescribeVirtualMFADevicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVirtualMFADevicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVirtualMFADevices',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeVirtualMFADevicesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeVirtualMFADevicesResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_virtual_mfadevices_with_options_async(
        self,
        request: ecd_20200930_models.DescribeVirtualMFADevicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeVirtualMFADevicesResponse:
        """
        @summary Queries multi-factor authentication (MFA) devices that are bound to an Active Directory (AD) account.
        
        @param request: DescribeVirtualMFADevicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVirtualMFADevicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVirtualMFADevices',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeVirtualMFADevicesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeVirtualMFADevicesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_virtual_mfadevices(
        self,
        request: ecd_20200930_models.DescribeVirtualMFADevicesRequest,
    ) -> ecd_20200930_models.DescribeVirtualMFADevicesResponse:
        """
        @summary Queries multi-factor authentication (MFA) devices that are bound to an Active Directory (AD) account.
        
        @param request: DescribeVirtualMFADevicesRequest
        @return: DescribeVirtualMFADevicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_virtual_mfadevices_with_options(request, runtime)

    async def describe_virtual_mfadevices_async(
        self,
        request: ecd_20200930_models.DescribeVirtualMFADevicesRequest,
    ) -> ecd_20200930_models.DescribeVirtualMFADevicesResponse:
        """
        @summary Queries multi-factor authentication (MFA) devices that are bound to an Active Directory (AD) account.
        
        @param request: DescribeVirtualMFADevicesRequest
        @return: DescribeVirtualMFADevicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_virtual_mfadevices_with_options_async(request, runtime)

    def describe_zones_with_options(
        self,
        request: ecd_20200930_models.DescribeZonesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeZonesResponse:
        """
        @summary Queries the zones in a region in which Elastic Desktop Service is supported.
        
        @param request: DescribeZonesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeZonesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.zone_type):
            query['ZoneType'] = request.zone_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeZones',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeZonesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeZonesResponse(),
                self.execute(params, req, runtime)
            )

    async def describe_zones_with_options_async(
        self,
        request: ecd_20200930_models.DescribeZonesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DescribeZonesResponse:
        """
        @summary Queries the zones in a region in which Elastic Desktop Service is supported.
        
        @param request: DescribeZonesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeZonesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.zone_type):
            query['ZoneType'] = request.zone_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeZones',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DescribeZonesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DescribeZonesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def describe_zones(
        self,
        request: ecd_20200930_models.DescribeZonesRequest,
    ) -> ecd_20200930_models.DescribeZonesResponse:
        """
        @summary Queries the zones in a region in which Elastic Desktop Service is supported.
        
        @param request: DescribeZonesRequest
        @return: DescribeZonesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_zones_with_options(request, runtime)

    async def describe_zones_async(
        self,
        request: ecd_20200930_models.DescribeZonesRequest,
    ) -> ecd_20200930_models.DescribeZonesResponse:
        """
        @summary Queries the zones in a region in which Elastic Desktop Service is supported.
        
        @param request: DescribeZonesRequest
        @return: DescribeZonesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_zones_with_options_async(request, runtime)

    def detach_cen_with_options(
        self,
        request: ecd_20200930_models.DetachCenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DetachCenResponse:
        """
        @summary Unbinds an advanced office network from a CEN instance.
        
        @param request: DetachCenRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetachCenResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachCen',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DetachCenResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DetachCenResponse(),
                self.execute(params, req, runtime)
            )

    async def detach_cen_with_options_async(
        self,
        request: ecd_20200930_models.DetachCenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DetachCenResponse:
        """
        @summary Unbinds an advanced office network from a CEN instance.
        
        @param request: DetachCenRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetachCenResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachCen',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DetachCenResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DetachCenResponse(),
                await self.execute_async(params, req, runtime)
            )

    def detach_cen(
        self,
        request: ecd_20200930_models.DetachCenRequest,
    ) -> ecd_20200930_models.DetachCenResponse:
        """
        @summary Unbinds an advanced office network from a CEN instance.
        
        @param request: DetachCenRequest
        @return: DetachCenResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.detach_cen_with_options(request, runtime)

    async def detach_cen_async(
        self,
        request: ecd_20200930_models.DetachCenRequest,
    ) -> ecd_20200930_models.DetachCenResponse:
        """
        @summary Unbinds an advanced office network from a CEN instance.
        
        @param request: DetachCenRequest
        @return: DetachCenResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.detach_cen_with_options_async(request, runtime)

    def detach_end_user_with_options(
        self,
        request: ecd_20200930_models.DetachEndUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DetachEndUserResponse:
        """
        @summary Unbinds a hardware client from a user.
        
        @param request: DetachEndUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetachEndUserResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_domain):
            query['AdDomain'] = request.ad_domain
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.device_id):
            query['DeviceId'] = request.device_id
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachEndUser',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DetachEndUserResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DetachEndUserResponse(),
                self.execute(params, req, runtime)
            )

    async def detach_end_user_with_options_async(
        self,
        request: ecd_20200930_models.DetachEndUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DetachEndUserResponse:
        """
        @summary Unbinds a hardware client from a user.
        
        @param request: DetachEndUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetachEndUserResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_domain):
            query['AdDomain'] = request.ad_domain
        if not UtilClient.is_unset(request.client_type):
            query['ClientType'] = request.client_type
        if not UtilClient.is_unset(request.device_id):
            query['DeviceId'] = request.device_id
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachEndUser',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DetachEndUserResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DetachEndUserResponse(),
                await self.execute_async(params, req, runtime)
            )

    def detach_end_user(
        self,
        request: ecd_20200930_models.DetachEndUserRequest,
    ) -> ecd_20200930_models.DetachEndUserResponse:
        """
        @summary Unbinds a hardware client from a user.
        
        @param request: DetachEndUserRequest
        @return: DetachEndUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.detach_end_user_with_options(request, runtime)

    async def detach_end_user_async(
        self,
        request: ecd_20200930_models.DetachEndUserRequest,
    ) -> ecd_20200930_models.DetachEndUserResponse:
        """
        @summary Unbinds a hardware client from a user.
        
        @param request: DetachEndUserRequest
        @return: DetachEndUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.detach_end_user_with_options_async(request, runtime)

    def disable_desktops_in_group_with_options(
        self,
        request: ecd_20200930_models.DisableDesktopsInGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DisableDesktopsInGroupResponse:
        """
        @summary Disables cloud desktops in a desktop group.
        
        @param request: DisableDesktopsInGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DisableDesktopsInGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_ids):
            query['DesktopIds'] = request.desktop_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableDesktopsInGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DisableDesktopsInGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DisableDesktopsInGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def disable_desktops_in_group_with_options_async(
        self,
        request: ecd_20200930_models.DisableDesktopsInGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DisableDesktopsInGroupResponse:
        """
        @summary Disables cloud desktops in a desktop group.
        
        @param request: DisableDesktopsInGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DisableDesktopsInGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_ids):
            query['DesktopIds'] = request.desktop_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableDesktopsInGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DisableDesktopsInGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DisableDesktopsInGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def disable_desktops_in_group(
        self,
        request: ecd_20200930_models.DisableDesktopsInGroupRequest,
    ) -> ecd_20200930_models.DisableDesktopsInGroupResponse:
        """
        @summary Disables cloud desktops in a desktop group.
        
        @param request: DisableDesktopsInGroupRequest
        @return: DisableDesktopsInGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.disable_desktops_in_group_with_options(request, runtime)

    async def disable_desktops_in_group_async(
        self,
        request: ecd_20200930_models.DisableDesktopsInGroupRequest,
    ) -> ecd_20200930_models.DisableDesktopsInGroupResponse:
        """
        @summary Disables cloud desktops in a desktop group.
        
        @param request: DisableDesktopsInGroupRequest
        @return: DisableDesktopsInGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.disable_desktops_in_group_with_options_async(request, runtime)

    def disconnect_desktop_sessions_with_options(
        self,
        request: ecd_20200930_models.DisconnectDesktopSessionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DisconnectDesktopSessionsResponse:
        """
        @summary Disconnects from desktop sessions.
        
        @param request: DisconnectDesktopSessionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DisconnectDesktopSessionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.pre_check):
            query['PreCheck'] = request.pre_check
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sessions):
            query['Sessions'] = request.sessions
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisconnectDesktopSessions',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DisconnectDesktopSessionsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DisconnectDesktopSessionsResponse(),
                self.execute(params, req, runtime)
            )

    async def disconnect_desktop_sessions_with_options_async(
        self,
        request: ecd_20200930_models.DisconnectDesktopSessionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DisconnectDesktopSessionsResponse:
        """
        @summary Disconnects from desktop sessions.
        
        @param request: DisconnectDesktopSessionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DisconnectDesktopSessionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.pre_check):
            query['PreCheck'] = request.pre_check
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sessions):
            query['Sessions'] = request.sessions
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisconnectDesktopSessions',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DisconnectDesktopSessionsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DisconnectDesktopSessionsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def disconnect_desktop_sessions(
        self,
        request: ecd_20200930_models.DisconnectDesktopSessionsRequest,
    ) -> ecd_20200930_models.DisconnectDesktopSessionsResponse:
        """
        @summary Disconnects from desktop sessions.
        
        @param request: DisconnectDesktopSessionsRequest
        @return: DisconnectDesktopSessionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.disconnect_desktop_sessions_with_options(request, runtime)

    async def disconnect_desktop_sessions_async(
        self,
        request: ecd_20200930_models.DisconnectDesktopSessionsRequest,
    ) -> ecd_20200930_models.DisconnectDesktopSessionsResponse:
        """
        @summary Disconnects from desktop sessions.
        
        @param request: DisconnectDesktopSessionsRequest
        @return: DisconnectDesktopSessionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.disconnect_desktop_sessions_with_options_async(request, runtime)

    def dissociate_network_package_with_options(
        self,
        request: ecd_20200930_models.DissociateNetworkPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DissociateNetworkPackageResponse:
        """
        @summary Unbinds a premium bandwidth plan from an office network.
        
        @param request: DissociateNetworkPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DissociateNetworkPackageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_package_id):
            query['NetworkPackageId'] = request.network_package_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DissociateNetworkPackage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DissociateNetworkPackageResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DissociateNetworkPackageResponse(),
                self.execute(params, req, runtime)
            )

    async def dissociate_network_package_with_options_async(
        self,
        request: ecd_20200930_models.DissociateNetworkPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DissociateNetworkPackageResponse:
        """
        @summary Unbinds a premium bandwidth plan from an office network.
        
        @param request: DissociateNetworkPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DissociateNetworkPackageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_package_id):
            query['NetworkPackageId'] = request.network_package_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DissociateNetworkPackage',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DissociateNetworkPackageResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DissociateNetworkPackageResponse(),
                await self.execute_async(params, req, runtime)
            )

    def dissociate_network_package(
        self,
        request: ecd_20200930_models.DissociateNetworkPackageRequest,
    ) -> ecd_20200930_models.DissociateNetworkPackageResponse:
        """
        @summary Unbinds a premium bandwidth plan from an office network.
        
        @param request: DissociateNetworkPackageRequest
        @return: DissociateNetworkPackageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.dissociate_network_package_with_options(request, runtime)

    async def dissociate_network_package_async(
        self,
        request: ecd_20200930_models.DissociateNetworkPackageRequest,
    ) -> ecd_20200930_models.DissociateNetworkPackageResponse:
        """
        @summary Unbinds a premium bandwidth plan from an office network.
        
        @param request: DissociateNetworkPackageRequest
        @return: DissociateNetworkPackageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.dissociate_network_package_with_options_async(request, runtime)

    def download_cds_file_with_options(
        self,
        request: ecd_20200930_models.DownloadCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DownloadCdsFileResponse:
        """
        @summary CDS文件下载
        
        @param request: DownloadCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DownloadCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DownloadCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DownloadCdsFileResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DownloadCdsFileResponse(),
                self.execute(params, req, runtime)
            )

    async def download_cds_file_with_options_async(
        self,
        request: ecd_20200930_models.DownloadCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.DownloadCdsFileResponse:
        """
        @summary CDS文件下载
        
        @param request: DownloadCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DownloadCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DownloadCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.DownloadCdsFileResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.DownloadCdsFileResponse(),
                await self.execute_async(params, req, runtime)
            )

    def download_cds_file(
        self,
        request: ecd_20200930_models.DownloadCdsFileRequest,
    ) -> ecd_20200930_models.DownloadCdsFileResponse:
        """
        @summary CDS文件下载
        
        @param request: DownloadCdsFileRequest
        @return: DownloadCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.download_cds_file_with_options(request, runtime)

    async def download_cds_file_async(
        self,
        request: ecd_20200930_models.DownloadCdsFileRequest,
    ) -> ecd_20200930_models.DownloadCdsFileResponse:
        """
        @summary CDS文件下载
        
        @param request: DownloadCdsFileRequest
        @return: DownloadCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.download_cds_file_with_options_async(request, runtime)

    def export_client_events_with_options(
        self,
        request: ecd_20200930_models.ExportClientEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ExportClientEventsResponse:
        """
        @summary Exports events that occur on a cloud desktop from an Alibaba Cloud Workspace client.
        
        @param request: ExportClientEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportClientEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.event_types):
            query['EventTypes'] = request.event_types
        if not UtilClient.is_unset(request.lang_type):
            query['LangType'] = request.lang_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportClientEvents',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ExportClientEventsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ExportClientEventsResponse(),
                self.execute(params, req, runtime)
            )

    async def export_client_events_with_options_async(
        self,
        request: ecd_20200930_models.ExportClientEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ExportClientEventsResponse:
        """
        @summary Exports events that occur on a cloud desktop from an Alibaba Cloud Workspace client.
        
        @param request: ExportClientEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportClientEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.event_types):
            query['EventTypes'] = request.event_types
        if not UtilClient.is_unset(request.lang_type):
            query['LangType'] = request.lang_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportClientEvents',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ExportClientEventsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ExportClientEventsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def export_client_events(
        self,
        request: ecd_20200930_models.ExportClientEventsRequest,
    ) -> ecd_20200930_models.ExportClientEventsResponse:
        """
        @summary Exports events that occur on a cloud desktop from an Alibaba Cloud Workspace client.
        
        @param request: ExportClientEventsRequest
        @return: ExportClientEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.export_client_events_with_options(request, runtime)

    async def export_client_events_async(
        self,
        request: ecd_20200930_models.ExportClientEventsRequest,
    ) -> ecd_20200930_models.ExportClientEventsResponse:
        """
        @summary Exports events that occur on a cloud desktop from an Alibaba Cloud Workspace client.
        
        @param request: ExportClientEventsRequest
        @return: ExportClientEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.export_client_events_with_options_async(request, runtime)

    def export_desktop_group_info_with_options(
        self,
        request: ecd_20200930_models.ExportDesktopGroupInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ExportDesktopGroupInfoResponse:
        """
        @summary Exports cloud computer pools. The list of cloud computer pools is saved as an XLSX file. Each entry of cloud computer pool data includes the ID and name of the cloud computer pool, the ID and name of the office network, the cloud computer pool template, and the name of the security policy.
        
        @param request: ExportDesktopGroupInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportDesktopGroupInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_group_name):
            query['DesktopGroupName'] = request.desktop_group_name
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.expired_time):
            query['ExpiredTime'] = request.expired_time
        if not UtilClient.is_unset(request.lang_type):
            query['LangType'] = request.lang_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportDesktopGroupInfo',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ExportDesktopGroupInfoResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ExportDesktopGroupInfoResponse(),
                self.execute(params, req, runtime)
            )

    async def export_desktop_group_info_with_options_async(
        self,
        request: ecd_20200930_models.ExportDesktopGroupInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ExportDesktopGroupInfoResponse:
        """
        @summary Exports cloud computer pools. The list of cloud computer pools is saved as an XLSX file. Each entry of cloud computer pool data includes the ID and name of the cloud computer pool, the ID and name of the office network, the cloud computer pool template, and the name of the security policy.
        
        @param request: ExportDesktopGroupInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportDesktopGroupInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_group_name):
            query['DesktopGroupName'] = request.desktop_group_name
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.expired_time):
            query['ExpiredTime'] = request.expired_time
        if not UtilClient.is_unset(request.lang_type):
            query['LangType'] = request.lang_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportDesktopGroupInfo',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ExportDesktopGroupInfoResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ExportDesktopGroupInfoResponse(),
                await self.execute_async(params, req, runtime)
            )

    def export_desktop_group_info(
        self,
        request: ecd_20200930_models.ExportDesktopGroupInfoRequest,
    ) -> ecd_20200930_models.ExportDesktopGroupInfoResponse:
        """
        @summary Exports cloud computer pools. The list of cloud computer pools is saved as an XLSX file. Each entry of cloud computer pool data includes the ID and name of the cloud computer pool, the ID and name of the office network, the cloud computer pool template, and the name of the security policy.
        
        @param request: ExportDesktopGroupInfoRequest
        @return: ExportDesktopGroupInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.export_desktop_group_info_with_options(request, runtime)

    async def export_desktop_group_info_async(
        self,
        request: ecd_20200930_models.ExportDesktopGroupInfoRequest,
    ) -> ecd_20200930_models.ExportDesktopGroupInfoResponse:
        """
        @summary Exports cloud computer pools. The list of cloud computer pools is saved as an XLSX file. Each entry of cloud computer pool data includes the ID and name of the cloud computer pool, the ID and name of the office network, the cloud computer pool template, and the name of the security policy.
        
        @param request: ExportDesktopGroupInfoRequest
        @return: ExportDesktopGroupInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.export_desktop_group_info_with_options_async(request, runtime)

    def export_desktop_list_info_with_options(
        self,
        request: ecd_20200930_models.ExportDesktopListInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ExportDesktopListInfoResponse:
        """
        @summary Exports a cloud computer list as a CSV file.
        
        @description The cloud computer list exported by calling this operation is saved as a CSV file. Each entry of data of a cloud computer includes the following fields:
        Cloud computer ID and name
        Office network ID and name
        The instance type, OS and protocol of the cloud computer
        System disk and data disk of the cloud computer
        The status
        Purchase method
        The time when the cloud computer expires
        Remaining duration and total duration
        Number of assigned users and number of current users
        Office network type
        The time when the cloud computer was created
        Tags
        Encryption status
        IP
        The hostname
        
        @param request: ExportDesktopListInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportDesktopListInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.desktop_status):
            query['DesktopStatus'] = request.desktop_status
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.expired_time):
            query['ExpiredTime'] = request.expired_time
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang_type):
            query['LangType'] = request.lang_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportDesktopListInfo',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ExportDesktopListInfoResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ExportDesktopListInfoResponse(),
                self.execute(params, req, runtime)
            )

    async def export_desktop_list_info_with_options_async(
        self,
        request: ecd_20200930_models.ExportDesktopListInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ExportDesktopListInfoResponse:
        """
        @summary Exports a cloud computer list as a CSV file.
        
        @description The cloud computer list exported by calling this operation is saved as a CSV file. Each entry of data of a cloud computer includes the following fields:
        Cloud computer ID and name
        Office network ID and name
        The instance type, OS and protocol of the cloud computer
        System disk and data disk of the cloud computer
        The status
        Purchase method
        The time when the cloud computer expires
        Remaining duration and total duration
        Number of assigned users and number of current users
        Office network type
        The time when the cloud computer was created
        Tags
        Encryption status
        IP
        The hostname
        
        @param request: ExportDesktopListInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportDesktopListInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.desktop_name):
            query['DesktopName'] = request.desktop_name
        if not UtilClient.is_unset(request.desktop_status):
            query['DesktopStatus'] = request.desktop_status
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.expired_time):
            query['ExpiredTime'] = request.expired_time
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang_type):
            query['LangType'] = request.lang_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportDesktopListInfo',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ExportDesktopListInfoResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ExportDesktopListInfoResponse(),
                await self.execute_async(params, req, runtime)
            )

    def export_desktop_list_info(
        self,
        request: ecd_20200930_models.ExportDesktopListInfoRequest,
    ) -> ecd_20200930_models.ExportDesktopListInfoResponse:
        """
        @summary Exports a cloud computer list as a CSV file.
        
        @description The cloud computer list exported by calling this operation is saved as a CSV file. Each entry of data of a cloud computer includes the following fields:
        Cloud computer ID and name
        Office network ID and name
        The instance type, OS and protocol of the cloud computer
        System disk and data disk of the cloud computer
        The status
        Purchase method
        The time when the cloud computer expires
        Remaining duration and total duration
        Number of assigned users and number of current users
        Office network type
        The time when the cloud computer was created
        Tags
        Encryption status
        IP
        The hostname
        
        @param request: ExportDesktopListInfoRequest
        @return: ExportDesktopListInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.export_desktop_list_info_with_options(request, runtime)

    async def export_desktop_list_info_async(
        self,
        request: ecd_20200930_models.ExportDesktopListInfoRequest,
    ) -> ecd_20200930_models.ExportDesktopListInfoResponse:
        """
        @summary Exports a cloud computer list as a CSV file.
        
        @description The cloud computer list exported by calling this operation is saved as a CSV file. Each entry of data of a cloud computer includes the following fields:
        Cloud computer ID and name
        Office network ID and name
        The instance type, OS and protocol of the cloud computer
        System disk and data disk of the cloud computer
        The status
        Purchase method
        The time when the cloud computer expires
        Remaining duration and total duration
        Number of assigned users and number of current users
        Office network type
        The time when the cloud computer was created
        Tags
        Encryption status
        IP
        The hostname
        
        @param request: ExportDesktopListInfoRequest
        @return: ExportDesktopListInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.export_desktop_list_info_with_options_async(request, runtime)

    def get_async_task_with_options(
        self,
        request: ecd_20200930_models.GetAsyncTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetAsyncTaskResponse:
        """
        @summary Obtains the information about an asynchronous task based on the value of the AsyncTaskId parameter that you obtain by calling the CopyCdsFile operation.
        
        @param request: GetAsyncTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAsyncTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.async_task_id):
            query['AsyncTaskId'] = request.async_task_id
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAsyncTask',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetAsyncTaskResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetAsyncTaskResponse(),
                self.execute(params, req, runtime)
            )

    async def get_async_task_with_options_async(
        self,
        request: ecd_20200930_models.GetAsyncTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetAsyncTaskResponse:
        """
        @summary Obtains the information about an asynchronous task based on the value of the AsyncTaskId parameter that you obtain by calling the CopyCdsFile operation.
        
        @param request: GetAsyncTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAsyncTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.async_task_id):
            query['AsyncTaskId'] = request.async_task_id
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAsyncTask',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetAsyncTaskResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetAsyncTaskResponse(),
                await self.execute_async(params, req, runtime)
            )

    def get_async_task(
        self,
        request: ecd_20200930_models.GetAsyncTaskRequest,
    ) -> ecd_20200930_models.GetAsyncTaskResponse:
        """
        @summary Obtains the information about an asynchronous task based on the value of the AsyncTaskId parameter that you obtain by calling the CopyCdsFile operation.
        
        @param request: GetAsyncTaskRequest
        @return: GetAsyncTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_async_task_with_options(request, runtime)

    async def get_async_task_async(
        self,
        request: ecd_20200930_models.GetAsyncTaskRequest,
    ) -> ecd_20200930_models.GetAsyncTaskResponse:
        """
        @summary Obtains the information about an asynchronous task based on the value of the AsyncTaskId parameter that you obtain by calling the CopyCdsFile operation.
        
        @param request: GetAsyncTaskRequest
        @return: GetAsyncTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_async_task_with_options_async(request, runtime)

    def get_connection_ticket_with_options(
        self,
        request: ecd_20200930_models.GetConnectionTicketRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetConnectionTicketResponse:
        """
        @summary Obtains the credential that is used to connect to a cloud desktop.
        
        @description The cloud computer must be in the Running state.
        
        @param request: GetConnectionTicketRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetConnectionTicketResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_content):
            query['CommandContent'] = request.command_content
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetConnectionTicket',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetConnectionTicketResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetConnectionTicketResponse(),
                self.execute(params, req, runtime)
            )

    async def get_connection_ticket_with_options_async(
        self,
        request: ecd_20200930_models.GetConnectionTicketRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetConnectionTicketResponse:
        """
        @summary Obtains the credential that is used to connect to a cloud desktop.
        
        @description The cloud computer must be in the Running state.
        
        @param request: GetConnectionTicketRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetConnectionTicketResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_content):
            query['CommandContent'] = request.command_content
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetConnectionTicket',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetConnectionTicketResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetConnectionTicketResponse(),
                await self.execute_async(params, req, runtime)
            )

    def get_connection_ticket(
        self,
        request: ecd_20200930_models.GetConnectionTicketRequest,
    ) -> ecd_20200930_models.GetConnectionTicketResponse:
        """
        @summary Obtains the credential that is used to connect to a cloud desktop.
        
        @description The cloud computer must be in the Running state.
        
        @param request: GetConnectionTicketRequest
        @return: GetConnectionTicketResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_connection_ticket_with_options(request, runtime)

    async def get_connection_ticket_async(
        self,
        request: ecd_20200930_models.GetConnectionTicketRequest,
    ) -> ecd_20200930_models.GetConnectionTicketResponse:
        """
        @summary Obtains the credential that is used to connect to a cloud desktop.
        
        @description The cloud computer must be in the Running state.
        
        @param request: GetConnectionTicketRequest
        @return: GetConnectionTicketResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_connection_ticket_with_options_async(request, runtime)

    def get_coordinate_ticket_with_options(
        self,
        request: ecd_20200930_models.GetCoordinateTicketRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetCoordinateTicketResponse:
        """
        @summary Obtains the credentials of the stream collaboration
        
        @param request: GetCoordinateTicketRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCoordinateTicketResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.co_id):
            query['CoId'] = request.co_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCoordinateTicket',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetCoordinateTicketResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetCoordinateTicketResponse(),
                self.execute(params, req, runtime)
            )

    async def get_coordinate_ticket_with_options_async(
        self,
        request: ecd_20200930_models.GetCoordinateTicketRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetCoordinateTicketResponse:
        """
        @summary Obtains the credentials of the stream collaboration
        
        @param request: GetCoordinateTicketRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCoordinateTicketResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.co_id):
            query['CoId'] = request.co_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCoordinateTicket',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetCoordinateTicketResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetCoordinateTicketResponse(),
                await self.execute_async(params, req, runtime)
            )

    def get_coordinate_ticket(
        self,
        request: ecd_20200930_models.GetCoordinateTicketRequest,
    ) -> ecd_20200930_models.GetCoordinateTicketResponse:
        """
        @summary Obtains the credentials of the stream collaboration
        
        @param request: GetCoordinateTicketRequest
        @return: GetCoordinateTicketResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_coordinate_ticket_with_options(request, runtime)

    async def get_coordinate_ticket_async(
        self,
        request: ecd_20200930_models.GetCoordinateTicketRequest,
    ) -> ecd_20200930_models.GetCoordinateTicketResponse:
        """
        @summary Obtains the credentials of the stream collaboration
        
        @param request: GetCoordinateTicketRequest
        @return: GetCoordinateTicketResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_coordinate_ticket_with_options_async(request, runtime)

    def get_desktop_group_detail_with_options(
        self,
        request: ecd_20200930_models.GetDesktopGroupDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetDesktopGroupDetailResponse:
        """
        @summary Queries the information about a cloud computer pool.
        
        @param request: GetDesktopGroupDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetDesktopGroupDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetDesktopGroupDetail',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetDesktopGroupDetailResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetDesktopGroupDetailResponse(),
                self.execute(params, req, runtime)
            )

    async def get_desktop_group_detail_with_options_async(
        self,
        request: ecd_20200930_models.GetDesktopGroupDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetDesktopGroupDetailResponse:
        """
        @summary Queries the information about a cloud computer pool.
        
        @param request: GetDesktopGroupDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetDesktopGroupDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetDesktopGroupDetail',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetDesktopGroupDetailResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetDesktopGroupDetailResponse(),
                await self.execute_async(params, req, runtime)
            )

    def get_desktop_group_detail(
        self,
        request: ecd_20200930_models.GetDesktopGroupDetailRequest,
    ) -> ecd_20200930_models.GetDesktopGroupDetailResponse:
        """
        @summary Queries the information about a cloud computer pool.
        
        @param request: GetDesktopGroupDetailRequest
        @return: GetDesktopGroupDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_desktop_group_detail_with_options(request, runtime)

    async def get_desktop_group_detail_async(
        self,
        request: ecd_20200930_models.GetDesktopGroupDetailRequest,
    ) -> ecd_20200930_models.GetDesktopGroupDetailResponse:
        """
        @summary Queries the information about a cloud computer pool.
        
        @param request: GetDesktopGroupDetailRequest
        @return: GetDesktopGroupDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_desktop_group_detail_with_options_async(request, runtime)

    def get_office_site_sso_status_with_options(
        self,
        request: ecd_20200930_models.GetOfficeSiteSsoStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetOfficeSiteSsoStatusResponse:
        """
        @summary Queries whether single sign-on (SSO) is enabled for a workspace.
        
        @param request: GetOfficeSiteSsoStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetOfficeSiteSsoStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetOfficeSiteSsoStatus',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetOfficeSiteSsoStatusResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetOfficeSiteSsoStatusResponse(),
                self.execute(params, req, runtime)
            )

    async def get_office_site_sso_status_with_options_async(
        self,
        request: ecd_20200930_models.GetOfficeSiteSsoStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetOfficeSiteSsoStatusResponse:
        """
        @summary Queries whether single sign-on (SSO) is enabled for a workspace.
        
        @param request: GetOfficeSiteSsoStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetOfficeSiteSsoStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetOfficeSiteSsoStatus',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetOfficeSiteSsoStatusResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetOfficeSiteSsoStatusResponse(),
                await self.execute_async(params, req, runtime)
            )

    def get_office_site_sso_status(
        self,
        request: ecd_20200930_models.GetOfficeSiteSsoStatusRequest,
    ) -> ecd_20200930_models.GetOfficeSiteSsoStatusResponse:
        """
        @summary Queries whether single sign-on (SSO) is enabled for a workspace.
        
        @param request: GetOfficeSiteSsoStatusRequest
        @return: GetOfficeSiteSsoStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_office_site_sso_status_with_options(request, runtime)

    async def get_office_site_sso_status_async(
        self,
        request: ecd_20200930_models.GetOfficeSiteSsoStatusRequest,
    ) -> ecd_20200930_models.GetOfficeSiteSsoStatusResponse:
        """
        @summary Queries whether single sign-on (SSO) is enabled for a workspace.
        
        @param request: GetOfficeSiteSsoStatusRequest
        @return: GetOfficeSiteSsoStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_office_site_sso_status_with_options_async(request, runtime)

    def get_sp_metadata_with_options(
        self,
        request: ecd_20200930_models.GetSpMetadataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetSpMetadataResponse:
        """
        @summary Obtains the metadata of a Security Assertion Markup Language (SAML) 2.0-based service provider (SP).
        
        @description You can call this operation only for workspaces of the Active Directory (AD) and convenience account types.
        
        @param request: GetSpMetadataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSpMetadataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSpMetadata',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetSpMetadataResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetSpMetadataResponse(),
                self.execute(params, req, runtime)
            )

    async def get_sp_metadata_with_options_async(
        self,
        request: ecd_20200930_models.GetSpMetadataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.GetSpMetadataResponse:
        """
        @summary Obtains the metadata of a Security Assertion Markup Language (SAML) 2.0-based service provider (SP).
        
        @description You can call this operation only for workspaces of the Active Directory (AD) and convenience account types.
        
        @param request: GetSpMetadataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSpMetadataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSpMetadata',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.GetSpMetadataResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.GetSpMetadataResponse(),
                await self.execute_async(params, req, runtime)
            )

    def get_sp_metadata(
        self,
        request: ecd_20200930_models.GetSpMetadataRequest,
    ) -> ecd_20200930_models.GetSpMetadataResponse:
        """
        @summary Obtains the metadata of a Security Assertion Markup Language (SAML) 2.0-based service provider (SP).
        
        @description You can call this operation only for workspaces of the Active Directory (AD) and convenience account types.
        
        @param request: GetSpMetadataRequest
        @return: GetSpMetadataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_sp_metadata_with_options(request, runtime)

    async def get_sp_metadata_async(
        self,
        request: ecd_20200930_models.GetSpMetadataRequest,
    ) -> ecd_20200930_models.GetSpMetadataResponse:
        """
        @summary Obtains the metadata of a Security Assertion Markup Language (SAML) 2.0-based service provider (SP).
        
        @description You can call this operation only for workspaces of the Active Directory (AD) and convenience account types.
        
        @param request: GetSpMetadataRequest
        @return: GetSpMetadataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_sp_metadata_with_options_async(request, runtime)

    def hibernate_desktops_with_options(
        self,
        request: ecd_20200930_models.HibernateDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.HibernateDesktopsResponse:
        """
        @summary Hibernates cloud desktops.
        
        @description Hibernating a cloud desktop is in private preview. If you want to try this feature, submit a ticket.
        
        @param request: HibernateDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: HibernateDesktopsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='HibernateDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.HibernateDesktopsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.HibernateDesktopsResponse(),
                self.execute(params, req, runtime)
            )

    async def hibernate_desktops_with_options_async(
        self,
        request: ecd_20200930_models.HibernateDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.HibernateDesktopsResponse:
        """
        @summary Hibernates cloud desktops.
        
        @description Hibernating a cloud desktop is in private preview. If you want to try this feature, submit a ticket.
        
        @param request: HibernateDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: HibernateDesktopsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='HibernateDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.HibernateDesktopsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.HibernateDesktopsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def hibernate_desktops(
        self,
        request: ecd_20200930_models.HibernateDesktopsRequest,
    ) -> ecd_20200930_models.HibernateDesktopsResponse:
        """
        @summary Hibernates cloud desktops.
        
        @description Hibernating a cloud desktop is in private preview. If you want to try this feature, submit a ticket.
        
        @param request: HibernateDesktopsRequest
        @return: HibernateDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.hibernate_desktops_with_options(request, runtime)

    async def hibernate_desktops_async(
        self,
        request: ecd_20200930_models.HibernateDesktopsRequest,
    ) -> ecd_20200930_models.HibernateDesktopsResponse:
        """
        @summary Hibernates cloud desktops.
        
        @description Hibernating a cloud desktop is in private preview. If you want to try this feature, submit a ticket.
        
        @param request: HibernateDesktopsRequest
        @return: HibernateDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.hibernate_desktops_with_options_async(request, runtime)

    def list_cds_files_with_options(
        self,
        tmp_req: ecd_20200930_models.ListCdsFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListCdsFilesResponse:
        """
        @summary Queries the files in a cloud disk.
        
        @param tmp_req: ListCdsFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCdsFilesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ecd_20200930_models.ListCdsFilesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.file_ids):
            request.file_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.file_ids, 'FileIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_ids_shrink):
            query['FileIds'] = request.file_ids_shrink
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        if not UtilClient.is_unset(request.parent_file_id):
            query['ParentFileId'] = request.parent_file_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCdsFiles',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListCdsFilesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListCdsFilesResponse(),
                self.execute(params, req, runtime)
            )

    async def list_cds_files_with_options_async(
        self,
        tmp_req: ecd_20200930_models.ListCdsFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListCdsFilesResponse:
        """
        @summary Queries the files in a cloud disk.
        
        @param tmp_req: ListCdsFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCdsFilesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ecd_20200930_models.ListCdsFilesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.file_ids):
            request.file_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.file_ids, 'FileIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_ids_shrink):
            query['FileIds'] = request.file_ids_shrink
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        if not UtilClient.is_unset(request.parent_file_id):
            query['ParentFileId'] = request.parent_file_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCdsFiles',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListCdsFilesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListCdsFilesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def list_cds_files(
        self,
        request: ecd_20200930_models.ListCdsFilesRequest,
    ) -> ecd_20200930_models.ListCdsFilesResponse:
        """
        @summary Queries the files in a cloud disk.
        
        @param request: ListCdsFilesRequest
        @return: ListCdsFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_cds_files_with_options(request, runtime)

    async def list_cds_files_async(
        self,
        request: ecd_20200930_models.ListCdsFilesRequest,
    ) -> ecd_20200930_models.ListCdsFilesResponse:
        """
        @summary Queries the files in a cloud disk.
        
        @param request: ListCdsFilesRequest
        @return: ListCdsFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_cds_files_with_options_async(request, runtime)

    def list_directory_users_with_options(
        self,
        request: ecd_20200930_models.ListDirectoryUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListDirectoryUsersResponse:
        """
        @summary Obtains the user information in the AD system if you use an AD directory to connect to an AD system.
        
        @description If you use an AD directory to connect to an AD system, you can call this operation to obtain the user information in the AD system.
        
        @param request: ListDirectoryUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDirectoryUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assigned_info):
            query['AssignedInfo'] = request.assigned_info
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.include_assigned_user):
            query['IncludeAssignedUser'] = request.include_assigned_user
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oupath):
            query['OUPath'] = request.oupath
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sort_type):
            query['SortType'] = request.sort_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDirectoryUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListDirectoryUsersResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListDirectoryUsersResponse(),
                self.execute(params, req, runtime)
            )

    async def list_directory_users_with_options_async(
        self,
        request: ecd_20200930_models.ListDirectoryUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListDirectoryUsersResponse:
        """
        @summary Obtains the user information in the AD system if you use an AD directory to connect to an AD system.
        
        @description If you use an AD directory to connect to an AD system, you can call this operation to obtain the user information in the AD system.
        
        @param request: ListDirectoryUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDirectoryUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assigned_info):
            query['AssignedInfo'] = request.assigned_info
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.include_assigned_user):
            query['IncludeAssignedUser'] = request.include_assigned_user
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oupath):
            query['OUPath'] = request.oupath
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sort_type):
            query['SortType'] = request.sort_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDirectoryUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListDirectoryUsersResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListDirectoryUsersResponse(),
                await self.execute_async(params, req, runtime)
            )

    def list_directory_users(
        self,
        request: ecd_20200930_models.ListDirectoryUsersRequest,
    ) -> ecd_20200930_models.ListDirectoryUsersResponse:
        """
        @summary Obtains the user information in the AD system if you use an AD directory to connect to an AD system.
        
        @description If you use an AD directory to connect to an AD system, you can call this operation to obtain the user information in the AD system.
        
        @param request: ListDirectoryUsersRequest
        @return: ListDirectoryUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_directory_users_with_options(request, runtime)

    async def list_directory_users_async(
        self,
        request: ecd_20200930_models.ListDirectoryUsersRequest,
    ) -> ecd_20200930_models.ListDirectoryUsersResponse:
        """
        @summary Obtains the user information in the AD system if you use an AD directory to connect to an AD system.
        
        @description If you use an AD directory to connect to an AD system, you can call this operation to obtain the user information in the AD system.
        
        @param request: ListDirectoryUsersRequest
        @return: ListDirectoryUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_directory_users_with_options_async(request, runtime)

    def list_file_permission_with_options(
        self,
        request: ecd_20200930_models.ListFilePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListFilePermissionResponse:
        """
        @summary Queries the information about shared files of cloud disks.
        
        @param request: ListFilePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListFilePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListFilePermission',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListFilePermissionResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListFilePermissionResponse(),
                self.execute(params, req, runtime)
            )

    async def list_file_permission_with_options_async(
        self,
        request: ecd_20200930_models.ListFilePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListFilePermissionResponse:
        """
        @summary Queries the information about shared files of cloud disks.
        
        @param request: ListFilePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListFilePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListFilePermission',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListFilePermissionResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListFilePermissionResponse(),
                await self.execute_async(params, req, runtime)
            )

    def list_file_permission(
        self,
        request: ecd_20200930_models.ListFilePermissionRequest,
    ) -> ecd_20200930_models.ListFilePermissionResponse:
        """
        @summary Queries the information about shared files of cloud disks.
        
        @param request: ListFilePermissionRequest
        @return: ListFilePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_file_permission_with_options(request, runtime)

    async def list_file_permission_async(
        self,
        request: ecd_20200930_models.ListFilePermissionRequest,
    ) -> ecd_20200930_models.ListFilePermissionResponse:
        """
        @summary Queries the information about shared files of cloud disks.
        
        @param request: ListFilePermissionRequest
        @return: ListFilePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_file_permission_with_options_async(request, runtime)

    def list_office_site_overview_with_options(
        self,
        request: ecd_20200930_models.ListOfficeSiteOverviewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListOfficeSiteOverviewResponse:
        """
        @summary Queries information about an office network, including its status, cloud computer quantity, virtual private cloud (VPC) type, and more.
        
        @param request: ListOfficeSiteOverviewRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListOfficeSiteOverviewResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force_refresh):
            query['ForceRefresh'] = request.force_refresh
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.query_range):
            query['QueryRange'] = request.query_range
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListOfficeSiteOverview',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListOfficeSiteOverviewResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListOfficeSiteOverviewResponse(),
                self.execute(params, req, runtime)
            )

    async def list_office_site_overview_with_options_async(
        self,
        request: ecd_20200930_models.ListOfficeSiteOverviewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListOfficeSiteOverviewResponse:
        """
        @summary Queries information about an office network, including its status, cloud computer quantity, virtual private cloud (VPC) type, and more.
        
        @param request: ListOfficeSiteOverviewRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListOfficeSiteOverviewResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force_refresh):
            query['ForceRefresh'] = request.force_refresh
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.query_range):
            query['QueryRange'] = request.query_range
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListOfficeSiteOverview',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListOfficeSiteOverviewResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListOfficeSiteOverviewResponse(),
                await self.execute_async(params, req, runtime)
            )

    def list_office_site_overview(
        self,
        request: ecd_20200930_models.ListOfficeSiteOverviewRequest,
    ) -> ecd_20200930_models.ListOfficeSiteOverviewResponse:
        """
        @summary Queries information about an office network, including its status, cloud computer quantity, virtual private cloud (VPC) type, and more.
        
        @param request: ListOfficeSiteOverviewRequest
        @return: ListOfficeSiteOverviewResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_office_site_overview_with_options(request, runtime)

    async def list_office_site_overview_async(
        self,
        request: ecd_20200930_models.ListOfficeSiteOverviewRequest,
    ) -> ecd_20200930_models.ListOfficeSiteOverviewResponse:
        """
        @summary Queries information about an office network, including its status, cloud computer quantity, virtual private cloud (VPC) type, and more.
        
        @param request: ListOfficeSiteOverviewRequest
        @return: ListOfficeSiteOverviewResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_office_site_overview_with_options_async(request, runtime)

    def list_office_site_users_with_options(
        self,
        request: ecd_20200930_models.ListOfficeSiteUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListOfficeSiteUsersResponse:
        """
        @summary Queries information about Active Directory (AD) users after an enterprise AD office network (formerly workspace) interconnects to an AD domain.
        
        @param request: ListOfficeSiteUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListOfficeSiteUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assigned_info):
            query['AssignedInfo'] = request.assigned_info
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.include_assigned_user):
            query['IncludeAssignedUser'] = request.include_assigned_user
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oupath):
            query['OUPath'] = request.oupath
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sort_type):
            query['SortType'] = request.sort_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListOfficeSiteUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListOfficeSiteUsersResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListOfficeSiteUsersResponse(),
                self.execute(params, req, runtime)
            )

    async def list_office_site_users_with_options_async(
        self,
        request: ecd_20200930_models.ListOfficeSiteUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListOfficeSiteUsersResponse:
        """
        @summary Queries information about Active Directory (AD) users after an enterprise AD office network (formerly workspace) interconnects to an AD domain.
        
        @param request: ListOfficeSiteUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListOfficeSiteUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assigned_info):
            query['AssignedInfo'] = request.assigned_info
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.include_assigned_user):
            query['IncludeAssignedUser'] = request.include_assigned_user
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.oupath):
            query['OUPath'] = request.oupath
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sort_type):
            query['SortType'] = request.sort_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListOfficeSiteUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListOfficeSiteUsersResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListOfficeSiteUsersResponse(),
                await self.execute_async(params, req, runtime)
            )

    def list_office_site_users(
        self,
        request: ecd_20200930_models.ListOfficeSiteUsersRequest,
    ) -> ecd_20200930_models.ListOfficeSiteUsersResponse:
        """
        @summary Queries information about Active Directory (AD) users after an enterprise AD office network (formerly workspace) interconnects to an AD domain.
        
        @param request: ListOfficeSiteUsersRequest
        @return: ListOfficeSiteUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_office_site_users_with_options(request, runtime)

    async def list_office_site_users_async(
        self,
        request: ecd_20200930_models.ListOfficeSiteUsersRequest,
    ) -> ecd_20200930_models.ListOfficeSiteUsersResponse:
        """
        @summary Queries information about Active Directory (AD) users after an enterprise AD office network (formerly workspace) interconnects to an AD domain.
        
        @param request: ListOfficeSiteUsersRequest
        @return: ListOfficeSiteUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_office_site_users_with_options_async(request, runtime)

    def list_tag_resources_with_options(
        self,
        request: ecd_20200930_models.ListTagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListTagResourcesResponse:
        """
        @summary Queries the tags of cloud computers.
        
        @description You must use at least one of the following parameters in the request to determine the object that you want to query: `ResourceId.N`, `Tag.N.Key`, and `Tag.N.Value`.
        
        @param request: ListTagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTagResources',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListTagResourcesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListTagResourcesResponse(),
                self.execute(params, req, runtime)
            )

    async def list_tag_resources_with_options_async(
        self,
        request: ecd_20200930_models.ListTagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListTagResourcesResponse:
        """
        @summary Queries the tags of cloud computers.
        
        @description You must use at least one of the following parameters in the request to determine the object that you want to query: `ResourceId.N`, `Tag.N.Key`, and `Tag.N.Value`.
        
        @param request: ListTagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTagResources',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListTagResourcesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListTagResourcesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def list_tag_resources(
        self,
        request: ecd_20200930_models.ListTagResourcesRequest,
    ) -> ecd_20200930_models.ListTagResourcesResponse:
        """
        @summary Queries the tags of cloud computers.
        
        @description You must use at least one of the following parameters in the request to determine the object that you want to query: `ResourceId.N`, `Tag.N.Key`, and `Tag.N.Value`.
        
        @param request: ListTagResourcesRequest
        @return: ListTagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_tag_resources_with_options(request, runtime)

    async def list_tag_resources_async(
        self,
        request: ecd_20200930_models.ListTagResourcesRequest,
    ) -> ecd_20200930_models.ListTagResourcesResponse:
        """
        @summary Queries the tags of cloud computers.
        
        @description You must use at least one of the following parameters in the request to determine the object that you want to query: `ResourceId.N`, `Tag.N.Key`, and `Tag.N.Value`.
        
        @param request: ListTagResourcesRequest
        @return: ListTagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_tag_resources_with_options_async(request, runtime)

    def list_user_ad_organization_units_with_options(
        self,
        request: ecd_20200930_models.ListUserAdOrganizationUnitsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListUserAdOrganizationUnitsResponse:
        """
        @summary Obtains the organizational units (OUs) of an Active Directory (AD) domain that is connected to an enterprise AD office network (formerly workspace).
        
        @param request: ListUserAdOrganizationUnitsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListUserAdOrganizationUnitsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListUserAdOrganizationUnits',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListUserAdOrganizationUnitsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListUserAdOrganizationUnitsResponse(),
                self.execute(params, req, runtime)
            )

    async def list_user_ad_organization_units_with_options_async(
        self,
        request: ecd_20200930_models.ListUserAdOrganizationUnitsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ListUserAdOrganizationUnitsResponse:
        """
        @summary Obtains the organizational units (OUs) of an Active Directory (AD) domain that is connected to an enterprise AD office network (formerly workspace).
        
        @param request: ListUserAdOrganizationUnitsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListUserAdOrganizationUnitsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListUserAdOrganizationUnits',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ListUserAdOrganizationUnitsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ListUserAdOrganizationUnitsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def list_user_ad_organization_units(
        self,
        request: ecd_20200930_models.ListUserAdOrganizationUnitsRequest,
    ) -> ecd_20200930_models.ListUserAdOrganizationUnitsResponse:
        """
        @summary Obtains the organizational units (OUs) of an Active Directory (AD) domain that is connected to an enterprise AD office network (formerly workspace).
        
        @param request: ListUserAdOrganizationUnitsRequest
        @return: ListUserAdOrganizationUnitsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_user_ad_organization_units_with_options(request, runtime)

    async def list_user_ad_organization_units_async(
        self,
        request: ecd_20200930_models.ListUserAdOrganizationUnitsRequest,
    ) -> ecd_20200930_models.ListUserAdOrganizationUnitsResponse:
        """
        @summary Obtains the organizational units (OUs) of an Active Directory (AD) domain that is connected to an enterprise AD office network (formerly workspace).
        
        @param request: ListUserAdOrganizationUnitsRequest
        @return: ListUserAdOrganizationUnitsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_user_ad_organization_units_with_options_async(request, runtime)

    def lock_virtual_mfadevice_with_options(
        self,
        request: ecd_20200930_models.LockVirtualMFADeviceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.LockVirtualMFADeviceResponse:
        """
        @summary Locks a multi-factor authentication (MFA) device that is in the NORMAL state.
        
        @description After a virtual MFA device is locked, its status changes to LOCKED. The Active Directory (AD) user who uses the virtual MFA device is unable to pass MFA and is therefore unable to log on to the client. You can call the [UnlockVirtualMFADevice](https://help.aliyun.com/document_detail/206212.html) operation to unlock the device.
        
        @param request: LockVirtualMFADeviceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: LockVirtualMFADeviceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.serial_number):
            query['SerialNumber'] = request.serial_number
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='LockVirtualMFADevice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.LockVirtualMFADeviceResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.LockVirtualMFADeviceResponse(),
                self.execute(params, req, runtime)
            )

    async def lock_virtual_mfadevice_with_options_async(
        self,
        request: ecd_20200930_models.LockVirtualMFADeviceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.LockVirtualMFADeviceResponse:
        """
        @summary Locks a multi-factor authentication (MFA) device that is in the NORMAL state.
        
        @description After a virtual MFA device is locked, its status changes to LOCKED. The Active Directory (AD) user who uses the virtual MFA device is unable to pass MFA and is therefore unable to log on to the client. You can call the [UnlockVirtualMFADevice](https://help.aliyun.com/document_detail/206212.html) operation to unlock the device.
        
        @param request: LockVirtualMFADeviceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: LockVirtualMFADeviceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.serial_number):
            query['SerialNumber'] = request.serial_number
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='LockVirtualMFADevice',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.LockVirtualMFADeviceResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.LockVirtualMFADeviceResponse(),
                await self.execute_async(params, req, runtime)
            )

    def lock_virtual_mfadevice(
        self,
        request: ecd_20200930_models.LockVirtualMFADeviceRequest,
    ) -> ecd_20200930_models.LockVirtualMFADeviceResponse:
        """
        @summary Locks a multi-factor authentication (MFA) device that is in the NORMAL state.
        
        @description After a virtual MFA device is locked, its status changes to LOCKED. The Active Directory (AD) user who uses the virtual MFA device is unable to pass MFA and is therefore unable to log on to the client. You can call the [UnlockVirtualMFADevice](https://help.aliyun.com/document_detail/206212.html) operation to unlock the device.
        
        @param request: LockVirtualMFADeviceRequest
        @return: LockVirtualMFADeviceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.lock_virtual_mfadevice_with_options(request, runtime)

    async def lock_virtual_mfadevice_async(
        self,
        request: ecd_20200930_models.LockVirtualMFADeviceRequest,
    ) -> ecd_20200930_models.LockVirtualMFADeviceResponse:
        """
        @summary Locks a multi-factor authentication (MFA) device that is in the NORMAL state.
        
        @description After a virtual MFA device is locked, its status changes to LOCKED. The Active Directory (AD) user who uses the virtual MFA device is unable to pass MFA and is therefore unable to log on to the client. You can call the [UnlockVirtualMFADevice](https://help.aliyun.com/document_detail/206212.html) operation to unlock the device.
        
        @param request: LockVirtualMFADeviceRequest
        @return: LockVirtualMFADeviceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.lock_virtual_mfadevice_with_options_async(request, runtime)

    def migrate_desktops_with_options(
        self,
        request: ecd_20200930_models.MigrateDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.MigrateDesktopsResponse:
        """
        @summary Migrates cloud computers from the current office network (formerly called workspace) to the new office network.
        
        @param request: MigrateDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: MigrateDesktopsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.target_office_site_id):
            query['TargetOfficeSiteId'] = request.target_office_site_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='MigrateDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.MigrateDesktopsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.MigrateDesktopsResponse(),
                self.execute(params, req, runtime)
            )

    async def migrate_desktops_with_options_async(
        self,
        request: ecd_20200930_models.MigrateDesktopsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.MigrateDesktopsResponse:
        """
        @summary Migrates cloud computers from the current office network (formerly called workspace) to the new office network.
        
        @param request: MigrateDesktopsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: MigrateDesktopsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.target_office_site_id):
            query['TargetOfficeSiteId'] = request.target_office_site_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='MigrateDesktops',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.MigrateDesktopsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.MigrateDesktopsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def migrate_desktops(
        self,
        request: ecd_20200930_models.MigrateDesktopsRequest,
    ) -> ecd_20200930_models.MigrateDesktopsResponse:
        """
        @summary Migrates cloud computers from the current office network (formerly called workspace) to the new office network.
        
        @param request: MigrateDesktopsRequest
        @return: MigrateDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.migrate_desktops_with_options(request, runtime)

    async def migrate_desktops_async(
        self,
        request: ecd_20200930_models.MigrateDesktopsRequest,
    ) -> ecd_20200930_models.MigrateDesktopsResponse:
        """
        @summary Migrates cloud computers from the current office network (formerly called workspace) to the new office network.
        
        @param request: MigrateDesktopsRequest
        @return: MigrateDesktopsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.migrate_desktops_with_options_async(request, runtime)

    def migrate_image_protocol_with_options(
        self,
        request: ecd_20200930_models.MigrateImageProtocolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.MigrateImageProtocolResponse:
        """
        @summary Update the protocols of images to Adaptive Streaming Protocol (ASP).
        
        @param request: MigrateImageProtocolRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: MigrateImageProtocolResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.target_protocol_type):
            query['TargetProtocolType'] = request.target_protocol_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='MigrateImageProtocol',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.MigrateImageProtocolResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.MigrateImageProtocolResponse(),
                self.execute(params, req, runtime)
            )

    async def migrate_image_protocol_with_options_async(
        self,
        request: ecd_20200930_models.MigrateImageProtocolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.MigrateImageProtocolResponse:
        """
        @summary Update the protocols of images to Adaptive Streaming Protocol (ASP).
        
        @param request: MigrateImageProtocolRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: MigrateImageProtocolResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.target_protocol_type):
            query['TargetProtocolType'] = request.target_protocol_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='MigrateImageProtocol',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.MigrateImageProtocolResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.MigrateImageProtocolResponse(),
                await self.execute_async(params, req, runtime)
            )

    def migrate_image_protocol(
        self,
        request: ecd_20200930_models.MigrateImageProtocolRequest,
    ) -> ecd_20200930_models.MigrateImageProtocolResponse:
        """
        @summary Update the protocols of images to Adaptive Streaming Protocol (ASP).
        
        @param request: MigrateImageProtocolRequest
        @return: MigrateImageProtocolResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.migrate_image_protocol_with_options(request, runtime)

    async def migrate_image_protocol_async(
        self,
        request: ecd_20200930_models.MigrateImageProtocolRequest,
    ) -> ecd_20200930_models.MigrateImageProtocolResponse:
        """
        @summary Update the protocols of images to Adaptive Streaming Protocol (ASP).
        
        @param request: MigrateImageProtocolRequest
        @return: MigrateImageProtocolResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.migrate_image_protocol_with_options_async(request, runtime)

    def modify_adconnector_directory_with_options(
        self,
        request: ecd_20200930_models.ModifyADConnectorDirectoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyADConnectorDirectoryResponse:
        """
        @summary Modifies an Active Directory (AD) directory.
        
        @description You can modify the following domain name- and Domain Name System (DNS)-related parameters only for Active Directory (AD) directories that are in the ERROR or REGISTERING state: `DomainName`, `SubDomainName`, `DnsAddress.N`, and `SubDomainDnsAddress`.
        
        @param request: ModifyADConnectorDirectoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyADConnectorDirectoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_hostname):
            query['AdHostname'] = request.ad_hostname
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.directory_name):
            query['DirectoryName'] = request.directory_name
        if not UtilClient.is_unset(request.dns_address):
            query['DnsAddress'] = request.dns_address
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_password):
            query['DomainPassword'] = request.domain_password
        if not UtilClient.is_unset(request.domain_user_name):
            query['DomainUserName'] = request.domain_user_name
        if not UtilClient.is_unset(request.mfa_enabled):
            query['MfaEnabled'] = request.mfa_enabled
        if not UtilClient.is_unset(request.ouname):
            query['OUName'] = request.ouname
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sub_domain_dns_address):
            query['SubDomainDnsAddress'] = request.sub_domain_dns_address
        if not UtilClient.is_unset(request.sub_domain_name):
            query['SubDomainName'] = request.sub_domain_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyADConnectorDirectory',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyADConnectorDirectoryResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyADConnectorDirectoryResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_adconnector_directory_with_options_async(
        self,
        request: ecd_20200930_models.ModifyADConnectorDirectoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyADConnectorDirectoryResponse:
        """
        @summary Modifies an Active Directory (AD) directory.
        
        @description You can modify the following domain name- and Domain Name System (DNS)-related parameters only for Active Directory (AD) directories that are in the ERROR or REGISTERING state: `DomainName`, `SubDomainName`, `DnsAddress.N`, and `SubDomainDnsAddress`.
        
        @param request: ModifyADConnectorDirectoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyADConnectorDirectoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_hostname):
            query['AdHostname'] = request.ad_hostname
        if not UtilClient.is_unset(request.directory_id):
            query['DirectoryId'] = request.directory_id
        if not UtilClient.is_unset(request.directory_name):
            query['DirectoryName'] = request.directory_name
        if not UtilClient.is_unset(request.dns_address):
            query['DnsAddress'] = request.dns_address
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_password):
            query['DomainPassword'] = request.domain_password
        if not UtilClient.is_unset(request.domain_user_name):
            query['DomainUserName'] = request.domain_user_name
        if not UtilClient.is_unset(request.mfa_enabled):
            query['MfaEnabled'] = request.mfa_enabled
        if not UtilClient.is_unset(request.ouname):
            query['OUName'] = request.ouname
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sub_domain_dns_address):
            query['SubDomainDnsAddress'] = request.sub_domain_dns_address
        if not UtilClient.is_unset(request.sub_domain_name):
            query['SubDomainName'] = request.sub_domain_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyADConnectorDirectory',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyADConnectorDirectoryResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyADConnectorDirectoryResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_adconnector_directory(
        self,
        request: ecd_20200930_models.ModifyADConnectorDirectoryRequest,
    ) -> ecd_20200930_models.ModifyADConnectorDirectoryResponse:
        """
        @summary Modifies an Active Directory (AD) directory.
        
        @description You can modify the following domain name- and Domain Name System (DNS)-related parameters only for Active Directory (AD) directories that are in the ERROR or REGISTERING state: `DomainName`, `SubDomainName`, `DnsAddress.N`, and `SubDomainDnsAddress`.
        
        @param request: ModifyADConnectorDirectoryRequest
        @return: ModifyADConnectorDirectoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_adconnector_directory_with_options(request, runtime)

    async def modify_adconnector_directory_async(
        self,
        request: ecd_20200930_models.ModifyADConnectorDirectoryRequest,
    ) -> ecd_20200930_models.ModifyADConnectorDirectoryResponse:
        """
        @summary Modifies an Active Directory (AD) directory.
        
        @description You can modify the following domain name- and Domain Name System (DNS)-related parameters only for Active Directory (AD) directories that are in the ERROR or REGISTERING state: `DomainName`, `SubDomainName`, `DnsAddress.N`, and `SubDomainDnsAddress`.
        
        @param request: ModifyADConnectorDirectoryRequest
        @return: ModifyADConnectorDirectoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_adconnector_directory_with_options_async(request, runtime)

    def modify_adconnector_office_site_with_options(
        self,
        request: ecd_20200930_models.ModifyADConnectorOfficeSiteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyADConnectorOfficeSiteResponse:
        """
        @summary Modifies the basic properties of an enterprise Active Directory (AD) office network, such as the office network name and domain names of the enterprise AD subdomains.
        
        @description You can modify parameters of domain names and Domain Name System (DNS) for enterprise AD office networks that are in the `ERROR` or `REGISTERED` state. The parameters include `DomainName`, `SubDomainName`, `DnsAddress.N`, and `SubDomainDnsAddress.N`.
        
        @param request: ModifyADConnectorOfficeSiteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyADConnectorOfficeSiteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_hostname):
            query['AdHostname'] = request.ad_hostname
        if not UtilClient.is_unset(request.backup_dchostname):
            query['BackupDCHostname'] = request.backup_dchostname
        if not UtilClient.is_unset(request.backup_dns):
            query['BackupDns'] = request.backup_dns
        if not UtilClient.is_unset(request.dns_address):
            query['DnsAddress'] = request.dns_address
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_password):
            query['DomainPassword'] = request.domain_password
        if not UtilClient.is_unset(request.domain_user_name):
            query['DomainUserName'] = request.domain_user_name
        if not UtilClient.is_unset(request.mfa_enabled):
            query['MfaEnabled'] = request.mfa_enabled
        if not UtilClient.is_unset(request.ouname):
            query['OUName'] = request.ouname
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sub_domain_dns_address):
            query['SubDomainDnsAddress'] = request.sub_domain_dns_address
        if not UtilClient.is_unset(request.sub_domain_name):
            query['SubDomainName'] = request.sub_domain_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyADConnectorOfficeSite',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyADConnectorOfficeSiteResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyADConnectorOfficeSiteResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_adconnector_office_site_with_options_async(
        self,
        request: ecd_20200930_models.ModifyADConnectorOfficeSiteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyADConnectorOfficeSiteResponse:
        """
        @summary Modifies the basic properties of an enterprise Active Directory (AD) office network, such as the office network name and domain names of the enterprise AD subdomains.
        
        @description You can modify parameters of domain names and Domain Name System (DNS) for enterprise AD office networks that are in the `ERROR` or `REGISTERED` state. The parameters include `DomainName`, `SubDomainName`, `DnsAddress.N`, and `SubDomainDnsAddress.N`.
        
        @param request: ModifyADConnectorOfficeSiteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyADConnectorOfficeSiteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_hostname):
            query['AdHostname'] = request.ad_hostname
        if not UtilClient.is_unset(request.backup_dchostname):
            query['BackupDCHostname'] = request.backup_dchostname
        if not UtilClient.is_unset(request.backup_dns):
            query['BackupDns'] = request.backup_dns
        if not UtilClient.is_unset(request.dns_address):
            query['DnsAddress'] = request.dns_address
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_password):
            query['DomainPassword'] = request.domain_password
        if not UtilClient.is_unset(request.domain_user_name):
            query['DomainUserName'] = request.domain_user_name
        if not UtilClient.is_unset(request.mfa_enabled):
            query['MfaEnabled'] = request.mfa_enabled
        if not UtilClient.is_unset(request.ouname):
            query['OUName'] = request.ouname
        if not UtilClient.is_unset(request.office_site_id):
            query['OfficeSiteId'] = request.office_site_id
        if not UtilClient.is_unset(request.office_site_name):
            query['OfficeSiteName'] = request.office_site_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sub_domain_dns_address):
            query['SubDomainDnsAddress'] = request.sub_domain_dns_address
        if not UtilClient.is_unset(request.sub_domain_name):
            query['SubDomainName'] = request.sub_domain_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyADConnectorOfficeSite',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyADConnectorOfficeSiteResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyADConnectorOfficeSiteResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_adconnector_office_site(
        self,
        request: ecd_20200930_models.ModifyADConnectorOfficeSiteRequest,
    ) -> ecd_20200930_models.ModifyADConnectorOfficeSiteResponse:
        """
        @summary Modifies the basic properties of an enterprise Active Directory (AD) office network, such as the office network name and domain names of the enterprise AD subdomains.
        
        @description You can modify parameters of domain names and Domain Name System (DNS) for enterprise AD office networks that are in the `ERROR` or `REGISTERED` state. The parameters include `DomainName`, `SubDomainName`, `DnsAddress.N`, and `SubDomainDnsAddress.N`.
        
        @param request: ModifyADConnectorOfficeSiteRequest
        @return: ModifyADConnectorOfficeSiteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_adconnector_office_site_with_options(request, runtime)

    async def modify_adconnector_office_site_async(
        self,
        request: ecd_20200930_models.ModifyADConnectorOfficeSiteRequest,
    ) -> ecd_20200930_models.ModifyADConnectorOfficeSiteResponse:
        """
        @summary Modifies the basic properties of an enterprise Active Directory (AD) office network, such as the office network name and domain names of the enterprise AD subdomains.
        
        @description You can modify parameters of domain names and Domain Name System (DNS) for enterprise AD office networks that are in the `ERROR` or `REGISTERED` state. The parameters include `DomainName`, `SubDomainName`, `DnsAddress.N`, and `SubDomainDnsAddress.N`.
        
        @param request: ModifyADConnectorOfficeSiteRequest
        @return: ModifyADConnectorOfficeSiteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_adconnector_office_site_with_options_async(request, runtime)

    def modify_acl_entries_with_options(
        self,
        request: ecd_20200930_models.ModifyAclEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyAclEntriesResponse:
        """
        @summary Modify the Internet access control policy on the office network or cloud computer granularity.
        
        @description You can set different Internet access control policies at different granularities to achieve the effect of composite policies. For example, you can disable the Internet access on the office network granularity and enable the Internet access on specific cloud computer granularity. The effect is that all cloud computers in the office network except the specified cloud computers are not allowed to access the Internet.
        
        @param request: ModifyAclEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyAclEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyAclEntries',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyAclEntriesResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyAclEntriesResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_acl_entries_with_options_async(
        self,
        request: ecd_20200930_models.ModifyAclEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyAclEntriesResponse:
        """
        @summary Modify the Internet access control policy on the office network or cloud computer granularity.
        
        @description You can set different Internet access control policies at different granularities to achieve the effect of composite policies. For example, you can disable the Internet access on the office network granularity and enable the Internet access on specific cloud computer granularity. The effect is that all cloud computers in the office network except the specified cloud computers are not allowed to access the Internet.
        
        @param request: ModifyAclEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyAclEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyAclEntries',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyAclEntriesResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyAclEntriesResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_acl_entries(
        self,
        request: ecd_20200930_models.ModifyAclEntriesRequest,
    ) -> ecd_20200930_models.ModifyAclEntriesResponse:
        """
        @summary Modify the Internet access control policy on the office network or cloud computer granularity.
        
        @description You can set different Internet access control policies at different granularities to achieve the effect of composite policies. For example, you can disable the Internet access on the office network granularity and enable the Internet access on specific cloud computer granularity. The effect is that all cloud computers in the office network except the specified cloud computers are not allowed to access the Internet.
        
        @param request: ModifyAclEntriesRequest
        @return: ModifyAclEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_acl_entries_with_options(request, runtime)

    async def modify_acl_entries_async(
        self,
        request: ecd_20200930_models.ModifyAclEntriesRequest,
    ) -> ecd_20200930_models.ModifyAclEntriesResponse:
        """
        @summary Modify the Internet access control policy on the office network or cloud computer granularity.
        
        @description You can set different Internet access control policies at different granularities to achieve the effect of composite policies. For example, you can disable the Internet access on the office network granularity and enable the Internet access on specific cloud computer granularity. The effect is that all cloud computers in the office network except the specified cloud computers are not allowed to access the Internet.
        
        @param request: ModifyAclEntriesRequest
        @return: ModifyAclEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_acl_entries_with_options_async(request, runtime)

    def modify_auto_snapshot_policy_with_options(
        self,
        request: ecd_20200930_models.ModifyAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyAutoSnapshotPolicyResponse:
        """
        @summary Modifies the parameters of an automatic snapshot policy, such as the policy name and snapshot retention period.
        
        @param request: ModifyAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cron_expression):
            query['CronExpression'] = request.cron_expression
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyAutoSnapshotPolicyResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyAutoSnapshotPolicyResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_auto_snapshot_policy_with_options_async(
        self,
        request: ecd_20200930_models.ModifyAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyAutoSnapshotPolicyResponse:
        """
        @summary Modifies the parameters of an automatic snapshot policy, such as the policy name and snapshot retention period.
        
        @param request: ModifyAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cron_expression):
            query['CronExpression'] = request.cron_expression
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyAutoSnapshotPolicy',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyAutoSnapshotPolicyResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyAutoSnapshotPolicyResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_auto_snapshot_policy(
        self,
        request: ecd_20200930_models.ModifyAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.ModifyAutoSnapshotPolicyResponse:
        """
        @summary Modifies the parameters of an automatic snapshot policy, such as the policy name and snapshot retention period.
        
        @param request: ModifyAutoSnapshotPolicyRequest
        @return: ModifyAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_auto_snapshot_policy_with_options(request, runtime)

    async def modify_auto_snapshot_policy_async(
        self,
        request: ecd_20200930_models.ModifyAutoSnapshotPolicyRequest,
    ) -> ecd_20200930_models.ModifyAutoSnapshotPolicyResponse:
        """
        @summary Modifies the parameters of an automatic snapshot policy, such as the policy name and snapshot retention period.
        
        @param request: ModifyAutoSnapshotPolicyRequest
        @return: ModifyAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_auto_snapshot_policy_with_options_async(request, runtime)

    def modify_bundle_with_options(
        self,
        request: ecd_20200930_models.ModifyBundleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyBundleResponse:
        """
        @summary Modifies a custom cloud computer template.
        
        @description Only custom desktop templates can be modified.
        
        @param request: ModifyBundleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyBundleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.bundle_name):
            query['BundleName'] = request.bundle_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyBundle',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyBundleResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyBundleResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_bundle_with_options_async(
        self,
        request: ecd_20200930_models.ModifyBundleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyBundleResponse:
        """
        @summary Modifies a custom cloud computer template.
        
        @description Only custom desktop templates can be modified.
        
        @param request: ModifyBundleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyBundleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bundle_id):
            query['BundleId'] = request.bundle_id
        if not UtilClient.is_unset(request.bundle_name):
            query['BundleName'] = request.bundle_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyBundle',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyBundleResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyBundleResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_bundle(
        self,
        request: ecd_20200930_models.ModifyBundleRequest,
    ) -> ecd_20200930_models.ModifyBundleResponse:
        """
        @summary Modifies a custom cloud computer template.
        
        @description Only custom desktop templates can be modified.
        
        @param request: ModifyBundleRequest
        @return: ModifyBundleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_bundle_with_options(request, runtime)

    async def modify_bundle_async(
        self,
        request: ecd_20200930_models.ModifyBundleRequest,
    ) -> ecd_20200930_models.ModifyBundleResponse:
        """
        @summary Modifies a custom cloud computer template.
        
        @description Only custom desktop templates can be modified.
        
        @param request: ModifyBundleRequest
        @return: ModifyBundleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_bundle_with_options_async(request, runtime)

    def modify_cds_file_with_options(
        self,
        request: ecd_20200930_models.ModifyCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCdsFileResponse:
        """
        @summary Modifies the files in a cloud disk.
        
        @param request: ModifyCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.conflict_policy):
            query['ConflictPolicy'] = request.conflict_policy
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCdsFileResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCdsFileResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_cds_file_with_options_async(
        self,
        request: ecd_20200930_models.ModifyCdsFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCdsFileResponse:
        """
        @summary Modifies the files in a cloud disk.
        
        @param request: ModifyCdsFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCdsFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.conflict_policy):
            query['ConflictPolicy'] = request.conflict_policy
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.file_id):
            query['FileId'] = request.file_id
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCdsFile',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCdsFileResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCdsFileResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_cds_file(
        self,
        request: ecd_20200930_models.ModifyCdsFileRequest,
    ) -> ecd_20200930_models.ModifyCdsFileResponse:
        """
        @summary Modifies the files in a cloud disk.
        
        @param request: ModifyCdsFileRequest
        @return: ModifyCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_cds_file_with_options(request, runtime)

    async def modify_cds_file_async(
        self,
        request: ecd_20200930_models.ModifyCdsFileRequest,
    ) -> ecd_20200930_models.ModifyCdsFileResponse:
        """
        @summary Modifies the files in a cloud disk.
        
        @param request: ModifyCdsFileRequest
        @return: ModifyCdsFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_cds_file_with_options_async(request, runtime)

    def modify_cds_file_share_link_with_options(
        self,
        request: ecd_20200930_models.ModifyCdsFileShareLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCdsFileShareLinkResponse:
        """
        @summary Modifies the link for file sharing.
        
        @param request: ModifyCdsFileShareLinkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCdsFileShareLinkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disable_download):
            query['DisableDownload'] = request.disable_download
        if not UtilClient.is_unset(request.disable_preview):
            query['DisablePreview'] = request.disable_preview
        if not UtilClient.is_unset(request.disable_save):
            query['DisableSave'] = request.disable_save
        if not UtilClient.is_unset(request.download_count):
            query['DownloadCount'] = request.download_count
        if not UtilClient.is_unset(request.download_limit):
            query['DownloadLimit'] = request.download_limit
        if not UtilClient.is_unset(request.expiration):
            query['Expiration'] = request.expiration
        if not UtilClient.is_unset(request.preview_count):
            query['PreviewCount'] = request.preview_count
        if not UtilClient.is_unset(request.preview_limit):
            query['PreviewLimit'] = request.preview_limit
        if not UtilClient.is_unset(request.report_count):
            query['ReportCount'] = request.report_count
        if not UtilClient.is_unset(request.save_count):
            query['SaveCount'] = request.save_count
        if not UtilClient.is_unset(request.save_limit):
            query['SaveLimit'] = request.save_limit
        if not UtilClient.is_unset(request.share_id):
            query['ShareId'] = request.share_id
        if not UtilClient.is_unset(request.share_name):
            query['ShareName'] = request.share_name
        if not UtilClient.is_unset(request.share_pwd):
            query['SharePwd'] = request.share_pwd
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.video_preview_count):
            query['VideoPreviewCount'] = request.video_preview_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCdsFileShareLink',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCdsFileShareLinkResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCdsFileShareLinkResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_cds_file_share_link_with_options_async(
        self,
        request: ecd_20200930_models.ModifyCdsFileShareLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCdsFileShareLinkResponse:
        """
        @summary Modifies the link for file sharing.
        
        @param request: ModifyCdsFileShareLinkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCdsFileShareLinkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disable_download):
            query['DisableDownload'] = request.disable_download
        if not UtilClient.is_unset(request.disable_preview):
            query['DisablePreview'] = request.disable_preview
        if not UtilClient.is_unset(request.disable_save):
            query['DisableSave'] = request.disable_save
        if not UtilClient.is_unset(request.download_count):
            query['DownloadCount'] = request.download_count
        if not UtilClient.is_unset(request.download_limit):
            query['DownloadLimit'] = request.download_limit
        if not UtilClient.is_unset(request.expiration):
            query['Expiration'] = request.expiration
        if not UtilClient.is_unset(request.preview_count):
            query['PreviewCount'] = request.preview_count
        if not UtilClient.is_unset(request.preview_limit):
            query['PreviewLimit'] = request.preview_limit
        if not UtilClient.is_unset(request.report_count):
            query['ReportCount'] = request.report_count
        if not UtilClient.is_unset(request.save_count):
            query['SaveCount'] = request.save_count
        if not UtilClient.is_unset(request.save_limit):
            query['SaveLimit'] = request.save_limit
        if not UtilClient.is_unset(request.share_id):
            query['ShareId'] = request.share_id
        if not UtilClient.is_unset(request.share_name):
            query['ShareName'] = request.share_name
        if not UtilClient.is_unset(request.share_pwd):
            query['SharePwd'] = request.share_pwd
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.video_preview_count):
            query['VideoPreviewCount'] = request.video_preview_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCdsFileShareLink',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCdsFileShareLinkResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCdsFileShareLinkResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_cds_file_share_link(
        self,
        request: ecd_20200930_models.ModifyCdsFileShareLinkRequest,
    ) -> ecd_20200930_models.ModifyCdsFileShareLinkResponse:
        """
        @summary Modifies the link for file sharing.
        
        @param request: ModifyCdsFileShareLinkRequest
        @return: ModifyCdsFileShareLinkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_cds_file_share_link_with_options(request, runtime)

    async def modify_cds_file_share_link_async(
        self,
        request: ecd_20200930_models.ModifyCdsFileShareLinkRequest,
    ) -> ecd_20200930_models.ModifyCdsFileShareLinkResponse:
        """
        @summary Modifies the link for file sharing.
        
        @param request: ModifyCdsFileShareLinkRequest
        @return: ModifyCdsFileShareLinkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_cds_file_share_link_with_options_async(request, runtime)

    def modify_cloud_drive_groups_with_options(
        self,
        request: ecd_20200930_models.ModifyCloudDriveGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCloudDriveGroupsResponse:
        """
        @summary Modifies team spaces.
        
        @param request: ModifyCloudDriveGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCloudDriveGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.total_size):
            query['TotalSize'] = request.total_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCloudDriveGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDriveGroupsResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDriveGroupsResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_cloud_drive_groups_with_options_async(
        self,
        request: ecd_20200930_models.ModifyCloudDriveGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCloudDriveGroupsResponse:
        """
        @summary Modifies team spaces.
        
        @param request: ModifyCloudDriveGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCloudDriveGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.total_size):
            query['TotalSize'] = request.total_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCloudDriveGroups',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDriveGroupsResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDriveGroupsResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_cloud_drive_groups(
        self,
        request: ecd_20200930_models.ModifyCloudDriveGroupsRequest,
    ) -> ecd_20200930_models.ModifyCloudDriveGroupsResponse:
        """
        @summary Modifies team spaces.
        
        @param request: ModifyCloudDriveGroupsRequest
        @return: ModifyCloudDriveGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_cloud_drive_groups_with_options(request, runtime)

    async def modify_cloud_drive_groups_async(
        self,
        request: ecd_20200930_models.ModifyCloudDriveGroupsRequest,
    ) -> ecd_20200930_models.ModifyCloudDriveGroupsResponse:
        """
        @summary Modifies team spaces.
        
        @param request: ModifyCloudDriveGroupsRequest
        @return: ModifyCloudDriveGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_cloud_drive_groups_with_options_async(request, runtime)

    def modify_cloud_drive_permission_with_options(
        self,
        request: ecd_20200930_models.ModifyCloudDrivePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCloudDrivePermissionResponse:
        """
        @summary Modifies the user permissions on Cloud Drive Service, and configures users who have the download permissions and upload and download permissions. By default, the users that are not configured the preceding permissions only have the upload permissions.
        
        @param request: ModifyCloudDrivePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCloudDrivePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.download_end_user_ids):
            query['DownloadEndUserIds'] = request.download_end_user_ids
        if not UtilClient.is_unset(request.download_upload_end_user_ids):
            query['DownloadUploadEndUserIds'] = request.download_upload_end_user_ids
        if not UtilClient.is_unset(request.no_download_no_upload_end_user_ids):
            query['NoDownloadNoUploadEndUserIds'] = request.no_download_no_upload_end_user_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCloudDrivePermission',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDrivePermissionResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDrivePermissionResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_cloud_drive_permission_with_options_async(
        self,
        request: ecd_20200930_models.ModifyCloudDrivePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCloudDrivePermissionResponse:
        """
        @summary Modifies the user permissions on Cloud Drive Service, and configures users who have the download permissions and upload and download permissions. By default, the users that are not configured the preceding permissions only have the upload permissions.
        
        @param request: ModifyCloudDrivePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCloudDrivePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.download_end_user_ids):
            query['DownloadEndUserIds'] = request.download_end_user_ids
        if not UtilClient.is_unset(request.download_upload_end_user_ids):
            query['DownloadUploadEndUserIds'] = request.download_upload_end_user_ids
        if not UtilClient.is_unset(request.no_download_no_upload_end_user_ids):
            query['NoDownloadNoUploadEndUserIds'] = request.no_download_no_upload_end_user_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCloudDrivePermission',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDrivePermissionResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDrivePermissionResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_cloud_drive_permission(
        self,
        request: ecd_20200930_models.ModifyCloudDrivePermissionRequest,
    ) -> ecd_20200930_models.ModifyCloudDrivePermissionResponse:
        """
        @summary Modifies the user permissions on Cloud Drive Service, and configures users who have the download permissions and upload and download permissions. By default, the users that are not configured the preceding permissions only have the upload permissions.
        
        @param request: ModifyCloudDrivePermissionRequest
        @return: ModifyCloudDrivePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_cloud_drive_permission_with_options(request, runtime)

    async def modify_cloud_drive_permission_async(
        self,
        request: ecd_20200930_models.ModifyCloudDrivePermissionRequest,
    ) -> ecd_20200930_models.ModifyCloudDrivePermissionResponse:
        """
        @summary Modifies the user permissions on Cloud Drive Service, and configures users who have the download permissions and upload and download permissions. By default, the users that are not configured the preceding permissions only have the upload permissions.
        
        @param request: ModifyCloudDrivePermissionRequest
        @return: ModifyCloudDrivePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_cloud_drive_permission_with_options_async(request, runtime)

    def modify_cloud_drive_users_with_options(
        self,
        request: ecd_20200930_models.ModifyCloudDriveUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCloudDriveUsersResponse:
        """
        @summary 修改无影网盘终端用户的属性
        
        @param request: ModifyCloudDriveUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCloudDriveUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.user_max_size):
            query['UserMaxSize'] = request.user_max_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCloudDriveUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDriveUsersResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDriveUsersResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_cloud_drive_users_with_options_async(
        self,
        request: ecd_20200930_models.ModifyCloudDriveUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCloudDriveUsersResponse:
        """
        @summary 修改无影网盘终端用户的属性
        
        @param request: ModifyCloudDriveUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCloudDriveUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cds_id):
            query['CdsId'] = request.cds_id
        if not UtilClient.is_unset(request.end_user_id):
            query['EndUserId'] = request.end_user_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.user_max_size):
            query['UserMaxSize'] = request.user_max_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCloudDriveUsers',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDriveUsersResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCloudDriveUsersResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_cloud_drive_users(
        self,
        request: ecd_20200930_models.ModifyCloudDriveUsersRequest,
    ) -> ecd_20200930_models.ModifyCloudDriveUsersResponse:
        """
        @summary 修改无影网盘终端用户的属性
        
        @param request: ModifyCloudDriveUsersRequest
        @return: ModifyCloudDriveUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_cloud_drive_users_with_options(request, runtime)

    async def modify_cloud_drive_users_async(
        self,
        request: ecd_20200930_models.ModifyCloudDriveUsersRequest,
    ) -> ecd_20200930_models.ModifyCloudDriveUsersResponse:
        """
        @summary 修改无影网盘终端用户的属性
        
        @param request: ModifyCloudDriveUsersRequest
        @return: ModifyCloudDriveUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_cloud_drive_users_with_options_async(request, runtime)

    def modify_config_group_with_options(
        self,
        request: ecd_20200930_models.ModifyConfigGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyConfigGroupResponse:
        """
        @summary Modifies the basic information of a configuration group.
        
        @param request: ModifyConfigGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyConfigGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyConfigGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyConfigGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyConfigGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_config_group_with_options_async(
        self,
        request: ecd_20200930_models.ModifyConfigGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyConfigGroupResponse:
        """
        @summary Modifies the basic information of a configuration group.
        
        @param request: ModifyConfigGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyConfigGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyConfigGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyConfigGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyConfigGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_config_group(
        self,
        request: ecd_20200930_models.ModifyConfigGroupRequest,
    ) -> ecd_20200930_models.ModifyConfigGroupResponse:
        """
        @summary Modifies the basic information of a configuration group.
        
        @param request: ModifyConfigGroupRequest
        @return: ModifyConfigGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_config_group_with_options(request, runtime)

    async def modify_config_group_async(
        self,
        request: ecd_20200930_models.ModifyConfigGroupRequest,
    ) -> ecd_20200930_models.ModifyConfigGroupResponse:
        """
        @summary Modifies the basic information of a configuration group.
        
        @param request: ModifyConfigGroupRequest
        @return: ModifyConfigGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_config_group_with_options_async(request, runtime)

    def modify_customized_list_headers_with_options(
        self,
        request: ecd_20200930_models.ModifyCustomizedListHeadersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCustomizedListHeadersResponse:
        """
        @summary Modifies the layouts of cloud computer list headers, such as the required fields and the display and hide settings.
        
        @param request: ModifyCustomizedListHeadersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCustomizedListHeadersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.headers):
            query['Headers'] = request.headers
        if not UtilClient.is_unset(request.list_type):
            query['ListType'] = request.list_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCustomizedListHeaders',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCustomizedListHeadersResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCustomizedListHeadersResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_customized_list_headers_with_options_async(
        self,
        request: ecd_20200930_models.ModifyCustomizedListHeadersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyCustomizedListHeadersResponse:
        """
        @summary Modifies the layouts of cloud computer list headers, such as the required fields and the display and hide settings.
        
        @param request: ModifyCustomizedListHeadersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCustomizedListHeadersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.headers):
            query['Headers'] = request.headers
        if not UtilClient.is_unset(request.list_type):
            query['ListType'] = request.list_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCustomizedListHeaders',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCustomizedListHeadersResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyCustomizedListHeadersResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_customized_list_headers(
        self,
        request: ecd_20200930_models.ModifyCustomizedListHeadersRequest,
    ) -> ecd_20200930_models.ModifyCustomizedListHeadersResponse:
        """
        @summary Modifies the layouts of cloud computer list headers, such as the required fields and the display and hide settings.
        
        @param request: ModifyCustomizedListHeadersRequest
        @return: ModifyCustomizedListHeadersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_customized_list_headers_with_options(request, runtime)

    async def modify_customized_list_headers_async(
        self,
        request: ecd_20200930_models.ModifyCustomizedListHeadersRequest,
    ) -> ecd_20200930_models.ModifyCustomizedListHeadersResponse:
        """
        @summary Modifies the layouts of cloud computer list headers, such as the required fields and the display and hide settings.
        
        @param request: ModifyCustomizedListHeadersRequest
        @return: ModifyCustomizedListHeadersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_customized_list_headers_with_options_async(request, runtime)

    def modify_desktop_charge_type_with_options(
        self,
        request: ecd_20200930_models.ModifyDesktopChargeTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyDesktopChargeTypeResponse:
        """
        @summary Changes the billing method of cloud computers to subscription or pay-as-you-go.
        
        @description    Before you call this operation, make sure that you fully understand the billing methods of cloud computers. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        Before you call this operation, make sure that the cloud computers whose billing method you want to change are in the Running or Stopped state and you have no overdue payments in your Alibaba Cloud account.
        After the order payment is completed, the system starts to change the billing method of the cloud computers. During the change, you cannot perform operations, such as starting or stopping the cloud computers, and changing configurations of the cloud computers.
        
        @param request: ModifyDesktopChargeTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDesktopChargeTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.use_duration):
            query['UseDuration'] = request.use_duration
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDesktopChargeType',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopChargeTypeResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopChargeTypeResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_desktop_charge_type_with_options_async(
        self,
        request: ecd_20200930_models.ModifyDesktopChargeTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyDesktopChargeTypeResponse:
        """
        @summary Changes the billing method of cloud computers to subscription or pay-as-you-go.
        
        @description    Before you call this operation, make sure that you fully understand the billing methods of cloud computers. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        Before you call this operation, make sure that the cloud computers whose billing method you want to change are in the Running or Stopped state and you have no overdue payments in your Alibaba Cloud account.
        After the order payment is completed, the system starts to change the billing method of the cloud computers. During the change, you cannot perform operations, such as starting or stopping the cloud computers, and changing configurations of the cloud computers.
        
        @param request: ModifyDesktopChargeTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDesktopChargeTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.promotion_id):
            query['PromotionId'] = request.promotion_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.use_duration):
            query['UseDuration'] = request.use_duration
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDesktopChargeType',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopChargeTypeResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopChargeTypeResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_desktop_charge_type(
        self,
        request: ecd_20200930_models.ModifyDesktopChargeTypeRequest,
    ) -> ecd_20200930_models.ModifyDesktopChargeTypeResponse:
        """
        @summary Changes the billing method of cloud computers to subscription or pay-as-you-go.
        
        @description    Before you call this operation, make sure that you fully understand the billing methods of cloud computers. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        Before you call this operation, make sure that the cloud computers whose billing method you want to change are in the Running or Stopped state and you have no overdue payments in your Alibaba Cloud account.
        After the order payment is completed, the system starts to change the billing method of the cloud computers. During the change, you cannot perform operations, such as starting or stopping the cloud computers, and changing configurations of the cloud computers.
        
        @param request: ModifyDesktopChargeTypeRequest
        @return: ModifyDesktopChargeTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_desktop_charge_type_with_options(request, runtime)

    async def modify_desktop_charge_type_async(
        self,
        request: ecd_20200930_models.ModifyDesktopChargeTypeRequest,
    ) -> ecd_20200930_models.ModifyDesktopChargeTypeResponse:
        """
        @summary Changes the billing method of cloud computers to subscription or pay-as-you-go.
        
        @description    Before you call this operation, make sure that you fully understand the billing methods of cloud computers. For more information, see [Billing overview](https://help.aliyun.com/document_detail/188395.html).
        Before you call this operation, make sure that the cloud computers whose billing method you want to change are in the Running or Stopped state and you have no overdue payments in your Alibaba Cloud account.
        After the order payment is completed, the system starts to change the billing method of the cloud computers. During the change, you cannot perform operations, such as starting or stopping the cloud computers, and changing configurations of the cloud computers.
        
        @param request: ModifyDesktopChargeTypeRequest
        @return: ModifyDesktopChargeTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_desktop_charge_type_with_options_async(request, runtime)

    def modify_desktop_group_with_options(
        self,
        request: ecd_20200930_models.ModifyDesktopGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyDesktopGroupResponse:
        """
        @summary Modifies the configurations of a cloud computer pool.
        
        @description After a cloud computer pool is created, the system creates a specific number of cloud computers in the pool based on the auto scaling policy and user connections. Cloud computers are created by using the same cloud computer template and security policy. You can modify the configurations of the pool, including the pool name, cloud computer template, and policy, in different business scenarios.
        
        @param request: ModifyDesktopGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDesktopGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_auto_setup):
            query['AllowAutoSetup'] = request.allow_auto_setup
        if not UtilClient.is_unset(request.allow_buffer_count):
            query['AllowBufferCount'] = request.allow_buffer_count
        if not UtilClient.is_unset(request.bind_amount):
            query['BindAmount'] = request.bind_amount
        if not UtilClient.is_unset(request.buy_desktops_count):
            query['BuyDesktopsCount'] = request.buy_desktops_count
        if not UtilClient.is_unset(request.classify):
            query['Classify'] = request.classify
        if not UtilClient.is_unset(request.comments):
            query['Comments'] = request.comments
        if not UtilClient.is_unset(request.connect_duration):
            query['ConnectDuration'] = request.connect_duration
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_group_name):
            query['DesktopGroupName'] = request.desktop_group_name
        if not UtilClient.is_unset(request.disable_session_config):
            query['DisableSessionConfig'] = request.disable_session_config
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.idle_disconnect_duration):
            query['IdleDisconnectDuration'] = request.idle_disconnect_duration
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.keep_duration):
            query['KeepDuration'] = request.keep_duration
        if not UtilClient.is_unset(request.load_policy):
            query['LoadPolicy'] = request.load_policy
        if not UtilClient.is_unset(request.max_desktops_count):
            query['MaxDesktopsCount'] = request.max_desktops_count
        if not UtilClient.is_unset(request.min_desktops_count):
            query['MinDesktopsCount'] = request.min_desktops_count
        if not UtilClient.is_unset(request.own_bundle_id):
            query['OwnBundleId'] = request.own_bundle_id
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.policy_group_ids):
            query['PolicyGroupIds'] = request.policy_group_ids
        if not UtilClient.is_unset(request.profile_follow_switch):
            query['ProfileFollowSwitch'] = request.profile_follow_switch
        if not UtilClient.is_unset(request.ratio_threshold):
            query['RatioThreshold'] = request.ratio_threshold
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.reset_type):
            query['ResetType'] = request.reset_type
        if not UtilClient.is_unset(request.scale_strategy_id):
            query['ScaleStrategyId'] = request.scale_strategy_id
        if not UtilClient.is_unset(request.stop_duration):
            query['StopDuration'] = request.stop_duration
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDesktopGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopGroupResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopGroupResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_desktop_group_with_options_async(
        self,
        request: ecd_20200930_models.ModifyDesktopGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyDesktopGroupResponse:
        """
        @summary Modifies the configurations of a cloud computer pool.
        
        @description After a cloud computer pool is created, the system creates a specific number of cloud computers in the pool based on the auto scaling policy and user connections. Cloud computers are created by using the same cloud computer template and security policy. You can modify the configurations of the pool, including the pool name, cloud computer template, and policy, in different business scenarios.
        
        @param request: ModifyDesktopGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDesktopGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_auto_setup):
            query['AllowAutoSetup'] = request.allow_auto_setup
        if not UtilClient.is_unset(request.allow_buffer_count):
            query['AllowBufferCount'] = request.allow_buffer_count
        if not UtilClient.is_unset(request.bind_amount):
            query['BindAmount'] = request.bind_amount
        if not UtilClient.is_unset(request.buy_desktops_count):
            query['BuyDesktopsCount'] = request.buy_desktops_count
        if not UtilClient.is_unset(request.classify):
            query['Classify'] = request.classify
        if not UtilClient.is_unset(request.comments):
            query['Comments'] = request.comments
        if not UtilClient.is_unset(request.connect_duration):
            query['ConnectDuration'] = request.connect_duration
        if not UtilClient.is_unset(request.desktop_group_id):
            query['DesktopGroupId'] = request.desktop_group_id
        if not UtilClient.is_unset(request.desktop_group_name):
            query['DesktopGroupName'] = request.desktop_group_name
        if not UtilClient.is_unset(request.disable_session_config):
            query['DisableSessionConfig'] = request.disable_session_config
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.idle_disconnect_duration):
            query['IdleDisconnectDuration'] = request.idle_disconnect_duration
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.keep_duration):
            query['KeepDuration'] = request.keep_duration
        if not UtilClient.is_unset(request.load_policy):
            query['LoadPolicy'] = request.load_policy
        if not UtilClient.is_unset(request.max_desktops_count):
            query['MaxDesktopsCount'] = request.max_desktops_count
        if not UtilClient.is_unset(request.min_desktops_count):
            query['MinDesktopsCount'] = request.min_desktops_count
        if not UtilClient.is_unset(request.own_bundle_id):
            query['OwnBundleId'] = request.own_bundle_id
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.policy_group_ids):
            query['PolicyGroupIds'] = request.policy_group_ids
        if not UtilClient.is_unset(request.profile_follow_switch):
            query['ProfileFollowSwitch'] = request.profile_follow_switch
        if not UtilClient.is_unset(request.ratio_threshold):
            query['RatioThreshold'] = request.ratio_threshold
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.reset_type):
            query['ResetType'] = request.reset_type
        if not UtilClient.is_unset(request.scale_strategy_id):
            query['ScaleStrategyId'] = request.scale_strategy_id
        if not UtilClient.is_unset(request.stop_duration):
            query['StopDuration'] = request.stop_duration
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDesktopGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopGroupResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopGroupResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_desktop_group(
        self,
        request: ecd_20200930_models.ModifyDesktopGroupRequest,
    ) -> ecd_20200930_models.ModifyDesktopGroupResponse:
        """
        @summary Modifies the configurations of a cloud computer pool.
        
        @description After a cloud computer pool is created, the system creates a specific number of cloud computers in the pool based on the auto scaling policy and user connections. Cloud computers are created by using the same cloud computer template and security policy. You can modify the configurations of the pool, including the pool name, cloud computer template, and policy, in different business scenarios.
        
        @param request: ModifyDesktopGroupRequest
        @return: ModifyDesktopGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_desktop_group_with_options(request, runtime)

    async def modify_desktop_group_async(
        self,
        request: ecd_20200930_models.ModifyDesktopGroupRequest,
    ) -> ecd_20200930_models.ModifyDesktopGroupResponse:
        """
        @summary Modifies the configurations of a cloud computer pool.
        
        @description After a cloud computer pool is created, the system creates a specific number of cloud computers in the pool based on the auto scaling policy and user connections. Cloud computers are created by using the same cloud computer template and security policy. You can modify the configurations of the pool, including the pool name, cloud computer template, and policy, in different business scenarios.
        
        @param request: ModifyDesktopGroupRequest
        @return: ModifyDesktopGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_desktop_group_with_options_async(request, runtime)

    def modify_desktop_host_name_with_options(
        self,
        request: ecd_20200930_models.ModifyDesktopHostNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyDesktopHostNameResponse:
        """
        @summary Modifies the hostname of a Windows cloud computer in the Active Directory (AD) office network.
        
        @description The Windows cloud computer whose hostname you want to modify must be in an AD office network. After the hostname is modified, the cloud computer is re-created.
        
        @param request: ModifyDesktopHostNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDesktopHostNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.new_host_name):
            query['NewHostName'] = request.new_host_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDesktopHostName',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopHostNameResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopHostNameResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_desktop_host_name_with_options_async(
        self,
        request: ecd_20200930_models.ModifyDesktopHostNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyDesktopHostNameResponse:
        """
        @summary Modifies the hostname of a Windows cloud computer in the Active Directory (AD) office network.
        
        @description The Windows cloud computer whose hostname you want to modify must be in an AD office network. After the hostname is modified, the cloud computer is re-created.
        
        @param request: ModifyDesktopHostNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDesktopHostNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.new_host_name):
            query['NewHostName'] = request.new_host_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDesktopHostName',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopHostNameResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopHostNameResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_desktop_host_name(
        self,
        request: ecd_20200930_models.ModifyDesktopHostNameRequest,
    ) -> ecd_20200930_models.ModifyDesktopHostNameResponse:
        """
        @summary Modifies the hostname of a Windows cloud computer in the Active Directory (AD) office network.
        
        @description The Windows cloud computer whose hostname you want to modify must be in an AD office network. After the hostname is modified, the cloud computer is re-created.
        
        @param request: ModifyDesktopHostNameRequest
        @return: ModifyDesktopHostNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_desktop_host_name_with_options(request, runtime)

    async def modify_desktop_host_name_async(
        self,
        request: ecd_20200930_models.ModifyDesktopHostNameRequest,
    ) -> ecd_20200930_models.ModifyDesktopHostNameResponse:
        """
        @summary Modifies the hostname of a Windows cloud computer in the Active Directory (AD) office network.
        
        @description The Windows cloud computer whose hostname you want to modify must be in an AD office network. After the hostname is modified, the cloud computer is re-created.
        
        @param request: ModifyDesktopHostNameRequest
        @return: ModifyDesktopHostNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_desktop_host_name_with_options_async(request, runtime)

    def modify_desktop_name_with_options(
        self,
        request: ecd_20200930_models.ModifyDesktopNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyDesktopNameResponse:
        """
        @summary Changes the name of a cloud computer to a new name.
        
        @param request: ModifyDesktopNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDesktopNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.new_desktop_name):
            query['NewDesktopName'] = request.new_desktop_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDesktopName',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopNameResponse(),
                self.call_api(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopNameResponse(),
                self.execute(params, req, runtime)
            )

    async def modify_desktop_name_with_options_async(
        self,
        request: ecd_20200930_models.ModifyDesktopNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyDesktopNameResponse:
        """
        @summary Changes the name of a cloud computer to a new name.
        
        @param request: ModifyDesktopNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDesktopNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.desktop_id):
            query['DesktopId'] = request.desktop_id
        if not UtilClient.is_unset(request.new_desktop_name):
            query['NewDesktopName'] = request.new_desktop_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDesktopName',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        if UtilClient.is_unset(self._signature_version) or not UtilClient.equal_string(self._signature_version, 'v4'):
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopNameResponse(),
                await self.call_api_async(params, req, runtime)
            )
        else:
            return TeaCore.from_map(
                ecd_20200930_models.ModifyDesktopNameResponse(),
                await self.execute_async(params, req, runtime)
            )

    def modify_desktop_name(
        self,
        request: ecd_20200930_models.ModifyDesktopNameRequest,
    ) -> ecd_20200930_models.ModifyDesktopNameResponse:
        """
        @summary Changes the name of a cloud computer to a new name.
        
        @param request: ModifyDesktopNameRequest
        @return: ModifyDesktopNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_desktop_name_with_options(request, runtime)

    async def modify_desktop_name_async(
        self,
        request: ecd_20200930_models.ModifyDesktopNameRequest,
    ) -> ecd_20200930_models.ModifyDesktopNameResponse:
        """
        @summary Changes the name of a cloud computer to a new name.
        
        @param request: ModifyDesktopNameRequest
        @return: ModifyDesktopNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_desktop_name_with_options_async(request, runtime)

    def modify_desktop_oversold_group_with_options(
        self,
        request: ecd_20200930_models.ModifyDesktopOversoldGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecd_20200930_models.ModifyDesktopOversoldGroupResponse:
        """
        @summary 修改桌面超卖组
        
        @param request: ModifyDesktopOversoldGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDesktopOversoldGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.concurrence_count):
            query['ConcurrenceCount'] = request.concurrence_count
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.idle_disconnect_duration):
            query['IdleDisconnectDuration'] = request.idle_disconnect_duration
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.keep_duration):
            query['KeepDuration'] = request.keep_duration
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.oversold_group_id):
            query['OversoldGroupId'] = request.oversold_group_id
        if not UtilClient.is_unset(request.oversold_user_count):
            query['OversoldUserCount'] = request.oversold_user_count
        if not UtilClient.is_unset(request.oversold_warn):
            query['OversoldWarn'] = request.oversold_warn
        if not UtilClient.is_unset(request.policy_group_id):
            query['PolicyGroupId'] = request.policy_group_id
        if not UtilClient.is_unset(request.stop_duration):
            query['StopDuration'] = request.stop_duration
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDesktopOversoldGroup',
            version='2020-09-30',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type