# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List


class CdsFileShareLinkModel(TeaModel):
    def __init__(
        self,
        access_count: int = None,
        create_time: str = None,
        creator: str = None,
        description: str = None,
        disable_download: bool = None,
        disable_preview: bool = None,
        disable_save: bool = None,
        download_count: int = None,
        download_limit: int = None,
        drive_id: str = None,
        expiration: str = None,
        expired: bool = None,
        file_ids: str = None,
        modifiy_time: str = None,
        preview_count: int = None,
        preview_limit: int = None,
        report_count: int = None,
        save_count: int = None,
        save_limit: int = None,
        share_id: str = None,
        share_link: str = None,
        share_name: str = None,
        share_pwd: str = None,
        status: str = None,
        video_preview_count: int = None,
    ):
        self.access_count = access_count
        self.create_time = create_time
        self.creator = creator
        self.description = description
        self.disable_download = disable_download
        self.disable_preview = disable_preview
        self.disable_save = disable_save
        self.download_count = download_count
        self.download_limit = download_limit
        self.drive_id = drive_id
        self.expiration = expiration
        self.expired = expired
        self.file_ids = file_ids
        self.modifiy_time = modifiy_time
        self.preview_count = preview_count
        self.preview_limit = preview_limit
        self.report_count = report_count
        self.save_count = save_count
        self.save_limit = save_limit
        self.share_id = share_id
        self.share_link = share_link
        self.share_name = share_name
        self.share_pwd = share_pwd
        self.status = status
        self.video_preview_count = video_preview_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_count is not None:
            result['AccessCount'] = self.access_count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.description is not None:
            result['Description'] = self.description
        if self.disable_download is not None:
            result['DisableDownload'] = self.disable_download
        if self.disable_preview is not None:
            result['DisablePreview'] = self.disable_preview
        if self.disable_save is not None:
            result['DisableSave'] = self.disable_save
        if self.download_count is not None:
            result['DownloadCount'] = self.download_count
        if self.download_limit is not None:
            result['DownloadLimit'] = self.download_limit
        if self.drive_id is not None:
            result['DriveId'] = self.drive_id
        if self.expiration is not None:
            result['Expiration'] = self.expiration
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.file_ids is not None:
            result['FileIds'] = self.file_ids
        if self.modifiy_time is not None:
            result['ModifiyTime'] = self.modifiy_time
        if self.preview_count is not None:
            result['PreviewCount'] = self.preview_count
        if self.preview_limit is not None:
            result['PreviewLimit'] = self.preview_limit
        if self.report_count is not None:
            result['ReportCount'] = self.report_count
        if self.save_count is not None:
            result['SaveCount'] = self.save_count
        if self.save_limit is not None:
            result['SaveLimit'] = self.save_limit
        if self.share_id is not None:
            result['ShareId'] = self.share_id
        if self.share_link is not None:
            result['ShareLink'] = self.share_link
        if self.share_name is not None:
            result['ShareName'] = self.share_name
        if self.share_pwd is not None:
            result['SharePwd'] = self.share_pwd
        if self.status is not None:
            result['Status'] = self.status
        if self.video_preview_count is not None:
            result['VideoPreviewCount'] = self.video_preview_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessCount') is not None:
            self.access_count = m.get('AccessCount')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisableDownload') is not None:
            self.disable_download = m.get('DisableDownload')
        if m.get('DisablePreview') is not None:
            self.disable_preview = m.get('DisablePreview')
        if m.get('DisableSave') is not None:
            self.disable_save = m.get('DisableSave')
        if m.get('DownloadCount') is not None:
            self.download_count = m.get('DownloadCount')
        if m.get('DownloadLimit') is not None:
            self.download_limit = m.get('DownloadLimit')
        if m.get('DriveId') is not None:
            self.drive_id = m.get('DriveId')
        if m.get('Expiration') is not None:
            self.expiration = m.get('Expiration')
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('FileIds') is not None:
            self.file_ids = m.get('FileIds')
        if m.get('ModifiyTime') is not None:
            self.modifiy_time = m.get('ModifiyTime')
        if m.get('PreviewCount') is not None:
            self.preview_count = m.get('PreviewCount')
        if m.get('PreviewLimit') is not None:
            self.preview_limit = m.get('PreviewLimit')
        if m.get('ReportCount') is not None:
            self.report_count = m.get('ReportCount')
        if m.get('SaveCount') is not None:
            self.save_count = m.get('SaveCount')
        if m.get('SaveLimit') is not None:
            self.save_limit = m.get('SaveLimit')
        if m.get('ShareId') is not None:
            self.share_id = m.get('ShareId')
        if m.get('ShareLink') is not None:
            self.share_link = m.get('ShareLink')
        if m.get('ShareName') is not None:
            self.share_name = m.get('ShareName')
        if m.get('SharePwd') is not None:
            self.share_pwd = m.get('SharePwd')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VideoPreviewCount') is not None:
            self.video_preview_count = m.get('VideoPreviewCount')
        return self


class FilePermissionMemberCdsIdentity(TeaModel):
    def __init__(
        self,
        id: str = None,
        type: str = None,
    ):
        # This parameter is required.
        self.id = id
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class FilePermissionMember(TeaModel):
    def __init__(
        self,
        cds_identity: FilePermissionMemberCdsIdentity = None,
        disinherit_sub_group: bool = None,
        expire_time: int = None,
        role_id: str = None,
    ):
        # This parameter is required.
        self.cds_identity = cds_identity
        self.disinherit_sub_group = disinherit_sub_group
        self.expire_time = expire_time
        # This parameter is required.
        self.role_id = role_id

    def validate(self):
        if self.cds_identity:
            self.cds_identity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_identity is not None:
            result['CdsIdentity'] = self.cds_identity.to_map()
        if self.disinherit_sub_group is not None:
            result['DisinheritSubGroup'] = self.disinherit_sub_group
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsIdentity') is not None:
            temp_model = FilePermissionMemberCdsIdentity()
            self.cds_identity = temp_model.from_map(m['CdsIdentity'])
        if m.get('DisinheritSubGroup') is not None:
            self.disinherit_sub_group = m.get('DisinheritSubGroup')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class Permission(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        dest_cidr_ip: str = None,
        ip_protocol: str = None,
        nic_type: str = None,
        policy: str = None,
        port_range: str = None,
        priority: str = None,
        source_cidr_ip: str = None,
        source_port_range: str = None,
    ):
        self.create_time = create_time
        self.description = description
        self.dest_cidr_ip = dest_cidr_ip
        self.ip_protocol = ip_protocol
        self.nic_type = nic_type
        self.policy = policy
        self.port_range = port_range
        self.priority = priority
        self.source_cidr_ip = source_cidr_ip
        self.source_port_range = source_port_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('NicType') is not None:
            self.nic_type = m.get('NicType')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        return self


class ActivateOfficeSiteRequest(TeaModel):
    def __init__(
        self,
        office_site_id: str = None,
        region_id: str = None,
    ):
        # The ID of the convenience office network that is locked.
        # 
        # This parameter is required.
        self.office_site_id = office_site_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ActivateOfficeSiteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ActivateOfficeSiteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ActivateOfficeSiteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ActivateOfficeSiteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDesktopOversoldUserGroupRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddDesktopOversoldUserGroupRequest(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        name: str = None,
        oversold_group_id: str = None,
        policy_group_id: str = None,
        tag: List[AddDesktopOversoldUserGroupRequestTag] = None,
    ):
        self.image_id = image_id
        self.name = name
        self.oversold_group_id = oversold_group_id
        self.policy_group_id = policy_group_id
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.name is not None:
            result['Name'] = self.name
        if self.oversold_group_id is not None:
            result['OversoldGroupId'] = self.oversold_group_id
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OversoldGroupId') is not None:
            self.oversold_group_id = m.get('OversoldGroupId')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddDesktopOversoldUserGroupRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class AddDesktopOversoldUserGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        user_group_id: str = None,
    ):
        self.user_group_id = user_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class AddDesktopOversoldUserGroupResponseBody(TeaModel):
    def __init__(
        self,
        data: AddDesktopOversoldUserGroupResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AddDesktopOversoldUserGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDesktopOversoldUserGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDesktopOversoldUserGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDesktopOversoldUserGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDevicesRequest(TeaModel):
    def __init__(
        self,
        client_type: int = None,
        device_ids: List[str] = None,
        region_id: str = None,
    ):
        # The type of the client.
        # 
        # Valid values:
        # 
        # *   1: hardware client.
        # *   2: software client.
        # 
        # This parameter is required.
        self.client_type = client_type
        # The IDs of the devices. You can specify up to 200 IDs.
        # 
        # This parameter is required.
        self.device_ids = device_ids
        # The ID of the region. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the regions supported by WUYING Workspace.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.device_ids is not None:
            result['DeviceIds'] = self.device_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('DeviceIds') is not None:
            self.device_ids = m.get('DeviceIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddDevicesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
    ):
        # The execution result. If the request was successful, `success` is returned. If the request failed, an error message is returned.
        self.code = code
        # The returned error message. This parameter is not returned if the value of Code is `success`.
        self.message = message
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDevicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddFilePermissionRequestMemberListCdsIdentity(TeaModel):
    def __init__(
        self,
        id: str = None,
        type: str = None,
    ):
        # The ID of the user.
        # 
        # This parameter is required.
        self.id = id
        # The type of the user.
        # 
        # Valid values:
        # 
        # *   <!-- -->
        # 
        #     IT_Group
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     IT_User
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddFilePermissionRequestMemberList(TeaModel):
    def __init__(
        self,
        cds_identity: AddFilePermissionRequestMemberListCdsIdentity = None,
        disinherit_sub_group: bool = None,
        expire_time: int = None,
        role_id: str = None,
    ):
        # The user of the cloud disk.
        # 
        # This parameter is required.
        self.cds_identity = cds_identity
        # Specifies whether the users of the child group can inherit the folder permissions.
        self.disinherit_sub_group = disinherit_sub_group
        # The time when the authorization expires. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC. The value never expires. You can specify a value that is predefined by the system for this parameter. Example: 4775500800000.
        self.expire_time = expire_time
        # The ID of the role to which you want to attach the folder permissions. To configure the folder permissions: you can specify a role or create custom operation permissions. You can use RoleId to specify a role. RoleId is mutually exclusive with ActionList. If you specify both of them, the value of RoleId takes precedence.
        # 
        # Valid values:
        # 
        # * SystemFileEditorWithoutShareLink
        # * SystemFileUploaderAndDownloaderWithShareLink
        # * SystemFileDownloader
        # * SystemFileEditorWithoutDelete
        # * SystemFileOwner
        # * SystemFileDownloaderWithShareLink
        # * SystemFileUploaderAndViewer
        # * SystemFileViewer
        # * SystemFileEditor
        # * SystemFileUploaderWithShareLink
        # * SystemFileUploader
        # * SystemFileUploaderAndDownloader
        # * SystemFileMetaViewer
        # 
        # This parameter is required.
        self.role_id = role_id

    def validate(self):
        if self.cds_identity:
            self.cds_identity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_identity is not None:
            result['CdsIdentity'] = self.cds_identity.to_map()
        if self.disinherit_sub_group is not None:
            result['DisinheritSubGroup'] = self.disinherit_sub_group
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsIdentity') is not None:
            temp_model = AddFilePermissionRequestMemberListCdsIdentity()
            self.cds_identity = temp_model.from_map(m['CdsIdentity'])
        if m.get('DisinheritSubGroup') is not None:
            self.disinherit_sub_group = m.get('DisinheritSubGroup')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class AddFilePermissionRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: str = None,
        file_id: str = None,
        group_id: str = None,
        member_list: List[AddFilePermissionRequestMemberList] = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk whose folder you want to share.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The ID of the end user who uses the cloud disk.
        self.end_user_id = end_user_id
        # The ID of the file.
        # 
        # This parameter is required.
        self.file_id = file_id
        # The ID of the team that uses cloud disks in Cloud Drive Service.
        self.group_id = group_id
        # The members who are granted the folder permissions.
        # 
        # This parameter is required.
        self.member_list = member_list
        # The region ID of the folder. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        if self.member_list:
            for k in self.member_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['MemberList'] = []
        if self.member_list is not None:
            for k in self.member_list:
                result['MemberList'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.member_list = []
        if m.get('MemberList') is not None:
            for k in m.get('MemberList'):
                temp_model = AddFilePermissionRequestMemberList()
                self.member_list.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddFilePermissionShrinkRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: str = None,
        file_id: str = None,
        group_id: str = None,
        member_list_shrink: str = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk whose folder you want to share.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The ID of the end user who uses the cloud disk.
        self.end_user_id = end_user_id
        # The ID of the file.
        # 
        # This parameter is required.
        self.file_id = file_id
        # The ID of the team that uses cloud disks in Cloud Drive Service.
        self.group_id = group_id
        # The members who are granted the folder permissions.
        # 
        # This parameter is required.
        self.member_list_shrink = member_list_shrink
        # The region ID of the folder. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.member_list_shrink is not None:
            result['MemberList'] = self.member_list_shrink
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MemberList') is not None:
            self.member_list_shrink = m.get('MemberList')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddFilePermissionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddFilePermissionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddFilePermissionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddFilePermissionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddUserToDesktopGroupRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        desktop_group_id: str = None,
        desktop_group_ids: List[str] = None,
        end_user_ids: List[str] = None,
        region_id: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length. For more information, see [How to ensure the idempotence of a request](https://help.aliyun.com/document_detail/25693.html).
        self.client_token = client_token
        # The ID of the desktop group that you want to assign to more regular users.
        self.desktop_group_id = desktop_group_id
        # The IDs of the desktop groups.
        self.desktop_group_ids = desktop_group_ids
        # The regular users to whom you want to assign the desktop group.
        # 
        # This parameter is required.
        self.end_user_ids = end_user_ids
        # The ID of the region.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_ids is not None:
            result['DesktopGroupIds'] = self.desktop_group_ids
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupIds') is not None:
            self.desktop_group_ids = m.get('DesktopGroupIds')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddUserToDesktopGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddUserToDesktopGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddUserToDesktopGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddUserToDesktopGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddUserToDesktopOversoldUserGroupRequest(TeaModel):
    def __init__(
        self,
        add_user_amount: int = None,
        end_user_id: str = None,
        oversold_group_id: str = None,
        user_group_id: str = None,
    ):
        self.add_user_amount = add_user_amount
        self.end_user_id = end_user_id
        self.oversold_group_id = oversold_group_id
        self.user_group_id = user_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_user_amount is not None:
            result['AddUserAmount'] = self.add_user_amount
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.oversold_group_id is not None:
            result['OversoldGroupId'] = self.oversold_group_id
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddUserAmount') is not None:
            self.add_user_amount = m.get('AddUserAmount')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('OversoldGroupId') is not None:
            self.oversold_group_id = m.get('OversoldGroupId')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class AddUserToDesktopOversoldUserGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddUserToDesktopOversoldUserGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddUserToDesktopOversoldUserGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddUserToDesktopOversoldUserGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        desktop_id: List[str] = None,
        policy_id: str = None,
        region_id: str = None,
    ):
        # The IDs of the cloud computers. You can specify 1 to 20 IDs.
        # 
        # This parameter is required.
        self.desktop_id = desktop_id
        # The ID of the automatic snapshot policy.
        # 
        # This parameter is required.
        self.policy_id = policy_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ApplyAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApplyAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyCoordinatePrivilegeRequest(TeaModel):
    def __init__(
        self,
        co_id: str = None,
        end_user_id: str = None,
        region_id: str = None,
        user_type: str = None,
        uuid: str = None,
    ):
        # The ID of the application for the coordinate permissions.
        # 
        # This parameter is required.
        self.co_id = co_id
        # The ID of the end user.
        self.end_user_id = end_user_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The type of user who requires the coordinate permissions.
        # 
        # Valid value: TENANT_ADMIN.
        # 
        # This parameter is required.
        self.user_type = user_type
        # The unique identifier of the client. If you use an Alibaba Cloud Workspace client, click **About** on the client logon page to view the identifier of the client.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.co_id is not None:
            result['CoId'] = self.co_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.user_type is not None:
            result['UserType'] = self.user_type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoId') is not None:
            self.co_id = m.get('CoId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class ApplyCoordinatePrivilegeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApplyCoordinatePrivilegeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyCoordinatePrivilegeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyCoordinatePrivilegeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyCoordinationForMonitoringRequestResourceCandidates(TeaModel):
    def __init__(
        self,
        owner_ali_uid: int = None,
        owner_end_user_id: str = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_properties: str = None,
        resource_region_id: str = None,
        resource_type: str = None,
    ):
        # The ID of the Alibaba Cloud account to which the current cloud desktop belongs.
        # 
        # This parameter is required.
        self.owner_ali_uid = owner_ali_uid
        # The ID of the current end user.
        self.owner_end_user_id = owner_end_user_id
        # The ID of the cloud desktop.
        # 
        # This parameter is required.
        self.resource_id = resource_id
        # The name of the cloud desktop.
        # 
        # This parameter is required.
        self.resource_name = resource_name
        # The properties of the cloud desktop.
        self.resource_properties = resource_properties
        # The region where the resource resides.
        # 
        # This parameter is required.
        self.resource_region_id = resource_region_id
        # The resource type.
        # 
        # Set the value to CLOUD_DESKTOP.
        # 
        # *   The value CLOUD_DESKTOP specifies that the resource is a cloud desktop.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # This parameter is required.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_ali_uid is not None:
            result['OwnerAliUid'] = self.owner_ali_uid
        if self.owner_end_user_id is not None:
            result['OwnerEndUserId'] = self.owner_end_user_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_properties is not None:
            result['ResourceProperties'] = self.resource_properties
        if self.resource_region_id is not None:
            result['ResourceRegionId'] = self.resource_region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAliUid') is not None:
            self.owner_ali_uid = m.get('OwnerAliUid')
        if m.get('OwnerEndUserId') is not None:
            self.owner_end_user_id = m.get('OwnerEndUserId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceProperties') is not None:
            self.resource_properties = m.get('ResourceProperties')
        if m.get('ResourceRegionId') is not None:
            self.resource_region_id = m.get('ResourceRegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class ApplyCoordinationForMonitoringRequest(TeaModel):
    def __init__(
        self,
        coordinate_policy_type: str = None,
        end_user_id: str = None,
        initiator_type: str = None,
        region_id: str = None,
        resource_candidates: List[ApplyCoordinationForMonitoringRequestResourceCandidates] = None,
        uuid: str = None,
    ):
        # The coordination policy.
        # 
        # Set the value to FULL_CONTROL.
        # 
        # *   The value FULL_CONTROL specifies that the cloud desktop is shared and remote access to the cloud desktop is allowed.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # This parameter is required.
        self.coordinate_policy_type = coordinate_policy_type
        # The ID of the end user who initiates the stream collaboration. If the initiator is the administrator, do not specify this parameter.
        self.end_user_id = end_user_id
        # The type of the initiator.
        # 
        # Set the value to ADMIN_INITIATE.
        # 
        # *   The value ADMIN_INITIATE specifies that the administrator initiates the coordination request.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.initiator_type = initiator_type
        # The region ID. You can call the [DescribeRegions](https://next.api.aliyun.com/document/ecd/2020-09-30/DescribeRegions) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The list of cloud desktops that run the collaboration task at the same time.
        # 
        # This parameter is required.
        self.resource_candidates = resource_candidates
        # The universally unique identifier (UUID) of the device.
        # 
        # This parameter is required.
        self.uuid = uuid

    def validate(self):
        if self.resource_candidates:
            for k in self.resource_candidates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.coordinate_policy_type is not None:
            result['CoordinatePolicyType'] = self.coordinate_policy_type
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.initiator_type is not None:
            result['InitiatorType'] = self.initiator_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['ResourceCandidates'] = []
        if self.resource_candidates is not None:
            for k in self.resource_candidates:
                result['ResourceCandidates'].append(k.to_map() if k else None)
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoordinatePolicyType') is not None:
            self.coordinate_policy_type = m.get('CoordinatePolicyType')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('InitiatorType') is not None:
            self.initiator_type = m.get('InitiatorType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.resource_candidates = []
        if m.get('ResourceCandidates') is not None:
            for k in m.get('ResourceCandidates'):
                temp_model = ApplyCoordinationForMonitoringRequestResourceCandidates()
                self.resource_candidates.append(temp_model.from_map(k))
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class ApplyCoordinationForMonitoringResponseBodyCoordinateFlowModels(TeaModel):
    def __init__(
        self,
        co_id: str = None,
        coordinate_status: str = None,
        coordinate_ticket: str = None,
        initiator_type: str = None,
        owner_user_id: str = None,
        resource_id: str = None,
        resource_name: str = None,
    ):
        # The ID of the stream collaboration.
        self.co_id = co_id
        # The current status of the collaboration task.
        # 
        # Valid values:
        # 
        # *   COORDINATING: The collaboration task is being executed.
        # 
        # *   TERMINATING: The collaboration task is being terminated.
        # 
        # *   TERMINATED: The collaboration task is terminated.
        # 
        # *   PENDING: The collaboration task is pending to be executed.
        self.coordinate_status = coordinate_status
        # The ticket that is used to establish the Adaptive Streaming Protocol (ASP)-based connection.
        self.coordinate_ticket = coordinate_ticket
        # The type of the initiator.
        # 
        # Valid values:
        # 
        # *   ADMIN_INITIATE_FORCE: The administrator forcibly initiates the collaboration request.
        # 
        # *   ADMIN_INITIATE: The administrator initiates the collaboration request.
        # 
        # *   COORDINATOR_INITIATE_FORCE: The coordinator forcibly initiates the collaboration request.
        self.initiator_type = initiator_type
        # The ID of the Alibaba Cloud account of the end user.
        self.owner_user_id = owner_user_id
        # The ID of the cloud desktop.
        self.resource_id = resource_id
        # The name of the cloud desktop.
        self.resource_name = resource_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.co_id is not None:
            result['CoId'] = self.co_id
        if self.coordinate_status is not None:
            result['CoordinateStatus'] = self.coordinate_status
        if self.coordinate_ticket is not None:
            result['CoordinateTicket'] = self.coordinate_ticket
        if self.initiator_type is not None:
            result['InitiatorType'] = self.initiator_type
        if self.owner_user_id is not None:
            result['OwnerUserId'] = self.owner_user_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoId') is not None:
            self.co_id = m.get('CoId')
        if m.get('CoordinateStatus') is not None:
            self.coordinate_status = m.get('CoordinateStatus')
        if m.get('CoordinateTicket') is not None:
            self.coordinate_ticket = m.get('CoordinateTicket')
        if m.get('InitiatorType') is not None:
            self.initiator_type = m.get('InitiatorType')
        if m.get('OwnerUserId') is not None:
            self.owner_user_id = m.get('OwnerUserId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        return self


class ApplyCoordinationForMonitoringResponseBody(TeaModel):
    def __init__(
        self,
        coordinate_flow_models: List[ApplyCoordinationForMonitoringResponseBodyCoordinateFlowModels] = None,
        request_id: str = None,
    ):
        # The list of stream collaboration models.
        self.coordinate_flow_models = coordinate_flow_models
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.coordinate_flow_models:
            for k in self.coordinate_flow_models:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CoordinateFlowModels'] = []
        if self.coordinate_flow_models is not None:
            for k in self.coordinate_flow_models:
                result['CoordinateFlowModels'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.coordinate_flow_models = []
        if m.get('CoordinateFlowModels') is not None:
            for k in m.get('CoordinateFlowModels'):
                temp_model = ApplyCoordinationForMonitoringResponseBodyCoordinateFlowModels()
                self.coordinate_flow_models.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApplyCoordinationForMonitoringResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyCoordinationForMonitoringResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyCoordinationForMonitoringResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApproveFotaUpdateRequest(TeaModel):
    def __init__(
        self,
        app_version: str = None,
        desktop_id: str = None,
        region_id: str = None,
    ):
        # Mirror version.
        # 
        # This parameter is required.
        self.app_version = app_version
        # The ID of the cloud computer.
        # 
        # This parameter is required.
        self.desktop_id = desktop_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the regions supported by Elastic Desktop Service.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ApproveFotaUpdateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApproveFotaUpdateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApproveFotaUpdateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApproveFotaUpdateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateNetworkPackageRequest(TeaModel):
    def __init__(
        self,
        network_package_id: str = None,
        office_site_id: str = None,
        region_id: str = None,
    ):
        # The ID of the premium bandwidth plan.
        # 
        # This parameter is required.
        self.network_package_id = network_package_id
        # The ID of the office network. You can call the [DescribeNetworkPackages](https://help.aliyun.com/document_detail/216079.html) to obtain the ID of the office network to which a premium bandwidth plan is bound.
        # 
        # This parameter is required.
        self.office_site_id = office_site_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AssociateNetworkPackageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateNetworkPackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AssociateNetworkPackageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssociateNetworkPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachCenRequest(TeaModel):
    def __init__(
        self,
        cen_id: str = None,
        cen_owner_id: int = None,
        office_site_id: str = None,
        region_id: str = None,
        verify_code: str = None,
    ):
        # The ID of the CEN instance.
        # 
        # This parameter is required.
        self.cen_id = cen_id
        # The Alibaba Cloud account to which the CEN instance belongs.
        # 
        # *   If you own the CEN instance, you can skip this parameter.
        # *   If you do not own the CEN instance, you must specify the ID of the account that owns the CEN instance.
        self.cen_owner_id = cen_owner_id
        # The office network ID.
        # 
        # This parameter is required.
        self.office_site_id = office_site_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The verification code. If you do not own the CEN instance, you must call the [SendVerifyCode](https://help.aliyun.com/document_detail/436847.html) operation to obtain a verification code.
        self.verify_code = verify_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.verify_code is not None:
            result['VerifyCode'] = self.verify_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VerifyCode') is not None:
            self.verify_code = m.get('VerifyCode')
        return self


class AttachCenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachCenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachCenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachEndUserRequest(TeaModel):
    def __init__(
        self,
        ad_domain: str = None,
        client_type: int = None,
        device_id: str = None,
        directory_id: str = None,
        end_user_id: str = None,
        region_id: str = None,
        user_type: str = None,
    ):
        # The address of the Active Directory (AD) office network.
        self.ad_domain = ad_domain
        # The type of the client.
        # 
        # Valid values:
        # 
        # *   1: hardware client.
        # 
        # This parameter is required.
        self.client_type = client_type
        # The serial number (SN) of the hardware client.
        # 
        # This parameter is required.
        self.device_id = device_id
        # The ID of the convenient office network.
        self.directory_id = directory_id
        # The ID of the user that you want to bind to the hardware client.
        # 
        # This parameter is required.
        self.end_user_id = end_user_id
        # The ID of the region. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the regions supported by WUYING Workspace.
        self.region_id = region_id
        # The account type of the user.
        # 
        # Valid values:
        # 
        # *   AD: enterprise AD account.
        # *   SIMPLE: convenience account
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_domain is not None:
            result['AdDomain'] = self.ad_domain
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdDomain') is not None:
            self.ad_domain = m.get('AdDomain')
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class AttachEndUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachEndUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachEndUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachEndUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindConfigGroupRequestResourceInfos(TeaModel):
    def __init__(
        self,
        product_type: str = None,
        resource_id: str = None,
        resource_region_id: str = None,
        resource_type: str = None,
    ):
        # The service type of the resource.
        # 
        # Valid value:
        # 
        # *   CLOUD_DESKTOP: the cloud computer service.
        self.product_type = product_type
        # The ID of the resource.
        self.resource_id = resource_id
        # The region ID of the resource.
        self.resource_region_id = resource_region_id
        # The type of the resource.
        # 
        # Valid values:
        # 
        # *   RESOURCE_GROUP: the resource group
        # *   CLOUD_DESKTOP: the cloud computer service.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_region_id is not None:
            result['ResourceRegionId'] = self.resource_region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceRegionId') is not None:
            self.resource_region_id = m.get('ResourceRegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class BindConfigGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        region_id: str = None,
        resource_infos: List[BindConfigGroupRequestResourceInfos] = None,
    ):
        # The ID of the configuration group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The ID of the region. Set the value to `cn-shanghai`.
        self.region_id = region_id
        # The resources to which you want to bind the configuration group.
        # 
        # This parameter is required.
        self.resource_infos = resource_infos

    def validate(self):
        if self.resource_infos:
            for k in self.resource_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['ResourceInfos'] = []
        if self.resource_infos is not None:
            for k in self.resource_infos:
                result['ResourceInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.resource_infos = []
        if m.get('ResourceInfos') is not None:
            for k in m.get('ResourceInfos'):
                temp_model = BindConfigGroupRequestResourceInfos()
                self.resource_infos.append(temp_model.from_map(k))
        return self


class BindConfigGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        request_id: str = None,
    ):
        # The ID of the configuration group.
        self.group_id = group_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindConfigGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BindConfigGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindConfigGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        desktop_id: List[str] = None,
        policy_id: str = None,
        region_id: str = None,
    ):
        # The IDs of the cloud computers. You can specify 1 to 50 IDs. The IDs cannot be an empty string. The IDs can be up to 64 characters in length and cannot contain `http://` or `https://`. The IDs cannot start with `acs:` or `aliyun`.
        # 
        # This parameter is required.
        self.desktop_id = desktop_id
        # The ID of the automatic snapshot policy.
        self.policy_id = policy_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CancelAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelCdsFileShareLinkRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        share_id: str = None,
    ):
        # The ID of the cloud disk.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The ID of the file sharing task.
        # 
        # This parameter is required.
        self.share_id = share_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.share_id is not None:
            result['ShareId'] = self.share_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('ShareId') is not None:
            self.share_id = m.get('ShareId')
        return self


class CancelCdsFileShareLinkResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The operation result. The value success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # The data information.
        self.data = data
        # The error message that is returned if the request failed. This parameter is not returned if the value of Code is `success`.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the call was successful.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelCdsFileShareLinkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelCdsFileShareLinkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelCdsFileShareLinkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelCoordinationForMonitoringRequest(TeaModel):
    def __init__(
        self,
        co_ids: List[str] = None,
        end_user_id: str = None,
        region_id: str = None,
        user_type: str = None,
    ):
        # The IDs of stream collaboration tasks.
        # 
        # This parameter is required.
        self.co_ids = co_ids
        # The ID of the end user that initiates stream collaboration. If the initiator is the administrator, skip this parameter.
        self.end_user_id = end_user_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/436773.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The type of the user.
        # 
        # Valid value:
        # 
        # * TENANT_ADMIN: administrator.
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.co_ids is not None:
            result['CoIds'] = self.co_ids
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoIds') is not None:
            self.co_ids = m.get('CoIds')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class CancelCoordinationForMonitoringResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelCoordinationForMonitoringResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelCoordinationForMonitoringResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelCoordinationForMonitoringResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelCopyImageRequest(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        region_id: str = None,
    ):
        # The ID of the new image in the destination region.
        # 
        # This parameter is required.
        self.image_id = image_id
        # The ID of the region to which the image is copied.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CancelCopyImageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelCopyImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelCopyImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelCopyImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClonePolicyGroupRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        policy_group_id: str = None,
        region_id: str = None,
    ):
        # The name of the cloud computer policy that you want to create.
        # 
        # This parameter is required.
        self.name = name
        # The ID of the destination cloud computer policy that you want to clone.
        # 
        # This parameter is required.
        self.policy_group_id = policy_group_id
        # The region ID. You can call the [DescribeRegions](~~DescribeRegions~~) operation to query the regions supported by Elastic Desktop Service (EDS).
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ClonePolicyGroupResponseBody(TeaModel):
    def __init__(
        self,
        policy_group_id: str = None,
        request_id: str = None,
    ):
        # The ID of the new cloud computer policy.
        self.policy_group_id = policy_group_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ClonePolicyGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ClonePolicyGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ClonePolicyGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CompleteCdsFileRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: str = None,
        file_id: str = None,
        group_id: str = None,
        region_id: str = None,
        upload_id: str = None,
    ):
        # The ID of the cloud disk.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The name of the end user.
        self.end_user_id = end_user_id
        # The file ID. An ID is the unique identifier of a file.
        # 
        # This parameter is required.
        self.file_id = file_id
        self.group_id = group_id
        # The region ID. You can call the DescribeRegions operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the file uploading task.
        # 
        # This parameter is required.
        self.upload_id = upload_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.upload_id is not None:
            result['UploadId'] = self.upload_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UploadId') is not None:
            self.upload_id = m.get('UploadId')
        return self


class CompleteCdsFileResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CompleteCdsFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CompleteCdsFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CompleteCdsFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfigADConnectorTrustRequest(TeaModel):
    def __init__(
        self,
        office_site_id: str = None,
        rds_license_domain: bool = None,
        region_id: str = None,
        trust_key: str = None,
    ):
        # The ID of the enterprise AD office network.
        # 
        # This parameter is required.
        self.office_site_id = office_site_id
        # Specifies whether to configure a trust password for the Remote Desktop Services (RDS) License Domain of the enterprise AD office network.
        # 
        # Valid values:
        # 
        # *   true: configures a trust password for the RDS License Domain of the AD office network.
        # 
        # *   false: configures a trust password for a regular enterprise AD office network.
        self.rds_license_domain = rds_license_domain
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The trust password. You can specify the password when you configure a trust relationship between the AD domain and the ecd.acs domain.
        # 
        # This parameter is required.
        self.trust_key = trust_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.rds_license_domain is not None:
            result['RdsLicenseDomain'] = self.rds_license_domain
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.trust_key is not None:
            result['TrustKey'] = self.trust_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RdsLicenseDomain') is not None:
            self.rds_license_domain = m.get('RdsLicenseDomain')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TrustKey') is not None:
            self.trust_key = m.get('TrustKey')
        return self


class ConfigADConnectorTrustResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConfigADConnectorTrustResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ConfigADConnectorTrustResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfigADConnectorTrustResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfigADConnectorUserRequest(TeaModel):
    def __init__(
        self,
        domain_password: str = None,
        domain_user_name: str = None,
        ouname: str = None,
        office_site_id: str = None,
        region_id: str = None,
    ):
        # The password of the AD user that has the permissions to join computers to domains.
        # 
        # This parameter is required.
        self.domain_password = domain_password
        # The username of the AD user that has the permissions to join computers to domains.
        # 
        # After the username is configured, the cloud desktops in the same AD workspace are joined to the specified OU.
        # 
        # This parameter is required.
        self.domain_user_name = domain_user_name
        # The name of the OU in the AD domain. You can call the [ListUserAdOrganizationUnits](https://help.aliyun.com/document_detail/311259.html) to obtain the OU name.
        self.ouname = ouname
        # The ID of the AD workspace.
        # 
        # This parameter is required.
        self.office_site_id = office_site_id
        # The ID of the region.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_password is not None:
            result['DomainPassword'] = self.domain_password
        if self.domain_user_name is not None:
            result['DomainUserName'] = self.domain_user_name
        if self.ouname is not None:
            result['OUName'] = self.ouname
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainPassword') is not None:
            self.domain_password = m.get('DomainPassword')
        if m.get('DomainUserName') is not None:
            self.domain_user_name = m.get('DomainUserName')
        if m.get('OUName') is not None:
            self.ouname = m.get('OUName')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ConfigADConnectorUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConfigADConnectorUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ConfigADConnectorUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfigADConnectorUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyCdsFileRequest(TeaModel):
    def __init__(
        self,
        auto_rename: bool = None,
        cds_id: str = None,
        end_user_id: str = None,
        file_id: str = None,
        file_receiver_id: str = None,
        file_receiver_type: str = None,
        group_id: str = None,
        parent_folder_id: str = None,
        region_id: str = None,
    ):
        # Specifies whether to automatically rename the file if a file that has the same name exists in the folder to which you want to copy the file. Default value: false.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.auto_rename = auto_rename
        # The ID of the cloud disk.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The user ID that you want to use to access the cloud disk.
        self.end_user_id = end_user_id
        # The file ID. You can call the CreateCdsFile operation to query the file ID.
        # 
        # This parameter is required.
        self.file_id = file_id
        # 目标复制文件所在的个人空间ID（即UserId，您可以在DescribeCloudDriveUsers接口返回的报文中获取。）或者目标复制文件所在的团队空间ID（即GroupId，您可以在DescribeCloudDriveGroups接口返回的报文中获取。）
        # > FileReceiverId和FileReceiverType都为空时，默认复制到文件所在的个人空间。
        # >
        self.file_receiver_id = file_receiver_id
        # 文件所属的空间类型。
        self.file_receiver_type = file_receiver_type
        self.group_id = group_id
        # The ID of the parent folder of the folder to which you want to copy the file. If you want to copy the file to the root directory, set this parameter to root.
        # 
        # This parameter is required.
        self.parent_folder_id = parent_folder_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_rename is not None:
            result['AutoRename'] = self.auto_rename
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.file_receiver_id is not None:
            result['FileReceiverId'] = self.file_receiver_id
        if self.file_receiver_type is not None:
            result['FileReceiverType'] = self.file_receiver_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.parent_folder_id is not None:
            result['ParentFolderId'] = self.parent_folder_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoRename') is not None:
            self.auto_rename = m.get('AutoRename')
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FileReceiverId') is not None:
            self.file_receiver_id = m.get('FileReceiverId')
        if m.get('FileReceiverType') is not None:
            self.file_receiver_type = m.get('FileReceiverType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ParentFolderId') is not None:
            self.parent_folder_id = m.get('ParentFolderId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CopyCdsFileResponseBodyCopyCdsFileModel(TeaModel):
    def __init__(
        self,
        async_task_id: str = None,
        file_id: str = None,
    ):
        # The ID of the asynchronous task. This parameter is not returned if you copy a file. This parameter is returned if you copy a folder in the backend in an asynchronous manner. You can call the GetAsyncTask operation to obtain the ID and details of an asynchronous task.
        self.async_task_id = async_task_id
        # The ID of the copied file or folder.
        self.file_id = file_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_task_id is not None:
            result['AsyncTaskId'] = self.async_task_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsyncTaskId') is not None:
            self.async_task_id = m.get('AsyncTaskId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class CopyCdsFileResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        copy_cds_file_model: CopyCdsFileResponseBodyCopyCdsFileModel = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The operation result. The value success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # The details about the file copying.
        self.copy_cds_file_model = copy_cds_file_model
        # The error message that is returned. This parameter is not returned if the value of Code is success.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.success = success

    def validate(self):
        if self.copy_cds_file_model:
            self.copy_cds_file_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.copy_cds_file_model is not None:
            result['CopyCdsFileModel'] = self.copy_cds_file_model.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CopyCdsFileModel') is not None:
            temp_model = CopyCdsFileResponseBodyCopyCdsFileModel()
            self.copy_cds_file_model = temp_model.from_map(m['CopyCdsFileModel'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CopyCdsFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopyCdsFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyCdsFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyImageRequest(TeaModel):
    def __init__(
        self,
        destination_description: str = None,
        destination_image_name: str = None,
        destination_region_id: str = None,
        image_id: str = None,
        region_id: str = None,
    ):
        # The description of the new image in the destination region. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        self.destination_description = destination_description
        # The name of the new image. The name must be 2 to 128 characters in length. The name must start with a letter but cannot start with `http://` or `https://`. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        # 
        # This parameter is required.
        self.destination_image_name = destination_image_name
        # The ID of the destination region. The ID must be different from the current region ID of the image. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.destination_region_id = destination_region_id
        # The ID of the image that is copied to the destination region.
        # 
        # This parameter is required.
        self.image_id = image_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_description is not None:
            result['DestinationDescription'] = self.destination_description
        if self.destination_image_name is not None:
            result['DestinationImageName'] = self.destination_image_name
        if self.destination_region_id is not None:
            result['DestinationRegionId'] = self.destination_region_id
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationDescription') is not None:
            self.destination_description = m.get('DestinationDescription')
        if m.get('DestinationImageName') is not None:
            self.destination_image_name = m.get('DestinationImageName')
        if m.get('DestinationRegionId') is not None:
            self.destination_region_id = m.get('DestinationRegionId')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CopyImageResponseBody(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        request_id: str = None,
    ):
        # The ID of the image that is being copied.
        self.image_id = image_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopyImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateADConnectorDirectoryRequest(TeaModel):
    def __init__(
        self,
        desktop_access_type: str = None,
        directory_name: str = None,
        dns_address: List[str] = None,
        domain_name: str = None,
        domain_password: str = None,
        domain_user_name: str = None,
        enable_admin_access: bool = None,
        mfa_enabled: bool = None,
        region_id: str = None,
        specification: int = None,
        sub_domain_dns_address: List[str] = None,
        sub_domain_name: str = None,
        v_switch_id: List[str] = None,
    ):
        # The method in which the cloud computer is connected.
        # 
        # Valid values:
        # 
        # *   VPC
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Internet (default)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Any
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.desktop_access_type = desktop_access_type
        # The directory name. The name must be 2 to 255 characters in length. The name must start with a letter but cannot start with `http://` or `https://`. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        # 
        # This parameter is required.
        self.directory_name = directory_name
        # The IP address of the DNS server corresponding to the enterprise AD. You can specify only one IP address. Make sure that the specified IP address is accessible in the network of the selected vSwitch.
        # 
        # This parameter is required.
        self.dns_address = dns_address
        # The fully qualified domain name (FQDN) of the enterprise AD system. The value must contain the hostname and the domain name. You can register each FQDN only once.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The password of the domain administrator. The password can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.domain_password = domain_password
        # The username of the domain administrator. The username can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.domain_user_name = domain_user_name
        # Specifies whether to grant the local administrator permissions to users that are authorized to use cloud computers in the office network.
        # 
        # Valid values:
        # 
        # *   <!-- -->
        # 
        #     true
        # 
        #     <!-- -->
        # 
        #     (default)
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.enable_admin_access = enable_admin_access
        # Specifies whether to enable Multi-Factor Authentication (MFA). After you enable MFA, all AD users in the directory must enter a dynamic verification code generated by the virtual MFA device in addition to a correct password when they log on to a cloud computer.
        # 
        # >  When end users log on to a cloud computer for the first time, they must bind an MFA device.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     false (default)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.mfa_enabled = mfa_enabled
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The type of the AD connector.
        # 
        # Valid values:
        # - 1 (General)
        # - 2 (Advanced)
        self.specification = specification
        # The DNS address of the existing AD subdomain.\\
        # If you specify the `SubDomainName` parameter but you do not specify this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
        self.sub_domain_dns_address = sub_domain_dns_address
        # The FQDN of the enterprise AD subdomain. The value must contain the hostname and the subdomain name.
        self.sub_domain_name = sub_domain_name
        # Details of the vSwitch IDs. You can specify only one vSwitch ID.
        # 
        # This parameter is required.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_access_type is not None:
            result['DesktopAccessType'] = self.desktop_access_type
        if self.directory_name is not None:
            result['DirectoryName'] = self.directory_name
        if self.dns_address is not None:
            result['DnsAddress'] = self.dns_address
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_password is not None:
            result['DomainPassword'] = self.domain_password
        if self.domain_user_name is not None:
            result['DomainUserName'] = self.domain_user_name
        if self.enable_admin_access is not None:
            result['EnableAdminAccess'] = self.enable_admin_access
        if self.mfa_enabled is not None:
            result['MfaEnabled'] = self.mfa_enabled
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.sub_domain_dns_address is not None:
            result['SubDomainDnsAddress'] = self.sub_domain_dns_address
        if self.sub_domain_name is not None:
            result['SubDomainName'] = self.sub_domain_name
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopAccessType') is not None:
            self.desktop_access_type = m.get('DesktopAccessType')
        if m.get('DirectoryName') is not None:
            self.directory_name = m.get('DirectoryName')
        if m.get('DnsAddress') is not None:
            self.dns_address = m.get('DnsAddress')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainPassword') is not None:
            self.domain_password = m.get('DomainPassword')
        if m.get('DomainUserName') is not None:
            self.domain_user_name = m.get('DomainUserName')
        if m.get('EnableAdminAccess') is not None:
            self.enable_admin_access = m.get('EnableAdminAccess')
        if m.get('MfaEnabled') is not None:
            self.mfa_enabled = m.get('MfaEnabled')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('SubDomainDnsAddress') is not None:
            self.sub_domain_dns_address = m.get('SubDomainDnsAddress')
        if m.get('SubDomainName') is not None:
            self.sub_domain_name = m.get('SubDomainName')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateADConnectorDirectoryResponseBodyAdConnectors(TeaModel):
    def __init__(
        self,
        address: str = None,
    ):
        # The connection address.
        self.address = address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        return self


class CreateADConnectorDirectoryResponseBody(TeaModel):
    def __init__(
        self,
        ad_connectors: List[CreateADConnectorDirectoryResponseBodyAdConnectors] = None,
        directory_id: str = None,
        request_id: str = None,
        trust_password: str = None,
    ):
        # The details of AD connectors.
        self.ad_connectors = ad_connectors
        # The ID of the AD directory.
        self.directory_id = directory_id
        # The ID of the request.
        self.request_id = request_id
        # The AD trust password.
        self.trust_password = trust_password

    def validate(self):
        if self.ad_connectors:
            for k in self.ad_connectors:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdConnectors'] = []
        if self.ad_connectors is not None:
            for k in self.ad_connectors:
                result['AdConnectors'].append(k.to_map() if k else None)
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.trust_password is not None:
            result['TrustPassword'] = self.trust_password
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ad_connectors = []
        if m.get('AdConnectors') is not None:
            for k in m.get('AdConnectors'):
                temp_model = CreateADConnectorDirectoryResponseBodyAdConnectors()
                self.ad_connectors.append(temp_model.from_map(k))
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TrustPassword') is not None:
            self.trust_password = m.get('TrustPassword')
        return self


class CreateADConnectorDirectoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateADConnectorDirectoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateADConnectorDirectoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateADConnectorOfficeSiteRequest(TeaModel):
    def __init__(
        self,
        ad_hostname: str = None,
        backup_dchostname: str = None,
        backup_dns: str = None,
        bandwidth: int = None,
        cen_id: str = None,
        cen_owner_id: int = None,
        cidr_block: str = None,
        desktop_access_type: str = None,
        dns_address: List[str] = None,
        domain_name: str = None,
        domain_password: str = None,
        domain_user_name: str = None,
        enable_admin_access: bool = None,
        enable_internet_access: bool = None,
        mfa_enabled: bool = None,
        office_site_name: str = None,
        protocol_type: str = None,
        region_id: str = None,
        specification: int = None,
        sub_domain_dns_address: List[str] = None,
        sub_domain_name: str = None,
        v_switch_id: List[str] = None,
        verify_code: str = None,
    ):
        # The hostname of the domain controller. The hostname must comply with the naming conventions for Windows hosts.
        self.ad_hostname = ad_hostname
        # The hostname of the backup domain controller.
        self.backup_dchostname = backup_dchostname
        # The DNS address of the backup domain controller.
        self.backup_dns = backup_dns
        # The maximum public bandwidth of the Internet access package. Valid values: 0 to 200.\\
        # If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
        self.bandwidth = bandwidth
        # The ID of the CEN instance.
        self.cen_id = cen_id
        # The Alibaba Cloud account that creates the Cloud Enterprise Network (CEN) instance.
        # 
        # *   If you do not specify the CenId parameter, or the CEN instance that is specified by the CenId parameter belongs to the current Alibaba Cloud account, skip this parameter.
        # *   If you specify the CenId parameter and the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, enter the ID of the Alibaba Cloud account.
        self.cen_owner_id = cen_owner_id
        # The IPv4 CIDR block of the virtual private cloud (VPC) that your office network uses. The system creates a VPC for your office network based on the IPv4 CIDR block. We recommend that you set this parameter to one of the following CIDR blocks and their subnets:
        # 
        # *   `10.0.0.0/12` (subnet mask range: 12 to 24 bits)
        # *   `172.16.0.0/12` (subnet mask range: 12 to 24 bits)
        # *   `192.168.0.0/16` (subnet mask range: 16 to 24 bits)
        self.cidr_block = cidr_block
        # The method to connect to cloud computers from Alibaba Cloud Workspace clients.
        # 
        # >  The VPC connection depends on Alibaba Cloud PrivateLink. You can use PrivateLink for free. When you set this parameter to `VPC` or `Any`, PrivateLink is automatically activated.
        # 
        # Valid values:
        # 
        # - Internet: connects clients to cloud desktops only over the Internet. [Default]
        # - VPC: connects clients to cloud desktops only over a VPC.
        # - Any: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method based on your business requirements when you connect to your cloud desktop from a client.
        self.desktop_access_type = desktop_access_type
        # The IP address of the DNS server of the enterprise AD system. You can specify only one IP address.
        # 
        # This parameter is required.
        self.dns_address = dns_address
        # The domain name of the enterprise AD system. You can register each domain name only once.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The password of the domain administrator. The password can be up to 64 characters in length.
        self.domain_password = domain_password
        # The username of the domain administrator. The username can be up to 64 characters in length.
        # 
        # > Specify the username by using sAMAccountName instead of userPrincipalName.
        self.domain_user_name = domain_user_name
        # Specifies whether to grant the local administrator permissions to users that are authorized to use cloud computers in the office network.
        # 
        # Valid values:
        # 
        # *   <!-- -->
        # 
        #     true
        # 
        #     <!-- -->
        # 
        #     (default)
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.enable_admin_access = enable_admin_access
        # Specifies whether to enable Internet access.
        self.enable_internet_access = enable_internet_access
        # Specifies whether to enable multi-factor authentication (MFA).
        self.mfa_enabled = mfa_enabled
        # The office network name. The name must be 2 to 255 characters in length. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-). It must start with a letter and cannot start with `http://` or `https://`.\\
        # This parameter is empty by default.
        self.office_site_name = office_site_name
        # The protocol type.
        # 
        # Valid value:
        # 
        # *   Adaptive Streaming Protocol (ASP)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.protocol_type = protocol_type
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The AD connector type.
        # 
        # Valid values:
        # 
        # *   1: General
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   2: Advanced
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.specification = specification
        # The DNS address of the enterprise AD subdomain. If you specify `SubDomainName` but do not specify this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
        self.sub_domain_dns_address = sub_domain_dns_address
        # The domain name of the enterprise AD subdomain.
        self.sub_domain_name = sub_domain_name
        # The array of the vSwitch IDs.
        self.v_switch_id = v_switch_id
        # The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the [SendVerifyCode](https://help.aliyun.com/document_detail/436847.html) operation to obtain the verification code.
        self.verify_code = verify_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_hostname is not None:
            result['AdHostname'] = self.ad_hostname
        if self.backup_dchostname is not None:
            result['BackupDCHostname'] = self.backup_dchostname
        if self.backup_dns is not None:
            result['BackupDns'] = self.backup_dns
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.desktop_access_type is not None:
            result['DesktopAccessType'] = self.desktop_access_type
        if self.dns_address is not None:
            result['DnsAddress'] = self.dns_address
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_password is not None:
            result['DomainPassword'] = self.domain_password
        if self.domain_user_name is not None:
            result['DomainUserName'] = self.domain_user_name
        if self.enable_admin_access is not None:
            result['EnableAdminAccess'] = self.enable_admin_access
        if self.enable_internet_access is not None:
            result['EnableInternetAccess'] = self.enable_internet_access
        if self.mfa_enabled is not None:
            result['MfaEnabled'] = self.mfa_enabled
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.sub_domain_dns_address is not None:
            result['SubDomainDnsAddress'] = self.sub_domain_dns_address
        if self.sub_domain_name is not None:
            result['SubDomainName'] = self.sub_domain_name
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.verify_code is not None:
            result['VerifyCode'] = self.verify_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdHostname') is not None:
            self.ad_hostname = m.get('AdHostname')
        if m.get('BackupDCHostname') is not None:
            self.backup_dchostname = m.get('BackupDCHostname')
        if m.get('BackupDns') is not None:
            self.backup_dns = m.get('BackupDns')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('DesktopAccessType') is not None:
            self.desktop_access_type = m.get('DesktopAccessType')
        if m.get('DnsAddress') is not None:
            self.dns_address = m.get('DnsAddress')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainPassword') is not None:
            self.domain_password = m.get('DomainPassword')
        if m.get('DomainUserName') is not None:
            self.domain_user_name = m.get('DomainUserName')
        if m.get('EnableAdminAccess') is not None:
            self.enable_admin_access = m.get('EnableAdminAccess')
        if m.get('EnableInternetAccess') is not None:
            self.enable_internet_access = m.get('EnableInternetAccess')
        if m.get('MfaEnabled') is not None:
            self.mfa_enabled = m.get('MfaEnabled')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('SubDomainDnsAddress') is not None:
            self.sub_domain_dns_address = m.get('SubDomainDnsAddress')
        if m.get('SubDomainName') is not None:
            self.sub_domain_name = m.get('SubDomainName')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VerifyCode') is not None:
            self.verify_code = m.get('VerifyCode')
        return self


class CreateADConnectorOfficeSiteResponseBody(TeaModel):
    def __init__(
        self,
        office_site_id: str = None,
        request_id: str = None,
    ):
        # The office network ID.
        self.office_site_id = office_site_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateADConnectorOfficeSiteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateADConnectorOfficeSiteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateADConnectorOfficeSiteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAndBindNasFileSystemRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        desktop_group_id: str = None,
        encrypt_type: int = None,
        end_user_ids: List[str] = None,
        file_system_name: str = None,
        office_site_id: str = None,
        region_id: str = None,
        storage_type: str = None,
    ):
        # The description of the NAS file system.
        self.description = description
        # The ID of the desktop group.
        # 
        # This parameter is required.
        self.desktop_group_id = desktop_group_id
        # Specifies whether to encrypt data in the NAS file system. You can use keys that are hosted by Key Management Service (KMS) to encrypt data in a file system. When you read and write the encrypted data, the data is automatically decrypted. Valid values:
        # 
        # *   0: does not encrypt data in the NAS file system.
        # *   1: encrypts data in the NAS file system by using a NAS-managed key. ` If you set  `FileSystemType`  to  `standard`  or  `extreme`, you can use a NAS-managed key to encrypt data in a NAS file system.`
        # *   2: encrypts data in the NAS file system by using a KMS-managed key. `If` you set FileSystemType`  to  `extreme`, you can use a KMS-managed key to encrypt data in a NAS file system.`
        # 
        # Default value: 0.
        self.encrypt_type = encrypt_type
        # The list of users.
        self.end_user_ids = end_user_ids
        # The name of the NAS file system.
        # 
        # This parameter is required.
        self.file_system_name = file_system_name
        # The ID of the workspace.
        # 
        # This parameter is required.
        self.office_site_id = office_site_id
        # The region ID.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The storage type of the NAS file system. Valid values:
        # 
        # *   Capacity
        # *   Performance
        # 
        # Default value: Capacity.
        # 
        # This parameter is required.
        self.storage_type = storage_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.encrypt_type is not None:
            result['EncryptType'] = self.encrypt_type
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.file_system_name is not None:
            result['FileSystemName'] = self.file_system_name
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('EncryptType') is not None:
            self.encrypt_type = m.get('EncryptType')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('FileSystemName') is not None:
            self.file_system_name = m.get('FileSystemName')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class CreateAndBindNasFileSystemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAndBindNasFileSystemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAndBindNasFileSystemResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAndBindNasFileSystemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        cron_expression: str = None,
        policy_name: str = None,
        region_id: str = None,
        retention_days: int = None,
    ):
        # The CRON expression for periodic scheduling.
        # 
        # This parameter is required.
        self.cron_expression = cron_expression
        # The name of the automatic snapshot policy. The name must be 2 to 128 characters in length. The name must start with a letter but cannot start with `http://` or `https://`. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-). This parameter is empty by default.
        # 
        # This parameter is required.
        self.policy_name = policy_name
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The retention period of the automatic snapshots. Unit: days. Valid values: 1 to 180.
        # 
        # This parameter is required.
        self.retention_days = retention_days

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RetentionDays') is not None:
            self.retention_days = m.get('RetentionDays')
        return self


class CreateAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        policy_id: str = None,
        request_id: str = None,
    ):
        # The ID of the automatic snapshot policy.
        self.policy_id = policy_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBandwidthResourcePackagesRequest(TeaModel):
    def __init__(
        self,
        amount: int = None,
        auto_pay: bool = None,
        package_size: int = None,
        period: int = None,
        period_unit: str = None,
        promotion_id: str = None,
        region_id: str = None,
    ):
        # The number of the data transfer plans that you want to create at the same time. Valid values: 1 to 20. Default value: 1.
        self.amount = amount
        # Specifies whether to enable the auto-payment feature.
        self.auto_pay = auto_pay
        # The size of the data transfer plan. Valid values: 10 to 1000. Unit: GiB.
        # 
        # This parameter is required.
        self.package_size = package_size
        # The subscription duration. The valid values of this parameter vary based on the value of `PeriodUnit`.
        # 
        # *   If `PeriodUnit` is set to `Month`, the valid values of Period are 1, 3, and 6.
        # *   If `PeriodUnit` is set to `Year`, the valid value of Period is 1.
        # 
        # Default value: 1.
        self.period = period
        # The unit of the subscription duration.
        # 
        # Valid values:
        # 
        # *   Month (default)
        # *   Year
        self.period_unit = period_unit
        # The ID of the promotional activity.
        self.promotion_id = promotion_id
        # The ID of the region. You can call the [DescribeRegions](~~DescribeRegions~~) operation to query the list of regions where Elastic Desktop Service (EDS) Enterprise is available.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.package_size is not None:
            result['PackageSize'] = self.package_size
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('PackageSize') is not None:
            self.package_size = m.get('PackageSize')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateBandwidthResourcePackagesResponseBody(TeaModel):
    def __init__(
        self,
        order_id: int = None,
        request_id: str = None,
    ):
        # The ID of the order.
        self.order_id = order_id
        # The ID of a request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBandwidthResourcePackagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBandwidthResourcePackagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBandwidthResourcePackagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBundleRequest(TeaModel):
    def __init__(
        self,
        bundle_name: str = None,
        description: str = None,
        desktop_type: str = None,
        image_id: str = None,
        language: str = None,
        region_id: str = None,
        root_disk_performance_level: str = None,
        root_disk_size_gib: int = None,
        user_disk_performance_level: str = None,
        user_disk_size_gib: List[int] = None,
    ):
        # The name of the cloud computer template.
        self.bundle_name = bundle_name
        # The description of the cloud computer template.
        self.description = description
        # The instance type of the cloud computers. You can call the [DescribeBundles](https://help.aliyun.com/document_detail/436974.html) operation to query cloud computer templates and obtain the instance types supported by the cloud computers from the `DesktopType` response parameter.
        # 
        # >  If you want the template to use a non-GPU-accelerated image, you can only select a non-GPU-accelerated instance type. If you want the template to use a GPU-accelerated image, you can only select a GPU-accelerated instance type.
        # 
        # This parameter is required.
        self.desktop_type = desktop_type
        # The ID of the image.
        # 
        # This parameter is required.
        self.image_id = image_id
        # The OS language. This parameter is available only for system images. Valid values:
        # 
        # *   zh-CN: Simplified Chinese
        # *   zh-HK: Traditional Chinese (Hong Kong)
        # *   en-US: American English
        # *   ja-JP: Japanese
        self.language = language
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The performance level (PL) of the system disk. When the cloud computer instance type that is specified by the DesktopType parameter is set to a graphical instance type or instance type with a high clock speed, you can set the performance level of the disks. For more information about the differences among disks at different PLs, see [Enhanced SSDs](https://help.aliyun.com/document_detail/122389.html).
        # 
        # Valid values:
        # 
        # *   PL1
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PL0
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PL3
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PL2
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.root_disk_performance_level = root_disk_performance_level
        # The size of the system disk. Unit: GiB. The value of this parameter must be consistent with the system disk size supported by the cloud computer instance type. For more information, see [Overview](https://help.aliyun.com/document_detail/188609.html).
        # 
        # This parameter is required.
        self.root_disk_size_gib = root_disk_size_gib
        # The PL of the data disk. When the cloud computer instance type that is specified by the DesktopType parameter is set to a graphical instance type or instance type with a high clock speed, you can set the performance level of the disks. For more information about the differences among disks at different PLs, see [Enhanced SSDs](https://help.aliyun.com/document_detail/122389.html).
        # 
        # Valid values:
        # 
        # *   PL1
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PL0
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PL3
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PL2
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.user_disk_performance_level = user_disk_performance_level
        # The data disk sizes. You can configure only one data disk.
        # 
        # This parameter is required.
        self.user_disk_size_gib = user_disk_size_gib

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_name is not None:
            result['BundleName'] = self.bundle_name
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.language is not None:
            result['Language'] = self.language
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.root_disk_performance_level is not None:
            result['RootDiskPerformanceLevel'] = self.root_disk_performance_level
        if self.root_disk_size_gib is not None:
            result['RootDiskSizeGib'] = self.root_disk_size_gib
        if self.user_disk_performance_level is not None:
            result['UserDiskPerformanceLevel'] = self.user_disk_performance_level
        if self.user_disk_size_gib is not None:
            result['UserDiskSizeGib'] = self.user_disk_size_gib
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleName') is not None:
            self.bundle_name = m.get('BundleName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RootDiskPerformanceLevel') is not None:
            self.root_disk_performance_level = m.get('RootDiskPerformanceLevel')
        if m.get('RootDiskSizeGib') is not None:
            self.root_disk_size_gib = m.get('RootDiskSizeGib')
        if m.get('UserDiskPerformanceLevel') is not None:
            self.user_disk_performance_level = m.get('UserDiskPerformanceLevel')
        if m.get('UserDiskSizeGib') is not None:
            self.user_disk_size_gib = m.get('UserDiskSizeGib')
        return self


class CreateBundleResponseBody(TeaModel):
    def __init__(
        self,
        bundle_id: str = None,
        request_id: str = None,
    ):
        # The ID of the cloud computer template.
        self.bundle_id = bundle_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBundleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBundleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBundleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCdsFileRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        conflict_policy: str = None,
        end_user_id: str = None,
        file_hash: str = None,
        file_length: int = None,
        file_name: str = None,
        file_type: str = None,
        group_id: str = None,
        parent_file_id: str = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The policy that is used when the file that you want to upload has the same name as an existing file in the cloud disk.
        # 
        # Valid values:
        # 
        # *   refuse
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     denies creating the file
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   auto_rename
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     automatically renames the file
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   ignore
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     allows the file to use the same name as the existing file in the cloud disk
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   over_write
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     overwrites the existing file in the cloud disk
        # 
        #     <!-- -->
        # 
        #     .
        self.conflict_policy = conflict_policy
        # The user ID.
        self.end_user_id = end_user_id
        # The hash value of the SHA1 algorithm that is used by the file.
        self.file_hash = file_hash
        # The file size. Unit: bytes.
        # 
        # This parameter is required.
        self.file_length = file_length
        # The file name.
        # 
        # This parameter is required.
        self.file_name = file_name
        # The file type.
        # 
        # Valid values:
        # 
        # *   file
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   folder
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # This parameter is required.
        self.file_type = file_type
        self.group_id = group_id
        # The ID of the parent folder.
        # 
        # This parameter is required.
        self.parent_file_id = parent_file_id
        # The region ID.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.conflict_policy is not None:
            result['ConflictPolicy'] = self.conflict_policy
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_hash is not None:
            result['FileHash'] = self.file_hash
        if self.file_length is not None:
            result['FileLength'] = self.file_length
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.parent_file_id is not None:
            result['ParentFileId'] = self.parent_file_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('ConflictPolicy') is not None:
            self.conflict_policy = m.get('ConflictPolicy')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileHash') is not None:
            self.file_hash = m.get('FileHash')
        if m.get('FileLength') is not None:
            self.file_length = m.get('FileLength')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ParentFileId') is not None:
            self.parent_file_id = m.get('ParentFileId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateCdsFileResponseBodyFileModel(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        upload_id: str = None,
        upload_url: str = None,
    ):
        self.file_id = file_id
        self.upload_id = upload_id
        self.upload_url = upload_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.upload_id is not None:
            result['UploadId'] = self.upload_id
        if self.upload_url is not None:
            result['UploadUrl'] = self.upload_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('UploadId') is not None:
            self.upload_id = m.get('UploadId')
        if m.get('UploadUrl') is not None:
            self.upload_url = m.get('UploadUrl')
        return self


class CreateCdsFileResponseBody(TeaModel):
    def __init__(
        self,
        file_model: CreateCdsFileResponseBodyFileModel = None,
        request_id: str = None,
    ):
        self.file_model = file_model
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.file_model:
            self.file_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_model is not None:
            result['FileModel'] = self.file_model.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileModel') is not None:
            temp_model = CreateCdsFileResponseBodyFileModel()
            self.file_model = temp_model.from_map(m['FileModel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCdsFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCdsFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCdsFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCdsFileShareLinkRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        description: str = None,
        disable_download: bool = None,
        disable_preview: bool = None,
        disable_save: bool = None,
        download_limit: int = None,
        end_user_id: str = None,
        expiration: str = None,
        file_ids: List[str] = None,
        group_id: str = None,
        preview_limit: int = None,
        save_limit: int = None,
        share_name: str = None,
        share_pwd: str = None,
    ):
        # The ID of the cloud disk.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The description of the file sharing task. The description must be 0 to 1,024 characters in length.
        self.description = description
        # Specifies whether to prohibit the download of the files that are being shared.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     prohibits file download
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     allows file download
        # 
        #     <!-- -->
        # 
        #     .
        self.disable_download = disable_download
        # Specifies whether to prohibit the preview of the files that are being shared.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     prohibits file preview
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     allows file preview
        # 
        #     <!-- -->
        # 
        #     .
        self.disable_preview = disable_preview
        # Specifies whether to prohibit the dump of the files that are being shared.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     prohibits file dump
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     allows file dump
        # 
        #     <!-- -->
        # 
        #     .
        self.disable_save = disable_save
        # The limit on the number of times that the shared files can be downloaded. The value of this parameter must be equal to or greater than 0. The value 0 specifies that no limit is imposed on the number of times that the shared files can be downloaded.
        self.download_limit = download_limit
        # The ID of the end user.
        self.end_user_id = end_user_id
        # The time when the file sharing link expires. The value of this parameter follows the RFC 3339 standard. Example: "2020-06-28T11:33:00.000+08:00". If this parameter is set to "", the file sharing link never expires.
        self.expiration = expiration
        # The file IDs.
        self.file_ids = file_ids
        self.group_id = group_id
        # The limit on the number of times that the shared files can be previewed. The value of this parameter must be equal to or greater than 0. The value 0 specifies that no limit is imposed on the number of times that the shared files can be previewed.
        self.preview_limit = preview_limit
        # The limit on the number of times that the shared files can be dumped. The value of this parameter must be equal to or greater than 0. The value 0 specifies that no limit is imposed on the number of times that the shared files can be dumped.
        self.save_limit = save_limit
        # The name of the file sharing task. If you leave this parameter empty, the file name that corresponds to the first ID in the file ID list is used. The name must be 0 to 128 characters in length.
        self.share_name = share_name
        # The length of the access code. Valid values: 6 to 8. Unit: bytes. If you leave this parameter empty or set it to null, no access code is required. If you use a token to share files, you do not need to configure this parameter. The access code can contain only visible ASCII characters.
        self.share_pwd = share_pwd

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.description is not None:
            result['Description'] = self.description
        if self.disable_download is not None:
            result['DisableDownload'] = self.disable_download
        if self.disable_preview is not None:
            result['DisablePreview'] = self.disable_preview
        if self.disable_save is not None:
            result['DisableSave'] = self.disable_save
        if self.download_limit is not None:
            result['DownloadLimit'] = self.download_limit
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.expiration is not None:
            result['Expiration'] = self.expiration
        if self.file_ids is not None:
            result['FileIds'] = self.file_ids
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.preview_limit is not None:
            result['PreviewLimit'] = self.preview_limit
        if self.save_limit is not None:
            result['SaveLimit'] = self.save_limit
        if self.share_name is not None:
            result['ShareName'] = self.share_name
        if self.share_pwd is not None:
            result['SharePwd'] = self.share_pwd
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisableDownload') is not None:
            self.disable_download = m.get('DisableDownload')
        if m.get('DisablePreview') is not None:
            self.disable_preview = m.get('DisablePreview')
        if m.get('DisableSave') is not None:
            self.disable_save = m.get('DisableSave')
        if m.get('DownloadLimit') is not None:
            self.download_limit = m.get('DownloadLimit')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('Expiration') is not None:
            self.expiration = m.get('Expiration')
        if m.get('FileIds') is not None:
            self.file_ids = m.get('FileIds')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PreviewLimit') is not None:
            self.preview_limit = m.get('PreviewLimit')
        if m.get('SaveLimit') is not None:
            self.save_limit = m.get('SaveLimit')
        if m.get('ShareName') is not None:
            self.share_name = m.get('ShareName')
        if m.get('SharePwd') is not None:
            self.share_pwd = m.get('SharePwd')
        return self


class CreateCdsFileShareLinkResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CdsFileShareLinkModel = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The operation result. The value success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # The data information.
        self.data = data
        # The error message that is returned. This parameter is not returned if the value of Code is success.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CdsFileShareLinkModel()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateCdsFileShareLinkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCdsFileShareLinkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCdsFileShareLinkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCloudDriveServiceRequest(TeaModel):
    def __init__(
        self,
        auto_pay: bool = None,
        auto_renew: bool = None,
        biz_type: int = None,
        cds_charge_type: str = None,
        cen_id: str = None,
        domain_name: str = None,
        end_user_id: List[str] = None,
        max_size: int = None,
        name: str = None,
        office_site_id: str = None,
        office_site_type: str = None,
        period: int = None,
        period_unit: str = None,
        region_id: str = None,
        solution_id: str = None,
        user_count: int = None,
        user_max_size: int = None,
    ):
        self.auto_pay = auto_pay
        self.auto_renew = auto_renew
        # The business type.
        self.biz_type = biz_type
        self.cds_charge_type = cds_charge_type
        self.cen_id = cen_id
        self.domain_name = domain_name
        self.end_user_id = end_user_id
        # This parameter is required.
        self.max_size = max_size
        # The name of the cloud disk that you want to create in Cloud Drive Service.
        self.name = name
        self.office_site_id = office_site_id
        self.office_site_type = office_site_type
        self.period = period
        self.period_unit = period_unit
        # The region ID.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The solution ID.
        self.solution_id = solution_id
        self.user_count = user_count
        self.user_max_size = user_max_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.cds_charge_type is not None:
            result['CdsChargeType'] = self.cds_charge_type
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.max_size is not None:
            result['MaxSize'] = self.max_size
        if self.name is not None:
            result['Name'] = self.name
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_type is not None:
            result['OfficeSiteType'] = self.office_site_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.solution_id is not None:
            result['SolutionId'] = self.solution_id
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        if self.user_max_size is not None:
            result['UserMaxSize'] = self.user_max_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('CdsChargeType') is not None:
            self.cds_charge_type = m.get('CdsChargeType')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('MaxSize') is not None:
            self.max_size = m.get('MaxSize')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteType') is not None:
            self.office_site_type = m.get('OfficeSiteType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SolutionId') is not None:
            self.solution_id = m.get('SolutionId')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        if m.get('UserMaxSize') is not None:
            self.user_max_size = m.get('UserMaxSize')
        return self


class CreateCloudDriveServiceResponseBodyConflictCdsAndOrderConflictCds(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        region_id: str = None,
    ):
        self.cds_id = cds_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateCloudDriveServiceResponseBodyConflictCdsAndOrderConflictOrder(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        order_id: str = None,
        region_id: str = None,
    ):
        self.cds_id = cds_id
        self.order_id = order_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateCloudDriveServiceResponseBodyConflictCdsAndOrder(TeaModel):
    def __init__(
        self,
        conflict_cds: List[CreateCloudDriveServiceResponseBodyConflictCdsAndOrderConflictCds] = None,
        conflict_order: List[CreateCloudDriveServiceResponseBodyConflictCdsAndOrderConflictOrder] = None,
    ):
        self.conflict_cds = conflict_cds
        self.conflict_order = conflict_order

    def validate(self):
        if self.conflict_cds:
            for k in self.conflict_cds:
                if k:
                    k.validate()
        if self.conflict_order:
            for k in self.conflict_order:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConflictCds'] = []
        if self.conflict_cds is not None:
            for k in self.conflict_cds:
                result['ConflictCds'].append(k.to_map() if k else None)
        result['ConflictOrder'] = []
        if self.conflict_order is not None:
            for k in self.conflict_order:
                result['ConflictOrder'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.conflict_cds = []
        if m.get('ConflictCds') is not None:
            for k in m.get('ConflictCds'):
                temp_model = CreateCloudDriveServiceResponseBodyConflictCdsAndOrderConflictCds()
                self.conflict_cds.append(temp_model.from_map(k))
        self.conflict_order = []
        if m.get('ConflictOrder') is not None:
            for k in m.get('ConflictOrder'):
                temp_model = CreateCloudDriveServiceResponseBodyConflictCdsAndOrderConflictOrder()
                self.conflict_order.append(temp_model.from_map(k))
        return self


class CreateCloudDriveServiceResponseBody(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        cds_name: str = None,
        cen_id: str = None,
        conflict_cds_and_order: CreateCloudDriveServiceResponseBodyConflictCdsAndOrder = None,
        domain_name: str = None,
        error_code: str = None,
        max_size: str = None,
        office_site_type: str = None,
        order_id: str = None,
        request_id: str = None,
    ):
        # The ID of the attached cloud disk.
        self.cds_id = cds_id
        # The name of the cloud disk that is created in Cloud Drive Service.
        self.cds_name = cds_name
        self.cen_id = cen_id
        self.conflict_cds_and_order = conflict_cds_and_order
        self.domain_name = domain_name
        self.error_code = error_code
        # The maximum capacity of each instance in Cloud Drive Service. Unit: GiB
        self.max_size = max_size
        self.office_site_type = office_site_type
        self.order_id = order_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.conflict_cds_and_order:
            self.conflict_cds_and_order.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.cds_name is not None:
            result['CdsName'] = self.cds_name
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.conflict_cds_and_order is not None:
            result['ConflictCdsAndOrder'] = self.conflict_cds_and_order.to_map()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.max_size is not None:
            result['MaxSize'] = self.max_size
        if self.office_site_type is not None:
            result['OfficeSiteType'] = self.office_site_type
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('CdsName') is not None:
            self.cds_name = m.get('CdsName')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ConflictCdsAndOrder') is not None:
            temp_model = CreateCloudDriveServiceResponseBodyConflictCdsAndOrder()
            self.conflict_cds_and_order = temp_model.from_map(m['ConflictCdsAndOrder'])
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('MaxSize') is not None:
            self.max_size = m.get('MaxSize')
        if m.get('OfficeSiteType') is not None:
            self.office_site_type = m.get('OfficeSiteType')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCloudDriveServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCloudDriveServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCloudDriveServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCloudDriveUsersRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: List[str] = None,
        region_id: str = None,
        user_max_size: int = None,
    ):
        # The ID of the cloud disk.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The IDs of the end users.
        # 
        # This parameter is required.
        self.end_user_id = end_user_id
        # The region ID.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The maximum storage space of an end user. Unit: bytes.
        # 
        # This parameter is required.
        self.user_max_size = user_max_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.user_max_size is not None:
            result['UserMaxSize'] = self.user_max_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UserMaxSize') is not None:
            self.user_max_size = m.get('UserMaxSize')
        return self


class CreateCloudDriveUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCloudDriveUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCloudDriveUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCloudDriveUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConfigGroupRequestConfigTimers(TeaModel):
    def __init__(
        self,
        allow_client_setting: bool = None,
        cron_expression: str = None,
        enforce: bool = None,
        interval: int = None,
        operation_type: str = None,
        process_whitelist: List[str] = None,
        reset_type: str = None,
        timer_type: str = None,
        trigger_type: str = None,
    ):
        # Specifies whether to allow end users to configure scheduled tasks.
        self.allow_client_setting = allow_client_setting
        # The CRON expression for the scheduled task.
        # 
        # >  The time must be in UTC. For example, for 24:00 (UTC+8), you must set the value to 0 0 16 ? \\* 1,2,3,4,5,6,7
        self.cron_expression = cron_expression
        # Specifies whether to forcibly execute the scheduled task.
        self.enforce = enforce
        # The interval at which the scheduled task is executed. Unit: minutes.
        self.interval = interval
        # The type of the scheduled operation. If you set TimerType to NoConnect, you can specify this parameter.
        # 
        # Valid values:
        # 
        # *   Hibernate: scheduled hibernation.
        # *   Shutdown: scheduled shutdown.
        self.operation_type = operation_type
        # The process whitelist. If whitelisted processes are running, the scheduled task upon inactivity does not take effect.
        self.process_whitelist = process_whitelist
        # The reset operation for cloud computers.
        # 
        # Valid values:
        # 
        # *   RESET_TYPE_SYSTEM: resets only the system disks of cloud computers.
        # *   RESET_TYPE_USER_DISK: resets only the data disks of cloud computers.
        # *   RESET_TYPE_BOTH: resets the system disks and data disks of cloud computers.
        self.reset_type = reset_type
        # The type of the scheduled task.
        # 
        # Valid values:
        # 
        # *   NoOperationDisconnect: scheduled disconnection upon inactivity.
        # *   NoConnect: scheduled disconnection upon specified operation (OperationType).
        # *   TimerBoot: scheduled start.
        # *   TimerReset: scheduled reset.
        # *   NoOperationShutdown: scheduled shutdown upon inactivity.
        # *   NoOperationHibernate: scheduled hibernation upon inactivity.
        # *   TimerShutdown: scheduled shutdown.
        # *   NoOperationReboot: scheduled restart upon inactivity.
        # *   TimerReboot: scheduled restart.
        # 
        # This parameter is required.
        self.timer_type = timer_type
        # The method to trigger the scheduled task upon inactivity.
        # 
        # Valid values:
        # 
        # *   Advanced: intelligent detection.
        # *   Standard: standard detection.
        self.trigger_type = trigger_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_client_setting is not None:
            result['AllowClientSetting'] = self.allow_client_setting
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.enforce is not None:
            result['Enforce'] = self.enforce
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.process_whitelist is not None:
            result['ProcessWhitelist'] = self.process_whitelist
        if self.reset_type is not None:
            result['ResetType'] = self.reset_type
        if self.timer_type is not None:
            result['TimerType'] = self.timer_type
        if self.trigger_type is not None:
            result['TriggerType'] = self.trigger_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowClientSetting') is not None:
            self.allow_client_setting = m.get('AllowClientSetting')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('Enforce') is not None:
            self.enforce = m.get('Enforce')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('ProcessWhitelist') is not None:
            self.process_whitelist = m.get('ProcessWhitelist')
        if m.get('ResetType') is not None:
            self.reset_type = m.get('ResetType')
        if m.get('TimerType') is not None:
            self.timer_type = m.get('TimerType')
        if m.get('TriggerType') is not None:
            self.trigger_type = m.get('TriggerType')
        return self


class CreateConfigGroupRequest(TeaModel):
    def __init__(
        self,
        config_timers: List[CreateConfigGroupRequestConfigTimers] = None,
        description: str = None,
        name: str = None,
        product_type: str = None,
        region_id: str = None,
        type: str = None,
    ):
        # The list of configuration groups.
        self.config_timers = config_timers
        # The description of the configuration group.
        self.description = description
        # The name of the configuration group.
        # 
        # This parameter is required.
        self.name = name
        # The service type of the configuration group.
        # 
        # Valid value:
        # 
        # *   CLOUD_DESKTOP: the cloud computer service.
        # 
        # This parameter is required.
        self.product_type = product_type
        # The ID of the region. Set the value to `cn-shanghai`.
        self.region_id = region_id
        # The type of the configuration group.
        # 
        # Valid value:
        # 
        # *   Timer: the scheduled task type.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        if self.config_timers:
            for k in self.config_timers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigTimers'] = []
        if self.config_timers is not None:
            for k in self.config_timers:
                result['ConfigTimers'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_timers = []
        if m.get('ConfigTimers') is not None:
            for k in m.get('ConfigTimers'):
                temp_model = CreateConfigGroupRequestConfigTimers()
                self.config_timers.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateConfigGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        message: str = None,
        request_id: str = None,
    ):
        # The ID of the configuration group.
        self.group_id = group_id
        # The creation result of the configuration group.
        self.message = message
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateConfigGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateConfigGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateConfigGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDesktopGroupRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key. You cannot specify an empty string as a tag key. A tag key can be up to 128 characters in length and cannot start with `acs:` or `aliyun`. The tag key cannot contain `http://` or `https://`.
        # 
        # This parameter is required.
        self.key = key
        # The tag value. You can specify an empty string as a tag key. A tag value can be up to 128 characters in length and cannot start with `acs:`. The tag value cannot contain `http://` or `https://`.
        # 
        # This parameter is required.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDesktopGroupRequest(TeaModel):
    def __init__(
        self,
        all_classify_users: bool = None,
        allow_auto_setup: int = None,
        allow_buffer_count: int = None,
        auto_pay: bool = None,
        auto_renew: bool = None,
        bind_amount: int = None,
        bundle_id: str = None,
        buy_desktops_count: int = None,
        charge_type: str = None,
        classify: str = None,
        client_token: str = None,
        comments: str = None,
        connect_duration: int = None,
        data_disk_category: str = None,
        data_disk_per_level: str = None,
        data_disk_size: int = None,
        default_init_desktop_count: int = None,
        default_language: str = None,
        desktop_group_name: str = None,
        desktop_type: str = None,
        directory_id: str = None,
        end_user_ids: List[str] = None,
        exclusive_type: str = None,
        file_system_id: str = None,
        group_amount: int = None,
        group_version: int = None,
        hostname: str = None,
        idle_disconnect_duration: int = None,
        image_id: str = None,
        keep_duration: int = None,
        load_policy: int = None,
        max_desktops_count: int = None,
        min_desktops_count: int = None,
        multi_resource: bool = None,
        office_site_id: str = None,
        own_type: int = None,
        period: int = None,
        period_unit: str = None,
        policy_group_id: str = None,
        profile_follow_switch: bool = None,
        promotion_id: str = None,
        ratio_threshold: float = None,
        region_id: str = None,
        reset_type: int = None,
        scale_strategy_id: str = None,
        session_type: str = None,
        snapshot_policy_id: str = None,
        stop_duration: int = None,
        system_disk_category: str = None,
        system_disk_per_level: str = None,
        system_disk_size: int = None,
        tag: List[CreateDesktopGroupRequestTag] = None,
        timer_group_id: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
        vpc_id: str = None,
    ):
        # The types of the users.
        # 
        # >  This parameter is not publicly available.
        self.all_classify_users = all_classify_users
        # Specifies whether to enable batch-based automatic creation of subscription cloud computers for the shared group. This parameter is required if you set `ChargeType` to `PrePaid`.
        # 
        # Valid values:
        # 
        # *   0: enables batch-based automatic creation of subscription cloud computers.
        # *   1: disables batch-based automatic creation of subscription cloud computers.
        self.allow_auto_setup = allow_auto_setup
        # The maximum number of pay-as-you-go cloud computers that can be reserved in the shared group. This parameter is required if you set `ChargeType` to `PostPaid`. Valid values:
        # 
        # *   0: does not reserve any cloud computers.
        # *   N: reserves N cloud computers (1≤ N ≤ 100).
        # 
        # >  Setting this parameter to 0 means no cloud computers will be reserved in the shared group. In this case, the system must create, start, and assign cloud computers to end users upon request, which can be time-consuming. To improve user experience, we recommend that you reserve a specific number of cloud computers.
        self.allow_buffer_count = allow_buffer_count
        # Specifies whether to automatically complete the payment for subscription orders.
        self.auto_pay = auto_pay
        # Specifies whether to enable auto-renewal for the shared subscription group.
        # 
        # Valid values:
        # 
        # *   true
        # *   false
        self.auto_renew = auto_renew
        # The number of concurrent sessions of the multi-session shared group.
        # 
        # >  This parameter is not publicly available.
        self.bind_amount = bind_amount
        # The ID of the cloud computer template.
        self.bundle_id = bundle_id
        # *   For shared subscription groups, this parameter defines the initial number of cloud computers to be created. Valid values: 0 to 200.
        # *   For shared pay-as-you-go groups, this parameter defines the minimum initial number of cloud computers to be created. Valid values: 0 to `MaxDesktopsCount`. Default value: 1.
        self.buy_desktops_count = buy_desktops_count
        # The billing method of the shared group.
        # 
        # Valid values:
        # 
        # *   PostPaid: pay-as-you-go.
        # *   PrePaid: subscription.
        # 
        # This parameter is required.
        self.charge_type = charge_type
        # The type of the cloud computers in the shared group.
        # 
        # >  This parameter is not publicly available.
        # 
        # Valid values:
        # 
        # *   teacher: cloud computers designed for teachers.
        # *   student: cloud computers designed for students.
        self.classify = classify
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [How to ensure idempotence](https://help.aliyun.com/document_detail/25693.html).
        self.client_token = client_token
        # The remarks of the shared group.
        self.comments = comments
        # The maximum duration for which each session remains connected. The session is automatically disconnected once the specified maximum time limit is reached. Unit: milliseconds. Valid values: 900000 to 345600000. That is, the session can be connected for 15 to 5,760 minutes (4 days).
        self.connect_duration = connect_duration
        # The category of the data disk.
        # 
        # Valid values:
        # 
        # *   cloud_auto: the standard SSD.
        # *   cloud_essd: the ESSD.
        self.data_disk_category = data_disk_category
        # The PL of the data disk of the ESSD category. Default value: PL0.
        # 
        # Valid values:
        # 
        # *   PL1
        # *   PL0
        self.data_disk_per_level = data_disk_per_level
        # The size of the data disk. Unit: GB. Valid values: 0 to 16380. The value must be an integral multiple of 20.
        # 
        # *   A value of 0 means no data disk is attached.
        # *   If the selected plan includes a standard SSD, the data disk size must be at least 20 GB.
        # 
        # Default value: 0.
        self.data_disk_size = data_disk_size
        # The default number of cloud computers that you want to create at the same time in the shared group. Default value: 1.
        self.default_init_desktop_count = default_init_desktop_count
        # The language of the OS.
        # 
        # Valid values:
        # 
        # *   en-US: English.
        # *   zh-HK: Traditional Chinese.
        # *   zh-CN: Simplified Chinese
        # *   ja-JP: Japanese.
        self.default_language = default_language
        # The name of the shared group. The name can be up to 30 characters in length and can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-). It must start with a letter but cannot start with `http://` or `https://`.
        self.desktop_group_name = desktop_group_name
        # The specifications of the cloud computer. You can call the [DescribeDesktopTypes](~~DescribeDesktopTypes~~) operation to query all the supported specifications.
        self.desktop_type = desktop_type
        # The ID of the directory.
        # 
        # >  This parameter is not publicly available.
        self.directory_id = directory_id
        # The IDs of the end users.
        self.end_user_ids = end_user_ids
        # Specifies whether the shared group is exclusive. You must set this parameter to `Exclusive` when `SessionType` is set to `MultipleSession`.
        self.exclusive_type = exclusive_type
        # The ID of the File Storage NAS (NAS) file system for the user data roaming feature.
        # 
        # >  This parameter is not publicly available.
        self.file_system_id = file_system_id
        # The number of shared groups for the single-cloud computer type. You must specify this parameter if you set `MultiResource` to `false`. Valid values: 1 to 5. Default value: 1.
        self.group_amount = group_amount
        # The version of the shared group.
        self.group_version = group_version
        # The hostname series of the cloud computer. This parameter is supported exclusively when the office network operates on Active Directory (AD) and the cloud computer runs on a Windows operating system.
        # 
        # Naming conventions:
        # 
        # *   A hostname must be 2 to 15 characters in length
        # *   and can contain only letters, digits, and hyphens (-). It cannot start or end with a hyphen (-), contain consecutive hyphens (-), or contain only digits.
        # 
        # If you want to create multiple cloud computers, specify their hostnames in the `name_prefix[begin_number,bits]name_suffix` format. For example, if you set Hostname to ecd-[1,4]-test, the hostnames of the cloud computers will be assigned sequentially as ecd-0001-test, ecd-0002-test, and so on.
        # 
        # *   `name_prefix`: the prefix of the hostname.
        # *   `[begin_number,bits]`: the sequential number in the hostname. The `begin_number` value is the starting number. Valid values of begin_number: 0 to 999999. Default value: 0. The `bits` value is the number of digits. Valid values: 1 to 6. Default value: 6.
        # *   `name_suffix`: the suffix of the hostname.
        self.hostname = hostname
        # The duration after which a session is terminated if no keyboard or mouse activity is detected. When an end user connects to a cloud computer, a session is initiated. If no input from the keyboard or mouse is detected within this specified timeframe, the session is automatically closed. Unit: milliseconds. Valid values: 360000 to 3600000 (6 minutes to 60 minutes)
        # 
        # The system prompts end users to save their data 30 seconds before a session is disconnected. To avoid data loss, end users must save their session data upon receiving the prompt.
        # 
        # >  This parameter is suitable only for cloud computers whose image version is v1.0.2 or later.
        self.idle_disconnect_duration = idle_disconnect_duration
        # The ID of the image.
        self.image_id = image_id
        # The duration for which each session remains active after disconnection. Valid values: 180000 (3 minutes) to 345600000 (4 days). Unit: milliseconds. If you set this parameter to 0, the session is permanently retained after disconnection.
        # 
        # When a session is disconnected, take note of the following items: 1. If the end user does not resume the session within the specified duration, the session will close, and all unsaved data will be cleared. 2. If the end user resumes the session within the specified duration, the session data will remain accessible for continued use.
        self.keep_duration = keep_duration
        # The load balancing policy of the multi-session shared group.
        # 
        # >  This parameter is not publicly available.
        # 
        # Valid values:
        # 
        # *   0: depth-first
        # *   1: breadth first
        self.load_policy = load_policy
        # The maximum number of pay-as-you-go cloud computers that can be automatically provisioned at the same time in the shared group. Valid values: 0 to 500.
        self.max_desktops_count = max_desktops_count
        # The minimum number of subscription cloud computers that can be automatically provisioned at the same time in the shared group. This parameter is required if you set `ChargeType` to `PrePaid`. Default value: 1. Valid values: 0 to `MaxDesktopsCount`.
        self.min_desktops_count = min_desktops_count
        # Specifies whether the shared group is a multi-cloud computer type.
        # 
        # Valid values:
        # 
        # *   true: a multi-cloud computer type.
        # *   false: a single-cloud computer type.
        self.multi_resource = multi_resource
        # The ID of the office network.
        # 
        # This parameter is required.
        self.office_site_id = office_site_id
        # The session type of the shared group.
        # 
        # >  This parameter is not publicly available.
        # 
        # Valid values:
        # 
        # *   0: single-session.
        # *   1: multi-session.
        self.own_type = own_type
        # The subscription duration of the shared group. This parameter is required if you set `ChargeType` to `PrePaid`. You must specify the subscription duration unit by using `PeriodUnit`.
        # 
        # *   If you set `PeriodUnit` to `Month`, valid values of this parameter:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   6
        # 
        # *   If you set `PeriodUnit` to `Year`, valid values of this parameter:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   4
        #     *   5
        self.period = period
        # The unit of the subscription duration.
        self.period_unit = period_unit
        # The ID of the policy.
        # 
        # This parameter is required.
        self.policy_group_id = policy_group_id
        # Specifies whether to enable user data roaming.
        # 
        # >  This parameter is not publicly available.
        self.profile_follow_switch = profile_follow_switch
        # The ID of the coupon.
        self.promotion_id = promotion_id
        # The threshold for the ratio of connected sessions. This parameter defines the condition that activates automatic scaling of cloud computers in a multi-session shared group. The ratio of connected sessions is calculated by using the following formula:
        # 
        # `Ratio of connected sessions = Number of connected sessions/(Total number of cloud computers × Maximum number of sessions allowed for each cloud computer) × 100%`.
        # 
        # If the connected session ratio exceeds the specified threshold, new cloud computers are provisioned. If the ratio falls below the threshold, idle cloud computers are deleted.
        # 
        # >  This parameter is not publicly available.
        self.ratio_threshold = ratio_threshold
        # The ID of the region. You can call the [DescribeRegions](~~DescribeRegions~~) operation to query the list of regions where Elastic Desktop Service (EDS) Enterprise is available.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The reset option of the shared group.
        # 
        # Valid values:
        # 
        # *   0: Reset is not required.
        # *   1: Only the system disk is reset.
        # *   2: Only the data disk is reset.
        # *   3: Both the system disk and the data disk are reset.
        self.reset_type = reset_type
        # The ID of the scaling policy.
        # 
        # >  This parameter is not publicly available.
        self.scale_strategy_id = scale_strategy_id
        # The type of the session.
        # 
        # Valid values:
        # 
        # *   SingleSession
        # *   MultipleSession
        self.session_type = session_type
        # The ID of the automatic snapshot policy.
        self.snapshot_policy_id = snapshot_policy_id
        # The maximum period of inactivity allowed before a cloud computer is automatically stopped. If the idle duration reaches the specified limit, the system stops the cloud computer. When an end user reconnects to the stopped cloud computer, it automatically restarts. Unit: milliseconds.
        self.stop_duration = stop_duration
        # The category of the system disk.
        # 
        # Valid values:
        # 
        # *   cloud_auto: the standard SSD.
        # *   cloud_essd: the Enterprise SSD (ESSD).
        self.system_disk_category = system_disk_category
        # The performance level (PL) of the system disk of the ESSD category. Default value: PL0.
        # 
        # Valid values:
        # 
        # *   PL1
        # *   PL0
        self.system_disk_per_level = system_disk_per_level
        # The size of the system disk. Unit: GiB.
        # 
        # >  The system disk must be at least as large as the image.
        self.system_disk_size = system_disk_size
        # The tags. You can specify up to 20 tags.
        self.tag = tag
        # The ID of the timer group.
        self.timer_group_id = timer_group_id
        # Specifies whether to enable disk encryption.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that you want to use when disk encryption is enabled. You can call the [ListKeys](https://help.aliyun.com/document_detail/28951.html) operation to obtain a list of KMS keys.
        self.volume_encryption_key = volume_encryption_key
        # The ID of the virtual private cloud (VPC).
        # 
        # >  This parameter is not publicly available.
        self.vpc_id = vpc_id

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_classify_users is not None:
            result['AllClassifyUsers'] = self.all_classify_users
        if self.allow_auto_setup is not None:
            result['AllowAutoSetup'] = self.allow_auto_setup
        if self.allow_buffer_count is not None:
            result['AllowBufferCount'] = self.allow_buffer_count
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.bind_amount is not None:
            result['BindAmount'] = self.bind_amount
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.buy_desktops_count is not None:
            result['BuyDesktopsCount'] = self.buy_desktops_count
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.classify is not None:
            result['Classify'] = self.classify
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.comments is not None:
            result['Comments'] = self.comments
        if self.connect_duration is not None:
            result['ConnectDuration'] = self.connect_duration
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.data_disk_per_level is not None:
            result['DataDiskPerLevel'] = self.data_disk_per_level
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.default_init_desktop_count is not None:
            result['DefaultInitDesktopCount'] = self.default_init_desktop_count
        if self.default_language is not None:
            result['DefaultLanguage'] = self.default_language
        if self.desktop_group_name is not None:
            result['DesktopGroupName'] = self.desktop_group_name
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.exclusive_type is not None:
            result['ExclusiveType'] = self.exclusive_type
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.group_amount is not None:
            result['GroupAmount'] = self.group_amount
        if self.group_version is not None:
            result['GroupVersion'] = self.group_version
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.idle_disconnect_duration is not None:
            result['IdleDisconnectDuration'] = self.idle_disconnect_duration
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.keep_duration is not None:
            result['KeepDuration'] = self.keep_duration
        if self.load_policy is not None:
            result['LoadPolicy'] = self.load_policy
        if self.max_desktops_count is not None:
            result['MaxDesktopsCount'] = self.max_desktops_count
        if self.min_desktops_count is not None:
            result['MinDesktopsCount'] = self.min_desktops_count
        if self.multi_resource is not None:
            result['MultiResource'] = self.multi_resource
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.own_type is not None:
            result['OwnType'] = self.own_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.profile_follow_switch is not None:
            result['ProfileFollowSwitch'] = self.profile_follow_switch
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.ratio_threshold is not None:
            result['RatioThreshold'] = self.ratio_threshold
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reset_type is not None:
            result['ResetType'] = self.reset_type
        if self.scale_strategy_id is not None:
            result['ScaleStrategyId'] = self.scale_strategy_id
        if self.session_type is not None:
            result['SessionType'] = self.session_type
        if self.snapshot_policy_id is not None:
            result['SnapshotPolicyId'] = self.snapshot_policy_id
        if self.stop_duration is not None:
            result['StopDuration'] = self.stop_duration
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.system_disk_per_level is not None:
            result['SystemDiskPerLevel'] = self.system_disk_per_level
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.timer_group_id is not None:
            result['TimerGroupId'] = self.timer_group_id
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllClassifyUsers') is not None:
            self.all_classify_users = m.get('AllClassifyUsers')
        if m.get('AllowAutoSetup') is not None:
            self.allow_auto_setup = m.get('AllowAutoSetup')
        if m.get('AllowBufferCount') is not None:
            self.allow_buffer_count = m.get('AllowBufferCount')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('BindAmount') is not None:
            self.bind_amount = m.get('BindAmount')
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('BuyDesktopsCount') is not None:
            self.buy_desktops_count = m.get('BuyDesktopsCount')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Classify') is not None:
            self.classify = m.get('Classify')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Comments') is not None:
            self.comments = m.get('Comments')
        if m.get('ConnectDuration') is not None:
            self.connect_duration = m.get('ConnectDuration')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('DataDiskPerLevel') is not None:
            self.data_disk_per_level = m.get('DataDiskPerLevel')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('DefaultInitDesktopCount') is not None:
            self.default_init_desktop_count = m.get('DefaultInitDesktopCount')
        if m.get('DefaultLanguage') is not None:
            self.default_language = m.get('DefaultLanguage')
        if m.get('DesktopGroupName') is not None:
            self.desktop_group_name = m.get('DesktopGroupName')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('ExclusiveType') is not None:
            self.exclusive_type = m.get('ExclusiveType')
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('GroupAmount') is not None:
            self.group_amount = m.get('GroupAmount')
        if m.get('GroupVersion') is not None:
            self.group_version = m.get('GroupVersion')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('IdleDisconnectDuration') is not None:
            self.idle_disconnect_duration = m.get('IdleDisconnectDuration')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('KeepDuration') is not None:
            self.keep_duration = m.get('KeepDuration')
        if m.get('LoadPolicy') is not None:
            self.load_policy = m.get('LoadPolicy')
        if m.get('MaxDesktopsCount') is not None:
            self.max_desktops_count = m.get('MaxDesktopsCount')
        if m.get('MinDesktopsCount') is not None:
            self.min_desktops_count = m.get('MinDesktopsCount')
        if m.get('MultiResource') is not None:
            self.multi_resource = m.get('MultiResource')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OwnType') is not None:
            self.own_type = m.get('OwnType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('ProfileFollowSwitch') is not None:
            self.profile_follow_switch = m.get('ProfileFollowSwitch')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('RatioThreshold') is not None:
            self.ratio_threshold = m.get('RatioThreshold')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResetType') is not None:
            self.reset_type = m.get('ResetType')
        if m.get('ScaleStrategyId') is not None:
            self.scale_strategy_id = m.get('ScaleStrategyId')
        if m.get('SessionType') is not None:
            self.session_type = m.get('SessionType')
        if m.get('SnapshotPolicyId') is not None:
            self.snapshot_policy_id = m.get('SnapshotPolicyId')
        if m.get('StopDuration') is not None:
            self.stop_duration = m.get('StopDuration')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('SystemDiskPerLevel') is not None:
            self.system_disk_per_level = m.get('SystemDiskPerLevel')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDesktopGroupRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TimerGroupId') is not None:
            self.timer_group_id = m.get('TimerGroupId')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateDesktopGroupResponseBody(TeaModel):
    def __init__(
        self,
        desktop_group_id: str = None,
        desktop_group_ids: List[str] = None,
        order_ids: List[str] = None,
        request_id: str = None,
    ):
        # The ID of the shared group.
        self.desktop_group_id = desktop_group_id
        # The IDs of the shared groups.
        self.desktop_group_ids = desktop_group_ids
        # The IDs of the orders.
        self.order_ids = order_ids
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_ids is not None:
            result['DesktopGroupIds'] = self.desktop_group_ids
        if self.order_ids is not None:
            result['OrderIds'] = self.order_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupIds') is not None:
            self.desktop_group_ids = m.get('DesktopGroupIds')
        if m.get('OrderIds') is not None:
            self.order_ids = m.get('OrderIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDesktopGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDesktopGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDesktopGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDesktopOversoldGroupRequest(TeaModel):
    def __init__(
        self,
        concurrence_count: int = None,
        data_disk_size: int = None,
        description: str = None,
        desktop_type: str = None,
        directory_id: str = None,
        idle_disconnect_duration: int = None,
        image_id: str = None,
        keep_duration: int = None,
        name: str = None,
        oversold_user_count: int = None,
        oversold_warn: int = None,
        period: int = None,
        period_unit: str = None,
        policy_group_id: str = None,
        stop_duration: int = None,
        system_disk_size: int = None,
    ):
        self.concurrence_count = concurrence_count
        self.data_disk_size = data_disk_size
        self.description = description
        self.desktop_type = desktop_type
        self.directory_id = directory_id
        self.idle_disconnect_duration = idle_disconnect_duration
        self.image_id = image_id
        self.keep_duration = keep_duration
        self.name = name
        self.oversold_user_count = oversold_user_count
        self.oversold_warn = oversold_warn
        self.period = period
        self.period_unit = period_unit
        self.policy_group_id = policy_group_id
        self.stop_duration = stop_duration
        self.system_disk_size = system_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrence_count is not None:
            result['ConcurrenceCount'] = self.concurrence_count
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.idle_disconnect_duration is not None:
            result['IdleDisconnectDuration'] = self.idle_disconnect_duration
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.keep_duration is not None:
            result['KeepDuration'] = self.keep_duration
        if self.name is not None:
            result['Name'] = self.name
        if self.oversold_user_count is not None:
            result['OversoldUserCount'] = self.oversold_user_count
        if self.oversold_warn is not None:
            result['OversoldWarn'] = self.oversold_warn
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.stop_duration is not None:
            result['StopDuration'] = self.stop_duration
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcurrenceCount') is not None:
            self.concurrence_count = m.get('ConcurrenceCount')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('IdleDisconnectDuration') is not None:
            self.idle_disconnect_duration = m.get('IdleDisconnectDuration')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('KeepDuration') is not None:
            self.keep_duration = m.get('KeepDuration')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OversoldUserCount') is not None:
            self.oversold_user_count = m.get('OversoldUserCount')
        if m.get('OversoldWarn') is not None:
            self.oversold_warn = m.get('OversoldWarn')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('StopDuration') is not None:
            self.stop_duration = m.get('StopDuration')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        return self


class CreateDesktopOversoldGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        order_id: int = None,
        oversold_group_id: str = None,
    ):
        self.order_id = order_id
        self.oversold_group_id = oversold_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.oversold_group_id is not None:
            result['OversoldGroupId'] = self.oversold_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('OversoldGroupId') is not None:
            self.oversold_group_id = m.get('OversoldGroupId')
        return self


class CreateDesktopOversoldGroupResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateDesktopOversoldGroupResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateDesktopOversoldGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDesktopOversoldGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDesktopOversoldGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDesktopOversoldGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDesktopsRequestBundleModels(TeaModel):
    def __init__(
        self,
        amount: int = None,
        bundle_id: str = None,
        desktop_name: str = None,
        end_user_ids: List[str] = None,
        hostname: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
    ):
        # The number of cloud computers that you want to create. Valid values: 1 to 300. Default value: null.
        self.amount = amount
        # The ID of a cloud computer template.
        self.bundle_id = bundle_id
        # The name of the cloud computer. The name must meet the following requirements:
        # 
        # *   The name must be 1 to 64 characters in length.
        # *   The name must start with a letter but cannot start with `http://` or `https://`.
        # *   The name can only contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        self.desktop_name = desktop_name
        # The IDs of the end users to whom the cloud computer are assigned.
        self.end_user_ids = end_user_ids
        # The custom hostnames of the cloud computers. This parameter is valid only if the office network is an AD office network and the operating system type of the cloud computers is Windows.
        # 
        # The hostnames must meet the following requirements:
        # 
        # *   The hostnames must be 2 to 15 characters in length.
        # *   The hostnames can contain only letters, digits, and hyphens (-). The hostnames cannot start or end with a hyphen (-), contain consecutive hyphens (-), or contain only digits.
        # 
        # When you create multiple cloud computers, you can use the `name_prefix[begin_number,bits]name_suffix` naming format to name the cloud computers. For example, if you set the value of the Hostname parameter to ecd-[1,4]-test, the hostname of the first cloud computer is ecd-0001-test, the hostname of the second cloud computer is ecd-0002-test, and so on.
        # 
        # *   `name_prefix`: the prefix of the hostname.
        # *   `[begin_number,bits]`: the sequential number in the hostname. The `begin_number` value is the starting digit. Valid values of begin_number: 0 to 999999. Default value: 0. The `bits` value is the number of digits. Valid values: 1 to 6. Default value: 6.
        # *   `name_suffix`: the suffix of the hostname.
        self.hostname = hostname
        # Specifies whether to enable disk encryption.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that is used when disk encryption is enabled. You can call the [ListKeys](https://help.aliyun.com/document_detail/28951.html) operation to query the list of KMS keys.
        self.volume_encryption_key = volume_encryption_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        return self


class CreateDesktopsRequestDesktopAttachment(TeaModel):
    def __init__(
        self,
        data_disk_category: str = None,
        data_disk_per_level: str = None,
        data_disk_size: int = None,
        default_language: str = None,
        desktop_type: str = None,
        image_id: str = None,
        system_disk_category: str = None,
        system_disk_per_level: str = None,
        system_disk_size: int = None,
    ):
        # The category of the data disk. Valid values:
        # 
        # *   cloud_auto: SSD
        # *   cloud_essd: ESSD
        self.data_disk_category = data_disk_category
        # The performance level of the data disk. Valid values:
        # 
        # - PL0 (default)
        # - PL1
        self.data_disk_per_level = data_disk_per_level
        # The size of the data disk. Unit: GiB.
        self.data_disk_size = data_disk_size
        # The default display language:
        # 
        # - zh-CN: Simplified Chinese
        # - zh-HK: Traditional Chinese
        # - en-US: English
        # - ja-JP: Japanese
        self.default_language = default_language
        # The desktop type. You can call the [DescribeDesktopTypes](~~DescribeDesktopTypes~~) operation to query the IDs of supported desktop types.
        self.desktop_type = desktop_type
        # The ID of the image.
        self.image_id = image_id
        # The category of the system disk. Valid values:
        # 
        # *   cloud_auto: SSD
        # *   cloud_essd: ESSD
        self.system_disk_category = system_disk_category
        # The performance level of the system disk. Valid values:
        # 
        # - PL0 (default)
        # - PL1
        self.system_disk_per_level = system_disk_per_level
        # The size of the system disk. Unit: GiB.
        self.system_disk_size = system_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.data_disk_per_level is not None:
            result['DataDiskPerLevel'] = self.data_disk_per_level
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.default_language is not None:
            result['DefaultLanguage'] = self.default_language
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.system_disk_per_level is not None:
            result['SystemDiskPerLevel'] = self.system_disk_per_level
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('DataDiskPerLevel') is not None:
            self.data_disk_per_level = m.get('DataDiskPerLevel')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('DefaultLanguage') is not None:
            self.default_language = m.get('DefaultLanguage')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('SystemDiskPerLevel') is not None:
            self.system_disk_per_level = m.get('SystemDiskPerLevel')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        return self


class CreateDesktopsRequestDesktopTimers(TeaModel):
    def __init__(
        self,
        allow_client_setting: bool = None,
        cron_expression: str = None,
        enforce: bool = None,
        interval: int = None,
        operation_type: str = None,
        reset_type: str = None,
        timer_type: str = None,
    ):
        # Specifies whether to allow the end user to configure the scheduled task.
        self.allow_client_setting = allow_client_setting
        # The cron expression for the scheduled task.
        # 
        # >  The time must be in UTC. For example, for 24:00 (UTC+8), you must set the value to 0 0 16 ? \\* 1,2,3,4,5,6,7
        self.cron_expression = cron_expression
        # Specifies whether to forcibly execute the scheduled task.
        # 
        # Valid values:
        # 
        # *   true: forcibly executes the scheduled task regardless of the status and connection of the cloud computers.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false: does not forcibly execute the scheduled task.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.enforce = enforce
        # The interval at which cloud computers are created. Unit: minutes.
        self.interval = interval
        # The operations that scheduled tasks support. This parameter is valid only when TimerType is set to NoConnect.
        # 
        # Valid values:
        # 
        # *   Hibernate: hibernates the cloud computers.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Shutdown: stops the cloud computers.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.operation_type = operation_type
        # The reset type of the cloud computers.
        # 
        # Valid values:
        # 
        # *   RESET_TYPE_SYSTEM: resets the system disks.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   RESET_TYPE_BOTH: resets the system disks and data disks.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.reset_type = reset_type
        # The type of the scheduled task.
        self.timer_type = timer_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_client_setting is not None:
            result['AllowClientSetting'] = self.allow_client_setting
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.enforce is not None:
            result['Enforce'] = self.enforce
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.reset_type is not None:
            result['ResetType'] = self.reset_type
        if self.timer_type is not None:
            result['TimerType'] = self.timer_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowClientSetting') is not None:
            self.allow_client_setting = m.get('AllowClientSetting')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('Enforce') is not None:
            self.enforce = m.get('Enforce')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('ResetType') is not None:
            self.reset_type = m.get('ResetType')
        if m.get('TimerType') is not None:
            self.timer_type = m.get('TimerType')
        return self


class CreateDesktopsRequestMonthDesktopSetting(TeaModel):
    def __init__(
        self,
        buyer_id: int = None,
        desktop_id: str = None,
        use_duration: int = None,
    ):
        # > This parameter is not publicly available.
        self.buyer_id = buyer_id
        # > This parameter is not publicly available.
        self.desktop_id = desktop_id
        # > This parameter is not publicly available.
        self.use_duration = use_duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.buyer_id is not None:
            result['BuyerId'] = self.buyer_id
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.use_duration is not None:
            result['UseDuration'] = self.use_duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuyerId') is not None:
            self.buyer_id = m.get('BuyerId')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('UseDuration') is not None:
            self.use_duration = m.get('UseDuration')
        return self


class CreateDesktopsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag. You can specify 1 to 20 keys for a tag.
        self.key = key
        # The value of the tag. You can specify 1 to 20 values for a tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDesktopsRequestUserCommands(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_encoding: str = None,
        content_type: str = None,
    ):
        # The command content.
        self.content = content
        # The encoding mode of the command content.
        # 
        # Valid values:
        # 
        # *   Base64: encodes the command content in Base64.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PlainText: does not encode the command content.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.content_encoding = content_encoding
        # The language type of the command.
        # 
        # Valid values:
        # 
        # *   RunPowerShellScript: PowerShell commands (applicable to Windows cloud computers).
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   RunShellScript: shell commands (applicable to Linux cloud computers).
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   RunBatScript: batch commands (applicable to Windows cloud computers).
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.content_type = content_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentEncoding') is not None:
            self.content_encoding = m.get('ContentEncoding')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        return self


class CreateDesktopsRequest(TeaModel):
    def __init__(
        self,
        amount: int = None,
        auto_pay: bool = None,
        auto_renew: bool = None,
        bundle_id: str = None,
        bundle_models: List[CreateDesktopsRequestBundleModels] = None,
        charge_type: str = None,
        desktop_attachment: CreateDesktopsRequestDesktopAttachment = None,
        desktop_member_ip: str = None,
        desktop_name: str = None,
        desktop_name_suffix: bool = None,
        desktop_timers: List[CreateDesktopsRequestDesktopTimers] = None,
        directory_id: str = None,
        end_user_id: List[str] = None,
        group_id: str = None,
        hostname: str = None,
        month_desktop_setting: CreateDesktopsRequestMonthDesktopSetting = None,
        office_site_id: str = None,
        period: int = None,
        period_unit: str = None,
        policy_group_id: str = None,
        promotion_id: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        saving_plan_id: str = None,
        snapshot_policy_id: str = None,
        tag: List[CreateDesktopsRequestTag] = None,
        timer_group_id: str = None,
        user_assign_mode: str = None,
        user_commands: List[CreateDesktopsRequestUserCommands] = None,
        user_name: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
        vpc_id: str = None,
    ):
        # The number of cloud computers that you want to create. Valid values: 1 to 300. Default value: 1.
        self.amount = amount
        # Specifies whether to enable automatic payment.
        self.auto_pay = auto_pay
        # Specifies whether to enable auto-renewal. This parameter takes effect only when the ChargeType parameter is set to PrePaid.
        self.auto_renew = auto_renew
        # The ID of the cloud computer template.
        self.bundle_id = bundle_id
        # The cloud computer templates.
        self.bundle_models = bundle_models
        # The billing method of the cloud computers.
        # 
        # Default value: PostPaid. Valid values:
        # 
        # *   Postpaid: pay-as-you-go
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PrePaid: subscription
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.charge_type = charge_type
        # The input parameters used when no templates are used.
        self.desktop_attachment = desktop_attachment
        # The private IP address of the cloud computer.
        self.desktop_member_ip = desktop_member_ip
        # The name of the cloud computer. The name must meet the following requirements:
        # 
        # *   The name must be 1 to 64 characters in length.
        # *   The name must start with a letter but cannot start with `http://` or `https://`.
        # *   The name can only contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        self.desktop_name = desktop_name
        # Specifies whether to automatically add suffixes to the names of cloud computers when you create multiple cloud computers at the same time.
        # 
        # Default value: true. Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   False
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.desktop_name_suffix = desktop_name_suffix
        # The details of the scheduled task on cloud computers.
        self.desktop_timers = desktop_timers
        # >  This parameter is not publicly available.
        self.directory_id = directory_id
        # The IDs of the end users to which you want to assign the cloud computers. You can specify 1 to 100 IDs.
        self.end_user_id = end_user_id
        # The ID of the cloud computer pool.
        self.group_id = group_id
        # The custom hostnames of the cloud computers. This parameter is valid only if the office network is an AD office network and the operating system type of the cloud computers is Windows.
        # 
        # The hostnames must meet the following requirements:
        # 
        # *   The hostnames must be 2 to 15 characters in length.
        # *   The hostnames can contain only letters, digits, and hyphens (-). The hostnames cannot start or end with a hyphen (-), contain consecutive hyphens (-), or contain only digits.
        # 
        # When you create multiple cloud computers, you can use the `name_prefix[begin_number,bits]name_suffix` naming format to name the cloud computers. For example, if you set the value of the Hostname parameter to ecd-[1,4]-test, the hostname of the first cloud computer is ecd-0001-test, the hostname of the second cloud computer is ecd-0002-test, and so on.
        # 
        # *   `name_prefix`: the prefix of the hostname.
        # *   `[begin_number,bits]`: the sequential number in the hostname. The `begin_number` value is the starting digit. Valid values of begin_number: 0 to 999999. Default value: 0. The `bits` value is the number of digits. Valid values: 1 to 6. Default value: 6.
        # *   `name_suffix`: the suffix of the hostname.
        self.hostname = hostname
        # > This parameter is not publicly available.
        self.month_desktop_setting = month_desktop_setting
        # The office network ID.
        self.office_site_id = office_site_id
        # The subscription duration of the cloud desktop that you want to create. The unit is specified by the `PeriodUnit` parameter. This parameter takes effect and is required only when the `ChargeType` parameter is set to `PrePaid`.
        # 
        # *   Valid values if the `PeriodUnit` parameter is set to `Month`:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   6
        # 
        # *   Valid values if the `PeriodUnit` parameter is set to `Year`:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   4
        #     *   5
        self.period = period
        # The unit of the subscription duration.
        self.period_unit = period_unit
        # The ID of the policy.
        # 
        # This parameter is required.
        self.policy_group_id = policy_group_id
        # The ID of the sales promotion.
        self.promotion_id = promotion_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # The ID of the saving plan.
        self.saving_plan_id = saving_plan_id
        # The ID of the auto-snapshot policy.
        self.snapshot_policy_id = snapshot_policy_id
        # The tags that you want to add to the cloud desktop.
        self.tag = tag
        # The ID of the timer group.
        self.timer_group_id = timer_group_id
        # How the cloud computers are assigned.
        # 
        # >  If you do not specify the `EndUserId` parameter, the cloud computers are not assigned to end users after the cloud computers are created.
        # 
        # Default value: ALL. Valid values:
        # 
        # *   ALL: If you specify the EndUserId parameter, the cloud computers are assigned to all specified end users after the cloud computers are created.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PER_USER: If you specify the EndUserId parameter, the cloud computers are evenly assigned to the specified end users after the cloud computers are created.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     In this case, you must make sure that the value of the Amount parameter can be divided by the N value of the EndUserId.N parameter that you specify.
        # 
        #     <!-- -->
        self.user_assign_mode = user_assign_mode
        # Details about the custom command scripts.
        self.user_commands = user_commands
        # >  This parameter is not publicly available.
        self.user_name = user_name
        # Specifies whether to enable disk encryption.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that you want to use when disk encryption is enabled. You can call the [ListKeys](https://help.aliyun.com/document_detail/28951.html) operation to obtain a list of KMS keys.
        self.volume_encryption_key = volume_encryption_key
        # >  This parameter is not publicly available.
        self.vpc_id = vpc_id

    def validate(self):
        if self.bundle_models:
            for k in self.bundle_models:
                if k:
                    k.validate()
        if self.desktop_attachment:
            self.desktop_attachment.validate()
        if self.desktop_timers:
            for k in self.desktop_timers:
                if k:
                    k.validate()
        if self.month_desktop_setting:
            self.month_desktop_setting.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.user_commands:
            for k in self.user_commands:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        result['BundleModels'] = []
        if self.bundle_models is not None:
            for k in self.bundle_models:
                result['BundleModels'].append(k.to_map() if k else None)
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.desktop_attachment is not None:
            result['DesktopAttachment'] = self.desktop_attachment.to_map()
        if self.desktop_member_ip is not None:
            result['DesktopMemberIp'] = self.desktop_member_ip
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_name_suffix is not None:
            result['DesktopNameSuffix'] = self.desktop_name_suffix
        result['DesktopTimers'] = []
        if self.desktop_timers is not None:
            for k in self.desktop_timers:
                result['DesktopTimers'].append(k.to_map() if k else None)
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.month_desktop_setting is not None:
            result['MonthDesktopSetting'] = self.month_desktop_setting.to_map()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.saving_plan_id is not None:
            result['SavingPlanId'] = self.saving_plan_id
        if self.snapshot_policy_id is not None:
            result['SnapshotPolicyId'] = self.snapshot_policy_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.timer_group_id is not None:
            result['TimerGroupId'] = self.timer_group_id
        if self.user_assign_mode is not None:
            result['UserAssignMode'] = self.user_assign_mode
        result['UserCommands'] = []
        if self.user_commands is not None:
            for k in self.user_commands:
                result['UserCommands'].append(k.to_map() if k else None)
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        self.bundle_models = []
        if m.get('BundleModels') is not None:
            for k in m.get('BundleModels'):
                temp_model = CreateDesktopsRequestBundleModels()
                self.bundle_models.append(temp_model.from_map(k))
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DesktopAttachment') is not None:
            temp_model = CreateDesktopsRequestDesktopAttachment()
            self.desktop_attachment = temp_model.from_map(m['DesktopAttachment'])
        if m.get('DesktopMemberIp') is not None:
            self.desktop_member_ip = m.get('DesktopMemberIp')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopNameSuffix') is not None:
            self.desktop_name_suffix = m.get('DesktopNameSuffix')
        self.desktop_timers = []
        if m.get('DesktopTimers') is not None:
            for k in m.get('DesktopTimers'):
                temp_model = CreateDesktopsRequestDesktopTimers()
                self.desktop_timers.append(temp_model.from_map(k))
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('MonthDesktopSetting') is not None:
            temp_model = CreateDesktopsRequestMonthDesktopSetting()
            self.month_desktop_setting = temp_model.from_map(m['MonthDesktopSetting'])
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SavingPlanId') is not None:
            self.saving_plan_id = m.get('SavingPlanId')
        if m.get('SnapshotPolicyId') is not None:
            self.snapshot_policy_id = m.get('SnapshotPolicyId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDesktopsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TimerGroupId') is not None:
            self.timer_group_id = m.get('TimerGroupId')
        if m.get('UserAssignMode') is not None:
            self.user_assign_mode = m.get('UserAssignMode')
        self.user_commands = []
        if m.get('UserCommands') is not None:
            for k in m.get('UserCommands'):
                temp_model = CreateDesktopsRequestUserCommands()
                self.user_commands.append(temp_model.from_map(k))
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateDesktopsShrinkRequestBundleModels(TeaModel):
    def __init__(
        self,
        amount: int = None,
        bundle_id: str = None,
        desktop_name: str = None,
        end_user_ids: List[str] = None,
        hostname: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
    ):
        # The number of cloud computers that you want to create. Valid values: 1 to 300. Default value: null.
        self.amount = amount
        # The ID of a cloud computer template.
        self.bundle_id = bundle_id
        # The name of the cloud computer. The name must meet the following requirements:
        # 
        # *   The name must be 1 to 64 characters in length.
        # *   The name must start with a letter but cannot start with `http://` or `https://`.
        # *   The name can only contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        self.desktop_name = desktop_name
        # The IDs of the end users to whom the cloud computer are assigned.
        self.end_user_ids = end_user_ids
        # The custom hostnames of the cloud computers. This parameter is valid only if the office network is an AD office network and the operating system type of the cloud computers is Windows.
        # 
        # The hostnames must meet the following requirements:
        # 
        # *   The hostnames must be 2 to 15 characters in length.
        # *   The hostnames can contain only letters, digits, and hyphens (-). The hostnames cannot start or end with a hyphen (-), contain consecutive hyphens (-), or contain only digits.
        # 
        # When you create multiple cloud computers, you can use the `name_prefix[begin_number,bits]name_suffix` naming format to name the cloud computers. For example, if you set the value of the Hostname parameter to ecd-[1,4]-test, the hostname of the first cloud computer is ecd-0001-test, the hostname of the second cloud computer is ecd-0002-test, and so on.
        # 
        # *   `name_prefix`: the prefix of the hostname.
        # *   `[begin_number,bits]`: the sequential number in the hostname. The `begin_number` value is the starting digit. Valid values of begin_number: 0 to 999999. Default value: 0. The `bits` value is the number of digits. Valid values: 1 to 6. Default value: 6.
        # *   `name_suffix`: the suffix of the hostname.
        self.hostname = hostname
        # Specifies whether to enable disk encryption.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that is used when disk encryption is enabled. You can call the [ListKeys](https://help.aliyun.com/document_detail/28951.html) operation to query the list of KMS keys.
        self.volume_encryption_key = volume_encryption_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        return self


class CreateDesktopsShrinkRequestDesktopTimers(TeaModel):
    def __init__(
        self,
        allow_client_setting: bool = None,
        cron_expression: str = None,
        enforce: bool = None,
        interval: int = None,
        operation_type: str = None,
        reset_type: str = None,
        timer_type: str = None,
    ):
        # Specifies whether to allow the end user to configure the scheduled task.
        self.allow_client_setting = allow_client_setting
        # The cron expression for the scheduled task.
        # 
        # >  The time must be in UTC. For example, for 24:00 (UTC+8), you must set the value to 0 0 16 ? \\* 1,2,3,4,5,6,7
        self.cron_expression = cron_expression
        # Specifies whether to forcibly execute the scheduled task.
        # 
        # Valid values:
        # 
        # *   true: forcibly executes the scheduled task regardless of the status and connection of the cloud computers.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false: does not forcibly execute the scheduled task.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.enforce = enforce
        # The interval at which cloud computers are created. Unit: minutes.
        self.interval = interval
        # The operations that scheduled tasks support. This parameter is valid only when TimerType is set to NoConnect.
        # 
        # Valid values:
        # 
        # *   Hibernate: hibernates the cloud computers.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Shutdown: stops the cloud computers.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.operation_type = operation_type
        # The reset type of the cloud computers.
        # 
        # Valid values:
        # 
        # *   RESET_TYPE_SYSTEM: resets the system disks.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   RESET_TYPE_BOTH: resets the system disks and data disks.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.reset_type = reset_type
        # The type of the scheduled task.
        self.timer_type = timer_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_client_setting is not None:
            result['AllowClientSetting'] = self.allow_client_setting
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.enforce is not None:
            result['Enforce'] = self.enforce
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.reset_type is not None:
            result['ResetType'] = self.reset_type
        if self.timer_type is not None:
            result['TimerType'] = self.timer_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowClientSetting') is not None:
            self.allow_client_setting = m.get('AllowClientSetting')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('Enforce') is not None:
            self.enforce = m.get('Enforce')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('ResetType') is not None:
            self.reset_type = m.get('ResetType')
        if m.get('TimerType') is not None:
            self.timer_type = m.get('TimerType')
        return self


class CreateDesktopsShrinkRequestMonthDesktopSetting(TeaModel):
    def __init__(
        self,
        buyer_id: int = None,
        desktop_id: str = None,
        use_duration: int = None,
    ):
        # > This parameter is not publicly available.
        self.buyer_id = buyer_id
        # > This parameter is not publicly available.
        self.desktop_id = desktop_id
        # > This parameter is not publicly available.
        self.use_duration = use_duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.buyer_id is not None:
            result['BuyerId'] = self.buyer_id
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.use_duration is not None:
            result['UseDuration'] = self.use_duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuyerId') is not None:
            self.buyer_id = m.get('BuyerId')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('UseDuration') is not None:
            self.use_duration = m.get('UseDuration')
        return self


class CreateDesktopsShrinkRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag. You can specify 1 to 20 keys for a tag.
        self.key = key
        # The value of the tag. You can specify 1 to 20 values for a tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDesktopsShrinkRequestUserCommands(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_encoding: str = None,
        content_type: str = None,
    ):
        # The command content.
        self.content = content
        # The encoding mode of the command content.
        # 
        # Valid values:
        # 
        # *   Base64: encodes the command content in Base64.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PlainText: does not encode the command content.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.content_encoding = content_encoding
        # The language type of the command.
        # 
        # Valid values:
        # 
        # *   RunPowerShellScript: PowerShell commands (applicable to Windows cloud computers).
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   RunShellScript: shell commands (applicable to Linux cloud computers).
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   RunBatScript: batch commands (applicable to Windows cloud computers).
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.content_type = content_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentEncoding') is not None:
            self.content_encoding = m.get('ContentEncoding')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        return self


class CreateDesktopsShrinkRequest(TeaModel):
    def __init__(
        self,
        amount: int = None,
        auto_pay: bool = None,
        auto_renew: bool = None,
        bundle_id: str = None,
        bundle_models: List[CreateDesktopsShrinkRequestBundleModels] = None,
        charge_type: str = None,
        desktop_attachment_shrink: str = None,
        desktop_member_ip: str = None,
        desktop_name: str = None,
        desktop_name_suffix: bool = None,
        desktop_timers: List[CreateDesktopsShrinkRequestDesktopTimers] = None,
        directory_id: str = None,
        end_user_id: List[str] = None,
        group_id: str = None,
        hostname: str = None,
        month_desktop_setting: CreateDesktopsShrinkRequestMonthDesktopSetting = None,
        office_site_id: str = None,
        period: int = None,
        period_unit: str = None,
        policy_group_id: str = None,
        promotion_id: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        saving_plan_id: str = None,
        snapshot_policy_id: str = None,
        tag: List[CreateDesktopsShrinkRequestTag] = None,
        timer_group_id: str = None,
        user_assign_mode: str = None,
        user_commands: List[CreateDesktopsShrinkRequestUserCommands] = None,
        user_name: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
        vpc_id: str = None,
    ):
        # The number of cloud computers that you want to create. Valid values: 1 to 300. Default value: 1.
        self.amount = amount
        # Specifies whether to enable automatic payment.
        self.auto_pay = auto_pay
        # Specifies whether to enable auto-renewal. This parameter takes effect only when the ChargeType parameter is set to PrePaid.
        self.auto_renew = auto_renew
        # The ID of the cloud computer template.
        self.bundle_id = bundle_id
        # The cloud computer templates.
        self.bundle_models = bundle_models
        # The billing method of the cloud computers.
        # 
        # Default value: PostPaid. Valid values:
        # 
        # *   Postpaid: pay-as-you-go
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PrePaid: subscription
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.charge_type = charge_type
        # The input parameters used when no templates are used.
        self.desktop_attachment_shrink = desktop_attachment_shrink
        # The private IP address of the cloud computer.
        self.desktop_member_ip = desktop_member_ip
        # The name of the cloud computer. The name must meet the following requirements:
        # 
        # *   The name must be 1 to 64 characters in length.
        # *   The name must start with a letter but cannot start with `http://` or `https://`.
        # *   The name can only contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        self.desktop_name = desktop_name
        # Specifies whether to automatically add suffixes to the names of cloud computers when you create multiple cloud computers at the same time.
        # 
        # Default value: true. Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   False
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.desktop_name_suffix = desktop_name_suffix
        # The details of the scheduled task on cloud computers.
        self.desktop_timers = desktop_timers
        # >  This parameter is not publicly available.
        self.directory_id = directory_id
        # The IDs of the end users to which you want to assign the cloud computers. You can specify 1 to 100 IDs.
        self.end_user_id = end_user_id
        # The ID of the cloud computer pool.
        self.group_id = group_id
        # The custom hostnames of the cloud computers. This parameter is valid only if the office network is an AD office network and the operating system type of the cloud computers is Windows.
        # 
        # The hostnames must meet the following requirements:
        # 
        # *   The hostnames must be 2 to 15 characters in length.
        # *   The hostnames can contain only letters, digits, and hyphens (-). The hostnames cannot start or end with a hyphen (-), contain consecutive hyphens (-), or contain only digits.
        # 
        # When you create multiple cloud computers, you can use the `name_prefix[begin_number,bits]name_suffix` naming format to name the cloud computers. For example, if you set the value of the Hostname parameter to ecd-[1,4]-test, the hostname of the first cloud computer is ecd-0001-test, the hostname of the second cloud computer is ecd-0002-test, and so on.
        # 
        # *   `name_prefix`: the prefix of the hostname.
        # *   `[begin_number,bits]`: the sequential number in the hostname. The `begin_number` value is the starting digit. Valid values of begin_number: 0 to 999999. Default value: 0. The `bits` value is the number of digits. Valid values: 1 to 6. Default value: 6.
        # *   `name_suffix`: the suffix of the hostname.
        self.hostname = hostname
        # > This parameter is not publicly available.
        self.month_desktop_setting = month_desktop_setting
        # The office network ID.
        self.office_site_id = office_site_id
        # The subscription duration of the cloud desktop that you want to create. The unit is specified by the `PeriodUnit` parameter. This parameter takes effect and is required only when the `ChargeType` parameter is set to `PrePaid`.
        # 
        # *   Valid values if the `PeriodUnit` parameter is set to `Month`:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   6
        # 
        # *   Valid values if the `PeriodUnit` parameter is set to `Year`:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   4
        #     *   5
        self.period = period
        # The unit of the subscription duration.
        self.period_unit = period_unit
        # The ID of the policy.
        # 
        # This parameter is required.
        self.policy_group_id = policy_group_id
        # The ID of the sales promotion.
        self.promotion_id = promotion_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # The ID of the saving plan.
        self.saving_plan_id = saving_plan_id
        # The ID of the auto-snapshot policy.
        self.snapshot_policy_id = snapshot_policy_id
        # The tags that you want to add to the cloud desktop.
        self.tag = tag
        # The ID of the timer group.
        self.timer_group_id = timer_group_id
        # How the cloud computers are assigned.
        # 
        # >  If you do not specify the `EndUserId` parameter, the cloud computers are not assigned to end users after the cloud computers are created.
        # 
        # Default value: ALL. Valid values:
        # 
        # *   ALL: If you specify the EndUserId parameter, the cloud computers are assigned to all specified end users after the cloud computers are created.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PER_USER: If you specify the EndUserId parameter, the cloud computers are evenly assigned to the specified end users after the cloud computers are created.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     In this case, you must make sure that the value of the Amount parameter can be divided by the N value of the EndUserId.N parameter that you specify.
        # 
        #     <!-- -->
        self.user_assign_mode = user_assign_mode
        # Details about the custom command scripts.
        self.user_commands = user_commands
        # >  This parameter is not publicly available.
        self.user_name = user_name
        # Specifies whether to enable disk encryption.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that you want to use when disk encryption is enabled. You can call the [ListKeys](https://help.aliyun.com/document_detail/28951.html) operation to obtain a list of KMS keys.
        self.volume_encryption_key = volume_encryption_key
        # >  This parameter is not publicly available.
        self.vpc_id = vpc_id

    def validate(self):
        if self.bundle_models:
            for k in self.bundle_models:
                if k:
                    k.validate()
        if self.desktop_timers:
            for k in self.desktop_timers:
                if k:
                    k.validate()
        if self.month_desktop_setting:
            self.month_desktop_setting.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.user_commands:
            for k in self.user_commands:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        result['BundleModels'] = []
        if self.bundle_models is not None:
            for k in self.bundle_models:
                result['BundleModels'].append(k.to_map() if k else None)
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.desktop_attachment_shrink is not None:
            result['DesktopAttachment'] = self.desktop_attachment_shrink
        if self.desktop_member_ip is not None:
            result['DesktopMemberIp'] = self.desktop_member_ip
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_name_suffix is not None:
            result['DesktopNameSuffix'] = self.desktop_name_suffix
        result['DesktopTimers'] = []
        if self.desktop_timers is not None:
            for k in self.desktop_timers:
                result['DesktopTimers'].append(k.to_map() if k else None)
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.month_desktop_setting is not None:
            result['MonthDesktopSetting'] = self.month_desktop_setting.to_map()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.saving_plan_id is not None:
            result['SavingPlanId'] = self.saving_plan_id
        if self.snapshot_policy_id is not None:
            result['SnapshotPolicyId'] = self.snapshot_policy_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.timer_group_id is not None:
            result['TimerGroupId'] = self.timer_group_id
        if self.user_assign_mode is not None:
            result['UserAssignMode'] = self.user_assign_mode
        result['UserCommands'] = []
        if self.user_commands is not None:
            for k in self.user_commands:
                result['UserCommands'].append(k.to_map() if k else None)
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        self.bundle_models = []
        if m.get('BundleModels') is not None:
            for k in m.get('BundleModels'):
                temp_model = CreateDesktopsShrinkRequestBundleModels()
                self.bundle_models.append(temp_model.from_map(k))
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DesktopAttachment') is not None:
            self.desktop_attachment_shrink = m.get('DesktopAttachment')
        if m.get('DesktopMemberIp') is not None:
            self.desktop_member_ip = m.get('DesktopMemberIp')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopNameSuffix') is not None:
            self.desktop_name_suffix = m.get('DesktopNameSuffix')
        self.desktop_timers = []
        if m.get('DesktopTimers') is not None:
            for k in m.get('DesktopTimers'):
                temp_model = CreateDesktopsShrinkRequestDesktopTimers()
                self.desktop_timers.append(temp_model.from_map(k))
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('MonthDesktopSetting') is not None:
            temp_model = CreateDesktopsShrinkRequestMonthDesktopSetting()
            self.month_desktop_setting = temp_model.from_map(m['MonthDesktopSetting'])
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SavingPlanId') is not None:
            self.saving_plan_id = m.get('SavingPlanId')
        if m.get('SnapshotPolicyId') is not None:
            self.snapshot_policy_id = m.get('SnapshotPolicyId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDesktopsShrinkRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TimerGroupId') is not None:
            self.timer_group_id = m.get('TimerGroupId')
        if m.get('UserAssignMode') is not None:
            self.user_assign_mode = m.get('UserAssignMode')
        self.user_commands = []
        if m.get('UserCommands') is not None:
            for k in m.get('UserCommands'):
                temp_model = CreateDesktopsShrinkRequestUserCommands()
                self.user_commands.append(temp_model.from_map(k))
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateDesktopsResponseBody(TeaModel):
    def __init__(
        self,
        desktop_id: List[str] = None,
        order_id: str = None,
        request_id: str = None,
    ):
        # The IDs of the cloud computers that are created. If multiple cloud computers are created, multiple IDs are returned.
        self.desktop_id = desktop_id
        # The ID of the order.
        # 
        # > This parameter is returned only when you set the ChargeType parameter to PrePaid.
        self.order_id = order_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDesktopsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDesktopsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDesktopsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiskEncryptionServiceRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateDiskEncryptionServiceResponseBody(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The order ID.
        self.order_id = order_id
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDiskEncryptionServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDiskEncryptionServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiskEncryptionServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImageRequest(TeaModel):
    def __init__(
        self,
        auto_clean_userdata: bool = None,
        description: str = None,
        desktop_id: str = None,
        disk_type: str = None,
        image_name: str = None,
        image_resource_type: str = None,
        region_id: str = None,
        snapshot_id: str = None,
        snapshot_ids: List[str] = None,
    ):
        # Specifies whether to clear private data of users. If you set AutoCleanUserdata to `true`, the custom image clears the data directories, excluding the `Administrator` and `Public` directories, in the `C:\\Users` directory.
        self.auto_clean_userdata = auto_clean_userdata
        # The description of the custom image. The description must be 2 to 256 characters in length. It cannot start with `http://` or `https://`.
        self.description = description
        # The ID of the cloud computer.
        self.desktop_id = desktop_id
        # The disk data that is contained in the custom image.
        # 
        # Valid values:
        # 
        # - SYSTEM: only contain data from system disks.
        # - ALL: contain data from system disks and user disks. [default]
        self.disk_type = disk_type
        # The name of the image. The name must be 2 to 128 characters in length. The name must start with a letter but cannot start with `http://` or `https://`. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        self.image_name = image_name
        # This parameter is not publicly available.
        self.image_resource_type = image_resource_type
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the snapshot.
        self.snapshot_id = snapshot_id
        # The IDs of the snapshots.
        self.snapshot_ids = snapshot_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_clean_userdata is not None:
            result['AutoCleanUserdata'] = self.auto_clean_userdata
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_resource_type is not None:
            result['ImageResourceType'] = self.image_resource_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.snapshot_ids is not None:
            result['SnapshotIds'] = self.snapshot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoCleanUserdata') is not None:
            self.auto_clean_userdata = m.get('AutoCleanUserdata')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ImageResourceType') is not None:
            self.image_resource_type = m.get('ImageResourceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SnapshotIds') is not None:
            self.snapshot_ids = m.get('SnapshotIds')
        return self


class CreateImageResponseBody(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        request_id: str = None,
    ):
        # The ID of the image.
        self.image_id = image_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNASFileSystemRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        encrypt_type: str = None,
        name: str = None,
        office_site_id: str = None,
        region_id: str = None,
        storage_type: str = None,
    ):
        # Description of the NAS file system.
        self.description = description
        # Whether the file system is encrypted. Uses KMS service-managed keys to encrypt the file system\\"s on-disk data. No decryption is required when reading and writing encrypted data. Possible values and their meanings:
        # 
        # - 0: Not encrypted.
        # - 1: Encrypted using NAS-managed keys.
        # 
        # Default value: 0
        self.encrypt_type = encrypt_type
        # Name of the NAS file system.
        # The file name must follow these rules:
        # - Length: 2 to 128 English or Chinese characters.
        # - Must start with an uppercase or lowercase letter or a Chinese character, cannot start with http:// or https://.
        # - Can include numbers, underscores (_), or hyphens (-).
        self.name = name
        # Workspace ID.
        # 
        # This parameter is required.
        self.office_site_id = office_site_id
        # Region ID.
        # 
        # This parameter is required.
        self.region_id = region_id
        # Storage specification type of the NAS file system. Allowed values:
        # 
        # - Capacity: Capacity type.
        # - Performance: Performance type.
        # 
        # Default value: Capacity
        self.storage_type = storage_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.encrypt_type is not None:
            result['EncryptType'] = self.encrypt_type
        if self.name is not None:
            result['Name'] = self.name
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EncryptType') is not None:
            self.encrypt_type = m.get('EncryptType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class CreateNASFileSystemResponseBody(TeaModel):
    def __init__(
        self,
        file_system_id: str = None,
        file_system_name: str = None,
        mount_target_domain: str = None,
        office_site_id: str = None,
        request_id: str = None,
    ):
        # ID of the NAS file system.
        self.file_system_id = file_system_id
        # Name of the NAS file system.
        self.file_system_name = file_system_name
        # Mount point domain.
        self.mount_target_domain = mount_target_domain
        # Workspace ID.
        self.office_site_id = office_site_id
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.file_system_name is not None:
            result['FileSystemName'] = self.file_system_name
        if self.mount_target_domain is not None:
            result['MountTargetDomain'] = self.mount_target_domain
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('FileSystemName') is not None:
            self.file_system_name = m.get('FileSystemName')
        if m.get('MountTargetDomain') is not None:
            self.mount_target_domain = m.get('MountTargetDomain')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNASFileSystemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNASFileSystemResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNASFileSystemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkPackageRequest(TeaModel):
    def __init__(
        self,
        auto_pay: bool = None,
        auto_renew: bool = None,
        bandwidth: int = None,
        internet_charge_type: str = None,
        office_site_id: str = None,
        pay_type: str = None,
        period: int = None,
        period_unit: str = None,
        promotion_id: str = None,
        region_id: str = None,
    ):
        # Specifies whether to enable the automatic payment feature.
        # 
        # Valid values:
        # 
        # *   true (default): enables the auto-payment feature.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     Make sure that your account has sufficient balance. Otherwise, no order is generated.
        # 
        #     <!-- -->
        # 
        # *   false: disables the auto-payment feature. In this case, an order is generated but you need to make the payment manually.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     To make the payment, log on to the Elastic Desktop Service console, go to the Orders page, and find the order based on the order ID.
        # 
        #     <!-- -->
        self.auto_pay = auto_pay
        # Specifies whether to enable auto-renewal for the premium bandwidth plan.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.auto_renew = auto_renew
        # The bandwidth provided by the premium bandwidth plan. Unit: Mbit/s.
        # 
        # *   Valid values if the premium bandwidth plan is a subscription plan: 2 to 1000.
        # *   Valid values if the premium bandwidth plan is a pay-as-you-go plan that charges by data transfer (PayByTraffic): 2 to 200.
        # *   Valid values if the premium bandwidth plan is a pay-as-you-go plan that charges by fixed bandwidth (PayByBandwidth): 2 to 1000.
        # 
        # This parameter is required.
        self.bandwidth = bandwidth
        # The charge type of the premium bandwidth plan.
        # 
        # *   Valid value when the `PayType` parameter is set to `PrePaid`:
        # 
        #     *   PayByBandwidth: charges by fixed bandwidth.
        # 
        # *   Valid values when the `PayType` parameter is set to `PostPaid`:
        # 
        #     *   PayByTraffic: charges by data transfer.
        #     *   PayByBandwidth: charges by fixed bandwidth.
        self.internet_charge_type = internet_charge_type
        # The office network ID.
        # 
        # This parameter is required.
        self.office_site_id = office_site_id
        # The billing method of the premium bandwidth plan.
        # 
        # Valid values:
        # 
        # *   PostPaid: pay-as-you-go
        # *   PrePaid: subscription
        self.pay_type = pay_type
        # The subscription duration of the premium bandwidth plan. This parameter takes effect and is required only when the `PayType` parameter is set to `PrePaid`. The valid values of this parameter vary based on the `PeriodUnit` value.
        # 
        # *   Valid value when the `PeriodUnit` parameter is set to `Week`: 1
        # *   Valid values when the `PeriodUnit` parameter is set to `Month`: 1, 2, 3, and 6
        # *   Valid values when the `PeriodUnit` parameter is set to `Year`: 1, 2, and 3
        # 
        # Default value: 1.
        self.period = period
        # The unit of the subscription duration of the premium bandwidth plan. This parameter takes effect and is required only when the `PayType` parameter is set to `PrePaid`.
        # 
        # Valid values:
        # 
        # *   Month
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Year
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Week
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.period_unit = period_unit
        # The ID of the sales promotion.
        self.promotion_id = promotion_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateNetworkPackageResponseBody(TeaModel):
    def __init__(
        self,
        network_package_id: str = None,
        order_id: str = None,
        request_id: str = None,
    ):
        # The ID of the premium bandwidth plan.
        self.network_package_id = network_package_id
        # The ID of the bill.
        self.order_id = order_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNetworkPackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNetworkPackageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNetworkPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePolicyGroupRequestAuthorizeAccessPolicyRule(TeaModel):
    def __init__(
        self,
        cidr_ip: str = None,
        description: str = None,
    ):
        # The client CIDR block from which end users can connect to cloud computers. The value is an IPv4 CIDR block.
        self.cidr_ip = cidr_ip
        # The description of the client IP address whitelist.
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_ip is not None:
            result['CidrIp'] = self.cidr_ip
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrIp') is not None:
            self.cidr_ip = m.get('CidrIp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreatePolicyGroupRequestAuthorizeSecurityPolicyRule(TeaModel):
    def __init__(
        self,
        cidr_ip: str = None,
        description: str = None,
        ip_protocol: str = None,
        policy: str = None,
        port_range: str = None,
        priority: str = None,
        type: str = None,
    ):
        # The object to which the security group rule applies. The value is an IPv4 CIDR block.
        self.cidr_ip = cidr_ip
        # The description of the security group rule.
        self.description = description
        # The protocol type of the security group rule.
        # 
        # Valid values:
        # 
        # *   TCP: the Transmission Control Protocol (TCP) protocol.
        # *   UDP: the User Datagram Protocol (UDP) protocol.
        # *   ALL: all protocols.
        # *   GRE: the Generic Routing Encapsulation (GRE) protocol.
        # *   ICMP: the Internet Control Message Protocol (ICMP) for IPv4.
        self.ip_protocol = ip_protocol
        # The authorization of the security group rule.
        # 
        # Valid values:
        # 
        # *   drop: denies all access requests. If no messages of access denied are returned, the requests timed out or failed.
        # *   accept (default): accepts all requests.
        self.policy = policy
        # The port range of the security group rule. The value range of this parameter varies based on the value of the IpProtocol parameter.
        # 
        # *   If the IpProtocol parameter is set to TCP or UDP, the port range is 1 to 65535. Separate the start port number and the end port number with a forward slash (/). Example: 1/200.
        # *   If the IpProtocol parameter is set to ICMP, set the value to -1/-1.
        # *   If the IpProtocol parameter is set to GRE, set the value to -1/-1.
        # *   If the IpProtocol parameter is set to ALL, set the value to -1/-1.
        # 
        # For more information about the common ports applied in EDS, see [Common ports](https://help.aliyun.com/document_detail/40724.html).
        self.port_range = port_range
        # The priority of the security group rule. A smaller value indicates a higher priority.\\
        # Valid values: 1 to 60.\\
        # Default value: 1.
        self.priority = priority
        # The direction of the security group rule.
        # 
        # Valid values:
        # 
        # *   outflow: outbound.
        # *   inflow: inbound.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_ip is not None:
            result['CidrIp'] = self.cidr_ip
        if self.description is not None:
            result['Description'] = self.description
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrIp') is not None:
            self.cidr_ip = m.get('CidrIp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreatePolicyGroupRequestClientType(TeaModel):
    def __init__(
        self,
        client_type: str = None,
        status: str = None,
    ):
        # The type of the Alibaba Cloud Workspace client.
        # 
        # >  If you do not specify the `ClientType` parameter, all types of the client are allowed by default.
        # 
        # Valid values:
        # 
        # *   html5: web client
        # *   android: Android client
        # *   ios: iOS client
        # *   windows: Windows client
        # *   macos: macOS client
        self.client_type = client_type
        # Specifies whether to allow end users to use a specific type of the client to connect to cloud computers.
        # 
        # >  If you do not specify the `ClientType` parameter, all types of the client are allowed by default.
        # 
        # Valid values:
        # 
        # *   OFF
        # *   ON
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreatePolicyGroupRequestDeviceRedirects(TeaModel):
    def __init__(
        self,
        device_type: str = None,
        redirect_type: str = None,
    ):
        # The peripheral type.
        # 
        # Valid values:
        # 
        # *   printer
        # *   scanner
        # *   camera
        # *   adb: the Android Debug Bridge (ADB) device.
        self.device_type = device_type
        # The redirection type.
        # 
        # Valid values:
        # 
        # *   deviceRedirect: device redirection
        # *   usbRedirect: USB redirection
        # *   off: redirection disabled
        self.redirect_type = redirect_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.redirect_type is not None:
            result['RedirectType'] = self.redirect_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('RedirectType') is not None:
            self.redirect_type = m.get('RedirectType')
        return self


class CreatePolicyGroupRequestDeviceRules(TeaModel):
    def __init__(
        self,
        device_name: str = None,
        device_pid: str = None,
        device_type: str = None,
        device_vid: str = None,
        opt_command: str = None,
        redirect_type: str = None,
    ):
        # The device name.
        self.device_name = device_name
        # The product ID.
        self.device_pid = device_pid
        # The peripheral type.
        # 
        # Valid values:
        # 
        # *   usbKey
        # *   other
        # *   graphicsTablet
        # *   printer
        # *   cardReader
        # *   scanner
        # *   storage
        # *   camera
        # *   adb
        # *   networkInterfaceCard: the NIC device.
        self.device_type = device_type
        # The vendor ID (VID). For more information, see [Valid USB VIDs](https://www.usb.org/sites/default/files/vendor_ids032322.pdf_1.pdf).
        self.device_vid = device_vid
        # The link optimization command.
        self.opt_command = opt_command
        # The redirection type.
        # 
        # Valid values:
        # 
        # *   deviceRedirect: device redirection
        # *   usbRedirect: USB redirection
        # *   off: redirection disabled
        self.redirect_type = redirect_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_pid is not None:
            result['DevicePid'] = self.device_pid
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.device_vid is not None:
            result['DeviceVid'] = self.device_vid
        if self.opt_command is not None:
            result['OptCommand'] = self.opt_command
        if self.redirect_type is not None:
            result['RedirectType'] = self.redirect_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DevicePid') is not None:
            self.device_pid = m.get('DevicePid')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('DeviceVid') is not None:
            self.device_vid = m.get('DeviceVid')
        if m.get('OptCommand') is not None:
            self.opt_command = m.get('OptCommand')
        if m.get('RedirectType') is not None:
            self.redirect_type = m.get('RedirectType')
        return self


class CreatePolicyGroupRequestDomainResolveRule(TeaModel):
    def __init__(
        self,
        description: str = None,
        domain: str = None,
        policy: str = None,
    ):
        # The description of domain name resolution rule.
        self.description = description
        # The domain name.
        self.domain = domain
        # Specifies whether to allow the domain name resolution rule.
        # 
        # Valid values:
        # 
        # *   allow: allows the rule.
        # *   block: denies the rule.
        self.policy = policy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.policy is not None:
            result['Policy'] = self.policy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        return self


class CreatePolicyGroupRequestUsbSupplyRedirectRule(TeaModel):
    def __init__(
        self,
        description: str = None,
        device_class: str = None,
        device_subclass: str = None,
        product_id: str = None,
        usb_redirect_type: int = None,
        usb_rule_type: int = None,
        vendor_id: str = None,
    ):
        # The description of the rule.
        self.description = description
        # The class of the device. If you set the `usbRuleType` parameter to 1, you must specify this parameter. For more information, see [Defined Class Codes](https://www.usb.org/defined-class-codes).
        self.device_class = device_class
        # The subclass of the device. If you set the `usbRuleType` parameter to 1, you must specify this parameter. For more information, see [Defined Class Codes](https://www.usb.org/defined-class-codes).
        self.device_subclass = device_subclass
        # The ID of the service.
        self.product_id = product_id
        # The type of USB redirection.
        # 
        # Valid values:
        # 
        # *   1: allows USB redirection
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   2: forbids USB redirection
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.usb_redirect_type = usb_redirect_type
        # The type of the USB redirection rule.
        # 
        # Valid values:
        # 
        # *   1: by device class
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   2: by device vendor
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.usb_rule_type = usb_rule_type
        # The ID of the vendor. For more information, see [Valid USB Vendor IDs (VIDs)](https://www.usb.org/sites/default/files/vendor_ids032322.pdf_1.pdf).
        self.vendor_id = vendor_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.device_class is not None:
            result['DeviceClass'] = self.device_class
        if self.device_subclass is not None:
            result['DeviceSubclass'] = self.device_subclass
        if self.product_id is not None:
            result['ProductId'] = self.product_id
        if self.usb_redirect_type is not None:
            result['UsbRedirectType'] = self.usb_redirect_type
        if self.usb_rule_type is not None:
            result['UsbRuleType'] = self.usb_rule_type
        if self.vendor_id is not None:
            result['VendorId'] = self.vendor_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceClass') is not None:
            self.device_class = m.get('DeviceClass')
        if m.get('DeviceSubclass') is not None:
            self.device_subclass = m.get('DeviceSubclass')
        if m.get('ProductId') is not None:
            self.product_id = m.get('ProductId')
        if m.get('UsbRedirectType') is not None:
            self.usb_redirect_type = m.get('UsbRedirectType')
        if m.get('UsbRuleType') is not None:
            self.usb_rule_type = m.get('UsbRuleType')
        if m.get('VendorId') is not None:
            self.vendor_id = m.get('VendorId')
        return self


class CreatePolicyGroupRequest(TeaModel):
    def __init__(
        self,
        admin_access: str = None,
        app_content_protection: str = None,
        authorize_access_policy_rule: List[CreatePolicyGroupRequestAuthorizeAccessPolicyRule] = None,
        authorize_security_policy_rule: List[CreatePolicyGroupRequestAuthorizeSecurityPolicyRule] = None,
        camera_redirect: str = None,
        client_type: List[CreatePolicyGroupRequestClientType] = None,
        clipboard: str = None,
        device_redirects: List[CreatePolicyGroupRequestDeviceRedirects] = None,
        device_rules: List[CreatePolicyGroupRequestDeviceRules] = None,
        domain_list: str = None,
        domain_resolve_rule: List[CreatePolicyGroupRequestDomainResolveRule] = None,
        domain_resolve_rule_type: str = None,
        end_user_apply_admin_coordinate: str = None,
        end_user_group_coordinate: str = None,
        gpu_acceleration: str = None,
        html_5access: str = None,
        html_5file_transfer: str = None,
        internet_communication_protocol: str = None,
        local_drive: str = None,
        max_reconnect_time: int = None,
        name: str = None,
        net_redirect: str = None,
        preempt_login: str = None,
        preempt_login_user: List[str] = None,
        printer_redirection: str = None,
        record_content: str = None,
        record_content_expires: int = None,
        recording: str = None,
        recording_audio: str = None,
        recording_duration: int = None,
        recording_end_time: str = None,
        recording_expires: int = None,
        recording_fps: int = None,
        recording_start_time: str = None,
        recording_user_notify: str = None,
        recording_user_notify_message: str = None,
        region_id: str = None,
        remote_coordinate: str = None,
        scope: str = None,
        scope_value: List[str] = None,
        usb_redirect: str = None,
        usb_supply_redirect_rule: List[CreatePolicyGroupRequestUsbSupplyRedirectRule] = None,
        video_redirect: str = None,
        visual_quality: str = None,
        watermark: str = None,
        watermark_anti_cam: str = None,
        watermark_color: int = None,
        watermark_degree: float = None,
        watermark_font_size: int = None,
        watermark_font_style: str = None,
        watermark_power: str = None,
        watermark_row_amount: int = None,
        watermark_security: str = None,
        watermark_transparency: str = None,
        watermark_transparency_value: int = None,
        watermark_type: str = None,
        wy_assistant: str = None,
    ):
        # Specifies whether end users have the administrator permissions.
        # 
        # >  This parameter is in invitational preview for specific users and not available to the public.
        self.admin_access = admin_access
        # Specifies whether to enable the anti-screenshot feature.
        # 
        # Valid values:
        # 
        # *   off: Anti-screenshot is disabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: Anti-screenshot is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.app_content_protection = app_content_protection
        # The client IP address whitelist. After you configure the whitelist, end users can access cloud computers only from the IP addresses in the whitelist.
        self.authorize_access_policy_rule = authorize_access_policy_rule
        # The security group rules.
        self.authorize_security_policy_rule = authorize_security_policy_rule
        # Specifies whether to enable the webcam redirection feature.
        # 
        # Valid values:
        # 
        # *   off: Webcam redirection is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: Webcam redirection is enabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.camera_redirect = camera_redirect
        # The logon method control rules to limit the type of the Alibaba Cloud Workspace client used by end users to connect to cloud computers.
        self.client_type = client_type
        # The permissions on the clipboard.
        # 
        # Valid values:
        # 
        # *   read: specifies one-way transfer. You can copy files only from local devices to cloud computers.
        # *   readwrite: specifies two-way transfer. You can copy files between local devices and cloud computers.
        # *   write: specifies one-way transfer. You can only copy files from cloud computers to local devices.
        # *   off (default): disables both one-way and two-way transfer. Files cannot be copied between local devices and cloud computers.
        self.clipboard = clipboard
        # The device redirection rules.
        self.device_redirects = device_redirects
        # The custom peripheral rules.
        self.device_rules = device_rules
        # Specifies whether the access control for domain names is enabled. Domain names support wildcards (\\*). Separate multiple domain names with commas (,).
        # 
        # Valid values:
        # 
        # *   off
        # *   on
        self.domain_list = domain_list
        # The details of the domain name resolution rule.
        self.domain_resolve_rule = domain_resolve_rule
        # The type of the domain name resolution policy.
        # 
        # Valid values:
        # 
        # *   OFF
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ON
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.domain_resolve_rule_type = domain_resolve_rule_type
        # Specifies whether to turn on the Contact Administrator for Help switch.
        # 
        # Valid values:
        # 
        # *   OFF
        # *   ON
        self.end_user_apply_admin_coordinate = end_user_apply_admin_coordinate
        # Specifies whether to turn on the User Stream Collaboration switch.
        # 
        # Valid values:
        # 
        # *   OFF
        # *   ON
        self.end_user_group_coordinate = end_user_group_coordinate
        # Specifies whether to enable the Image Quality Control feature. If you have high requirements on the performance and user experience in scenarios such as professional design, we recommend that you enable this feature.
        # 
        # Valid values:
        # 
        # *   off
        # *   on
        self.gpu_acceleration = gpu_acceleration
        # Specifies whether to allow web client access.
        # 
        # >  We recommend that you use the ClientType-related parameters to control the Alibaba Cloud Workspace client type for cloud computer logon.``
        # 
        # Valid values:
        # 
        # *   off (default)
        # *   on
        self.html_5access = html_5access
        # The file transfer feature on the web client.
        # 
        # Valid values:
        # 
        # *   all: Files can be uploaded and downloaded between local computers and the web client.
        # *   download: Files on the web client can be downloaded to local computers.
        # *   upload: Files on local computers can be uploaded to the web client.
        # *   off (default): Files cannot be transferred between the web client and local computers.
        self.html_5file_transfer = html_5file_transfer
        # The protocol for network communication.
        # 
        # Valid values:
        # 
        # *   TCP (default): TCP
        # *   BOTH: TCP and UDP
        self.internet_communication_protocol = internet_communication_protocol
        # The permissions on local disk mapping.
        # 
        # Valid values:
        # 
        # *   read: read-only. Local disk mapping is available on cloud computers. However, you can only read (copy) local files but cannot modify the files.
        # *   readwrite: read and write. Local disk mapping is available on cloud computers. You can read (copy) and write (modify) local files.
        # *   off (default): disabled. Local disk mapping is unavailable on cloud computers.
        self.local_drive = local_drive
        # The maximum retry period for reconnecting to cloud computers when the cloud computers are disconnected due to none-human reasons. Valid values: 30 to 7200. Unit: seconds.
        self.max_reconnect_time = max_reconnect_time
        # The name of the policy.
        self.name = name
        # Specifies whether to enable the network redirection feature.
        # 
        # > This feature is in invitational preview and is not available to the public.
        # 
        # Valid values:
        # 
        # *   off (default): The network redirection feature is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: The network redirection feature is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.net_redirect = net_redirect
        # The cloud computer preemption feature.
        # 
        # >  To ensure user experience and data security, when a cloud computer is used by an end user, other end users cannot connect to the cloud computer. By default, this parameter is set to `off`, which cannot be modified.
        # 
        # Valid values:
        # 
        # *   off (default): Multiple end users cannot connect to the same cloud computer at the same time.
        self.preempt_login = preempt_login
        # The usernames that are allowed to connect to the cloud computer in use. You can specify up to five usernames.
        # 
        # >  To ensure user experience and data security, other end users cannot connect to the cloud computer that is used by an end user.
        self.preempt_login_user = preempt_login_user
        # The policy for printer redirection.
        # 
        # Valid values:
        # 
        # *   off: Printer redirection is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: Printer redirection is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.printer_redirection = printer_redirection
        # Specifies whether to enable the custom screen recording feature.
        # 
        # Valid values:
        # 
        # *   off: Custom screen recording is disabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: Custom screen recording is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.record_content = record_content
        # The duration in which the custom screen recording is valid. Default value: 30. Unit: days.
        self.record_content_expires = record_content_expires
        # Specifies whether to enable the screen recording feature.
        # 
        # Valid values:
        # 
        # *   byaction_cmd_ft: enables the operation-triggered screen recording upon command execution and file transfer.
        # *   ALLTIME: enables the whole-process screen recording. That is, the recording starts when cloud computers are connected and ends when the cloud computers are disconnected.
        # *   session: enables the screen recording for session lifecycle listening.
        # *   PERIOD: enables the interval-based screen recording. You must specify an interval between the start time and end time of this type of recording.
        # *   byaction_commands: enables the operation-triggered screen recording upon command execution.
        # *   OFF: disables the screen recording feature.
        # *   byaction_file_transfer: enables the operation-triggered screen recording upon file transfer.
        self.recording = recording
        # Specifies whether to record audio files generated from cloud computers.
        # 
        # Valid values:
        # 
        # *   off: records only video files.
        # *   on: records video and audio files.
        self.recording_audio = recording_audio
        # The file length of the screen recording. Unit: minutes. Screen recording files are split based on the specified file length and uploaded to Object Storage Service (OSS) buckets. When a screen recording file reaches 300 MB in size, the system preferentially performs rolling update for the file.
        # 
        # Valid values:
        # 
        # *   10
        # *   20
        # *   30
        # *   60
        self.recording_duration = recording_duration
        # The time when the screen recording ends. The value is in the HH:MM:SS format. The value is meaningful only when you set the `Recording` parameter to `PERIOD`.
        self.recording_end_time = recording_end_time
        # The retention period of the screen recording file. Valid values: 1 to 180. Unit: days.
        self.recording_expires = recording_expires
        # The frame rate of screen recording. Unit: fps.
        # 
        # Valid values:
        # 
        # *   2
        # *   5
        # *   10
        # *   15
        self.recording_fps = recording_fps
        # The time when the screen recording starts. The value is in the HH:MM:SS format. The value is meaningful only when you set the `Recording` parameter to `PERIOD`.
        self.recording_start_time = recording_start_time
        # Specifies whether to enable the screen recording notification feature after end users log on to the Alibaba Cloud Workspace client.
        # 
        # Valid values:
        # 
        # *   off
        # *   on
        self.recording_user_notify = recording_user_notify
        # The notification content of screen recording. By default, this parameter is left empty.
        self.recording_user_notify_message = recording_user_notify_message
        # The region ID. You can call the [DescribeRegions](~~DescribeRegions~~) operation to query the regions supported by Elastic Desktop Service (EDS).
        # 
        # This parameter is required.
        self.region_id = region_id
        # The permission to control the keyboard and the mouse during remote assistance.
        # 
        # Valid values:
        # 
        # *    optionalControl: By default, this feature is disabled. You can enable it by applying permissions.
        # 
        # *   fullControl: The permission is granted.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   disableControl: The permission is revoked.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.remote_coordinate = remote_coordinate
        # The effective scope of the policy.
        # 
        # Valid values:
        # 
        # *   IP: The policy takes effect based on the IP address.
        # *   GLOBAL: The policy takes effect globally.
        self.scope = scope
        # This parameter is required when the `Scope` parameter is set to `IP`.````
        self.scope_value = scope_value
        # Specifies whether to enable USB redirection.
        # 
        # Valid values:
        # 
        # *   off: USB redirection is disabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: USB redirection is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.usb_redirect = usb_redirect
        # The USB redirection rules.
        self.usb_supply_redirect_rule = usb_supply_redirect_rule
        # Specifies whether to enable the multimedia redirection switch.
        # 
        # Valid values:
        # 
        # *   off
        # *   on
        self.video_redirect = video_redirect
        # The policy for image display quality.
        # 
        # Valid values:
        # 
        # *   high
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   low
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   lossless
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   medium: adaptive. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.visual_quality = visual_quality
        # The watermarking feature.
        # 
        # Valid values:
        # 
        # *   blind: Invisible watermarks are applied.
        # *   off (default): The watermarking feature is disabled.
        # *   on: Visible watermarks are applied.
        self.watermark = watermark
        # Specifies whether to enable the anti-screen photo feature for invisible watermarks.
        # 
        # Valid values:
        # 
        # *   off
        # *   on
        self.watermark_anti_cam = watermark_anti_cam
        # The font color in red, green, and blue (RGB) of the watermark. Valid values: 0 to 16777215.
        self.watermark_color = watermark_color
        # The watermark rotation. Valid values: -10 to -30.
        self.watermark_degree = watermark_degree
        # The watermark font size. Valid values: 10 to 20.
        self.watermark_font_size = watermark_font_size
        # The watermark font style.
        # 
        # Valid values:
        # 
        # *   plain
        # *   bold
        self.watermark_font_style = watermark_font_style
        # The watermark enhancement feature.
        # 
        # Valid values:
        # 
        # *   high
        # *   low
        # *   medium
        self.watermark_power = watermark_power
        # The number of watermark rows.
        # 
        # >  This parameter is not available for public use.
        self.watermark_row_amount = watermark_row_amount
        # Specifies whether to enable the security priority feature for invisible watermarks.
        # 
        # Valid values:
        # 
        # *   off
        # *   on
        self.watermark_security = watermark_security
        # The transparency of the watermark.
        # 
        # Valid values:
        # 
        # *   LIGHT
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DARK
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   MIDDLE
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.watermark_transparency = watermark_transparency
        # The watermark opacity. A larger value indicates more opaque watermarks. Valid values: 10 to 100.
        self.watermark_transparency_value = watermark_transparency_value
        # The watermark content. You can select up to three items as the watermark content. Separate multiple items with commas (,).
        # 
        # >  If you set this parameter to `Custom`, specify `WatermarkCustomText`
        # 
        # Valid values:
        # 
        # *   EndUserId: the username.
        # *   Custom: the custom text.
        # *   DesktopIp: the IP address of the cloud computer.
        # *   ClientIp: the IP address of the Alibaba Cloud Workspace client.
        # *   HostName: the rightmost 15 digits of the cloud computer ID.
        # *   ClientTime: the current time displayed on the cloud computer.
        self.watermark_type = watermark_type
        # Specifies whether to provide the AI Assistant function in the DesktopAssistant when the cloud computer is accessed from the Alibaba Cloud Workspace desktop clients (including the Windows client and the macOS client).
        # 
        # > Desktop clients of V7.7 and higher versions required.
        # 
        # Valid values:
        # 
        # - off: the AI Aisstant function is not provided.
        # - on: the AI Aisstant function is provided.
        self.wy_assistant = wy_assistant

    def validate(self):
        if self.authorize_access_policy_rule:
            for k in self.authorize_access_policy_rule:
                if k:
                    k.validate()
        if self.authorize_security_policy_rule:
            for k in self.authorize_security_policy_rule:
                if k:
                    k.validate()
        if self.client_type:
            for k in self.client_type:
                if k:
                    k.validate()
        if self.device_redirects:
            for k in self.device_redirects:
                if k:
                    k.validate()
        if self.device_rules:
            for k in self.device_rules:
                if k:
                    k.validate()
        if self.domain_resolve_rule:
            for k in self.domain_resolve_rule:
                if k:
                    k.validate()
        if self.usb_supply_redirect_rule:
            for k in self.usb_supply_redirect_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.admin_access is not None:
            result['AdminAccess'] = self.admin_access
        if self.app_content_protection is not None:
            result['AppContentProtection'] = self.app_content_protection
        result['AuthorizeAccessPolicyRule'] = []
        if self.authorize_access_policy_rule is not None:
            for k in self.authorize_access_policy_rule:
                result['AuthorizeAccessPolicyRule'].append(k.to_map() if k else None)
        result['AuthorizeSecurityPolicyRule'] = []
        if self.authorize_security_policy_rule is not None:
            for k in self.authorize_security_policy_rule:
                result['AuthorizeSecurityPolicyRule'].append(k.to_map() if k else None)
        if self.camera_redirect is not None:
            result['CameraRedirect'] = self.camera_redirect
        result['ClientType'] = []
        if self.client_type is not None:
            for k in self.client_type:
                result['ClientType'].append(k.to_map() if k else None)
        if self.clipboard is not None:
            result['Clipboard'] = self.clipboard
        result['DeviceRedirects'] = []
        if self.device_redirects is not None:
            for k in self.device_redirects:
                result['DeviceRedirects'].append(k.to_map() if k else None)
        result['DeviceRules'] = []
        if self.device_rules is not None:
            for k in self.device_rules:
                result['DeviceRules'].append(k.to_map() if k else None)
        if self.domain_list is not None:
            result['DomainList'] = self.domain_list
        result['DomainResolveRule'] = []
        if self.domain_resolve_rule is not None:
            for k in self.domain_resolve_rule:
                result['DomainResolveRule'].append(k.to_map() if k else None)
        if self.domain_resolve_rule_type is not None:
            result['DomainResolveRuleType'] = self.domain_resolve_rule_type
        if self.end_user_apply_admin_coordinate is not None:
            result['EndUserApplyAdminCoordinate'] = self.end_user_apply_admin_coordinate
        if self.end_user_group_coordinate is not None:
            result['EndUserGroupCoordinate'] = self.end_user_group_coordinate
        if self.gpu_acceleration is not None:
            result['GpuAcceleration'] = self.gpu_acceleration
        if self.html_5access is not None:
            result['Html5Access'] = self.html_5access
        if self.html_5file_transfer is not None:
            result['Html5FileTransfer'] = self.html_5file_transfer
        if self.internet_communication_protocol is not None:
            result['InternetCommunicationProtocol'] = self.internet_communication_protocol
        if self.local_drive is not None:
            result['LocalDrive'] = self.local_drive
        if self.max_reconnect_time is not None:
            result['MaxReconnectTime'] = self.max_reconnect_time
        if self.name is not None:
            result['Name'] = self.name
        if self.net_redirect is not None:
            result['NetRedirect'] = self.net_redirect
        if self.preempt_login is not None:
            result['PreemptLogin'] = self.preempt_login
        if self.preempt_login_user is not None:
            result['PreemptLoginUser'] = self.preempt_login_user
        if self.printer_redirection is not None:
            result['PrinterRedirection'] = self.printer_redirection
        if self.record_content is not None:
            result['RecordContent'] = self.record_content
        if self.record_content_expires is not None:
            result['RecordContentExpires'] = self.record_content_expires
        if self.recording is not None:
            result['Recording'] = self.recording
        if self.recording_audio is not None:
            result['RecordingAudio'] = self.recording_audio
        if self.recording_duration is not None:
            result['RecordingDuration'] = self.recording_duration
        if self.recording_end_time is not None:
            result['RecordingEndTime'] = self.recording_end_time
        if self.recording_expires is not None:
            result['RecordingExpires'] = self.recording_expires
        if self.recording_fps is not None:
            result['RecordingFps'] = self.recording_fps
        if self.recording_start_time is not None:
            result['RecordingStartTime'] = self.recording_start_time
        if self.recording_user_notify is not None:
            result['RecordingUserNotify'] = self.recording_user_notify
        if self.recording_user_notify_message is not None:
            result['RecordingUserNotifyMessage'] = self.recording_user_notify_message
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.remote_coordinate is not None:
            result['RemoteCoordinate'] = self.remote_coordinate
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.scope_value is not None:
            result['ScopeValue'] = self.scope_value
        if self.usb_redirect is not None:
            result['UsbRedirect'] = self.usb_redirect
        result['UsbSupplyRedirectRule'] = []
        if self.usb_supply_redirect_rule is not None:
            for k in self.usb_supply_redirect_rule:
                result['UsbSupplyRedirectRule'].append(k.to_map() if k else None)
        if self.video_redirect is not None:
            result['VideoRedirect'] = self.video_redirect
        if self.visual_quality is not None:
            result['VisualQuality'] = self.visual_quality
        if self.watermark is not None:
            result['Watermark'] = self.watermark
        if self.watermark_anti_cam is not None:
            result['WatermarkAntiCam'] = self.watermark_anti_cam
        if self.watermark_color is not None:
            result['WatermarkColor'] = self.watermark_color
        if self.watermark_degree is not None:
            result['WatermarkDegree'] = self.watermark_degree
        if self.watermark_font_size is not None:
            result['WatermarkFontSize'] = self.watermark_font_size
        if self.watermark_font_style is not None:
            result['WatermarkFontStyle'] = self.watermark_font_style
        if self.watermark_power is not None:
            result['WatermarkPower'] = self.watermark_power
        if self.watermark_row_amount is not None:
            result['WatermarkRowAmount'] = self.watermark_row_amount
        if self.watermark_security is not None:
            result['WatermarkSecurity'] = self.watermark_security
        if self.watermark_transparency is not None:
            result['WatermarkTransparency'] = self.watermark_transparency
        if self.watermark_transparency_value is not None:
            result['WatermarkTransparencyValue'] = self.watermark_transparency_value
        if self.watermark_type is not None:
            result['WatermarkType'] = self.watermark_type
        if self.wy_assistant is not None:
            result['WyAssistant'] = self.wy_assistant
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdminAccess') is not None:
            self.admin_access = m.get('AdminAccess')
        if m.get('AppContentProtection') is not None:
            self.app_content_protection = m.get('AppContentProtection')
        self.authorize_access_policy_rule = []
        if m.get('AuthorizeAccessPolicyRule') is not None:
            for k in m.get('AuthorizeAccessPolicyRule'):
                temp_model = CreatePolicyGroupRequestAuthorizeAccessPolicyRule()
                self.authorize_access_policy_rule.append(temp_model.from_map(k))
        self.authorize_security_policy_rule = []
        if m.get('AuthorizeSecurityPolicyRule') is not None:
            for k in m.get('AuthorizeSecurityPolicyRule'):
                temp_model = CreatePolicyGroupRequestAuthorizeSecurityPolicyRule()
                self.authorize_security_policy_rule.append(temp_model.from_map(k))
        if m.get('CameraRedirect') is not None:
            self.camera_redirect = m.get('CameraRedirect')
        self.client_type = []
        if m.get('ClientType') is not None:
            for k in m.get('ClientType'):
                temp_model = CreatePolicyGroupRequestClientType()
                self.client_type.append(temp_model.from_map(k))
        if m.get('Clipboard') is not None:
            self.clipboard = m.get('Clipboard')
        self.device_redirects = []
        if m.get('DeviceRedirects') is not None:
            for k in m.get('DeviceRedirects'):
                temp_model = CreatePolicyGroupRequestDeviceRedirects()
                self.device_redirects.append(temp_model.from_map(k))
        self.device_rules = []
        if m.get('DeviceRules') is not None:
            for k in m.get('DeviceRules'):
                temp_model = CreatePolicyGroupRequestDeviceRules()
                self.device_rules.append(temp_model.from_map(k))
        if m.get('DomainList') is not None:
            self.domain_list = m.get('DomainList')
        self.domain_resolve_rule = []
        if m.get('DomainResolveRule') is not None:
            for k in m.get('DomainResolveRule'):
                temp_model = CreatePolicyGroupRequestDomainResolveRule()
                self.domain_resolve_rule.append(temp_model.from_map(k))
        if m.get('DomainResolveRuleType') is not None:
            self.domain_resolve_rule_type = m.get('DomainResolveRuleType')
        if m.get('EndUserApplyAdminCoordinate') is not None:
            self.end_user_apply_admin_coordinate = m.get('EndUserApplyAdminCoordinate')
        if m.get('EndUserGroupCoordinate') is not None:
            self.end_user_group_coordinate = m.get('EndUserGroupCoordinate')
        if m.get('GpuAcceleration') is not None:
            self.gpu_acceleration = m.get('GpuAcceleration')
        if m.get('Html5Access') is not None:
            self.html_5access = m.get('Html5Access')
        if m.get('Html5FileTransfer') is not None:
            self.html_5file_transfer = m.get('Html5FileTransfer')
        if m.get('InternetCommunicationProtocol') is not None:
            self.internet_communication_protocol = m.get('InternetCommunicationProtocol')
        if m.get('LocalDrive') is not None:
            self.local_drive = m.get('LocalDrive')
        if m.get('MaxReconnectTime') is not None:
            self.max_reconnect_time = m.get('MaxReconnectTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetRedirect') is not None:
            self.net_redirect = m.get('NetRedirect')
        if m.get('PreemptLogin') is not None:
            self.preempt_login = m.get('PreemptLogin')
        if m.get('PreemptLoginUser') is not None:
            self.preempt_login_user = m.get('PreemptLoginUser')
        if m.get('PrinterRedirection') is not None:
            self.printer_redirection = m.get('PrinterRedirection')
        if m.get('RecordContent') is not None:
            self.record_content = m.get('RecordContent')
        if m.get('RecordContentExpires') is not None:
            self.record_content_expires = m.get('RecordContentExpires')
        if m.get('Recording') is not None:
            self.recording = m.get('Recording')
        if m.get('RecordingAudio') is not None:
            self.recording_audio = m.get('RecordingAudio')
        if m.get('RecordingDuration') is not None:
            self.recording_duration = m.get('RecordingDuration')
        if m.get('RecordingEndTime') is not None:
            self.recording_end_time = m.get('RecordingEndTime')
        if m.get('RecordingExpires') is not None:
            self.recording_expires = m.get('RecordingExpires')
        if m.get('RecordingFps') is not None:
            self.recording_fps = m.get('RecordingFps')
        if m.get('RecordingStartTime') is not None:
            self.recording_start_time = m.get('RecordingStartTime')
        if m.get('RecordingUserNotify') is not None:
            self.recording_user_notify = m.get('RecordingUserNotify')
        if m.get('RecordingUserNotifyMessage') is not None:
            self.recording_user_notify_message = m.get('RecordingUserNotifyMessage')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RemoteCoordinate') is not None:
            self.remote_coordinate = m.get('RemoteCoordinate')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('ScopeValue') is not None:
            self.scope_value = m.get('ScopeValue')
        if m.get('UsbRedirect') is not None:
            self.usb_redirect = m.get('UsbRedirect')
        self.usb_supply_redirect_rule = []
        if m.get('UsbSupplyRedirectRule') is not None:
            for k in m.get('UsbSupplyRedirectRule'):
                temp_model = CreatePolicyGroupRequestUsbSupplyRedirectRule()
                self.usb_supply_redirect_rule.append(temp_model.from_map(k))
        if m.get('VideoRedirect') is not None:
            self.video_redirect = m.get('VideoRedirect')
        if m.get('VisualQuality') is not None:
            self.visual_quality = m.get('VisualQuality')
        if m.get('Watermark') is not None:
            self.watermark = m.get('Watermark')
        if m.get('WatermarkAntiCam') is not None:
            self.watermark_anti_cam = m.get('WatermarkAntiCam')
        if m.get('WatermarkColor') is not None:
            self.watermark_color = m.get('WatermarkColor')
        if m.get('WatermarkDegree') is not None:
            self.watermark_degree = m.get('WatermarkDegree')
        if m.get('WatermarkFontSize') is not None:
            self.watermark_font_size = m.get('WatermarkFontSize')
        if m.get('WatermarkFontStyle') is not None:
            self.watermark_font_style = m.get('WatermarkFontStyle')
        if m.get('WatermarkPower') is not None:
            self.watermark_power = m.get('WatermarkPower')
        if m.get('WatermarkRowAmount') is not None:
            self.watermark_row_amount = m.get('WatermarkRowAmount')
        if m.get('WatermarkSecurity') is not None:
            self.watermark_security = m.get('WatermarkSecurity')
        if m.get('WatermarkTransparency') is not None:
            self.watermark_transparency = m.get('WatermarkTransparency')
        if m.get('WatermarkTransparencyValue') is not None:
            self.watermark_transparency_value = m.get('WatermarkTransparencyValue')
        if m.get('WatermarkType') is not None:
            self.watermark_type = m.get('WatermarkType')
        if m.get('WyAssistant') is not None:
            self.wy_assistant = m.get('WyAssistant')
        return self


class CreatePolicyGroupResponseBody(TeaModel):
    def __init__(
        self,
        policy_group_id: str = None,
        request_id: str = None,
    ):
        # The cloud computer policy ID.
        self.policy_group_id = policy_group_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePolicyGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePolicyGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePolicyGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRAMDirectoryRequest(TeaModel):
    def __init__(
        self,
        desktop_access_type: str = None,
        directory_name: str = None,
        enable_admin_access: bool = None,
        enable_internet_access: bool = None,
        region_id: str = None,
        v_switch_id: List[str] = None,
    ):
        # The method in which the cloud computer is connected.
        # 
        # Valid values:
        # 
        # *   VPC
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Internet (default)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Any
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.desktop_access_type = desktop_access_type
        # The directory name. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. The name can contain digits, colons (:), underscores (_), and hyphens (-).
        # 
        # This parameter is required.
        self.directory_name = directory_name
        # Specifies whether to grant the local administrator permissions to users that are authorized to use cloud computers in the office network.
        # 
        # Valid values:
        # 
        # *   <!-- -->
        # 
        #     true
        # 
        #     <!-- -->
        # 
        #     (default)
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.enable_admin_access = enable_admin_access
        # Specifies whether to enable Internet access.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.enable_internet_access = enable_internet_access
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The vSwitch IDs. You can configure only one vSwitch.
        # 
        # This parameter is required.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_access_type is not None:
            result['DesktopAccessType'] = self.desktop_access_type
        if self.directory_name is not None:
            result['DirectoryName'] = self.directory_name
        if self.enable_admin_access is not None:
            result['EnableAdminAccess'] = self.enable_admin_access
        if self.enable_internet_access is not None:
            result['EnableInternetAccess'] = self.enable_internet_access
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopAccessType') is not None:
            self.desktop_access_type = m.get('DesktopAccessType')
        if m.get('DirectoryName') is not None:
            self.directory_name = m.get('DirectoryName')
        if m.get('EnableAdminAccess') is not None:
            self.enable_admin_access = m.get('EnableAdminAccess')
        if m.get('EnableInternetAccess') is not None:
            self.enable_internet_access = m.get('EnableInternetAccess')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateRAMDirectoryResponseBody(TeaModel):
    def __init__(
        self,
        directory_id: str = None,
        request_id: str = None,
    ):
        # The RAM directory ID.
        self.directory_id = directory_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRAMDirectoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRAMDirectoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRAMDirectoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSimpleOfficeSiteRequest(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        cen_id: str = None,
        cen_owner_id: int = None,
        cidr_block: str = None,
        cloud_box_office_site: bool = None,
        desktop_access_type: str = None,
        enable_admin_access: bool = None,
        enable_internet_access: bool = None,
        need_verify_zero_device: bool = None,
        office_site_name: str = None,
        region_id: str = None,
        v_switch_id: List[str] = None,
        verify_code: str = None,
        vpc_type: str = None,
    ):
        # The maximum public bandwidth. Value range: 10 to 200. Unit: Mbit/s. This parameter is available if you set `EnableInternetAccess` to `true`.
        self.bandwidth = bandwidth
        # The Cloud Enterprise Network (CEN) instance ID.
        # 
        # >  If you want end users to connect to cloud computers from Alibaba Cloud Workspace clients over VPCs, you can attach the office network to a CEN instance. The CEN instance is the one that connects to your on-premises network over VPN Gateway or Express Connect.
        self.cen_id = cen_id
        # The ID of the Alibaba Cloud account to which the Cloud Enterprise Network (CEN) instance belongs.
        # 
        # - If you do not specify the CenId parameter, or the CEN instance that is specified by the CenId parameter belongs to the current Alibaba Cloud account, skip this parameter.
        # - If you specify the CenId parameter and the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, enter the ID of the Alibaba Cloud account.
        self.cen_owner_id = cen_owner_id
        # The IPv4 CIDR block that you want the office network to use in the virtual private cloud (VPC) of the office network. The system automatically creates a VPC for the office network based on the IPv4 CIDR block. We recommend that you set this parameter to one of the following CIDR blocks and their subnets:
        # 
        # *   `10.0.0.0/12` (subnet mask range: 12 to 14 bits)
        # *   `172.16.0.0/12` (subnet mask range: 12 to 24 bits)
        # *   `192.168.0.0/16` (subnet mask range: 16 to 24 bits)
        self.cidr_block = cidr_block
        # Specifies whether to create a CloudBox-based office network.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.cloud_box_office_site = cloud_box_office_site
        # The method to connect to cloud computers from Alibaba Cloud Workspace clients.
        # 
        # >  The VPC connection depends on Alibaba Cloud PrivateLink. You can use PrivateLink for free. When you set this parameter to VPC or Any, PrivateLink is automatically activated.````
        self.desktop_access_type = desktop_access_type
        # Specifies whether to grant the local administrator permissions to users that are authorized to use cloud computers in the office network.
        # 
        # Valid values:
        # 
        # * true (default)
        # * false
        self.enable_admin_access = enable_admin_access
        # Specifies whether to enable Internet access.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false (default)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.enable_internet_access = enable_internet_access
        # Specifies whether to enable trusted device verification.
        self.need_verify_zero_device = need_verify_zero_device
        # The office network name. The name must be 2 to 255 characters in length. It can contain digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with `http://` or `https://`.
        self.office_site_name = office_site_name
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The IDs of the vSwitches that you want to specify in VPCs. This parameter is required only when you create CloudBox-based office networks.
        self.v_switch_id = v_switch_id
        # The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the [SendVerifyCode](https://help.aliyun.com/document_detail/335132.html) operation to obtain the verification code.
        self.verify_code = verify_code
        # The network type of the office network.
        # 
        # Valid values:
        # 
        # *   standard: advanced
        # *   basic: basic
        self.vpc_type = vpc_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.cloud_box_office_site is not None:
            result['CloudBoxOfficeSite'] = self.cloud_box_office_site
        if self.desktop_access_type is not None:
            result['DesktopAccessType'] = self.desktop_access_type
        if self.enable_admin_access is not None:
            result['EnableAdminAccess'] = self.enable_admin_access
        if self.enable_internet_access is not None:
            result['EnableInternetAccess'] = self.enable_internet_access
        if self.need_verify_zero_device is not None:
            result['NeedVerifyZeroDevice'] = self.need_verify_zero_device
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.verify_code is not None:
            result['VerifyCode'] = self.verify_code
        if self.vpc_type is not None:
            result['VpcType'] = self.vpc_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('CloudBoxOfficeSite') is not None:
            self.cloud_box_office_site = m.get('CloudBoxOfficeSite')
        if m.get('DesktopAccessType') is not None:
            self.desktop_access_type = m.get('DesktopAccessType')
        if m.get('EnableAdminAccess') is not None:
            self.enable_admin_access = m.get('EnableAdminAccess')
        if m.get('EnableInternetAccess') is not None:
            self.enable_internet_access = m.get('EnableInternetAccess')
        if m.get('NeedVerifyZeroDevice') is not None:
            self.need_verify_zero_device = m.get('NeedVerifyZeroDevice')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VerifyCode') is not None:
            self.verify_code = m.get('VerifyCode')
        if m.get('VpcType') is not None:
            self.vpc_type = m.get('VpcType')
        return self


class CreateSimpleOfficeSiteResponseBody(TeaModel):
    def __init__(
        self,
        office_site_id: str = None,
        request_id: str = None,
    ):
        # The office network ID.
        self.office_site_id = office_site_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSimpleOfficeSiteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSimpleOfficeSiteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSimpleOfficeSiteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSnapshotRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        desktop_id: str = None,
        region_id: str = None,
        snapshot_name: str = None,
        source_disk_type: str = None,
    ):
        # The description of the snapshot. The description can be up to 128 characters in length.
        self.description = description
        # The ID of the cloud computer.
        # 
        # This parameter is required.
        self.desktop_id = desktop_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The name of the snapshot. The name must be 2 to 127 characters in length. The name must start with a letter. The name can contain letters, digits, underscores (_), and hyphens (-). The name cannot start with `auto` because snapshots whose names start with auto are recognized as automatic snapshots.
        # 
        # This parameter is required.
        self.snapshot_name = snapshot_name
        # The type of the disk for which you want to create a snapshot.
        # 
        # Valid values:
        # 
        # *   system: system disk
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   data: data disk
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # This parameter is required.
        self.source_disk_type = source_disk_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snapshot_name is not None:
            result['SnapshotName'] = self.snapshot_name
        if self.source_disk_type is not None:
            result['SourceDiskType'] = self.source_disk_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnapshotName') is not None:
            self.snapshot_name = m.get('SnapshotName')
        if m.get('SourceDiskType') is not None:
            self.source_disk_type = m.get('SourceDiskType')
        return self


class CreateSnapshotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        snapshot_id: str = None,
    ):
        # The ID of the region.
        self.request_id = request_id
        # The ID of the snapshot.
        self.snapshot_id = snapshot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CreateSnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSnapshotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_id: List[str] = None,
        region_id: str = None,
    ):
        # The IDs of the automatic snapshot policies that you want to delete.
        # 
        # This parameter is required.
        self.policy_id = policy_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBundlesRequest(TeaModel):
    def __init__(
        self,
        bundle_id: List[str] = None,
        region_id: str = None,
    ):
        # The IDs of the cloud computer templates. You can specify 1 to 100 IDs.
        # 
        # This parameter is required.
        self.bundle_id = bundle_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteBundlesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBundlesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBundlesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBundlesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCdsFileRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: str = None,
        file_id: str = None,
        group_id: str = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The ID of the end user who uses the cloud disk.
        self.end_user_id = end_user_id
        # The ID of the file. The ID is a unique identifier for the file.
        # 
        # This parameter is required.
        self.file_id = file_id
        # The group ID.
        self.group_id = group_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCdsFileResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The operation result. A value of success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # Indicates whether the data is returned.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCdsFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCdsFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCdsFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCloudDriveGroupsRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        group_id: List[str] = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk in Cloud Drive Service.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The IDs of the teams that you want to delete. You can delete multiple teams at a time.
        self.group_id = group_id
        # The region ID.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCloudDriveGroupsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The result of the operation. A value of success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # The data information.
        self.data = data
        # The error message returned. This parameter is not returned if the value of Code is `success`.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true: The request is successful. false: The request fails.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCloudDriveGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCloudDriveGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCloudDriveGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCloudDriveUsersRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: List[str] = None,
        region_id: str = None,
    ):
        # This parameter is required.
        self.cds_id = cds_id
        self.end_user_id = end_user_id
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCloudDriveUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCloudDriveUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCloudDriveUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCloudDriveUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConfigGroupRequest(TeaModel):
    def __init__(
        self,
        group_ids: List[str] = None,
        region_id: str = None,
    ):
        # The IDs of the configuration groups that you want to delete.
        self.group_ids = group_ids
        # The ID of the region. Set the value to `cn-shanghai`.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteConfigGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteConfigGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteConfigGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteConfigGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDesktopGroupRequest(TeaModel):
    def __init__(
        self,
        desktop_group_id: str = None,
        region_id: str = None,
    ):
        # The ID of the desktop group.
        # 
        # This parameter is required.
        self.desktop_group_id = desktop_group_id
        # The region ID.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDesktopGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDesktopGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDesktopGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDesktopGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDesktopsRequest(TeaModel):
    def __init__(
        self,
        desktop_id: List[str] = None,
        region_id: str = None,
    ):
        # The IDs of the cloud computers. You can specify 1 to 100 IDs.
        # 
        # This parameter is required.
        self.desktop_id = desktop_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDesktopsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDesktopsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDesktopsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDesktopsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDevicesRequest(TeaModel):
    def __init__(
        self,
        client_type: int = None,
        device_ids: List[str] = None,
        force: int = None,
        region_id: str = None,
    ):
        # The type of the client.
        # 
        # Valid values:
        # 
        # *   1: hardware client.
        # *   2: software client.
        # 
        # This parameter is required.
        self.client_type = client_type
        # The IDs of the devices. You can specify up to 200 IDs.
        # 
        # This parameter is required.
        self.device_ids = device_ids
        # Specifies whether to forcefully delete the device if the device is bound to a user.
        # 
        # Valid values:
        # 
        # *   0: do not forcefully delete the device.
        # *   1: forcefully delete the device.
        # 
        # This parameter is required.
        self.force = force
        # The ID of the region. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the regions supported by WUYING Workspace.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.device_ids is not None:
            result['DeviceIds'] = self.device_ids
        if self.force is not None:
            result['Force'] = self.force
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('DeviceIds') is not None:
            self.device_ids = m.get('DeviceIds')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDevicesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDevicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDirectoriesRequest(TeaModel):
    def __init__(
        self,
        directory_id: List[str] = None,
        region_id: str = None,
    ):
        # The directory IDs. You can specify one or more directory IDs.
        # 
        # This parameter is required.
        self.directory_id = directory_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDirectoriesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDirectoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDirectoriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDirectoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEduRoomRequest(TeaModel):
    def __init__(
        self,
        edu_room_id: str = None,
        region_id: str = None,
    ):
        # This parameter is required.
        self.edu_room_id = edu_room_id
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.edu_room_id is not None:
            result['EduRoomId'] = self.edu_room_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EduRoomId') is not None:
            self.edu_room_id = m.get('EduRoomId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteEduRoomResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEduRoomResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEduRoomResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEduRoomResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImagesRequest(TeaModel):
    def __init__(
        self,
        delete_cascaded_bundle: bool = None,
        image_id: List[str] = None,
        region_id: str = None,
    ):
        # Specifies whether to delete the associated template.
        self.delete_cascaded_bundle = delete_cascaded_bundle
        # The image IDs. You can specify 1 to 100 image IDs.
        # 
        # This parameter is required.
        self.image_id = image_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_cascaded_bundle is not None:
            result['DeleteCascadedBundle'] = self.delete_cascaded_bundle
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeleteCascadedBundle') is not None:
            self.delete_cascaded_bundle = m.get('DeleteCascadedBundle')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteImagesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteImagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteImagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteImagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNASFileSystemsRequest(TeaModel):
    def __init__(
        self,
        file_system_id: List[str] = None,
        region_id: str = None,
    ):
        # The IDs of the NAS file systems that you want to delete.
        # 
        # This parameter is required.
        self.file_system_id = file_system_id
        # The region ID of the NAS file system that you want to delete.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteNASFileSystemsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNASFileSystemsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNASFileSystemsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNASFileSystemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkPackagesRequest(TeaModel):
    def __init__(
        self,
        network_package_id: List[str] = None,
        region_id: str = None,
    ):
        # The IDs of premium bandwidth plans. You can specify one or more IDs.
        # 
        # This parameter is required.
        self.network_package_id = network_package_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteNetworkPackagesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkPackagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNetworkPackagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNetworkPackagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOfficeSitesRequest(TeaModel):
    def __init__(
        self,
        office_site_id: List[str] = None,
        region_id: str = None,
    ):
        # The IDs of the office networks. You can specify 1 to 100 office networks.
        # 
        # This parameter is required.
        self.office_site_id = office_site_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteOfficeSitesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteOfficeSitesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteOfficeSitesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOfficeSitesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePolicyGroupsRequest(TeaModel):
    def __init__(
        self,
        policy_group_id: List[str] = None,
        region_id: str = None,
    ):
        # The cloud computer policy IDs. You can specify 1 to 100 policies.
        # 
        # This parameter is required.
        self.policy_group_id = policy_group_id
        # The region ID. You can call the [DescribeRegions](~~DescribeRegions~~) operation to query the regions supported by EDS.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeletePolicyGroupsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePolicyGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePolicyGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePolicyGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnapshotRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        snapshot_id: List[str] = None,
    ):
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The snapshot IDs. You can specify 1 to 100 IDs.
        # 
        # This parameter is required.
        self.snapshot_id = snapshot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class DeleteSnapshotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSnapshotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVirtualMFADeviceRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        serial_number: str = None,
    ):
        # The region ID.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The serial number of the virtual MFA device, which is a unique identifier.
        # 
        # You can call the [DescribeVirtualMFADevices](https://help.aliyun.com/document_detail/206210.html) operation to query the serial number of the virtual MFA device that is bound by AD users.
        # 
        # This parameter is required.
        self.serial_number = serial_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        return self


class DeleteVirtualMFADeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVirtualMFADeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVirtualMFADeviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVirtualMFADeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAclEntriesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        office_site_id: str = None,
        region_id: str = None,
        source_id: str = None,
        source_type: str = None,
    ):
        # The number of entries per page. Maximum value: 1600.
        # 
        # Default value: 1600.
        self.max_results = max_results
        # The token that is used for the next query. If this parameter is empty, all results have been returned.
        self.next_token = next_token
        # The office network ID.
        self.office_site_id = office_site_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the instance to which the ACL applies. You can specify an office network ID or a cloud computer ID.
        self.source_id = source_id
        # The granularity of the ACL.
        # 
        # Valid values:
        # 
        # *   desktop: cloud computer
        # *   vpc: office network
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class DescribeAclEntriesResponseBodyAclEntries(TeaModel):
    def __init__(
        self,
        policy: str = None,
        source_id: str = None,
        source_type: str = None,
    ):
        # The ACL type.
        # 
        # Valid values:
        # 
        # *   allow: whitelist
        # *   disable: blacklist
        self.policy = policy
        # The ID of the instance to which the ACL applies, such as an office network ID or a cloud computer ID.
        self.source_id = source_id
        # The granularity of the ACL.
        # 
        # Valid values:
        # 
        # *   desktop: cloud computer
        # *   vpc: office network
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class DescribeAclEntriesResponseBody(TeaModel):
    def __init__(
        self,
        acl_entries: List[DescribeAclEntriesResponseBodyAclEntries] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The ACL entries.
        self.acl_entries = acl_entries
        # The token that is used to start the next query. If the value of this parameter is empty, all results are returned.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.acl_entries:
            for k in self.acl_entries:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AclEntries'] = []
        if self.acl_entries is not None:
            for k in self.acl_entries:
                result['AclEntries'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acl_entries = []
        if m.get('AclEntries') is not None:
            for k in m.get('AclEntries'):
                temp_model = DescribeAclEntriesResponseBodyAclEntries()
                self.acl_entries.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAclEntriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAclEntriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAclEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        policy_id: str = None,
        policy_name: str = None,
        region_id: str = None,
    ):
        # The number of entries to return on each page.
        # 
        # *   Maximum value: 100
        # *   Default value: 20
        self.max_results = max_results
        # The token that determines the start point of the next query. If this parameter is left empty, all results are returned.
        self.next_token = next_token
        # The ID of the automatic snapshot policy.
        self.policy_id = policy_id
        # The name of the automatic snapshot policy.
        self.policy_name = policy_name
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeAutoSnapshotPolicyResponseBodyAutoSnapshotPolicies(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        cron_expression: str = None,
        desktop_num: int = None,
        policy_id: str = None,
        policy_name: str = None,
        region_id: str = None,
        retention_days: str = None,
        status: str = None,
        time_points: str = None,
    ):
        # The time when the automatic snapshot policy was created. The time follows the [ISO 8601](https://help.aliyun.com/document_detail/25696.html) standard in the `yyyy-mm-ddthh:mm:ssz` format. The time is displayed in UTC.
        self.creation_time = creation_time
        # The cron expression that specifies when Elastic Desktop Service creates snapshots on the cloud computers.
        self.cron_expression = cron_expression
        # The number of cloud computers to which the automatic snapshot policy is applied.
        self.desktop_num = desktop_num
        # The ID of the automatic snapshot policy.
        self.policy_id = policy_id
        # The name of the automatic snapshot policy.
        self.policy_name = policy_name
        # The ID of the region to which the automatic snapshot policy belongs.
        self.region_id = region_id
        # The retention period of the automatic snapshots. Unit: days. Valid values: 1 to 180.
        self.retention_days = retention_days
        # The status of the automatic snapshot policy.
        # 
        # Valid values:
        # 
        # *   Expire: The automatic snapshot policy cannot be used because you have overdue payments in your account.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Normal: The automatic snapshot policy is normal.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.status = status
        # The points in time at which the auto snapshots were created.
        # 
        # The parameter values are a JSON array. Example: `["0", "1", ... "23"]`. A maximum of 24 points in time are returned. The points in time are separated with commas (,).
        self.time_points = time_points

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.desktop_num is not None:
            result['DesktopNum'] = self.desktop_num
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        if self.status is not None:
            result['Status'] = self.status
        if self.time_points is not None:
            result['TimePoints'] = self.time_points
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('DesktopNum') is not None:
            self.desktop_num = m.get('DesktopNum')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RetentionDays') is not None:
            self.retention_days = m.get('RetentionDays')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TimePoints') is not None:
            self.time_points = m.get('TimePoints')
        return self


class DescribeAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        auto_snapshot_policies: List[DescribeAutoSnapshotPolicyResponseBodyAutoSnapshotPolicies] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The details of the queried automatic snapshot policies.
        self.auto_snapshot_policies = auto_snapshot_policies
        # The token that is used to start the next query. If this parameter is empty, all results haven been returned.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.auto_snapshot_policies:
            for k in self.auto_snapshot_policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AutoSnapshotPolicies'] = []
        if self.auto_snapshot_policies is not None:
            for k in self.auto_snapshot_policies:
                result['AutoSnapshotPolicies'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.auto_snapshot_policies = []
        if m.get('AutoSnapshotPolicies') is not None:
            for k in m.get('AutoSnapshotPolicies'):
                temp_model = DescribeAutoSnapshotPolicyResponseBodyAutoSnapshotPolicies()
                self.auto_snapshot_policies.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBundlesRequest(TeaModel):
    def __init__(
        self,
        bundle_id: List[str] = None,
        bundle_type: str = None,
        check_stock: bool = None,
        cpu_count: int = None,
        desktop_type_family: str = None,
        fota_channel: str = None,
        from_desktop_group: bool = None,
        gpu_count: float = None,
        gpu_driver_type: str = None,
        image_id: List[str] = None,
        max_results: int = None,
        memory_size: int = None,
        next_token: str = None,
        os_type: str = None,
        protocol_type: str = None,
        region_id: str = None,
        scope: str = None,
        selected_bundle: bool = None,
        session_type: str = None,
        support_multi_session: bool = None,
        volume_encryption_enabled: bool = None,
    ):
        # The IDs of the cloud computer templates. You can specify 1 to 100 IDs.
        self.bundle_id = bundle_id
        # The type of the cloud computer template.
        # 
        # Valid values:
        # 
        # *   SYSTEM: system template
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   CUSTOM: custom template
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.bundle_type = bundle_type
        # Specifies whether to query the inventory status of the cloud computer instance type.
        self.check_stock = check_stock
        # The number of vCPUs contained in the cloud computer instance type.
        self.cpu_count = cpu_count
        # The instance family of the cloud computers.
        # 
        # Valid values:
        # 
        # *   eds.graphics: graphical instance families
        # *   eds.hf: instance families with high clock speeds
        # *   eds.general: general-purpose instance families
        self.desktop_type_family = desktop_type_family
        # >  This parameter is not available for public use.
        self.fota_channel = fota_channel
        # Specifies whether the cloud computers in the template belong to a cloud computer pool.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.from_desktop_group = from_desktop_group
        # The number of GPUs contained in the cloud computer instance type.
        self.gpu_count = gpu_count
        # The GPU driver type.
        # 
        # Valid values:
        # 
        # *   T4
        # *   A10
        # *   G28
        # *   G39
        self.gpu_driver_type = gpu_driver_type
        # The image IDs.
        self.image_id = image_id
        # The number of entries to return on each page.
        # 
        # Maximum value: 100.
        # 
        # Default value: 10.
        self.max_results = max_results
        # The memory size of the cloud computer instance type. Unit: GiB.
        self.memory_size = memory_size
        # The token that is used to start the next query.
        self.next_token = next_token
        # The type of the OS.
        # 
        # Valid values:
        # 
        # *   Linux
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.os_type = os_type
        # The protocol type.
        # 
        # Valid values:
        # 
        # *   HDX: High-definition Experience (HDX) protocol
        # *   ASP: in-house Adaptive Streaming Protocol (ASP) (recommend)
        self.protocol_type = protocol_type
        # The region ID. You can call the [DescribeRegions](~~DescribeRegions~~) operation to query the regions supported by Elastic Desktop Service (EDS).
        # 
        # This parameter is required.
        self.region_id = region_id
        # The scenario to use the image.
        self.scope = scope
        # The desktop template that is selected based on specific criteria.
        self.selected_bundle = selected_bundle
        # The type of the session. Valide values:
        # 
        # - SingleSession
        # - MultipleSession
        self.session_type = session_type
        # Specifies whether to return multi-session cloud computer templates. Default value: false.
        self.support_multi_session = support_multi_session
        # Specifies whether to enable disk encryption.
        self.volume_encryption_enabled = volume_encryption_enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.bundle_type is not None:
            result['BundleType'] = self.bundle_type
        if self.check_stock is not None:
            result['CheckStock'] = self.check_stock
        if self.cpu_count is not None:
            result['CpuCount'] = self.cpu_count
        if self.desktop_type_family is not None:
            result['DesktopTypeFamily'] = self.desktop_type_family
        if self.fota_channel is not None:
            result['FotaChannel'] = self.fota_channel
        if self.from_desktop_group is not None:
            result['FromDesktopGroup'] = self.from_desktop_group
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.gpu_driver_type is not None:
            result['GpuDriverType'] = self.gpu_driver_type
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.selected_bundle is not None:
            result['SelectedBundle'] = self.selected_bundle
        if self.session_type is not None:
            result['SessionType'] = self.session_type
        if self.support_multi_session is not None:
            result['SupportMultiSession'] = self.support_multi_session
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('BundleType') is not None:
            self.bundle_type = m.get('BundleType')
        if m.get('CheckStock') is not None:
            self.check_stock = m.get('CheckStock')
        if m.get('CpuCount') is not None:
            self.cpu_count = m.get('CpuCount')
        if m.get('DesktopTypeFamily') is not None:
            self.desktop_type_family = m.get('DesktopTypeFamily')
        if m.get('FotaChannel') is not None:
            self.fota_channel = m.get('FotaChannel')
        if m.get('FromDesktopGroup') is not None:
            self.from_desktop_group = m.get('FromDesktopGroup')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('GpuDriverType') is not None:
            self.gpu_driver_type = m.get('GpuDriverType')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('MemorySize') is not None:
            self.memory_size = m.get('MemorySize')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SelectedBundle') is not None:
            self.selected_bundle = m.get('SelectedBundle')
        if m.get('SessionType') is not None:
            self.session_type = m.get('SessionType')
        if m.get('SupportMultiSession') is not None:
            self.support_multi_session = m.get('SupportMultiSession')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        return self


class DescribeBundlesResponseBodyBundlesDesktopTypeAttribute(TeaModel):
    def __init__(
        self,
        cpu_count: int = None,
        gpu_count: float = None,
        gpu_spec: str = None,
        memory_size: int = None,
    ):
        # The number of vCPUs.
        self.cpu_count = cpu_count
        # The number of GPUs.
        self.gpu_count = gpu_count
        # The GPU type.
        self.gpu_spec = gpu_spec
        # The memory size. Unit: MiB.
        self.memory_size = memory_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_count is not None:
            result['CpuCount'] = self.cpu_count
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.gpu_spec is not None:
            result['GpuSpec'] = self.gpu_spec
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CpuCount') is not None:
            self.cpu_count = m.get('CpuCount')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('GpuSpec') is not None:
            self.gpu_spec = m.get('GpuSpec')
        if m.get('MemorySize') is not None:
            self.memory_size = m.get('MemorySize')
        return self


class DescribeBundlesResponseBodyBundlesDisks(TeaModel):
    def __init__(
        self,
        disk_performance_level: str = None,
        disk_size: int = None,
        disk_type: str = None,
    ):
        # The PL of the disk.
        # 
        # Valid values:
        # 
        # *   PL1
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PL0
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PL3
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PL2
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.disk_performance_level = disk_performance_level
        # The size of the disk. Unit: GiB.
        self.disk_size = disk_size
        # The type of the disk.
        # 
        # Valid values:
        # 
        # *   SYSTEM: system disk
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DATA: data disk
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.disk_type = disk_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_performance_level is not None:
            result['DiskPerformanceLevel'] = self.disk_performance_level
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskPerformanceLevel') is not None:
            self.disk_performance_level = m.get('DiskPerformanceLevel')
        if m.get('DiskSize') is not None:
            self.disk_size = m.get('DiskSize')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        return self


class DescribeBundlesResponseBodyBundles(TeaModel):
    def __init__(
        self,
        bundle_id: str = None,
        bundle_name: str = None,
        bundle_type: str = None,
        creation_time: str = None,
        data_disk_category: str = None,
        description: str = None,
        desktop_type: str = None,
        desktop_type_attribute: DescribeBundlesResponseBodyBundlesDesktopTypeAttribute = None,
        desktop_type_family: str = None,
        disks: List[DescribeBundlesResponseBodyBundlesDisks] = None,
        image_id: str = None,
        image_name: str = None,
        image_status: str = None,
        language: str = None,
        os_type: str = None,
        platform: str = None,
        protocol_type: str = None,
        session_type: str = None,
        stock_state: str = None,
        system_disk_category: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
    ):
        # The ID of the cloud computer template.
        self.bundle_id = bundle_id
        # The name of the cloud computer template.
        self.bundle_name = bundle_name
        # The type of the cloud computer template.
        # 
        # Valid values:
        # 
        # *   SYSTEM: system template
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   CUSTOM: custom template
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.bundle_type = bundle_type
        # The time when the cloud computer template was created.
        self.creation_time = creation_time
        # The category of the data disk. Valid values:
        # 
        # *   cloud_efficiency: ultra disk
        # *   cloud_auto: SSD
        # *   cloud_essd: ESSD (supported by specific specifications)
        self.data_disk_category = data_disk_category
        # The description of the cloud computer template.
        self.description = description
        # The instance type of the cloud computer.
        self.desktop_type = desktop_type
        # The details of the cloud computer instance type.
        self.desktop_type_attribute = desktop_type_attribute
        # The instance family of the cloud computer.
        # 
        # Valid values:
        # 
        # *   eds.graphics: graphical instance family
        # *   eds.hf: instance family with a high clock speed
        # *   eds.general: general-purpose instance family
        self.desktop_type_family = desktop_type_family
        # Details of the disks.
        self.disks = disks
        # The image ID.
        self.image_id = image_id
        # The image name.
        self.image_name = image_name
        # The status of the image.
        self.image_status = image_status
        # The OS language of the image.
        # 
        # Valid values:
        # 
        # *   en-US: English
        # *   zh-HK: Chinese, Traditional (Hong Kong, China)
        # *   zh-CN: Simplified Chinese
        # *   ja-JP: Japanese
        self.language = language
        # The type of the OS.
        # 
        # Valid values:
        # 
        # *   Linux
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.os_type = os_type
        # The OS.
        # 
        # Valid values:
        # 
        # *   Ubuntu
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows Server 2022
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   UOS
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   CentOS
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows Server 2019
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows Server 2016
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.platform = platform
        # The protocol type.
        # 
        # Valid values:
        # 
        # *   HDX: HDX protocol
        # *   ASP: in-house ASP
        self.protocol_type = protocol_type
        # The session type.
        # 
        # Valid values:
        # 
        # *   0: single-session
        # *   1: multi-session
        self.session_type = session_type
        # The inventory status of the cloud computer instance type. This parameter is returned only if you set the `CheckStock` parameter to `true`.
        self.stock_state = stock_state
        # The category of the system disk. Valid values:
        # 
        # *   cloud_efficiency: ultra disk
        # *   cloud_auto: SSD
        # *   cloud_essd: ESSD (supported by specific specifications)
        self.system_disk_category = system_disk_category
        # Indicates whether disk encryption is enabled.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that is used when disk encryption is enabled.
        self.volume_encryption_key = volume_encryption_key

    def validate(self):
        if self.desktop_type_attribute:
            self.desktop_type_attribute.validate()
        if self.disks:
            for k in self.disks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.bundle_name is not None:
            result['BundleName'] = self.bundle_name
        if self.bundle_type is not None:
            result['BundleType'] = self.bundle_type
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.desktop_type_attribute is not None:
            result['DesktopTypeAttribute'] = self.desktop_type_attribute.to_map()
        if self.desktop_type_family is not None:
            result['DesktopTypeFamily'] = self.desktop_type_family
        result['Disks'] = []
        if self.disks is not None:
            for k in self.disks:
                result['Disks'].append(k.to_map() if k else None)
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_status is not None:
            result['ImageStatus'] = self.image_status
        if self.language is not None:
            result['Language'] = self.language
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.session_type is not None:
            result['SessionType'] = self.session_type
        if self.stock_state is not None:
            result['StockState'] = self.stock_state
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('BundleName') is not None:
            self.bundle_name = m.get('BundleName')
        if m.get('BundleType') is not None:
            self.bundle_type = m.get('BundleType')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('DesktopTypeAttribute') is not None:
            temp_model = DescribeBundlesResponseBodyBundlesDesktopTypeAttribute()
            self.desktop_type_attribute = temp_model.from_map(m['DesktopTypeAttribute'])
        if m.get('DesktopTypeFamily') is not None:
            self.desktop_type_family = m.get('DesktopTypeFamily')
        self.disks = []
        if m.get('Disks') is not None:
            for k in m.get('Disks'):
                temp_model = DescribeBundlesResponseBodyBundlesDisks()
                self.disks.append(temp_model.from_map(k))
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ImageStatus') is not None:
            self.image_status = m.get('ImageStatus')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('SessionType') is not None:
            self.session_type = m.get('SessionType')
        if m.get('StockState') is not None:
            self.stock_state = m.get('StockState')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        return self


class DescribeBundlesResponseBody(TeaModel):
    def __init__(
        self,
        bundles: List[DescribeBundlesResponseBodyBundles] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The details of the cloud computer templates.
        self.bundles = bundles
        # The token that is used for the next query. If this parameter is empty, all results have been returned.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.bundles:
            for k in self.bundles:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Bundles'] = []
        if self.bundles is not None:
            for k in self.bundles:
                result['Bundles'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bundles = []
        if m.get('Bundles') is not None:
            for k in m.get('Bundles'):
                temp_model = DescribeBundlesResponseBodyBundles()
                self.bundles.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBundlesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBundlesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBundlesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCdsFileShareLinksRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        creators: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        share_id: str = None,
        share_name: str = None,
        status: str = None,
    ):
        # The ID of the cloud disk.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The users that create the file sharing links.
        self.creators = creators
        # The maximum number of resources to return. Valid values: 1 to 100. Default value: 100. The number of returned resources must be less than or equal to the specified number.
        self.max_results = max_results
        # Specifies the marker after which the returned list begins. If this parameter is not specified, all results are returned. Default value: null.
        self.next_token = next_token
        # The ID of the file sharing link.
        self.share_id = share_id
        # The sharing name for fuzzy search.
        self.share_name = share_name
        # The file sharing status. Valid values: ● disabled: canceled ● enabled: valid
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.creators is not None:
            result['Creators'] = self.creators
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.share_id is not None:
            result['ShareId'] = self.share_id
        if self.share_name is not None:
            result['ShareName'] = self.share_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('Creators') is not None:
            self.creators = m.get('Creators')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ShareId') is not None:
            self.share_id = m.get('ShareId')
        if m.get('ShareName') is not None:
            self.share_name = m.get('ShareName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCdsFileShareLinksResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[CdsFileShareLinkModel] = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The operation result. A value of success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # The data information.
        self.data = data
        # The error message that is returned. This parameter is not returned if the value of Code is `success`.
        self.message = message
        # A pagination token. It can be used in the next request to retrieve a new page of results. If NextToken is empty, no next page exists.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = CdsFileShareLinkModel()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCdsFileShareLinksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCdsFileShareLinksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCdsFileShareLinksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCensRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        # The page number.\\
        # Default value: 1.
        self.page_number = page_number
        # The number of entries per page.\\
        # Default value: 50.
        self.page_size = page_size
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCensResponseBodyCensPackageIds(TeaModel):
    def __init__(
        self,
        package_id: str = None,
    ):
        # The ID of the bandwidth plan that is bound to the CEN instance.
        self.package_id = package_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.package_id is not None:
            result['PackageId'] = self.package_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PackageId') is not None:
            self.package_id = m.get('PackageId')
        return self


class DescribeCensResponseBodyCensTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag.
        self.key = key
        # The value of the tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCensResponseBodyCens(TeaModel):
    def __init__(
        self,
        cen_id: str = None,
        creation_time: str = None,
        description: str = None,
        ipv_6level: str = None,
        name: str = None,
        package_ids: List[DescribeCensResponseBodyCensPackageIds] = None,
        protection_level: str = None,
        status: str = None,
        tags: List[DescribeCensResponseBodyCensTags] = None,
    ):
        # The ID of the CEN instance.
        self.cen_id = cen_id
        # The time when the CEN instance was created.
        self.creation_time = creation_time
        # The description of the CEN instance.
        self.description = description
        # The IPv6 level.
        # 
        # >  IPv6 is not supported.
        # 
        # Valid value:
        # 
        # *   DISABLED
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.ipv_6level = ipv_6level
        # The name of the CEN instance.
        self.name = name
        # The bandwidth plans that are bound to the CEN instance.
        self.package_ids = package_ids
        # The tolerated level of CIDR block conflict.
        # 
        # Valid value:
        # 
        # *   REDUCED: CIDR block conflicts are allowed, but the conflicting CIDR blocks cannot be identical.
        self.protection_level = protection_level
        # The status of the CEN instance.
        # 
        # Valid values:
        # 
        # *   Creating
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Active
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Deleting
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.status = status
        # The tags of the CEN instance.
        self.tags = tags

    def validate(self):
        if self.package_ids:
            for k in self.package_ids:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.ipv_6level is not None:
            result['Ipv6Level'] = self.ipv_6level
        if self.name is not None:
            result['Name'] = self.name
        result['PackageIds'] = []
        if self.package_ids is not None:
            for k in self.package_ids:
                result['PackageIds'].append(k.to_map() if k else None)
        if self.protection_level is not None:
            result['ProtectionLevel'] = self.protection_level
        if self.status is not None:
            result['Status'] = self.status
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Ipv6Level') is not None:
            self.ipv_6level = m.get('Ipv6Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.package_ids = []
        if m.get('PackageIds') is not None:
            for k in m.get('PackageIds'):
                temp_model = DescribeCensResponseBodyCensPackageIds()
                self.package_ids.append(temp_model.from_map(k))
        if m.get('ProtectionLevel') is not None:
            self.protection_level = m.get('ProtectionLevel')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeCensResponseBodyCensTags()
                self.tags.append(temp_model.from_map(k))
        return self


class DescribeCensResponseBody(TeaModel):
    def __init__(
        self,
        cens: List[DescribeCensResponseBodyCens] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # Details of the CEN instances.
        self.cens = cens
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of CEN instances returned.
        self.total_count = total_count

    def validate(self):
        if self.cens:
            for k in self.cens:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Cens'] = []
        if self.cens is not None:
            for k in self.cens:
                result['Cens'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cens = []
        if m.get('Cens') is not None:
            for k in m.get('Cens'):
                temp_model = DescribeCensResponseBodyCens()
                self.cens.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCensResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCensResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCensResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClientEventsRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        desktop_ip: str = None,
        desktop_name: str = None,
        directory_id: str = None,
        end_time: str = None,
        end_user_id: str = None,
        event_type: str = None,
        event_types: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        region_id: str = None,
        start_time: str = None,
    ):
        # The cloud desktop ID. If you do not specify a value for this parameter, events of all cloud desktops in the specified region are queried.
        self.desktop_id = desktop_id
        # The IP address of the cloud desktop. If you do not specify a value for this parameter, the events of all cloud desktops in the specified region are queried.
        self.desktop_ip = desktop_ip
        # The cloud desktop name.
        self.desktop_name = desktop_name
        # This parameter is not available to the public.
        self.directory_id = directory_id
        # The end of the time range to query. Specify the time in the [ISO 8601](https://help.aliyun.com/document_detail/25696.html) standard in the YYYY-MM-DDThh:mm:ssZ format. The time must be in UTC.\\
        # If you do not specify a value for this parameter, the current time is used.
        self.end_time = end_time
        # The information about the end user that connects to the cloud desktop from the Elastic Desktop Service (EDS) client. The information can be a Resource Access Management (RAM) user ID or an Active Directory (AD) username. If you do not specify a value for this parameter, the events of all end users in the specified region are queried.
        self.end_user_id = end_user_id
        # The type of the events that you want to query. If you specify multiple values for the EventTypes parameter, the events of all specified types are returned. If you do not specify values for the EventTypes and EventType parameters, all events of end users in the specified region are returned.
        # 
        # Valid values:
        # 
        # *   DESKTOP_STOP: End users stop the cloud desktop.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   GET_LITE_CONNECTION_TICKET: End users obtain the credential for reconnecting to the cloud desktop upon disconnection.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DESKTOP_DISCONNECT: End users disconnect desktop sessions.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   GET_CONNECTION_TICKET: End users request to connect to the cloud desktop.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   CLIENT_LOGIN: End users log on to the cloud desktop.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DESKTOP_REBOOT: End users restart the cloud desktop.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DESKTOP_CONNECT: End users establish desktop sessions.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DESKTOP_START: End users start the cloud desktop.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.event_type = event_type
        # The array of event types that you want to query. You can specify multiple event types. The response contains all or specified types of events.
        self.event_types = event_types
        # The number of entries per page.\\
        # Default value: 100.
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. You do not need to specify this parameter for the first request. You must specify the token that is obtained from the previous query as the value of NextToken.
        self.next_token = next_token
        # The ID of the workspace to which the cloud desktop belongs. If you do not specify a value for this parameter, the events of all workspaces in the specified region are queried.
        self.office_site_id = office_site_id
        # The workspace name.
        self.office_site_name = office_site_name
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The beginning of the time range to query. Specify the time in the [ISO 8601](https://help.aliyun.com/document_detail/25696.html) standard in the YYYY-MM-DDThh:mm:ssZ format. The time must be in UTC.\\
        # If you do not specify a value for this parameter, all events that occurred before the point in time that you specify for `EndTime` are queried.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_ip is not None:
            result['DesktopIp'] = self.desktop_ip
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.event_types is not None:
            result['EventTypes'] = self.event_types
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopIp') is not None:
            self.desktop_ip = m.get('DesktopIp')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('EventTypes') is not None:
            self.event_types = m.get('EventTypes')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeClientEventsResponseBodyEvents(TeaModel):
    def __init__(
        self,
        ali_uid: str = None,
        bytes_received: str = None,
        bytes_send: str = None,
        client_ip: str = None,
        client_os: str = None,
        client_version: str = None,
        description: str = None,
        desktop_group_id: str = None,
        desktop_group_name: str = None,
        desktop_id: str = None,
        desktop_ip: str = None,
        desktop_name: str = None,
        directory_id: str = None,
        directory_type: str = None,
        end_user_id: str = None,
        event_id: str = None,
        event_time: str = None,
        event_type: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        office_site_type: str = None,
        region_id: str = None,
        status: str = None,
    ):
        # The ID of the Alibaba Cloud account with which the event is associated.
        self.ali_uid = ali_uid
        # The number of bytes that are received.
        self.bytes_received = bytes_received
        # The number of bytes that are sent.
        self.bytes_send = bytes_send
        # The IP address of the client.
        self.client_ip = client_ip
        # The OS that the client runs.
        self.client_os = client_os
        # The client version.
        self.client_version = client_version
        # The description.
        self.description = description
        # The desktop group ID.
        self.desktop_group_id = desktop_group_id
        # The desktop group name.
        self.desktop_group_name = desktop_group_name
        # The cloud desktop ID.
        self.desktop_id = desktop_id
        # The IP address of the cloud desktop.
        self.desktop_ip = desktop_ip
        # The cloud desktop name.
        self.desktop_name = desktop_name
        # The ID of the directory to which the cloud desktop belongs.
        self.directory_id = directory_id
        # The directory type.
        self.directory_type = directory_type
        # The information about the end user that connects to the cloud desktop from the EDS client. The information can be a RAM user ID or an AD username.
        self.end_user_id = end_user_id
        # The event ID.
        self.event_id = event_id
        # The time when the event occurred.
        self.event_time = event_time
        # The event type. Valid values:
        self.event_type = event_type
        # The ID of the workspace to which the cloud desktop belongs.
        self.office_site_id = office_site_id
        # The workspace name.
        self.office_site_name = office_site_name
        # The account type of the workspace.
        # 
        # Valid values:
        # 
        # *   SIMPLE: convenience account
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   AD_CONNECTOR: enterprise AD account
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.office_site_type = office_site_type
        # The region ID.
        self.region_id = region_id
        # The status of the event. If you set the EventType parameter to `DESKTOP_DISCONNECT` or `GET_CONNECTION_TICKET`, this parameter is returned. Valid values:
        # 
        # *   200\\. The value indicates that the request is successful.
        # *   An error message. The value indicates that the request failed. Example: FailedToGetConnectionTicket.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.bytes_received is not None:
            result['BytesReceived'] = self.bytes_received
        if self.bytes_send is not None:
            result['BytesSend'] = self.bytes_send
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.client_os is not None:
            result['ClientOS'] = self.client_os
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_name is not None:
            result['DesktopGroupName'] = self.desktop_group_name
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_ip is not None:
            result['DesktopIp'] = self.desktop_ip
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.directory_type is not None:
            result['DirectoryType'] = self.directory_type
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.office_site_type is not None:
            result['OfficeSiteType'] = self.office_site_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('BytesReceived') is not None:
            self.bytes_received = m.get('BytesReceived')
        if m.get('BytesSend') is not None:
            self.bytes_send = m.get('BytesSend')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('ClientOS') is not None:
            self.client_os = m.get('ClientOS')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupName') is not None:
            self.desktop_group_name = m.get('DesktopGroupName')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopIp') is not None:
            self.desktop_ip = m.get('DesktopIp')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DirectoryType') is not None:
            self.directory_type = m.get('DirectoryType')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OfficeSiteType') is not None:
            self.office_site_type = m.get('OfficeSiteType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeClientEventsResponseBody(TeaModel):
    def __init__(
        self,
        events: List[DescribeClientEventsResponseBodyEvents] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The information about the events of an end user.
        self.events = events
        # A pagination token. It can be used in the next request to retrieve a new page of results. If NextToken is empty, no next page exists.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.events:
            for k in self.events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Events'] = []
        if self.events is not None:
            for k in self.events:
                result['Events'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.events = []
        if m.get('Events') is not None:
            for k in m.get('Events'):
                temp_model = DescribeClientEventsResponseBodyEvents()
                self.events.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClientEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeClientEventsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClientEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudDriveGroupsRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        directory_id: str = None,
        directory_name: str = None,
        drive_status: str = None,
        drive_type: str = None,
        group_id: List[str] = None,
        group_name: str = None,
        group_type: str = None,
        max_results: int = None,
        next_token: str = None,
        parent_group_id: str = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk in Cloud Drive Service.
        # 
        # This parameter is required.
        self.cds_id = cds_id
        # The workspace ID.
        self.directory_id = directory_id
        # The workspace name.
        self.directory_name = directory_name
        # The team space status. Valid values:
        # 
        # *   enabled
        # *   disabled
        # 
        # Default value: enabled.
        self.drive_status = drive_status
        # Specifies whether the space is increased.
        # 
        # *   binding: increased
        # *   unbound: not increased
        # 
        # Default value: null. The default value indicates that all spaces are queried.
        self.drive_type = drive_type
        # The team ID.
        self.group_id = group_id
        # The team name for fuzzy search.
        self.group_name = group_name
        # The team type.
        # 
        # *   org: organizational structure
        # *   directory: workspace
        # 
        # Default value: null. The default value indicates that all types of teams are queried.
        self.group_type = group_type
        # The number of entries to return on each page.
        # 
        # *   Valid values: 1 to 100
        # *   Default value: 20
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The ID of the parent node. If a parent node ID is specified, the subnodes are queried. If you set the value of this parameter to root, the root node is queried.
        # 
        # Default value: null. The default value indicates that all nodes are queried.
        self.parent_group_id = parent_group_id
        # The region ID.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.directory_name is not None:
            result['DirectoryName'] = self.directory_name
        if self.drive_status is not None:
            result['DriveStatus'] = self.drive_status
        if self.drive_type is not None:
            result['DriveType'] = self.drive_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.parent_group_id is not None:
            result['ParentGroupId'] = self.parent_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DirectoryName') is not None:
            self.directory_name = m.get('DirectoryName')
        if m.get('DriveStatus') is not None:
            self.drive_status = m.get('DriveStatus')
        if m.get('DriveType') is not None:
            self.drive_type = m.get('DriveType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ParentGroupId') is not None:
            self.parent_group_id = m.get('ParentGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCloudDriveGroupsResponseBodyCloudDriveGroupsAdminUserInfos(TeaModel):
    def __init__(
        self,
        email: str = None,
        end_user_id: str = None,
        job_number: str = None,
        nick_name: str = None,
        phone: str = None,
        real_nick_name: str = None,
        remark: str = None,
    ):
        self.email = email
        self.end_user_id = end_user_id
        self.job_number = job_number
        self.nick_name = nick_name
        self.phone = phone
        self.real_nick_name = real_nick_name
        self.remark = remark

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.email is not None:
            result['Email'] = self.email
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.job_number is not None:
            result['JobNumber'] = self.job_number
        if self.nick_name is not None:
            result['NickName'] = self.nick_name
        if self.phone is not None:
            result['Phone'] = self.phone
        if self.real_nick_name is not None:
            result['RealNickName'] = self.real_nick_name
        if self.remark is not None:
            result['Remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('JobNumber') is not None:
            self.job_number = m.get('JobNumber')
        if m.get('NickName') is not None:
            self.nick_name = m.get('NickName')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        if m.get('RealNickName') is not None:
            self.real_nick_name = m.get('RealNickName')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        return self


class DescribeCloudDriveGroupsResponseBodyCloudDriveGroups(TeaModel):
    def __init__(
        self,
        admin_user_ids: str = None,
        admin_user_infos: List[DescribeCloudDriveGroupsResponseBodyCloudDriveGroupsAdminUserInfos] = None,
        create_time: str = None,
        directory_id: str = None,
        drive_id: str = None,
        group_id: str = None,
        group_name: str = None,
        org_id: str = None,
        recycle_bin_size: str = None,
        status: str = None,
        total_size: int = None,
        used_size: str = None,
    ):
        self.admin_user_ids = admin_user_ids
        self.admin_user_infos = admin_user_infos
        # The time when the team space was created.
        self.create_time = create_time
        # The workspace ID.
        self.directory_id = directory_id
        # The team space ID.
        self.drive_id = drive_id
        # The team ID.
        self.group_id = group_id
        # The name of the team space.
        self.group_name = group_name
        self.org_id = org_id
        self.recycle_bin_size = recycle_bin_size
        # The team space status. Valid values:
        # 
        # *   enabled
        # *   disabled
        # 
        # Default value: enabled.
        self.status = status
        # The total capacity of the team space.
        self.total_size = total_size
        # The capacity of the used space. Unit: bytes.
        self.used_size = used_size

    def validate(self):
        if self.admin_user_infos:
            for k in self.admin_user_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.admin_user_ids is not None:
            result['AdminUserIds'] = self.admin_user_ids
        result['AdminUserInfos'] = []
        if self.admin_user_infos is not None:
            for k in self.admin_user_infos:
                result['AdminUserInfos'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.drive_id is not None:
            result['DriveId'] = self.drive_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.org_id is not None:
            result['OrgId'] = self.org_id
        if self.recycle_bin_size is not None:
            result['RecycleBinSize'] = self.recycle_bin_size
        if self.status is not None:
            result['Status'] = self.status
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        if self.used_size is not None:
            result['UsedSize'] = self.used_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdminUserIds') is not None:
            self.admin_user_ids = m.get('AdminUserIds')
        self.admin_user_infos = []
        if m.get('AdminUserInfos') is not None:
            for k in m.get('AdminUserInfos'):
                temp_model = DescribeCloudDriveGroupsResponseBodyCloudDriveGroupsAdminUserInfos()
                self.admin_user_infos.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DriveId') is not None:
            self.drive_id = m.get('DriveId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('OrgId') is not None:
            self.org_id = m.get('OrgId')
        if m.get('RecycleBinSize') is not None:
            self.recycle_bin_size = m.get('RecycleBinSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        if m.get('UsedSize') is not None:
            self.used_size = m.get('UsedSize')
        return self


class DescribeCloudDriveGroupsResponseBody(TeaModel):
    def __init__(
        self,
        cloud_drive_groups: List[DescribeCloudDriveGroupsResponseBodyCloudDriveGroups] = None,
        count: int = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The list of team spaces.
        self.cloud_drive_groups = cloud_drive_groups
        # The total number of entries returned.
        self.count = count
        # The returned value of NextToken is a pagination token, which can be used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.cloud_drive_groups:
            for k in self.cloud_drive_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CloudDriveGroups'] = []
        if self.cloud_drive_groups is not None:
            for k in self.cloud_drive_groups:
                result['CloudDriveGroups'].append(k.to_map() if k else None)
        if self.count is not None:
            result['Count'] = self.count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cloud_drive_groups = []
        if m.get('CloudDriveGroups') is not None:
            for k in m.get('CloudDriveGroups'):
                temp_model = DescribeCloudDriveGroupsResponseBodyCloudDriveGroups()
                self.cloud_drive_groups.append(temp_model.from_map(k))
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCloudDriveGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudDriveGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudDriveGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudDrivePermissionsRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        region_id: str = None,
    ):
        # This parameter is required.
        self.cds_id = cds_id
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCloudDrivePermissionsResponseBodyCloudDrivePermissionModels(TeaModel):
    def __init__(
        self,
        end_users: List[str] = None,
        permission: str = None,
    ):
        self.end_users = end_users
        self.permission = permission

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_users is not None:
            result['EndUsers'] = self.end_users
        if self.permission is not None:
            result['Permission'] = self.permission
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndUsers') is not None:
            self.end_users = m.get('EndUsers')
        if m.get('Permission') is not None:
            self.permission = m.get('Permission')
        return self


class DescribeCloudDrivePermissionsResponseBody(TeaModel):
    def __init__(
        self,
        cloud_drive_permission_models: List[DescribeCloudDrivePermissionsResponseBodyCloudDrivePermissionModels] = None,
        request_id: str = None,
    ):
        self.cloud_drive_permission_models = cloud_drive_permission_models
        self.request_id = request_id

    def validate(self):
        if self.cloud_drive_permission_models:
            for k in self.cloud_drive_permission_models:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CloudDrivePermissionModels'] = []
        if self.cloud_drive_permission_models is not None:
            for k in self.cloud_drive_permission_models:
                result['CloudDrivePermissionModels'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cloud_drive_permission_models = []
        if m.get('CloudDrivePermissionModels') is not None:
            for k in m.get('CloudDrivePermissionModels'):
                temp_model = DescribeCloudDrivePermissionsResponseBodyCloudDrivePermissionModels()
                self.cloud_drive_permission_models.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCloudDrivePermissionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudDrivePermissionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudDrivePermissionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudDriveUsersRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
    ):
        # This parameter is required.
        self.cds_id = cds_id
        self.end_user_id = end_user_id
        self.max_results = max_results
        self.next_token = next_token
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCloudDriveUsersResponseBodyCloudDriveUsers(TeaModel):
    def __init__(
        self,
        drive_id: str = None,
        end_user_id: str = None,
        status: str = None,
        total_size: int = None,
        used_size: int = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.drive_id = drive_id
        self.end_user_id = end_user_id
        self.status = status
        self.total_size = total_size
        self.used_size = used_size
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drive_id is not None:
            result['DriveId'] = self.drive_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.status is not None:
            result['Status'] = self.status
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        if self.used_size is not None:
            result['UsedSize'] = self.used_size
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriveId') is not None:
            self.drive_id = m.get('DriveId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        if m.get('UsedSize') is not None:
            self.used_size = m.get('UsedSize')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeCloudDriveUsersResponseBody(TeaModel):
    def __init__(
        self,
        cloud_drive_users: List[DescribeCloudDriveUsersResponseBodyCloudDriveUsers] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.cloud_drive_users = cloud_drive_users
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.cloud_drive_users:
            for k in self.cloud_drive_users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CloudDriveUsers'] = []
        if self.cloud_drive_users is not None:
            for k in self.cloud_drive_users:
                result['CloudDriveUsers'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cloud_drive_users = []
        if m.get('CloudDriveUsers') is not None:
            for k in m.get('CloudDriveUsers'):
                temp_model = DescribeCloudDriveUsersResponseBodyCloudDriveUsers()
                self.cloud_drive_users.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCloudDriveUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudDriveUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudDriveUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeConfigGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_ids: List[str] = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        product_type: str = None,
        region_id: str = None,
        statuses: List[str] = None,
        type: str = None,
    ):
        # The ID of the configuration group.
        self.group_id = group_id
        # The IDs of the configuration groups.
        self.group_ids = group_ids
        # The name of the configuration group.
        self.name = name
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The service type of the configuration group.
        # 
        # Valid value:
        # 
        # *   CLOUD_DESKTOP: the cloud computer service.
        self.product_type = product_type
        # The ID of the region. Set the value to `cn-shanghai`.
        self.region_id = region_id
        # The status of the configuration groups.
        self.statuses = statuses
        # The type of the configuration group.
        # 
        # Valid value:
        # 
        # *   Timer: the scheduled task type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.statuses is not None:
            result['Statuses'] = self.statuses
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Statuses') is not None:
            self.statuses = m.get('Statuses')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeConfigGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        bind_count: int = None,
        bind_count_map: Dict[str, int] = None,
        description: str = None,
        group_id: str = None,
        name: str = None,
        product_type: str = None,
        status: str = None,
        type: str = None,
    ):
        # The number of resources that are bound to the configuration group.
        self.bind_count = bind_count
        # The number of bound cloud computers.
        self.bind_count_map = bind_count_map
        # The description of the configuration group.
        self.description = description
        # The ID of the configuration group.
        self.group_id = group_id
        # The name of the configuration group.
        self.name = name
        # The service type of the configuration group.
        # 
        # Valid values:
        # 
        # *   CLOUD_DESKTOP: the cloud computer service.
        self.product_type = product_type
        # The state of the configuration group.
        # 
        # Valid values:
        # 
        # *   AVAILABLE: The configuration group is available.
        # *   UNAVAILABLE: The configuration group is deleted.
        # *   DELETING: The configuration group is being deleted.
        # *   UPDATING: The configuration group is being modified.
        self.status = status
        # The type of the configuration group.
        # 
        # Valid values:
        # 
        # *   Timer: the scheduled task type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_count is not None:
            result['BindCount'] = self.bind_count
        if self.bind_count_map is not None:
            result['BindCountMap'] = self.bind_count_map
        if self.description is not None:
            result['Description'] = self.description
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindCount') is not None:
            self.bind_count = m.get('BindCount')
        if m.get('BindCountMap') is not None:
            self.bind_count_map = m.get('BindCountMap')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeConfigGroupResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeConfigGroupResponseBodyData] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The configuration groups.
        self.data = data
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeConfigGroupResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeConfigGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeConfigGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeConfigGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomizedListHeadersRequest(TeaModel):
    def __init__(
        self,
        lang_type: str = None,
        list_type: str = None,
        region_id: str = None,
    ):
        self.lang_type = lang_type
        self.list_type = list_type
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang_type is not None:
            result['LangType'] = self.lang_type
        if self.list_type is not None:
            result['ListType'] = self.list_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LangType') is not None:
            self.lang_type = m.get('LangType')
        if m.get('ListType') is not None:
            self.list_type = m.get('ListType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCustomizedListHeadersResponseBodyHeaders(TeaModel):
    def __init__(
        self,
        display_type: str = None,
        header_key: str = None,
        header_name: str = None,
    ):
        self.display_type = display_type
        self.header_key = header_key
        self.header_name = header_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_type is not None:
            result['DisplayType'] = self.display_type
        if self.header_key is not None:
            result['HeaderKey'] = self.header_key
        if self.header_name is not None:
            result['HeaderName'] = self.header_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayType') is not None:
            self.display_type = m.get('DisplayType')
        if m.get('HeaderKey') is not None:
            self.header_key = m.get('HeaderKey')
        if m.get('HeaderName') is not None:
            self.header_name = m.get('HeaderName')
        return self


class DescribeCustomizedListHeadersResponseBody(TeaModel):
    def __init__(
        self,
        headers: List[DescribeCustomizedListHeadersResponseBodyHeaders] = None,
        request_id: str = None,
    ):
        self.headers = headers
        self.request_id = request_id

    def validate(self):
        if self.headers:
            for k in self.headers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Headers'] = []
        if self.headers is not None:
            for k in self.headers:
                result['Headers'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.headers = []
        if m.get('Headers') is not None:
            for k in m.get('Headers'):
                temp_model = DescribeCustomizedListHeadersResponseBodyHeaders()
                self.headers.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCustomizedListHeadersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomizedListHeadersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomizedListHeadersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopGroupSessionsRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        end_user_id: str = None,
        max_results: int = None,
        next_token: str = None,
        own_type: int = None,
        region_id: str = None,
        session_status: str = None,
        start_time: str = None,
    ):
        # The end of the time range to query.
        self.end_time = end_time
        # The ID of the end user.
        self.end_user_id = end_user_id
        # The number of entries per page.
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The type of the session.
        # 
        # Valid values:
        # 
        # *   0: single-session
        # *   1: multi-session
        self.own_type = own_type
        # The region ID.
        self.region_id = region_id
        # The status of the session.
        # 
        # Valid values:
        # 
        # *   Connected
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Disconnected
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.session_status = session_status
        # The beginning of the time range to query.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.own_type is not None:
            result['OwnType'] = self.own_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.session_status is not None:
            result['SessionStatus'] = self.session_status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnType') is not None:
            self.own_type = m.get('OwnType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SessionStatus') is not None:
            self.session_status = m.get('SessionStatus')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDesktopGroupSessionsResponseBodySessions(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        client_os: str = None,
        client_version: str = None,
        desktop_group_id: str = None,
        desktop_group_name: str = None,
        desktop_id: str = None,
        end_user_apply_coordinate_time: int = None,
        end_user_id: str = None,
        last_session_end_time: str = None,
        last_session_start_time: str = None,
        latest_connection_time: int = None,
        office_site_id: str = None,
        office_site_name: str = None,
        os_type: str = None,
        own_type: int = None,
        protocol_type: str = None,
        session_idle_time: int = None,
        session_status: str = None,
        total_connection_duration: int = None,
    ):
        # The IP address of the client.
        self.client_ip = client_ip
        # The OS that the client runs.
        self.client_os = client_os
        # The version of the client.
        self.client_version = client_version
        # The ID of the desktop group.
        self.desktop_group_id = desktop_group_id
        # The name of the desktop group.
        self.desktop_group_name = desktop_group_name
        # If the session is being established, the value of this parameter indicates the ID of the current cloud desktop. If the session is disconnected, the value of this parameter indicates the ID of the cloud desktop that was most recently connected.
        self.desktop_id = desktop_id
        # The point in time when the end user applies for administrator assistance.
        self.end_user_apply_coordinate_time = end_user_apply_coordinate_time
        # The ID of the end user.
        self.end_user_id = end_user_id
        # The end time of the most recent connection.
        self.last_session_end_time = last_session_end_time
        # The start time of the most recent connection.
        self.last_session_start_time = last_session_start_time
        # The duration of the most recent session.
        self.latest_connection_time = latest_connection_time
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The name of the workspace.
        self.office_site_name = office_site_name
        # The OS. Valid values:
        # 
        # *   Windows
        # *   Linux
        self.os_type = os_type
        # The type of the session.
        # 
        # Valid values:
        # 
        # *   0: single-session
        # *   1: multi-session
        self.own_type = own_type
        # The type of the protocol.
        self.protocol_type = protocol_type
        # The duration during which the cloud desktop stays in the Idle state.
        self.session_idle_time = session_idle_time
        # The state of the session.
        # 
        # Valid values:
        # 
        # *   Connected
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Disconnected
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.session_status = session_status
        # The total duration of the sessions.
        self.total_connection_duration = total_connection_duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.client_os is not None:
            result['ClientOS'] = self.client_os
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_name is not None:
            result['DesktopGroupName'] = self.desktop_group_name
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.end_user_apply_coordinate_time is not None:
            result['EndUserApplyCoordinateTime'] = self.end_user_apply_coordinate_time
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.last_session_end_time is not None:
            result['LastSessionEndTime'] = self.last_session_end_time
        if self.last_session_start_time is not None:
            result['LastSessionStartTime'] = self.last_session_start_time
        if self.latest_connection_time is not None:
            result['LatestConnectionTime'] = self.latest_connection_time
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.own_type is not None:
            result['OwnType'] = self.own_type
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.session_idle_time is not None:
            result['SessionIdleTime'] = self.session_idle_time
        if self.session_status is not None:
            result['SessionStatus'] = self.session_status
        if self.total_connection_duration is not None:
            result['TotalConnectionDuration'] = self.total_connection_duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('ClientOS') is not None:
            self.client_os = m.get('ClientOS')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupName') is not None:
            self.desktop_group_name = m.get('DesktopGroupName')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('EndUserApplyCoordinateTime') is not None:
            self.end_user_apply_coordinate_time = m.get('EndUserApplyCoordinateTime')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('LastSessionEndTime') is not None:
            self.last_session_end_time = m.get('LastSessionEndTime')
        if m.get('LastSessionStartTime') is not None:
            self.last_session_start_time = m.get('LastSessionStartTime')
        if m.get('LatestConnectionTime') is not None:
            self.latest_connection_time = m.get('LatestConnectionTime')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('OwnType') is not None:
            self.own_type = m.get('OwnType')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('SessionIdleTime') is not None:
            self.session_idle_time = m.get('SessionIdleTime')
        if m.get('SessionStatus') is not None:
            self.session_status = m.get('SessionStatus')
        if m.get('TotalConnectionDuration') is not None:
            self.total_connection_duration = m.get('TotalConnectionDuration')
        return self


class DescribeDesktopGroupSessionsResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        request_id: str = None,
        sessions: List[DescribeDesktopGroupSessionsResponseBodySessions] = None,
        total_count: int = None,
    ):
        # A pagination token. It can be used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id
        # The sessions.
        self.sessions = sessions
        # The total number of sessions.
        self.total_count = total_count

    def validate(self):
        if self.sessions:
            for k in self.sessions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Sessions'] = []
        if self.sessions is not None:
            for k in self.sessions:
                result['Sessions'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.sessions = []
        if m.get('Sessions') is not None:
            for k in m.get('Sessions'):
                temp_model = DescribeDesktopGroupSessionsResponseBodySessions()
                self.sessions.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDesktopGroupSessionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopGroupSessionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopGroupSessionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopGroupsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag. If you specify the `Tag` parameter, you must also specify the `Key` parameter. The tag key can be up to 128 characters in length and cannot contain `http://` or `https://`. The tag key cannot start with `aliyun` or `acs:`. You cannot specify an empty string as a tag key.
        self.key = key
        # The value of the tag. The tag value can be an empty string. The tag value can be up to 128 characters in length. It cannot start with `acs:` and cannot contain `http://` or `https://`.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDesktopGroupsRequest(TeaModel):
    def __init__(
        self,
        bundle_id: List[str] = None,
        desktop_group_id: str = None,
        desktop_group_ids: List[str] = None,
        desktop_group_name: str = None,
        end_user_ids: List[str] = None,
        excluded_end_user_ids: List[str] = None,
        image_id: List[str] = None,
        max_results: int = None,
        multi_resource: bool = None,
        next_token: str = None,
        office_site_id: str = None,
        own_type: int = None,
        period: int = None,
        period_unit: str = None,
        policy_group_id: str = None,
        protocol_type: str = None,
        region_id: str = None,
        status: int = None,
        tag: List[DescribeDesktopGroupsRequestTag] = None,
    ):
        # The IDs of the cloud computer templates.
        self.bundle_id = bundle_id
        # The ID of the cloud computer pool.
        self.desktop_group_id = desktop_group_id
        self.desktop_group_ids = desktop_group_ids
        # The name of the cloud computer pool to query. Fuzzy search is supported.
        self.desktop_group_name = desktop_group_name
        # The authorized user IDs of cloud computer pools.
        self.end_user_ids = end_user_ids
        # The authorized users that you want to exclude.
        self.excluded_end_user_ids = excluded_end_user_ids
        # The IDs of the images.
        self.image_id = image_id
        # The number of entries to return on each page. Valid values: 1 to 100. Default value: 10.
        self.max_results = max_results
        self.multi_resource = multi_resource
        # The pagination token that is used in the next request to retrieve a new page of results. If the NextToken parameter is empty, no next page exists.
        self.next_token = next_token
        # The ID of the office network to which the cloud computer pool belongs.
        self.office_site_id = office_site_id
        # The type of the cloud computer pool.
        # 
        # >  This parameter is not publicly available.
        # 
        # Valid values:
        # 
        # *   0: individual (single session)
        # *   1: shared (multiple sessions)
        self.own_type = own_type
        # The subscription duration of the cloud computer pool. The unit is specified by the `PeriodUnit` parameter.
        # 
        # *   Valid values if the `PeriodUnit` parameter is set to `Month`:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   6
        # 
        # *   Valid values if the `PeriodUnit` parameter is set to `Year`:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   4
        #     *   5
        self.period = period
        # The unit of the subscription duration.
        self.period_unit = period_unit
        # The ID of the policy that you want to associate with the cloud computer pool.
        self.policy_group_id = policy_group_id
        # The protocol type.
        # 
        # Valid values:
        # 
        # *   High-definition Experience (HDX)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Adaptive Streaming Protocol (ASP)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.protocol_type = protocol_type
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the regions supported by WUYING Workspace.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The payment status of the cloud computer pool.
        # 
        # Valid values:
        # 
        # *   0: unpaid
        # *   1: paid
        # *   2: overdue or expired
        self.status = status
        # The tags attached to the cloud computer pool. You can specify 1 to 20 tags.
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_ids is not None:
            result['DesktopGroupIds'] = self.desktop_group_ids
        if self.desktop_group_name is not None:
            result['DesktopGroupName'] = self.desktop_group_name
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.excluded_end_user_ids is not None:
            result['ExcludedEndUserIds'] = self.excluded_end_user_ids
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.multi_resource is not None:
            result['MultiResource'] = self.multi_resource
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.own_type is not None:
            result['OwnType'] = self.own_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupIds') is not None:
            self.desktop_group_ids = m.get('DesktopGroupIds')
        if m.get('DesktopGroupName') is not None:
            self.desktop_group_name = m.get('DesktopGroupName')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('ExcludedEndUserIds') is not None:
            self.excluded_end_user_ids = m.get('ExcludedEndUserIds')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('MultiResource') is not None:
            self.multi_resource = m.get('MultiResource')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OwnType') is not None:
            self.own_type = m.get('OwnType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDesktopGroupsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDesktopGroupsResponseBodyDesktopGroupsCountPerStatus(TeaModel):
    def __init__(
        self,
        count: int = None,
        status: str = None,
    ):
        # The total number of cloud computers.
        self.count = count
        # The status of the cloud computer.
        # 
        # Valid values:
        # 
        # *   Stopped
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Starting
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Rebuilding
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Running
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Stopping
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Expired
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Deleted
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Pending
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDesktopGroupsResponseBodyDesktopGroupsTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag.
        self.key = key
        # The value of the tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDesktopGroupsResponseBodyDesktopGroups(TeaModel):
    def __init__(
        self,
        bind_amount: int = None,
        buy_desktops_count: int = None,
        comments: str = None,
        connect_duration: int = None,
        count_per_status: List[DescribeDesktopGroupsResponseBodyDesktopGroupsCountPerStatus] = None,
        cpu: int = None,
        create_time: str = None,
        creator: str = None,
        data_disk_category: str = None,
        data_disk_size: str = None,
        desktop_count: int = None,
        desktop_group_id: str = None,
        desktop_group_name: str = None,
        desktop_type: str = None,
        end_user_count: int = None,
        expired_time: str = None,
        gpu_count: float = None,
        gpu_driver_version: str = None,
        gpu_spec: str = None,
        idle_disconnect_duration: int = None,
        image_id: str = None,
        keep_duration: int = None,
        load_policy: int = None,
        max_desktops_count: int = None,
        memory: int = None,
        min_desktops_count: int = None,
        office_site_id: str = None,
        office_site_name: str = None,
        office_site_type: str = None,
        os_type: str = None,
        own_bundle_id: str = None,
        own_bundle_name: str = None,
        own_type: int = None,
        pay_type: str = None,
        policy_group_id: str = None,
        policy_group_name: str = None,
        protocol_type: str = None,
        ratio_threshold: float = None,
        reset_type: int = None,
        status: int = None,
        stop_duration: int = None,
        subnet_id: str = None,
        system_disk_category: str = None,
        system_disk_size: int = None,
        tags: List[DescribeDesktopGroupsResponseBodyDesktopGroupsTags] = None,
        version: int = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
    ):
        # The number of concurrent sessions that is allowed for each cloud computer pool in a multi-session cloud computer pool.
        self.bind_amount = bind_amount
        # *   This parameter has different meanings based on the billing method of the cloud computer pool. For a subscription pool, this parameter specifies the number of cloud computers to purchase in the pool. Valid values: 0 to 200.
        # *   For a pay-as-you-go pool, this parameter specifies the minimum number of cloud computers to create in the pool. Valid values: 0 to `MaxDesktopsCount`. Default value: 1.
        self.buy_desktops_count = buy_desktops_count
        # The remarks.
        self.comments = comments
        # The maximum period of time during which a session is connected. When the specified maximum period of time is reached, the session is automatically disconnected. Unit: milliseconds.
        self.connect_duration = connect_duration
        # The number of cloud computers in each state.
        self.count_per_status = count_per_status
        # The number of vCPUs.
        self.cpu = cpu
        # The time when the cloud computer pool was created.
        self.create_time = create_time
        # The Alibaba Cloud account that creates the cloud computer pool.
        self.creator = creator
        # The category of the user disk.
        # 
        # Valid values:
        # 
        # *   cloud_efficiency: ultra disk
        # *   cloud_ssd: standard SSD
        # *   cloud_essd: enhanced SSD (ESSD)
        self.data_disk_category = data_disk_category
        # The user disk capacity. Unit: GiB.
        self.data_disk_size = data_disk_size
        # The number of cloud computers that are created.
        self.desktop_count = desktop_count
        # The ID of the cloud computer pool.
        self.desktop_group_id = desktop_group_id
        # The name of the cloud computer pool.
        self.desktop_group_name = desktop_group_name
        # The cloud computer type. You can call the [DescribeDesktopTypes](https://help.aliyun.com/document_detail/188882.html) operation to query the IDs of the cloud computer types supported by WUYING Workspace.
        self.desktop_type = desktop_type
        # The number of users that are granted permissions to use the cloud computer pool.
        self.end_user_count = end_user_count
        # The time when the subscription cloud computer pool expires.
        self.expired_time = expired_time
        # The number of GPUs.
        self.gpu_count = gpu_count
        # The version of the GPU driver.
        self.gpu_driver_version = gpu_driver_version
        # The GPU memory.
        self.gpu_spec = gpu_spec
        # The period of time after which a session is closed. After an end user connects to a cloud computer, the session is established. If the system does not detect inputs from the keyboard or mouse within the specified period of time, the session is closed. Unit: milliseconds.
        self.idle_disconnect_duration = idle_disconnect_duration
        # The ID of the image.
        self.image_id = image_id
        # The keep-alive duration of a session after the session is disconnected. Valid values: 180000 (3 minutes) to 345600000 (4 days). Unit: milliseconds. If you set this parameter to 0, the session is permanently retained after it is disconnected.
        # 
        # When a session is disconnected, take note of the following situations: If an end user does not resume the session within the specified duration, the session is closed and all unsaved data is cleared. If the end user resumes the session within the specified duration, the end user can continue to access data of the session.
        self.keep_duration = keep_duration
        # The load balancing policy of the multi-session cloud computer pool.
        # 
        # Valid values:
        # 
        # *   0: depth-first
        # *   1: breadth-first
        self.load_policy = load_policy
        # The maximum number of cloud computers that can be housed in the pay-as-you-go cloud computer pool.
        self.max_desktops_count = max_desktops_count
        # The memory size. Unit: MiB.
        self.memory = memory
        # The maximum number of cloud computers that can be automatically created in the subscription cloud computer pool.
        self.min_desktops_count = min_desktops_count
        # The name of the office network in which the cloud computer pool resides.
        self.office_site_id = office_site_id
        # The ID of the office network to which the cloud computer pool belongs.
        self.office_site_name = office_site_name
        # The account type of the office network.
        # 
        # Valid values:
        # 
        # *   PERSONAL: individual office network
        # *   SIMPLE: convenience office network
        # *   AD_CONNECTOR: enterprise Active Directory (AD) office network
        # *   RAM: Resource Access Management (RAM)-based office network
        self.office_site_type = office_site_type
        # The OS.
        # 
        # Valid values:
        # 
        # *   Linux
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.os_type = os_type
        # The ID of the cloud computer template.
        self.own_bundle_id = own_bundle_id
        # The name of the cloud computer template.
        self.own_bundle_name = own_bundle_name
        # The type of the cloud computer pool.
        # 
        # Valid values:
        # 
        # *   0: individual (single session)
        # *   1: shared (multiple sessions)
        self.own_type = own_type
        # The billing method of the cloud computer pool.
        # 
        # Valid values:
        # 
        # *   PostPaid: pay-as-you-go
        # *   PrePaid: subscription
        self.pay_type = pay_type
        # The ID of the policy that is associated with the cloud computer pool.
        self.policy_group_id = policy_group_id
        # The name of the policy that is associated with the cloud computer pool.
        self.policy_group_name = policy_group_name
        # The protocol type.
        # 
        # Valid values:
        # 
        # *   HDX
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ASP
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.protocol_type = protocol_type
        # The threshold for the ratio of connected sessions. This parameter indicates the condition that triggers auto scaling in a multi-session cloud computer pool. The ratio of connected sessions is calculated by using the following formula:
        # 
        # `Ratio of connected sessions = Number of connected sessions/(Total number of cloud computers × Maximum number of sessions allowed for each cloud computer) × 100%`.
        # 
        # When the specified threshold is reached, new cloud computers are automatically created. When the specified threshold is not reached, idle cloud computers are released.
        self.ratio_threshold = ratio_threshold
        # The disk reset type of the cloud computer pool.
        # 
        # Valid values:
        # 
        # *   0: does not reset disks
        # *   1: resets only the system disks
        # *   2: resets only the user disks
        # *   3: resets the system disks and user disks
        self.reset_type = reset_type
        # The payment status of the cloud computer pool.
        # 
        # Valid values:
        # 
        # *   0: unpaid
        # *   1: paid
        # *   2: overdue or expired
        self.status = status
        # The period of time after which an idle cloud computer is stopped. When the specified period of time is reached, the cloud computer is automatically stopped. If an end user connects to the stopped cloud computer, the cloud computer is automatically started. Unit: milliseconds.
        self.stop_duration = stop_duration
        # The ID of the subnet.
        self.subnet_id = subnet_id
        # The category of the system disk.
        # 
        # Valid values:
        # 
        # *   cloud_efficiency: ultra disk
        # *   cloud_ssd: standard SSD
        # *   cloud_essd: enhanced SSD (ESSD)
        self.system_disk_category = system_disk_category
        # The system disk capacity. Unit: GiB.
        self.system_disk_size = system_disk_size
        # The tags attached to the cloud computer pool.
        self.tags = tags
        # The version number of the cloud computer pool.
        self.version = version
        # Indicates whether disk encryption is enabled.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key for disk encryption.
        self.volume_encryption_key = volume_encryption_key

    def validate(self):
        if self.count_per_status:
            for k in self.count_per_status:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_amount is not None:
            result['BindAmount'] = self.bind_amount
        if self.buy_desktops_count is not None:
            result['BuyDesktopsCount'] = self.buy_desktops_count
        if self.comments is not None:
            result['Comments'] = self.comments
        if self.connect_duration is not None:
            result['ConnectDuration'] = self.connect_duration
        result['CountPerStatus'] = []
        if self.count_per_status is not None:
            for k in self.count_per_status:
                result['CountPerStatus'].append(k.to_map() if k else None)
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.desktop_count is not None:
            result['DesktopCount'] = self.desktop_count
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_name is not None:
            result['DesktopGroupName'] = self.desktop_group_name
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.end_user_count is not None:
            result['EndUserCount'] = self.end_user_count
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.gpu_spec is not None:
            result['GpuSpec'] = self.gpu_spec
        if self.idle_disconnect_duration is not None:
            result['IdleDisconnectDuration'] = self.idle_disconnect_duration
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.keep_duration is not None:
            result['KeepDuration'] = self.keep_duration
        if self.load_policy is not None:
            result['LoadPolicy'] = self.load_policy
        if self.max_desktops_count is not None:
            result['MaxDesktopsCount'] = self.max_desktops_count
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.min_desktops_count is not None:
            result['MinDesktopsCount'] = self.min_desktops_count
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.office_site_type is not None:
            result['OfficeSiteType'] = self.office_site_type
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.own_bundle_id is not None:
            result['OwnBundleId'] = self.own_bundle_id
        if self.own_bundle_name is not None:
            result['OwnBundleName'] = self.own_bundle_name
        if self.own_type is not None:
            result['OwnType'] = self.own_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.policy_group_name is not None:
            result['PolicyGroupName'] = self.policy_group_name
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.ratio_threshold is not None:
            result['RatioThreshold'] = self.ratio_threshold
        if self.reset_type is not None:
            result['ResetType'] = self.reset_type
        if self.status is not None:
            result['Status'] = self.status
        if self.stop_duration is not None:
            result['StopDuration'] = self.stop_duration
        if self.subnet_id is not None:
            result['SubnetId'] = self.subnet_id
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.version is not None:
            result['Version'] = self.version
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindAmount') is not None:
            self.bind_amount = m.get('BindAmount')
        if m.get('BuyDesktopsCount') is not None:
            self.buy_desktops_count = m.get('BuyDesktopsCount')
        if m.get('Comments') is not None:
            self.comments = m.get('Comments')
        if m.get('ConnectDuration') is not None:
            self.connect_duration = m.get('ConnectDuration')
        self.count_per_status = []
        if m.get('CountPerStatus') is not None:
            for k in m.get('CountPerStatus'):
                temp_model = DescribeDesktopGroupsResponseBodyDesktopGroupsCountPerStatus()
                self.count_per_status.append(temp_model.from_map(k))
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('DesktopCount') is not None:
            self.desktop_count = m.get('DesktopCount')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupName') is not None:
            self.desktop_group_name = m.get('DesktopGroupName')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('EndUserCount') is not None:
            self.end_user_count = m.get('EndUserCount')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('GpuSpec') is not None:
            self.gpu_spec = m.get('GpuSpec')
        if m.get('IdleDisconnectDuration') is not None:
            self.idle_disconnect_duration = m.get('IdleDisconnectDuration')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('KeepDuration') is not None:
            self.keep_duration = m.get('KeepDuration')
        if m.get('LoadPolicy') is not None:
            self.load_policy = m.get('LoadPolicy')
        if m.get('MaxDesktopsCount') is not None:
            self.max_desktops_count = m.get('MaxDesktopsCount')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('MinDesktopsCount') is not None:
            self.min_desktops_count = m.get('MinDesktopsCount')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OfficeSiteType') is not None:
            self.office_site_type = m.get('OfficeSiteType')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('OwnBundleId') is not None:
            self.own_bundle_id = m.get('OwnBundleId')
        if m.get('OwnBundleName') is not None:
            self.own_bundle_name = m.get('OwnBundleName')
        if m.get('OwnType') is not None:
            self.own_type = m.get('OwnType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('PolicyGroupName') is not None:
            self.policy_group_name = m.get('PolicyGroupName')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RatioThreshold') is not None:
            self.ratio_threshold = m.get('RatioThreshold')
        if m.get('ResetType') is not None:
            self.reset_type = m.get('ResetType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StopDuration') is not None:
            self.stop_duration = m.get('StopDuration')
        if m.get('SubnetId') is not None:
            self.subnet_id = m.get('SubnetId')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeDesktopGroupsResponseBodyDesktopGroupsTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        return self


class DescribeDesktopGroupsResponseBody(TeaModel):
    def __init__(
        self,
        desktop_groups: List[DescribeDesktopGroupsResponseBodyDesktopGroups] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The cloud computer pools.
        self.desktop_groups = desktop_groups
        # The returned value of NextToken is a pagination token, which can be used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.desktop_groups:
            for k in self.desktop_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DesktopGroups'] = []
        if self.desktop_groups is not None:
            for k in self.desktop_groups:
                result['DesktopGroups'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.desktop_groups = []
        if m.get('DesktopGroups') is not None:
            for k in m.get('DesktopGroups'):
                temp_model = DescribeDesktopGroupsResponseBodyDesktopGroups()
                self.desktop_groups.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDesktopGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopInfoRequest(TeaModel):
    def __init__(
        self,
        desktop_id: List[str] = None,
        region_id: str = None,
    ):
        # The IDs of the cloud computers. You can specify 1 to 100 IDs.
        self.desktop_id = desktop_id
        # The ID of the region. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the regions supported by Elastic Desktop Service.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDesktopInfoResponseBodyDesktops(TeaModel):
    def __init__(
        self,
        connection_status: str = None,
        current_app_version: str = None,
        desktop_group_id: str = None,
        desktop_id: str = None,
        desktop_status: str = None,
        management_flag: List[str] = None,
        new_app_size: int = None,
        new_app_version: str = None,
        release_note: str = None,
        start_time: str = None,
    ):
        # The connection status of the user.
        # 
        # Valid values:
        # 
        # *   Connected
        # *   Disconnected
        self.connection_status = connection_status
        # The version of the cloud computer image.
        self.current_app_version = current_app_version
        # The ID of the cloud computer pool.
        self.desktop_group_id = desktop_group_id
        # The ID of the cloud computer.
        self.desktop_id = desktop_id
        # The status of the cloud computer.
        # 
        # Valid values:
        # 
        # *   Stopped
        # *   Failed
        # *   Starting
        # *   Running
        # *   Stopping
        # *   Expired
        # *   Deleted
        # *   Pending
        self.desktop_status = desktop_status
        # The information about flags that are used to manage cloud computers.
        self.management_flag = management_flag
        # The size of the update package. Unit: KB.
        self.new_app_size = new_app_size
        # The version number of the image that can be updated on the cloud computer.
        self.new_app_version = new_app_version
        # The description of the image version that can be updated.
        self.release_note = release_note
        # The time when the cloud computer was first started.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_status is not None:
            result['ConnectionStatus'] = self.connection_status
        if self.current_app_version is not None:
            result['CurrentAppVersion'] = self.current_app_version
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_status is not None:
            result['DesktopStatus'] = self.desktop_status
        if self.management_flag is not None:
            result['ManagementFlag'] = self.management_flag
        if self.new_app_size is not None:
            result['NewAppSize'] = self.new_app_size
        if self.new_app_version is not None:
            result['NewAppVersion'] = self.new_app_version
        if self.release_note is not None:
            result['ReleaseNote'] = self.release_note
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionStatus') is not None:
            self.connection_status = m.get('ConnectionStatus')
        if m.get('CurrentAppVersion') is not None:
            self.current_app_version = m.get('CurrentAppVersion')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopStatus') is not None:
            self.desktop_status = m.get('DesktopStatus')
        if m.get('ManagementFlag') is not None:
            self.management_flag = m.get('ManagementFlag')
        if m.get('NewAppSize') is not None:
            self.new_app_size = m.get('NewAppSize')
        if m.get('NewAppVersion') is not None:
            self.new_app_version = m.get('NewAppVersion')
        if m.get('ReleaseNote') is not None:
            self.release_note = m.get('ReleaseNote')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDesktopInfoResponseBody(TeaModel):
    def __init__(
        self,
        desktops: List[DescribeDesktopInfoResponseBodyDesktops] = None,
        request_id: str = None,
    ):
        # The basic information about cloud computers.
        self.desktops = desktops
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.desktops:
            for k in self.desktops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Desktops'] = []
        if self.desktops is not None:
            for k in self.desktops:
                result['Desktops'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.desktops = []
        if m.get('Desktops') is not None:
            for k in m.get('Desktops'):
                temp_model = DescribeDesktopInfoResponseBodyDesktops()
                self.desktops.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDesktopInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopOversoldGroupRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        oversold_group_ids: List[str] = None,
    ):
        self.max_results = max_results
        self.next_token = next_token
        self.oversold_group_ids = oversold_group_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.oversold_group_ids is not None:
            result['OversoldGroupIds'] = self.oversold_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OversoldGroupIds') is not None:
            self.oversold_group_ids = m.get('OversoldGroupIds')
        return self


class DescribeDesktopOversoldGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        concurrence_count: int = None,
        cur_concurrence_count: int = None,
        data_disk_size: int = None,
        description: str = None,
        desktop_type: str = None,
        directory_id: str = None,
        expire_time: str = None,
        idle_disconnect_duration: str = None,
        image_id: str = None,
        keep_duration: str = None,
        name: str = None,
        oversold_group_id: str = None,
        oversold_user_count: int = None,
        oversold_warn: int = None,
        policy_group_id: str = None,
        sale_status: str = None,
        status: str = None,
        stop_duration: int = None,
        system_disk_size: int = None,
    ):
        self.concurrence_count = concurrence_count
        self.cur_concurrence_count = cur_concurrence_count
        self.data_disk_size = data_disk_size
        self.description = description
        self.desktop_type = desktop_type
        self.directory_id = directory_id
        self.expire_time = expire_time
        self.idle_disconnect_duration = idle_disconnect_duration
        self.image_id = image_id
        self.keep_duration = keep_duration
        self.name = name
        self.oversold_group_id = oversold_group_id
        self.oversold_user_count = oversold_user_count
        self.oversold_warn = oversold_warn
        self.policy_group_id = policy_group_id
        self.sale_status = sale_status
        self.status = status
        self.stop_duration = stop_duration
        self.system_disk_size = system_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrence_count is not None:
            result['ConcurrenceCount'] = self.concurrence_count
        if self.cur_concurrence_count is not None:
            result['CurConcurrenceCount'] = self.cur_concurrence_count
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.idle_disconnect_duration is not None:
            result['IdleDisconnectDuration'] = self.idle_disconnect_duration
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.keep_duration is not None:
            result['KeepDuration'] = self.keep_duration
        if self.name is not None:
            result['Name'] = self.name
        if self.oversold_group_id is not None:
            result['OversoldGroupId'] = self.oversold_group_id
        if self.oversold_user_count is not None:
            result['OversoldUserCount'] = self.oversold_user_count
        if self.oversold_warn is not None:
            result['OversoldWarn'] = self.oversold_warn
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.sale_status is not None:
            result['SaleStatus'] = self.sale_status
        if self.status is not None:
            result['Status'] = self.status
        if self.stop_duration is not None:
            result['StopDuration'] = self.stop_duration
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcurrenceCount') is not None:
            self.concurrence_count = m.get('ConcurrenceCount')
        if m.get('CurConcurrenceCount') is not None:
            self.cur_concurrence_count = m.get('CurConcurrenceCount')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('IdleDisconnectDuration') is not None:
            self.idle_disconnect_duration = m.get('IdleDisconnectDuration')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('KeepDuration') is not None:
            self.keep_duration = m.get('KeepDuration')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OversoldGroupId') is not None:
            self.oversold_group_id = m.get('OversoldGroupId')
        if m.get('OversoldUserCount') is not None:
            self.oversold_user_count = m.get('OversoldUserCount')
        if m.get('OversoldWarn') is not None:
            self.oversold_warn = m.get('OversoldWarn')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('SaleStatus') is not None:
            self.sale_status = m.get('SaleStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StopDuration') is not None:
            self.stop_duration = m.get('StopDuration')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        return self


class DescribeDesktopOversoldGroupResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        data: List[DescribeDesktopOversoldGroupResponseBodyData] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.count = count
        self.data = data
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeDesktopOversoldGroupResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDesktopOversoldGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopOversoldGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopOversoldGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopOversoldUserRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        end_user_id: str = None,
        max_results: int = None,
        next_token: str = None,
        oversold_group_id: str = None,
        user_desktop_ids: List[str] = None,
        user_group_id: str = None,
    ):
        self.client_token = client_token
        self.end_user_id = end_user_id
        self.max_results = max_results
        self.next_token = next_token
        self.oversold_group_id = oversold_group_id
        self.user_desktop_ids = user_desktop_ids
        self.user_group_id = user_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.oversold_group_id is not None:
            result['OversoldGroupId'] = self.oversold_group_id
        if self.user_desktop_ids is not None:
            result['UserDesktopIds'] = self.user_desktop_ids
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OversoldGroupId') is not None:
            self.oversold_group_id = m.get('OversoldGroupId')
        if m.get('UserDesktopIds') is not None:
            self.user_desktop_ids = m.get('UserDesktopIds')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class DescribeDesktopOversoldUserResponseBodyData(TeaModel):
    def __init__(
        self,
        end_user_id: str = None,
        oversold_group_id: str = None,
        user_desktop_id: str = None,
        user_group_id: str = None,
    ):
        self.end_user_id = end_user_id
        self.oversold_group_id = oversold_group_id
        self.user_desktop_id = user_desktop_id
        self.user_group_id = user_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.oversold_group_id is not None:
            result['OversoldGroupId'] = self.oversold_group_id
        if self.user_desktop_id is not None:
            result['UserDesktopId'] = self.user_desktop_id
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('OversoldGroupId') is not None:
            self.oversold_group_id = m.get('OversoldGroupId')
        if m.get('UserDesktopId') is not None:
            self.user_desktop_id = m.get('UserDesktopId')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class DescribeDesktopOversoldUserResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        data: List[DescribeDesktopOversoldUserResponseBodyData] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.count = count
        self.data = data
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeDesktopOversoldUserResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDesktopOversoldUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopOversoldUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopOversoldUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopOversoldUserGroupRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        oversold_group_id: str = None,
        user_group_ids: List[str] = None,
    ):
        self.max_results = max_results
        self.next_token = next_token
        self.oversold_group_id = oversold_group_id
        self.user_group_ids = user_group_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.oversold_group_id is not None:
            result['OversoldGroupId'] = self.oversold_group_id
        if self.user_group_ids is not None:
            result['UserGroupIds'] = self.user_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OversoldGroupId') is not None:
            self.oversold_group_id = m.get('OversoldGroupId')
        if m.get('UserGroupIds') is not None:
            self.user_group_ids = m.get('UserGroupIds')
        return self


class DescribeDesktopOversoldUserGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        name: str = None,
        oversold_group_id: str = None,
        policy_group_id: str = None,
        user_group_id: str = None,
    ):
        self.image_id = image_id
        self.name = name
        self.oversold_group_id = oversold_group_id
        self.policy_group_id = policy_group_id
        self.user_group_id = user_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.name is not None:
            result['Name'] = self.name
        if self.oversold_group_id is not None:
            result['OversoldGroupId'] = self.oversold_group_id
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OversoldGroupId') is not None:
            self.oversold_group_id = m.get('OversoldGroupId')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class DescribeDesktopOversoldUserGroupResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        data: List[DescribeDesktopOversoldUserGroupResponseBodyData] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.count = count
        self.data = data
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeDesktopOversoldUserGroupResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDesktopOversoldUserGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopOversoldUserGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopOversoldUserGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopSessionsRequest(TeaModel):
    def __init__(
        self,
        check_os_session: bool = None,
        desktop_id: List[str] = None,
        desktop_name: str = None,
        end_time: str = None,
        end_user_id: str = None,
        end_user_id_filter: str = None,
        office_site_id: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        session_status: str = None,
        start_time: str = None,
        sub_pay_type: str = None,
    ):
        # Specifies whether to turn on the switch to check session status of cloud computers.
        self.check_os_session = check_os_session
        # The IDs of the cloud computers. You can specify the IDs of 1 to 100 cloud computers.
        self.desktop_id = desktop_id
        # The name of the cloud computer.
        self.desktop_name = desktop_name
        # The end of the time range to query.
        self.end_time = end_time
        # The ID of the end user.
        self.end_user_id = end_user_id
        # The ID the end user. It is the same as EndUserId. Either one of these two parameters is required.
        self.end_user_id_filter = end_user_id_filter
        # The ID of the office network.
        self.office_site_id = office_site_id
        # The page number.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The region ID. You can call the [DescribeRegions](~~DescribeRegions~~) operation to query the regions supported by Elastic Desktop Service (EDS).
        # 
        # This parameter is required.
        self.region_id = region_id
        # The state of the session.
        # 
        # Valid values:
        # 
        # *   Connected
        # *   Disconnected
        self.session_status = session_status
        # The start of the time range to query.
        self.start_time = start_time
        # The billing method of cloud computers.
        # 
        # Valid values:
        # 
        # *   duration: hourly plan (available for users in the whitelist)
        # *   postPaid: pay-as-you-go
        # *   monthPackage: monthly subscription (the 120-hour/250-hour computing plan)
        # *   prePaid: monthly subscription (the Unlimited computing plan)
        self.sub_pay_type = sub_pay_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_os_session is not None:
            result['CheckOsSession'] = self.check_os_session
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.end_user_id_filter is not None:
            result['EndUserIdFilter'] = self.end_user_id_filter
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.session_status is not None:
            result['SessionStatus'] = self.session_status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.sub_pay_type is not None:
            result['SubPayType'] = self.sub_pay_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckOsSession') is not None:
            self.check_os_session = m.get('CheckOsSession')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EndUserIdFilter') is not None:
            self.end_user_id_filter = m.get('EndUserIdFilter')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SessionStatus') is not None:
            self.session_status = m.get('SessionStatus')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SubPayType') is not None:
            self.sub_pay_type = m.get('SubPayType')
        return self


class DescribeDesktopSessionsResponseBodySessions(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        client_os: str = None,
        client_version: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        end_user_apply_coordinate_time: int = None,
        end_user_id: str = None,
        latest_connection_time: int = None,
        office_site_id: str = None,
        office_site_name: str = None,
        os_session_status: str = None,
        os_type: str = None,
        protocol_type: str = None,
        session_end_time: str = None,
        session_idle_time: int = None,
        session_start_time: str = None,
        session_status: str = None,
        sub_pay_type: str = None,
        total_connection_time: int = None,
    ):
        # The IP address of the client.
        self.client_ip = client_ip
        # The client OS.
        self.client_os = client_os
        # The client version.
        self.client_version = client_version
        # The ID of the cloud computer.
        self.desktop_id = desktop_id
        # The name of the cloud computer.
        self.desktop_name = desktop_name
        # The duration of the remote assistance. Unit: seconds.
        self.end_user_apply_coordinate_time = end_user_apply_coordinate_time
        # The ID of the end user.
        self.end_user_id = end_user_id
        # The duration of the last connection to the cloud computer. Unit: seconds.
        self.latest_connection_time = latest_connection_time
        # The ID of the office network.
        self.office_site_id = office_site_id
        # The name of the office network.
        self.office_site_name = office_site_name
        # Indicates whether the switch to check session status of cloud computers is turned on.
        self.os_session_status = os_session_status
        # The OS.
        # 
        # Valid values:
        # 
        # *   Linux
        # *   Windows
        self.os_type = os_type
        # The protocol type.
        # 
        # Valid values:
        # 
        # *   HDX
        # *   ASP
        self.protocol_type = protocol_type
        # The end time of the session.
        self.session_end_time = session_end_time
        # The idle duration of the session. Unit: seconds.
        self.session_idle_time = session_idle_time
        # The start time of the session.
        self.session_start_time = session_start_time
        # The state of the session.
        # 
        # Valid values:
        # 
        # *   Connected
        # *   Disconnected
        self.session_status = session_status
        # The billing method of cloud computers.
        # 
        # Valid values:
        # 
        # *   duration: hourly plan (available for users in the whitelist)
        # *   postPaid: pay-as-you-go
        # *   monthPackage: monthly subscription (120-hour computing plan and 250-hour computing plan)
        # *   prePaid: monthly subscription (Unlimited computing plan)
        self.sub_pay_type = sub_pay_type
        # The total connection duration. Unit: seconds.
        self.total_connection_time = total_connection_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.client_os is not None:
            result['ClientOS'] = self.client_os
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.end_user_apply_coordinate_time is not None:
            result['EndUserApplyCoordinateTime'] = self.end_user_apply_coordinate_time
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.latest_connection_time is not None:
            result['LatestConnectionTime'] = self.latest_connection_time
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.os_session_status is not None:
            result['OsSessionStatus'] = self.os_session_status
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.session_end_time is not None:
            result['SessionEndTime'] = self.session_end_time
        if self.session_idle_time is not None:
            result['SessionIdleTime'] = self.session_idle_time
        if self.session_start_time is not None:
            result['SessionStartTime'] = self.session_start_time
        if self.session_status is not None:
            result['SessionStatus'] = self.session_status
        if self.sub_pay_type is not None:
            result['SubPayType'] = self.sub_pay_type
        if self.total_connection_time is not None:
            result['TotalConnectionTime'] = self.total_connection_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('ClientOS') is not None:
            self.client_os = m.get('ClientOS')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('EndUserApplyCoordinateTime') is not None:
            self.end_user_apply_coordinate_time = m.get('EndUserApplyCoordinateTime')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('LatestConnectionTime') is not None:
            self.latest_connection_time = m.get('LatestConnectionTime')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OsSessionStatus') is not None:
            self.os_session_status = m.get('OsSessionStatus')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('SessionEndTime') is not None:
            self.session_end_time = m.get('SessionEndTime')
        if m.get('SessionIdleTime') is not None:
            self.session_idle_time = m.get('SessionIdleTime')
        if m.get('SessionStartTime') is not None:
            self.session_start_time = m.get('SessionStartTime')
        if m.get('SessionStatus') is not None:
            self.session_status = m.get('SessionStatus')
        if m.get('SubPayType') is not None:
            self.sub_pay_type = m.get('SubPayType')
        if m.get('TotalConnectionTime') is not None:
            self.total_connection_time = m.get('TotalConnectionTime')
        return self


class DescribeDesktopSessionsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sessions: List[DescribeDesktopSessionsResponseBodySessions] = None,
        total_count: int = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Details of sessions.
        self.sessions = sessions
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.sessions:
            for k in self.sessions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Sessions'] = []
        if self.sessions is not None:
            for k in self.sessions:
                result['Sessions'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.sessions = []
        if m.get('Sessions') is not None:
            for k in m.get('Sessions'):
                temp_model = DescribeDesktopSessionsResponseBodySessions()
                self.sessions.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDesktopSessionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopSessionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopSessionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopTypesRequest(TeaModel):
    def __init__(
        self,
        applied_scope: str = None,
        cpu_count: int = None,
        desktop_group_id_for_modify: str = None,
        desktop_id_for_modify: str = None,
        desktop_type_id: str = None,
        desktop_type_id_list: List[str] = None,
        gpu_count: float = None,
        gpu_driver_type: str = None,
        gpu_memory: int = None,
        instance_type_family: str = None,
        memory_size: int = None,
        order_by: str = None,
        order_type: str = None,
        region_id: str = None,
        scope: str = None,
        sort_type: str = None,
        support_min_session_count: int = None,
        zone_id: str = None,
    ):
        # Applicable Scope of specifications. Default value: `Public`
        self.applied_scope = applied_scope
        # The number of vCPUs.
        self.cpu_count = cpu_count
        # The ID of the cloud computer pool when you change instance types of cloud computers. If you specify this parameter, the information about whether the instance type is compatible with the cloud computer pool is included in the response.
        self.desktop_group_id_for_modify = desktop_group_id_for_modify
        # The ID of the cloud computer when you change instance types of cloud computers. If you specify this parameter, the information about whether the instance type is compatible with the cloud computer is included in the response.
        self.desktop_id_for_modify = desktop_id_for_modify
        # The IDs of the instance types of cloud computers.
        # 
        # >  If the values of the `InstanceTypeFamily` and `DesktopTypeId` parameters are empty, all instance types of cloud computers are queried.
        # 
        # Valid values:
        # 
        # *   eds.hf.4c8g
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ecd.basic.large
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ecd.advanced.large
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ecd.basic.small
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ecd.graphics.2xlarge
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.hf.8c16g
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.hf.12c24g
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.general.8c16g
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.general.16c32g
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ecd.advanced.xlarge
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.graphics.16c1t4
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ecd.graphics.xlarge
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ecd.performance.2xlarge
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.general.8c32g
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.general.2c2g
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.general.2c4g
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.graphics.24c1t4
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.general.4c8g
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.general.4c16g
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.general.2c8g
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.desktop_type_id = desktop_type_id
        # The array of specifications.
        self.desktop_type_id_list = desktop_type_id_list
        # The number of GPUs.
        self.gpu_count = gpu_count
        # The type of the pre-installed GPU driver. Valid values:
        # 
        # - T4
        # - A10
        # - G28
        # - G39
        self.gpu_driver_type = gpu_driver_type
        # The GPU memory size. Unit: MB.
        self.gpu_memory = gpu_memory
        # The name of the instance family.
        # 
        # >  If the values of the `InstanceTypeFamily` and `DesktopTypeId` parameters are empty, all instance families of cloud computers are queried.
        # 
        # Valid values:
        # 
        # *   ecd.advanced
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.graphics
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ecd.basic
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.hf
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ecd.graphics
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   eds.general
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ecd.performance
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.instance_type_family = instance_type_family
        # The memory size. Unit: MiB.
        self.memory_size = memory_size
        # The sort criterion. If left empty, the entries will be in descending order based on the creation time. Valid values:
        # 
        # - Memory: sort by memory size
        # - Cpu: sort by number of CPU cores
        self.order_by = order_by
        # The order type.
        self.order_type = order_type
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The sales mode. Valid values:
        # 
        # - MonthPackage: monthly subscription
        # - FastBuy: fast buy
        self.scope = scope
        # The sort order. Valid values:
        # 
        # - ASC: in ascending order [default]
        # - DESC: in descending order
        self.sort_type = sort_type
        # The number of sessions supported.
        self.support_min_session_count = support_min_session_count
        # > This parameter is not publicly available.
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applied_scope is not None:
            result['AppliedScope'] = self.applied_scope
        if self.cpu_count is not None:
            result['CpuCount'] = self.cpu_count
        if self.desktop_group_id_for_modify is not None:
            result['DesktopGroupIdForModify'] = self.desktop_group_id_for_modify
        if self.desktop_id_for_modify is not None:
            result['DesktopIdForModify'] = self.desktop_id_for_modify
        if self.desktop_type_id is not None:
            result['DesktopTypeId'] = self.desktop_type_id
        if self.desktop_type_id_list is not None:
            result['DesktopTypeIdList'] = self.desktop_type_id_list
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.gpu_driver_type is not None:
            result['GpuDriverType'] = self.gpu_driver_type
        if self.gpu_memory is not None:
            result['GpuMemory'] = self.gpu_memory
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.sort_type is not None:
            result['SortType'] = self.sort_type
        if self.support_min_session_count is not None:
            result['SupportMinSessionCount'] = self.support_min_session_count
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppliedScope') is not None:
            self.applied_scope = m.get('AppliedScope')
        if m.get('CpuCount') is not None:
            self.cpu_count = m.get('CpuCount')
        if m.get('DesktopGroupIdForModify') is not None:
            self.desktop_group_id_for_modify = m.get('DesktopGroupIdForModify')
        if m.get('DesktopIdForModify') is not None:
            self.desktop_id_for_modify = m.get('DesktopIdForModify')
        if m.get('DesktopTypeId') is not None:
            self.desktop_type_id = m.get('DesktopTypeId')
        if m.get('DesktopTypeIdList') is not None:
            self.desktop_type_id_list = m.get('DesktopTypeIdList')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('GpuDriverType') is not None:
            self.gpu_driver_type = m.get('GpuDriverType')
        if m.get('GpuMemory') is not None:
            self.gpu_memory = m.get('GpuMemory')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('MemorySize') is not None:
            self.memory_size = m.get('MemorySize')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SortType') is not None:
            self.sort_type = m.get('SortType')
        if m.get('SupportMinSessionCount') is not None:
            self.support_min_session_count = m.get('SupportMinSessionCount')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDesktopTypesResponseBodyDesktopTypes(TeaModel):
    def __init__(
        self,
        cpu_count: str = None,
        data_disk_size: str = None,
        desktop_type_id: str = None,
        desktop_type_status: str = None,
        gpu_count: float = None,
        gpu_memory: int = None,
        gpu_spec: str = None,
        instance_type_family: str = None,
        max_session_count: int = None,
        memory_size: str = None,
        scopes: List[str] = None,
        stock_state: str = None,
        system_disk_size: str = None,
    ):
        # The number of vCPUs.
        self.cpu_count = cpu_count
        # The size of the data disk. Unit: GiB.
        self.data_disk_size = data_disk_size
        # The ID of the cloud desktop type.
        self.desktop_type_id = desktop_type_id
        # The status of the cloud desktop type. If SUFFICIENT is returned, the number of cloud desktops of the type is sufficient.
        self.desktop_type_status = desktop_type_status
        # The number of GPUs.
        self.gpu_count = gpu_count
        # The GPU memory size. Unit: MB. This parameter applies to GPU-enabled cloud computers only.
        self.gpu_memory = gpu_memory
        # The GPU memory.
        self.gpu_spec = gpu_spec
        # The family of the cloud desktop type.
        self.instance_type_family = instance_type_family
        # The number of sessions supported by the current specification.
        self.max_session_count = max_session_count
        # The memory size. Unit: MiB.
        self.memory_size = memory_size
        # The array of sales modes.
        self.scopes = scopes
        # The stock status.
        self.stock_state = stock_state
        # The size of the system disk. Unit: GiB.
        self.system_disk_size = system_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_count is not None:
            result['CpuCount'] = self.cpu_count
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.desktop_type_id is not None:
            result['DesktopTypeId'] = self.desktop_type_id
        if self.desktop_type_status is not None:
            result['DesktopTypeStatus'] = self.desktop_type_status
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.gpu_memory is not None:
            result['GpuMemory'] = self.gpu_memory
        if self.gpu_spec is not None:
            result['GpuSpec'] = self.gpu_spec
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.max_session_count is not None:
            result['MaxSessionCount'] = self.max_session_count
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        if self.scopes is not None:
            result['Scopes'] = self.scopes
        if self.stock_state is not None:
            result['StockState'] = self.stock_state
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CpuCount') is not None:
            self.cpu_count = m.get('CpuCount')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('DesktopTypeId') is not None:
            self.desktop_type_id = m.get('DesktopTypeId')
        if m.get('DesktopTypeStatus') is not None:
            self.desktop_type_status = m.get('DesktopTypeStatus')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('GpuMemory') is not None:
            self.gpu_memory = m.get('GpuMemory')
        if m.get('GpuSpec') is not None:
            self.gpu_spec = m.get('GpuSpec')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('MaxSessionCount') is not None:
            self.max_session_count = m.get('MaxSessionCount')
        if m.get('MemorySize') is not None:
            self.memory_size = m.get('MemorySize')
        if m.get('Scopes') is not None:
            self.scopes = m.get('Scopes')
        if m.get('StockState') is not None:
            self.stock_state = m.get('StockState')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        return self


class DescribeDesktopTypesResponseBody(TeaModel):
    def __init__(
        self,
        desktop_types: List[DescribeDesktopTypesResponseBodyDesktopTypes] = None,
        request_id: str = None,
    ):
        # Details of cloud desktop types.
        self.desktop_types = desktop_types
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.desktop_types:
            for k in self.desktop_types:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DesktopTypes'] = []
        if self.desktop_types is not None:
            for k in self.desktop_types:
                result['DesktopTypes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.desktop_types = []
        if m.get('DesktopTypes') is not None:
            for k in m.get('DesktopTypes'):
                temp_model = DescribeDesktopTypesResponseBodyDesktopTypes()
                self.desktop_types.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDesktopTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopTypesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key. If you specify the `Tag` parameter, you must also specify the `Key` parameter. The tag key can be up to 128 characters in length and cannot contain `http://` or `https://`. The tag key cannot start with `acs:` or `aliyun` and contain only spaces.
        self.key = key
        # The tag value. The tag value can be up to 128 characters in length and cannot contain `http://` or `https://`. The tag value cannot start with `acs:` or `aliyun`.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDesktopsRequest(TeaModel):
    def __init__(
        self,
        charge_type: str = None,
        desktop_group_id: str = None,
        desktop_id: List[str] = None,
        desktop_name: str = None,
        desktop_status: str = None,
        desktop_status_list: List[str] = None,
        desktop_type: str = None,
        directory_id: str = None,
        end_user_id: List[str] = None,
        excluded_end_user_id: List[str] = None,
        expired_time: str = None,
        fill_resource_group: bool = None,
        filter_desktop_group: bool = None,
        gpu_instance_group_id: str = None,
        group_id: str = None,
        image_id: List[str] = None,
        management_flag: str = None,
        max_results: int = None,
        multi_resource: bool = None,
        next_token: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        only_desktop_group: bool = None,
        os_types: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        policy_group_id: str = None,
        protocol_type: str = None,
        qos_rule_id: str = None,
        query_fota_update: bool = None,
        region_id: str = None,
        resource_group_id: str = None,
        snapshot_policy_id: str = None,
        sub_pay_type: str = None,
        tag: List[DescribeDesktopsRequestTag] = None,
        user_name: str = None,
    ):
        # The billing method of the cloud computer.
        # 
        # Valid values:
        # 
        # *   Postpaid (default): pay-as-you-go
        # *   PrePaid: subscription
        self.charge_type = charge_type
        # The ID of the cloud computer pool. If you specify `OnlyDesktopGroup`, ignore `DesktopGroupId`. If you leave `DesktopId` empty, all IDs of the cloud computers in the cloud computer pool are queried.````
        self.desktop_group_id = desktop_group_id
        # The cloud computer IDs. You can specify the IDs of 1 to 100 cloud computers.
        self.desktop_id = desktop_id
        # The cloud computer name.
        self.desktop_name = desktop_name
        # The cloud computer status.
        # 
        # Valid values:
        # 
        # *   Stopped
        # *   Starting
        # *   Rebuilding
        # *   Running
        # *   Stopping
        # *   Expired
        # *   Deleted
        # *   Pending
        self.desktop_status = desktop_status
        # The list of cloud computer status.
        self.desktop_status_list = desktop_status_list
        # The cloud computer type. You can call the [DescribeDesktopTypes](https://help.aliyun.com/document_detail/188882.html) operation to query the IDs of all supported types.
        self.desktop_type = desktop_type
        # The directory ID, which is the same as the office network ID.
        self.directory_id = directory_id
        # The authorized users of the cloud computer. You can specify the IDs of 1 to 100 users.
        # 
        # >  During a specific period of time, only one user can connect to and use the cloud computer.
        self.end_user_id = end_user_id
        # The list of authorized users that you want to exclude from the cloud computer. You can specify the IDs of 1 to 100 users.
        self.excluded_end_user_id = excluded_end_user_id
        # The time when a subscription cloud computer expires.
        self.expired_time = expired_time
        # Specifies whether to query the information about the enterprise resource group.
        self.fill_resource_group = fill_resource_group
        # Specifies whether to exclude pooled cloud computers.
        # 
        # Valid values:
        # 
        # *   true (default)
        # *   false
        self.filter_desktop_group = filter_desktop_group
        # The ID of the elastic GPU pool.
        self.gpu_instance_group_id = gpu_instance_group_id
        # The ID of the cloud computer pool.
        self.group_id = group_id
        # The IDs of the images.
        self.image_id = image_id
        # The flag that is used to manage the cloud desktops.
        self.management_flag = management_flag
        # The number of entries per page.
        # 
        # *   Maximum value: 100
        # *   Default value: 10
        self.max_results = max_results
        # Specifies whether the shared group is a multi-cloud computer type.
        # 
        # Valid values:
        # 
        # - true: a multi-cloud computer type.
        # - false: a single-cloud computer type.
        self.multi_resource = multi_resource
        # The token that determines the start point of the next query. If this parameter is left empty, all results are returned.
        self.next_token = next_token
        # The office network ID.
        self.office_site_id = office_site_id
        # The office network name.
        self.office_site_name = office_site_name
        # Specifies whether to query pooled cloud computers.
        self.only_desktop_group = only_desktop_group
        # The operating systems (OSs).
        self.os_types = os_types
        # The page number.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the cloud computer policy.
        self.policy_group_id = policy_group_id
        # The protocol.
        # 
        # Valid values:
        # 
        # *   HDX: High-definition Experience (HDX) protocol
        # *   ASP: in-house Adaptive Streaming Protocol (ASP) (recommended)
        self.protocol_type = protocol_type
        # The ID of the network throttling rule.
        self.qos_rule_id = qos_rule_id
        # Specifies whether to query the image update information about the cloud computer.
        # 
        # Valid values:
        # 
        # *   true
        # *   false (default)
        self.query_fota_update = query_fota_update
        # The region ID. You can call the [DescribeRegions](~~DescribeRegions~~) operation to query the regions supported by Elastic Desktop Service (EDS).
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the enterprise resource group.
        self.resource_group_id = resource_group_id
        # The ID of the snapshot policy.
        self.snapshot_policy_id = snapshot_policy_id
        # The billing method of the cloud computer.
        # 
        # Valid values:
        # 
        # *   duration: hourly plan (available for users in the whitelist)
        # *   postPaid: pay-as-you-go
        # *   monthPackage: monthly subscription (120-hour or 250-hour computing plan)
        # *   prePaid: monthly subscription (unlimited-hour computing plan)
        self.sub_pay_type = sub_pay_type
        # The tags that you want to add to the cloud computer. A tag is a key-value pair that consists of a tag key and a tag value. Tags are used to identify resources. You can use tags to manage cloud computers by group. This facilitates search and batch operations. For more information, see [Use tags to manage cloud computers](https://help.aliyun.com/document_detail/203781.html).
        self.tag = tag
        # The name of the end user.
        self.user_name = user_name

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_status is not None:
            result['DesktopStatus'] = self.desktop_status
        if self.desktop_status_list is not None:
            result['DesktopStatusList'] = self.desktop_status_list
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.excluded_end_user_id is not None:
            result['ExcludedEndUserId'] = self.excluded_end_user_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.fill_resource_group is not None:
            result['FillResourceGroup'] = self.fill_resource_group
        if self.filter_desktop_group is not None:
            result['FilterDesktopGroup'] = self.filter_desktop_group
        if self.gpu_instance_group_id is not None:
            result['GpuInstanceGroupId'] = self.gpu_instance_group_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.management_flag is not None:
            result['ManagementFlag'] = self.management_flag
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.multi_resource is not None:
            result['MultiResource'] = self.multi_resource
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.only_desktop_group is not None:
            result['OnlyDesktopGroup'] = self.only_desktop_group
        if self.os_types is not None:
            result['OsTypes'] = self.os_types
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.qos_rule_id is not None:
            result['QosRuleId'] = self.qos_rule_id
        if self.query_fota_update is not None:
            result['QueryFotaUpdate'] = self.query_fota_update
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.snapshot_policy_id is not None:
            result['SnapshotPolicyId'] = self.snapshot_policy_id
        if self.sub_pay_type is not None:
            result['SubPayType'] = self.sub_pay_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopStatus') is not None:
            self.desktop_status = m.get('DesktopStatus')
        if m.get('DesktopStatusList') is not None:
            self.desktop_status_list = m.get('DesktopStatusList')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('ExcludedEndUserId') is not None:
            self.excluded_end_user_id = m.get('ExcludedEndUserId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('FillResourceGroup') is not None:
            self.fill_resource_group = m.get('FillResourceGroup')
        if m.get('FilterDesktopGroup') is not None:
            self.filter_desktop_group = m.get('FilterDesktopGroup')
        if m.get('GpuInstanceGroupId') is not None:
            self.gpu_instance_group_id = m.get('GpuInstanceGroupId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ManagementFlag') is not None:
            self.management_flag = m.get('ManagementFlag')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('MultiResource') is not None:
            self.multi_resource = m.get('MultiResource')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OnlyDesktopGroup') is not None:
            self.only_desktop_group = m.get('OnlyDesktopGroup')
        if m.get('OsTypes') is not None:
            self.os_types = m.get('OsTypes')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('QosRuleId') is not None:
            self.qos_rule_id = m.get('QosRuleId')
        if m.get('QueryFotaUpdate') is not None:
            self.query_fota_update = m.get('QueryFotaUpdate')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SnapshotPolicyId') is not None:
            self.snapshot_policy_id = m.get('SnapshotPolicyId')
        if m.get('SubPayType') is not None:
            self.sub_pay_type = m.get('SubPayType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDesktopsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeDesktopsResponseBodyDesktopsDisks(TeaModel):
    def __init__(
        self,
        disk_category: str = None,
        disk_id: str = None,
        disk_size: int = None,
        disk_type: str = None,
        performance_level: str = None,
    ):
        # The type of the disk. Valid values:
        # 
        # *   cloud_efficiency: ultra disk.
        # *   cloud_auto: standard SSD.
        # *   cloud_essd: enhanced SSD (ESSD).
        self.disk_category = disk_category
        # The disk ID.
        self.disk_id = disk_id
        # The disk size. Unit: GiB.
        self.disk_size = disk_size
        # The type of the disk.
        # 
        # Valid values:
        # 
        # *   SYSTEM: system disk
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DATA: data disk
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.disk_type = disk_type
        # The performance level (PL) of the disk when an enterprise SSD (ESSD) is used.
        # 
        # For more information about the differences among enterprise SSDs (ESSDs) at different PLs, see [ESSDs](https://help.aliyun.com/document_detail/122389.html).
        # 
        # Valid values:
        # 
        # *   PL1
        # *   PL0
        # *   PL3
        # *   PL2
        self.performance_level = performance_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('DiskSize') is not None:
            self.disk_size = m.get('DiskSize')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        return self


class DescribeDesktopsResponseBodyDesktopsFotaUpdate(TeaModel):
    def __init__(
        self,
        current_app_version: str = None,
        new_app_version: str = None,
        release_note: str = None,
        release_note_en: str = None,
        release_note_jp: str = None,
        size: int = None,
    ):
        # The current image version of the cloud computer.
        self.current_app_version = current_app_version
        # The version number to which the image of the cloud computer can be updated.
        self.new_app_version = new_app_version
        # The description of the version to which the image of the cloud computer can be updated.
        self.release_note = release_note
        # The English description of the version to which the image of the cloud computer can be updated.
        self.release_note_en = release_note_en
        # The Japanese description of the image version to which the cloud desktop can be updated.
        self.release_note_jp = release_note_jp
        # The size of the installation package for the image to which the cloud desktop can be updated. Unit: KB.
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_app_version is not None:
            result['CurrentAppVersion'] = self.current_app_version
        if self.new_app_version is not None:
            result['NewAppVersion'] = self.new_app_version
        if self.release_note is not None:
            result['ReleaseNote'] = self.release_note
        if self.release_note_en is not None:
            result['ReleaseNoteEn'] = self.release_note_en
        if self.release_note_jp is not None:
            result['ReleaseNoteJp'] = self.release_note_jp
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentAppVersion') is not None:
            self.current_app_version = m.get('CurrentAppVersion')
        if m.get('NewAppVersion') is not None:
            self.new_app_version = m.get('NewAppVersion')
        if m.get('ReleaseNote') is not None:
            self.release_note = m.get('ReleaseNote')
        if m.get('ReleaseNoteEn') is not None:
            self.release_note_en = m.get('ReleaseNoteEn')
        if m.get('ReleaseNoteJp') is not None:
            self.release_note_jp = m.get('ReleaseNoteJp')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeDesktopsResponseBodyDesktopsResourceGroups(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
    ):
        # The ID of the enterprise resource group.
        self.id = id
        # The name of the enterprise resource group.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeDesktopsResponseBodyDesktopsSessions(TeaModel):
    def __init__(
        self,
        end_user_id: str = None,
        establishment_time: str = None,
        external_user_name: str = None,
    ):
        # The ID of the end user that connects to the cloud computer.
        self.end_user_id = end_user_id
        # The time when the cloud computer session was established.
        self.establishment_time = establishment_time
        # The name of the external user.
        self.external_user_name = external_user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.establishment_time is not None:
            result['EstablishmentTime'] = self.establishment_time
        if self.external_user_name is not None:
            result['ExternalUserName'] = self.external_user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EstablishmentTime') is not None:
            self.establishment_time = m.get('EstablishmentTime')
        if m.get('ExternalUserName') is not None:
            self.external_user_name = m.get('ExternalUserName')
        return self


class DescribeDesktopsResponseBodyDesktopsTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key.
        self.key = key
        # The tag value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDesktopsResponseBodyDesktops(TeaModel):
    def __init__(
        self,
        bind_amount: int = None,
        bundle_id: str = None,
        bundle_name: str = None,
        charge_type: str = None,
        connection_status: str = None,
        cpu: int = None,
        creation_time: str = None,
        data_disk_category: str = None,
        data_disk_size: str = None,
        desktop_group_id: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        desktop_status: str = None,
        desktop_type: str = None,
        directory_id: str = None,
        directory_type: str = None,
        disks: List[DescribeDesktopsResponseBodyDesktopsDisks] = None,
        downgrade_quota: int = None,
        downgraded_times: int = None,
        end_user_ids: List[str] = None,
        expired_time: str = None,
        fota_update: DescribeDesktopsResponseBodyDesktopsFotaUpdate = None,
        gpu_category: int = None,
        gpu_count: float = None,
        gpu_driver_version: str = None,
        gpu_spec: str = None,
        hibernation_beta: bool = None,
        hibernation_options_configured: bool = None,
        host_name: str = None,
        image_id: str = None,
        management_flag: str = None,
        management_flags: List[str] = None,
        memory: int = None,
        network_interface_id: str = None,
        network_interface_ip: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        office_site_type: str = None,
        office_site_vpc_type: str = None,
        os_type: str = None,
        platform: str = None,
        policy_group_id: str = None,
        policy_group_id_list: List[str] = None,
        policy_group_name: str = None,
        policy_group_name_list: List[str] = None,
        progress: str = None,
        protocol_type: str = None,
        resource_groups: List[DescribeDesktopsResponseBodyDesktopsResourceGroups] = None,
        session_type: str = None,
        sessions: List[DescribeDesktopsResponseBodyDesktopsSessions] = None,
        snapshot_policy_id: str = None,
        snapshot_policy_name: str = None,
        standard_start_time: str = None,
        start_time: str = None,
        support_hibernation: bool = None,
        system_disk_category: str = None,
        system_disk_size: int = None,
        tags: List[DescribeDesktopsResponseBodyDesktopsTags] = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
        zone_type: str = None,
    ):
        # The number of concurrent sessions of each cloud computer in a multi-session cloud computer pool.
        self.bind_amount = bind_amount
        # The ID of the template used to create the cloud computer.
        self.bundle_id = bundle_id
        # The name of the template used to create the cloud computer.
        self.bundle_name = bundle_name
        # The billing method of the cloud computer.
        # 
        # Valid values:
        # 
        # *   Postpaid (default): pay-as-you-go
        # *   PrePaid: subscription
        self.charge_type = charge_type
        # The connection status of the end user.
        # 
        # Valid values:
        # 
        # *   Unknown
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Connected
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Disconnected
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.connection_status = connection_status
        # The number of vCPUs.
        self.cpu = cpu
        # The time when the cloud computer was created.
        self.creation_time = creation_time
        # >  This parameter is in invitational preview and is not publicly available.
        self.data_disk_category = data_disk_category
        # >  This parameter is in invitational preview and is not publicly available.
        self.data_disk_size = data_disk_size
        # The ID of the cloud computer pool to which cloud computers belong. Default value: null.``
        self.desktop_group_id = desktop_group_id
        # The cloud computer ID.
        self.desktop_id = desktop_id
        # The cloud computer name.
        self.desktop_name = desktop_name
        # The cloud computer status.
        self.desktop_status = desktop_status
        # The cloud computer type.
        self.desktop_type = desktop_type
        # The directory ID, which is the same as the office network ID (OfficeSiteId).
        self.directory_id = directory_id
        # >  This parameter is in invitational preview and is not publicly available.
        self.directory_type = directory_type
        # The information about the disks.
        self.disks = disks
        # The number of times for which the cloud desktop can be downgraded.
        self.downgrade_quota = downgrade_quota
        # The number of times for which the cloud desktop has been downgraded.
        self.downgraded_times = downgraded_times
        # The end user IDs.
        self.end_user_ids = end_user_ids
        # The time when a subscription cloud computer expired.
        self.expired_time = expired_time
        # The information about the image version of the cloud computer.
        self.fota_update = fota_update
        # Indicates whether the cloud computer uses GPUs.
        self.gpu_category = gpu_category
        # The number of GPU cores.
        self.gpu_count = gpu_count
        # The GPU driver version used by the cloud computer.
        self.gpu_driver_version = gpu_driver_version
        # The GPU Specifications.
        self.gpu_spec = gpu_spec
        # >  This parameter is in invitational preview and is not publicly available.
        self.hibernation_beta = hibernation_beta
        # >  This parameter is in invitational preview and is not publicly available.
        self.hibernation_options_configured = hibernation_options_configured
        # The hostname of the cloud desktop.
        self.host_name = host_name
        # The image ID.
        self.image_id = image_id
        # The flag that is used to manage the cloud computer.
        # 
        # Valid values:
        # 
        # *   Migrating: The cloud computer is being migrated.
        # *   Updating: The configurations of the cloud computer are being updated.
        # *   NoFlag: No flags are available.
        self.management_flag = management_flag
        # The flags that are used to manage the cloud computers.
        self.management_flags = management_flags
        # The memory size. Unit: MiB.
        self.memory = memory
        # The ID of the supplementary network interface controller (NIC) created by EDS within an RAM user or Active Directory (AD) user. You cannot modify the ID.
        self.network_interface_id = network_interface_id
        # The IP address of the supplementary NIC created by EDS within an RAM or AD user.
        self.network_interface_ip = network_interface_ip
        # The office network ID.
        self.office_site_id = office_site_id
        # The office network name.
        self.office_site_name = office_site_name
        # The account type of the office network.
        # 
        # Valid values:
        # 
        # *   SIMPLE: convenience account
        # *   AD_CONNECTOR: enterprise AD account
        self.office_site_type = office_site_type
        # The VPC type of the office network.
        # 
        # Valid values:
        # 
        # *   standard
        # *   customized
        # *   basic
        self.office_site_vpc_type = office_site_vpc_type
        # The OS that is defined in the desktop template.
        self.os_type = os_type
        # The information about the OS platform.
        # 
        # Valid values:
        # 
        # *   Ubuntu
        # *   Windows Server 2022
        # *   UOS
        # *   CentOS
        # *   Windows Server 2019
        # *   Windows Server 2016
        self.platform = platform
        # The policy ID.
        self.policy_group_id = policy_group_id
        # The IDs of the cloud computer policies.
        self.policy_group_id_list = policy_group_id_list
        # The policy name.
        self.policy_group_name = policy_group_name
        # The names of the cloud computer policies.
        self.policy_group_name_list = policy_group_name_list
        # The progress of creating the cloud computer.
        self.progress = progress
        # The protocol.
        # 
        # Valid values:
        # 
        # *   HDX
        # *   ASP
        self.protocol_type = protocol_type
        # The information about the enterprise resource groups.
        self.resource_groups = resource_groups
        # The type of the session.
        # 
        # Valid values:
        # 
        # *   SINGLE_SESSION
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   MULTIPLE_SESSION
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.session_type = session_type
        # The session information about cloud computers connected by end users.
        self.sessions = sessions
        # The snapshot policy ID.
        self.snapshot_policy_id = snapshot_policy_id
        # The name of the snapshot policy.
        self.snapshot_policy_name = snapshot_policy_name
        # The standard start time.
        self.standard_start_time = standard_start_time
        # The time when the cloud computer was first started.
        self.start_time = start_time
        # Indicates whether the cloud desktop supports hibernation.
        self.support_hibernation = support_hibernation
        # >  This parameter is in invitational preview and is not publicly available.
        self.system_disk_category = system_disk_category
        # >  This parameter is in invitational preview and is not publicly available.
        self.system_disk_size = system_disk_size
        # Details about the tags.
        self.tags = tags
        # Indicates whether disk encryption is enabled.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that is used when disk encryption is enabled. You can call the [ListKeys](https://help.aliyun.com/document_detail/28951.html) operation to query the list of KMS keys.
        self.volume_encryption_key = volume_encryption_key
        # The zone type. Default value: `AvailabilityZone`. This value indicates Alibaba Cloud zones.
        self.zone_type = zone_type

    def validate(self):
        if self.disks:
            for k in self.disks:
                if k:
                    k.validate()
        if self.fota_update:
            self.fota_update.validate()
        if self.resource_groups:
            for k in self.resource_groups:
                if k:
                    k.validate()
        if self.sessions:
            for k in self.sessions:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_amount is not None:
            result['BindAmount'] = self.bind_amount
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.bundle_name is not None:
            result['BundleName'] = self.bundle_name
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.connection_status is not None:
            result['ConnectionStatus'] = self.connection_status
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_status is not None:
            result['DesktopStatus'] = self.desktop_status
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.directory_type is not None:
            result['DirectoryType'] = self.directory_type
        result['Disks'] = []
        if self.disks is not None:
            for k in self.disks:
                result['Disks'].append(k.to_map() if k else None)
        if self.downgrade_quota is not None:
            result['DowngradeQuota'] = self.downgrade_quota
        if self.downgraded_times is not None:
            result['DowngradedTimes'] = self.downgraded_times
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.fota_update is not None:
            result['FotaUpdate'] = self.fota_update.to_map()
        if self.gpu_category is not None:
            result['GpuCategory'] = self.gpu_category
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.gpu_spec is not None:
            result['GpuSpec'] = self.gpu_spec
        if self.hibernation_beta is not None:
            result['HibernationBeta'] = self.hibernation_beta
        if self.hibernation_options_configured is not None:
            result['HibernationOptionsConfigured'] = self.hibernation_options_configured
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.management_flag is not None:
            result['ManagementFlag'] = self.management_flag
        if self.management_flags is not None:
            result['ManagementFlags'] = self.management_flags
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.network_interface_ip is not None:
            result['NetworkInterfaceIp'] = self.network_interface_ip
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.office_site_type is not None:
            result['OfficeSiteType'] = self.office_site_type
        if self.office_site_vpc_type is not None:
            result['OfficeSiteVpcType'] = self.office_site_vpc_type
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.policy_group_id_list is not None:
            result['PolicyGroupIdList'] = self.policy_group_id_list
        if self.policy_group_name is not None:
            result['PolicyGroupName'] = self.policy_group_name
        if self.policy_group_name_list is not None:
            result['PolicyGroupNameList'] = self.policy_group_name_list
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        result['ResourceGroups'] = []
        if self.resource_groups is not None:
            for k in self.resource_groups:
                result['ResourceGroups'].append(k.to_map() if k else None)
        if self.session_type is not None:
            result['SessionType'] = self.session_type
        result['Sessions'] = []
        if self.sessions is not None:
            for k in self.sessions:
                result['Sessions'].append(k.to_map() if k else None)
        if self.snapshot_policy_id is not None:
            result['SnapshotPolicyId'] = self.snapshot_policy_id
        if self.snapshot_policy_name is not None:
            result['SnapshotPolicyName'] = self.snapshot_policy_name
        if self.standard_start_time is not None:
            result['StandardStartTime'] = self.standard_start_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.support_hibernation is not None:
            result['SupportHibernation'] = self.support_hibernation
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        if self.zone_type is not None:
            result['ZoneType'] = self.zone_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindAmount') is not None:
            self.bind_amount = m.get('BindAmount')
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('BundleName') is not None:
            self.bundle_name = m.get('BundleName')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ConnectionStatus') is not None:
            self.connection_status = m.get('ConnectionStatus')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopStatus') is not None:
            self.desktop_status = m.get('DesktopStatus')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DirectoryType') is not None:
            self.directory_type = m.get('DirectoryType')
        self.disks = []
        if m.get('Disks') is not None:
            for k in m.get('Disks'):
                temp_model = DescribeDesktopsResponseBodyDesktopsDisks()
                self.disks.append(temp_model.from_map(k))
        if m.get('DowngradeQuota') is not None:
            self.downgrade_quota = m.get('DowngradeQuota')
        if m.get('DowngradedTimes') is not None:
            self.downgraded_times = m.get('DowngradedTimes')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('FotaUpdate') is not None:
            temp_model = DescribeDesktopsResponseBodyDesktopsFotaUpdate()
            self.fota_update = temp_model.from_map(m['FotaUpdate'])
        if m.get('GpuCategory') is not None:
            self.gpu_category = m.get('GpuCategory')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('GpuSpec') is not None:
            self.gpu_spec = m.get('GpuSpec')
        if m.get('HibernationBeta') is not None:
            self.hibernation_beta = m.get('HibernationBeta')
        if m.get('HibernationOptionsConfigured') is not None:
            self.hibernation_options_configured = m.get('HibernationOptionsConfigured')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ManagementFlag') is not None:
            self.management_flag = m.get('ManagementFlag')
        if m.get('ManagementFlags') is not None:
            self.management_flags = m.get('ManagementFlags')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('NetworkInterfaceIp') is not None:
            self.network_interface_ip = m.get('NetworkInterfaceIp')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OfficeSiteType') is not None:
            self.office_site_type = m.get('OfficeSiteType')
        if m.get('OfficeSiteVpcType') is not None:
            self.office_site_vpc_type = m.get('OfficeSiteVpcType')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('PolicyGroupIdList') is not None:
            self.policy_group_id_list = m.get('PolicyGroupIdList')
        if m.get('PolicyGroupName') is not None:
            self.policy_group_name = m.get('PolicyGroupName')
        if m.get('PolicyGroupNameList') is not None:
            self.policy_group_name_list = m.get('PolicyGroupNameList')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        self.resource_groups = []
        if m.get('ResourceGroups') is not None:
            for k in m.get('ResourceGroups'):
                temp_model = DescribeDesktopsResponseBodyDesktopsResourceGroups()
                self.resource_groups.append(temp_model.from_map(k))
        if m.get('SessionType') is not None:
            self.session_type = m.get('SessionType')
        self.sessions = []
        if m.get('Sessions') is not None:
            for k in m.get('Sessions'):
                temp_model = DescribeDesktopsResponseBodyDesktopsSessions()
                self.sessions.append(temp_model.from_map(k))
        if m.get('SnapshotPolicyId') is not None:
            self.snapshot_policy_id = m.get('SnapshotPolicyId')
        if m.get('SnapshotPolicyName') is not None:
            self.snapshot_policy_name = m.get('SnapshotPolicyName')
        if m.get('StandardStartTime') is not None:
            self.standard_start_time = m.get('StandardStartTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SupportHibernation') is not None:
            self.support_hibernation = m.get('SupportHibernation')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeDesktopsResponseBodyDesktopsTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        if m.get('ZoneType') is not None:
            self.zone_type = m.get('ZoneType')
        return self


class DescribeDesktopsResponseBody(TeaModel):
    def __init__(
        self,
        desktops: List[DescribeDesktopsResponseBodyDesktops] = None,
        next_token: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The information about the cloud computers.
        self.desktops = desktops
        # The token that is used for the next query. If this parameter is left empty, all results are returned.
        self.next_token = next_token
        # The page number.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of cloud computers.
        self.total_count = total_count

    def validate(self):
        if self.desktops:
            for k in self.desktops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Desktops'] = []
        if self.desktops is not None:
            for k in self.desktops:
                result['Desktops'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.desktops = []
        if m.get('Desktops') is not None:
            for k in m.get('Desktops'):
                temp_model = DescribeDesktopsResponseBodyDesktops()
                self.desktops.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDesktopsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopsInGroupRequest(TeaModel):
    def __init__(
        self,
        custom_end_time_period: int = None,
        custom_start_time_period: int = None,
        desktop_group_id: str = None,
        ignore_deleted: bool = None,
        max_results: int = None,
        next_token: str = None,
        pay_type: str = None,
        region_id: str = None,
    ):
        self.custom_end_time_period = custom_end_time_period
        self.custom_start_time_period = custom_start_time_period
        # The ID of the cloud computer pool.
        # 
        # This parameter is required.
        self.desktop_group_id = desktop_group_id
        # Specifies whether to ignore deletion flags.
        # 
        # Default value: true. Valid values:
        # 
        # *   true: ignores deletion flags. The cloud computers that were deleted are returned.
        # *   false: does not ignore deletion flags. The cloud computers that were deleted are not returned.
        self.ignore_deleted = ignore_deleted
        # The number of entries to return on each page. Valid values: 1 to 100. Default value: 10.
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. If the NextToken parameter is empty, no next page exists.
        self.next_token = next_token
        # The billing method of the desktop group.
        self.pay_type = pay_type
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_end_time_period is not None:
            result['CustomEndTimePeriod'] = self.custom_end_time_period
        if self.custom_start_time_period is not None:
            result['CustomStartTimePeriod'] = self.custom_start_time_period
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.ignore_deleted is not None:
            result['IgnoreDeleted'] = self.ignore_deleted
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomEndTimePeriod') is not None:
            self.custom_end_time_period = m.get('CustomEndTimePeriod')
        if m.get('CustomStartTimePeriod') is not None:
            self.custom_start_time_period = m.get('CustomStartTimePeriod')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('IgnoreDeleted') is not None:
            self.ignore_deleted = m.get('IgnoreDeleted')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDesktopsInGroupResponseBodyPaidDesktops(TeaModel):
    def __init__(
        self,
        connection_status: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        desktop_status: str = None,
        disk_type: str = None,
        end_user_id: str = None,
        end_user_ids: List[str] = None,
        end_user_name: str = None,
        end_user_names: List[str] = None,
        fota_version: str = None,
        gpu_driver_version: str = None,
        image_id: str = None,
        image_name: str = None,
        management_flag: str = None,
        management_flags: List[str] = None,
        member_eni_ip: str = None,
        os_type: str = None,
        primary_eni_ip: str = None,
        protocol_type: str = None,
        reset_time: str = None,
        system_disk_size: int = None,
    ):
        # The connection status of the cloud computer.
        # 
        # Valid values:
        # 
        # *   Unknown
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Connected
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Disconnected
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.connection_status = connection_status
        # The ID of the cloud computer.
        self.desktop_id = desktop_id
        # The name of the cloud computer.
        self.desktop_name = desktop_name
        # The status of the cloud computer.
        # 
        # Valid values:
        # 
        # *   Stopped
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Starting
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Rebuilding
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Running
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Stopping
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Expired
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Deleted
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Pending
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.desktop_status = desktop_status
        # The type of the disk.
        # 
        # Valid values:
        # 
        # *   SYSTEM: system disk
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DATA: data disk
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.disk_type = disk_type
        # The ID of the authorized user of the cloud computer.
        self.end_user_id = end_user_id
        # The IDs of the end users who are connected to the cloud computers in the cloud computer pool. If no end users are connected, no values are returned for this parameter.
        self.end_user_ids = end_user_ids
        # The username of the authorized user.
        self.end_user_name = end_user_name
        # The usernames of the end users who are connected to the cloud computers in the cloud computer pool. If no end users are connected, no values are returned for this parameter.
        self.end_user_names = end_user_names
        # The image version.
        self.fota_version = fota_version
        # The version of the GPU driver.
        self.gpu_driver_version = gpu_driver_version
        # The image ID.
        self.image_id = image_id
        # The image name.
        self.image_name = image_name
        # The flag that is used to manage the cloud computer.
        # 
        # Valid values:
        # 
        # *   Updating: The configurations of the cloud computer are being updated.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   NoFlag: No flags are attached to the cloud computer.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.management_flag = management_flag
        # The flags that are used to manage the cloud computers.
        self.management_flags = management_flags
        # The IP address of the member network interface controller (NIC) of the instance.
        self.member_eni_ip = member_eni_ip
        # The OS.
        # 
        # Valid values:
        # 
        # *   Linux
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.os_type = os_type
        # The IP address of the primary NIC of the instance.
        self.primary_eni_ip = primary_eni_ip
        # The protocol.
        # 
        # Valid values:
        # 
        # *   HDX: High-definition Experience (HDX) protocol
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ASP: Adaptive Streaming Protocol (ASP) protocol provided by Alibaba Cloud
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.protocol_type = protocol_type
        # The time when the cloud computer was reset.
        self.reset_time = reset_time
        # The system disk size. Unit: GiB.
        self.system_disk_size = system_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_status is not None:
            result['ConnectionStatus'] = self.connection_status
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_status is not None:
            result['DesktopStatus'] = self.desktop_status
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.end_user_name is not None:
            result['EndUserName'] = self.end_user_name
        if self.end_user_names is not None:
            result['EndUserNames'] = self.end_user_names
        if self.fota_version is not None:
            result['FotaVersion'] = self.fota_version
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.management_flag is not None:
            result['ManagementFlag'] = self.management_flag
        if self.management_flags is not None:
            result['ManagementFlags'] = self.management_flags
        if self.member_eni_ip is not None:
            result['MemberEniIp'] = self.member_eni_ip
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.primary_eni_ip is not None:
            result['PrimaryEniIp'] = self.primary_eni_ip
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.reset_time is not None:
            result['ResetTime'] = self.reset_time
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionStatus') is not None:
            self.connection_status = m.get('ConnectionStatus')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopStatus') is not None:
            self.desktop_status = m.get('DesktopStatus')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('EndUserName') is not None:
            self.end_user_name = m.get('EndUserName')
        if m.get('EndUserNames') is not None:
            self.end_user_names = m.get('EndUserNames')
        if m.get('FotaVersion') is not None:
            self.fota_version = m.get('FotaVersion')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ManagementFlag') is not None:
            self.management_flag = m.get('ManagementFlag')
        if m.get('ManagementFlags') is not None:
            self.management_flags = m.get('ManagementFlags')
        if m.get('MemberEniIp') is not None:
            self.member_eni_ip = m.get('MemberEniIp')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('PrimaryEniIp') is not None:
            self.primary_eni_ip = m.get('PrimaryEniIp')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('ResetTime') is not None:
            self.reset_time = m.get('ResetTime')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        return self


class DescribeDesktopsInGroupResponseBodyPostPaidDesktops(TeaModel):
    def __init__(
        self,
        connection_status: str = None,
        create_duration: str = None,
        create_time: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        desktop_status: str = None,
        disk_type: str = None,
        end_user_id: str = None,
        end_user_ids: List[str] = None,
        end_user_name: str = None,
        end_user_names: List[str] = None,
        fota_version: str = None,
        gpu_driver_version: str = None,
        image_id: str = None,
        image_name: str = None,
        management_flag: str = None,
        management_flags: List[str] = None,
        member_eni_ip: str = None,
        os_type: str = None,
        primary_eni_ip: str = None,
        protocol_type: str = None,
        release_time: str = None,
        reset_time: str = None,
        system_disk_size: int = None,
    ):
        # The connection status of the cloud computer.
        # 
        # Valid values:
        # 
        # *   Unknown
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Connected
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Disconnected
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.connection_status = connection_status
        # The retention period of the cloud computer.
        self.create_duration = create_duration
        # The time when the cloud computer was created.
        self.create_time = create_time
        # The ID of the cloud computer.
        self.desktop_id = desktop_id
        # The name of the cloud computer.
        self.desktop_name = desktop_name
        # The status of the cloud computer.
        # 
        # Valid values:
        # 
        # *   Stopped
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Starting
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Rebuilding
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Running
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Stopping
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Expired
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Deleted
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Pending
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.desktop_status = desktop_status
        # The type of the disk.
        # 
        # Valid values:
        # 
        # *   SYSTEM: system disk
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DATA: data disk
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.disk_type = disk_type
        # The ID of the authorized user.
        self.end_user_id = end_user_id
        # The IDs of the end users who are connected to the cloud computers in the cloud computer pool. If no end users are connected, no values are returned for this parameter.
        self.end_user_ids = end_user_ids
        # The username of the authorized user.
        self.end_user_name = end_user_name
        # The usernames of the end users who are connected to the cloud computers in the cloud computer pool. If no end users are connected, no values are returned for this parameter.
        self.end_user_names = end_user_names
        # The image version.
        self.fota_version = fota_version
        # The version of the GPU driver.
        self.gpu_driver_version = gpu_driver_version
        # The image ID.
        self.image_id = image_id
        # The image name.
        self.image_name = image_name
        # The flag that is used to manage the cloud computer.
        # 
        # Valid values:
        # 
        # *   Updating: The configurations of the cloud computer are being updated.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   NoFlag: No flags are attached to the cloud computer.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.management_flag = management_flag
        # The flags that are used to manage the cloud computers.
        self.management_flags = management_flags
        # The IP address of the member NIC of the instance.
        self.member_eni_ip = member_eni_ip
        # The OS.
        # 
        # Valid values:
        # 
        # *   Linux
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.os_type = os_type
        # The IP address of the primary NIC of the instance.
        self.primary_eni_ip = primary_eni_ip
        # The protocol.
        # 
        # Valid values:
        # 
        # *   HDX: HDX protocol
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ASP: ASP protocol provided by Alibaba Cloud
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.protocol_type = protocol_type
        # The time when the cloud computer was released.
        self.release_time = release_time
        # The time when the cloud computer was reset.
        self.reset_time = reset_time
        # The system disk size. Unit: GiB.
        self.system_disk_size = system_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_status is not None:
            result['ConnectionStatus'] = self.connection_status
        if self.create_duration is not None:
            result['CreateDuration'] = self.create_duration
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_status is not None:
            result['DesktopStatus'] = self.desktop_status
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.end_user_name is not None:
            result['EndUserName'] = self.end_user_name
        if self.end_user_names is not None:
            result['EndUserNames'] = self.end_user_names
        if self.fota_version is not None:
            result['FotaVersion'] = self.fota_version
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.management_flag is not None:
            result['ManagementFlag'] = self.management_flag
        if self.management_flags is not None:
            result['ManagementFlags'] = self.management_flags
        if self.member_eni_ip is not None:
            result['MemberEniIp'] = self.member_eni_ip
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.primary_eni_ip is not None:
            result['PrimaryEniIp'] = self.primary_eni_ip
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.reset_time is not None:
            result['ResetTime'] = self.reset_time
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionStatus') is not None:
            self.connection_status = m.get('ConnectionStatus')
        if m.get('CreateDuration') is not None:
            self.create_duration = m.get('CreateDuration')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopStatus') is not None:
            self.desktop_status = m.get('DesktopStatus')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('EndUserName') is not None:
            self.end_user_name = m.get('EndUserName')
        if m.get('EndUserNames') is not None:
            self.end_user_names = m.get('EndUserNames')
        if m.get('FotaVersion') is not None:
            self.fota_version = m.get('FotaVersion')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ManagementFlag') is not None:
            self.management_flag = m.get('ManagementFlag')
        if m.get('ManagementFlags') is not None:
            self.management_flags = m.get('ManagementFlags')
        if m.get('MemberEniIp') is not None:
            self.member_eni_ip = m.get('MemberEniIp')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('PrimaryEniIp') is not None:
            self.primary_eni_ip = m.get('PrimaryEniIp')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('ResetTime') is not None:
            self.reset_time = m.get('ResetTime')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        return self


class DescribeDesktopsInGroupResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        online_pre_paid_desktops_count: int = None,
        paid_desktops: List[DescribeDesktopsInGroupResponseBodyPaidDesktops] = None,
        paid_desktops_count: int = None,
        post_paid_desktops: List[DescribeDesktopsInGroupResponseBodyPostPaidDesktops] = None,
        post_paid_desktops_count: int = None,
        post_paid_desktops_total_amount: int = None,
        request_id: str = None,
        running_pre_paid_desktops_count: int = None,
        stoped_pre_paid_desktops_count: int = None,
        stopped_pre_paid_desktops_count: int = None,
    ):
        # The returned value of NextToken is a pagination token, which can be used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The number of subscription cloud computers that are in the Connected state.
        self.online_pre_paid_desktops_count = online_pre_paid_desktops_count
        # The details about subscription cloud computers.
        self.paid_desktops = paid_desktops
        # The total number of queried subscription cloud computers.
        self.paid_desktops_count = paid_desktops_count
        # The details about pay-as-you-go cloud computers.
        self.post_paid_desktops = post_paid_desktops
        # The total number of queried pay-as-you-go cloud computers.
        self.post_paid_desktops_count = post_paid_desktops_count
        # The total amount of bills for pay-as-you-go cloud computers.
        self.post_paid_desktops_total_amount = post_paid_desktops_total_amount
        # The request ID.
        self.request_id = request_id
        # The number of subscription cloud computers that are in the Running state.
        self.running_pre_paid_desktops_count = running_pre_paid_desktops_count
        # The number of subscription cloud computers that are in the Stopped state.
        self.stoped_pre_paid_desktops_count = stoped_pre_paid_desktops_count
        # The number of subscription cloud computers that are in the Stopped state.
        self.stopped_pre_paid_desktops_count = stopped_pre_paid_desktops_count

    def validate(self):
        if self.paid_desktops:
            for k in self.paid_desktops:
                if k:
                    k.validate()
        if self.post_paid_desktops:
            for k in self.post_paid_desktops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.online_pre_paid_desktops_count is not None:
            result['OnlinePrePaidDesktopsCount'] = self.online_pre_paid_desktops_count
        result['PaidDesktops'] = []
        if self.paid_desktops is not None:
            for k in self.paid_desktops:
                result['PaidDesktops'].append(k.to_map() if k else None)
        if self.paid_desktops_count is not None:
            result['PaidDesktopsCount'] = self.paid_desktops_count
        result['PostPaidDesktops'] = []
        if self.post_paid_desktops is not None:
            for k in self.post_paid_desktops:
                result['PostPaidDesktops'].append(k.to_map() if k else None)
        if self.post_paid_desktops_count is not None:
            result['PostPaidDesktopsCount'] = self.post_paid_desktops_count
        if self.post_paid_desktops_total_amount is not None:
            result['PostPaidDesktopsTotalAmount'] = self.post_paid_desktops_total_amount
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.running_pre_paid_desktops_count is not None:
            result['RunningPrePaidDesktopsCount'] = self.running_pre_paid_desktops_count
        if self.stoped_pre_paid_desktops_count is not None:
            result['StopedPrePaidDesktopsCount'] = self.stoped_pre_paid_desktops_count
        if self.stopped_pre_paid_desktops_count is not None:
            result['StoppedPrePaidDesktopsCount'] = self.stopped_pre_paid_desktops_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OnlinePrePaidDesktopsCount') is not None:
            self.online_pre_paid_desktops_count = m.get('OnlinePrePaidDesktopsCount')
        self.paid_desktops = []
        if m.get('PaidDesktops') is not None:
            for k in m.get('PaidDesktops'):
                temp_model = DescribeDesktopsInGroupResponseBodyPaidDesktops()
                self.paid_desktops.append(temp_model.from_map(k))
        if m.get('PaidDesktopsCount') is not None:
            self.paid_desktops_count = m.get('PaidDesktopsCount')
        self.post_paid_desktops = []
        if m.get('PostPaidDesktops') is not None:
            for k in m.get('PostPaidDesktops'):
                temp_model = DescribeDesktopsInGroupResponseBodyPostPaidDesktops()
                self.post_paid_desktops.append(temp_model.from_map(k))
        if m.get('PostPaidDesktopsCount') is not None:
            self.post_paid_desktops_count = m.get('PostPaidDesktopsCount')
        if m.get('PostPaidDesktopsTotalAmount') is not None:
            self.post_paid_desktops_total_amount = m.get('PostPaidDesktopsTotalAmount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RunningPrePaidDesktopsCount') is not None:
            self.running_pre_paid_desktops_count = m.get('RunningPrePaidDesktopsCount')
        if m.get('StopedPrePaidDesktopsCount') is not None:
            self.stoped_pre_paid_desktops_count = m.get('StopedPrePaidDesktopsCount')
        if m.get('StoppedPrePaidDesktopsCount') is not None:
            self.stopped_pre_paid_desktops_count = m.get('StoppedPrePaidDesktopsCount')
        return self


class DescribeDesktopsInGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopsInGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopsInGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDevicesRequest(TeaModel):
    def __init__(
        self,
        ad_domain: str = None,
        client_type: str = None,
        device_id: str = None,
        directory_id: str = None,
        end_user_id: str = None,
        page_number: int = None,
        page_size: int = None,
        region: str = None,
        user_type: str = None,
    ):
        # The address of the Active Directory (AD) office network.
        self.ad_domain = ad_domain
        # The type of the client.
        # 
        # Valid values:
        # 
        # *   1: hardware client.
        # *   2: software client.
        # 
        # This parameter is required.
        self.client_type = client_type
        # The ID of the device. The serial number (SN) of the hardware client or the UUID of the software client.
        self.device_id = device_id
        # The ID of the convenient office network.
        self.directory_id = directory_id
        # The ID of the bound user.
        self.end_user_id = end_user_id
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The ID of the region. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the regions supported by WUYING Workspace.
        self.region = region
        # The account type of the user.
        # 
        # Valid values:
        # 
        # *   AD: enterprise AD account.
        # *   SIMPLE: convenience account
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_domain is not None:
            result['AdDomain'] = self.ad_domain
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region is not None:
            result['Region'] = self.region
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdDomain') is not None:
            self.ad_domain = m.get('AdDomain')
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class DescribeDevicesResponseBodyDevicesEndUserList(TeaModel):
    def __init__(
        self,
        ad_domain: str = None,
        directory_id: str = None,
        end_user_id: str = None,
        user_type: str = None,
    ):
        # The address of the AD office network.
        self.ad_domain = ad_domain
        # The ID of the convenient office network.
        self.directory_id = directory_id
        # The ID of the user.
        self.end_user_id = end_user_id
        # The account type of the user.
        # 
        # Valid values:
        # 
        # *   AD: enterprise AD account.
        # *   SIMPLE: convenience account
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_domain is not None:
            result['AdDomain'] = self.ad_domain
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdDomain') is not None:
            self.ad_domain = m.get('AdDomain')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class DescribeDevicesResponseBodyDevices(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        end_user_list: List[DescribeDevicesResponseBodyDevicesEndUserList] = None,
    ):
        # The ID of the device. The serial number (SN) of the hardware client or the UUID of the software client.
        self.device_id = device_id
        # The users who are bound to the device.
        self.end_user_list = end_user_list

    def validate(self):
        if self.end_user_list:
            for k in self.end_user_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        result['EndUserList'] = []
        if self.end_user_list is not None:
            for k in self.end_user_list:
                result['EndUserList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        self.end_user_list = []
        if m.get('EndUserList') is not None:
            for k in m.get('EndUserList'):
                temp_model = DescribeDevicesResponseBodyDevicesEndUserList()
                self.end_user_list.append(temp_model.from_map(k))
        return self


class DescribeDevicesResponseBody(TeaModel):
    def __init__(
        self,
        devices: List[DescribeDevicesResponseBodyDevices] = None,
        request_id: str = None,
    ):
        # The information about devices that you queried.
        self.devices = devices
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = DescribeDevicesResponseBodyDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDevicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDirectoriesRequest(TeaModel):
    def __init__(
        self,
        directory_id: List[str] = None,
        directory_status: str = None,
        directory_type: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
        status: str = None,
    ):
        # Details of directory IDs. You can specify one or more directory IDs.
        self.directory_id = directory_id
        # The directory status. This parameter is equivalent to `Status`.
        self.directory_status = directory_status
        # The directory type.
        # 
        # Valid values:
        # 
        # *   SIMPLE: a directory of the convenience account type
        # *   AD_CONNECTOR: an AD directory
        # *   RAM: a RAM directory
        self.directory_type = directory_type
        # The number of entries to return on each page.
        # 
        # Maximum value: 100.
        # 
        # Default value: 10.
        self.max_results = max_results
        # The token that determines the start point of the next query. If this parameter is empty, all results are returned.
        self.next_token = next_token
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The directory status.
        # 
        # Valid values:
        # 
        # *   REGISTERING: The directory is being registered.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DEREGISTERING: The directory is being deregistered.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   REGISTERED: The directory is registered.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   NEEDCONFIGTRUST: A trust relationship needs to be configured for the directory.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   CONFIGTRUSTFAILED: A trust relationship fails to be configured for the directory.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DEREGISTERED: The directory is deregistered.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ERROR: One or more configurations of the directory are invalid.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   CONFIGTRUSTING: A trust relationship is being configured.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   NEEDCONFIGUSER: Users need to be configured for the directory.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.directory_status is not None:
            result['DirectoryStatus'] = self.directory_status
        if self.directory_type is not None:
            result['DirectoryType'] = self.directory_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DirectoryStatus') is not None:
            self.directory_status = m.get('DirectoryStatus')
        if m.get('DirectoryType') is not None:
            self.directory_type = m.get('DirectoryType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDirectoriesResponseBodyDirectoriesADConnectors(TeaModel):
    def __init__(
        self,
        adconnector_address: str = None,
        connector_status: str = None,
        network_interface_id: str = None,
        specification: str = None,
        trust_key: str = None,
        v_switch_id: str = None,
    ):
        # The connection address.
        self.adconnector_address = adconnector_address
        # Valid values:
        # 
        # *   CONNECT_ERROR
        # *   RUNNING
        # *   CONNECTING: You must configure domain trust for your AD system.
        # *   EXPIRED
        # *   CREATING
        self.connector_status = connector_status
        # The ID of the NIC to which the AD connector is mounted.
        self.network_interface_id = network_interface_id
        # The AD connector type.
        # 
        # Valid values:
        # 
        # *   1: General
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   2: Advanced
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.specification = specification
        # The trust password of the AD domain controller.
        self.trust_key = trust_key
        # The ID of the vSwitch with which the AD connector is associated.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adconnector_address is not None:
            result['ADConnectorAddress'] = self.adconnector_address
        if self.connector_status is not None:
            result['ConnectorStatus'] = self.connector_status
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.trust_key is not None:
            result['TrustKey'] = self.trust_key
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ADConnectorAddress') is not None:
            self.adconnector_address = m.get('ADConnectorAddress')
        if m.get('ConnectorStatus') is not None:
            self.connector_status = m.get('ConnectorStatus')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('TrustKey') is not None:
            self.trust_key = m.get('TrustKey')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DescribeDirectoriesResponseBodyDirectoriesLogs(TeaModel):
    def __init__(
        self,
        level: str = None,
        message: str = None,
        step: str = None,
        time_stamp: str = None,
    ):
        # The level of the log entry.
        # 
        # Valid values:
        # 
        # *   ERROR
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   INFO
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   WARN
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.level = level
        # Details of the log entry.
        self.message = message
        # The step that corresponds to the log entry.
        self.step = step
        # The time when the log entry was printed.
        self.time_stamp = time_stamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.step is not None:
            result['Step'] = self.step
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDirectoriesResponseBodyDirectories(TeaModel):
    def __init__(
        self,
        adconnectors: List[DescribeDirectoriesResponseBodyDirectoriesADConnectors] = None,
        ad_hostname: str = None,
        backup_dchostname: str = None,
        backup_dns: str = None,
        creation_time: str = None,
        custom_security_group_id: str = None,
        desktop_access_type: str = None,
        desktop_vpc_endpoint: str = None,
        directory_id: str = None,
        directory_type: str = None,
        dns_address: List[str] = None,
        dns_user_name: str = None,
        domain_name: str = None,
        domain_password: str = None,
        domain_user_name: str = None,
        enable_admin_access: bool = None,
        enable_cross_desktop_access: bool = None,
        enable_internet_access: bool = None,
        file_system_ids: List[str] = None,
        logs: List[DescribeDirectoriesResponseBodyDirectoriesLogs] = None,
        mfa_enabled: bool = None,
        name: str = None,
        need_verify_login_risk: bool = None,
        ou_name: str = None,
        sso_enabled: bool = None,
        status: str = None,
        sub_dns_address: List[str] = None,
        sub_domain_name: str = None,
        trust_password: str = None,
        v_switch_ids: List[str] = None,
        vpc_id: str = None,
    ):
        # Details of the AD connector.
        self.adconnectors = adconnectors
        # The hostname of the domain controller.
        self.ad_hostname = ad_hostname
        # The hostname of the backup domain controller.
        self.backup_dchostname = backup_dchostname
        # The DNS address of the backup domain controller.
        self.backup_dns = backup_dns
        # The time when the directory was created.
        self.creation_time = creation_time
        # The security group ID. This parameter is returned only when the directory type is AD office network.
        self.custom_security_group_id = custom_security_group_id
        # The method in which the cloud computer is connected.
        # 
        # Valid values:
        # 
        # *   VPC
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Internet
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Any
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.desktop_access_type = desktop_access_type
        # The endpoint that is used to connect to cloud computers in the directory over a VPC.
        self.desktop_vpc_endpoint = desktop_vpc_endpoint
        # The directory ID.
        self.directory_id = directory_id
        # The directory type.
        # 
        # Valid values:
        # 
        # *   AD_CONNECTOR: AD directory
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   RAM: RAM directory
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.directory_type = directory_type
        # The DNS address of the directory.
        self.dns_address = dns_address
        # The username of a DNS user.
        self.dns_user_name = dns_user_name
        # The domain name.
        self.domain_name = domain_name
        # The password of the domain administrator. This parameter is returned only when the directory type is AD office network.
        self.domain_password = domain_password
        # The username of the domain administrator.
        self.domain_user_name = domain_user_name
        # Indicates whether the local administrator permissions are granted to users that use cloud computers in the office network.
        self.enable_admin_access = enable_admin_access
        # Indicates whether cloud computers can communicate with each other in the directory.
        self.enable_cross_desktop_access = enable_cross_desktop_access
        # Indicates whether access over the Internet is enabled.
        # 
        # >  This parameter is unavailable.
        self.enable_internet_access = enable_internet_access
        # The IDs of File Storage NAS (NAS) file systems.
        self.file_system_ids = file_system_ids
        # The registration logs. This parameter is returned only when the directory type is AD office network.
        self.logs = logs
        # Indicates whether MFA is enabled.
        self.mfa_enabled = mfa_enabled
        # The directory name.
        self.name = name
        # Indicates whether two-step verification for logons is enabled. This parameter is returned only for directories of convenience account type.\\
        # If two-factor verification is enabled, the system checks whether security risks exist within the logon account when a convenience user logs on to an Alibaba Cloud Workspace client. If risks are detected, the system sends a verification code to the email address that is associated with the account. Then, the convenience user can log on to the client only after the user enters the correct verification code.
        self.need_verify_login_risk = need_verify_login_risk
        # The organization unit that you selected when you added the cloud computer to the domain.
        self.ou_name = ou_name
        # Indicates whether single sign-on (SSO) is enabled.
        self.sso_enabled = sso_enabled
        # The status of the AD directory.
        # 
        # Valid values:
        # 
        # *   REGISTERING
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   REGISTERED
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.status = status
        # The DNS address of the enterprise AD subdomain.
        self.sub_dns_address = sub_dns_address
        # The fully qualified domain name (FQDN) of the existing AD subdomain. The value contains both the host name and the domain name.
        self.sub_domain_name = sub_domain_name
        # The AD trust password. This parameter is returned only when the directory type is AD office network.
        self.trust_password = trust_password
        # The IDs of the vSwitches specified when the directory was created.
        self.v_switch_ids = v_switch_ids
        # The ID of the VPC to which the vSwitch belongs. This parameter is returned only when the directory type is AD office network.
        self.vpc_id = vpc_id

    def validate(self):
        if self.adconnectors:
            for k in self.adconnectors:
                if k:
                    k.validate()
        if self.logs:
            for k in self.logs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ADConnectors'] = []
        if self.adconnectors is not None:
            for k in self.adconnectors:
                result['ADConnectors'].append(k.to_map() if k else None)
        if self.ad_hostname is not None:
            result['AdHostname'] = self.ad_hostname
        if self.backup_dchostname is not None:
            result['BackupDCHostname'] = self.backup_dchostname
        if self.backup_dns is not None:
            result['BackupDns'] = self.backup_dns
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.custom_security_group_id is not None:
            result['CustomSecurityGroupId'] = self.custom_security_group_id
        if self.desktop_access_type is not None:
            result['DesktopAccessType'] = self.desktop_access_type
        if self.desktop_vpc_endpoint is not None:
            result['DesktopVpcEndpoint'] = self.desktop_vpc_endpoint
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.directory_type is not None:
            result['DirectoryType'] = self.directory_type
        if self.dns_address is not None:
            result['DnsAddress'] = self.dns_address
        if self.dns_user_name is not None:
            result['DnsUserName'] = self.dns_user_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_password is not None:
            result['DomainPassword'] = self.domain_password
        if self.domain_user_name is not None:
            result['DomainUserName'] = self.domain_user_name
        if self.enable_admin_access is not None:
            result['EnableAdminAccess'] = self.enable_admin_access
        if self.enable_cross_desktop_access is not None:
            result['EnableCrossDesktopAccess'] = self.enable_cross_desktop_access
        if self.enable_internet_access is not None:
            result['EnableInternetAccess'] = self.enable_internet_access
        if self.file_system_ids is not None:
            result['FileSystemIds'] = self.file_system_ids
        result['Logs'] = []
        if self.logs is not None:
            for k in self.logs:
                result['Logs'].append(k.to_map() if k else None)
        if self.mfa_enabled is not None:
            result['MfaEnabled'] = self.mfa_enabled
        if self.name is not None:
            result['Name'] = self.name
        if self.need_verify_login_risk is not None:
            result['NeedVerifyLoginRisk'] = self.need_verify_login_risk
        if self.ou_name is not None:
            result['OuName'] = self.ou_name
        if self.sso_enabled is not None:
            result['SsoEnabled'] = self.sso_enabled
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_dns_address is not None:
            result['SubDnsAddress'] = self.sub_dns_address
        if self.sub_domain_name is not None:
            result['SubDomainName'] = self.sub_domain_name
        if self.trust_password is not None:
            result['TrustPassword'] = self.trust_password
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.adconnectors = []
        if m.get('ADConnectors') is not None:
            for k in m.get('ADConnectors'):
                temp_model = DescribeDirectoriesResponseBodyDirectoriesADConnectors()
                self.adconnectors.append(temp_model.from_map(k))
        if m.get('AdHostname') is not None:
            self.ad_hostname = m.get('AdHostname')
        if m.get('BackupDCHostname') is not None:
            self.backup_dchostname = m.get('BackupDCHostname')
        if m.get('BackupDns') is not None:
            self.backup_dns = m.get('BackupDns')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('CustomSecurityGroupId') is not None:
            self.custom_security_group_id = m.get('CustomSecurityGroupId')
        if m.get('DesktopAccessType') is not None:
            self.desktop_access_type = m.get('DesktopAccessType')
        if m.get('DesktopVpcEndpoint') is not None:
            self.desktop_vpc_endpoint = m.get('DesktopVpcEndpoint')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DirectoryType') is not None:
            self.directory_type = m.get('DirectoryType')
        if m.get('DnsAddress') is not None:
            self.dns_address = m.get('DnsAddress')
        if m.get('DnsUserName') is not None:
            self.dns_user_name = m.get('DnsUserName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainPassword') is not None:
            self.domain_password = m.get('DomainPassword')
        if m.get('DomainUserName') is not None:
            self.domain_user_name = m.get('DomainUserName')
        if m.get('EnableAdminAccess') is not None:
            self.enable_admin_access = m.get('EnableAdminAccess')
        if m.get('EnableCrossDesktopAccess') is not None:
            self.enable_cross_desktop_access = m.get('EnableCrossDesktopAccess')
        if m.get('EnableInternetAccess') is not None:
            self.enable_internet_access = m.get('EnableInternetAccess')
        if m.get('FileSystemIds') is not None:
            self.file_system_ids = m.get('FileSystemIds')
        self.logs = []
        if m.get('Logs') is not None:
            for k in m.get('Logs'):
                temp_model = DescribeDirectoriesResponseBodyDirectoriesLogs()
                self.logs.append(temp_model.from_map(k))
        if m.get('MfaEnabled') is not None:
            self.mfa_enabled = m.get('MfaEnabled')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NeedVerifyLoginRisk') is not None:
            self.need_verify_login_risk = m.get('NeedVerifyLoginRisk')
        if m.get('OuName') is not None:
            self.ou_name = m.get('OuName')
        if m.get('SsoEnabled') is not None:
            self.sso_enabled = m.get('SsoEnabled')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubDnsAddress') is not None:
            self.sub_dns_address = m.get('SubDnsAddress')
        if m.get('SubDomainName') is not None:
            self.sub_domain_name = m.get('SubDomainName')
        if m.get('TrustPassword') is not None:
            self.trust_password = m.get('TrustPassword')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeDirectoriesResponseBody(TeaModel):
    def __init__(
        self,
        ad_hostname: str = None,
        directories: List[DescribeDirectoriesResponseBodyDirectories] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The hostname of the domain controller. The hostname must comply with the hostname naming convention of Windows. This parameter is returned only when the directory type is AD office network.
        self.ad_hostname = ad_hostname
        # The directories.
        self.directories = directories
        # The token that is used for the next query. If this parameter is empty, all results are returned.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.directories:
            for k in self.directories:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_hostname is not None:
            result['AdHostname'] = self.ad_hostname
        result['Directories'] = []
        if self.directories is not None:
            for k in self.directories:
                result['Directories'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdHostname') is not None:
            self.ad_hostname = m.get('AdHostname')
        self.directories = []
        if m.get('Directories') is not None:
            for k in m.get('Directories'):
                temp_model = DescribeDirectoriesResponseBodyDirectories()
                self.directories.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDirectoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDirectoriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDirectoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowMetricRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        instance_id: str = None,
        instance_type: str = None,
        metric_type: str = None,
        period: int = None,
        region_id: str = None,
        start_time: str = None,
    ):
        # This parameter is required.
        self.end_time = end_time
        # This parameter is required.
        self.instance_id = instance_id
        # This parameter is required.
        self.instance_type = instance_type
        # This parameter is required.
        self.metric_type = metric_type
        # This parameter is required.
        self.period = period
        # This parameter is required.
        self.region_id = region_id
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeFlowMetricResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFlowMetricResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFlowMetricResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFlowMetricResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowStatisticRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        office_site_id: str = None,
        page_number: int = None,
        page_size: int = None,
        period: int = None,
        region_id: str = None,
    ):
        # The ID of the cloud computer.
        self.desktop_id = desktop_id
        # The office network ID.
        # 
        # This parameter is required.
        self.office_site_id = office_site_id
        # The number of the page to return.\\
        # Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The statistic collection interval. Unit: seconds.
        # 
        # Valid values:
        # 
        # *   3600: 1 hour
        # *   10800: 3 hours
        # *   86400: 24 hours
        # 
        # This parameter is required.
        self.period = period
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowStatisticResponseBodyDesktopFlowStatistic(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        desktop_name: str = None,
        flow_in: str = None,
        flow_rank: int = None,
    ):
        # The ID of the cloud computer.
        self.desktop_id = desktop_id
        # The name of the cloud computer.
        self.desktop_name = desktop_name
        # The traffic amount. Unit: KB.
        self.flow_in = flow_in
        # The traffic ranking.
        self.flow_rank = flow_rank

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.flow_in is not None:
            result['FlowIn'] = self.flow_in
        if self.flow_rank is not None:
            result['FlowRank'] = self.flow_rank
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('FlowIn') is not None:
            self.flow_in = m.get('FlowIn')
        if m.get('FlowRank') is not None:
            self.flow_rank = m.get('FlowRank')
        return self


class DescribeFlowStatisticResponseBody(TeaModel):
    def __init__(
        self,
        desktop_count: int = None,
        desktop_flow_statistic: List[DescribeFlowStatisticResponseBodyDesktopFlowStatistic] = None,
        request_id: str = None,
    ):
        # The number of available cloud computers in the office network.
        self.desktop_count = desktop_count
        # The traffic statistics.
        self.desktop_flow_statistic = desktop_flow_statistic
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.desktop_flow_statistic:
            for k in self.desktop_flow_statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_count is not None:
            result['DesktopCount'] = self.desktop_count
        result['DesktopFlowStatistic'] = []
        if self.desktop_flow_statistic is not None:
            for k in self.desktop_flow_statistic:
                result['DesktopFlowStatistic'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopCount') is not None:
            self.desktop_count = m.get('DesktopCount')
        self.desktop_flow_statistic = []
        if m.get('DesktopFlowStatistic') is not None:
            for k in m.get('DesktopFlowStatistic'):
                temp_model = DescribeFlowStatisticResponseBodyDesktopFlowStatistic()
                self.desktop_flow_statistic.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFlowStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFlowStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFlowStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFotaPendingDesktopsRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        desktop_name: str = None,
        max_results: int = None,
        next_token: str = None,
        office_site_id: str = None,
        region_id: str = None,
        task_uid: str = None,
    ):
        # The ID of the cloud computer.
        self.desktop_id = desktop_id
        # The name of the cloud computer.
        self.desktop_name = desktop_name
        # The number of entries per page.
        # 
        # *   Valid values: 1 to 100.
        # *   Default value: 20.
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. You do not need to specify this parameter for the first request. You must specify the token that is obtained from the previous query as the value of `NextToken`.
        self.next_token = next_token
        # The ID of the office network. You can call the [DescribeOfficeSites](https://help.aliyun.com/document_detail/216071.html) operation to obtain the value of this parameter.
        self.office_site_id = office_site_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the regions supported by Elastic Desktop Service.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the image update task. You can call the [DescribeFotaTasks](https://help.aliyun.com/document_detail/437001.html) operation to obtain the value of this parameter.
        self.task_uid = task_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_uid is not None:
            result['TaskUid'] = self.task_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskUid') is not None:
            self.task_uid = m.get('TaskUid')
        return self


class DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktopsSessions(TeaModel):
    def __init__(
        self,
        end_user_id: str = None,
    ):
        # The ID of the end user that connects to the cloud computer.
        self.end_user_id = end_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        return self


class DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktops(TeaModel):
    def __init__(
        self,
        current_app_version: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        fota_project: str = None,
        office_site_id: str = None,
        sessions: List[DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktopsSessions] = None,
        status: int = None,
    ):
        # The current version of the image used by the cloud computer.
        self.current_app_version = current_app_version
        # The ID of the cloud computer.
        self.desktop_id = desktop_id
        # The name of the cloud computer.
        self.desktop_name = desktop_name
        # > This parameter is not publicly available.
        self.fota_project = fota_project
        # The ID of the office network.
        self.office_site_id = office_site_id
        # The connected sessions.
        self.sessions = sessions
        # The status of the cloud computer.
        # 
        # Valid values:
        # 
        # *   0: The cloud computer is being created.
        # *   1: The cloud computer is being started.
        # *   2: The cloud computer is running.
        # *   3: The cloud computer is being stopped.
        # *   5: The cloud computer is stopped.
        # *   6: The cloud computer expires.
        # *   7: The cloud computer is deleted.
        # *   9: Failed to create the cloud computer.
        self.status = status

    def validate(self):
        if self.sessions:
            for k in self.sessions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_app_version is not None:
            result['CurrentAppVersion'] = self.current_app_version
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.fota_project is not None:
            result['FotaProject'] = self.fota_project
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        result['Sessions'] = []
        if self.sessions is not None:
            for k in self.sessions:
                result['Sessions'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentAppVersion') is not None:
            self.current_app_version = m.get('CurrentAppVersion')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('FotaProject') is not None:
            self.fota_project = m.get('FotaProject')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        self.sessions = []
        if m.get('Sessions') is not None:
            for k in m.get('Sessions'):
                temp_model = DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktopsSessions()
                self.sessions.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeFotaPendingDesktopsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        fota_pending_desktops: List[DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktops] = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The response code.
        self.code = code
        # The cloud computers whose images can be and are pending to be updated to the version specified in `TaskUid`.
        self.fota_pending_desktops = fota_pending_desktops
        # The returned message.
        self.message = message
        # A pagination token. It can be used in the next request to retrieve a new page of results. If NextToken is empty, no next page exists.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.fota_pending_desktops:
            for k in self.fota_pending_desktops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['FotaPendingDesktops'] = []
        if self.fota_pending_desktops is not None:
            for k in self.fota_pending_desktops:
                result['FotaPendingDesktops'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.fota_pending_desktops = []
        if m.get('FotaPendingDesktops') is not None:
            for k in m.get('FotaPendingDesktops'):
                temp_model = DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktops()
                self.fota_pending_desktops.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFotaPendingDesktopsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFotaPendingDesktopsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFotaPendingDesktopsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFotaTasksRequest(TeaModel):
    def __init__(
        self,
        fota_status: str = None,
        lang: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
        task_uid: List[str] = None,
        user_status: str = None,
    ):
        # >  This parameter is not publicly available.
        self.fota_status = fota_status
        # The language of the image version to update.
        # 
        # Valid values:
        # 
        # *   en: English.
        # *   zh: Simplified Chinese.
        self.lang = lang
        # The number of entries per page.
        # 
        # *   Valid values: 1 to 100
        # *   Default value: 20
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. If the NextToken parameter is empty, no next page exists.
        self.next_token = next_token
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the regions supported by Elastic Desktop Service.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The IDs of the image update tasks.
        self.task_uid = task_uid
        # Specifies whether to automatically push the image update task.
        # 
        # Valid values:
        # 
        # *   Running: automatically pushes the image update task.
        # *   Pending: does not automatically push the image update task.
        self.user_status = user_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fota_status is not None:
            result['FotaStatus'] = self.fota_status
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_uid is not None:
            result['TaskUid'] = self.task_uid
        if self.user_status is not None:
            result['UserStatus'] = self.user_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FotaStatus') is not None:
            self.fota_status = m.get('FotaStatus')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskUid') is not None:
            self.task_uid = m.get('TaskUid')
        if m.get('UserStatus') is not None:
            self.user_status = m.get('UserStatus')
        return self


class DescribeFotaTasksResponseBodyFotaTasks(TeaModel):
    def __init__(
        self,
        app_version: str = None,
        fota_project: str = None,
        pending_custom_image_count: int = None,
        pending_desktop_count: int = None,
        publish_time: str = None,
        release_note: str = None,
        size: int = None,
        status: str = None,
        task_uid: str = None,
    ):
        # The image version. You can call the [DescribeImages](https://help.aliyun.com/document_detail/188895.html) operation to obtain the value of this parameter.
        self.app_version = app_version
        # >  This parameter is not publicly available.
        self.fota_project = fota_project
        # The number of custom images that can be updated to this version.
        self.pending_custom_image_count = pending_custom_image_count
        # The number of cloud computers whose images can be updated to this version.
        self.pending_desktop_count = pending_desktop_count
        # The time when the image version available for update was published.
        self.publish_time = publish_time
        # The description of the image version available for update.
        self.release_note = release_note
        # The size of the update package. Unit: KB.
        self.size = size
        # Indicates whether the image update task is automatically pushed.
        # 
        # Valid values:
        # 
        # *   Running: automatically pushes the image update task.
        # *   Pending: does not automatically push the image update task.
        self.status = status
        # The ID of the image upgrade task.
        self.task_uid = task_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.fota_project is not None:
            result['FotaProject'] = self.fota_project
        if self.pending_custom_image_count is not None:
            result['PendingCustomImageCount'] = self.pending_custom_image_count
        if self.pending_desktop_count is not None:
            result['PendingDesktopCount'] = self.pending_desktop_count
        if self.publish_time is not None:
            result['PublishTime'] = self.publish_time
        if self.release_note is not None:
            result['ReleaseNote'] = self.release_note
        if self.size is not None:
            result['Size'] = self.size
        if self.status is not None:
            result['Status'] = self.status
        if self.task_uid is not None:
            result['TaskUid'] = self.task_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('FotaProject') is not None:
            self.fota_project = m.get('FotaProject')
        if m.get('PendingCustomImageCount') is not None:
            self.pending_custom_image_count = m.get('PendingCustomImageCount')
        if m.get('PendingDesktopCount') is not None:
            self.pending_desktop_count = m.get('PendingDesktopCount')
        if m.get('PublishTime') is not None:
            self.publish_time = m.get('PublishTime')
        if m.get('ReleaseNote') is not None:
            self.release_note = m.get('ReleaseNote')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskUid') is not None:
            self.task_uid = m.get('TaskUid')
        return self


class DescribeFotaTasksResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        fota_tasks: List[DescribeFotaTasksResponseBodyFotaTasks] = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The returned message. If the request was successful, a `success` is returned. If the request failed, an error message is returned.
        self.code = code
        # Details about the image update task.
        self.fota_tasks = fota_tasks
        # The returned error message. This parameter is not returned if the Code value is a `success` message.
        self.message = message
        # A pagination token. It can be used in the next request to retrieve a new page of results. If NextToken is empty, no next page exists.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.fota_tasks:
            for k in self.fota_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['FotaTasks'] = []
        if self.fota_tasks is not None:
            for k in self.fota_tasks:
                result['FotaTasks'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.fota_tasks = []
        if m.get('FotaTasks') is not None:
            for k in m.get('FotaTasks'):
                temp_model = DescribeFotaTasksResponseBodyFotaTasks()
                self.fota_tasks.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFotaTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFotaTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFotaTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGuestApplicationsRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        end_user_id: str = None,
        region_id: str = None,
    ):
        # The ID of the cloud computer.
        # 
        # This parameter is required.
        self.desktop_id = desktop_id
        # The ID of the end user.
        # 
        # This parameter is required.
        self.end_user_id = end_user_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeGuestApplicationsResponseBodyApplicationsProcessData(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        application_version: str = None,
        cpu_percent: float = None,
        gpu_percent: float = None,
        iospeed: float = None,
        mem_percent: float = None,
        pid: int = None,
        process_path: str = None,
    ):
        # The application name.
        self.application_name = application_name
        # The application version.
        self.application_version = application_version
        # The CPU utilization (%).
        self.cpu_percent = cpu_percent
        # The GPU utilization (%).
        self.gpu_percent = gpu_percent
        # The I/O read and write performance.
        self.iospeed = iospeed
        # The memory utilization (%).
        self.mem_percent = mem_percent
        # The PID.
        self.pid = pid
        # The path to the process.
        self.process_path = process_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_version is not None:
            result['ApplicationVersion'] = self.application_version
        if self.cpu_percent is not None:
            result['CpuPercent'] = self.cpu_percent
        if self.gpu_percent is not None:
            result['GpuPercent'] = self.gpu_percent
        if self.iospeed is not None:
            result['Iospeed'] = self.iospeed
        if self.mem_percent is not None:
            result['MemPercent'] = self.mem_percent
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.process_path is not None:
            result['ProcessPath'] = self.process_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationVersion') is not None:
            self.application_version = m.get('ApplicationVersion')
        if m.get('CpuPercent') is not None:
            self.cpu_percent = m.get('CpuPercent')
        if m.get('GpuPercent') is not None:
            self.gpu_percent = m.get('GpuPercent')
        if m.get('Iospeed') is not None:
            self.iospeed = m.get('Iospeed')
        if m.get('MemPercent') is not None:
            self.mem_percent = m.get('MemPercent')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('ProcessPath') is not None:
            self.process_path = m.get('ProcessPath')
        return self


class DescribeGuestApplicationsResponseBodyApplications(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        application_version: str = None,
        cpu_percent: float = None,
        gpu_percent: float = None,
        icon_url: str = None,
        io_speed: float = None,
        mem_percent: float = None,
        pid: int = None,
        process_data: List[DescribeGuestApplicationsResponseBodyApplicationsProcessData] = None,
        process_path: str = None,
        status: str = None,
    ):
        # The application name.
        self.application_name = application_name
        # The application version.
        self.application_version = application_version
        # The CPU utilization (%).
        self.cpu_percent = cpu_percent
        # The GPU utilization (%).
        self.gpu_percent = gpu_percent
        # The icon URL of the application.
        self.icon_url = icon_url
        # The I/O read and write performance.
        self.io_speed = io_speed
        # The memory utilization (%).
        self.mem_percent = mem_percent
        # The process ID (PID).
        self.pid = pid
        # The process information.
        self.process_data = process_data
        # The path to the process.
        self.process_path = process_path
        # The application status.
        self.status = status

    def validate(self):
        if self.process_data:
            for k in self.process_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_version is not None:
            result['ApplicationVersion'] = self.application_version
        if self.cpu_percent is not None:
            result['CpuPercent'] = self.cpu_percent
        if self.gpu_percent is not None:
            result['GpuPercent'] = self.gpu_percent
        if self.icon_url is not None:
            result['IconUrl'] = self.icon_url
        if self.io_speed is not None:
            result['IoSpeed'] = self.io_speed
        if self.mem_percent is not None:
            result['MemPercent'] = self.mem_percent
        if self.pid is not None:
            result['Pid'] = self.pid
        result['ProcessData'] = []
        if self.process_data is not None:
            for k in self.process_data:
                result['ProcessData'].append(k.to_map() if k else None)
        if self.process_path is not None:
            result['ProcessPath'] = self.process_path
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationVersion') is not None:
            self.application_version = m.get('ApplicationVersion')
        if m.get('CpuPercent') is not None:
            self.cpu_percent = m.get('CpuPercent')
        if m.get('GpuPercent') is not None:
            self.gpu_percent = m.get('GpuPercent')
        if m.get('IconUrl') is not None:
            self.icon_url = m.get('IconUrl')
        if m.get('IoSpeed') is not None:
            self.io_speed = m.get('IoSpeed')
        if m.get('MemPercent') is not None:
            self.mem_percent = m.get('MemPercent')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        self.process_data = []
        if m.get('ProcessData') is not None:
            for k in m.get('ProcessData'):
                temp_model = DescribeGuestApplicationsResponseBodyApplicationsProcessData()
                self.process_data.append(temp_model.from_map(k))
        if m.get('ProcessPath') is not None:
            self.process_path = m.get('ProcessPath')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeGuestApplicationsResponseBody(TeaModel):
    def __init__(
        self,
        applications: List[DescribeGuestApplicationsResponseBodyApplications] = None,
        request_id: str = None,
    ):
        # The details of the applications.
        self.applications = applications
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = DescribeGuestApplicationsResponseBodyApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGuestApplicationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGuestApplicationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGuestApplicationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageModifiedRecordsRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
    ):
        # The ID of the cloud computer.
        # 
        # This parameter is required.
        self.desktop_id = desktop_id
        # The maximum number of entries to return on each page.
        # 
        # *   Maximum value: 100.
        # *   Default value: 10.
        self.max_results = max_results
        # The token that determines the start point of the next query. If this parameter is left empty, all results are returned.
        self.next_token = next_token
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeImageModifiedRecordsResponseBodyImageModifiedRecords(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        image_name: str = None,
        new_image_id: str = None,
        new_image_name: str = None,
        status: int = None,
        update_time: str = None,
    ):
        # The ID of the original image.
        self.image_id = image_id
        # The name of the original image.
        self.image_name = image_name
        # The ID of the new image after the image was modified.
        self.new_image_id = new_image_id
        # The name of the new image after the image was modified.
        self.new_image_name = new_image_name
        # The status of the image modification.
        # 
        # Valid values:
        # 
        # *   0: The image is being modified.
        # 
        # *   1: The image is successfully modified.
        # 
        # *   2: The image fails to be modified.
        self.status = status
        # The time when the image was last modified.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.new_image_id is not None:
            result['NewImageId'] = self.new_image_id
        if self.new_image_name is not None:
            result['NewImageName'] = self.new_image_name
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('NewImageId') is not None:
            self.new_image_id = m.get('NewImageId')
        if m.get('NewImageName') is not None:
            self.new_image_name = m.get('NewImageName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeImageModifiedRecordsResponseBody(TeaModel):
    def __init__(
        self,
        image_modified_records: List[DescribeImageModifiedRecordsResponseBodyImageModifiedRecords] = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # Details about the image modification record.
        self.image_modified_records = image_modified_records
        # If the NextToken parameter is empty, no next page exists.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id
        # The total number of image modification records.
        self.total_count = total_count

    def validate(self):
        if self.image_modified_records:
            for k in self.image_modified_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageModifiedRecords'] = []
        if self.image_modified_records is not None:
            for k in self.image_modified_records:
                result['ImageModifiedRecords'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image_modified_records = []
        if m.get('ImageModifiedRecords') is not None:
            for k in m.get('ImageModifiedRecords'):
                temp_model = DescribeImageModifiedRecordsResponseBodyImageModifiedRecords()
                self.image_modified_records.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageModifiedRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeImageModifiedRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImageModifiedRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImagePermissionRequest(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        region_id: str = None,
    ):
        # The image ID.
        # 
        # This parameter is required.
        self.image_id = image_id
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeImagePermissionResponseBody(TeaModel):
    def __init__(
        self,
        ali_uids: List[str] = None,
        request_id: str = None,
    ):
        # The IDs of the Alibaba Cloud accounts with which the image is shared.
        self.ali_uids = ali_uids
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uids is not None:
            result['AliUids'] = self.ali_uids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUids') is not None:
            self.ali_uids = m.get('AliUids')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImagePermissionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeImagePermissionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImagePermissionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImagesRequest(TeaModel):
    def __init__(
        self,
        desktop_instance_type: str = None,
        fota_version: str = None,
        gpu_category: bool = None,
        gpu_driver_version: str = None,
        image_id: List[str] = None,
        image_name: str = None,
        image_status: str = None,
        image_type: str = None,
        language_type: str = None,
        max_results: int = None,
        next_token: str = None,
        os_type: str = None,
        protocol_type: str = None,
        region_id: str = None,
        session_type: str = None,
    ):
        # The instance type of the cloud computer. You can call the [DescribeDesktopTypes](https://help.aliyun.com/document_detail/436816.html) operation to obtain the parameter value.
        self.desktop_instance_type = desktop_instance_type
        # The image version.
        self.fota_version = fota_version
        # Specifies whether the images are GPU-accelerated images.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.gpu_category = gpu_category
        # The version of the GPU driver.
        self.gpu_driver_version = gpu_driver_version
        # The IDs of the images. You can specify one or more image IDs.
        self.image_id = image_id
        # The image name.
        self.image_name = image_name
        # The state of the image.
        self.image_status = image_status
        # The type of the image.
        self.image_type = image_type
        # The language of the OS.
        self.language_type = language_type
        # The maximum number of entries to return on each page.
        # 
        # *   Maximum value: 100.
        # *   Default value: 10.
        self.max_results = max_results
        # The token that determines the start point of the next query. If you do not specify this parameter, all results are returned.
        self.next_token = next_token
        # The type of the operating system of the images. Default value: `null`.
        # 
        # Valid values:
        # 
        # *   Linux
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.os_type = os_type
        # The protocol type.
        # 
        # Valid values:
        # 
        # *   HDX: High-definition Experience (HDX) protocol
        # *   ASP: in-house Adaptive Streaming Protocol (ASP) (recommended)
        self.protocol_type = protocol_type
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The session type.
        self.session_type = session_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_instance_type is not None:
            result['DesktopInstanceType'] = self.desktop_instance_type
        if self.fota_version is not None:
            result['FotaVersion'] = self.fota_version
        if self.gpu_category is not None:
            result['GpuCategory'] = self.gpu_category
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_status is not None:
            result['ImageStatus'] = self.image_status
        if self.image_type is not None:
            result['ImageType'] = self.image_type
        if self.language_type is not None:
            result['LanguageType'] = self.language_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.session_type is not None:
            result['SessionType'] = self.session_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopInstanceType') is not None:
            self.desktop_instance_type = m.get('DesktopInstanceType')
        if m.get('FotaVersion') is not None:
            self.fota_version = m.get('FotaVersion')
        if m.get('GpuCategory') is not None:
            self.gpu_category = m.get('GpuCategory')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ImageStatus') is not None:
            self.image_status = m.get('ImageStatus')
        if m.get('ImageType') is not None:
            self.image_type = m.get('ImageType')
        if m.get('LanguageType') is not None:
            self.language_type = m.get('LanguageType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SessionType') is not None:
            self.session_type = m.get('SessionType')
        return self


class DescribeImagesResponseBodyImages(TeaModel):
    def __init__(
        self,
        app_version: str = None,
        creation_time: str = None,
        data_disk_size: int = None,
        description: str = None,
        gpu_category: bool = None,
        gpu_driver_version: str = None,
        image_id: str = None,
        image_type: str = None,
        name: str = None,
        os_type: str = None,
        platform: str = None,
        progress: str = None,
        protocol_type: str = None,
        session_type: str = None,
        shared_count: int = None,
        size: int = None,
        status: str = None,
        supported_languages: List[str] = None,
        update_time: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
    ):
        # The version of the image.
        self.app_version = app_version
        # The time when the image was created.
        self.creation_time = creation_time
        # The size of the data disk. Unit: GiB.
        self.data_disk_size = data_disk_size
        # The description of the image.
        self.description = description
        # Indicates whether the image is a GPU-accelerated image.
        self.gpu_category = gpu_category
        # The version number of the GPU driver.
        self.gpu_driver_version = gpu_driver_version
        # The ID of the image.
        self.image_id = image_id
        # The type of the image.
        # 
        # Valid values:
        # 
        # *   SYSTEM
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   CUSTOM
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.image_type = image_type
        # The name of the image.
        self.name = name
        # The type of the operating system.
        self.os_type = os_type
        # The operating system type of the image.
        # 
        # Valid values:
        # 
        # *   Ubuntu
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows Server 2022
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   UOS
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   CentOS
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows Server 2019
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   SQL Server 2016
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Windows 10
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.platform = platform
        # The creation progress of the image. Unit: %.
        self.progress = progress
        # The protocol type.
        # 
        # Valid values:
        # 
        # *   HDX: High-definition Experience (HDX) protocol
        # *   ASP: in-house Adaptive Streaming Protocol (ASP) (recommended)
        self.protocol_type = protocol_type
        # The type of the image session.
        # 
        # Valid values:
        # 
        # *   SINGLE_SESSION: single-session image.
        # 
        # *   MULTIPLE_SESSION: multi-session image.
        self.session_type = session_type
        # The number of shared images.
        self.shared_count = shared_count
        # The size of the image. Unit: GiB.
        self.size = size
        # The status of the image.
        # 
        # Valid values:
        # 
        # *   Creating
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Available
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   CreateFailed
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.status = status
        # The languages of the operating system.
        self.supported_languages = supported_languages
        # The time when the image was last modified.
        self.update_time = update_time
        # Indicates whether disk encryption is enabled.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that is used when disk encryption is enabled. You can call the [ListKeys](https://help.aliyun.com/document_detail/28951.html) operation to query the list of KMS keys.
        self.volume_encryption_key = volume_encryption_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.description is not None:
            result['Description'] = self.description
        if self.gpu_category is not None:
            result['GpuCategory'] = self.gpu_category
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_type is not None:
            result['ImageType'] = self.image_type
        if self.name is not None:
            result['Name'] = self.name
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.session_type is not None:
            result['SessionType'] = self.session_type
        if self.shared_count is not None:
            result['SharedCount'] = self.shared_count
        if self.size is not None:
            result['Size'] = self.size
        if self.status is not None:
            result['Status'] = self.status
        if self.supported_languages is not None:
            result['SupportedLanguages'] = self.supported_languages
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GpuCategory') is not None:
            self.gpu_category = m.get('GpuCategory')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageType') is not None:
            self.image_type = m.get('ImageType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('SessionType') is not None:
            self.session_type = m.get('SessionType')
        if m.get('SharedCount') is not None:
            self.shared_count = m.get('SharedCount')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SupportedLanguages') is not None:
            self.supported_languages = m.get('SupportedLanguages')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        return self


class DescribeImagesResponseBody(TeaModel):
    def __init__(
        self,
        images: List[DescribeImagesResponseBodyImages] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The details of the images.
        self.images = images
        # The token that determines the start point of the next query. If this parameter is empty, all results are returned.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.images:
            for k in self.images:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Images'] = []
        if self.images is not None:
            for k in self.images:
                result['Images'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.images = []
        if m.get('Images') is not None:
            for k in m.get('Images'):
                temp_model = DescribeImagesResponseBodyImages()
                self.images.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeImagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInvocationsRequest(TeaModel):
    def __init__(
        self,
        command_type: str = None,
        content_encoding: str = None,
        desktop_id: str = None,
        desktop_ids: List[str] = None,
        end_user_id: str = None,
        include_invoke_desktops: bool = None,
        include_output: bool = None,
        invoke_id: str = None,
        invoke_status: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
    ):
        # The type of the command. Valid values:
        # 
        # *   RunBatScript
        # *   RunPowerShellScript
        self.command_type = command_type
        # The encoding method of the command content and output. Valid values:
        # 
        # *   PlainText
        # *   Base64
        # 
        # Default value: Base64.
        self.content_encoding = content_encoding
        # The ID of the cloud desktop. If you specify a cloud desktop, all the execution records of Cloud Assistant commands on the cloud desktop are queried.
        self.desktop_id = desktop_id
        # The IDs of the cloud desktops.
        self.desktop_ids = desktop_ids
        # The ID of the end user.
        self.end_user_id = end_user_id
        # Specifies whether to return the execution results of all cloud computers if the command is executed on multiple cloud computers.
        # 
        # Valid values:
        # 
        # - true: returned.
        # - false: not returned.
        self.include_invoke_desktops = include_invoke_desktops
        # Specifies whether to return command outputs in the response. Valid values:
        # 
        # *   true: returns command outputs.
        # *   false: does not return command outputs.
        # 
        # Default value: false.
        self.include_output = include_output
        # The ID of the execution.
        self.invoke_id = invoke_id
        # The overall execution status of a command. The overall execution status is determined by the execution status of the command on one or more cloud desktops. Valid values:
        # 
        # *   Running: The execution is in progress on one or more cloud desktops.
        # *   Finished: The execution is finished on all cloud desktops, or the execution is manually stopped on some cloud desktops and the execution is finished on others.
        # *   Failed: The execution failed on all cloud desktops.
        # *   PartialFailed: The execution failed on some cloud desktops.
        # *   Stopped: The execution is stopped.
        # 
        # Default value: Running.
        self.invoke_status = invoke_status
        # The number of entries per page.
        # 
        # *   Valid values: 1 to 50.
        # *   Default value: 10.
        self.max_results = max_results
        # The query token. Set the value to the NextToken value that is returned from the last call to the previous DescribeInvocations operation.
        self.next_token = next_token
        # The ID of the region.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command_type is not None:
            result['CommandType'] = self.command_type
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_ids is not None:
            result['DesktopIds'] = self.desktop_ids
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.include_invoke_desktops is not None:
            result['IncludeInvokeDesktops'] = self.include_invoke_desktops
        if self.include_output is not None:
            result['IncludeOutput'] = self.include_output
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        if self.invoke_status is not None:
            result['InvokeStatus'] = self.invoke_status
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommandType') is not None:
            self.command_type = m.get('CommandType')
        if m.get('ContentEncoding') is not None:
            self.content_encoding = m.get('ContentEncoding')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopIds') is not None:
            self.desktop_ids = m.get('DesktopIds')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('IncludeInvokeDesktops') is not None:
            self.include_invoke_desktops = m.get('IncludeInvokeDesktops')
        if m.get('IncludeOutput') is not None:
            self.include_output = m.get('IncludeOutput')
        if m.get('InvokeId') is not None:
            self.invoke_id = m.get('InvokeId')
        if m.get('InvokeStatus') is not None:
            self.invoke_status = m.get('InvokeStatus')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeInvocationsResponseBodyInvocationsInvokeDesktops(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        dropped: int = None,
        error_code: str = None,
        error_info: str = None,
        exit_code: int = None,
        finish_time: str = None,
        invocation_status: str = None,
        output: str = None,
        repeats: int = None,
        start_time: str = None,
        stop_time: str = None,
        update_time: str = None,
    ):
        # The time when the command execution was performed.
        self.creation_time = creation_time
        # The ID of the cloud desktop.
        self.desktop_id = desktop_id
        # The name of the cloud desktop.
        self.desktop_name = desktop_name
        # The size of the text that is truncated and discarded when the Output value exceeds 24 KB in size.
        self.dropped = dropped
        # The code that indicates the reason why a command failed to be sent or executed. The valid values include:
        # 
        # *   If this parameter is empty, the execution is normal.
        # *   InstanceNotExists: The specified cloud desktop does not exist or is released.
        # *   InstanceReleased: The cloud desktop is released during the execution.
        # *   InstanceNotRunning: The cloud desktop is not running during the execution.
        # *   CommandNotApplicable: The command cannot be used on the cloud desktop.
        # *   ClientNotRunning: The Cloud Assistant client is not running.
        # *   ClientNotResponse: The Cloud Assistant client does not respond.
        # *   ClientIsUpgrading: The Cloud Assistant client is being upgraded.
        # *   ClientNeedUpgrade: The Cloud Assistant client needs to be upgraded.
        # *   DeliveryTimeout: The time to send the command in the request times out.
        # *   ExecutionTimeout: The execution times out.
        # *   ExecutionException: An exception occurs during the execution.
        # *   ExecutionInterrupted: The execution is interrupted.
        # *   ExitCodeNonzero: The execution finishes, but the exit code is not 0.
        self.error_code = error_code
        # Details about the reason why the command failed to be sent or executed. The valid values include:
        # 
        # *   If this parameter is empty, the execution is normal.
        # *   the specified instance does not exists: The cloud desktop does not exist or is released.
        # *   the instance has released when create task: The cloud desktop is released during execution.
        # *   the instance is not running when create task: The cloud desktop is not running when the execution is being performed.
        # *   the command is not applicable: The command cannot be used on the specified cloud desktop.
        # *   the aliyun service is not running on the instance: The Cloud Assistance client is not running.
        # *   the aliyun service in the instance does not response: The Cloud Assistant client is not responding.
        # *   the aliyun service in the instance is upgrading now: The Cloud Assistant client is being upgraded.
        # *   the aliyun service in the instance need upgrade: The Cloud Assistant client needs to be upgraded.
        # *   the command delivery has been timeout: The command that is sent in the request times out.
        # *   the command execution has been timeout: The execution times out.
        # *   the command execution got an exception: An exception occurs when the command is running.
        # *   the command execution has been interrupted: The execution is interrupted.
        # *   the command execution exit code is not zero: The execution finishes, but the exit code is not 0.
        self.error_info = error_info
        # The exit code of the execution.
        self.exit_code = exit_code
        # The time when the command execution ended.
        self.finish_time = finish_time
        # The execution status on the cloud desktop.
        self.invocation_status = invocation_status
        # The command output.
        # 
        # *   If the IncludeOutput parameter is set to false, Output is not returned.
        # *   If the ContentEncoding parameter is set to Base64, the value of Output is the output information that is encoded in Base64.
        self.output = output
        # The number of times that the command is executed on the cloud desktop.
        self.repeats = repeats
        # The start time of the execution on the cloud desktop.
        self.start_time = start_time
        # The time when you called the [StopInvocation](~~196957#doc-api-ecd-StopInvocation~~ "You can call this operation to stop a Cloud Assistant command that is running on one or cloud desktops.") operation to manually stop the command.
        self.stop_time = stop_time
        # The time when the execution status was updated.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.dropped is not None:
            result['Dropped'] = self.dropped
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_info is not None:
            result['ErrorInfo'] = self.error_info
        if self.exit_code is not None:
            result['ExitCode'] = self.exit_code
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.invocation_status is not None:
            result['InvocationStatus'] = self.invocation_status
        if self.output is not None:
            result['Output'] = self.output
        if self.repeats is not None:
            result['Repeats'] = self.repeats
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('Dropped') is not None:
            self.dropped = m.get('Dropped')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorInfo') is not None:
            self.error_info = m.get('ErrorInfo')
        if m.get('ExitCode') is not None:
            self.exit_code = m.get('ExitCode')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InvocationStatus') is not None:
            self.invocation_status = m.get('InvocationStatus')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('Repeats') is not None:
            self.repeats = m.get('Repeats')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeInvocationsResponseBodyInvocations(TeaModel):
    def __init__(
        self,
        command_content: str = None,
        command_type: str = None,
        creation_time: str = None,
        end_user_id: str = None,
        invocation_status: str = None,
        invoke_desktop_count: int = None,
        invoke_desktop_succeed_count: int = None,
        invoke_desktops: List[DescribeInvocationsResponseBodyInvocationsInvokeDesktops] = None,
        invoke_id: str = None,
    ):
        # The Base64-encoded command content.
        self.command_content = command_content
        # The type of the command.
        self.command_type = command_type
        # The time when the execution task is created.
        self.creation_time = creation_time
        # The ID of the end user.
        self.end_user_id = end_user_id
        # The overall execution status of the command. The overall execution status is determined by the execution status on all involved cloud desktops. The valid values include:
        # 
        # *   Pending: The system is verifying or sending the command. If the execution status on at least one cloud desktop is Pending, the overall execution status is Pending.
        # 
        # *   Running: The execution is in progress on cloud desktops. If the execution status on at least one cloud desktop is Running, the overall execution status is Running.
        # 
        # *   Success: If the execution status on all cloud desktops is Success or Stopped, or the execution status on at least one cloud desktop is Success, the overall execution status is Success.
        # 
        # *   Failed: If the execution status on all cloud desktops is Stopped or Failed, the overall execution status is Failed. If one or more execution status of a cloud desktop is one of the following values, Failed is returned:
        # 
        #     *   Invalid: The command is invalid.
        #     *   Aborted: The command fails to be sent.
        #     *   Failed: The command is executed, but the exit code is not 0.
        #     *   Timeout: The command times out.
        #     *   Error: An error occurs in the command.
        # 
        # *   Stopping: The execution is being stopped. If the execution status on at least one cloud desktop is Stopping, the overall execution state is Stopping.
        # 
        # *   Stopped: The execution is stopped. If the execution status on all cloud desktops is Stopped, the overall execution state is Stopped. If the execution status on a cloud desktop is one of the following values, Stopped is returned:
        # 
        #     *   Cancelled: The execution is canceled.
        #     *   Terminated: The execution is terminated.
        # 
        # *   PartialFailed: The execution succeeded on some cloud desktops and failed on others. If the execution status on different cloud desktops is Success, Failed, or Stopped, the overall execution state is PartialFailed.
        self.invocation_status = invocation_status
        # The total number of cloud computers on which the command is executed.
        self.invoke_desktop_count = invoke_desktop_count
        # The total number of cloud computers on which the command is executed successfully.
        self.invoke_desktop_succeed_count = invoke_desktop_succeed_count
        # The cloud desktops on which the command is executed.
        self.invoke_desktops = invoke_desktops
        # The ID of the execution.
        self.invoke_id = invoke_id

    def validate(self):
        if self.invoke_desktops:
            for k in self.invoke_desktops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.command_type is not None:
            result['CommandType'] = self.command_type
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.invocation_status is not None:
            result['InvocationStatus'] = self.invocation_status
        if self.invoke_desktop_count is not None:
            result['InvokeDesktopCount'] = self.invoke_desktop_count
        if self.invoke_desktop_succeed_count is not None:
            result['InvokeDesktopSucceedCount'] = self.invoke_desktop_succeed_count
        result['InvokeDesktops'] = []
        if self.invoke_desktops is not None:
            for k in self.invoke_desktops:
                result['InvokeDesktops'].append(k.to_map() if k else None)
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommandContent') is not None:
            self.command_content = m.get('CommandContent')
        if m.get('CommandType') is not None:
            self.command_type = m.get('CommandType')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('InvocationStatus') is not None:
            self.invocation_status = m.get('InvocationStatus')
        if m.get('InvokeDesktopCount') is not None:
            self.invoke_desktop_count = m.get('InvokeDesktopCount')
        if m.get('InvokeDesktopSucceedCount') is not None:
            self.invoke_desktop_succeed_count = m.get('InvokeDesktopSucceedCount')
        self.invoke_desktops = []
        if m.get('InvokeDesktops') is not None:
            for k in m.get('InvokeDesktops'):
                temp_model = DescribeInvocationsResponseBodyInvocationsInvokeDesktops()
                self.invoke_desktops.append(temp_model.from_map(k))
        if m.get('InvokeId') is not None:
            self.invoke_id = m.get('InvokeId')
        return self


class DescribeInvocationsResponseBody(TeaModel):
    def __init__(
        self,
        invocations: List[DescribeInvocationsResponseBodyInvocations] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # Details about execution records of the command.
        self.invocations = invocations
        # The query token that is returned from this call.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.invocations:
            for k in self.invocations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Invocations'] = []
        if self.invocations is not None:
            for k in self.invocations:
                result['Invocations'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.invocations = []
        if m.get('Invocations') is not None:
            for k in m.get('Invocations'):
                temp_model = DescribeInvocationsResponseBodyInvocations()
                self.invocations.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInvocationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInvocationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInvocationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeKmsKeysRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        # The ID of the region. You can call the [DescribeRegions](~~DescribeRegions~~) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeKmsKeysResponseBodyKeys(TeaModel):
    def __init__(
        self,
        alias: str = None,
        arn: str = None,
        key_id: str = None,
        type: str = None,
    ):
        # The alias of the key.
        self.alias = alias
        # The Alibaba Cloud Resource Name (ARN) of the key in KMS.
        self.arn = arn
        # The ID of the key.
        self.key_id = key_id
        # The type of the key.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.key_id is not None:
            result['KeyId'] = self.key_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('KeyId') is not None:
            self.key_id = m.get('KeyId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeKmsKeysResponseBody(TeaModel):
    def __init__(
        self,
        authorize_status: str = None,
        keys: List[DescribeKmsKeysResponseBodyKeys] = None,
        kms_service_status: str = None,
        request_id: str = None,
    ):
        # The authorization status.
        self.authorize_status = authorize_status
        # Details about the customer master keys (CMKs).
        self.keys = keys
        # Indicates whether KMS is activated.
        self.kms_service_status = kms_service_status
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.keys:
            for k in self.keys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorize_status is not None:
            result['AuthorizeStatus'] = self.authorize_status
        result['Keys'] = []
        if self.keys is not None:
            for k in self.keys:
                result['Keys'].append(k.to_map() if k else None)
        if self.kms_service_status is not None:
            result['KmsServiceStatus'] = self.kms_service_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthorizeStatus') is not None:
            self.authorize_status = m.get('AuthorizeStatus')
        self.keys = []
        if m.get('Keys') is not None:
            for k in m.get('Keys'):
                temp_model = DescribeKmsKeysResponseBodyKeys()
                self.keys.append(temp_model.from_map(k))
        if m.get('KmsServiceStatus') is not None:
            self.kms_service_status = m.get('KmsServiceStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeKmsKeysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeKmsKeysResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeKmsKeysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeModificationPriceRequest(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        instance_id: str = None,
        instance_type: str = None,
        region_id: str = None,
        resource_type: str = None,
        root_disk_size_gib: int = None,
        user_disk_size_gib: int = None,
    ):
        self.bandwidth = bandwidth
        self.instance_id = instance_id
        self.instance_type = instance_type
        # This parameter is required.
        self.region_id = region_id
        self.resource_type = resource_type
        self.root_disk_size_gib = root_disk_size_gib
        self.user_disk_size_gib = user_disk_size_gib

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.root_disk_size_gib is not None:
            result['RootDiskSizeGib'] = self.root_disk_size_gib
        if self.user_disk_size_gib is not None:
            result['UserDiskSizeGib'] = self.user_disk_size_gib
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('RootDiskSizeGib') is not None:
            self.root_disk_size_gib = m.get('RootDiskSizeGib')
        if m.get('UserDiskSizeGib') is not None:
            self.user_disk_size_gib = m.get('UserDiskSizeGib')
        return self


class DescribeModificationPriceResponseBodyPriceInfoPricePromotions(TeaModel):
    def __init__(
        self,
        option_code: str = None,
        promotion_desc: str = None,
        promotion_id: str = None,
        promotion_name: str = None,
        selected: bool = None,
    ):
        self.option_code = option_code
        self.promotion_desc = promotion_desc
        self.promotion_id = promotion_id
        self.promotion_name = promotion_name
        self.selected = selected

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.option_code is not None:
            result['OptionCode'] = self.option_code
        if self.promotion_desc is not None:
            result['PromotionDesc'] = self.promotion_desc
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.promotion_name is not None:
            result['PromotionName'] = self.promotion_name
        if self.selected is not None:
            result['Selected'] = self.selected
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OptionCode') is not None:
            self.option_code = m.get('OptionCode')
        if m.get('PromotionDesc') is not None:
            self.promotion_desc = m.get('PromotionDesc')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('PromotionName') is not None:
            self.promotion_name = m.get('PromotionName')
        if m.get('Selected') is not None:
            self.selected = m.get('Selected')
        return self


class DescribeModificationPriceResponseBodyPriceInfoPrice(TeaModel):
    def __init__(
        self,
        currency: str = None,
        discount_price: float = None,
        order_lines: Dict[str, str] = None,
        original_price: float = None,
        promotions: List[DescribeModificationPriceResponseBodyPriceInfoPricePromotions] = None,
        trade_price: float = None,
    ):
        self.currency = currency
        self.discount_price = discount_price
        self.order_lines = order_lines
        self.original_price = original_price
        self.promotions = promotions
        self.trade_price = trade_price

    def validate(self):
        if self.promotions:
            for k in self.promotions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.discount_price is not None:
            result['DiscountPrice'] = self.discount_price
        if self.order_lines is not None:
            result['OrderLines'] = self.order_lines
        if self.original_price is not None:
            result['OriginalPrice'] = self.original_price
        result['Promotions'] = []
        if self.promotions is not None:
            for k in self.promotions:
                result['Promotions'].append(k.to_map() if k else None)
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DiscountPrice') is not None:
            self.discount_price = m.get('DiscountPrice')
        if m.get('OrderLines') is not None:
            self.order_lines = m.get('OrderLines')
        if m.get('OriginalPrice') is not None:
            self.original_price = m.get('OriginalPrice')
        self.promotions = []
        if m.get('Promotions') is not None:
            for k in m.get('Promotions'):
                temp_model = DescribeModificationPriceResponseBodyPriceInfoPricePromotions()
                self.promotions.append(temp_model.from_map(k))
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class DescribeModificationPriceResponseBodyPriceInfoRules(TeaModel):
    def __init__(
        self,
        description: str = None,
        rule_id: int = None,
    ):
        self.description = description
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribeModificationPriceResponseBodyPriceInfo(TeaModel):
    def __init__(
        self,
        price: DescribeModificationPriceResponseBodyPriceInfoPrice = None,
        rules: List[DescribeModificationPriceResponseBodyPriceInfoRules] = None,
    ):
        self.price = price
        self.rules = rules

    def validate(self):
        if self.price:
            self.price.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.price is not None:
            result['Price'] = self.price.to_map()
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Price') is not None:
            temp_model = DescribeModificationPriceResponseBodyPriceInfoPrice()
            self.price = temp_model.from_map(m['Price'])
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeModificationPriceResponseBodyPriceInfoRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeModificationPriceResponseBody(TeaModel):
    def __init__(
        self,
        price_info: DescribeModificationPriceResponseBodyPriceInfo = None,
        request_id: str = None,
    ):
        self.price_info = price_info
        self.request_id = request_id

    def validate(self):
        if self.price_info:
            self.price_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PriceInfo') is not None:
            temp_model = DescribeModificationPriceResponseBodyPriceInfo()
            self.price_info = temp_model.from_map(m['PriceInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeModificationPriceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeModificationPriceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeModificationPriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNASFileSystemsRequest(TeaModel):
    def __init__(
        self,
        file_system_id: List[str] = None,
        match_compatible_profile: bool = None,
        max_results: int = None,
        next_token: str = None,
        office_site_id: str = None,
        region_id: str = None,
    ):
        # The IDs of the NAS file system.
        self.file_system_id = file_system_id
        # Specifies whether to filter NAS file systems that only support the user profile management (UPM) feature.
        self.match_compatible_profile = match_compatible_profile
        # The number of entries to return on each page.
        # 
        # Maximum value: 100.
        # 
        # Default value: 10.
        self.max_results = max_results
        # The token that determines the start point of the query.
        self.next_token = next_token
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The ID of the region.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.match_compatible_profile is not None:
            result['MatchCompatibleProfile'] = self.match_compatible_profile
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('MatchCompatibleProfile') is not None:
            self.match_compatible_profile = m.get('MatchCompatibleProfile')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeNASFileSystemsResponseBodyFileSystemsAppInstanceGroups(TeaModel):
    def __init__(
        self,
        app_instance_group_id: str = None,
        app_instance_group_name: str = None,
    ):
        # The ID of the delivery group.
        self.app_instance_group_id = app_instance_group_id
        # The name of the delivery group.
        self.app_instance_group_name = app_instance_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_instance_group_id is not None:
            result['AppInstanceGroupId'] = self.app_instance_group_id
        if self.app_instance_group_name is not None:
            result['AppInstanceGroupName'] = self.app_instance_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppInstanceGroupId') is not None:
            self.app_instance_group_id = m.get('AppInstanceGroupId')
        if m.get('AppInstanceGroupName') is not None:
            self.app_instance_group_name = m.get('AppInstanceGroupName')
        return self


class DescribeNASFileSystemsResponseBodyFileSystemsDesktopGroups(TeaModel):
    def __init__(
        self,
        desktop_group_id: str = None,
        desktop_group_name: str = None,
    ):
        # The ID of the desktop group.
        self.desktop_group_id = desktop_group_id
        # The name of the desktop group.
        self.desktop_group_name = desktop_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_name is not None:
            result['DesktopGroupName'] = self.desktop_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupName') is not None:
            self.desktop_group_name = m.get('DesktopGroupName')
        return self


class DescribeNASFileSystemsResponseBodyFileSystemsOfficeSites(TeaModel):
    def __init__(
        self,
        office_site_id: str = None,
        office_site_name: str = None,
    ):
        # The ID of the office network.
        self.office_site_id = office_site_id
        # The name of the office network.
        self.office_site_name = office_site_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        return self


class DescribeNASFileSystemsResponseBodyFileSystems(TeaModel):
    def __init__(
        self,
        allow_operate_user_drive: bool = None,
        app_instance_groups: List[DescribeNASFileSystemsResponseBodyFileSystemsAppInstanceGroups] = None,
        capacity: int = None,
        create_time: str = None,
        description: str = None,
        desktop_groups: List[DescribeNASFileSystemsResponseBodyFileSystemsDesktopGroups] = None,
        encryption_enabled: bool = None,
        file_system_id: str = None,
        file_system_name: str = None,
        file_system_status: str = None,
        file_system_type: str = None,
        metered_size: int = None,
        mount_target_domain: str = None,
        mount_target_status: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        office_sites: List[DescribeNASFileSystemsResponseBodyFileSystemsOfficeSites] = None,
        profile_compatible: bool = None,
        region_id: str = None,
        scene: str = None,
        storage_type: str = None,
        support_acl: bool = None,
        zone_id: str = None,
    ):
        # > This parameter is not publicly available.
        self.allow_operate_user_drive = allow_operate_user_drive
        # The array of the app steaming delivery groups bound with UPM-supported NAS.
        self.app_instance_groups = app_instance_groups
        # The total capacity of the NAS file system. Unit: GiB.
        # 
        # *   The Capacity type has 10 PiB of storage, which is equal to 10,485,760 GiB.
        # *   The Performance type has 1 PiB of storage, which is equal to 1,048,576 GiB.
        self.capacity = capacity
        # The time when the NAS file system was created.
        self.create_time = create_time
        # The description of the NAS file system.
        self.description = description
        # The desktop groups that are associated with the NAS file systems that support the UPM feature.
        self.desktop_groups = desktop_groups
        # Indicates whether disk encryption is enabled.
        self.encryption_enabled = encryption_enabled
        # The ID of the NAS file system.
        self.file_system_id = file_system_id
        # The name of the NAS file system.
        self.file_system_name = file_system_name
        # The status of the NAS file system. The possible values include:
        # 
        # *   Pending: The NAS file system is being created.
        # *   Running: The NAS file system is running.
        # *   Stopped: The NAS file system is stopped.
        # *   Deleting: The NAS file system is being deleted.
        # *   Deleted: The NAS file system is deleted.
        # *   Invalid: The NAS file system is invalid.
        self.file_system_status = file_system_status
        # The type of the NAS file system. Valid value: Universal NAS. This value indicates that the NAS file system is a General-purpose one.
        self.file_system_type = file_system_type
        # The used storage of the NAS file system. Unit: byte.
        self.metered_size = metered_size
        # The domain name of the mount target.
        self.mount_target_domain = mount_target_domain
        # The status of the mount target. The possible values include:
        # 
        # *   Pending: The mount target is being created.
        # *   Active: The mount target is enabled.
        # *   Inactive: The mount target is disabled.
        # *   Deleting: The mount target is being deleted.
        # *   Invalid: The mount target is invalid.
        self.mount_target_status = mount_target_status
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The name of the workspace.
        self.office_site_name = office_site_name
        # The array of office networks.
        self.office_sites = office_sites
        # Indicates whether the User Profile Management (UPM) feature is supported.
        self.profile_compatible = profile_compatible
        # The ID of the region.
        self.region_id = region_id
        # The storage type of the NAS file system. Valid values:
        # 
        # - Upm: UPM NAS
        # - ShareNas: Shared NAS
        self.scene = scene
        # The storage type of the NAS file system. Valid values:
        # 
        # *   Capacity
        # *   Performance
        self.storage_type = storage_type
        # Indicates whether the Server Message Block (SMB) access control list (ACL) feature was enabled.
        self.support_acl = support_acl
        # The ID of the zone where the NAS file system resides.
        self.zone_id = zone_id

    def validate(self):
        if self.app_instance_groups:
            for k in self.app_instance_groups:
                if k:
                    k.validate()
        if self.desktop_groups:
            for k in self.desktop_groups:
                if k:
                    k.validate()
        if self.office_sites:
            for k in self.office_sites:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_operate_user_drive is not None:
            result['AllowOperateUserDrive'] = self.allow_operate_user_drive
        result['AppInstanceGroups'] = []
        if self.app_instance_groups is not None:
            for k in self.app_instance_groups:
                result['AppInstanceGroups'].append(k.to_map() if k else None)
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        result['DesktopGroups'] = []
        if self.desktop_groups is not None:
            for k in self.desktop_groups:
                result['DesktopGroups'].append(k.to_map() if k else None)
        if self.encryption_enabled is not None:
            result['EncryptionEnabled'] = self.encryption_enabled
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.file_system_name is not None:
            result['FileSystemName'] = self.file_system_name
        if self.file_system_status is not None:
            result['FileSystemStatus'] = self.file_system_status
        if self.file_system_type is not None:
            result['FileSystemType'] = self.file_system_type
        if self.metered_size is not None:
            result['MeteredSize'] = self.metered_size
        if self.mount_target_domain is not None:
            result['MountTargetDomain'] = self.mount_target_domain
        if self.mount_target_status is not None:
            result['MountTargetStatus'] = self.mount_target_status
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        result['OfficeSites'] = []
        if self.office_sites is not None:
            for k in self.office_sites:
                result['OfficeSites'].append(k.to_map() if k else None)
        if self.profile_compatible is not None:
            result['ProfileCompatible'] = self.profile_compatible
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        if self.support_acl is not None:
            result['SupportAcl'] = self.support_acl
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowOperateUserDrive') is not None:
            self.allow_operate_user_drive = m.get('AllowOperateUserDrive')
        self.app_instance_groups = []
        if m.get('AppInstanceGroups') is not None:
            for k in m.get('AppInstanceGroups'):
                temp_model = DescribeNASFileSystemsResponseBodyFileSystemsAppInstanceGroups()
                self.app_instance_groups.append(temp_model.from_map(k))
        if m.get('Capacity') is not None:
            self.capacity = m.get('Capacity')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.desktop_groups = []
        if m.get('DesktopGroups') is not None:
            for k in m.get('DesktopGroups'):
                temp_model = DescribeNASFileSystemsResponseBodyFileSystemsDesktopGroups()
                self.desktop_groups.append(temp_model.from_map(k))
        if m.get('EncryptionEnabled') is not None:
            self.encryption_enabled = m.get('EncryptionEnabled')
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('FileSystemName') is not None:
            self.file_system_name = m.get('FileSystemName')
        if m.get('FileSystemStatus') is not None:
            self.file_system_status = m.get('FileSystemStatus')
        if m.get('FileSystemType') is not None:
            self.file_system_type = m.get('FileSystemType')
        if m.get('MeteredSize') is not None:
            self.metered_size = m.get('MeteredSize')
        if m.get('MountTargetDomain') is not None:
            self.mount_target_domain = m.get('MountTargetDomain')
        if m.get('MountTargetStatus') is not None:
            self.mount_target_status = m.get('MountTargetStatus')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        self.office_sites = []
        if m.get('OfficeSites') is not None:
            for k in m.get('OfficeSites'):
                temp_model = DescribeNASFileSystemsResponseBodyFileSystemsOfficeSites()
                self.office_sites.append(temp_model.from_map(k))
        if m.get('ProfileCompatible') is not None:
            self.profile_compatible = m.get('ProfileCompatible')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        if m.get('SupportAcl') is not None:
            self.support_acl = m.get('SupportAcl')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeNASFileSystemsResponseBody(TeaModel):
    def __init__(
        self,
        file_systems: List[DescribeNASFileSystemsResponseBodyFileSystems] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # Details about the NAS file systems.
        self.file_systems = file_systems
        # The token that determines the start point of the next query. This parameter is empty if no additional results exist.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.file_systems:
            for k in self.file_systems:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileSystems'] = []
        if self.file_systems is not None:
            for k in self.file_systems:
                result['FileSystems'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_systems = []
        if m.get('FileSystems') is not None:
            for k in m.get('FileSystems'):
                temp_model = DescribeNASFileSystemsResponseBodyFileSystems()
                self.file_systems.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNASFileSystemsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNASFileSystemsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNASFileSystemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNetworkPackagesRequest(TeaModel):
    def __init__(
        self,
        internet_charge_type: str = None,
        max_results: int = None,
        network_package_id: List[str] = None,
        next_token: str = None,
        region_id: str = None,
    ):
        # The charge type of the pay-as-you-go premium bandwidth plan.
        # 
        # Valid values:
        # 
        # *   PayByTraffic: charges by data transfer.
        # 
        # *   PayByBandwidth: charges by fixed bandwidth.
        self.internet_charge_type = internet_charge_type
        # The number of entries to return on each page.
        # 
        # *   Maximum value: 100
        # *   Default value: 10
        self.max_results = max_results
        # The ID of the premium bandwidth plan. You can specify 1 to 100 IDs.
        self.network_package_id = network_package_id
        # The token that determines the start point of the next query.
        self.next_token = next_token
        # The region ID. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/196646.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeNetworkPackagesResponseBodyNetworkPackages(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        business_status: str = None,
        create_time: str = None,
        eip_addresses: List[str] = None,
        expired_time: str = None,
        internet_charge_type: str = None,
        network_package_id: str = None,
        network_package_status: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        office_site_vpc_type: str = None,
        pay_type: str = None,
        reservation_active_time: str = None,
        reservation_bandwidth: int = None,
        reservation_internet_charge_type: str = None,
    ):
        # The bandwidth provided by the premium bandwidth plan. Unit: Mbit/s.
        self.bandwidth = bandwidth
        # The business status.
        # 
        # Valid values:
        # 
        # *   Expired
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Normal
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.business_status = business_status
        # The time when the premium bandwidth plan was created.
        self.create_time = create_time
        # The public egress IP address of the premium bandwidth plan.
        self.eip_addresses = eip_addresses
        # The time when the premium bandwidth plan expires.
        # 
        # *   If the plan is a subscription one, the time when the plan expires is returned.
        # *   If the plan is a pay-as-you-go one, `2099-12-31T15:59:59Z` is returned.
        self.expired_time = expired_time
        # The charge type of the premium bandwidth plan.
        # 
        # *   Valid value when the `PayType` parameter is set to `PrePaid`:
        # 
        #     *   PayByBandwidth: charges by fixed bandwidth.
        # 
        # *   Valid values when the `PayType` parameter is set to `PostPaid`:
        # 
        #     *   PayByTraffic: charges by data transfer.
        #     *   PayByBandwidth: charges by fixed bandwidth.
        self.internet_charge_type = internet_charge_type
        # The ID of the premium bandwidth plan.
        self.network_package_id = network_package_id
        # The status of the premium bandwidth plan.
        # 
        # Valid values:
        # 
        # *   Creating
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Released
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   InUse
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Releasing
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.network_package_status = network_package_status
        # The office network ID.
        self.office_site_id = office_site_id
        # The office network name.
        self.office_site_name = office_site_name
        # The type of the office network.
        # 
        # Valid values:
        # 
        # *   standard: advanced office network
        # *   customized: custom office network
        # *   basic: basic office network
        self.office_site_vpc_type = office_site_vpc_type
        # The billing method of the premium bandwidth plan.
        # 
        # Valid values:
        # 
        # *   PostPaid: pay-as-you-go
        # *   PrePaid: subscription
        self.pay_type = pay_type
        # The time when the reserved network bandwidth took effect.
        self.reservation_active_time = reservation_active_time
        # The peak bandwidth that is reserved for the premium bandwidth plan. Unit: Mbit/s.
        self.reservation_bandwidth = reservation_bandwidth
        # The billing method of the reserved network bandwidth.
        # 
        # Valid values:
        # 
        # *   PayByTraffic: charges by data transfer.
        # 
        # *   PayByBandwidth: charges by fixed bandwidth.
        self.reservation_internet_charge_type = reservation_internet_charge_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.eip_addresses is not None:
            result['EipAddresses'] = self.eip_addresses
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.network_package_status is not None:
            result['NetworkPackageStatus'] = self.network_package_status
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.office_site_vpc_type is not None:
            result['OfficeSiteVpcType'] = self.office_site_vpc_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.reservation_active_time is not None:
            result['ReservationActiveTime'] = self.reservation_active_time
        if self.reservation_bandwidth is not None:
            result['ReservationBandwidth'] = self.reservation_bandwidth
        if self.reservation_internet_charge_type is not None:
            result['ReservationInternetChargeType'] = self.reservation_internet_charge_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EipAddresses') is not None:
            self.eip_addresses = m.get('EipAddresses')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('NetworkPackageStatus') is not None:
            self.network_package_status = m.get('NetworkPackageStatus')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OfficeSiteVpcType') is not None:
            self.office_site_vpc_type = m.get('OfficeSiteVpcType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('ReservationActiveTime') is not None:
            self.reservation_active_time = m.get('ReservationActiveTime')
        if m.get('ReservationBandwidth') is not None:
            self.reservation_bandwidth = m.get('ReservationBandwidth')
        if m.get('ReservationInternetChargeType') is not None:
            self.reservation_internet_charge_type = m.get('ReservationInternetChargeType')
        return self


class DescribeNetworkPackagesResponseBody(TeaModel):
    def __init__(
        self,
        network_packages: List[DescribeNetworkPackagesResponseBodyNetworkPac