"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .granttype import GrantType
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import FieldMetadata
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AuthTokenRequestTypedDict(TypedDict):
    grant_type: GrantType
    r"""The type of grant being requested.

    - `client_credentials`: A grant type used by clients to obtain an access token
    - `refresh_token`: A grant type used by clients to obtain a new access token using a refresh token
    """
    client_id: NotRequired[str]
    r"""Client ID can be provided here in the body, or as the Username in HTTP Basic Auth."""
    client_secret: NotRequired[str]
    r"""Client secret can be provided here in the body, or as the Password in HTTP Basic Auth."""
    scope: NotRequired[str]
    r"""A space delimited list of scopes. Required when `grant_type` is `client_credentials`."""
    refresh_token: NotRequired[str]
    r"""The refresh_token returned alongside the access token being refreshed. Required when `grant_type` is `refresh_token`."""


class AuthTokenRequest(BaseModel):
    grant_type: Annotated[GrantType, FieldMetadata(form=True)]
    r"""The type of grant being requested.

    - `client_credentials`: A grant type used by clients to obtain an access token
    - `refresh_token`: A grant type used by clients to obtain a new access token using a refresh token
    """

    client_id: Annotated[Optional[str], FieldMetadata(form=True)] = None
    r"""Client ID can be provided here in the body, or as the Username in HTTP Basic Auth."""

    client_secret: Annotated[Optional[str], FieldMetadata(form=True)] = None
    r"""Client secret can be provided here in the body, or as the Password in HTTP Basic Auth."""

    scope: Annotated[Optional[str], FieldMetadata(form=True)] = None
    r"""A space delimited list of scopes. Required when `grant_type` is `client_credentials`."""

    refresh_token: Annotated[Optional[str], FieldMetadata(form=True)] = None
    r"""The refresh_token returned alongside the access token being refreshed. Required when `grant_type` is `refresh_token`."""
