"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CardAcceptanceMethodsTypedDict(TypedDict):
    r"""Describes the distribution of card transactions by payment method."""

    in_person_percentage: NotRequired[int]
    r"""Percentage of card transactions that are in-person payments. Minimum value is 0, maximum is 100."""
    mail_or_phone_percentage: NotRequired[int]
    r"""Percentage of card transactions that are mail or phone payments. Minimum value is 0, maximum is 100."""
    online_percentage: NotRequired[int]
    r"""Percentage of card transactions that are online payments. Minimum value is 0, maximum is 100."""


class CardAcceptanceMethods(BaseModel):
    r"""Describes the distribution of card transactions by payment method."""

    in_person_percentage: Annotated[
        Optional[int], pydantic.Field(alias="inPersonPercentage")
    ] = None
    r"""Percentage of card transactions that are in-person payments. Minimum value is 0, maximum is 100."""

    mail_or_phone_percentage: Annotated[
        Optional[int], pydantic.Field(alias="mailOrPhonePercentage")
    ] = None
    r"""Percentage of card transactions that are mail or phone payments. Minimum value is 0, maximum is 100."""

    online_percentage: Annotated[
        Optional[int], pydantic.Field(alias="onlinePercentage")
    ] = None
    r"""Percentage of card transactions that are online payments. Minimum value is 0, maximum is 100."""
