"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .terminalcard import TerminalCard, TerminalCardTypedDict
from enum import Enum
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CardPresentPaymentPaymentMethodPaymentMethodType(str, Enum):
    CARD_PRESENT_PAYMENT = "card-present-payment"


class CardPresentPaymentPaymentMethodTypedDict(TypedDict):
    r"""A card used at point of sale terminal for a card present transaction as contained within a payment method."""

    payment_method_id: str
    r"""ID of the payment method."""
    payment_method_type: CardPresentPaymentPaymentMethodPaymentMethodType
    terminal_card: NotRequired[TerminalCardTypedDict]
    r"""Describes payment card details captured with tap or in-person payment."""


class CardPresentPaymentPaymentMethod(BaseModel):
    r"""A card used at point of sale terminal for a card present transaction as contained within a payment method."""

    payment_method_id: Annotated[str, pydantic.Field(alias="paymentMethodID")]
    r"""ID of the payment method."""

    payment_method_type: Annotated[
        CardPresentPaymentPaymentMethodPaymentMethodType,
        pydantic.Field(alias="paymentMethodType"),
    ]

    terminal_card: Annotated[
        Optional[TerminalCard], pydantic.Field(alias="terminalCard")
    ] = None
    r"""Describes payment card details captured with tap or in-person payment."""
