"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .billablefee import BillableFee, BillableFeeTypedDict
from .cardacquiringmodel import CardAcquiringModel
from .minimumcommitment import MinimumCommitment, MinimumCommitmentTypedDict
from .monthlyplatformfee import MonthlyPlatformFee, MonthlyPlatformFeeTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class FeePlanTypedDict(TypedDict):
    plan_id: str
    name: str
    r"""The name of the fee plan."""
    card_acquiring_model: CardAcquiringModel
    r"""Specifies the card processing pricing model"""
    billable_fees: List[BillableFeeTypedDict]
    r"""Additional usage-based fees for this plan."""
    minimum_commitment: MinimumCommitmentTypedDict
    r"""The minimum spending amount that must be met in the billing period. If actual usage is below the minimum amount, account is charged the difference."""
    monthly_platform_fee: MonthlyPlatformFeeTypedDict
    r"""Fixed recurring amount paid in the billing period regardless of usage."""
    created_at: datetime
    description: NotRequired[str]
    r"""A description of the fee plan."""


class FeePlan(BaseModel):
    plan_id: Annotated[str, pydantic.Field(alias="planID")]

    name: str
    r"""The name of the fee plan."""

    card_acquiring_model: Annotated[
        CardAcquiringModel, pydantic.Field(alias="cardAcquiringModel")
    ]
    r"""Specifies the card processing pricing model"""

    billable_fees: Annotated[List[BillableFee], pydantic.Field(alias="billableFees")]
    r"""Additional usage-based fees for this plan."""

    minimum_commitment: Annotated[
        MinimumCommitment, pydantic.Field(alias="minimumCommitment")
    ]
    r"""The minimum spending amount that must be met in the billing period. If actual usage is below the minimum amount, account is charged the difference."""

    monthly_platform_fee: Annotated[
        MonthlyPlatformFee, pydantic.Field(alias="monthlyPlatformFee")
    ]
    r"""Fixed recurring amount paid in the billing period regardless of usage."""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]

    description: Optional[str] = None
    r"""A description of the fee plan."""
