"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class FeePropertiesTypedDict(TypedDict):
    r"""Defines the specific parameters used for fee calculation."""

    fixed_amount: NotRequired[AmountDecimalTypedDict]
    r"""A fixed fee that is applied to the amount of each transaction in the `fixed` and `blended` fee models."""
    variable_rate: NotRequired[str]
    r"""A percentage fee that is applied to the amount of each transaction in the `blended` fee model, expressed as a decimal.

    For example, 0.05% is '0.05'.
    """
    min_per_transaction: NotRequired[AmountDecimalTypedDict]
    r"""Specifies the minimum allowable spending for a single transaction, working as a transaction floor."""
    max_per_transaction: NotRequired[AmountDecimalTypedDict]
    r"""Specifies the maximum allowable spending for a single transaction, working as a transaction ceiling."""


class FeeProperties(BaseModel):
    r"""Defines the specific parameters used for fee calculation."""

    fixed_amount: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="fixedAmount")
    ] = None
    r"""A fixed fee that is applied to the amount of each transaction in the `fixed` and `blended` fee models."""

    variable_rate: Annotated[Optional[str], pydantic.Field(alias="variableRate")] = None
    r"""A percentage fee that is applied to the amount of each transaction in the `blended` fee model, expressed as a decimal.

    For example, 0.05% is '0.05'.
    """

    min_per_transaction: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="minPerTransaction")
    ] = None
    r"""Specifies the minimum allowable spending for a single transaction, working as a transaction floor."""

    max_per_transaction: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="maxPerTransaction")
    ] = None
    r"""Specifies the maximum allowable spending for a single transaction, working as a transaction ceiling."""
