"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .filepurpose import FilePurpose
from .filestatus import FileStatus
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class FileDetailsTypedDict(TypedDict):
    r"""Describes a file linked to a Moov account."""

    file_id: str
    file_name: str
    account_id: str
    file_purpose: FilePurpose
    r"""The file's purpose."""
    file_status: FileStatus
    r"""The file's status."""
    metadata: str
    file_size_bytes: int
    created_on: datetime
    updated_on: datetime
    decision_reason: NotRequired[str]


class FileDetails(BaseModel):
    r"""Describes a file linked to a Moov account."""

    file_id: Annotated[str, pydantic.Field(alias="fileID")]

    file_name: Annotated[str, pydantic.Field(alias="fileName")]

    account_id: Annotated[str, pydantic.Field(alias="accountID")]

    file_purpose: Annotated[FilePurpose, pydantic.Field(alias="filePurpose")]
    r"""The file's purpose."""

    file_status: Annotated[FileStatus, pydantic.Field(alias="fileStatus")]
    r"""The file's status."""

    metadata: str

    file_size_bytes: Annotated[int, pydantic.Field(alias="fileSizeBytes")]

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]

    decision_reason: Annotated[
        Optional[str], pydantic.Field(alias="decisionReason")
    ] = None
