"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class IssuingMerchantDataTypedDict(TypedDict):
    network_id: NotRequired[str]
    r"""External identifier used to identify the merchant with the card brand."""
    name: NotRequired[str]
    r"""Name of the merchant."""
    city: NotRequired[str]
    r"""The merchant's location."""
    country: NotRequired[str]
    r"""Two-letter country code."""
    postal_code: NotRequired[str]
    r"""The merchant's five-digit postal code."""
    state: NotRequired[str]
    r"""The merchant's two-letter state abbreviation."""
    mcc: NotRequired[str]
    r"""The Merchant Category Code."""


class IssuingMerchantData(BaseModel):
    network_id: Annotated[Optional[str], pydantic.Field(alias="networkID")] = None
    r"""External identifier used to identify the merchant with the card brand."""

    name: Optional[str] = None
    r"""Name of the merchant."""

    city: Optional[str] = None
    r"""The merchant's location."""

    country: Optional[str] = None
    r"""Two-letter country code."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""The merchant's five-digit postal code."""

    state: Optional[str] = None
    r"""The merchant's two-letter state abbreviation."""

    mcc: Optional[str] = None
    r"""The Merchant Category Code."""
