"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .applepayheader import ApplePayHeader, ApplePayHeaderTypedDict
from moovio_sdk.types import BaseModel
from typing_extensions import TypedDict


class LinkApplePaymentDataTypedDict(TypedDict):
    r"""Contains the encrypted payment data.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken/1916115-paymentdata)
    for more information.
    """

    version: str
    r"""Specifies the encryption used for the payment token (\"EC_v1\" or \"RSA_v1\")."""
    data: str
    r"""The encrypted, base64-encoded payment data."""
    signature: str
    r"""A base64 encoded signature of the payment and header data."""
    header: ApplePayHeaderTypedDict
    r"""Information needed to decrypt Apple Pay payment data.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/passkit/payment-token-format-reference#Header-keys-and-values)
    for more information.
    """


class LinkApplePaymentData(BaseModel):
    r"""Contains the encrypted payment data.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken/1916115-paymentdata)
    for more information.
    """

    version: str
    r"""Specifies the encryption used for the payment token (\"EC_v1\" or \"RSA_v1\")."""

    data: str
    r"""The encrypted, base64-encoded payment data."""

    signature: str
    r"""A base64 encoded signature of the payment and header data."""

    header: ApplePayHeader
    r"""Information needed to decrypt Apple Pay payment data.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/passkit/payment-token-format-reference#Header-keys-and-values)
    for more information.
    """
