"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .addressupdate import AddressUpdate, AddressUpdateTypedDict
from .businesstype import BusinessType
from .industrycodes import IndustryCodes, IndustryCodesTypedDict
from .phonenumber import PhoneNumber, PhoneNumberTypedDict
from .primaryregulator import PrimaryRegulator
from .taxidupdate import TaxIDUpdate, TaxIDUpdateTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PatchBusinessTypedDict(TypedDict):
    legal_business_name: NotRequired[str]
    doing_business_as: NotRequired[str]
    business_type: NotRequired[BusinessType]
    r"""The type of entity represented by this business."""
    address: NotRequired[AddressUpdateTypedDict]
    phone: NotRequired[PhoneNumberTypedDict]
    email: NotRequired[str]
    website: NotRequired[str]
    description: NotRequired[str]
    tax_id: NotRequired[TaxIDUpdateTypedDict]
    r"""An EIN (employer identification number) for the business. For sole proprietors, an SSN can be used as the EIN."""
    owners_provided: NotRequired[bool]
    industry_codes: NotRequired[IndustryCodesTypedDict]
    primary_regulator: NotRequired[PrimaryRegulator]
    r"""If the business is a financial institution, this field describes its primary regulator."""


class PatchBusiness(BaseModel):
    legal_business_name: Annotated[
        Optional[str], pydantic.Field(alias="legalBusinessName")
    ] = None

    doing_business_as: Annotated[
        Optional[str], pydantic.Field(alias="doingBusinessAs")
    ] = None

    business_type: Annotated[
        Optional[BusinessType], pydantic.Field(alias="businessType")
    ] = None
    r"""The type of entity represented by this business."""

    address: Optional[AddressUpdate] = None

    phone: Optional[PhoneNumber] = None

    email: Optional[str] = None

    website: Optional[str] = None

    description: Optional[str] = None

    tax_id: Annotated[Optional[TaxIDUpdate], pydantic.Field(alias="taxID")] = None
    r"""An EIN (employer identification number) for the business. For sole proprietors, an SSN can be used as the EIN."""

    owners_provided: Annotated[
        Optional[bool], pydantic.Field(alias="ownersProvided")
    ] = None

    industry_codes: Annotated[
        Optional[IndustryCodes], pydantic.Field(alias="industryCodes")
    ] = None

    primary_regulator: Annotated[
        Optional[PrimaryRegulator], pydantic.Field(alias="primaryRegulator")
    ] = None
    r"""If the business is a financial institution, this field describes its primary regulator."""
