"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import FieldMetadata
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TokenTypeHint(str, Enum):
    r"""The type of token being revoked."""

    ACCESS_TOKEN = "access_token"
    REFRESH_TOKEN = "refresh_token"


class RevokeTokenRequestTypedDict(TypedDict):
    token: str
    r"""The access or refresh token to revoke."""
    token_type_hint: NotRequired[TokenTypeHint]
    r"""The type of token being revoked."""
    client_id: NotRequired[str]
    r"""Client ID can be provided here in the body, or as the Username in HTTP Basic Auth."""
    client_secret: NotRequired[str]
    r"""Client secret can be provided here in the body, or as the Password in HTTP Basic Auth."""


class RevokeTokenRequest(BaseModel):
    token: Annotated[str, FieldMetadata(form=True)]
    r"""The access or refresh token to revoke."""

    token_type_hint: Annotated[Optional[TokenTypeHint], FieldMetadata(form=True)] = None
    r"""The type of token being revoked."""

    client_id: Annotated[Optional[str], FieldMetadata(form=True)] = None
    r"""Client ID can be provided here in the body, or as the Username in HTTP Basic Auth."""

    client_secret: Annotated[Optional[str], FieldMetadata(form=True)] = None
    r"""Client secret can be provided here in the body, or as the Password in HTTP Basic Auth."""
