"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .createauthorizeduserupdate import (
    CreateAuthorizedUserUpdate,
    CreateAuthorizedUserUpdateTypedDict,
)
from .issuedcardstate import IssuedCardState
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateIssuedCardTypedDict(TypedDict):
    state: NotRequired[IssuedCardState]
    r"""The `state` represents the operational status of an issued card. A card can only approve incoming authorizations if it is in an active state.

    - `active`: The card is operational and approves authorizations. Generally becomes active shortly after card creation.
    - `inactive`: The card cannot approve authorizations. This is currently a temporary state assigned post-creation during the activation process.
    - `closed`: The card is permanently deactivated and cannot approve authorizations. A card can be closed by request or when it expires.
    - `pending-verification`: Awaiting additional authorized user verification before the card can be activated.
    """
    memo: NotRequired[str]
    authorized_user: NotRequired[CreateAuthorizedUserUpdateTypedDict]
    r"""Fields for identifying an authorized individual."""


class UpdateIssuedCard(BaseModel):
    state: Optional[IssuedCardState] = None
    r"""The `state` represents the operational status of an issued card. A card can only approve incoming authorizations if it is in an active state.

    - `active`: The card is operational and approves authorizations. Generally becomes active shortly after card creation.
    - `inactive`: The card cannot approve authorizations. This is currently a temporary state assigned post-creation during the activation process.
    - `closed`: The card is permanently deactivated and cannot approve authorizations. A card can be closed by request or when it expires.
    - `pending-verification`: Awaiting additional authorized user verification before the card can be activated.
    """

    memo: Optional[str] = None

    authorized_user: Annotated[
        Optional[CreateAuthorizedUserUpdate], pydantic.Field(alias="authorizedUser")
    ] = None
    r"""Fields for identifying an authorized individual."""
