"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountverificationstatus import AccountVerificationStatus
from .document import Document, DocumentTypedDict
from .verificationstatus import VerificationStatus
from .verificationstatusdetail import VerificationStatusDetail
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class VerificationTypedDict(TypedDict):
    r"""Describes identity verification status and relevant identity verification documents."""

    status: VerificationStatus
    r"""Possible states an account verification can be in."""
    verification_status: NotRequired[AccountVerificationStatus]
    r"""Possible states an account verification can be in."""
    details: NotRequired[VerificationStatusDetail]
    r"""Additional detail for a verification status."""
    documents: NotRequired[List[DocumentTypedDict]]


class Verification(BaseModel):
    r"""Describes identity verification status and relevant identity verification documents."""

    status: Annotated[
        VerificationStatus,
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ]
    r"""Possible states an account verification can be in."""

    verification_status: Annotated[
        Optional[AccountVerificationStatus],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.",
            alias="verificationStatus",
        ),
    ] = None
    r"""Possible states an account verification can be in."""

    details: Annotated[
        Optional[VerificationStatusDetail],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = None
    r"""Additional detail for a verification status."""

    documents: Optional[List[Document]] = None
