# setup.py
from setuptools import setup, find_packages

setup(
    name="spiderforce4ai",
    version="1.2",
    author="Piotr Tamulewicz",
    author_email="pt@petertam.pro",
    description="Python wrapper for SpiderForce4AI HTML-to-Markdown conversion service",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    url="https://petertam.pro",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
    ],
    python_requires=">=3.11",
    install_requires=[
        "aiohttp>=3.8.0",
        "asyncio>=3.4.3",
        "rich>=10.0.0",
        "aiofiles>=0.8.0",
        "httpx>=0.24.0"
    ],
)