# Contributing to Velithon

Thank you for your interest in contributing to Velithon! This guide will help you get started with contributing to the project.

## Overview

Velithon is an open-source project and we welcome contributions from the community. Whether you're fixing bugs, adding features, improving documentation, or helping with testing, your contributions are valued.

## Ways to Contribute

### 1. Code Contributions
- Bug fixes
- New features
- Performance improvements
- Code optimizations

### 2. Documentation
- API documentation
- Tutorials and guides
- Code examples
- Translation

### 3. Testing
- Writing unit tests
- Integration testing
- Performance testing
- Bug reporting

### 4. Community Support
- Answering questions in issues
- Helping other contributors
- Code reviews
- Documentation reviews

## Getting Started

1. **Fork the repository** on GitHub
2. **Clone your fork** locally
3. **Set up the development environment**
4. **Create a feature branch**
5. **Make your changes**
6. **Test your changes**
7. **Submit a pull request**

## Quick Links

- [Development Setup](development.md) - Set up your local development environment
- [Code Style](code-style.md) - Coding standards and style guidelines
- [Testing](testing.md) - How to write and run tests
- [Documentation](documentation.md) - How to contribute to documentation

## Code of Conduct

We are committed to providing a welcoming and inclusive environment for all contributors. Please be respectful and professional in all interactions.

## Getting Help

If you need help with contributing:

1. Check the [documentation](development.md)
2. Look through existing [issues](https://github.com/DVNghiem/velithon/issues)
3. Ask questions in [discussions](https://github.com/DVNghiem/velithon/discussions)
4. Join our community chat (if available)

## Recognition

All contributors will be acknowledged in our contributors list. We appreciate every contribution, no matter how small!

## License

By contributing to Velithon, you agree that your contributions will be licensed under the same license as the project (BSD-3-Clause).
