from __future__ import annotations

from typing_extensions import TypedDict


class BatchListParams(TypedDict, total=False):
	"""
	Parameters for listing resources in batches.

	Attributes:
	    after (str): A cursor for use in pagination.
	            `after` is an object ID that defines your place in the list. For instance,
	            if you make a list request and receive 100 objects, ending with obj_foo,
	            your subsequent call can include after=obj_foo in order to fetch the next
	            page of the list.
	    limit (int): A limit on the number of objects to be returned.
	            Limit can range between 1 and 100, and the default is 10.
	"""

	after: str
	limit: int
