# This file was auto-generated by Fern from our API Definition.

import typing

import httpx
from ..environment import SarvamAIEnvironment
from .http_client import AsyncHttpClient, HttpClient


class BaseClientWrapper:
    def __init__(
        self,
        *,
        api_subscription_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        environment: SarvamAIEnvironment,
        timeout: typing.Optional[float] = None,
    ):
        self.api_subscription_key = api_subscription_key
        self._headers = headers
        self._environment = environment
        self._timeout = timeout

    def get_headers(self) -> typing.Dict[str, str]:
        headers: typing.Dict[str, str] = {
            "User-Agent": "sarvamai/0.1.19a2",
            "X-Fern-Language": "Python",
            "X-Fern-SDK-Name": "sarvamai",
            "X-Fern-SDK-Version": "0.1.19a2",
            **(self.get_custom_headers() or {}),
        }
        headers["api-subscription-key"] = self.api_subscription_key
        return headers

    def get_custom_headers(self) -> typing.Optional[typing.Dict[str, str]]:
        return self._headers

    def get_environment(self) -> SarvamAIEnvironment:
        return self._environment

    def get_timeout(self) -> typing.Optional[float]:
        return self._timeout


class SyncClientWrapper(BaseClientWrapper):
    def __init__(
        self,
        *,
        api_subscription_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        environment: SarvamAIEnvironment,
        timeout: typing.Optional[float] = None,
        httpx_client: httpx.Client,
    ):
        super().__init__(
            api_subscription_key=api_subscription_key, headers=headers, environment=environment, timeout=timeout
        )
        self.httpx_client = HttpClient(
            httpx_client=httpx_client, base_headers=self.get_headers, base_timeout=self.get_timeout
        )


class AsyncClientWrapper(BaseClientWrapper):
    def __init__(
        self,
        *,
        api_subscription_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        environment: SarvamAIEnvironment,
        timeout: typing.Optional[float] = None,
        httpx_client: httpx.AsyncClient,
    ):
        super().__init__(
            api_subscription_key=api_subscription_key, headers=headers, environment=environment, timeout=timeout
        )
        self.httpx_client = AsyncHttpClient(
            httpx_client=httpx_client, base_headers=self.get_headers, base_timeout=self.get_timeout
        )
