# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.forbidden_error import ForbiddenError
from ..errors.internal_server_error import InternalServerError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.language_identification_response import LanguageIdentificationResponse
from ..types.numerals_format import NumeralsFormat
from ..types.spoken_form_numerals_format import SpokenFormNumeralsFormat
from ..types.translate_mode import TranslateMode
from ..types.translate_model import TranslateModel
from ..types.translate_source_language import TranslateSourceLanguage
from ..types.translate_speaker_gender import TranslateSpeakerGender
from ..types.translate_target_language import TranslateTargetLanguage
from ..types.translation_response import TranslationResponse
from ..types.translatiterate_target_language import TranslatiterateTargetLanguage
from ..types.transliterate_mode import TransliterateMode
from ..types.transliterate_source_language import TransliterateSourceLanguage
from ..types.transliteration_response import TransliterationResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawTextClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def translate(
        self,
        *,
        input: str,
        source_language_code: TranslateSourceLanguage,
        target_language_code: TranslateTargetLanguage,
        speaker_gender: typing.Optional[TranslateSpeakerGender] = OMIT,
        mode: typing.Optional[TranslateMode] = OMIT,
        model: typing.Optional[TranslateModel] = OMIT,
        enable_preprocessing: typing.Optional[bool] = OMIT,
        output_script: typing.Optional[TransliterateMode] = OMIT,
        numerals_format: typing.Optional[NumeralsFormat] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TranslationResponse]:
        """
        **Translation** converts text from one language to another while preserving its meaning.
        For Example: **'मैं ऑफिस जा रहा हूँ'** translates to **'I am going to the office'** in English, where the script and language change, but the original meaning remains the same.

        Available languages:
        - **`bn-IN`**: Bengali
        - **`en-IN`**: English
        - **`gu-IN`**: Gujarati
        - **`hi-IN`**: Hindi
        - **`kn-IN`**: Kannada
        - **`ml-IN`**: Malayalam
        - **`mr-IN`**: Marathi
        - **`od-IN`**: Odia
        - **`pa-IN`**: Punjabi
        - **`ta-IN`**: Tamil
        - **`te-IN`**: Telugu

        ### Newly added languages:
        - **`as-IN`**: Assamese
        - **`brx-IN`**: Bodo
        - **`doi-IN`**: Dogri
        - **`kok-IN`**: Konkani
        - **`ks-IN`**: Kashmiri
        - **`mai-IN`**: Maithili
        - **`mni-IN`**: Manipuri (Meiteilon)
        - **`ne-IN`**: Nepali
        - **`sa-IN`**: Sanskrit
        - **`sat-IN`**: Santali
        - **`sd-IN`**: Sindhi
        - **`ur-IN`**: Urdu

        For hands-on practice, you can explore the notebook tutorial on [Translate API Tutorial](https://github.com/sarvamai/sarvam-ai-cookbook/blob/main/notebooks/translate/Translate_API_Tutorial.ipynb).

        Parameters
        ----------
        input : str
            The text you want to translate is the input text that will be processed by the translation model. The maximum is 1000 characters for Mayura:v1 and 2000 characters for Sarvam-Translate:v1.

        source_language_code : TranslateSourceLanguage
            Source language code for translation input.

            **mayura:v1 Languages:** Bengali, English, Gujarati, Hindi, Kannada, Malayalam, Marathi, Odia, Punjabi, Tamil, Telugu

            **sarvam-translate:v1 Languages:** All mayura:v1 languages and Assamese, Bodo, Dogri, Konkani, Kashmiri, Maithili, Manipuri, Nepali, Sanskrit, Santali, Sindhi, Urdu

            **Note:** mayura:v1 supports automatic language detection using 'auto' as the source language code.


        target_language_code : TranslateTargetLanguage
            The language code of the translated text. This specifies the target language for translation.

            **mayura:v1 Languages:** Bengali, English, Gujarati, Hindi, Kannada, Malayalam, Marathi, Odia, Punjabi, Tamil, Telugu

            **sarvam-translate:v1 Languages:** All mayura:v1 and Assamese, Bodo, Dogri, Konkani, Kashmiri, Maithili, Manipuri, Nepali, Sanskrit, Santali, Sindhi, Urdu


        speaker_gender : typing.Optional[TranslateSpeakerGender]
            Please specify the gender of the speaker for better translations.

        mode : typing.Optional[TranslateMode]
            Specifies the tone or style of the translation.

            **Model Support:**
            - **mayura:v1**: Supports formal, classic-colloquial, and modern-colloquial modes
            - **sarvam-translate:v1**: Only formal mode is supported

            **Default:** formal

        model : typing.Optional[TranslateModel]
            Specifies the translation model to use.
            - mayura:v1: Supports 12 languages with all modes, output scripts, and automatic language detection.
            - sarvam-translate:v1: Supports all 22 scheduled languages of India, formal mode only.

        enable_preprocessing : typing.Optional[bool]
            This will enable custom preprocessing of the input text which can result in better translations.
             Recommendation- You can switch on whenever there is some complex text with difficult vocabulary and sentences, for which you want simple translations that people can understand.

        output_script : typing.Optional[TransliterateMode]
            **output_script**: This is an optional parameter which controls the transliteration style applied to the output text.

            **Transliteration**: Converting text from one script to another while preserving pronunciation.

            For mayura:v1 - We support transliteration with four options:
            - **`null`**(default): No transliteration applied.
            - **`roman`**: Transliteration in Romanized script.
            - **`fully-native`**: Transliteration in the native script with formal style.
            - **`spoken-form-in-native`**: Transliteration in the native script with spoken style.

            For sarvam-translate:v1 - Transliteration is not supported.
            ### Example:
            English: Your EMI of Rs. 3000 is pending.
            Default modern translation: आपका Rs. 3000 का EMI pending है (when `null` is passed).

            With postprocessing enabled:
            - **roman output**: aapka Rs. 3000 ka EMI pending hai.

        numerals_format : typing.Optional[NumeralsFormat]
            `numerals_format` is an optional parameter with two options (supported for both mayura:v1 and sarvam-translate:v1):

            - **`international`** (default): Uses regular numerals (0-9).
            - **`native`**: Uses language-specific native numerals.

            ### Example:
            - If `international` format is selected, we use regular numerals (0-9). For example: `मेरा phone number है: 9840950950`.
            - If `native` format is selected, we use language-specific native numerals, like: `मेरा phone number है: ९८४०९५०९५०`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TranslationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "translate",
            base_url=self._client_wrapper.get_environment().base,
            method="POST",
            json={
                "input": input,
                "source_language_code": source_language_code,
                "target_language_code": target_language_code,
                "speaker_gender": speaker_gender,
                "mode": mode,
                "model": model,
                "enable_preprocessing": enable_preprocessing,
                "output_script": output_script,
                "numerals_format": numerals_format,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TranslationResponse,
                    parse_obj_as(
                        type_=TranslationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def identify_language(
        self, *, input: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[LanguageIdentificationResponse]:
        """
        Identifies the language (e.g., en-IN, hi-IN) and script (e.g., Latin, Devanagari) of the input text, supporting multiple languages.

        Parameters
        ----------
        input : str
            The text input for language and script identification. Max Input Limit is 1000 characters

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[LanguageIdentificationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "text-lid",
            base_url=self._client_wrapper.get_environment().base,
            method="POST",
            json={
                "input": input,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    LanguageIdentificationResponse,
                    parse_obj_as(
                        type_=LanguageIdentificationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def transliterate(
        self,
        *,
        input: str,
        source_language_code: TransliterateSourceLanguage,
        target_language_code: TranslatiterateTargetLanguage,
        numerals_format: typing.Optional[NumeralsFormat] = OMIT,
        spoken_form_numerals_language: typing.Optional[SpokenFormNumeralsFormat] = OMIT,
        spoken_form: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TransliterationResponse]:
        """
        **Transliteration** converts text from one script to another while preserving the original pronunciation. For example, **'नमस्ते'** becomes **'namaste'** in English, and **'how are you'** can be written as **'हाउ आर यू'** in Devanagari. This process ensures that the sound of the original text remains intact, even when written in a different script.

        Transliteration is useful when you want to represent words phonetically across different writing systems, such as converting **'मैं ऑफिस जा रहा हूँ'** to **'main office ja raha hun'** in English letters.

        **Translation**, on the other hand, converts text from one language to another while preserving the meaning rather than pronunciation. For example, **'मैं ऑफिस जा रहा हूँ'** translates to **'I am going to the office'** in English, changing both the script and the language while conveying the intended message.
        ### Examples of **Transliteration**:
        - **'Good morning'** becomes **'गुड मॉर्निंग'** in Hindi, where the pronunciation is preserved but the meaning is not translated.
        - **'सुप्रभात'** becomes **'suprabhat'** in English.

        Available languages:
        - **`en-IN`**: English
        - **`hi-IN`**: Hindi
        - **`bn-IN`**: Bengali
        - **`gu-IN`**: Gujarati
        - **`kn-IN`**: Kannada
        - **`ml-IN`**: Malayalam
        - **`mr-IN`**: Marathi
        - **`od-IN`**: Odia
        - **`pa-IN`**: Punjabi
        - **`ta-IN`**: Tamil
        - **`te-IN`**: Telugu

        For hands-on practice, you can explore the notebook tutorial on [Transliterate API Tutorial](https://github.com/sarvamai/sarvam-ai-cookbook/blob/main/notebooks/transliterate/Transliterate_API_Tutorial.ipynb).

        Parameters
        ----------
        input : str
            The text you want to transliterate.

        source_language_code : TransliterateSourceLanguage
            The language code of the input text. This specifies the source language for transliteration.



             Note:  The source language should either be an Indic language or English. As we supports both Indic-to-English and English-to-Indic transliteration.


        target_language_code : TranslatiterateTargetLanguage
            The language code of the transliteration text. This specifies the target language for transliteration.



             Note:The target language should either be an Indic language or English. As we supports both Indic-to-English and English-to-Indic transliteration.


        numerals_format : typing.Optional[NumeralsFormat]
            `numerals_format` is an optional parameter with two options:

            - **`international`** (default): Uses regular numerals (0-9).
            - **`native`**: Uses language-specific native numerals.

            ### Example:
            - If `international` format is selected, we use regular numerals (0-9). For example: `मेरा phone number है: 9840950950`.
            - If `native` format is selected, we use language-specific native numerals, like: `मेरा phone number है: ९८४०९५०९५०`.

        spoken_form_numerals_language : typing.Optional[SpokenFormNumeralsFormat]
            `spoken_form_numerals_language` is an optional parameter with two options and only works when spoken_form is true:

            - **`english`** : Numbers in the text will be spoken in English.
            - **`native(default)`**: Numbers in the text will be spoken in the native language.

            ### Examples:
            - **Input:** "मेरे पास ₹200 है"
              - If `english` format is selected: "मेरे पास टू हन्डर्ड रूपीस है"
              - If `native` format is selected: "मेरे पास दो सौ रुपये है"


        spoken_form : typing.Optional[bool]
              - Default: `False`
              - Converts text into a natural spoken form when `True`.
              - **Note:** No effect if output language is `en-IN`.

            ### Example:
            - **Input:** `मुझे कल 9:30am को appointment है`
              - **Output:** `मुझे कल सुबह साढ़े नौ बजे को अपॉइंटमेंट है`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TransliterationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "transliterate",
            base_url=self._client_wrapper.get_environment().base,
            method="POST",
            json={
                "input": input,
                "source_language_code": source_language_code,
                "target_language_code": target_language_code,
                "numerals_format": numerals_format,
                "spoken_form_numerals_language": spoken_form_numerals_language,
                "spoken_form": spoken_form,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TransliterationResponse,
                    parse_obj_as(
                        type_=TransliterationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawTextClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def translate(
        self,
        *,
        input: str,
        source_language_code: TranslateSourceLanguage,
        target_language_code: TranslateTargetLanguage,
        speaker_gender: typing.Optional[TranslateSpeakerGender] = OMIT,
        mode: typing.Optional[TranslateMode] = OMIT,
        model: typing.Optional[TranslateModel] = OMIT,
        enable_preprocessing: typing.Optional[bool] = OMIT,
        output_script: typing.Optional[TransliterateMode] = OMIT,
        numerals_format: typing.Optional[NumeralsFormat] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TranslationResponse]:
        """
        **Translation** converts text from one language to another while preserving its meaning.
        For Example: **'मैं ऑफिस जा रहा हूँ'** translates to **'I am going to the office'** in English, where the script and language change, but the original meaning remains the same.

        Available languages:
        - **`bn-IN`**: Bengali
        - **`en-IN`**: English
        - **`gu-IN`**: Gujarati
        - **`hi-IN`**: Hindi
        - **`kn-IN`**: Kannada
        - **`ml-IN`**: Malayalam
        - **`mr-IN`**: Marathi
        - **`od-IN`**: Odia
        - **`pa-IN`**: Punjabi
        - **`ta-IN`**: Tamil
        - **`te-IN`**: Telugu

        ### Newly added languages:
        - **`as-IN`**: Assamese
        - **`brx-IN`**: Bodo
        - **`doi-IN`**: Dogri
        - **`kok-IN`**: Konkani
        - **`ks-IN`**: Kashmiri
        - **`mai-IN`**: Maithili
        - **`mni-IN`**: Manipuri (Meiteilon)
        - **`ne-IN`**: Nepali
        - **`sa-IN`**: Sanskrit
        - **`sat-IN`**: Santali
        - **`sd-IN`**: Sindhi
        - **`ur-IN`**: Urdu

        For hands-on practice, you can explore the notebook tutorial on [Translate API Tutorial](https://github.com/sarvamai/sarvam-ai-cookbook/blob/main/notebooks/translate/Translate_API_Tutorial.ipynb).

        Parameters
        ----------
        input : str
            The text you want to translate is the input text that will be processed by the translation model. The maximum is 1000 characters for Mayura:v1 and 2000 characters for Sarvam-Translate:v1.

        source_language_code : TranslateSourceLanguage
            Source language code for translation input.

            **mayura:v1 Languages:** Bengali, English, Gujarati, Hindi, Kannada, Malayalam, Marathi, Odia, Punjabi, Tamil, Telugu

            **sarvam-translate:v1 Languages:** All mayura:v1 languages and Assamese, Bodo, Dogri, Konkani, Kashmiri, Maithili, Manipuri, Nepali, Sanskrit, Santali, Sindhi, Urdu

            **Note:** mayura:v1 supports automatic language detection using 'auto' as the source language code.


        target_language_code : TranslateTargetLanguage
            The language code of the translated text. This specifies the target language for translation.

            **mayura:v1 Languages:** Bengali, English, Gujarati, Hindi, Kannada, Malayalam, Marathi, Odia, Punjabi, Tamil, Telugu

            **sarvam-translate:v1 Languages:** All mayura:v1 and Assamese, Bodo, Dogri, Konkani, Kashmiri, Maithili, Manipuri, Nepali, Sanskrit, Santali, Sindhi, Urdu


        speaker_gender : typing.Optional[TranslateSpeakerGender]
            Please specify the gender of the speaker for better translations.

        mode : typing.Optional[TranslateMode]
            Specifies the tone or style of the translation.

            **Model Support:**
            - **mayura:v1**: Supports formal, classic-colloquial, and modern-colloquial modes
            - **sarvam-translate:v1**: Only formal mode is supported

            **Default:** formal

        model : typing.Optional[TranslateModel]
            Specifies the translation model to use.
            - mayura:v1: Supports 12 languages with all modes, output scripts, and automatic language detection.
            - sarvam-translate:v1: Supports all 22 scheduled languages of India, formal mode only.

        enable_preprocessing : typing.Optional[bool]
            This will enable custom preprocessing of the input text which can result in better translations.
             Recommendation- You can switch on whenever there is some complex text with difficult vocabulary and sentences, for which you want simple translations that people can understand.

        output_script : typing.Optional[TransliterateMode]
            **output_script**: This is an optional parameter which controls the transliteration style applied to the output text.

            **Transliteration**: Converting text from one script to another while preserving pronunciation.

            For mayura:v1 - We support transliteration with four options:
            - **`null`**(default): No transliteration applied.
            - **`roman`**: Transliteration in Romanized script.
            - **`fully-native`**: Transliteration in the native script with formal style.
            - **`spoken-form-in-native`**: Transliteration in the native script with spoken style.

            For sarvam-translate:v1 - Transliteration is not supported.
            ### Example:
            English: Your EMI of Rs. 3000 is pending.
            Default modern translation: आपका Rs. 3000 का EMI pending है (when `null` is passed).

            With postprocessing enabled:
            - **roman output**: aapka Rs. 3000 ka EMI pending hai.

        numerals_format : typing.Optional[NumeralsFormat]
            `numerals_format` is an optional parameter with two options (supported for both mayura:v1 and sarvam-translate:v1):

            - **`international`** (default): Uses regular numerals (0-9).
            - **`native`**: Uses language-specific native numerals.

            ### Example:
            - If `international` format is selected, we use regular numerals (0-9). For example: `मेरा phone number है: 9840950950`.
            - If `native` format is selected, we use language-specific native numerals, like: `मेरा phone number है: ९८४०९५०९५०`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TranslationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "translate",
            base_url=self._client_wrapper.get_environment().base,
            method="POST",
            json={
                "input": input,
                "source_language_code": source_language_code,
                "target_language_code": target_language_code,
                "speaker_gender": speaker_gender,
                "mode": mode,
                "model": model,
                "enable_preprocessing": enable_preprocessing,
                "output_script": output_script,
                "numerals_format": numerals_format,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TranslationResponse,
                    parse_obj_as(
                        type_=TranslationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def identify_language(
        self, *, input: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[LanguageIdentificationResponse]:
        """
        Identifies the language (e.g., en-IN, hi-IN) and script (e.g., Latin, Devanagari) of the input text, supporting multiple languages.

        Parameters
        ----------
        input : str
            The text input for language and script identification. Max Input Limit is 1000 characters

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[LanguageIdentificationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "text-lid",
            base_url=self._client_wrapper.get_environment().base,
            method="POST",
            json={
                "input": input,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    LanguageIdentificationResponse,
                    parse_obj_as(
                        type_=LanguageIdentificationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def transliterate(
        self,
        *,
        input: str,
        source_language_code: TransliterateSourceLanguage,
        target_language_code: TranslatiterateTargetLanguage,
        numerals_format: typing.Optional[NumeralsFormat] = OMIT,
        spoken_form_numerals_language: typing.Optional[SpokenFormNumeralsFormat] = OMIT,
        spoken_form: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TransliterationResponse]:
        """
        **Transliteration** converts text from one script to another while preserving the original pronunciation. For example, **'नमस्ते'** becomes **'namaste'** in English, and **'how are you'** can be written as **'हाउ आर यू'** in Devanagari. This process ensures that the sound of the original text remains intact, even when written in a different script.

        Transliteration is useful when you want to represent words phonetically across different writing systems, such as converting **'मैं ऑफिस जा रहा हूँ'** to **'main office ja raha hun'** in English letters.

        **Translation**, on the other hand, converts text from one language to another while preserving the meaning rather than pronunciation. For example, **'मैं ऑफिस जा रहा हूँ'** translates to **'I am going to the office'** in English, changing both the script and the language while conveying the intended message.
        ### Examples of **Transliteration**:
        - **'Good morning'** becomes **'गुड मॉर्निंग'** in Hindi, where the pronunciation is preserved but the meaning is not translated.
        - **'सुप्रभात'** becomes **'suprabhat'** in English.

        Available languages:
        - **`en-IN`**: English
        - **`hi-IN`**: Hindi
        - **`bn-IN`**: Bengali
        - **`gu-IN`**: Gujarati
        - **`kn-IN`**: Kannada
        - **`ml-IN`**: Malayalam
        - **`mr-IN`**: Marathi
        - **`od-IN`**: Odia
        - **`pa-IN`**: Punjabi
        - **`ta-IN`**: Tamil
        - **`te-IN`**: Telugu

        For hands-on practice, you can explore the notebook tutorial on [Transliterate API Tutorial](https://github.com/sarvamai/sarvam-ai-cookbook/blob/main/notebooks/transliterate/Transliterate_API_Tutorial.ipynb).

        Parameters
        ----------
        input : str
            The text you want to transliterate.

        source_language_code : TransliterateSourceLanguage
            The language code of the input text. This specifies the source language for transliteration.



             Note:  The source language should either be an Indic language or English. As we supports both Indic-to-English and English-to-Indic transliteration.


        target_language_code : TranslatiterateTargetLanguage
            The language code of the transliteration text. This specifies the target language for transliteration.



             Note:The target language should either be an Indic language or English. As we supports both Indic-to-English and English-to-Indic transliteration.


        numerals_format : typing.Optional[NumeralsFormat]
            `numerals_format` is an optional parameter with two options:

            - **`international`** (default): Uses regular numerals (0-9).
            - **`native`**: Uses language-specific native numerals.

            ### Example:
            - If `international` format is selected, we use regular numerals (0-9). For example: `मेरा phone number है: 9840950950`.
            - If `native` format is selected, we use language-specific native numerals, like: `मेरा phone number है: ९८४०९५०९५०`.

        spoken_form_numerals_language : typing.Optional[SpokenFormNumeralsFormat]
            `spoken_form_numerals_language` is an optional parameter with two options and only works when spoken_form is true:

            - **`english`** : Numbers in the text will be spoken in English.
            - **`native(default)`**: Numbers in the text will be spoken in the native language.

            ### Examples:
            - **Input:** "मेरे पास ₹200 है"
              - If `english` format is selected: "मेरे पास टू हन्डर्ड रूपीस है"
              - If `native` format is selected: "मेरे पास दो सौ रुपये है"


        spoken_form : typing.Optional[bool]
              - Default: `False`
              - Converts text into a natural spoken form when `True`.
              - **Note:** No effect if output language is `en-IN`.

            ### Example:
            - **Input:** `मुझे कल 9:30am को appointment है`
              - **Output:** `मुझे कल सुबह साढ़े नौ बजे को अपॉइंटमेंट है`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TransliterationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "transliterate",
            base_url=self._client_wrapper.get_environment().base,
            method="POST",
            json={
                "input": input,
                "source_language_code": source_language_code,
                "target_language_code": target_language_code,
                "numerals_format": numerals_format,
                "spoken_form_numerals_language": spoken_form_numerals_language,
                "spoken_form": spoken_form,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TransliterationResponse,
                    parse_obj_as(
                        type_=TransliterationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
