# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AudioData(UniversalBaseModel):
    data: str = pydantic.Field()
    """
    Base64 encoded audio data
    """

    sample_rate: int = pydantic.Field()
    """
    Audio sample rate in Hz (16kHz preferred, 8kHz least preferred)
    """

    encoding: typing.Literal["audio/wav"] = pydantic.Field(default="audio/wav")
    """
    Audio encoding format
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
