# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ConfigMessage(UniversalBaseModel):
    type: typing.Literal["config"] = pydantic.Field(default="config")
    """
    Message type identifier for configuration
    """

    prompt: typing.Optional[str] = pydantic.Field(default=None)
    """
    Prompt for ASR model to improve transcription accuracy
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
