# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .events_data_signal_type import EventsDataSignalType


class EventsData(UniversalBaseModel):
    """
    VAD events are sent when vad_signals=true. Fields may vary by event type.
    """

    event_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Type of event
    """

    timestamp: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Event timestamp
    """

    signal_type: typing.Optional[EventsDataSignalType] = pydantic.Field(default=None)
    """
    VAD signal type
    """

    occured_at: typing.Optional[float] = pydantic.Field(default=None)
    """
    Epoch timestamp when the event occurred
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
