# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .job_state import JobState
from .storage_container_type import StorageContainerType
from .task_detail_v_1 import TaskDetailV1


class JobStatusV1Response(UniversalBaseModel):
    job_state: JobState = pydantic.Field()
    """
    Job State
    """

    created_at: str = pydantic.Field()
    """
    Created At
    """

    updated_at: str = pydantic.Field()
    """
    Updated At
    """

    job_id: str = pydantic.Field()
    """
    Job Id
    """

    total_files: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total Files
    """

    successful_files_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Success Count
    """

    failed_files_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Failed Count
    """

    storage_container_type: StorageContainerType = pydantic.Field()
    """
    Storage Container Type
    """

    error_message: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error Message
    """

    job_details: typing.Optional[typing.List[TaskDetailV1]] = pydantic.Field(default=None)
    """
    Job details at file level.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
