
# JijBench: An Experiment and Benchmark Management Library for Mathematical Optimization

[![PyPI version shields.io](https://img.shields.io/pypi/v/jijbench.svg)](https://pypi.python.org/pypi/jijbench/)
[![PyPI pyversions](https://img.shields.io/pypi/pyversions/jijbench.svg)](https://pypi.python.org/pypi/jijbench/)
[![PyPI implementation](https://img.shields.io/pypi/implementation/jijbench.svg)](https://pypi.python.org/pypi/jijbench/)
[![PyPI format](https://img.shields.io/pypi/format/jijbench.svg)](https://pypi.python.org/pypi/jijbench/)
[![PyPI license](https://img.shields.io/pypi/l/jijbench.svg)](https://pypi.python.org/pypi/jijbench/)
[![PyPI download month](https://img.shields.io/pypi/dm/jijbench.svg)](https://pypi.python.org/pypi/jijbench/)
[![Downloads](https://pepy.tech/badge/jijbench)](https://pepy.tech/project/jijbench)

[![Python Test](https://github.com/Jij-Inc/JijBench/actions/workflows/python-test.yml/badge.svg)](https://github.com/Jij-Inc/JijBench/actions/workflows/python-test.yml)
[![CodeQL](https://github.com/Jij-Inc/JijBench/actions/workflows/github-code-scanning/codeql/badge.svg)](https://github.com/Jij-Inc/JijBench/actions/workflows/github-code-scanning/codeql)
[![Upload Python Package](https://github.com/Jij-Inc/JijBench/actions/workflows/python-publish.yml/badge.svg)](https://github.com/Jij-Inc/JijBench/actions/workflows/python-publish.yml)
[![codecov](https://codecov.io/gh/Jij-Inc/JijBench/branch/main/graph/badge.svg?token=pfEmtaSP8Z)](https://codecov.io/gh/Jij-Inc/JijBench)


JijBench is a Python library designed for developers working on research and development or proof-of-concept experiments using mathematical optimization. Positioned similarly to mlflow in the machine learning field, JijBench provides features such as saving optimization results, automatically computing benchmark metrics, and offering visualization tools for the results.

Primarily supporting Ising optimization problems, JijBench plans to extend its support to a wide range of optimization problems, such as MIP solvers, in the future.

## Installation
JijBench can be easily installed using pip.

``` shell
pip install jijbench
```

## Documentation and Support

Documentation: https://jij-inc.github.io/JijBench/

Tutorials will be provided in the future. Stay tuned!


## How to Contribute

See [CONTRIBUITING.md](CONTRIBUTING.md) 

---

Copyright (c) 2023 Jij Inc.

