import re

import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

with open("./clarifai/__init__.py", encoding="utf-8") as f:
    content = f.read()
_search_version = re.search(r'__version__\s*=\s*[\'"]([^\'"]*)[\'"]', content)
assert _search_version
version = _search_version.group(1)

with open("requirements.txt", "r", encoding="utf-8") as fh:
    install_requires = fh.read().split('\n')
    # remove ruff as it doesn't work with setup.py
    install_requires = [req for req in install_requires if not req.startswith('ruff')]

if install_requires and install_requires[-1] == '':
    # Remove the last empty line
    install_requires = install_requires[:-1]

packages = setuptools.find_namespace_packages(include=["clarifai*"])

setuptools.setup(
    name="clarifai",
    version=f"{version}",
    author="Clarifai",
    author_email="support@clarifai.com",
    description="Clarifai Python SDK",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/Clarifai/clarifai-python",
    packages=packages,
    classifiers=[
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: Implementation :: CPython",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
    ],
    license="Apache 2.0",
    python_requires='>=3.8',
    install_requires=install_requires,
    extras_require={
        'all': ["pycocotools>=2.0.7"],
    },
    entry_points={
        "console_scripts": [
            "clarifai = clarifai.cli.base:cli",
        ],
    },
    include_package_data=True,
)
