# Contributing to Wakis

First off, thanks for taking the time to contribute! ❤️ For a complete guide on how to contribute with new features, report bugs or open issues, please refer to our [CONTRIBUTING.md](https://github.com/ImpedanCEI/wakis/blob/main/CONTRIBUTING.md). Find a quick snippet below:

> ### Legal Notice <!-- omit in toc -->
> When contributing to this project, you must agree that you have authored 100% of the content, that you have the necessary rights to the content and that the content you contribute may be provided under the project licence.

### Your first code contribution
Wakis is an open-source code developed and maintained at CERN. It aims to be a platform for the electromagnetism and accelerator community to use and improve with each individual expertise. Therefore, if you as a user feel you can improve the code, we would be very grateful to review and accept pull-requests!

We recommend the following workflow:
* Create a fork: https://github.com/ImpedanCEI/wakis/fork 
* Commit your contributions to your fork
* If any feature is added, it needs a test! Inside the `tests/` folder, add a reproducible piece of code that can check the correct functionality of your feature. 
* Run your new `test_00x_your feature.py` together with all other Wakis tests by doing `pytest -v -s`. All tests must be passing before your feature can be merged!
* Last step is to open a pull request on https://github.com/ImpedanCEI/wakis/pulls. The maintainer will review and approve your contribution and it will be available for the next package relase 🎉

# Code of Conduct - Wakis

## Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to make participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, sex characteristics, gender identity and expression,
level of experience, education, socio-economic status, nationality, personal
appearance, race, religion, or sexual identity and orientation.

## Our Standards

Examples of behaviour that contributes to a positive environment for our
community include:

* Demonstrating empathy and kindness toward other people
* Being respectful of differing opinions, viewpoints, and experiences
* Giving and gracefully accepting constructive feedback
* Accepting responsibility and apologising to those affected by our mistakes,
  and learning from the experience
* Focusing on what is best not just for us as individuals, but for the
  overall community

Examples of unacceptable behaviour include:

* The use of sexualised language or imagery, and sexual attention or advances
* Trolling, insulting or derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or email
  address, without their explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

## Our Responsibilities

Project maintainers are responsible for clarifying and enforcing our standards of
acceptable behaviour and will take appropriate and fair corrective action in
response to any instances of unacceptable behaviour.

Project maintainers have the right and responsibility to remove, edit, or reject
comments, commits, code, wiki edits, issues, and other contributions that are
not aligned to this Code of Conduct, or to ban
temporarily or permanently any contributor for other behaviours that they deem
inappropriate, threatening, offensive, or harmful.

## Scope

This Code of Conduct applies within all community spaces, and also applies when
an individual is officially representing the community in public spaces.
Examples of representing our community include using an official e-mail address,
posting via an official social media account, or acting as an appointed
representative at an online or offline event.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behaviour may be
reported to the community leaders responsible for enforcement at <>.
All complaints will be reviewed and investigated promptly and fairly.

All community leaders are obligated to respect the privacy and security of the
reporter of any incident.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant](https://contributor-covenant.org/), version
[1.4](https://www.contributor-covenant.org/version/1/4/code-of-conduct/code_of_conduct.md) and
[2.0](https://www.contributor-covenant.org/version/2/0/code_of_conduct/code_of_conduct.md),
and was generated by [contributing.md](https://contributing.md/generator).
