# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CopyToRemoteArgs', 'CopyToRemote']

@pulumi.input_type
class CopyToRemoteArgs:
    def __init__(__self__, *,
                 connection: pulumi.Input['ConnectionArgs'],
                 remote_path: pulumi.Input[_builtins.str],
                 source: pulumi.Input[Union[pulumi.Asset, pulumi.Archive]],
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None):
        """
        The set of arguments for constructing a CopyToRemote resource.
        :param pulumi.Input['ConnectionArgs'] connection: The parameters with which to connect to the remote host.
        :param pulumi.Input[_builtins.str] remote_path: The destination path on the remote host. The last element of the path will be created if it doesn't exist but it's an error when additional elements don't exist. When the remote path is an existing directory, the source file or directory will be copied into that directory. When the source is a file and the remote path is an existing file, that file will be overwritten. When the source is a directory and the remote path an existing file, the copy will fail.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: An [asset or an archive](https://www.pulumi.com/docs/concepts/assets-archives/) to upload as the source of the copy. It must be path-based, i.e., be a `FileAsset` or a `FileArchive`. The item will be copied as-is; archives like .tgz will not be unpacked. Directories are copied recursively, overwriting existing files.
        :param pulumi.Input[Sequence[Any]] triggers: Trigger replacements on changes to this input.
        """
        pulumi.set(__self__, "connection", connection)
        pulumi.set(__self__, "remote_path", remote_path)
        pulumi.set(__self__, "source", source)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Input['ConnectionArgs']:
        """
        The parameters with which to connect to the remote host.
        """
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: pulumi.Input['ConnectionArgs']):
        pulumi.set(self, "connection", value)

    @_builtins.property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> pulumi.Input[_builtins.str]:
        """
        The destination path on the remote host. The last element of the path will be created if it doesn't exist but it's an error when additional elements don't exist. When the remote path is an existing directory, the source file or directory will be copied into that directory. When the source is a file and the remote path is an existing file, that file will be overwritten. When the source is a directory and the remote path an existing file, the copy will fail.
        """
        return pulumi.get(self, "remote_path")

    @remote_path.setter
    def remote_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remote_path", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]:
        """
        An [asset or an archive](https://www.pulumi.com/docs/concepts/assets-archives/) to upload as the source of the copy. It must be path-based, i.e., be a `FileAsset` or a `FileArchive`. The item will be copied as-is; archives like .tgz will not be unpacked. Directories are copied recursively, overwriting existing files.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        Trigger replacements on changes to this input.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "triggers", value)


@pulumi.type_token("command:remote:CopyToRemote")
class CopyToRemote(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection: Optional[pulumi.Input[Union['ConnectionArgs', 'ConnectionArgsDict']]] = None,
                 remote_path: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 __props__=None):
        """
        Copy an Asset or Archive to a remote host.

        ## Example usage

        This example copies a local directory to a remote host via SSH. For brevity, the remote server is assumed to exist, but it could also be provisioned in the same Pulumi program.

        ```python
        import pulumi
        import pulumi_command as command

        config = pulumi.Config()

        server_public_ip = config.require("serverPublicIp")
        user_name = config.require("userName")
        private_key = config.require("privateKey")
        payload = config.require("payload")
        dest_dir = config.require("destDir")

        archive = pulumi.FileArchive(payload)

        # The configuration of our SSH connection to the instance.
        conn = command.remote.ConnectionArgs(
            host = server_public_ip,
            user = user_name,
            private_key = private_key,
        )

        # Copy the files to the remote.
        copy = command.remote.CopyToRemote("copy",
            connection=conn,
            source=archive,
            remote_path=dest_dir)

        # Verify that the expected files were copied to the remote.
        # We want to run this after each copy, i.e., when something changed,
        # so we use the asset to be copied as a trigger.
        find = command.remote.Command("find",
            connection=conn,
            create=f"find {dest_dir}/{payload} | sort",
            triggers=[archive],
            opts = pulumi.ResourceOptions(depends_on=[copy]))

        pulumi.export("remoteContents", find.stdout)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionArgs', 'ConnectionArgsDict']] connection: The parameters with which to connect to the remote host.
        :param pulumi.Input[_builtins.str] remote_path: The destination path on the remote host. The last element of the path will be created if it doesn't exist but it's an error when additional elements don't exist. When the remote path is an existing directory, the source file or directory will be copied into that directory. When the source is a file and the remote path is an existing file, that file will be overwritten. When the source is a directory and the remote path an existing file, the copy will fail.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: An [asset or an archive](https://www.pulumi.com/docs/concepts/assets-archives/) to upload as the source of the copy. It must be path-based, i.e., be a `FileAsset` or a `FileArchive`. The item will be copied as-is; archives like .tgz will not be unpacked. Directories are copied recursively, overwriting existing files.
        :param pulumi.Input[Sequence[Any]] triggers: Trigger replacements on changes to this input.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CopyToRemoteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Copy an Asset or Archive to a remote host.

        ## Example usage

        This example copies a local directory to a remote host via SSH. For brevity, the remote server is assumed to exist, but it could also be provisioned in the same Pulumi program.

        ```python
        import pulumi
        import pulumi_command as command

        config = pulumi.Config()

        server_public_ip = config.require("serverPublicIp")
        user_name = config.require("userName")
        private_key = config.require("privateKey")
        payload = config.require("payload")
        dest_dir = config.require("destDir")

        archive = pulumi.FileArchive(payload)

        # The configuration of our SSH connection to the instance.
        conn = command.remote.ConnectionArgs(
            host = server_public_ip,
            user = user_name,
            private_key = private_key,
        )

        # Copy the files to the remote.
        copy = command.remote.CopyToRemote("copy",
            connection=conn,
            source=archive,
            remote_path=dest_dir)

        # Verify that the expected files were copied to the remote.
        # We want to run this after each copy, i.e., when something changed,
        # so we use the asset to be copied as a trigger.
        find = command.remote.Command("find",
            connection=conn,
            create=f"find {dest_dir}/{payload} | sort",
            triggers=[archive],
            opts = pulumi.ResourceOptions(depends_on=[copy]))

        pulumi.export("remoteContents", find.stdout)
        ```

        :param str resource_name: The name of the resource.
        :param CopyToRemoteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CopyToRemoteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection: Optional[pulumi.Input[Union['ConnectionArgs', 'ConnectionArgsDict']]] = None,
                 remote_path: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CopyToRemoteArgs.__new__(CopyToRemoteArgs)

            if connection is None and not opts.urn:
                raise TypeError("Missing required property 'connection'")
            __props__.__dict__["connection"] = None if connection is None else pulumi.Output.secret(connection)
            if remote_path is None and not opts.urn:
                raise TypeError("Missing required property 'remote_path'")
            __props__.__dict__["remote_path"] = remote_path
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["triggers"] = triggers
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["connection"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["triggers[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(CopyToRemote, __self__).__init__(
            'command:remote:CopyToRemote',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CopyToRemote':
        """
        Get an existing CopyToRemote resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CopyToRemoteArgs.__new__(CopyToRemoteArgs)

        __props__.__dict__["connection"] = None
        __props__.__dict__["remote_path"] = None
        __props__.__dict__["source"] = None
        __props__.__dict__["triggers"] = None
        return CopyToRemote(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Output['outputs.Connection']:
        """
        The parameters with which to connect to the remote host.
        """
        return pulumi.get(self, "connection")

    @_builtins.property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> pulumi.Output[_builtins.str]:
        """
        The destination path on the remote host. The last element of the path will be created if it doesn't exist but it's an error when additional elements don't exist. When the remote path is an existing directory, the source file or directory will be copied into that directory. When the source is a file and the remote path is an existing file, that file will be overwritten. When the source is a directory and the remote path an existing file, the copy will fail.
        """
        return pulumi.get(self, "remote_path")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Union[pulumi.Asset, pulumi.Archive]]:
        """
        An [asset or an archive](https://www.pulumi.com/docs/concepts/assets-archives/) to upload as the source of the copy. It must be path-based, i.e., be a `FileAsset` or a `FileArchive`. The item will be copied as-is; archives like .tgz will not be unpacked. Directories are copied recursively, overwriting existing files.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Sequence[Any]]]:
        """
        Trigger replacements on changes to this input.
        """
        return pulumi.get(self, "triggers")

