# coding: utf-8

from __future__ import annotations

import re  # noqa: F401
from datetime import date, datetime  # noqa: F401
from typing import Any, Dict, List, Optional  # noqa: F401

from fastapi_camelcase import CamelModel  # noqa: F401
from pydantic import AnyUrl, Field

from telus_bulk.models.tmf_645.characteristic import Characteristic
from telus_bulk.models.tmf_645.feature import Feature
from telus_bulk.models.tmf_645.note import Note
from telus_bulk.models.tmf_645.related_entity_ref_or_value import (
    RelatedEntityRefOrValue,
)
from telus_bulk.models.tmf_645.related_party import RelatedParty
from telus_bulk.models.tmf_645.related_place_ref_or_value import RelatedPlaceRefOrValue
from telus_bulk.models.tmf_645.related_service_order_item import RelatedServiceOrderItem
from telus_bulk.models.tmf_645.resource_ref import ResourceRef
from telus_bulk.models.tmf_645.service_ref_or_value import ServiceRefOrValue
from telus_bulk.models.tmf_645.service_ref_or_value import ServiceRelationship
from telus_bulk.models.tmf_645.service_specification_ref import ServiceSpecificationRef
from telus_bulk.models.tmf_645.service_state_type import ServiceStateType


class Service(CamelModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    Service - a model defined in OpenAPI

        id: The id of this Service [Optional].
        href: The href of this Service [Optional].
        category: The category of this Service [Optional].
        description: The description of this Service [Optional].
        end_date: The end_date of this Service [Optional].
        has_started: The has_started of this Service [Optional].
        is_bundle: The is_bundle of this Service [Optional].
        is_service_enabled: The is_service_enabled of this Service [Optional].
        is_stateful: The is_stateful of this Service [Optional].
        name: The name of this Service [Optional].
        service_date: The service_date of this Service [Optional].
        service_type: The service_type of this Service [Optional].
        start_date: The start_date of this Service [Optional].
        start_mode: The start_mode of this Service [Optional].
        feature: The feature of this Service [Optional].
        note: The note of this Service [Optional].
        place: The place of this Service [Optional].
        related_entity: The related_entity of this Service [Optional].
        related_party: The related_party of this Service [Optional].
        service_characteristic: The service_characteristic of this Service [Optional].
        service_order_item: The service_order_item of this Service [Optional].
        service_relationship: The service_relationship of this Service [Optional].
        service_specification: The service_specification of this Service [Optional].
        state: The state of this Service [Optional].
        supporting_resource: The supporting_resource of this Service [Optional].
        supporting_service: The supporting_service of this Service [Optional].
        base_type: The base_type of this Service [Optional].
        schema_location: The schema_location of this Service [Optional].
        type: The type of this Service [Optional].
    """

    id: Optional[str] = None
    href: Optional[str] = None
    category: Optional[str] = None
    description: Optional[str] = None
    end_date: Optional[datetime] = None
    has_started: Optional[bool] = None
    is_bundle: Optional[bool] = None
    is_service_enabled: Optional[bool] = None
    is_stateful: Optional[bool] = None
    name: Optional[str] = None
    service_date: Optional[str] = None
    service_type: Optional[str] = None
    start_date: Optional[datetime] = None
    start_mode: Optional[str] = None
    feature: Optional[List[Feature]] = None
    note: Optional[List[Note]] = None
    place: Optional[List[RelatedPlaceRefOrValue]] = None
    related_entity: Optional[List[RelatedEntityRefOrValue]] = None
    related_party: Optional[List[RelatedParty]] = None
    service_characteristic: Optional[List[Characteristic]] = None
    service_order_item: Optional[List[RelatedServiceOrderItem]] = None
    service_relationship: Optional[List[ServiceRelationship]] = None
    service_specification: Optional[ServiceSpecificationRef] = None
    state: Optional[ServiceStateType] = None
    supporting_resource: Optional[List[ResourceRef]] = None
    supporting_service: Optional[List[ServiceRefOrValue]] = None
    base_type: Optional[str] = None
    schema_location: Optional[AnyUrl] = None
    type: Optional[str] = Field(default=None, alias="@type")


Service.update_forward_refs()
