# Information for Potential Contributors

First off, thanks for taking the time to contribute!

This software is maintained by the [Ring-Moon Systems Node](https://pds-rings.seti.org) of NASA's [Planetary Data System](https://pds.nasa.gov). All types of contributions are encouraged and valued. See the [Table of Contents](#table-of-contents) for different ways to help and details about how this project handles them; please read the relevant section before making your contribution.

> If you like the project, but just don't have time to contribute, there are other easy ways to support the project and show your appreciation!
> - Star the project on GitHub
> - Post about it on social media
> - Refer to this project in your project's README
> - Mention the project at conferences and workshops and tell your friends/colleagues
> - Cite the project in your papers and posters


## Table of Contents

- [Code of Conduct](#code-of-conduct)
- [I Have a Question](#i-have-a-question)
- [I Want to Report a Bug](#i-want-to-report-a-bug)
- [I Want to Suggest an Enhancement](#i-want-to-suggest-an-enhancement)
- [I Want To Contribute Code](#i-want-to-contribute-code)


## Code of Conduct

This project and everyone participating in it are governed by the
[Code of Conduct](CODE_OF_CONDUCT.md).
By participating, you are expected to uphold this code. Please report unacceptable behavior
to <matt@seti.org>.


## I Have a Question

> Please read the available documentation!

Before asking a question, you can search for existing [issues](https://github.com/SETI/rms-oops/issues) that might help you. If you find a suitable issue and still need clarification, you can write your question in that issue.

If you can't find an appropriate issue and still want to ask a question, we recommend the following:

- Open an [issue](https://github.com/SETI/rms-oops/issues/new).
- Provide as much context and detail as you can.
- Provide project and platform versions (operating system, Python version, etc.), depending on what seems relevant.

We will try to answer your question as soon as possible.


## I Want to Report a Bug

### Before Submitting a Bug Report

A good bug report shouldn't leave others needing to chase you for more information. Therefore, we ask you to investigate carefully and collect all appropriate information in advance.

- Make sure that you are using the latest version of this software and its supporting packages.
- Make sure that you have read the documentation.
- Determine that your bug really is a bug and not an error in your code or a misunderstanding in how to use our software.
- To see if other users have experienced (and potentially solved) the same issue you're having, check if there is an existing issue for your bug or error in the [bug tracker](https://github.com/SETI/rms-oops/issues).
- Collect information about the bug:
  - Stack trace (Traceback)
  - OS and version (Windows/Linux/macOS), processor (x86/ARM/M1), Python version
  - Detailed information on how to reproduce the bug, including function parameters, command line arguments, and input given/output received.

### How Do I Submit a Good Bug Report?

> You must never report security-related issues, vulnerabilities, or bugs that include sensitive information to the issue tracker or elsewhere in public. Instead, sensitive bugs must be sent by email to <matt@seti.org>.

We use GitHub Issues to track bugs and errors. If you run into an issue with the project:

- Open an [issue](https://github.com/SETI/rms-oops/issues/new) with a **clear and descriptive title**. Please label the issue as `A-Bug` with no other labels.
- Explain the **behavior you would expect** and the **behavior observed**.
- Provide as much context as possible and describe the **detailed steps** that someone can follow to reproduce the problem. This usually includes providing your code; for a good bug report you should isolate the problem and create a reduced test case.
- Provide other information collected in the previous section, such as the operating system and language version.

Once it's filed:

- The project team will label the issue accordingly.
- A team member will try to reproduce the issue with your provided steps. If there are no steps given and no obvious way to reproduce the issue, the team will ask you for clarification.
- If the team is able to reproduce the issue, it will be appropriately labeled and either assigned to a team member to fix, or left unassigned to be [implemented by someone else](#i-want-to-contribute-code).


## I Want to Suggest an Enhancement

This section guides you through submitting an enhancement, **including completely new features and minor improvements to existing functionality**.

### Before Submitting an Enhancement

- Make sure that you are using the latest version of this software and its supporting packages.
- Make sure that you have read the documentation to see if the desired functionality is already provided.
- Perform a [search](https://github.com/SETI/rms-oops/issues) to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.
- Find out whether your idea fits within the scope and aims of the project. It's up to you to make a strong case to convince the project's developers of the merits of this feature. Keep in mind that we want features that will be useful to the majority of our users and not just a small subset. If you're just targeting a minority of users, consider writing an add-on/plugin library.

### How Do I Submit a Good Enhancement Suggestion?

We use GitHub Issues to track enhancement requests. If you want to suggest an enhancement:

- Open an [issue](https://github.com/SETI/rms-oops/issues/new) with a **clear and descriptive title**. Please label the issue as `A-Enhancement` with no other labels.
- Provide a **detailed** description of the suggested enhancement.
- **Explain why this enhancement would be useful** to most users.


## I Want To Contribute Code

> ### Legal Notice 
> When contributing to this project, you must agree that you have authored 100% of the content, that you have the necessary rights to the content, and that the content you contribute may be provided under the project license.

We welcome all code contributions, including bug fixes, new features, and improvements to documentation.

- All suggested changes must be submitted using GitHub's "Pull Request" functionality.
- All code changes must include appropriate new or updated tests to verify the changes made.
- Existing documentation, including function- and file-level docstrings, must be updated as necessary, and new features fully described.
- Code style must conform to that of the existing code; for Python this is generally a variant of PEP8 and PEP257.

All submissions will be reviewed in detail by a project team member and changes may be suggested. Once the reviewer approves the changes, they will be merged into the main project branch and made a permanent part of the software. Your efforts to improve the software are greatly appreciated!
