################################################################################
# oops/constants.py
################################################################################

import numpy as np

# Handy constants

C = 299792.458                  # speed of light in km/s
C_INVERSE = 1. / C

RPD = np.pi / 180.              # radians per degree
DPR = 180. / np.pi              # degrees per radian
SPR = 3600. * 180. / np.pi      # arcseconds per radian
RPS = np.pi / (3600. * 180.)    # radians per arcsecond
SPD = 86400.                    # seconds per day

AU = 149597870.7                # Astronomical Unit in km

PI = np.pi
TWOPI = 2. * np.pi
HALFPI = np.pi / 2.

################################################################################

