# MGost
Библиотека позволяет пользоваться преимуществами MGost конвертера локально

## Установка

Для начала необходимо получить API токен на [официальном сайте конвертера](https://articha.ru/auth/tokens/)

После создания ключа можно запустить библиотеку напрямую через [uv](https://docs.astral.sh/uv/) (**Рекомендуется**):
```bash
uvx mgost version
```

Или через pip:
```bash
python3.13 -m pip install mgost
python3.13 -m mgost version
```

## Запуск
Для инициализации папки для проекта используйте `mgost init`. Первый запуск запросит API токен:
```console
$ uvx mgost init
API ключ не найден ни в переменных среды, ни в .env.
Введите код вручную или внесите его в вышеперечисленные источники
ARTICHAAPI_TOKEN=
```

После ввода токена, нужно выбрать проект:
```console
ARTICHAAPI_TOKEN= ...
Текущий проект недействительный в облаке. Воспользуйтесь mgost init для инициализации проекта
Создать новый проект или синхронизировать существующий?
0. Создать новый проект
1. "Проект1"
2. "Проект2"
Действие: 
```

В зависимости от выбора, могут быть другие вопросы инициализации

## Синхронизация
После инициализации проект можно синхронизировать и выполнять рендер. Команда `mgost render` синхронизирует проект с облаком и выполнит рендер.

```console
$ mgost render
Текущий проект: Проект1
Синхронизация ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 3/3
Начинаю рендер
Рендер успешно завершён
↓ output.docx ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 100% 0:00:00
```

В случае проблем с выполнением рендера, лог будет отображаться в консоли:
```console
$ mgost render
Текущий проект: Проект1
Синхронизация ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 3/3
Начинаю рендер
Рендер успешно завершён
    ИНФО: grafana-logo-3.png не существует. Изображение (рисунок) пропущен
↓ output.docx ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 100% 0:00:00
```