# Generated by Django 3.2.15 on 2022-10-07 11:16

from django.db import migrations, models

from common.migrations.helpers import PostgresOnlyRunSQL


class Migration(migrations.Migration):

    atomic = False

    dependencies = [
        ("task_processor", "0004_recreate_task_indexes"),
    ]

    operations = [
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.RemoveIndex(
                    model_name="task",
                    name="incomplete_tasks_idx",
                ),
                migrations.AddIndex(
                    model_name="task",
                    index=models.Index(
                        condition=models.Q(
                            ("completed", False), ("num_failures__lt", 3)
                        ),
                        fields=["scheduled_for"],
                        name="incomplete_tasks_idx",
                    ),
                ),
            ],
            database_operations=[
                PostgresOnlyRunSQL(
                    'DROP INDEX CONCURRENTLY "incomplete_tasks_idx";',
                    reverse_sql='CREATE INDEX CONCURRENTLY "incomplete_tasks_idx" ON "task_processor_task" ("num_failures", "scheduled_for") WHERE NOT "completed";',
                ),
                PostgresOnlyRunSQL(
                    'CREATE INDEX CONCURRENTLY "incomplete_tasks_idx" ON "task_processor_task" ("scheduled_for") WHERE (NOT "completed" and "num_failures" < 3);',
                    reverse_sql='DROP INDEX CONCURRENTLY "incomplete_tasks_idx";',
                ),
            ],
        )
    ]
