"""Added service table [0701da9951a0].

Revision ID: 0701da9951a0
Revises: 0.56.1
Create Date: 2024-03-25 12:24:32.928543

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op
from sqlalchemy.engine.reflection import Inspector

# revision identifiers, used by Alembic.
revision = "0701da9951a0"
down_revision = "0.56.1"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # If the tables already exist, skip this migration.
    conn = op.get_bind()
    inspector = Inspector.from_engine(conn.engine)
    tables = inspector.get_table_names()
    if "service" in tables:
        return

    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "service",
        sa.Column(
            "workspace_id", sqlmodel.sql.sqltypes.GUID(), nullable=False
        ),
        sa.Column("user_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column("service_source", sa.TEXT(), nullable=True),
        sa.Column("service_type", sa.TEXT(), nullable=False),
        sa.Column("type", sa.TEXT(), nullable=False),
        sa.Column("flavor", sa.TEXT(), nullable=False),
        sa.Column("admin_state", sa.TEXT(), nullable=True),
        sa.Column("state", sa.TEXT(), nullable=True),
        sa.Column("prediction_url", sa.TEXT(), nullable=True),
        sa.Column("health_check_url", sa.TEXT(), nullable=True),
        sa.Column("pipeline_name", sa.TEXT(), nullable=True),
        sa.Column("pipeline_step_name", sa.TEXT(), nullable=True),
        sa.Column(
            "model_version_id", sqlmodel.sql.sqltypes.GUID(), nullable=True
        ),
        sa.Column(
            "pipeline_run_id", sqlmodel.sql.sqltypes.GUID(), nullable=True
        ),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("labels", sa.LargeBinary(), nullable=True),
        sa.Column("config", sa.LargeBinary(), nullable=False),
        sa.Column("status", sa.LargeBinary(), nullable=True),
        sa.Column("endpoint", sa.LargeBinary(), nullable=True),
        sa.ForeignKeyConstraint(
            ["model_version_id"],
            ["model_version.id"],
            name="fk_service_model_version_id_model_version",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["pipeline_run_id"],
            ["pipeline_run.id"],
            name="fk_service_pipeline_run_id_pipeline_run",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            name="fk_service_user_id_user",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["workspace_id"],
            ["workspace.id"],
            name="fk_service_workspace_id_workspace",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("service")
    # ### end Alembic commands ###
