"""Pipeline Versioning [e65aa6708ff7].

Revision ID: e65aa6708ff7
Revises: bea8a6ce3015
Create Date: 2023-01-27 10:33:30.974448

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "e65aa6708ff7"
down_revision = "bea8a6ce3015"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "version", sqlmodel.sql.sqltypes.AutoString(), nullable=True
            )
        )
        batch_op.add_column(
            sa.Column(
                "version_hash",
                sqlmodel.sql.sqltypes.AutoString(),
                nullable=True,
            )
        )
    op.execute("UPDATE pipeline SET version = 'UNVERSIONED'")
    op.execute("UPDATE pipeline SET version_hash = 'UNVERSIONED'")
    with op.batch_alter_table("pipeline", schema=None) as batch_op:
        batch_op.alter_column(
            "version",
            nullable=False,
            existing_type=sqlmodel.sql.sqltypes.AutoString(),
        )
        batch_op.alter_column(
            "version_hash",
            nullable=False,
            existing_type=sqlmodel.sql.sqltypes.AutoString(),
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline", schema=None) as batch_op:
        batch_op.drop_column("version_hash")
        batch_op.drop_column("version")

    # ### end Alembic commands ###
