// This file is auto-generated by scripts/model_generator.py

#![allow(non_snake_case)]

use chrono::{DateTime, Utc};
use pyo3::prelude::*;
use pyo3::types::{PyDateTime, PyDict, PyList};
use rbox::masterdb::models::*;
use std::collections::HashMap;

use super::iter::{PyItemsIter, PyObjectIter, PyStrIter};
use super::traits::{FromPy, IntoPy};

#[pyclass(name = "AgentRegistry", unsendable, get_all, set_all)]
pub struct PyAgentRegistry {
    pub registry_id: String,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub id_1: Option<String>,
    pub id_2: Option<String>,
    pub int_1: Option<i32>,
    pub int_2: Option<i32>,
    pub str_1: Option<String>,
    pub str_2: Option<String>,
    pub date_1: Option<String>,
    pub date_2: Option<String>,
    pub text_1: Option<String>,
    pub text_2: Option<String>,
}

impl IntoPy<PyAgentRegistry> for AgentRegistry {
    fn into_py(self, py: Python) -> PyResult<PyAgentRegistry> {
        let model = PyAgentRegistry {
            registry_id: self.registry_id,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            id_1: self.id_1,
            id_2: self.id_2,
            int_1: self.int_1,
            int_2: self.int_2,
            str_1: self.str_1,
            str_2: self.str_2,
            date_1: self.date_1,
            date_2: self.date_2,
            text_1: self.text_1,
            text_2: self.text_2,
        };
        Ok(model)
    }
}

impl FromPy<PyAgentRegistry> for AgentRegistry {
    fn from_py(py: Python, model: PyRef<'_, PyAgentRegistry>) -> Self {
        Self {
            registry_id: model.registry_id.clone(),
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            id_1: model.id_1.clone(),
            id_2: model.id_2.clone(),
            int_1: model.int_1,
            int_2: model.int_2,
            str_1: model.str_1.clone(),
            str_2: model.str_2.clone(),
            date_1: model.date_1.clone(),
            date_2: model.date_2.clone(),
            text_1: model.text_1.clone(),
            text_2: model.text_2.clone(),
        }
    }
}

impl PyAgentRegistry {
    fn field_names() -> Vec<String> {
        vec![
            "registry_id".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "id_1".to_string(),
            "id_2".to_string(),
            "int_1".to_string(),
            "int_2".to_string(),
            "str_1".to_string(),
            "str_2".to_string(),
            "date_1".to_string(),
            "date_2".to_string(),
            "text_1".to_string(),
            "text_2".to_string(),
        ]
    }
}

#[pymethods]
impl PyAgentRegistry {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "registry_id" => Ok(self.registry_id.clone().into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "id_1" => Ok(self.id_1.clone().into_pyobject(py)?.into()),
            "id_2" => Ok(self.id_2.clone().into_pyobject(py)?.into()),
            "int_1" => Ok(self.int_1.into_pyobject(py)?.into()),
            "int_2" => Ok(self.int_2.into_pyobject(py)?.into()),
            "str_1" => Ok(self.str_1.clone().into_pyobject(py)?.into()),
            "str_2" => Ok(self.str_2.clone().into_pyobject(py)?.into()),
            "date_1" => Ok(self.date_1.clone().into_pyobject(py)?.into()),
            "date_2" => Ok(self.date_2.clone().into_pyobject(py)?.into()),
            "text_1" => Ok(self.text_1.clone().into_pyobject(py)?.into()),
            "text_2" => Ok(self.text_2.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "registry_id" => self.registry_id = value.extract::<String>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "id_1" => self.id_1 = value.extract::<Option<String>>(py)?,
            "id_2" => self.id_2 = value.extract::<Option<String>>(py)?,
            "int_1" => self.int_1 = value.extract::<Option<i32>>(py)?,
            "int_2" => self.int_2 = value.extract::<Option<i32>>(py)?,
            "str_1" => self.str_1 = value.extract::<Option<String>>(py)?,
            "str_2" => self.str_2 = value.extract::<Option<String>>(py)?,
            "date_1" => self.date_1 = value.extract::<Option<String>>(py)?,
            "date_2" => self.date_2 = value.extract::<Option<String>>(py)?,
            "text_1" => self.text_1 = value.extract::<Option<String>>(py)?,
            "text_2" => self.text_2 = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("AgentRegistry(registry_id: {})", self.registry_id,))
    }
}

#[pyclass(name = "CloudAgentRegistry", unsendable, get_all, set_all)]
pub struct PyCloudAgentRegistry {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub int_1: Option<i32>,
    pub int_2: Option<i32>,
    pub str_1: Option<String>,
    pub str_2: Option<String>,
    pub date_1: Option<String>,
    pub date_2: Option<String>,
    pub text_1: Option<String>,
    pub text_2: Option<String>,
}

impl IntoPy<PyCloudAgentRegistry> for CloudAgentRegistry {
    fn into_py(self, py: Python) -> PyResult<PyCloudAgentRegistry> {
        let model = PyCloudAgentRegistry {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            int_1: self.int_1,
            int_2: self.int_2,
            str_1: self.str_1,
            str_2: self.str_2,
            date_1: self.date_1,
            date_2: self.date_2,
            text_1: self.text_1,
            text_2: self.text_2,
        };
        Ok(model)
    }
}

impl FromPy<PyCloudAgentRegistry> for CloudAgentRegistry {
    fn from_py(py: Python, model: PyRef<'_, PyCloudAgentRegistry>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            int_1: model.int_1,
            int_2: model.int_2,
            str_1: model.str_1.clone(),
            str_2: model.str_2.clone(),
            date_1: model.date_1.clone(),
            date_2: model.date_2.clone(),
            text_1: model.text_1.clone(),
            text_2: model.text_2.clone(),
        }
    }
}

impl PyCloudAgentRegistry {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "int_1".to_string(),
            "int_2".to_string(),
            "str_1".to_string(),
            "str_2".to_string(),
            "date_1".to_string(),
            "date_2".to_string(),
            "text_1".to_string(),
            "text_2".to_string(),
        ]
    }
}

#[pymethods]
impl PyCloudAgentRegistry {
    fn __len__(&self) -> usize {
        18
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "int_1" => Ok(self.int_1.into_pyobject(py)?.into()),
            "int_2" => Ok(self.int_2.into_pyobject(py)?.into()),
            "str_1" => Ok(self.str_1.clone().into_pyobject(py)?.into()),
            "str_2" => Ok(self.str_2.clone().into_pyobject(py)?.into()),
            "date_1" => Ok(self.date_1.clone().into_pyobject(py)?.into()),
            "date_2" => Ok(self.date_2.clone().into_pyobject(py)?.into()),
            "text_1" => Ok(self.text_1.clone().into_pyobject(py)?.into()),
            "text_2" => Ok(self.text_2.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "int_1" => self.int_1 = value.extract::<Option<i32>>(py)?,
            "int_2" => self.int_2 = value.extract::<Option<i32>>(py)?,
            "str_1" => self.str_1 = value.extract::<Option<String>>(py)?,
            "str_2" => self.str_2 = value.extract::<Option<String>>(py)?,
            "date_1" => self.date_1 = value.extract::<Option<String>>(py)?,
            "date_2" => self.date_2 = value.extract::<Option<String>>(py)?,
            "text_1" => self.text_1 = value.extract::<Option<String>>(py)?,
            "text_2" => self.text_2 = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("CloudAgentRegistry(ID: {})", self.ID,))
    }
}

#[pyclass(name = "ContentActiveCensor", unsendable, get_all, set_all)]
pub struct PyContentActiveCensor {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub ContentID: Option<String>,
    pub ActiveCensors: Option<String>,
    pub rb_activecensor_count: Option<i32>,
}

impl IntoPy<PyContentActiveCensor> for ContentActiveCensor {
    fn into_py(self, py: Python) -> PyResult<PyContentActiveCensor> {
        let model = PyContentActiveCensor {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            ContentID: self.ContentID,
            ActiveCensors: self.ActiveCensors,
            rb_activecensor_count: self.rb_activecensor_count,
        };
        Ok(model)
    }
}

impl FromPy<PyContentActiveCensor> for ContentActiveCensor {
    fn from_py(py: Python, model: PyRef<'_, PyContentActiveCensor>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            ContentID: model.ContentID.clone(),
            ActiveCensors: model.ActiveCensors.clone(),
            rb_activecensor_count: model.rb_activecensor_count,
        }
    }
}

impl PyContentActiveCensor {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "ContentID".to_string(),
            "ActiveCensors".to_string(),
            "rb_activecensor_count".to_string(),
        ]
    }
}

#[pymethods]
impl PyContentActiveCensor {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "ActiveCensors" => Ok(self.ActiveCensors.clone().into_pyobject(py)?.into()),
            "rb_activecensor_count" => Ok(self.rb_activecensor_count.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "ActiveCensors" => self.ActiveCensors = value.extract::<Option<String>>(py)?,
            "rb_activecensor_count" => {
                self.rb_activecensor_count = value.extract::<Option<i32>>(py)?
            }
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("ContentActiveCensor(ID: {})", self.ID,))
    }
}

#[pyclass(name = "ContentCue", unsendable, get_all, set_all)]
pub struct PyContentCue {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub ContentID: Option<String>,
    pub Cues: Option<String>,
    pub rb_cue_count: Option<i32>,
}

impl IntoPy<PyContentCue> for ContentCue {
    fn into_py(self, py: Python) -> PyResult<PyContentCue> {
        let model = PyContentCue {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            ContentID: self.ContentID,
            Cues: self.Cues,
            rb_cue_count: self.rb_cue_count,
        };
        Ok(model)
    }
}

impl FromPy<PyContentCue> for ContentCue {
    fn from_py(py: Python, model: PyRef<'_, PyContentCue>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            ContentID: model.ContentID.clone(),
            Cues: model.Cues.clone(),
            rb_cue_count: model.rb_cue_count,
        }
    }
}

impl PyContentCue {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "ContentID".to_string(),
            "Cues".to_string(),
            "rb_cue_count".to_string(),
        ]
    }
}

#[pymethods]
impl PyContentCue {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "Cues" => Ok(self.Cues.clone().into_pyobject(py)?.into()),
            "rb_cue_count" => Ok(self.rb_cue_count.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "Cues" => self.Cues = value.extract::<Option<String>>(py)?,
            "rb_cue_count" => self.rb_cue_count = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("ContentCue(ID: {})", self.ID,))
    }
}

#[pyclass(name = "ContentFile", unsendable, get_all, set_all)]
pub struct PyContentFile {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub ContentID: Option<String>,
    pub Path: Option<String>,
    pub Hash: Option<String>,
    pub Size: Option<i32>,
    pub rb_local_path: Option<String>,
    pub rb_insync_hash: Option<String>,
    pub rb_insync_local_usn: Option<i32>,
    pub rb_file_hash_dirty: Option<i32>,
    pub rb_local_file_status: Option<i32>,
    pub rb_in_progress: Option<i32>,
    pub rb_process_type: Option<i32>,
    pub rb_temp_path: Option<String>,
    pub rb_priority: Option<i32>,
    pub rb_file_size_dirty: Option<i32>,
}

impl IntoPy<PyContentFile> for ContentFile {
    fn into_py(self, py: Python) -> PyResult<PyContentFile> {
        let model = PyContentFile {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            ContentID: self.ContentID,
            Path: self.Path,
            Hash: self.Hash,
            Size: self.Size,
            rb_local_path: self.rb_local_path,
            rb_insync_hash: self.rb_insync_hash,
            rb_insync_local_usn: self.rb_insync_local_usn,
            rb_file_hash_dirty: self.rb_file_hash_dirty,
            rb_local_file_status: self.rb_local_file_status,
            rb_in_progress: self.rb_in_progress,
            rb_process_type: self.rb_process_type,
            rb_temp_path: self.rb_temp_path,
            rb_priority: self.rb_priority,
            rb_file_size_dirty: self.rb_file_size_dirty,
        };
        Ok(model)
    }
}

impl FromPy<PyContentFile> for ContentFile {
    fn from_py(py: Python, model: PyRef<'_, PyContentFile>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            ContentID: model.ContentID.clone(),
            Path: model.Path.clone(),
            Hash: model.Hash.clone(),
            Size: model.Size,
            rb_local_path: model.rb_local_path.clone(),
            rb_insync_hash: model.rb_insync_hash.clone(),
            rb_insync_local_usn: model.rb_insync_local_usn,
            rb_file_hash_dirty: model.rb_file_hash_dirty,
            rb_local_file_status: model.rb_local_file_status,
            rb_in_progress: model.rb_in_progress,
            rb_process_type: model.rb_process_type,
            rb_temp_path: model.rb_temp_path.clone(),
            rb_priority: model.rb_priority,
            rb_file_size_dirty: model.rb_file_size_dirty,
        }
    }
}

impl PyContentFile {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "ContentID".to_string(),
            "Path".to_string(),
            "Hash".to_string(),
            "Size".to_string(),
            "rb_local_path".to_string(),
            "rb_insync_hash".to_string(),
            "rb_insync_local_usn".to_string(),
            "rb_file_hash_dirty".to_string(),
            "rb_local_file_status".to_string(),
            "rb_in_progress".to_string(),
            "rb_process_type".to_string(),
            "rb_temp_path".to_string(),
            "rb_priority".to_string(),
            "rb_file_size_dirty".to_string(),
        ]
    }
}

#[pymethods]
impl PyContentFile {
    fn __len__(&self) -> usize {
        24
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "Path" => Ok(self.Path.clone().into_pyobject(py)?.into()),
            "Hash" => Ok(self.Hash.clone().into_pyobject(py)?.into()),
            "Size" => Ok(self.Size.into_pyobject(py)?.into()),
            "rb_local_path" => Ok(self.rb_local_path.clone().into_pyobject(py)?.into()),
            "rb_insync_hash" => Ok(self.rb_insync_hash.clone().into_pyobject(py)?.into()),
            "rb_insync_local_usn" => Ok(self.rb_insync_local_usn.into_pyobject(py)?.into()),
            "rb_file_hash_dirty" => Ok(self.rb_file_hash_dirty.into_pyobject(py)?.into()),
            "rb_local_file_status" => Ok(self.rb_local_file_status.into_pyobject(py)?.into()),
            "rb_in_progress" => Ok(self.rb_in_progress.into_pyobject(py)?.into()),
            "rb_process_type" => Ok(self.rb_process_type.into_pyobject(py)?.into()),
            "rb_temp_path" => Ok(self.rb_temp_path.clone().into_pyobject(py)?.into()),
            "rb_priority" => Ok(self.rb_priority.into_pyobject(py)?.into()),
            "rb_file_size_dirty" => Ok(self.rb_file_size_dirty.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "Path" => self.Path = value.extract::<Option<String>>(py)?,
            "Hash" => self.Hash = value.extract::<Option<String>>(py)?,
            "Size" => self.Size = value.extract::<Option<i32>>(py)?,
            "rb_local_path" => self.rb_local_path = value.extract::<Option<String>>(py)?,
            "rb_insync_hash" => self.rb_insync_hash = value.extract::<Option<String>>(py)?,
            "rb_insync_local_usn" => self.rb_insync_local_usn = value.extract::<Option<i32>>(py)?,
            "rb_file_hash_dirty" => self.rb_file_hash_dirty = value.extract::<Option<i32>>(py)?,
            "rb_local_file_status" => {
                self.rb_local_file_status = value.extract::<Option<i32>>(py)?
            }
            "rb_in_progress" => self.rb_in_progress = value.extract::<Option<i32>>(py)?,
            "rb_process_type" => self.rb_process_type = value.extract::<Option<i32>>(py)?,
            "rb_temp_path" => self.rb_temp_path = value.extract::<Option<String>>(py)?,
            "rb_priority" => self.rb_priority = value.extract::<Option<i32>>(py)?,
            "rb_file_size_dirty" => self.rb_file_size_dirty = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("ContentFile(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdActiveCensor", unsendable, get_all, set_all)]
pub struct PyDjmdActiveCensor {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub ContentID: Option<String>,
    pub InMsec: Option<i32>,
    pub OutMsec: Option<i32>,
    pub Info: Option<i32>,
    pub ParameterList: Option<String>,
    pub ContentUUID: Option<String>,
}

impl IntoPy<PyDjmdActiveCensor> for DjmdActiveCensor {
    fn into_py(self, py: Python) -> PyResult<PyDjmdActiveCensor> {
        let model = PyDjmdActiveCensor {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            ContentID: self.ContentID,
            InMsec: self.InMsec,
            OutMsec: self.OutMsec,
            Info: self.Info,
            ParameterList: self.ParameterList,
            ContentUUID: self.ContentUUID,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdActiveCensor> for DjmdActiveCensor {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdActiveCensor>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            ContentID: model.ContentID.clone(),
            InMsec: model.InMsec,
            OutMsec: model.OutMsec,
            Info: model.Info,
            ParameterList: model.ParameterList.clone(),
            ContentUUID: model.ContentUUID.clone(),
        }
    }
}

impl PyDjmdActiveCensor {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "ContentID".to_string(),
            "InMsec".to_string(),
            "OutMsec".to_string(),
            "Info".to_string(),
            "ParameterList".to_string(),
            "ContentUUID".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdActiveCensor {
    fn __len__(&self) -> usize {
        16
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "InMsec" => Ok(self.InMsec.into_pyobject(py)?.into()),
            "OutMsec" => Ok(self.OutMsec.into_pyobject(py)?.into()),
            "Info" => Ok(self.Info.into_pyobject(py)?.into()),
            "ParameterList" => Ok(self.ParameterList.clone().into_pyobject(py)?.into()),
            "ContentUUID" => Ok(self.ContentUUID.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "InMsec" => self.InMsec = value.extract::<Option<i32>>(py)?,
            "OutMsec" => self.OutMsec = value.extract::<Option<i32>>(py)?,
            "Info" => self.Info = value.extract::<Option<i32>>(py)?,
            "ParameterList" => self.ParameterList = value.extract::<Option<String>>(py)?,
            "ContentUUID" => self.ContentUUID = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdActiveCensor(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdAlbum", unsendable, get_all, set_all)]
pub struct PyDjmdAlbum {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Name: Option<String>,
    pub AlbumArtistID: Option<String>,
    pub ImagePath: Option<String>,
    pub Compilation: Option<i32>,
    pub SearchStr: Option<String>,
}

impl IntoPy<PyDjmdAlbum> for DjmdAlbum {
    fn into_py(self, py: Python) -> PyResult<PyDjmdAlbum> {
        let model = PyDjmdAlbum {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Name: self.Name,
            AlbumArtistID: self.AlbumArtistID,
            ImagePath: self.ImagePath,
            Compilation: self.Compilation,
            SearchStr: self.SearchStr,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdAlbum> for DjmdAlbum {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdAlbum>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Name: model.Name.clone(),
            AlbumArtistID: model.AlbumArtistID.clone(),
            ImagePath: model.ImagePath.clone(),
            Compilation: model.Compilation,
            SearchStr: model.SearchStr.clone(),
        }
    }
}

impl PyDjmdAlbum {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Name".to_string(),
            "AlbumArtistID".to_string(),
            "ImagePath".to_string(),
            "Compilation".to_string(),
            "SearchStr".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdAlbum {
    fn __len__(&self) -> usize {
        15
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            "AlbumArtistID" => Ok(self.AlbumArtistID.clone().into_pyobject(py)?.into()),
            "ImagePath" => Ok(self.ImagePath.clone().into_pyobject(py)?.into()),
            "Compilation" => Ok(self.Compilation.into_pyobject(py)?.into()),
            "SearchStr" => Ok(self.SearchStr.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            "AlbumArtistID" => self.AlbumArtistID = value.extract::<Option<String>>(py)?,
            "ImagePath" => self.ImagePath = value.extract::<Option<String>>(py)?,
            "Compilation" => self.Compilation = value.extract::<Option<i32>>(py)?,
            "SearchStr" => self.SearchStr = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdAlbum(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdArtist", unsendable, get_all, set_all)]
pub struct PyDjmdArtist {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Name: Option<String>,
    pub SearchStr: Option<String>,
}

impl IntoPy<PyDjmdArtist> for DjmdArtist {
    fn into_py(self, py: Python) -> PyResult<PyDjmdArtist> {
        let model = PyDjmdArtist {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Name: self.Name,
            SearchStr: self.SearchStr,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdArtist> for DjmdArtist {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdArtist>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Name: model.Name.clone(),
            SearchStr: model.SearchStr.clone(),
        }
    }
}

impl PyDjmdArtist {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Name".to_string(),
            "SearchStr".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdArtist {
    fn __len__(&self) -> usize {
        12
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            "SearchStr" => Ok(self.SearchStr.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            "SearchStr" => self.SearchStr = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdArtist(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdCategory", unsendable, get_all, set_all)]
pub struct PyDjmdCategory {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub MenuItemID: Option<String>,
    pub Seq: Option<i32>,
    pub Disable: Option<i32>,
    pub InfoOrder: Option<i32>,
}

impl IntoPy<PyDjmdCategory> for DjmdCategory {
    fn into_py(self, py: Python) -> PyResult<PyDjmdCategory> {
        let model = PyDjmdCategory {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            MenuItemID: self.MenuItemID,
            Seq: self.Seq,
            Disable: self.Disable,
            InfoOrder: self.InfoOrder,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdCategory> for DjmdCategory {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdCategory>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            MenuItemID: model.MenuItemID.clone(),
            Seq: model.Seq,
            Disable: model.Disable,
            InfoOrder: model.InfoOrder,
        }
    }
}

impl PyDjmdCategory {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "MenuItemID".to_string(),
            "Seq".to_string(),
            "Disable".to_string(),
            "InfoOrder".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdCategory {
    fn __len__(&self) -> usize {
        14
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "MenuItemID" => Ok(self.MenuItemID.clone().into_pyobject(py)?.into()),
            "Seq" => Ok(self.Seq.into_pyobject(py)?.into()),
            "Disable" => Ok(self.Disable.into_pyobject(py)?.into()),
            "InfoOrder" => Ok(self.InfoOrder.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "MenuItemID" => self.MenuItemID = value.extract::<Option<String>>(py)?,
            "Seq" => self.Seq = value.extract::<Option<i32>>(py)?,
            "Disable" => self.Disable = value.extract::<Option<i32>>(py)?,
            "InfoOrder" => self.InfoOrder = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdCategory(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdColor", unsendable, get_all, set_all)]
pub struct PyDjmdColor {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub ColorCode: Option<String>,
    pub SortKey: Option<i32>,
    pub Commnt: Option<String>,
}

impl IntoPy<PyDjmdColor> for DjmdColor {
    fn into_py(self, py: Python) -> PyResult<PyDjmdColor> {
        let model = PyDjmdColor {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            ColorCode: self.ColorCode,
            SortKey: self.SortKey,
            Commnt: self.Commnt,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdColor> for DjmdColor {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdColor>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            ColorCode: model.ColorCode.clone(),
            SortKey: model.SortKey,
            Commnt: model.Commnt.clone(),
        }
    }
}

impl PyDjmdColor {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "ColorCode".to_string(),
            "SortKey".to_string(),
            "Commnt".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdColor {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "ColorCode" => Ok(self.ColorCode.clone().into_pyobject(py)?.into()),
            "SortKey" => Ok(self.SortKey.into_pyobject(py)?.into()),
            "Commnt" => Ok(self.Commnt.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "ColorCode" => self.ColorCode = value.extract::<Option<String>>(py)?,
            "SortKey" => self.SortKey = value.extract::<Option<i32>>(py)?,
            "Commnt" => self.Commnt = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdColor(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdContent", unsendable, get_all, set_all)]
pub struct PyDjmdContent {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub FolderPath: Option<String>,
    pub FileNameL: Option<String>,
    pub FileNameS: Option<String>,
    pub Title: Option<String>,
    pub ArtistID: Option<String>,
    pub AlbumID: Option<String>,
    pub GenreID: Option<String>,
    pub BPM: Option<i32>,
    pub Length: Option<i32>,
    pub TrackNo: Option<i32>,
    pub BitRate: Option<i32>,
    pub BitDepth: Option<i32>,
    pub Commnt: Option<String>,
    pub FileType: Option<i32>,
    pub Rating: Option<i32>,
    pub ReleaseYear: Option<i32>,
    pub RemixerID: Option<String>,
    pub LabelID: Option<String>,
    pub OrgArtistID: Option<String>,
    pub KeyID: Option<String>,
    pub StockDate: Option<String>,
    pub ColorID: Option<String>,
    pub DJPlayCount: Option<i32>,
    pub ImagePath: Option<String>,
    pub MasterDBID: Option<String>,
    pub MasterSongID: Option<String>,
    pub AnalysisDataPath: Option<String>,
    pub SearchStr: Option<String>,
    pub FileSize: Option<i32>,
    pub DiscNo: Option<i32>,
    pub ComposerID: Option<String>,
    pub Subtitle: Option<String>,
    pub SampleRate: Option<i32>,
    pub DisableQuantize: Option<i32>,
    pub Analysed: Option<i32>,
    pub ReleaseDate: Option<String>,
    pub DateCreated: Option<String>,
    pub ContentLink: Option<i32>,
    pub Tag: Option<String>,
    pub ModifiedByRBM: Option<String>,
    pub HotCueAutoLoad: Option<String>,
    pub DeliveryControl: Option<String>,
    pub DeliveryComment: Option<String>,
    pub CueUpdated: Option<String>,
    pub AnalysisUpdated: Option<String>,
    pub TrackInfoUpdated: Option<String>,
    pub Lyricist: Option<String>,
    pub ISRC: Option<String>,
    pub SamplerTrackInfo: Option<i32>,
    pub SamplerPlayOffset: Option<i32>,
    pub SamplerGain: Option<f64>,
    pub VideoAssociate: Option<String>,
    pub LyricStatus: Option<i32>,
    pub ServiceID: Option<i32>,
    pub OrgFolderPath: Option<String>,
    pub Reserved1: Option<String>,
    pub Reserved2: Option<String>,
    pub Reserved3: Option<String>,
    pub Reserved4: Option<String>,
    pub ExtInfo: Option<String>,
    pub rb_file_id: Option<String>,
    pub DeviceID: Option<String>,
    pub rb_LocalFolderPath: Option<String>,
    pub SrcID: Option<String>,
    pub SrcTitle: Option<String>,
    pub SrcArtistName: Option<String>,
    pub SrcAlbumName: Option<String>,
    pub SrcLength: Option<i32>,
}

impl IntoPy<PyDjmdContent> for DjmdContent {
    fn into_py(self, py: Python) -> PyResult<PyDjmdContent> {
        let model = PyDjmdContent {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            FolderPath: self.FolderPath,
            FileNameL: self.FileNameL,
            FileNameS: self.FileNameS,
            Title: self.Title,
            ArtistID: self.ArtistID,
            AlbumID: self.AlbumID,
            GenreID: self.GenreID,
            BPM: self.BPM,
            Length: self.Length,
            TrackNo: self.TrackNo,
            BitRate: self.BitRate,
            BitDepth: self.BitDepth,
            Commnt: self.Commnt,
            FileType: self.FileType,
            Rating: self.Rating,
            ReleaseYear: self.ReleaseYear,
            RemixerID: self.RemixerID,
            LabelID: self.LabelID,
            OrgArtistID: self.OrgArtistID,
            KeyID: self.KeyID,
            StockDate: self.StockDate,
            ColorID: self.ColorID,
            DJPlayCount: self.DJPlayCount,
            ImagePath: self.ImagePath,
            MasterDBID: self.MasterDBID,
            MasterSongID: self.MasterSongID,
            AnalysisDataPath: self.AnalysisDataPath,
            SearchStr: self.SearchStr,
            FileSize: self.FileSize,
            DiscNo: self.DiscNo,
            ComposerID: self.ComposerID,
            Subtitle: self.Subtitle,
            SampleRate: self.SampleRate,
            DisableQuantize: self.DisableQuantize,
            Analysed: self.Analysed,
            ReleaseDate: self.ReleaseDate,
            DateCreated: self.DateCreated,
            ContentLink: self.ContentLink,
            Tag: self.Tag,
            ModifiedByRBM: self.ModifiedByRBM,
            HotCueAutoLoad: self.HotCueAutoLoad,
            DeliveryControl: self.DeliveryControl,
            DeliveryComment: self.DeliveryComment,
            CueUpdated: self.CueUpdated,
            AnalysisUpdated: self.AnalysisUpdated,
            TrackInfoUpdated: self.TrackInfoUpdated,
            Lyricist: self.Lyricist,
            ISRC: self.ISRC,
            SamplerTrackInfo: self.SamplerTrackInfo,
            SamplerPlayOffset: self.SamplerPlayOffset,
            SamplerGain: self.SamplerGain,
            VideoAssociate: self.VideoAssociate,
            LyricStatus: self.LyricStatus,
            ServiceID: self.ServiceID,
            OrgFolderPath: self.OrgFolderPath,
            Reserved1: self.Reserved1,
            Reserved2: self.Reserved2,
            Reserved3: self.Reserved3,
            Reserved4: self.Reserved4,
            ExtInfo: self.ExtInfo,
            rb_file_id: self.rb_file_id,
            DeviceID: self.DeviceID,
            rb_LocalFolderPath: self.rb_LocalFolderPath,
            SrcID: self.SrcID,
            SrcTitle: self.SrcTitle,
            SrcArtistName: self.SrcArtistName,
            SrcAlbumName: self.SrcAlbumName,
            SrcLength: self.SrcLength,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdContent> for DjmdContent {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdContent>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            FolderPath: model.FolderPath.clone(),
            FileNameL: model.FileNameL.clone(),
            FileNameS: model.FileNameS.clone(),
            Title: model.Title.clone(),
            ArtistID: model.ArtistID.clone(),
            AlbumID: model.AlbumID.clone(),
            GenreID: model.GenreID.clone(),
            BPM: model.BPM,
            Length: model.Length,
            TrackNo: model.TrackNo,
            BitRate: model.BitRate,
            BitDepth: model.BitDepth,
            Commnt: model.Commnt.clone(),
            FileType: model.FileType,
            Rating: model.Rating,
            ReleaseYear: model.ReleaseYear,
            RemixerID: model.RemixerID.clone(),
            LabelID: model.LabelID.clone(),
            OrgArtistID: model.OrgArtistID.clone(),
            KeyID: model.KeyID.clone(),
            StockDate: model.StockDate.clone(),
            ColorID: model.ColorID.clone(),
            DJPlayCount: model.DJPlayCount,
            ImagePath: model.ImagePath.clone(),
            MasterDBID: model.MasterDBID.clone(),
            MasterSongID: model.MasterSongID.clone(),
            AnalysisDataPath: model.AnalysisDataPath.clone(),
            SearchStr: model.SearchStr.clone(),
            FileSize: model.FileSize,
            DiscNo: model.DiscNo,
            ComposerID: model.ComposerID.clone(),
            Subtitle: model.Subtitle.clone(),
            SampleRate: model.SampleRate,
            DisableQuantize: model.DisableQuantize,
            Analysed: model.Analysed,
            ReleaseDate: model.ReleaseDate.clone(),
            DateCreated: model.DateCreated.clone(),
            ContentLink: model.ContentLink,
            Tag: model.Tag.clone(),
            ModifiedByRBM: model.ModifiedByRBM.clone(),
            HotCueAutoLoad: model.HotCueAutoLoad.clone(),
            DeliveryControl: model.DeliveryControl.clone(),
            DeliveryComment: model.DeliveryComment.clone(),
            CueUpdated: model.CueUpdated.clone(),
            AnalysisUpdated: model.AnalysisUpdated.clone(),
            TrackInfoUpdated: model.TrackInfoUpdated.clone(),
            Lyricist: model.Lyricist.clone(),
            ISRC: model.ISRC.clone(),
            SamplerTrackInfo: model.SamplerTrackInfo,
            SamplerPlayOffset: model.SamplerPlayOffset,
            SamplerGain: model.SamplerGain,
            VideoAssociate: model.VideoAssociate.clone(),
            LyricStatus: model.LyricStatus,
            ServiceID: model.ServiceID,
            OrgFolderPath: model.OrgFolderPath.clone(),
            Reserved1: model.Reserved1.clone(),
            Reserved2: model.Reserved2.clone(),
            Reserved3: model.Reserved3.clone(),
            Reserved4: model.Reserved4.clone(),
            ExtInfo: model.ExtInfo.clone(),
            rb_file_id: model.rb_file_id.clone(),
            DeviceID: model.DeviceID.clone(),
            rb_LocalFolderPath: model.rb_LocalFolderPath.clone(),
            SrcID: model.SrcID.clone(),
            SrcTitle: model.SrcTitle.clone(),
            SrcArtistName: model.SrcArtistName.clone(),
            SrcAlbumName: model.SrcAlbumName.clone(),
            SrcLength: model.SrcLength,
        }
    }
}

impl PyDjmdContent {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "FolderPath".to_string(),
            "FileNameL".to_string(),
            "FileNameS".to_string(),
            "Title".to_string(),
            "ArtistID".to_string(),
            "AlbumID".to_string(),
            "GenreID".to_string(),
            "BPM".to_string(),
            "Length".to_string(),
            "TrackNo".to_string(),
            "BitRate".to_string(),
            "BitDepth".to_string(),
            "Commnt".to_string(),
            "FileType".to_string(),
            "Rating".to_string(),
            "ReleaseYear".to_string(),
            "RemixerID".to_string(),
            "LabelID".to_string(),
            "OrgArtistID".to_string(),
            "KeyID".to_string(),
            "StockDate".to_string(),
            "ColorID".to_string(),
            "DJPlayCount".to_string(),
            "ImagePath".to_string(),
            "MasterDBID".to_string(),
            "MasterSongID".to_string(),
            "AnalysisDataPath".to_string(),
            "SearchStr".to_string(),
            "FileSize".to_string(),
            "DiscNo".to_string(),
            "ComposerID".to_string(),
            "Subtitle".to_string(),
            "SampleRate".to_string(),
            "DisableQuantize".to_string(),
            "Analysed".to_string(),
            "ReleaseDate".to_string(),
            "DateCreated".to_string(),
            "ContentLink".to_string(),
            "Tag".to_string(),
            "ModifiedByRBM".to_string(),
            "HotCueAutoLoad".to_string(),
            "DeliveryControl".to_string(),
            "DeliveryComment".to_string(),
            "CueUpdated".to_string(),
            "AnalysisUpdated".to_string(),
            "TrackInfoUpdated".to_string(),
            "Lyricist".to_string(),
            "ISRC".to_string(),
            "SamplerTrackInfo".to_string(),
            "SamplerPlayOffset".to_string(),
            "SamplerGain".to_string(),
            "VideoAssociate".to_string(),
            "LyricStatus".to_string(),
            "ServiceID".to_string(),
            "OrgFolderPath".to_string(),
            "Reserved1".to_string(),
            "Reserved2".to_string(),
            "Reserved3".to_string(),
            "Reserved4".to_string(),
            "ExtInfo".to_string(),
            "rb_file_id".to_string(),
            "DeviceID".to_string(),
            "rb_LocalFolderPath".to_string(),
            "SrcID".to_string(),
            "SrcTitle".to_string(),
            "SrcArtistName".to_string(),
            "SrcAlbumName".to_string(),
            "SrcLength".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdContent {
    fn __len__(&self) -> usize {
        78
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "FolderPath" => Ok(self.FolderPath.clone().into_pyobject(py)?.into()),
            "FileNameL" => Ok(self.FileNameL.clone().into_pyobject(py)?.into()),
            "FileNameS" => Ok(self.FileNameS.clone().into_pyobject(py)?.into()),
            "Title" => Ok(self.Title.clone().into_pyobject(py)?.into()),
            "ArtistID" => Ok(self.ArtistID.clone().into_pyobject(py)?.into()),
            "AlbumID" => Ok(self.AlbumID.clone().into_pyobject(py)?.into()),
            "GenreID" => Ok(self.GenreID.clone().into_pyobject(py)?.into()),
            "BPM" => Ok(self.BPM.into_pyobject(py)?.into()),
            "Length" => Ok(self.Length.into_pyobject(py)?.into()),
            "TrackNo" => Ok(self.TrackNo.into_pyobject(py)?.into()),
            "BitRate" => Ok(self.BitRate.into_pyobject(py)?.into()),
            "BitDepth" => Ok(self.BitDepth.into_pyobject(py)?.into()),
            "Commnt" => Ok(self.Commnt.clone().into_pyobject(py)?.into()),
            "FileType" => Ok(self.FileType.into_pyobject(py)?.into()),
            "Rating" => Ok(self.Rating.into_pyobject(py)?.into()),
            "ReleaseYear" => Ok(self.ReleaseYear.into_pyobject(py)?.into()),
            "RemixerID" => Ok(self.RemixerID.clone().into_pyobject(py)?.into()),
            "LabelID" => Ok(self.LabelID.clone().into_pyobject(py)?.into()),
            "OrgArtistID" => Ok(self.OrgArtistID.clone().into_pyobject(py)?.into()),
            "KeyID" => Ok(self.KeyID.clone().into_pyobject(py)?.into()),
            "StockDate" => Ok(self.StockDate.clone().into_pyobject(py)?.into()),
            "ColorID" => Ok(self.ColorID.clone().into_pyobject(py)?.into()),
            "DJPlayCount" => Ok(self.DJPlayCount.into_pyobject(py)?.into()),
            "ImagePath" => Ok(self.ImagePath.clone().into_pyobject(py)?.into()),
            "MasterDBID" => Ok(self.MasterDBID.clone().into_pyobject(py)?.into()),
            "MasterSongID" => Ok(self.MasterSongID.clone().into_pyobject(py)?.into()),
            "AnalysisDataPath" => Ok(self.AnalysisDataPath.clone().into_pyobject(py)?.into()),
            "SearchStr" => Ok(self.SearchStr.clone().into_pyobject(py)?.into()),
            "FileSize" => Ok(self.FileSize.into_pyobject(py)?.into()),
            "DiscNo" => Ok(self.DiscNo.into_pyobject(py)?.into()),
            "ComposerID" => Ok(self.ComposerID.clone().into_pyobject(py)?.into()),
            "Subtitle" => Ok(self.Subtitle.clone().into_pyobject(py)?.into()),
            "SampleRate" => Ok(self.SampleRate.into_pyobject(py)?.into()),
            "DisableQuantize" => Ok(self.DisableQuantize.into_pyobject(py)?.into()),
            "Analysed" => Ok(self.Analysed.into_pyobject(py)?.into()),
            "ReleaseDate" => Ok(self.ReleaseDate.clone().into_pyobject(py)?.into()),
            "DateCreated" => Ok(self.DateCreated.clone().into_pyobject(py)?.into()),
            "ContentLink" => Ok(self.ContentLink.into_pyobject(py)?.into()),
            "Tag" => Ok(self.Tag.clone().into_pyobject(py)?.into()),
            "ModifiedByRBM" => Ok(self.ModifiedByRBM.clone().into_pyobject(py)?.into()),
            "HotCueAutoLoad" => Ok(self.HotCueAutoLoad.clone().into_pyobject(py)?.into()),
            "DeliveryControl" => Ok(self.DeliveryControl.clone().into_pyobject(py)?.into()),
            "DeliveryComment" => Ok(self.DeliveryComment.clone().into_pyobject(py)?.into()),
            "CueUpdated" => Ok(self.CueUpdated.clone().into_pyobject(py)?.into()),
            "AnalysisUpdated" => Ok(self.AnalysisUpdated.clone().into_pyobject(py)?.into()),
            "TrackInfoUpdated" => Ok(self.TrackInfoUpdated.clone().into_pyobject(py)?.into()),
            "Lyricist" => Ok(self.Lyricist.clone().into_pyobject(py)?.into()),
            "ISRC" => Ok(self.ISRC.clone().into_pyobject(py)?.into()),
            "SamplerTrackInfo" => Ok(self.SamplerTrackInfo.into_pyobject(py)?.into()),
            "SamplerPlayOffset" => Ok(self.SamplerPlayOffset.into_pyobject(py)?.into()),
            "SamplerGain" => Ok(self.SamplerGain.into_pyobject(py)?.into()),
            "VideoAssociate" => Ok(self.VideoAssociate.clone().into_pyobject(py)?.into()),
            "LyricStatus" => Ok(self.LyricStatus.into_pyobject(py)?.into()),
            "ServiceID" => Ok(self.ServiceID.into_pyobject(py)?.into()),
            "OrgFolderPath" => Ok(self.OrgFolderPath.clone().into_pyobject(py)?.into()),
            "Reserved1" => Ok(self.Reserved1.clone().into_pyobject(py)?.into()),
            "Reserved2" => Ok(self.Reserved2.clone().into_pyobject(py)?.into()),
            "Reserved3" => Ok(self.Reserved3.clone().into_pyobject(py)?.into()),
            "Reserved4" => Ok(self.Reserved4.clone().into_pyobject(py)?.into()),
            "ExtInfo" => Ok(self.ExtInfo.clone().into_pyobject(py)?.into()),
            "rb_file_id" => Ok(self.rb_file_id.clone().into_pyobject(py)?.into()),
            "DeviceID" => Ok(self.DeviceID.clone().into_pyobject(py)?.into()),
            "rb_LocalFolderPath" => Ok(self.rb_LocalFolderPath.clone().into_pyobject(py)?.into()),
            "SrcID" => Ok(self.SrcID.clone().into_pyobject(py)?.into()),
            "SrcTitle" => Ok(self.SrcTitle.clone().into_pyobject(py)?.into()),
            "SrcArtistName" => Ok(self.SrcArtistName.clone().into_pyobject(py)?.into()),
            "SrcAlbumName" => Ok(self.SrcAlbumName.clone().into_pyobject(py)?.into()),
            "SrcLength" => Ok(self.SrcLength.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "FolderPath" => self.FolderPath = value.extract::<Option<String>>(py)?,
            "FileNameL" => self.FileNameL = value.extract::<Option<String>>(py)?,
            "FileNameS" => self.FileNameS = value.extract::<Option<String>>(py)?,
            "Title" => self.Title = value.extract::<Option<String>>(py)?,
            "ArtistID" => self.ArtistID = value.extract::<Option<String>>(py)?,
            "AlbumID" => self.AlbumID = value.extract::<Option<String>>(py)?,
            "GenreID" => self.GenreID = value.extract::<Option<String>>(py)?,
            "BPM" => self.BPM = value.extract::<Option<i32>>(py)?,
            "Length" => self.Length = value.extract::<Option<i32>>(py)?,
            "TrackNo" => self.TrackNo = value.extract::<Option<i32>>(py)?,
            "BitRate" => self.BitRate = value.extract::<Option<i32>>(py)?,
            "BitDepth" => self.BitDepth = value.extract::<Option<i32>>(py)?,
            "Commnt" => self.Commnt = value.extract::<Option<String>>(py)?,
            "FileType" => self.FileType = value.extract::<Option<i32>>(py)?,
            "Rating" => self.Rating = value.extract::<Option<i32>>(py)?,
            "ReleaseYear" => self.ReleaseYear = value.extract::<Option<i32>>(py)?,
            "RemixerID" => self.RemixerID = value.extract::<Option<String>>(py)?,
            "LabelID" => self.LabelID = value.extract::<Option<String>>(py)?,
            "OrgArtistID" => self.OrgArtistID = value.extract::<Option<String>>(py)?,
            "KeyID" => self.KeyID = value.extract::<Option<String>>(py)?,
            "StockDate" => self.StockDate = value.extract::<Option<String>>(py)?,
            "ColorID" => self.ColorID = value.extract::<Option<String>>(py)?,
            "DJPlayCount" => self.DJPlayCount = value.extract::<Option<i32>>(py)?,
            "ImagePath" => self.ImagePath = value.extract::<Option<String>>(py)?,
            "MasterDBID" => self.MasterDBID = value.extract::<Option<String>>(py)?,
            "MasterSongID" => self.MasterSongID = value.extract::<Option<String>>(py)?,
            "AnalysisDataPath" => self.AnalysisDataPath = value.extract::<Option<String>>(py)?,
            "SearchStr" => self.SearchStr = value.extract::<Option<String>>(py)?,
            "FileSize" => self.FileSize = value.extract::<Option<i32>>(py)?,
            "DiscNo" => self.DiscNo = value.extract::<Option<i32>>(py)?,
            "ComposerID" => self.ComposerID = value.extract::<Option<String>>(py)?,
            "Subtitle" => self.Subtitle = value.extract::<Option<String>>(py)?,
            "SampleRate" => self.SampleRate = value.extract::<Option<i32>>(py)?,
            "DisableQuantize" => self.DisableQuantize = value.extract::<Option<i32>>(py)?,
            "Analysed" => self.Analysed = value.extract::<Option<i32>>(py)?,
            "ReleaseDate" => self.ReleaseDate = value.extract::<Option<String>>(py)?,
            "DateCreated" => self.DateCreated = value.extract::<Option<String>>(py)?,
            "ContentLink" => self.ContentLink = value.extract::<Option<i32>>(py)?,
            "Tag" => self.Tag = value.extract::<Option<String>>(py)?,
            "ModifiedByRBM" => self.ModifiedByRBM = value.extract::<Option<String>>(py)?,
            "HotCueAutoLoad" => self.HotCueAutoLoad = value.extract::<Option<String>>(py)?,
            "DeliveryControl" => self.DeliveryControl = value.extract::<Option<String>>(py)?,
            "DeliveryComment" => self.DeliveryComment = value.extract::<Option<String>>(py)?,
            "CueUpdated" => self.CueUpdated = value.extract::<Option<String>>(py)?,
            "AnalysisUpdated" => self.AnalysisUpdated = value.extract::<Option<String>>(py)?,
            "TrackInfoUpdated" => self.TrackInfoUpdated = value.extract::<Option<String>>(py)?,
            "Lyricist" => self.Lyricist = value.extract::<Option<String>>(py)?,
            "ISRC" => self.ISRC = value.extract::<Option<String>>(py)?,
            "SamplerTrackInfo" => self.SamplerTrackInfo = value.extract::<Option<i32>>(py)?,
            "SamplerPlayOffset" => self.SamplerPlayOffset = value.extract::<Option<i32>>(py)?,
            "SamplerGain" => self.SamplerGain = value.extract::<Option<f64>>(py)?,
            "VideoAssociate" => self.VideoAssociate = value.extract::<Option<String>>(py)?,
            "LyricStatus" => self.LyricStatus = value.extract::<Option<i32>>(py)?,
            "ServiceID" => self.ServiceID = value.extract::<Option<i32>>(py)?,
            "OrgFolderPath" => self.OrgFolderPath = value.extract::<Option<String>>(py)?,
            "Reserved1" => self.Reserved1 = value.extract::<Option<String>>(py)?,
            "Reserved2" => self.Reserved2 = value.extract::<Option<String>>(py)?,
            "Reserved3" => self.Reserved3 = value.extract::<Option<String>>(py)?,
            "Reserved4" => self.Reserved4 = value.extract::<Option<String>>(py)?,
            "ExtInfo" => self.ExtInfo = value.extract::<Option<String>>(py)?,
            "rb_file_id" => self.rb_file_id = value.extract::<Option<String>>(py)?,
            "DeviceID" => self.DeviceID = value.extract::<Option<String>>(py)?,
            "rb_LocalFolderPath" => {
                self.rb_LocalFolderPath = value.extract::<Option<String>>(py)?
            }
            "SrcID" => self.SrcID = value.extract::<Option<String>>(py)?,
            "SrcTitle" => self.SrcTitle = value.extract::<Option<String>>(py)?,
            "SrcArtistName" => self.SrcArtistName = value.extract::<Option<String>>(py)?,
            "SrcAlbumName" => self.SrcAlbumName = value.extract::<Option<String>>(py)?,
            "SrcLength" => self.SrcLength = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdContent(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdCue", unsendable, get_all, set_all)]
pub struct PyDjmdCue {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub ContentID: Option<String>,
    pub InMsec: Option<i32>,
    pub InFrame: Option<i32>,
    pub InMpegFrame: Option<i32>,
    pub InMpegAbs: Option<i32>,
    pub OutMsec: Option<i32>,
    pub OutFrame: Option<i32>,
    pub OutMpegFrame: Option<i32>,
    pub OutMpegAbs: Option<i32>,
    pub Kind: Option<i32>,
    pub Color: Option<i32>,
    pub ColorTableIndex: Option<i32>,
    pub ActiveLoop: Option<i32>,
    pub Comment: Option<String>,
    pub BeatLoopSize: Option<i32>,
    pub CueMicrosec: Option<i32>,
    pub InPointSeekInfo: Option<String>,
    pub OutPointSeekInfo: Option<String>,
    pub ContentUUID: Option<String>,
}

impl IntoPy<PyDjmdCue> for DjmdCue {
    fn into_py(self, py: Python) -> PyResult<PyDjmdCue> {
        let model = PyDjmdCue {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            ContentID: self.ContentID,
            InMsec: self.InMsec,
            InFrame: self.InFrame,
            InMpegFrame: self.InMpegFrame,
            InMpegAbs: self.InMpegAbs,
            OutMsec: self.OutMsec,
            OutFrame: self.OutFrame,
            OutMpegFrame: self.OutMpegFrame,
            OutMpegAbs: self.OutMpegAbs,
            Kind: self.Kind,
            Color: self.Color,
            ColorTableIndex: self.ColorTableIndex,
            ActiveLoop: self.ActiveLoop,
            Comment: self.Comment,
            BeatLoopSize: self.BeatLoopSize,
            CueMicrosec: self.CueMicrosec,
            InPointSeekInfo: self.InPointSeekInfo,
            OutPointSeekInfo: self.OutPointSeekInfo,
            ContentUUID: self.ContentUUID,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdCue> for DjmdCue {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdCue>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            ContentID: model.ContentID.clone(),
            InMsec: model.InMsec,
            InFrame: model.InFrame,
            InMpegFrame: model.InMpegFrame,
            InMpegAbs: model.InMpegAbs,
            OutMsec: model.OutMsec,
            OutFrame: model.OutFrame,
            OutMpegFrame: model.OutMpegFrame,
            OutMpegAbs: model.OutMpegAbs,
            Kind: model.Kind,
            Color: model.Color,
            ColorTableIndex: model.ColorTableIndex,
            ActiveLoop: model.ActiveLoop,
            Comment: model.Comment.clone(),
            BeatLoopSize: model.BeatLoopSize,
            CueMicrosec: model.CueMicrosec,
            InPointSeekInfo: model.InPointSeekInfo.clone(),
            OutPointSeekInfo: model.OutPointSeekInfo.clone(),
            ContentUUID: model.ContentUUID.clone(),
        }
    }
}

impl PyDjmdCue {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "ContentID".to_string(),
            "InMsec".to_string(),
            "InFrame".to_string(),
            "InMpegFrame".to_string(),
            "InMpegAbs".to_string(),
            "OutMsec".to_string(),
            "OutFrame".to_string(),
            "OutMpegFrame".to_string(),
            "OutMpegAbs".to_string(),
            "Kind".to_string(),
            "Color".to_string(),
            "ColorTableIndex".to_string(),
            "ActiveLoop".to_string(),
            "Comment".to_string(),
            "BeatLoopSize".to_string(),
            "CueMicrosec".to_string(),
            "InPointSeekInfo".to_string(),
            "OutPointSeekInfo".to_string(),
            "ContentUUID".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdCue {
    fn __len__(&self) -> usize {
        29
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "InMsec" => Ok(self.InMsec.into_pyobject(py)?.into()),
            "InFrame" => Ok(self.InFrame.into_pyobject(py)?.into()),
            "InMpegFrame" => Ok(self.InMpegFrame.into_pyobject(py)?.into()),
            "InMpegAbs" => Ok(self.InMpegAbs.into_pyobject(py)?.into()),
            "OutMsec" => Ok(self.OutMsec.into_pyobject(py)?.into()),
            "OutFrame" => Ok(self.OutFrame.into_pyobject(py)?.into()),
            "OutMpegFrame" => Ok(self.OutMpegFrame.into_pyobject(py)?.into()),
            "OutMpegAbs" => Ok(self.OutMpegAbs.into_pyobject(py)?.into()),
            "Kind" => Ok(self.Kind.into_pyobject(py)?.into()),
            "Color" => Ok(self.Color.into_pyobject(py)?.into()),
            "ColorTableIndex" => Ok(self.ColorTableIndex.into_pyobject(py)?.into()),
            "ActiveLoop" => Ok(self.ActiveLoop.into_pyobject(py)?.into()),
            "Comment" => Ok(self.Comment.clone().into_pyobject(py)?.into()),
            "BeatLoopSize" => Ok(self.BeatLoopSize.into_pyobject(py)?.into()),
            "CueMicrosec" => Ok(self.CueMicrosec.into_pyobject(py)?.into()),
            "InPointSeekInfo" => Ok(self.InPointSeekInfo.clone().into_pyobject(py)?.into()),
            "OutPointSeekInfo" => Ok(self.OutPointSeekInfo.clone().into_pyobject(py)?.into()),
            "ContentUUID" => Ok(self.ContentUUID.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "InMsec" => self.InMsec = value.extract::<Option<i32>>(py)?,
            "InFrame" => self.InFrame = value.extract::<Option<i32>>(py)?,
            "InMpegFrame" => self.InMpegFrame = value.extract::<Option<i32>>(py)?,
            "InMpegAbs" => self.InMpegAbs = value.extract::<Option<i32>>(py)?,
            "OutMsec" => self.OutMsec = value.extract::<Option<i32>>(py)?,
            "OutFrame" => self.OutFrame = value.extract::<Option<i32>>(py)?,
            "OutMpegFrame" => self.OutMpegFrame = value.extract::<Option<i32>>(py)?,
            "OutMpegAbs" => self.OutMpegAbs = value.extract::<Option<i32>>(py)?,
            "Kind" => self.Kind = value.extract::<Option<i32>>(py)?,
            "Color" => self.Color = value.extract::<Option<i32>>(py)?,
            "ColorTableIndex" => self.ColorTableIndex = value.extract::<Option<i32>>(py)?,
            "ActiveLoop" => self.ActiveLoop = value.extract::<Option<i32>>(py)?,
            "Comment" => self.Comment = value.extract::<Option<String>>(py)?,
            "BeatLoopSize" => self.BeatLoopSize = value.extract::<Option<i32>>(py)?,
            "CueMicrosec" => self.CueMicrosec = value.extract::<Option<i32>>(py)?,
            "InPointSeekInfo" => self.InPointSeekInfo = value.extract::<Option<String>>(py)?,
            "OutPointSeekInfo" => self.OutPointSeekInfo = value.extract::<Option<String>>(py)?,
            "ContentUUID" => self.ContentUUID = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdCue(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdDevice", unsendable, get_all, set_all)]
pub struct PyDjmdDevice {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub MasterDBID: Option<String>,
    pub Name: Option<String>,
}

impl IntoPy<PyDjmdDevice> for DjmdDevice {
    fn into_py(self, py: Python) -> PyResult<PyDjmdDevice> {
        let model = PyDjmdDevice {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            MasterDBID: self.MasterDBID,
            Name: self.Name,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdDevice> for DjmdDevice {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdDevice>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            MasterDBID: model.MasterDBID.clone(),
            Name: model.Name.clone(),
        }
    }
}

impl PyDjmdDevice {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "MasterDBID".to_string(),
            "Name".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdDevice {
    fn __len__(&self) -> usize {
        12
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "MasterDBID" => Ok(self.MasterDBID.clone().into_pyobject(py)?.into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "MasterDBID" => self.MasterDBID = value.extract::<Option<String>>(py)?,
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdDevice(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdGenre", unsendable, get_all, set_all)]
pub struct PyDjmdGenre {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Name: Option<String>,
}

impl IntoPy<PyDjmdGenre> for DjmdGenre {
    fn into_py(self, py: Python) -> PyResult<PyDjmdGenre> {
        let model = PyDjmdGenre {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Name: self.Name,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdGenre> for DjmdGenre {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdGenre>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Name: model.Name.clone(),
        }
    }
}

impl PyDjmdGenre {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Name".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdGenre {
    fn __len__(&self) -> usize {
        11
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdGenre(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdHistory", unsendable, get_all, set_all)]
pub struct PyDjmdHistory {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Seq: Option<i32>,
    pub Name: Option<String>,
    pub Attribute: Option<i32>,
    pub ParentID: Option<String>,
    pub DateCreated: Option<String>,
}

impl IntoPy<PyDjmdHistory> for DjmdHistory {
    fn into_py(self, py: Python) -> PyResult<PyDjmdHistory> {
        let model = PyDjmdHistory {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Seq: self.Seq,
            Name: self.Name,
            Attribute: self.Attribute,
            ParentID: self.ParentID,
            DateCreated: self.DateCreated,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdHistory> for DjmdHistory {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdHistory>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Seq: model.Seq,
            Name: model.Name.clone(),
            Attribute: model.Attribute,
            ParentID: model.ParentID.clone(),
            DateCreated: model.DateCreated.clone(),
        }
    }
}

impl PyDjmdHistory {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Seq".to_string(),
            "Name".to_string(),
            "Attribute".to_string(),
            "ParentID".to_string(),
            "DateCreated".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdHistory {
    fn __len__(&self) -> usize {
        15
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Seq" => Ok(self.Seq.into_pyobject(py)?.into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            "Attribute" => Ok(self.Attribute.into_pyobject(py)?.into()),
            "ParentID" => Ok(self.ParentID.clone().into_pyobject(py)?.into()),
            "DateCreated" => Ok(self.DateCreated.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Seq" => self.Seq = value.extract::<Option<i32>>(py)?,
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            "Attribute" => self.Attribute = value.extract::<Option<i32>>(py)?,
            "ParentID" => self.ParentID = value.extract::<Option<String>>(py)?,
            "DateCreated" => self.DateCreated = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdHistory(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdSongHistory", unsendable, get_all, set_all)]
pub struct PyDjmdSongHistory {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub HistoryID: Option<String>,
    pub ContentID: Option<String>,
    pub TrackNo: Option<i32>,
}

impl IntoPy<PyDjmdSongHistory> for DjmdSongHistory {
    fn into_py(self, py: Python) -> PyResult<PyDjmdSongHistory> {
        let model = PyDjmdSongHistory {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            HistoryID: self.HistoryID,
            ContentID: self.ContentID,
            TrackNo: self.TrackNo,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdSongHistory> for DjmdSongHistory {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdSongHistory>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            HistoryID: model.HistoryID.clone(),
            ContentID: model.ContentID.clone(),
            TrackNo: model.TrackNo,
        }
    }
}

impl PyDjmdSongHistory {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "HistoryID".to_string(),
            "ContentID".to_string(),
            "TrackNo".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdSongHistory {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "HistoryID" => Ok(self.HistoryID.clone().into_pyobject(py)?.into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "TrackNo" => Ok(self.TrackNo.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "HistoryID" => self.HistoryID = value.extract::<Option<String>>(py)?,
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "TrackNo" => self.TrackNo = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdSongHistory(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdHotCueBanklist", unsendable, get_all, set_all)]
pub struct PyDjmdHotCueBanklist {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Seq: Option<i32>,
    pub Name: Option<String>,
    pub ImagePath: Option<String>,
    pub Attribute: Option<i32>,
    pub ParentID: Option<String>,
}

impl IntoPy<PyDjmdHotCueBanklist> for DjmdHotCueBanklist {
    fn into_py(self, py: Python) -> PyResult<PyDjmdHotCueBanklist> {
        let model = PyDjmdHotCueBanklist {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Seq: self.Seq,
            Name: self.Name,
            ImagePath: self.ImagePath,
            Attribute: self.Attribute,
            ParentID: self.ParentID,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdHotCueBanklist> for DjmdHotCueBanklist {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdHotCueBanklist>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Seq: model.Seq,
            Name: model.Name.clone(),
            ImagePath: model.ImagePath.clone(),
            Attribute: model.Attribute,
            ParentID: model.ParentID.clone(),
        }
    }
}

impl PyDjmdHotCueBanklist {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Seq".to_string(),
            "Name".to_string(),
            "ImagePath".to_string(),
            "Attribute".to_string(),
            "ParentID".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdHotCueBanklist {
    fn __len__(&self) -> usize {
        15
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Seq" => Ok(self.Seq.into_pyobject(py)?.into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            "ImagePath" => Ok(self.ImagePath.clone().into_pyobject(py)?.into()),
            "Attribute" => Ok(self.Attribute.into_pyobject(py)?.into()),
            "ParentID" => Ok(self.ParentID.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Seq" => self.Seq = value.extract::<Option<i32>>(py)?,
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            "ImagePath" => self.ImagePath = value.extract::<Option<String>>(py)?,
            "Attribute" => self.Attribute = value.extract::<Option<i32>>(py)?,
            "ParentID" => self.ParentID = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdHotCueBanklist(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdSongHotCueBanklist", unsendable, get_all, set_all)]
pub struct PyDjmdSongHotCueBanklist {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub ContentID: Option<String>,
    pub TrackNo: Option<i32>,
    pub CueID: Option<String>,
    pub InMsec: Option<i32>,
    pub InFrame: Option<i32>,
    pub InMpegFrame: Option<i32>,
    pub InMpegAbs: Option<i32>,
    pub OutMsec: Option<i32>,
    pub OutFrame: Option<i32>,
    pub OutMpegFrame: Option<i32>,
    pub OutMpegAbs: Option<i32>,
    pub Color: Option<i32>,
    pub ColorTableIndex: Option<i32>,
    pub ActiveLoop: Option<i32>,
    pub Comment: Option<String>,
    pub BeatLoopSize: Option<i32>,
    pub CueMicrosec: Option<i32>,
    pub InPointSeekInfo: Option<String>,
    pub OutPointSeekInfo: Option<String>,
    pub HotCueBanklistUUID: Option<String>,
}

impl IntoPy<PyDjmdSongHotCueBanklist> for DjmdSongHotCueBanklist {
    fn into_py(self, py: Python) -> PyResult<PyDjmdSongHotCueBanklist> {
        let model = PyDjmdSongHotCueBanklist {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            ContentID: self.ContentID,
            TrackNo: self.TrackNo,
            CueID: self.CueID,
            InMsec: self.InMsec,
            InFrame: self.InFrame,
            InMpegFrame: self.InMpegFrame,
            InMpegAbs: self.InMpegAbs,
            OutMsec: self.OutMsec,
            OutFrame: self.OutFrame,
            OutMpegFrame: self.OutMpegFrame,
            OutMpegAbs: self.OutMpegAbs,
            Color: self.Color,
            ColorTableIndex: self.ColorTableIndex,
            ActiveLoop: self.ActiveLoop,
            Comment: self.Comment,
            BeatLoopSize: self.BeatLoopSize,
            CueMicrosec: self.CueMicrosec,
            InPointSeekInfo: self.InPointSeekInfo,
            OutPointSeekInfo: self.OutPointSeekInfo,
            HotCueBanklistUUID: self.HotCueBanklistUUID,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdSongHotCueBanklist> for DjmdSongHotCueBanklist {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdSongHotCueBanklist>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            ContentID: model.ContentID.clone(),
            TrackNo: model.TrackNo,
            CueID: model.CueID.clone(),
            InMsec: model.InMsec,
            InFrame: model.InFrame,
            InMpegFrame: model.InMpegFrame,
            InMpegAbs: model.InMpegAbs,
            OutMsec: model.OutMsec,
            OutFrame: model.OutFrame,
            OutMpegFrame: model.OutMpegFrame,
            OutMpegAbs: model.OutMpegAbs,
            Color: model.Color,
            ColorTableIndex: model.ColorTableIndex,
            ActiveLoop: model.ActiveLoop,
            Comment: model.Comment.clone(),
            BeatLoopSize: model.BeatLoopSize,
            CueMicrosec: model.CueMicrosec,
            InPointSeekInfo: model.InPointSeekInfo.clone(),
            OutPointSeekInfo: model.OutPointSeekInfo.clone(),
            HotCueBanklistUUID: model.HotCueBanklistUUID.clone(),
        }
    }
}

impl PyDjmdSongHotCueBanklist {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "ContentID".to_string(),
            "TrackNo".to_string(),
            "CueID".to_string(),
            "InMsec".to_string(),
            "InFrame".to_string(),
            "InMpegFrame".to_string(),
            "InMpegAbs".to_string(),
            "OutMsec".to_string(),
            "OutFrame".to_string(),
            "OutMpegFrame".to_string(),
            "OutMpegAbs".to_string(),
            "Color".to_string(),
            "ColorTableIndex".to_string(),
            "ActiveLoop".to_string(),
            "Comment".to_string(),
            "BeatLoopSize".to_string(),
            "CueMicrosec".to_string(),
            "InPointSeekInfo".to_string(),
            "OutPointSeekInfo".to_string(),
            "HotCueBanklistUUID".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdSongHotCueBanklist {
    fn __len__(&self) -> usize {
        30
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "TrackNo" => Ok(self.TrackNo.into_pyobject(py)?.into()),
            "CueID" => Ok(self.CueID.clone().into_pyobject(py)?.into()),
            "InMsec" => Ok(self.InMsec.into_pyobject(py)?.into()),
            "InFrame" => Ok(self.InFrame.into_pyobject(py)?.into()),
            "InMpegFrame" => Ok(self.InMpegFrame.into_pyobject(py)?.into()),
            "InMpegAbs" => Ok(self.InMpegAbs.into_pyobject(py)?.into()),
            "OutMsec" => Ok(self.OutMsec.into_pyobject(py)?.into()),
            "OutFrame" => Ok(self.OutFrame.into_pyobject(py)?.into()),
            "OutMpegFrame" => Ok(self.OutMpegFrame.into_pyobject(py)?.into()),
            "OutMpegAbs" => Ok(self.OutMpegAbs.into_pyobject(py)?.into()),
            "Color" => Ok(self.Color.into_pyobject(py)?.into()),
            "ColorTableIndex" => Ok(self.ColorTableIndex.into_pyobject(py)?.into()),
            "ActiveLoop" => Ok(self.ActiveLoop.into_pyobject(py)?.into()),
            "Comment" => Ok(self.Comment.clone().into_pyobject(py)?.into()),
            "BeatLoopSize" => Ok(self.BeatLoopSize.into_pyobject(py)?.into()),
            "CueMicrosec" => Ok(self.CueMicrosec.into_pyobject(py)?.into()),
            "InPointSeekInfo" => Ok(self.InPointSeekInfo.clone().into_pyobject(py)?.into()),
            "OutPointSeekInfo" => Ok(self.OutPointSeekInfo.clone().into_pyobject(py)?.into()),
            "HotCueBanklistUUID" => Ok(self.HotCueBanklistUUID.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "TrackNo" => self.TrackNo = value.extract::<Option<i32>>(py)?,
            "CueID" => self.CueID = value.extract::<Option<String>>(py)?,
            "InMsec" => self.InMsec = value.extract::<Option<i32>>(py)?,
            "InFrame" => self.InFrame = value.extract::<Option<i32>>(py)?,
            "InMpegFrame" => self.InMpegFrame = value.extract::<Option<i32>>(py)?,
            "InMpegAbs" => self.InMpegAbs = value.extract::<Option<i32>>(py)?,
            "OutMsec" => self.OutMsec = value.extract::<Option<i32>>(py)?,
            "OutFrame" => self.OutFrame = value.extract::<Option<i32>>(py)?,
            "OutMpegFrame" => self.OutMpegFrame = value.extract::<Option<i32>>(py)?,
            "OutMpegAbs" => self.OutMpegAbs = value.extract::<Option<i32>>(py)?,
            "Color" => self.Color = value.extract::<Option<i32>>(py)?,
            "ColorTableIndex" => self.ColorTableIndex = value.extract::<Option<i32>>(py)?,
            "ActiveLoop" => self.ActiveLoop = value.extract::<Option<i32>>(py)?,
            "Comment" => self.Comment = value.extract::<Option<String>>(py)?,
            "BeatLoopSize" => self.BeatLoopSize = value.extract::<Option<i32>>(py)?,
            "CueMicrosec" => self.CueMicrosec = value.extract::<Option<i32>>(py)?,
            "InPointSeekInfo" => self.InPointSeekInfo = value.extract::<Option<String>>(py)?,
            "OutPointSeekInfo" => self.OutPointSeekInfo = value.extract::<Option<String>>(py)?,
            "HotCueBanklistUUID" => {
                self.HotCueBanklistUUID = value.extract::<Option<String>>(py)?
            }
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdSongHotCueBanklist(ID: {})", self.ID,))
    }
}

#[pyclass(name = "HotCueBanklistCue", unsendable, get_all, set_all)]
pub struct PyHotCueBanklistCue {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub HotCueBanklistID: Option<String>,
    pub Cues: Option<String>,
    pub rb_cue_count: Option<i32>,
}

impl IntoPy<PyHotCueBanklistCue> for HotCueBanklistCue {
    fn into_py(self, py: Python) -> PyResult<PyHotCueBanklistCue> {
        let model = PyHotCueBanklistCue {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            HotCueBanklistID: self.HotCueBanklistID,
            Cues: self.Cues,
            rb_cue_count: self.rb_cue_count,
        };
        Ok(model)
    }
}

impl FromPy<PyHotCueBanklistCue> for HotCueBanklistCue {
    fn from_py(py: Python, model: PyRef<'_, PyHotCueBanklistCue>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            HotCueBanklistID: model.HotCueBanklistID.clone(),
            Cues: model.Cues.clone(),
            rb_cue_count: model.rb_cue_count,
        }
    }
}

impl PyHotCueBanklistCue {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "HotCueBanklistID".to_string(),
            "Cues".to_string(),
            "rb_cue_count".to_string(),
        ]
    }
}

#[pymethods]
impl PyHotCueBanklistCue {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "HotCueBanklistID" => Ok(self.HotCueBanklistID.clone().into_pyobject(py)?.into()),
            "Cues" => Ok(self.Cues.clone().into_pyobject(py)?.into()),
            "rb_cue_count" => Ok(self.rb_cue_count.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "HotCueBanklistID" => self.HotCueBanklistID = value.extract::<Option<String>>(py)?,
            "Cues" => self.Cues = value.extract::<Option<String>>(py)?,
            "rb_cue_count" => self.rb_cue_count = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("HotCueBanklistCue(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdKey", unsendable, get_all, set_all)]
pub struct PyDjmdKey {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub ScaleName: Option<String>,
    pub Seq: Option<i32>,
}

impl IntoPy<PyDjmdKey> for DjmdKey {
    fn into_py(self, py: Python) -> PyResult<PyDjmdKey> {
        let model = PyDjmdKey {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            ScaleName: self.ScaleName,
            Seq: self.Seq,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdKey> for DjmdKey {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdKey>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            ScaleName: model.ScaleName.clone(),
            Seq: model.Seq,
        }
    }
}

impl PyDjmdKey {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "ScaleName".to_string(),
            "Seq".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdKey {
    fn __len__(&self) -> usize {
        12
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "ScaleName" => Ok(self.ScaleName.clone().into_pyobject(py)?.into()),
            "Seq" => Ok(self.Seq.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "ScaleName" => self.ScaleName = value.extract::<Option<String>>(py)?,
            "Seq" => self.Seq = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdKey(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdLabel", unsendable, get_all, set_all)]
pub struct PyDjmdLabel {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Name: Option<String>,
}

impl IntoPy<PyDjmdLabel> for DjmdLabel {
    fn into_py(self, py: Python) -> PyResult<PyDjmdLabel> {
        let model = PyDjmdLabel {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Name: self.Name,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdLabel> for DjmdLabel {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdLabel>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Name: model.Name.clone(),
        }
    }
}

impl PyDjmdLabel {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Name".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdLabel {
    fn __len__(&self) -> usize {
        11
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdLabel(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdMenuItems", unsendable, get_all, set_all)]
pub struct PyDjmdMenuItems {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Class: Option<i32>,
    pub Name: Option<String>,
}

impl IntoPy<PyDjmdMenuItems> for DjmdMenuItems {
    fn into_py(self, py: Python) -> PyResult<PyDjmdMenuItems> {
        let model = PyDjmdMenuItems {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Class: self.Class,
            Name: self.Name,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdMenuItems> for DjmdMenuItems {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdMenuItems>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Class: model.Class,
            Name: model.Name.clone(),
        }
    }
}

impl PyDjmdMenuItems {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Class".to_string(),
            "Name".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdMenuItems {
    fn __len__(&self) -> usize {
        12
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Class" => Ok(self.Class.into_pyobject(py)?.into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Class" => self.Class = value.extract::<Option<i32>>(py)?,
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdMenuItems(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdMixerParam", unsendable, get_all, set_all)]
pub struct PyDjmdMixerParam {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub ContentID: Option<String>,
    pub GainHigh: Option<i32>,
    pub GainLow: Option<i32>,
    pub PeakHigh: Option<i32>,
    pub PeakLow: Option<i32>,
}

impl IntoPy<PyDjmdMixerParam> for DjmdMixerParam {
    fn into_py(self, py: Python) -> PyResult<PyDjmdMixerParam> {
        let model = PyDjmdMixerParam {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            ContentID: self.ContentID,
            GainHigh: self.GainHigh,
            GainLow: self.GainLow,
            PeakHigh: self.PeakHigh,
            PeakLow: self.PeakLow,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdMixerParam> for DjmdMixerParam {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdMixerParam>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            ContentID: model.ContentID.clone(),
            GainHigh: model.GainHigh,
            GainLow: model.GainLow,
            PeakHigh: model.PeakHigh,
            PeakLow: model.PeakLow,
        }
    }
}

impl PyDjmdMixerParam {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "ContentID".to_string(),
            "GainHigh".to_string(),
            "GainLow".to_string(),
            "PeakHigh".to_string(),
            "PeakLow".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdMixerParam {
    fn __len__(&self) -> usize {
        15
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "GainHigh" => Ok(self.GainHigh.into_pyobject(py)?.into()),
            "GainLow" => Ok(self.GainLow.into_pyobject(py)?.into()),
            "PeakHigh" => Ok(self.PeakHigh.into_pyobject(py)?.into()),
            "PeakLow" => Ok(self.PeakLow.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "GainHigh" => self.GainHigh = value.extract::<Option<i32>>(py)?,
            "GainLow" => self.GainLow = value.extract::<Option<i32>>(py)?,
            "PeakHigh" => self.PeakHigh = value.extract::<Option<i32>>(py)?,
            "PeakLow" => self.PeakLow = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdMixerParam(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdMyTag", unsendable, get_all, set_all)]
pub struct PyDjmdMyTag {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Seq: Option<i32>,
    pub Name: Option<String>,
    pub Attribute: Option<i32>,
    pub ParentID: Option<String>,
}

impl IntoPy<PyDjmdMyTag> for DjmdMyTag {
    fn into_py(self, py: Python) -> PyResult<PyDjmdMyTag> {
        let model = PyDjmdMyTag {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Seq: self.Seq,
            Name: self.Name,
            Attribute: self.Attribute,
            ParentID: self.ParentID,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdMyTag> for DjmdMyTag {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdMyTag>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Seq: model.Seq,
            Name: model.Name.clone(),
            Attribute: model.Attribute,
            ParentID: model.ParentID.clone(),
        }
    }
}

impl PyDjmdMyTag {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Seq".to_string(),
            "Name".to_string(),
            "Attribute".to_string(),
            "ParentID".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdMyTag {
    fn __len__(&self) -> usize {
        14
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Seq" => Ok(self.Seq.into_pyobject(py)?.into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            "Attribute" => Ok(self.Attribute.into_pyobject(py)?.into()),
            "ParentID" => Ok(self.ParentID.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Seq" => self.Seq = value.extract::<Option<i32>>(py)?,
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            "Attribute" => self.Attribute = value.extract::<Option<i32>>(py)?,
            "ParentID" => self.ParentID = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdMyTag(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdSongMyTag", unsendable, get_all, set_all)]
pub struct PyDjmdSongMyTag {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub MyTagID: Option<String>,
    pub ContentID: Option<String>,
    pub TrackNo: Option<i32>,
}

impl IntoPy<PyDjmdSongMyTag> for DjmdSongMyTag {
    fn into_py(self, py: Python) -> PyResult<PyDjmdSongMyTag> {
        let model = PyDjmdSongMyTag {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            MyTagID: self.MyTagID,
            ContentID: self.ContentID,
            TrackNo: self.TrackNo,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdSongMyTag> for DjmdSongMyTag {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdSongMyTag>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            MyTagID: model.MyTagID.clone(),
            ContentID: model.ContentID.clone(),
            TrackNo: model.TrackNo,
        }
    }
}

impl PyDjmdSongMyTag {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "MyTagID".to_string(),
            "ContentID".to_string(),
            "TrackNo".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdSongMyTag {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "MyTagID" => Ok(self.MyTagID.clone().into_pyobject(py)?.into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "TrackNo" => Ok(self.TrackNo.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "MyTagID" => self.MyTagID = value.extract::<Option<String>>(py)?,
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "TrackNo" => self.TrackNo = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdSongMyTag(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdPlaylist", unsendable, get_all, set_all)]
pub struct PyDjmdPlaylist {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Seq: Option<i32>,
    pub Name: Option<String>,
    pub ImagePath: Option<String>,
    pub Attribute: Option<i32>,
    pub ParentID: Option<String>,
    pub SmartList: Option<String>,
}

impl IntoPy<PyDjmdPlaylist> for DjmdPlaylist {
    fn into_py(self, py: Python) -> PyResult<PyDjmdPlaylist> {
        let model = PyDjmdPlaylist {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Seq: self.Seq,
            Name: self.Name,
            ImagePath: self.ImagePath,
            Attribute: self.Attribute,
            ParentID: self.ParentID,
            SmartList: self.SmartList,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdPlaylist> for DjmdPlaylist {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdPlaylist>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Seq: model.Seq,
            Name: model.Name.clone(),
            ImagePath: model.ImagePath.clone(),
            Attribute: model.Attribute,
            ParentID: model.ParentID.clone(),
            SmartList: model.SmartList.clone(),
        }
    }
}

impl PyDjmdPlaylist {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Seq".to_string(),
            "Name".to_string(),
            "ImagePath".to_string(),
            "Attribute".to_string(),
            "ParentID".to_string(),
            "SmartList".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdPlaylist {
    fn __len__(&self) -> usize {
        16
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Seq" => Ok(self.Seq.into_pyobject(py)?.into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            "ImagePath" => Ok(self.ImagePath.clone().into_pyobject(py)?.into()),
            "Attribute" => Ok(self.Attribute.into_pyobject(py)?.into()),
            "ParentID" => Ok(self.ParentID.clone().into_pyobject(py)?.into()),
            "SmartList" => Ok(self.SmartList.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Seq" => self.Seq = value.extract::<Option<i32>>(py)?,
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            "ImagePath" => self.ImagePath = value.extract::<Option<String>>(py)?,
            "Attribute" => self.Attribute = value.extract::<Option<i32>>(py)?,
            "ParentID" => self.ParentID = value.extract::<Option<String>>(py)?,
            "SmartList" => self.SmartList = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdPlaylist(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdPlaylistTreeItem", unsendable, get_all, set_all)]
pub struct PyDjmdPlaylistTreeItem {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Seq: Option<i32>,
    pub Name: Option<String>,
    pub ImagePath: Option<String>,
    pub Attribute: Option<i32>,
    pub ParentID: Option<String>,
    pub SmartList: Option<String>,
    pub Children: Py<PyList>,
}

impl IntoPy<PyDjmdPlaylistTreeItem> for DjmdPlaylistTreeItem {
    fn into_py(self, py: Python) -> PyResult<PyDjmdPlaylistTreeItem> {
        let py_list = PyList::empty(py);
        for child in self.Children {
            let py_child = child.borrow().clone().into_py(py)?;
            let _ = py_list.append(py_child);
        }
        let model = PyDjmdPlaylistTreeItem {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Seq: self.Seq,
            Name: self.Name,
            ImagePath: self.ImagePath,
            Attribute: self.Attribute,
            ParentID: self.ParentID,
            SmartList: self.SmartList,
            Children: py_list.into(),
        };
        Ok(model)
    }
}

#[pyclass(name = "DjmdSongPlaylist", unsendable, get_all, set_all)]
pub struct PyDjmdSongPlaylist {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub PlaylistID: Option<String>,
    pub ContentID: Option<String>,
    pub TrackNo: Option<i32>,
}

impl IntoPy<PyDjmdSongPlaylist> for DjmdSongPlaylist {
    fn into_py(self, py: Python) -> PyResult<PyDjmdSongPlaylist> {
        let model = PyDjmdSongPlaylist {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            PlaylistID: self.PlaylistID,
            ContentID: self.ContentID,
            TrackNo: self.TrackNo,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdSongPlaylist> for DjmdSongPlaylist {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdSongPlaylist>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            PlaylistID: model.PlaylistID.clone(),
            ContentID: model.ContentID.clone(),
            TrackNo: model.TrackNo,
        }
    }
}

impl PyDjmdSongPlaylist {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "PlaylistID".to_string(),
            "ContentID".to_string(),
            "TrackNo".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdSongPlaylist {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "PlaylistID" => Ok(self.PlaylistID.clone().into_pyobject(py)?.into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "TrackNo" => Ok(self.TrackNo.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "PlaylistID" => self.PlaylistID = value.extract::<Option<String>>(py)?,
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "TrackNo" => self.TrackNo = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdSongPlaylist(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdProperty", unsendable, get_all, set_all)]
pub struct PyDjmdProperty {
    pub DBID: String,
    pub DBVersion: Option<String>,
    pub BaseDBDrive: Option<String>,
    pub CurrentDBDrive: Option<String>,
    pub DeviceID: Option<String>,
    pub Reserved1: Option<String>,
    pub Reserved2: Option<String>,
    pub Reserved3: Option<String>,
    pub Reserved4: Option<String>,
    pub Reserved5: Option<String>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
}

impl IntoPy<PyDjmdProperty> for DjmdProperty {
    fn into_py(self, py: Python) -> PyResult<PyDjmdProperty> {
        let model = PyDjmdProperty {
            DBID: self.DBID,
            DBVersion: self.DBVersion,
            BaseDBDrive: self.BaseDBDrive,
            CurrentDBDrive: self.CurrentDBDrive,
            DeviceID: self.DeviceID,
            Reserved1: self.Reserved1,
            Reserved2: self.Reserved2,
            Reserved3: self.Reserved3,
            Reserved4: self.Reserved4,
            Reserved5: self.Reserved5,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdProperty> for DjmdProperty {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdProperty>) -> Self {
        Self {
            DBID: model.DBID.clone(),
            DBVersion: model.DBVersion.clone(),
            BaseDBDrive: model.BaseDBDrive.clone(),
            CurrentDBDrive: model.CurrentDBDrive.clone(),
            DeviceID: model.DeviceID.clone(),
            Reserved1: model.Reserved1.clone(),
            Reserved2: model.Reserved2.clone(),
            Reserved3: model.Reserved3.clone(),
            Reserved4: model.Reserved4.clone(),
            Reserved5: model.Reserved5.clone(),
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
        }
    }
}

impl PyDjmdProperty {
    fn field_names() -> Vec<String> {
        vec![
            "DBID".to_string(),
            "DBVersion".to_string(),
            "BaseDBDrive".to_string(),
            "CurrentDBDrive".to_string(),
            "DeviceID".to_string(),
            "Reserved1".to_string(),
            "Reserved2".to_string(),
            "Reserved3".to_string(),
            "Reserved4".to_string(),
            "Reserved5".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdProperty {
    fn __len__(&self) -> usize {
        12
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "DBID" => Ok(self.DBID.clone().into_pyobject(py)?.into()),
            "DBVersion" => Ok(self.DBVersion.clone().into_pyobject(py)?.into()),
            "BaseDBDrive" => Ok(self.BaseDBDrive.clone().into_pyobject(py)?.into()),
            "CurrentDBDrive" => Ok(self.CurrentDBDrive.clone().into_pyobject(py)?.into()),
            "DeviceID" => Ok(self.DeviceID.clone().into_pyobject(py)?.into()),
            "Reserved1" => Ok(self.Reserved1.clone().into_pyobject(py)?.into()),
            "Reserved2" => Ok(self.Reserved2.clone().into_pyobject(py)?.into()),
            "Reserved3" => Ok(self.Reserved3.clone().into_pyobject(py)?.into()),
            "Reserved4" => Ok(self.Reserved4.clone().into_pyobject(py)?.into()),
            "Reserved5" => Ok(self.Reserved5.clone().into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "DBID" => self.DBID = value.extract::<String>(py)?,
            "DBVersion" => self.DBVersion = value.extract::<Option<String>>(py)?,
            "BaseDBDrive" => self.BaseDBDrive = value.extract::<Option<String>>(py)?,
            "CurrentDBDrive" => self.CurrentDBDrive = value.extract::<Option<String>>(py)?,
            "DeviceID" => self.DeviceID = value.extract::<Option<String>>(py)?,
            "Reserved1" => self.Reserved1 = value.extract::<Option<String>>(py)?,
            "Reserved2" => self.Reserved2 = value.extract::<Option<String>>(py)?,
            "Reserved3" => self.Reserved3 = value.extract::<Option<String>>(py)?,
            "Reserved4" => self.Reserved4 = value.extract::<Option<String>>(py)?,
            "Reserved5" => self.Reserved5 = value.extract::<Option<String>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdProperty(DBID: {})", self.DBID,))
    }
}

#[pyclass(name = "DjmdCloudProperty", unsendable, get_all, set_all)]
pub struct PyDjmdCloudProperty {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Reserved1: Option<String>,
    pub Reserved2: Option<String>,
    pub Reserved3: Option<String>,
    pub Reserved4: Option<String>,
    pub Reserved5: Option<String>,
}

impl IntoPy<PyDjmdCloudProperty> for DjmdCloudProperty {
    fn into_py(self, py: Python) -> PyResult<PyDjmdCloudProperty> {
        let model = PyDjmdCloudProperty {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Reserved1: self.Reserved1,
            Reserved2: self.Reserved2,
            Reserved3: self.Reserved3,
            Reserved4: self.Reserved4,
            Reserved5: self.Reserved5,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdCloudProperty> for DjmdCloudProperty {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdCloudProperty>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Reserved1: model.Reserved1.clone(),
            Reserved2: model.Reserved2.clone(),
            Reserved3: model.Reserved3.clone(),
            Reserved4: model.Reserved4.clone(),
            Reserved5: model.Reserved5.clone(),
        }
    }
}

impl PyDjmdCloudProperty {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Reserved1".to_string(),
            "Reserved2".to_string(),
            "Reserved3".to_string(),
            "Reserved4".to_string(),
            "Reserved5".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdCloudProperty {
    fn __len__(&self) -> usize {
        15
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Reserved1" => Ok(self.Reserved1.clone().into_pyobject(py)?.into()),
            "Reserved2" => Ok(self.Reserved2.clone().into_pyobject(py)?.into()),
            "Reserved3" => Ok(self.Reserved3.clone().into_pyobject(py)?.into()),
            "Reserved4" => Ok(self.Reserved4.clone().into_pyobject(py)?.into()),
            "Reserved5" => Ok(self.Reserved5.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Reserved1" => self.Reserved1 = value.extract::<Option<String>>(py)?,
            "Reserved2" => self.Reserved2 = value.extract::<Option<String>>(py)?,
            "Reserved3" => self.Reserved3 = value.extract::<Option<String>>(py)?,
            "Reserved4" => self.Reserved4 = value.extract::<Option<String>>(py)?,
            "Reserved5" => self.Reserved5 = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdCloudProperty(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdRecommendLike", unsendable, get_all, set_all)]
pub struct PyDjmdRecommendLike {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub ContentID1: Option<String>,
    pub ContentID2: Option<String>,
    pub LikeRate: Option<i32>,
    pub DataCreatedH: Option<i32>,
    pub DataCreatedL: Option<i32>,
}

impl IntoPy<PyDjmdRecommendLike> for DjmdRecommendLike {
    fn into_py(self, py: Python) -> PyResult<PyDjmdRecommendLike> {
        let model = PyDjmdRecommendLike {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            ContentID1: self.ContentID1,
            ContentID2: self.ContentID2,
            LikeRate: self.LikeRate,
            DataCreatedH: self.DataCreatedH,
            DataCreatedL: self.DataCreatedL,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdRecommendLike> for DjmdRecommendLike {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdRecommendLike>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            ContentID1: model.ContentID1.clone(),
            ContentID2: model.ContentID2.clone(),
            LikeRate: model.LikeRate,
            DataCreatedH: model.DataCreatedH,
            DataCreatedL: model.DataCreatedL,
        }
    }
}

impl PyDjmdRecommendLike {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "ContentID1".to_string(),
            "ContentID2".to_string(),
            "LikeRate".to_string(),
            "DataCreatedH".to_string(),
            "DataCreatedL".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdRecommendLike {
    fn __len__(&self) -> usize {
        15
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "ContentID1" => Ok(self.ContentID1.clone().into_pyobject(py)?.into()),
            "ContentID2" => Ok(self.ContentID2.clone().into_pyobject(py)?.into()),
            "LikeRate" => Ok(self.LikeRate.into_pyobject(py)?.into()),
            "DataCreatedH" => Ok(self.DataCreatedH.into_pyobject(py)?.into()),
            "DataCreatedL" => Ok(self.DataCreatedL.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "ContentID1" => self.ContentID1 = value.extract::<Option<String>>(py)?,
            "ContentID2" => self.ContentID2 = value.extract::<Option<String>>(py)?,
            "LikeRate" => self.LikeRate = value.extract::<Option<i32>>(py)?,
            "DataCreatedH" => self.DataCreatedH = value.extract::<Option<i32>>(py)?,
            "DataCreatedL" => self.DataCreatedL = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdRecommendLike(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdRelatedTracks", unsendable, get_all, set_all)]
pub struct PyDjmdRelatedTracks {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Seq: Option<i32>,
    pub Name: Option<String>,
    pub Attribute: Option<i32>,
    pub ParentID: Option<String>,
    pub Criteria: Option<String>,
}

impl IntoPy<PyDjmdRelatedTracks> for DjmdRelatedTracks {
    fn into_py(self, py: Python) -> PyResult<PyDjmdRelatedTracks> {
        let model = PyDjmdRelatedTracks {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Seq: self.Seq,
            Name: self.Name,
            Attribute: self.Attribute,
            ParentID: self.ParentID,
            Criteria: self.Criteria,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdRelatedTracks> for DjmdRelatedTracks {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdRelatedTracks>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Seq: model.Seq,
            Name: model.Name.clone(),
            Attribute: model.Attribute,
            ParentID: model.ParentID.clone(),
            Criteria: model.Criteria.clone(),
        }
    }
}

impl PyDjmdRelatedTracks {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Seq".to_string(),
            "Name".to_string(),
            "Attribute".to_string(),
            "ParentID".to_string(),
            "Criteria".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdRelatedTracks {
    fn __len__(&self) -> usize {
        15
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Seq" => Ok(self.Seq.into_pyobject(py)?.into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            "Attribute" => Ok(self.Attribute.into_pyobject(py)?.into()),
            "ParentID" => Ok(self.ParentID.clone().into_pyobject(py)?.into()),
            "Criteria" => Ok(self.Criteria.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Seq" => self.Seq = value.extract::<Option<i32>>(py)?,
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            "Attribute" => self.Attribute = value.extract::<Option<i32>>(py)?,
            "ParentID" => self.ParentID = value.extract::<Option<String>>(py)?,
            "Criteria" => self.Criteria = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdRelatedTracks(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdSongRelatedTracks", unsendable, get_all, set_all)]
pub struct PyDjmdSongRelatedTracks {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub RelatedTracksID: Option<String>,
    pub ContentID: Option<String>,
    pub TrackNo: Option<i32>,
}

impl IntoPy<PyDjmdSongRelatedTracks> for DjmdSongRelatedTracks {
    fn into_py(self, py: Python) -> PyResult<PyDjmdSongRelatedTracks> {
        let model = PyDjmdSongRelatedTracks {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            RelatedTracksID: self.RelatedTracksID,
            ContentID: self.ContentID,
            TrackNo: self.TrackNo,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdSongRelatedTracks> for DjmdSongRelatedTracks {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdSongRelatedTracks>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            RelatedTracksID: model.RelatedTracksID.clone(),
            ContentID: model.ContentID.clone(),
            TrackNo: model.TrackNo,
        }
    }
}

impl PyDjmdSongRelatedTracks {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "RelatedTracksID".to_string(),
            "ContentID".to_string(),
            "TrackNo".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdSongRelatedTracks {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "RelatedTracksID" => Ok(self.RelatedTracksID.clone().into_pyobject(py)?.into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "TrackNo" => Ok(self.TrackNo.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "RelatedTracksID" => self.RelatedTracksID = value.extract::<Option<String>>(py)?,
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "TrackNo" => self.TrackNo = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdSongRelatedTracks(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdSampler", unsendable, get_all, set_all)]
pub struct PyDjmdSampler {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Seq: Option<i32>,
    pub Name: Option<String>,
    pub Attribute: Option<i32>,
    pub ParentID: Option<String>,
}

impl IntoPy<PyDjmdSampler> for DjmdSampler {
    fn into_py(self, py: Python) -> PyResult<PyDjmdSampler> {
        let model = PyDjmdSampler {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Seq: self.Seq,
            Name: self.Name,
            Attribute: self.Attribute,
            ParentID: self.ParentID,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdSampler> for DjmdSampler {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdSampler>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Seq: model.Seq,
            Name: model.Name.clone(),
            Attribute: model.Attribute,
            ParentID: model.ParentID.clone(),
        }
    }
}

impl PyDjmdSampler {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Seq".to_string(),
            "Name".to_string(),
            "Attribute".to_string(),
            "ParentID".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdSampler {
    fn __len__(&self) -> usize {
        14
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Seq" => Ok(self.Seq.into_pyobject(py)?.into()),
            "Name" => Ok(self.Name.clone().into_pyobject(py)?.into()),
            "Attribute" => Ok(self.Attribute.into_pyobject(py)?.into()),
            "ParentID" => Ok(self.ParentID.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Seq" => self.Seq = value.extract::<Option<i32>>(py)?,
            "Name" => self.Name = value.extract::<Option<String>>(py)?,
            "Attribute" => self.Attribute = value.extract::<Option<i32>>(py)?,
            "ParentID" => self.ParentID = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdSampler(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdSongSampler", unsendable, get_all, set_all)]
pub struct PyDjmdSongSampler {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub SamplerID: Option<String>,
    pub ContentID: Option<String>,
    pub TrackNo: Option<i32>,
}

impl IntoPy<PyDjmdSongSampler> for DjmdSongSampler {
    fn into_py(self, py: Python) -> PyResult<PyDjmdSongSampler> {
        let model = PyDjmdSongSampler {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            SamplerID: self.SamplerID,
            ContentID: self.ContentID,
            TrackNo: self.TrackNo,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdSongSampler> for DjmdSongSampler {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdSongSampler>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            SamplerID: model.SamplerID.clone(),
            ContentID: model.ContentID.clone(),
            TrackNo: model.TrackNo,
        }
    }
}

impl PyDjmdSongSampler {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "SamplerID".to_string(),
            "ContentID".to_string(),
            "TrackNo".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdSongSampler {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "SamplerID" => Ok(self.SamplerID.clone().into_pyobject(py)?.into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "TrackNo" => Ok(self.TrackNo.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "SamplerID" => self.SamplerID = value.extract::<Option<String>>(py)?,
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "TrackNo" => self.TrackNo = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdSongSampler(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdSongTagList", unsendable, get_all, set_all)]
pub struct PyDjmdSongTagList {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub ContentID: Option<String>,
    pub TrackNo: Option<i32>,
}

impl IntoPy<PyDjmdSongTagList> for DjmdSongTagList {
    fn into_py(self, py: Python) -> PyResult<PyDjmdSongTagList> {
        let model = PyDjmdSongTagList {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            ContentID: self.ContentID,
            TrackNo: self.TrackNo,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdSongTagList> for DjmdSongTagList {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdSongTagList>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            ContentID: model.ContentID.clone(),
            TrackNo: model.TrackNo,
        }
    }
}

impl PyDjmdSongTagList {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "ContentID".to_string(),
            "TrackNo".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdSongTagList {
    fn __len__(&self) -> usize {
        12
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "ContentID" => Ok(self.ContentID.clone().into_pyobject(py)?.into()),
            "TrackNo" => Ok(self.TrackNo.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "ContentID" => self.ContentID = value.extract::<Option<String>>(py)?,
            "TrackNo" => self.TrackNo = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdSongTagList(ID: {})", self.ID,))
    }
}

#[pyclass(name = "DjmdSort", unsendable, get_all, set_all)]
pub struct PyDjmdSort {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub MenuItemID: Option<String>,
    pub Seq: Option<i32>,
    pub Disable: Option<i32>,
}

impl IntoPy<PyDjmdSort> for DjmdSort {
    fn into_py(self, py: Python) -> PyResult<PyDjmdSort> {
        let model = PyDjmdSort {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            MenuItemID: self.MenuItemID,
            Seq: self.Seq,
            Disable: self.Disable,
        };
        Ok(model)
    }
}

impl FromPy<PyDjmdSort> for DjmdSort {
    fn from_py(py: Python, model: PyRef<'_, PyDjmdSort>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            MenuItemID: model.MenuItemID.clone(),
            Seq: model.Seq,
            Disable: model.Disable,
        }
    }
}

impl PyDjmdSort {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "MenuItemID".to_string(),
            "Seq".to_string(),
            "Disable".to_string(),
        ]
    }
}

#[pymethods]
impl PyDjmdSort {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "MenuItemID" => Ok(self.MenuItemID.clone().into_pyobject(py)?.into()),
            "Seq" => Ok(self.Seq.into_pyobject(py)?.into()),
            "Disable" => Ok(self.Disable.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "MenuItemID" => self.MenuItemID = value.extract::<Option<String>>(py)?,
            "Seq" => self.Seq = value.extract::<Option<i32>>(py)?,
            "Disable" => self.Disable = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("DjmdSort(ID: {})", self.ID,))
    }
}

#[pyclass(name = "ImageFile", unsendable, get_all, set_all)]
pub struct PyImageFile {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub TableName: Option<String>,
    pub TargetUUID: Option<String>,
    pub TargetID: Option<String>,
    pub Path: Option<String>,
    pub Hash: Option<String>,
    pub Size: Option<i32>,
    pub rb_local_path: Option<String>,
    pub rb_insync_hash: Option<String>,
    pub rb_insync_local_usn: Option<i32>,
    pub rb_file_hash_dirty: Option<i32>,
    pub rb_local_file_status: Option<i32>,
    pub rb_in_progress: Option<i32>,
    pub rb_process_type: Option<i32>,
    pub rb_temp_path: Option<String>,
    pub rb_priority: Option<i32>,
    pub rb_file_size_dirty: Option<i32>,
}

impl IntoPy<PyImageFile> for ImageFile {
    fn into_py(self, py: Python) -> PyResult<PyImageFile> {
        let model = PyImageFile {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            TableName: self.TableName,
            TargetUUID: self.TargetUUID,
            TargetID: self.TargetID,
            Path: self.Path,
            Hash: self.Hash,
            Size: self.Size,
            rb_local_path: self.rb_local_path,
            rb_insync_hash: self.rb_insync_hash,
            rb_insync_local_usn: self.rb_insync_local_usn,
            rb_file_hash_dirty: self.rb_file_hash_dirty,
            rb_local_file_status: self.rb_local_file_status,
            rb_in_progress: self.rb_in_progress,
            rb_process_type: self.rb_process_type,
            rb_temp_path: self.rb_temp_path,
            rb_priority: self.rb_priority,
            rb_file_size_dirty: self.rb_file_size_dirty,
        };
        Ok(model)
    }
}

impl FromPy<PyImageFile> for ImageFile {
    fn from_py(py: Python, model: PyRef<'_, PyImageFile>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            TableName: model.TableName.clone(),
            TargetUUID: model.TargetUUID.clone(),
            TargetID: model.TargetID.clone(),
            Path: model.Path.clone(),
            Hash: model.Hash.clone(),
            Size: model.Size,
            rb_local_path: model.rb_local_path.clone(),
            rb_insync_hash: model.rb_insync_hash.clone(),
            rb_insync_local_usn: model.rb_insync_local_usn,
            rb_file_hash_dirty: model.rb_file_hash_dirty,
            rb_local_file_status: model.rb_local_file_status,
            rb_in_progress: model.rb_in_progress,
            rb_process_type: model.rb_process_type,
            rb_temp_path: model.rb_temp_path.clone(),
            rb_priority: model.rb_priority,
            rb_file_size_dirty: model.rb_file_size_dirty,
        }
    }
}

impl PyImageFile {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "TableName".to_string(),
            "TargetUUID".to_string(),
            "TargetID".to_string(),
            "Path".to_string(),
            "Hash".to_string(),
            "Size".to_string(),
            "rb_local_path".to_string(),
            "rb_insync_hash".to_string(),
            "rb_insync_local_usn".to_string(),
            "rb_file_hash_dirty".to_string(),
            "rb_local_file_status".to_string(),
            "rb_in_progress".to_string(),
            "rb_process_type".to_string(),
            "rb_temp_path".to_string(),
            "rb_priority".to_string(),
            "rb_file_size_dirty".to_string(),
        ]
    }
}

#[pymethods]
impl PyImageFile {
    fn __len__(&self) -> usize {
        26
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "TableName" => Ok(self.TableName.clone().into_pyobject(py)?.into()),
            "TargetUUID" => Ok(self.TargetUUID.clone().into_pyobject(py)?.into()),
            "TargetID" => Ok(self.TargetID.clone().into_pyobject(py)?.into()),
            "Path" => Ok(self.Path.clone().into_pyobject(py)?.into()),
            "Hash" => Ok(self.Hash.clone().into_pyobject(py)?.into()),
            "Size" => Ok(self.Size.into_pyobject(py)?.into()),
            "rb_local_path" => Ok(self.rb_local_path.clone().into_pyobject(py)?.into()),
            "rb_insync_hash" => Ok(self.rb_insync_hash.clone().into_pyobject(py)?.into()),
            "rb_insync_local_usn" => Ok(self.rb_insync_local_usn.into_pyobject(py)?.into()),
            "rb_file_hash_dirty" => Ok(self.rb_file_hash_dirty.into_pyobject(py)?.into()),
            "rb_local_file_status" => Ok(self.rb_local_file_status.into_pyobject(py)?.into()),
            "rb_in_progress" => Ok(self.rb_in_progress.into_pyobject(py)?.into()),
            "rb_process_type" => Ok(self.rb_process_type.into_pyobject(py)?.into()),
            "rb_temp_path" => Ok(self.rb_temp_path.clone().into_pyobject(py)?.into()),
            "rb_priority" => Ok(self.rb_priority.into_pyobject(py)?.into()),
            "rb_file_size_dirty" => Ok(self.rb_file_size_dirty.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "TableName" => self.TableName = value.extract::<Option<String>>(py)?,
            "TargetUUID" => self.TargetUUID = value.extract::<Option<String>>(py)?,
            "TargetID" => self.TargetID = value.extract::<Option<String>>(py)?,
            "Path" => self.Path = value.extract::<Option<String>>(py)?,
            "Hash" => self.Hash = value.extract::<Option<String>>(py)?,
            "Size" => self.Size = value.extract::<Option<i32>>(py)?,
            "rb_local_path" => self.rb_local_path = value.extract::<Option<String>>(py)?,
            "rb_insync_hash" => self.rb_insync_hash = value.extract::<Option<String>>(py)?,
            "rb_insync_local_usn" => self.rb_insync_local_usn = value.extract::<Option<i32>>(py)?,
            "rb_file_hash_dirty" => self.rb_file_hash_dirty = value.extract::<Option<i32>>(py)?,
            "rb_local_file_status" => {
                self.rb_local_file_status = value.extract::<Option<i32>>(py)?
            }
            "rb_in_progress" => self.rb_in_progress = value.extract::<Option<i32>>(py)?,
            "rb_process_type" => self.rb_process_type = value.extract::<Option<i32>>(py)?,
            "rb_temp_path" => self.rb_temp_path = value.extract::<Option<String>>(py)?,
            "rb_priority" => self.rb_priority = value.extract::<Option<i32>>(py)?,
            "rb_file_size_dirty" => self.rb_file_size_dirty = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("ImageFile(ID: {})", self.ID,))
    }
}

#[pyclass(name = "SettingFile", unsendable, get_all, set_all)]
pub struct PySettingFile {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub Path: Option<String>,
    pub Hash: Option<String>,
    pub Size: Option<i32>,
    pub rb_local_path: Option<String>,
    pub rb_insync_hash: Option<String>,
    pub rb_insync_local_usn: Option<i32>,
    pub rb_file_hash_dirty: Option<i32>,
    pub rb_file_size_dirty: Option<i32>,
}

impl IntoPy<PySettingFile> for SettingFile {
    fn into_py(self, py: Python) -> PyResult<PySettingFile> {
        let model = PySettingFile {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            Path: self.Path,
            Hash: self.Hash,
            Size: self.Size,
            rb_local_path: self.rb_local_path,
            rb_insync_hash: self.rb_insync_hash,
            rb_insync_local_usn: self.rb_insync_local_usn,
            rb_file_hash_dirty: self.rb_file_hash_dirty,
            rb_file_size_dirty: self.rb_file_size_dirty,
        };
        Ok(model)
    }
}

impl FromPy<PySettingFile> for SettingFile {
    fn from_py(py: Python, model: PyRef<'_, PySettingFile>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            Path: model.Path.clone(),
            Hash: model.Hash.clone(),
            Size: model.Size,
            rb_local_path: model.rb_local_path.clone(),
            rb_insync_hash: model.rb_insync_hash.clone(),
            rb_insync_local_usn: model.rb_insync_local_usn,
            rb_file_hash_dirty: model.rb_file_hash_dirty,
            rb_file_size_dirty: model.rb_file_size_dirty,
        }
    }
}

impl PySettingFile {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "Path".to_string(),
            "Hash".to_string(),
            "Size".to_string(),
            "rb_local_path".to_string(),
            "rb_insync_hash".to_string(),
            "rb_insync_local_usn".to_string(),
            "rb_file_hash_dirty".to_string(),
            "rb_file_size_dirty".to_string(),
        ]
    }
}

#[pymethods]
impl PySettingFile {
    fn __len__(&self) -> usize {
        18
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "Path" => Ok(self.Path.clone().into_pyobject(py)?.into()),
            "Hash" => Ok(self.Hash.clone().into_pyobject(py)?.into()),
            "Size" => Ok(self.Size.into_pyobject(py)?.into()),
            "rb_local_path" => Ok(self.rb_local_path.clone().into_pyobject(py)?.into()),
            "rb_insync_hash" => Ok(self.rb_insync_hash.clone().into_pyobject(py)?.into()),
            "rb_insync_local_usn" => Ok(self.rb_insync_local_usn.into_pyobject(py)?.into()),
            "rb_file_hash_dirty" => Ok(self.rb_file_hash_dirty.into_pyobject(py)?.into()),
            "rb_file_size_dirty" => Ok(self.rb_file_size_dirty.into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "Path" => self.Path = value.extract::<Option<String>>(py)?,
            "Hash" => self.Hash = value.extract::<Option<String>>(py)?,
            "Size" => self.Size = value.extract::<Option<i32>>(py)?,
            "rb_local_path" => self.rb_local_path = value.extract::<Option<String>>(py)?,
            "rb_insync_hash" => self.rb_insync_hash = value.extract::<Option<String>>(py)?,
            "rb_insync_local_usn" => self.rb_insync_local_usn = value.extract::<Option<i32>>(py)?,
            "rb_file_hash_dirty" => self.rb_file_hash_dirty = value.extract::<Option<i32>>(py)?,
            "rb_file_size_dirty" => self.rb_file_size_dirty = value.extract::<Option<i32>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("SettingFile(ID: {})", self.ID,))
    }
}

#[pyclass(name = "UuidIDMap", unsendable, get_all, set_all)]
pub struct PyUuidIDMap {
    pub ID: String,
    pub UUID: String,
    pub rb_data_status: i32,
    pub rb_local_data_status: i32,
    pub rb_local_deleted: i32,
    pub rb_local_synced: i32,
    pub usn: Option<i32>,
    pub rb_local_usn: Option<i32>,
    pub created_at: Py<PyDateTime>,
    pub updated_at: Py<PyDateTime>,
    pub TableName: Option<String>,
    pub TargetUUID: Option<String>,
    pub CurrentID: Option<String>,
}

impl IntoPy<PyUuidIDMap> for UuidIDMap {
    fn into_py(self, py: Python) -> PyResult<PyUuidIDMap> {
        let model = PyUuidIDMap {
            ID: self.ID,
            UUID: self.UUID,
            rb_data_status: self.rb_data_status,
            rb_local_data_status: self.rb_local_data_status,
            rb_local_deleted: self.rb_local_deleted,
            rb_local_synced: self.rb_local_synced,
            usn: self.usn,
            rb_local_usn: self.rb_local_usn,
            created_at: self.created_at.into_pyobject(py)?.into(),
            updated_at: self.updated_at.into_pyobject(py)?.into(),
            TableName: self.TableName,
            TargetUUID: self.TargetUUID,
            CurrentID: self.CurrentID,
        };
        Ok(model)
    }
}

impl FromPy<PyUuidIDMap> for UuidIDMap {
    fn from_py(py: Python, model: PyRef<'_, PyUuidIDMap>) -> Self {
        Self {
            ID: model.ID.clone(),
            UUID: model.UUID.clone(),
            rb_data_status: model.rb_data_status,
            rb_local_data_status: model.rb_local_data_status,
            rb_local_deleted: model.rb_local_deleted,
            rb_local_synced: model.rb_local_synced,
            usn: model.usn,
            rb_local_usn: model.rb_local_usn,
            created_at: model.created_at.extract::<DateTime<Utc>>(py).unwrap(),
            updated_at: model.updated_at.extract::<DateTime<Utc>>(py).unwrap(),
            TableName: model.TableName.clone(),
            TargetUUID: model.TargetUUID.clone(),
            CurrentID: model.CurrentID.clone(),
        }
    }
}

impl PyUuidIDMap {
    fn field_names() -> Vec<String> {
        vec![
            "ID".to_string(),
            "UUID".to_string(),
            "rb_data_status".to_string(),
            "rb_local_data_status".to_string(),
            "rb_local_deleted".to_string(),
            "rb_local_synced".to_string(),
            "usn".to_string(),
            "rb_local_usn".to_string(),
            "created_at".to_string(),
            "updated_at".to_string(),
            "TableName".to_string(),
            "TargetUUID".to_string(),
            "CurrentID".to_string(),
        ]
    }
}

#[pymethods]
impl PyUuidIDMap {
    fn __len__(&self) -> usize {
        13
    }

    fn __iter__(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        let iter = PyStrIter::new(Self::field_names());
        Py::new(py, iter)
    }

    fn __getitem__(&self, py: Python, key: &str) -> PyResult<PyObject> {
        match key {
            "ID" => Ok(self.ID.clone().into_pyobject(py)?.into()),
            "UUID" => Ok(self.UUID.clone().into_pyobject(py)?.into()),
            "rb_data_status" => Ok(self.rb_data_status.into_pyobject(py)?.into()),
            "rb_local_data_status" => Ok(self.rb_local_data_status.into_pyobject(py)?.into()),
            "rb_local_deleted" => Ok(self.rb_local_deleted.into_pyobject(py)?.into()),
            "rb_local_synced" => Ok(self.rb_local_synced.into_pyobject(py)?.into()),
            "usn" => Ok(self.usn.into_pyobject(py)?.into()),
            "rb_local_usn" => Ok(self.rb_local_usn.into_pyobject(py)?.into()),
            "created_at" => Ok(self.created_at.clone_ref(py).into()),
            "updated_at" => Ok(self.updated_at.clone_ref(py).into()),
            "TableName" => Ok(self.TableName.clone().into_pyobject(py)?.into()),
            "TargetUUID" => Ok(self.TargetUUID.clone().into_pyobject(py)?.into()),
            "CurrentID" => Ok(self.CurrentID.clone().into_pyobject(py)?.into()),
            _ => Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                "Key '{}' not found",
                key
            ))),
        }
    }

    fn __setitem__(&mut self, py: Python, key: &str, value: PyObject) -> PyResult<()> {
        match key {
            "ID" => self.ID = value.extract::<String>(py)?,
            "UUID" => self.UUID = value.extract::<String>(py)?,
            "rb_data_status" => self.rb_data_status = value.extract::<i32>(py)?,
            "rb_local_data_status" => self.rb_local_data_status = value.extract::<i32>(py)?,
            "rb_local_deleted" => self.rb_local_deleted = value.extract::<i32>(py)?,
            "rb_local_synced" => self.rb_local_synced = value.extract::<i32>(py)?,
            "usn" => self.usn = value.extract::<Option<i32>>(py)?,
            "rb_local_usn" => self.rb_local_usn = value.extract::<Option<i32>>(py)?,
            "created_at" => self.created_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "updated_at" => self.updated_at = value.extract::<Py<PyDateTime>>(py).unwrap(),
            "TableName" => self.TableName = value.extract::<Option<String>>(py)?,
            "TargetUUID" => self.TargetUUID = value.extract::<Option<String>>(py)?,
            "CurrentID" => self.CurrentID = value.extract::<Option<String>>(py)?,
            _ => {
                return Err(PyErr::new::<pyo3::exceptions::PyKeyError, _>(format!(
                    "Key '{}' not found",
                    key
                )))
            }
        }
        Ok(())
    }

    fn keys(&self, py: Python) -> PyResult<Py<PyStrIter>> {
        self.__iter__(py)
    }

    fn values(&self, py: Python) -> PyResult<Py<PyObjectIter>> {
        let mut values: Vec<PyObject> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push(value);
        }
        let iter = PyObjectIter::new(values);
        Py::new(py, iter)
    }

    fn items(&self, py: Python) -> PyResult<Py<PyItemsIter>> {
        let mut values: Vec<(String, PyObject)> = Vec::new();
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            values.push((key, value));
        }
        let iter = PyItemsIter::new(values);
        Py::new(py, iter)
    }

    fn get(&self, py: Python, key: &str, default: PyObject) -> PyResult<PyObject> {
        let res = self.__getitem__(py, key);
        if let Ok(res) = res {
            Ok(res)
        } else {
            Ok(default)
        }
    }

    fn update(&mut self, py: Python, data: HashMap<String, PyObject>) -> PyResult<()> {
        for (key, py_value) in data.into_iter() {
            let _ = self.__setitem__(py, &key, py_value);
        }
        Ok(())
    }

    fn to_dict(&self, py: Python) -> PyResult<Py<PyDict>> {
        let dict = PyDict::new(py);
        for key in Self::field_names() {
            let value = self.__getitem__(py, &key)?;
            dict.set_item(key, value)?;
        }
        Ok(dict.into())
    }

    fn __repr__(&self) -> PyResult<String> {
        Ok(format!("UuidIDMap(ID: {})", self.ID,))
    }
}
