# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.3.0] - 2025-01-28

### Performance
- **CRITICAL FIX**: Resolved major performance bottleneck in multiprocessing
  - Changed `process_single_file` methods from instance methods to static methods
  - Eliminated serialization overhead of entire analyzer objects during parallel processing
  - **Performance improvement: 10-20x faster on large datasets**
  - Processing 521 files now takes ~1.4 seconds (previously could take 1+ hour for larger datasets)

### Changed
- `BenignwareAnalyzer.process_single_file` is now a static method
- `MalwareAnalyzer.process_single_file` is now a static method with `binary_base_path` parameter
- `BaseAnalyzer.analyze_files` uses reflection to detect method signature and pass appropriate parameters

### Technical Details
- Old implementation serialized entire `self` object (including `file_list` with thousands of paths) for each multiprocessing task
- New implementation only serializes function reference and file path string
- Maintains pyelftools for ELF parsing (no change to analysis logic)

## [0.2.1] - 2024-12-XX

### Changed
- Package renamed from `dataset_labeler` to `pyelflabeler`
- Repository URL updated to reflect new package name
- Updated documentation and metadata

## [0.2.0] - 2024-12-XX

### Added
- Modular architecture with separation of concerns
- Factory pattern for analyzer creation
- Abstract base class for easy extension
- Modern Python tooling (uv, pyproject.toml)

### Changed
- Refactored from single `label.py` file to modular structure
- Improved code organization and maintainability

## [0.1.0] - Initial Release

### Added
- Dual mode operation (malware/benignware)
- ELF binary analysis
- Packer detection with DiE
- Malware family classification with AVClass
- Multi-process parallel processing
- Progress tracking with tqdm
