# coding: utf-8

# flake8: noqa

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "1.2.0"

# Define package exports
__all__ = [
    "AppsApi",
    "ArchivesApi",
    "CatalogDatacentersApi",
    "CatalogInstanceUsageApi",
    "CatalogInstancesApi",
    "CatalogRegionsApi",
    "ComposeApi",
    "CouponsApi",
    "CredentialsApi",
    "DeploymentsApi",
    "DockerHelperApi",
    "DomainsApi",
    "InstancesApi",
    "IntercomApi",
    "LogsApi",
    "MetricsApi",
    "OrganizationConfirmationsApi",
    "OrganizationInvitationsApi",
    "OrganizationMembersApi",
    "OrganizationQuotasApi",
    "PaymentMethodsApi",
    "PersistentVolumesApi",
    "ProfileApi",
    "ProvisioningApi",
    "QuotasApi",
    "RegionalDeploymentsApi",
    "RepositoriesApi",
    "SearchApi",
    "SecretsApi",
    "ServicesApi",
    "SessionsApi",
    "SnapshotsApi",
    "SubscriptionsApi",
    "SummaryApi",
    "UsagesApi",
    "UsersApi",
    "ActivityApi",
    "BillingApi",
    "InviteApi",
    "OrganizationApi",
    "SsoApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "AcceptOrganizationInvitationReply",
    "Action",
    "Activity",
    "ActivityList",
    "App",
    "AppEvent",
    "AppListItem",
    "AppStatus",
    "AppUsage",
    "AppsSummary",
    "Archive",
    "ArchiveDeploymentMetadata",
    "ArchiveSource",
    "AutoRelease",
    "AutoReleaseGroup",
    "AutocompleteReply",
    "AutocompleteRequest",
    "AvailabilityLevel",
    "AzureContainerRegistryConfiguration",
    "Budget",
    "BuildpackBuilder",
    "CannyAuthReply",
    "CatalogGPUDetails",
    "CatalogInstance",
    "CatalogInstanceListItem",
    "CatalogUsage",
    "ClearIdenfyVerificationResultRequest",
    "ComposeReply",
    "ConfigFile",
    "ConfirmPaymentAuthorizationReply",
    "CreateAccessTokenReply",
    "CreateAccessTokenRequest",
    "CreateAccountRequest",
    "CreateApp",
    "CreateAppReply",
    "CreateArchive",
    "CreateArchiveReply",
    "CreateBudgetReply",
    "CreateCompose",
    "CreateCredential",
    "CreateCredentialReply",
    "CreateDomain",
    "CreateDomainReply",
    "CreateOrganizationInvitationReply",
    "CreateOrganizationInvitationRequest",
    "CreateOrganizationReply",
    "CreateOrganizationRequest",
    "CreatePaymentAuthorizationReply",
    "CreatePersistentVolumeReply",
    "CreatePersistentVolumeRequest",
    "CreateSecret",
    "CreateSecretReply",
    "CreateService",
    "CreateServiceReply",
    "CreateSnapshotReply",
    "CreateSnapshotRequest",
    "CreateStageAttemptRequest",
    "Credential",
    "CredentialType",
    "DatabaseDeploymentMetadata",
    "DatabaseRolePassword",
    "DatabaseSource",
    "DatabaseUsage",
    "DatabaseUsageDetails",
    "DatacenterListItem",
    "DeactivateOrganizationReply",
    "DeactivateOrganizationRequest",
    "DeclareStageProgressRequest",
    "DeclareStepProgressRequest",
    "DeclineOrganizationInvitationReply",
    "DeleteOrganizationReply",
    "DeletePersistentVolumeReply",
    "DeleteSnapshotReply",
    "DeleteUserReply",
    "Deployment",
    "DeploymentDatabaseInfo",
    "DeploymentDefinition",
    "DeploymentDefinitionType",
    "DeploymentEnv",
    "DeploymentEvent",
    "DeploymentHealthCheck",
    "DeploymentInstanceType",
    "DeploymentListItem",
    "DeploymentMetadata",
    "DeploymentNeonPostgresDatabaseInfo",
    "DeploymentNeonPostgresDatabaseInfoRole",
    "DeploymentPort",
    "DeploymentProvisioningInfo",
    "DeploymentProvisioningInfoStage",
    "DeploymentProvisioningInfoStageBuildAttempt",
    "DeploymentProvisioningInfoStageBuildAttemptBuildStep",
    "DeploymentProvisioningInfoStageStatus",
    "DeploymentProxyPort",
    "DeploymentProxyPortMetadata",
    "DeploymentRole",
    "DeploymentRoute",
    "DeploymentScaling",
    "DeploymentScalingTarget",
    "DeploymentScalingTargetAverageCPU",
    "DeploymentScalingTargetAverageMem",
    "DeploymentScalingTargetConcurrentRequests",
    "DeploymentScalingTargetRequestsPerSecond",
    "DeploymentScalingTargetRequestsResponseTime",
    "DeploymentScalingTargetSleepIdleDelay",
    "DeploymentStatus",
    "DeploymentStrategy",
    "DeploymentStrategyType",
    "DeploymentVolume",
    "DesiredDeployment",
    "DesiredDeploymentGroup",
    "DigitalOceanRegistryConfiguration",
    "DiscourseAuthReply",
    "DiscourseAuthRequest",
    "DockerBuilder",
    "DockerHubRegistryConfiguration",
    "DockerSource",
    "Domain",
    "DomainLoadBalancerKoyeb",
    "DomainLoadBalancerQuotas",
    "DomainStatus",
    "DomainType",
    "DomainsSummary",
    "Env",
    "Error",
    "ErrorField",
    "ErrorWithFields",
    "ExecCommandIO",
    "ExecCommandReply",
    "ExecCommandRequestBody",
    "ExecCommandRequestIdType",
    "ExecCommandRequestTerminalSize",
    "GCPContainerRegistryConfiguration",
    "GetAppReply",
    "GetBudgetReply",
    "GetCatalogInstanceReply",
    "GetCredentialReply",
    "GetDeploymentReply",
    "GetDeploymentScalingReply",
    "GetDeploymentScalingReplyItem",
    "GetDomainReply",
    "GetGithubInstallationReply",
    "GetIdenfyTokenReply",
    "GetInstanceReply",
    "GetIntercomProfileReply",
    "GetMetricsReply",
    "GetMetricsReplyMetric",
    "GetOAuthOptionsReply",
    "GetOrganizationInvitationReply",
    "GetOrganizationReply",
    "GetOrganizationSummaryReply",
    "GetOrganizationUsageDetailsReply",
    "GetOrganizationUsageReply",
    "GetPaymentMethodReply",
    "GetPersistentVolumeReply",
    "GetQuotasReply",
    "GetRegionReply",
    "GetRegionalDeploymentReply",
    "GetSecretReply",
    "GetServiceReply",
    "GetSnapshotReply",
    "GetSubscriptionReply",
    "GetUserOrganizationInvitationReply",
    "GetUserSettingsReply",
    "GitDeploymentMetadata",
    "GitEnvDeploymentMetadata",
    "GitHubRegistryConfiguration",
    "GitLabRegistryConfiguration",
    "GitSource",
    "GithubInstallationReply",
    "GithubInstallationRequest",
    "GoogleProtobufAny",
    "GoogleProtobufNullValue",
    "GoogleRpcStatus",
    "HTTPHeader",
    "HTTPHealthCheck",
    "HasUnpaidInvoicesReply",
    "Instance",
    "InstanceAvailability",
    "InstanceEvent",
    "InstanceListItem",
    "InstanceStatus",
    "InstanceUsage",
    "InstancesSummary",
    "InviteUserRequest",
    "KgitproxyBranch",
    "KgitproxyGitHubRepository",
    "KgitproxyGithubInstallationStatus",
    "KgitproxyIndexingStatus",
    "KgitproxyListBranchesReply",
    "KgitproxyListRepositoriesReply",
    "KgitproxyRepository",
    "KgitproxyRepositoryProvider",
    "KsearchApp",
    "KsearchGlobalDeployment",
    "KsearchInstance",
    "KsearchOrganization",
    "KsearchRegionalDeployment",
    "KsearchSearchReply",
    "KsearchService",
    "KsearchUser",
    "ListAppEventsReply",
    "ListAppsReply",
    "ListCatalogInstancesReply",
    "ListCredentialsReply",
    "ListDatacentersReply",
    "ListDeploymentEventsReply",
    "ListDeploymentsReply",
    "ListDomainsReply",
    "ListInstanceEventsReply",
    "ListInstancesReply",
    "ListOrganizationInvitationsReply",
    "ListOrganizationMembersReply",
    "ListPaymentMethodsReply",
    "ListPersistentVolumeEventsReply",
    "ListPersistentVolumesReply",
    "ListRegionalDeploymentEventsReply",
    "ListRegionalDeploymentsReply",
    "ListRegionsReply",
    "ListSecretsReply",
    "ListServiceEventsReply",
    "ListServicesReply",
    "ListSnapshotsReply",
    "ListUsageReply",
    "ListUserOrganizationInvitationsReply",
    "ListUserOrganizationsReply",
    "LogEntry",
    "LoginMethodReply",
    "LoginMethodReplyMethod",
    "LoginReply",
    "LoginRequest",
    "ManageReply",
    "MembersSummary",
    "MetricName",
    "NeonPostgresDatabase",
    "NeonPostgresDatabaseDeploymentMetadata",
    "NeonPostgresDatabaseNeonDatabase",
    "NeonPostgresDatabaseNeonRole",
    "NeonPostgresSummary",
    "NextInvoiceReply",
    "NextInvoiceReplyDiscount",
    "NextInvoiceReplyDiscountType",
    "NextInvoiceReplyLine",
    "NextInvoiceReplyLinePeriod",
    "NextInvoiceReplyLinePrice",
    "Notification",
    "NotificationList",
    "OAuthCallbackReply",
    "OAuthCallbackRequest",
    "OAuthProvider",
    "Object",
    "Organization",
    "OrganizationDeactivationReason",
    "OrganizationDetailedStatus",
    "OrganizationInvitation",
    "OrganizationInvitationStatus",
    "OrganizationMember",
    "OrganizationMemberStatus",
    "OrganizationStatus",
    "OrganizationSummary",
    "PaymentMethod",
    "PaymentMethodStatus",
    "PeriodUsage",
    "PersistentVolume",
    "PersistentVolumeBackingStore",
    "PersistentVolumeEvent",
    "PersistentVolumeQuotas",
    "PersistentVolumeStatus",
    "Plan",
    "Port",
    "PrivateRegistryConfiguration",
    "ProxyPortProtocol",
    "PublicOrganization",
    "PublicUser",
    "QueryLogsReply",
    "QueryLogsReplyPagination",
    "Quotas",
    "ReactivateOrganizationReply",
    "RedeemCouponRequest",
    "RedeployReply",
    "RedeployRequestInfo",
    "Region",
    "RegionAvailability",
    "RegionListItem",
    "RegionUsage",
    "RegionalDeployment",
    "RegionalDeploymentDefinition",
    "RegionalDeploymentDefinitionType",
    "RegionalDeploymentEvent",
    "RegionalDeploymentListItem",
    "RegionalDeploymentRole",
    "RegionalDeploymentStatus",
    "RegionalDeploymentVolume",
    "RemoveOrganizationMemberReply",
    "ResendOrganizationInvitationReply",
    "ResetPasswordRequest",
    "RevealSecretReply",
    "ReviewOrganizationCapacityReply",
    "ReviewOrganizationCapacityRequest",
    "Route",
    "Sample",
    "ScaleToZeroQuotas",
    "Scaling",
    "Secret",
    "SecretType",
    "SecretsSummary",
    "Service",
    "ServiceEvent",
    "ServiceListItem",
    "ServiceState",
    "ServiceStatus",
    "ServiceSummary",
    "ServiceType",
    "ServiceUsage",
    "Snapshot",
    "SnapshotStatus",
    "SnapshotType",
    "StreamResultOfExecCommandReply",
    "StreamResultOfLogEntry",
    "Subscription",
    "SubscriptionPaymentFailure",
    "SubscriptionPaymentFailureStripeSDK",
    "SubscriptionStatus",
    "TCPHealthCheck",
    "Token",
    "TriggerDeploymentMetadata",
    "TriggerDeploymentMetadataActorType",
    "TriggerDeploymentMetadataTriggerType",
    "TriggerGitDeploymentMetadata",
    "TriggerGitDeploymentMetadataProvider",
    "UpdateApp",
    "UpdateAppReply",
    "UpdateBudgetReply",
    "UpdateBudgetRequest",
    "UpdateCredentialReply",
    "UpdateDomain",
    "UpdateDomainReply",
    "UpdateOrganizationPlanReply",
    "UpdateOrganizationPlanRequest",
    "UpdateOrganizationReply",
    "UpdatePasswordRequest",
    "UpdatePersistentVolumeReply",
    "UpdatePersistentVolumeRequest",
    "UpdateSecretReply",
    "UpdateService",
    "UpdateServiceReply",
    "UpdateSnapshotReply",
    "UpdateSnapshotRequest",
    "UpdateUserRequestUserUpdateBody",
    "UpdateUserSettingsReply",
    "UpdateUserSettingsRequest",
    "UpsertSignupQualificationReply",
    "UpsertSignupQualificationRequest",
    "Usage",
    "UsageDetails",
    "User",
    "UserFlags",
    "UserReply",
    "UserRoleRole",
    "UserSettings",
    "VerifyDockerImageReply",
    "VerifyDockerImageReplyErrCode",
]

# import apis into sdk package
from koyeb.api.api.apps_api import AppsApi as AppsApi
from koyeb.api.api.archives_api import ArchivesApi as ArchivesApi
from koyeb.api.api.catalog_datacenters_api import CatalogDatacentersApi as CatalogDatacentersApi
from koyeb.api.api.catalog_instance_usage_api import CatalogInstanceUsageApi as CatalogInstanceUsageApi
from koyeb.api.api.catalog_instances_api import CatalogInstancesApi as CatalogInstancesApi
from koyeb.api.api.catalog_regions_api import CatalogRegionsApi as CatalogRegionsApi
from koyeb.api.api.compose_api import ComposeApi as ComposeApi
from koyeb.api.api.coupons_api import CouponsApi as CouponsApi
from koyeb.api.api.credentials_api import CredentialsApi as CredentialsApi
from koyeb.api.api.deployments_api import DeploymentsApi as DeploymentsApi
from koyeb.api.api.docker_helper_api import DockerHelperApi as DockerHelperApi
from koyeb.api.api.domains_api import DomainsApi as DomainsApi
from koyeb.api.api.instances_api import InstancesApi as InstancesApi
from koyeb.api.api.intercom_api import IntercomApi as IntercomApi
from koyeb.api.api.logs_api import LogsApi as LogsApi
from koyeb.api.api.metrics_api import MetricsApi as MetricsApi
from koyeb.api.api.organization_confirmations_api import OrganizationConfirmationsApi as OrganizationConfirmationsApi
from koyeb.api.api.organization_invitations_api import OrganizationInvitationsApi as OrganizationInvitationsApi
from koyeb.api.api.organization_members_api import OrganizationMembersApi as OrganizationMembersApi
from koyeb.api.api.organization_quotas_api import OrganizationQuotasApi as OrganizationQuotasApi
from koyeb.api.api.payment_methods_api import PaymentMethodsApi as PaymentMethodsApi
from koyeb.api.api.persistent_volumes_api import PersistentVolumesApi as PersistentVolumesApi
from koyeb.api.api.profile_api import ProfileApi as ProfileApi
from koyeb.api.api.provisioning_api import ProvisioningApi as ProvisioningApi
from koyeb.api.api.quotas_api import QuotasApi as QuotasApi
from koyeb.api.api.regional_deployments_api import RegionalDeploymentsApi as RegionalDeploymentsApi
from koyeb.api.api.repositories_api import RepositoriesApi as RepositoriesApi
from koyeb.api.api.search_api import SearchApi as SearchApi
from koyeb.api.api.secrets_api import SecretsApi as SecretsApi
from koyeb.api.api.services_api import ServicesApi as ServicesApi
from koyeb.api.api.sessions_api import SessionsApi as SessionsApi
from koyeb.api.api.snapshots_api import SnapshotsApi as SnapshotsApi
from koyeb.api.api.subscriptions_api import SubscriptionsApi as SubscriptionsApi
from koyeb.api.api.summary_api import SummaryApi as SummaryApi
from koyeb.api.api.usages_api import UsagesApi as UsagesApi
from koyeb.api.api.users_api import UsersApi as UsersApi
from koyeb.api.api.activity_api import ActivityApi as ActivityApi
from koyeb.api.api.billing_api import BillingApi as BillingApi
from koyeb.api.api.invite_api import InviteApi as InviteApi
from koyeb.api.api.organization_api import OrganizationApi as OrganizationApi
from koyeb.api.api.sso_api import SsoApi as SsoApi

# import ApiClient
from koyeb.api.api_response import ApiResponse as ApiResponse
from koyeb.api.api_client import ApiClient as ApiClient
from koyeb.api.configuration import Configuration as Configuration
from koyeb.api.exceptions import OpenApiException as OpenApiException
from koyeb.api.exceptions import ApiTypeError as ApiTypeError
from koyeb.api.exceptions import ApiValueError as ApiValueError
from koyeb.api.exceptions import ApiKeyError as ApiKeyError
from koyeb.api.exceptions import ApiAttributeError as ApiAttributeError
from koyeb.api.exceptions import ApiException as ApiException

# import models into sdk package
from koyeb.api.models.accept_organization_invitation_reply import AcceptOrganizationInvitationReply as AcceptOrganizationInvitationReply
from koyeb.api.models.action import Action as Action
from koyeb.api.models.activity import Activity as Activity
from koyeb.api.models.activity_list import ActivityList as ActivityList
from koyeb.api.models.app import App as App
from koyeb.api.models.app_event import AppEvent as AppEvent
from koyeb.api.models.app_list_item import AppListItem as AppListItem
from koyeb.api.models.app_status import AppStatus as AppStatus
from koyeb.api.models.app_usage import AppUsage as AppUsage
from koyeb.api.models.apps_summary import AppsSummary as AppsSummary
from koyeb.api.models.archive import Archive as Archive
from koyeb.api.models.archive_deployment_metadata import ArchiveDeploymentMetadata as ArchiveDeploymentMetadata
from koyeb.api.models.archive_source import ArchiveSource as ArchiveSource
from koyeb.api.models.auto_release import AutoRelease as AutoRelease
from koyeb.api.models.auto_release_group import AutoReleaseGroup as AutoReleaseGroup
from koyeb.api.models.autocomplete_reply import AutocompleteReply as AutocompleteReply
from koyeb.api.models.autocomplete_request import AutocompleteRequest as AutocompleteRequest
from koyeb.api.models.availability_level import AvailabilityLevel as AvailabilityLevel
from koyeb.api.models.azure_container_registry_configuration import AzureContainerRegistryConfiguration as AzureContainerRegistryConfiguration
from koyeb.api.models.budget import Budget as Budget
from koyeb.api.models.buildpack_builder import BuildpackBuilder as BuildpackBuilder
from koyeb.api.models.canny_auth_reply import CannyAuthReply as CannyAuthReply
from koyeb.api.models.catalog_gpu_details import CatalogGPUDetails as CatalogGPUDetails
from koyeb.api.models.catalog_instance import CatalogInstance as CatalogInstance
from koyeb.api.models.catalog_instance_list_item import CatalogInstanceListItem as CatalogInstanceListItem
from koyeb.api.models.catalog_usage import CatalogUsage as CatalogUsage
from koyeb.api.models.clear_idenfy_verification_result_request import ClearIdenfyVerificationResultRequest as ClearIdenfyVerificationResultRequest
from koyeb.api.models.compose_reply import ComposeReply as ComposeReply
from koyeb.api.models.config_file import ConfigFile as ConfigFile
from koyeb.api.models.confirm_payment_authorization_reply import ConfirmPaymentAuthorizationReply as ConfirmPaymentAuthorizationReply
from koyeb.api.models.create_access_token_reply import CreateAccessTokenReply as CreateAccessTokenReply
from koyeb.api.models.create_access_token_request import CreateAccessTokenRequest as CreateAccessTokenRequest
from koyeb.api.models.create_account_request import CreateAccountRequest as CreateAccountRequest
from koyeb.api.models.create_app import CreateApp as CreateApp
from koyeb.api.models.create_app_reply import CreateAppReply as CreateAppReply
from koyeb.api.models.create_archive import CreateArchive as CreateArchive
from koyeb.api.models.create_archive_reply import CreateArchiveReply as CreateArchiveReply
from koyeb.api.models.create_budget_reply import CreateBudgetReply as CreateBudgetReply
from koyeb.api.models.create_compose import CreateCompose as CreateCompose
from koyeb.api.models.create_credential import CreateCredential as CreateCredential
from koyeb.api.models.create_credential_reply import CreateCredentialReply as CreateCredentialReply
from koyeb.api.models.create_domain import CreateDomain as CreateDomain
from koyeb.api.models.create_domain_reply import CreateDomainReply as CreateDomainReply
from koyeb.api.models.create_organization_invitation_reply import CreateOrganizationInvitationReply as CreateOrganizationInvitationReply
from koyeb.api.models.create_organization_invitation_request import CreateOrganizationInvitationRequest as CreateOrganizationInvitationRequest
from koyeb.api.models.create_organization_reply import CreateOrganizationReply as CreateOrganizationReply
from koyeb.api.models.create_organization_request import CreateOrganizationRequest as CreateOrganizationRequest
from koyeb.api.models.create_payment_authorization_reply import CreatePaymentAuthorizationReply as CreatePaymentAuthorizationReply
from koyeb.api.models.create_persistent_volume_reply import CreatePersistentVolumeReply as CreatePersistentVolumeReply
from koyeb.api.models.create_persistent_volume_request import CreatePersistentVolumeRequest as CreatePersistentVolumeRequest
from koyeb.api.models.create_secret import CreateSecret as CreateSecret
from koyeb.api.models.create_secret_reply import CreateSecretReply as CreateSecretReply
from koyeb.api.models.create_service import CreateService as CreateService
from koyeb.api.models.create_service_reply import CreateServiceReply as CreateServiceReply
from koyeb.api.models.create_snapshot_reply import CreateSnapshotReply as CreateSnapshotReply
from koyeb.api.models.create_snapshot_request import CreateSnapshotRequest as CreateSnapshotRequest
from koyeb.api.models.create_stage_attempt_request import CreateStageAttemptRequest as CreateStageAttemptRequest
from koyeb.api.models.credential import Credential as Credential
from koyeb.api.models.credential_type import CredentialType as CredentialType
from koyeb.api.models.database_deployment_metadata import DatabaseDeploymentMetadata as DatabaseDeploymentMetadata
from koyeb.api.models.database_role_password import DatabaseRolePassword as DatabaseRolePassword
from koyeb.api.models.database_source import DatabaseSource as DatabaseSource
from koyeb.api.models.database_usage import DatabaseUsage as DatabaseUsage
from koyeb.api.models.database_usage_details import DatabaseUsageDetails as DatabaseUsageDetails
from koyeb.api.models.datacenter_list_item import DatacenterListItem as DatacenterListItem
from koyeb.api.models.deactivate_organization_reply import DeactivateOrganizationReply as DeactivateOrganizationReply
from koyeb.api.models.deactivate_organization_request import DeactivateOrganizationRequest as DeactivateOrganizationRequest
from koyeb.api.models.declare_stage_progress_request import DeclareStageProgressRequest as DeclareStageProgressRequest
from koyeb.api.models.declare_step_progress_request import DeclareStepProgressRequest as DeclareStepProgressRequest
from koyeb.api.models.decline_organization_invitation_reply import DeclineOrganizationInvitationReply as DeclineOrganizationInvitationReply
from koyeb.api.models.delete_organization_reply import DeleteOrganizationReply as DeleteOrganizationReply
from koyeb.api.models.delete_persistent_volume_reply import DeletePersistentVolumeReply as DeletePersistentVolumeReply
from koyeb.api.models.delete_snapshot_reply import DeleteSnapshotReply as DeleteSnapshotReply
from koyeb.api.models.delete_user_reply import DeleteUserReply as DeleteUserReply
from koyeb.api.models.deployment import Deployment as Deployment
from koyeb.api.models.deployment_database_info import DeploymentDatabaseInfo as DeploymentDatabaseInfo
from koyeb.api.models.deployment_definition import DeploymentDefinition as DeploymentDefinition
from koyeb.api.models.deployment_definition_type import DeploymentDefinitionType as DeploymentDefinitionType
from koyeb.api.models.deployment_env import DeploymentEnv as DeploymentEnv
from koyeb.api.models.deployment_event import DeploymentEvent as DeploymentEvent
from koyeb.api.models.deployment_health_check import DeploymentHealthCheck as DeploymentHealthCheck
from koyeb.api.models.deployment_instance_type import DeploymentInstanceType as DeploymentInstanceType
from koyeb.api.models.deployment_list_item import DeploymentListItem as DeploymentListItem
from koyeb.api.models.deployment_metadata import DeploymentMetadata as DeploymentMetadata
from koyeb.api.models.deployment_neon_postgres_database_info import DeploymentNeonPostgresDatabaseInfo as DeploymentNeonPostgresDatabaseInfo
from koyeb.api.models.deployment_neon_postgres_database_info_role import DeploymentNeonPostgresDatabaseInfoRole as DeploymentNeonPostgresDatabaseInfoRole
from koyeb.api.models.deployment_port import DeploymentPort as DeploymentPort
from koyeb.api.models.deployment_provisioning_info import DeploymentProvisioningInfo as DeploymentProvisioningInfo
from koyeb.api.models.deployment_provisioning_info_stage import DeploymentProvisioningInfoStage as DeploymentProvisioningInfoStage
from koyeb.api.models.deployment_provisioning_info_stage_build_attempt import DeploymentProvisioningInfoStageBuildAttempt as DeploymentProvisioningInfoStageBuildAttempt
from koyeb.api.models.deployment_provisioning_info_stage_build_attempt_build_step import DeploymentProvisioningInfoStageBuildAttemptBuildStep as DeploymentProvisioningInfoStageBuildAttemptBuildStep
from koyeb.api.models.deployment_provisioning_info_stage_status import DeploymentProvisioningInfoStageStatus as DeploymentProvisioningInfoStageStatus
from koyeb.api.models.deployment_proxy_port import DeploymentProxyPort as DeploymentProxyPort
from koyeb.api.models.deployment_proxy_port_metadata import DeploymentProxyPortMetadata as DeploymentProxyPortMetadata
from koyeb.api.models.deployment_role import DeploymentRole as DeploymentRole
from koyeb.api.models.deployment_route import DeploymentRoute as DeploymentRoute
from koyeb.api.models.deployment_scaling import DeploymentScaling as DeploymentScaling
from koyeb.api.models.deployment_scaling_target import DeploymentScalingTarget as DeploymentScalingTarget
from koyeb.api.models.deployment_scaling_target_average_cpu import DeploymentScalingTargetAverageCPU as DeploymentScalingTargetAverageCPU
from koyeb.api.models.deployment_scaling_target_average_mem import DeploymentScalingTargetAverageMem as DeploymentScalingTargetAverageMem
from koyeb.api.models.deployment_scaling_target_concurrent_requests import DeploymentScalingTargetConcurrentRequests as DeploymentScalingTargetConcurrentRequests
from koyeb.api.models.deployment_scaling_target_requests_per_second import DeploymentScalingTargetRequestsPerSecond as DeploymentScalingTargetRequestsPerSecond
from koyeb.api.models.deployment_scaling_target_requests_response_time import DeploymentScalingTargetRequestsResponseTime as DeploymentScalingTargetRequestsResponseTime
from koyeb.api.models.deployment_scaling_target_sleep_idle_delay import DeploymentScalingTargetSleepIdleDelay as DeploymentScalingTargetSleepIdleDelay
from koyeb.api.models.deployment_status import DeploymentStatus as DeploymentStatus
from koyeb.api.models.deployment_strategy import DeploymentStrategy as DeploymentStrategy
from koyeb.api.models.deployment_strategy_type import DeploymentStrategyType as DeploymentStrategyType
from koyeb.api.models.deployment_volume import DeploymentVolume as DeploymentVolume
from koyeb.api.models.desired_deployment import DesiredDeployment as DesiredDeployment
from koyeb.api.models.desired_deployment_group import DesiredDeploymentGroup as DesiredDeploymentGroup
from koyeb.api.models.digital_ocean_registry_configuration import DigitalOceanRegistryConfiguration as DigitalOceanRegistryConfiguration
from koyeb.api.models.discourse_auth_reply import DiscourseAuthReply as DiscourseAuthReply
from koyeb.api.models.discourse_auth_request import DiscourseAuthRequest as DiscourseAuthRequest
from koyeb.api.models.docker_builder import DockerBuilder as DockerBuilder
from koyeb.api.models.docker_hub_registry_configuration import DockerHubRegistryConfiguration as DockerHubRegistryConfiguration
from koyeb.api.models.docker_source import DockerSource as DockerSource
from koyeb.api.models.domain import Domain as Domain
from koyeb.api.models.domain_load_balancer_koyeb import DomainLoadBalancerKoyeb as DomainLoadBalancerKoyeb
from koyeb.api.models.domain_load_balancer_quotas import DomainLoadBalancerQuotas as DomainLoadBalancerQuotas
from koyeb.api.models.domain_status import DomainStatus as DomainStatus
from koyeb.api.models.domain_type import DomainType as DomainType
from koyeb.api.models.domains_summary import DomainsSummary as DomainsSummary
from koyeb.api.models.env import Env as Env
from koyeb.api.models.error import Error as Error
from koyeb.api.models.error_field import ErrorField as ErrorField
from koyeb.api.models.error_with_fields import ErrorWithFields as ErrorWithFields
from koyeb.api.models.exec_command_io import ExecCommandIO as ExecCommandIO
from koyeb.api.models.exec_command_reply import ExecCommandReply as ExecCommandReply
from koyeb.api.models.exec_command_request_body import ExecCommandRequestBody as ExecCommandRequestBody
from koyeb.api.models.exec_command_request_id_type import ExecCommandRequestIdType as ExecCommandRequestIdType
from koyeb.api.models.exec_command_request_terminal_size import ExecCommandRequestTerminalSize as ExecCommandRequestTerminalSize
from koyeb.api.models.gcp_container_registry_configuration import GCPContainerRegistryConfiguration as GCPContainerRegistryConfiguration
from koyeb.api.models.get_app_reply import GetAppReply as GetAppReply
from koyeb.api.models.get_budget_reply import GetBudgetReply as GetBudgetReply
from koyeb.api.models.get_catalog_instance_reply import GetCatalogInstanceReply as GetCatalogInstanceReply
from koyeb.api.models.get_credential_reply import GetCredentialReply as GetCredentialReply
from koyeb.api.models.get_deployment_reply import GetDeploymentReply as GetDeploymentReply
from koyeb.api.models.get_deployment_scaling_reply import GetDeploymentScalingReply as GetDeploymentScalingReply
from koyeb.api.models.get_deployment_scaling_reply_item import GetDeploymentScalingReplyItem as GetDeploymentScalingReplyItem
from koyeb.api.models.get_domain_reply import GetDomainReply as GetDomainReply
from koyeb.api.models.get_github_installation_reply import GetGithubInstallationReply as GetGithubInstallationReply
from koyeb.api.models.get_idenfy_token_reply import GetIdenfyTokenReply as GetIdenfyTokenReply
from koyeb.api.models.get_instance_reply import GetInstanceReply as GetInstanceReply
from koyeb.api.models.get_intercom_profile_reply import GetIntercomProfileReply as GetIntercomProfileReply
from koyeb.api.models.get_metrics_reply import GetMetricsReply as GetMetricsReply
from koyeb.api.models.get_metrics_reply_metric import GetMetricsReplyMetric as GetMetricsReplyMetric
from koyeb.api.models.get_o_auth_options_reply import GetOAuthOptionsReply as GetOAuthOptionsReply
from koyeb.api.models.get_organization_invitation_reply import GetOrganizationInvitationReply as GetOrganizationInvitationReply
from koyeb.api.models.get_organization_reply import GetOrganizationReply as GetOrganizationReply
from koyeb.api.models.get_organization_summary_reply import GetOrganizationSummaryReply as GetOrganizationSummaryReply
from koyeb.api.models.get_organization_usage_details_reply import GetOrganizationUsageDetailsReply as GetOrganizationUsageDetailsReply
from koyeb.api.models.get_organization_usage_reply import GetOrganizationUsageReply as GetOrganizationUsageReply
from koyeb.api.models.get_payment_method_reply import GetPaymentMethodReply as GetPaymentMethodReply
from koyeb.api.models.get_persistent_volume_reply import GetPersistentVolumeReply as GetPersistentVolumeReply
from koyeb.api.models.get_quotas_reply import GetQuotasReply as GetQuotasReply
from koyeb.api.models.get_region_reply import GetRegionReply as GetRegionReply
from koyeb.api.models.get_regional_deployment_reply import GetRegionalDeploymentReply as GetRegionalDeploymentReply
from koyeb.api.models.get_secret_reply import GetSecretReply as GetSecretReply
from koyeb.api.models.get_service_reply import GetServiceReply as GetServiceReply
from koyeb.api.models.get_snapshot_reply import GetSnapshotReply as GetSnapshotReply
from koyeb.api.models.get_subscription_reply import GetSubscriptionReply as GetSubscriptionReply
from koyeb.api.models.get_user_organization_invitation_reply import GetUserOrganizationInvitationReply as GetUserOrganizationInvitationReply
from koyeb.api.models.get_user_settings_reply import GetUserSettingsReply as GetUserSettingsReply
from koyeb.api.models.git_deployment_metadata import GitDeploymentMetadata as GitDeploymentMetadata
from koyeb.api.models.git_env_deployment_metadata import GitEnvDeploymentMetadata as GitEnvDeploymentMetadata
from koyeb.api.models.git_hub_registry_configuration import GitHubRegistryConfiguration as GitHubRegistryConfiguration
from koyeb.api.models.git_lab_registry_configuration import GitLabRegistryConfiguration as GitLabRegistryConfiguration
from koyeb.api.models.git_source import GitSource as GitSource
from koyeb.api.models.github_installation_reply import GithubInstallationReply as GithubInstallationReply
from koyeb.api.models.github_installation_request import GithubInstallationRequest as GithubInstallationRequest
from koyeb.api.models.google_protobuf_any import GoogleProtobufAny as GoogleProtobufAny
from koyeb.api.models.google_protobuf_null_value import GoogleProtobufNullValue as GoogleProtobufNullValue
from koyeb.api.models.google_rpc_status import GoogleRpcStatus as GoogleRpcStatus
from koyeb.api.models.http_header import HTTPHeader as HTTPHeader
from koyeb.api.models.http_health_check import HTTPHealthCheck as HTTPHealthCheck
from koyeb.api.models.has_unpaid_invoices_reply import HasUnpaidInvoicesReply as HasUnpaidInvoicesReply
from koyeb.api.models.instance import Instance as Instance
from koyeb.api.models.instance_availability import InstanceAvailability as InstanceAvailability
from koyeb.api.models.instance_event import InstanceEvent as InstanceEvent
from koyeb.api.models.instance_list_item import InstanceListItem as InstanceListItem
from koyeb.api.models.instance_status import InstanceStatus as InstanceStatus
from koyeb.api.models.instance_usage import InstanceUsage as InstanceUsage
from koyeb.api.models.instances_summary import InstancesSummary as InstancesSummary
from koyeb.api.models.invite_user_request import InviteUserRequest as InviteUserRequest
from koyeb.api.models.kgitproxy_branch import KgitproxyBranch as KgitproxyBranch
from koyeb.api.models.kgitproxy_git_hub_repository import KgitproxyGitHubRepository as KgitproxyGitHubRepository
from koyeb.api.models.kgitproxy_github_installation_status import KgitproxyGithubInstallationStatus as KgitproxyGithubInstallationStatus
from koyeb.api.models.kgitproxy_indexing_status import KgitproxyIndexingStatus as KgitproxyIndexingStatus
from koyeb.api.models.kgitproxy_list_branches_reply import KgitproxyListBranchesReply as KgitproxyListBranchesReply
from koyeb.api.models.kgitproxy_list_repositories_reply import KgitproxyListRepositoriesReply as KgitproxyListRepositoriesReply
from koyeb.api.models.kgitproxy_repository import KgitproxyRepository as KgitproxyRepository
from koyeb.api.models.kgitproxy_repository_provider import KgitproxyRepositoryProvider as KgitproxyRepositoryProvider
from koyeb.api.models.ksearch_app import KsearchApp as KsearchApp
from koyeb.api.models.ksearch_global_deployment import KsearchGlobalDeployment as KsearchGlobalDeployment
from koyeb.api.models.ksearch_instance import KsearchInstance as KsearchInstance
from koyeb.api.models.ksearch_organization import KsearchOrganization as KsearchOrganization
from koyeb.api.models.ksearch_regional_deployment import KsearchRegionalDeployment as KsearchRegionalDeployment
from koyeb.api.models.ksearch_search_reply import KsearchSearchReply as KsearchSearchReply
from koyeb.api.models.ksearch_service import KsearchService as KsearchService
from koyeb.api.models.ksearch_user import KsearchUser as KsearchUser
from koyeb.api.models.list_app_events_reply import ListAppEventsReply as ListAppEventsReply
from koyeb.api.models.list_apps_reply import ListAppsReply as ListAppsReply
from koyeb.api.models.list_catalog_instances_reply import ListCatalogInstancesReply as ListCatalogInstancesReply
from koyeb.api.models.list_credentials_reply import ListCredentialsReply as ListCredentialsReply
from koyeb.api.models.list_datacenters_reply import ListDatacentersReply as ListDatacentersReply
from koyeb.api.models.list_deployment_events_reply import ListDeploymentEventsReply as ListDeploymentEventsReply
from koyeb.api.models.list_deployments_reply import ListDeploymentsReply as ListDeploymentsReply
from koyeb.api.models.list_domains_reply import ListDomainsReply as ListDomainsReply
from koyeb.api.models.list_instance_events_reply import ListInstanceEventsReply as ListInstanceEventsReply
from koyeb.api.models.list_instances_reply import ListInstancesReply as ListInstancesReply
from koyeb.api.models.list_organization_invitations_reply import ListOrganizationInvitationsReply as ListOrganizationInvitationsReply
from koyeb.api.models.list_organization_members_reply import ListOrganizationMembersReply as ListOrganizationMembersReply
from koyeb.api.models.list_payment_methods_reply import ListPaymentMethodsReply as ListPaymentMethodsReply
from koyeb.api.models.list_persistent_volume_events_reply import ListPersistentVolumeEventsReply as ListPersistentVolumeEventsReply
from koyeb.api.models.list_persistent_volumes_reply import ListPersistentVolumesReply as ListPersistentVolumesReply
from koyeb.api.models.list_regional_deployment_events_reply import ListRegionalDeploymentEventsReply as ListRegionalDeploymentEventsReply
from koyeb.api.models.list_regional_deployments_reply import ListRegionalDeploymentsReply as ListRegionalDeploymentsReply
from koyeb.api.models.list_regions_reply import ListRegionsReply as ListRegionsReply
from koyeb.api.models.list_secrets_reply import ListSecretsReply as ListSecretsReply
from koyeb.api.models.list_service_events_reply import ListServiceEventsReply as ListServiceEventsReply
from koyeb.api.models.list_services_reply import ListServicesReply as ListServicesReply
from koyeb.api.models.list_snapshots_reply import ListSnapshotsReply as ListSnapshotsReply
from koyeb.api.models.list_usage_reply import ListUsageReply as ListUsageReply
from koyeb.api.models.list_user_organization_invitations_reply import ListUserOrganizationInvitationsReply as ListUserOrganizationInvitationsReply
from koyeb.api.models.list_user_organizations_reply import ListUserOrganizationsReply as ListUserOrganizationsReply
from koyeb.api.models.log_entry import LogEntry as LogEntry
from koyeb.api.models.login_method_reply import LoginMethodReply as LoginMethodReply
from koyeb.api.models.login_method_reply_method import LoginMethodReplyMethod as LoginMethodReplyMethod
from koyeb.api.models.login_reply import LoginReply as LoginReply
from koyeb.api.models.login_request import LoginRequest as LoginRequest
from koyeb.api.models.manage_reply import ManageReply as ManageReply
from koyeb.api.models.members_summary import MembersSummary as MembersSummary
from koyeb.api.models.metric_name import MetricName as MetricName
from koyeb.api.models.neon_postgres_database import NeonPostgresDatabase as NeonPostgresDatabase
from koyeb.api.models.neon_postgres_database_deployment_metadata import NeonPostgresDatabaseDeploymentMetadata as NeonPostgresDatabaseDeploymentMetadata
from koyeb.api.models.neon_postgres_database_neon_database import NeonPostgresDatabaseNeonDatabase as NeonPostgresDatabaseNeonDatabase
from koyeb.api.models.neon_postgres_database_neon_role import NeonPostgresDatabaseNeonRole as NeonPostgresDatabaseNeonRole
from koyeb.api.models.neon_postgres_summary import NeonPostgresSummary as NeonPostgresSummary
from koyeb.api.models.next_invoice_reply import NextInvoiceReply as NextInvoiceReply
from koyeb.api.models.next_invoice_reply_discount import NextInvoiceReplyDiscount as NextInvoiceReplyDiscount
from koyeb.api.models.next_invoice_reply_discount_type import NextInvoiceReplyDiscountType as NextInvoiceReplyDiscountType
from koyeb.api.models.next_invoice_reply_line import NextInvoiceReplyLine as NextInvoiceReplyLine
from koyeb.api.models.next_invoice_reply_line_period import NextInvoiceReplyLinePeriod as NextInvoiceReplyLinePeriod
from koyeb.api.models.next_invoice_reply_line_price import NextInvoiceReplyLinePrice as NextInvoiceReplyLinePrice
from koyeb.api.models.notification import Notification as Notification
from koyeb.api.models.notification_list import NotificationList as NotificationList
from koyeb.api.models.o_auth_callback_reply import OAuthCallbackReply as OAuthCallbackReply
from koyeb.api.models.o_auth_callback_request import OAuthCallbackRequest as OAuthCallbackRequest
from koyeb.api.models.o_auth_provider import OAuthProvider as OAuthProvider
from koyeb.api.models.object import Object as Object
from koyeb.api.models.organization import Organization as Organization
from koyeb.api.models.organization_deactivation_reason import OrganizationDeactivationReason as OrganizationDeactivationReason
from koyeb.api.models.organization_detailed_status import OrganizationDetailedStatus as OrganizationDetailedStatus
from koyeb.api.models.organization_invitation import OrganizationInvitation as OrganizationInvitation
from koyeb.api.models.organization_invitation_status import OrganizationInvitationStatus as OrganizationInvitationStatus
from koyeb.api.models.organization_member import OrganizationMember as OrganizationMember
from koyeb.api.models.organization_member_status import OrganizationMemberStatus as OrganizationMemberStatus
from koyeb.api.models.organization_status import OrganizationStatus as OrganizationStatus
from koyeb.api.models.organization_summary import OrganizationSummary as OrganizationSummary
from koyeb.api.models.payment_method import PaymentMethod as PaymentMethod
from koyeb.api.models.payment_method_status import PaymentMethodStatus as PaymentMethodStatus
from koyeb.api.models.period_usage import PeriodUsage as PeriodUsage
from koyeb.api.models.persistent_volume import PersistentVolume as PersistentVolume
from koyeb.api.models.persistent_volume_backing_store import PersistentVolumeBackingStore as PersistentVolumeBackingStore
from koyeb.api.models.persistent_volume_event import PersistentVolumeEvent as PersistentVolumeEvent
from koyeb.api.models.persistent_volume_quotas import PersistentVolumeQuotas as PersistentVolumeQuotas
from koyeb.api.models.persistent_volume_status import PersistentVolumeStatus as PersistentVolumeStatus
from koyeb.api.models.plan import Plan as Plan
from koyeb.api.models.port import Port as Port
from koyeb.api.models.private_registry_configuration import PrivateRegistryConfiguration as PrivateRegistryConfiguration
from koyeb.api.models.proxy_port_protocol import ProxyPortProtocol as ProxyPortProtocol
from koyeb.api.models.public_organization import PublicOrganization as PublicOrganization
from koyeb.api.models.public_user import PublicUser as PublicUser
from koyeb.api.models.query_logs_reply import QueryLogsReply as QueryLogsReply
from koyeb.api.models.query_logs_reply_pagination import QueryLogsReplyPagination as QueryLogsReplyPagination
from koyeb.api.models.quotas import Quotas as Quotas
from koyeb.api.models.reactivate_organization_reply import ReactivateOrganizationReply as ReactivateOrganizationReply
from koyeb.api.models.redeem_coupon_request import RedeemCouponRequest as RedeemCouponRequest
from koyeb.api.models.redeploy_reply import RedeployReply as RedeployReply
from koyeb.api.models.redeploy_request_info import RedeployRequestInfo as RedeployRequestInfo
from koyeb.api.models.region import Region as Region
from koyeb.api.models.region_availability import RegionAvailability as RegionAvailability
from koyeb.api.models.region_list_item import RegionListItem as RegionListItem
from koyeb.api.models.region_usage import RegionUsage as RegionUsage
from koyeb.api.models.regional_deployment import RegionalDeployment as RegionalDeployment
from koyeb.api.models.regional_deployment_definition import RegionalDeploymentDefinition as RegionalDeploymentDefinition
from koyeb.api.models.regional_deployment_definition_type import RegionalDeploymentDefinitionType as RegionalDeploymentDefinitionType
from koyeb.api.models.regional_deployment_event import RegionalDeploymentEvent as RegionalDeploymentEvent
from koyeb.api.models.regional_deployment_list_item import RegionalDeploymentListItem as RegionalDeploymentListItem
from koyeb.api.models.regional_deployment_role import RegionalDeploymentRole as RegionalDeploymentRole
from koyeb.api.models.regional_deployment_status import RegionalDeploymentStatus as RegionalDeploymentStatus
from koyeb.api.models.regional_deployment_volume import RegionalDeploymentVolume as RegionalDeploymentVolume
from koyeb.api.models.remove_organization_member_reply import RemoveOrganizationMemberReply as RemoveOrganizationMemberReply
from koyeb.api.models.resend_organization_invitation_reply import ResendOrganizationInvitationReply as ResendOrganizationInvitationReply
from koyeb.api.models.reset_password_request import ResetPasswordRequest as ResetPasswordRequest
from koyeb.api.models.reveal_secret_reply import RevealSecretReply as RevealSecretReply
from koyeb.api.models.review_organization_capacity_reply import ReviewOrganizationCapacityReply as ReviewOrganizationCapacityReply
from koyeb.api.models.review_organization_capacity_request import ReviewOrganizationCapacityRequest as ReviewOrganizationCapacityRequest
from koyeb.api.models.route import Route as Route
from koyeb.api.models.sample import Sample as Sample
from koyeb.api.models.scale_to_zero_quotas import ScaleToZeroQuotas as ScaleToZeroQuotas
from koyeb.api.models.scaling import Scaling as Scaling
from koyeb.api.models.secret import Secret as Secret
from koyeb.api.models.secret_type import SecretType as SecretType
from koyeb.api.models.secrets_summary import SecretsSummary as SecretsSummary
from koyeb.api.models.service import Service as Service
from koyeb.api.models.service_event import ServiceEvent as ServiceEvent
from koyeb.api.models.service_list_item import ServiceListItem as ServiceListItem
from koyeb.api.models.service_state import ServiceState as ServiceState
from koyeb.api.models.service_status import ServiceStatus as ServiceStatus
from koyeb.api.models.service_summary import ServiceSummary as ServiceSummary
from koyeb.api.models.service_type import ServiceType as ServiceType
from koyeb.api.models.service_usage import ServiceUsage as ServiceUsage
from koyeb.api.models.snapshot import Snapshot as Snapshot
from koyeb.api.models.snapshot_status import SnapshotStatus as SnapshotStatus
from koyeb.api.models.snapshot_type import SnapshotType as SnapshotType
from koyeb.api.models.stream_result_of_exec_command_reply import StreamResultOfExecCommandReply as StreamResultOfExecCommandReply
from koyeb.api.models.stream_result_of_log_entry import StreamResultOfLogEntry as StreamResultOfLogEntry
from koyeb.api.models.subscription import Subscription as Subscription
from koyeb.api.models.subscription_payment_failure import SubscriptionPaymentFailure as SubscriptionPaymentFailure
from koyeb.api.models.subscription_payment_failure_stripe_sdk import SubscriptionPaymentFailureStripeSDK as SubscriptionPaymentFailureStripeSDK
from koyeb.api.models.subscription_status import SubscriptionStatus as SubscriptionStatus
from koyeb.api.models.tcp_health_check import TCPHealthCheck as TCPHealthCheck
from koyeb.api.models.token import Token as Token
from koyeb.api.models.trigger_deployment_metadata import TriggerDeploymentMetadata as TriggerDeploymentMetadata
from koyeb.api.models.trigger_deployment_metadata_actor_type import TriggerDeploymentMetadataActorType as TriggerDeploymentMetadataActorType
from koyeb.api.models.trigger_deployment_metadata_trigger_type import TriggerDeploymentMetadataTriggerType as TriggerDeploymentMetadataTriggerType
from koyeb.api.models.trigger_git_deployment_metadata import TriggerGitDeploymentMetadata as TriggerGitDeploymentMetadata
from koyeb.api.models.trigger_git_deployment_metadata_provider import TriggerGitDeploymentMetadataProvider as TriggerGitDeploymentMetadataProvider
from koyeb.api.models.update_app import UpdateApp as UpdateApp
from koyeb.api.models.update_app_reply import UpdateAppReply as UpdateAppReply
from koyeb.api.models.update_budget_reply import UpdateBudgetReply as UpdateBudgetReply
from koyeb.api.models.update_budget_request import UpdateBudgetRequest as UpdateBudgetRequest
from koyeb.api.models.update_credential_reply import UpdateCredentialReply as UpdateCredentialReply
from koyeb.api.models.update_domain import UpdateDomain as UpdateDomain
from koyeb.api.models.update_domain_reply import UpdateDomainReply as UpdateDomainReply
from koyeb.api.models.update_organization_plan_reply import UpdateOrganizationPlanReply as UpdateOrganizationPlanReply
from koyeb.api.models.update_organization_plan_request import UpdateOrganizationPlanRequest as UpdateOrganizationPlanRequest
from koyeb.api.models.update_organization_reply import UpdateOrganizationReply as UpdateOrganizationReply
from koyeb.api.models.update_password_request import UpdatePasswordRequest as UpdatePasswordRequest
from koyeb.api.models.update_persistent_volume_reply import UpdatePersistentVolumeReply as UpdatePersistentVolumeReply
from koyeb.api.models.update_persistent_volume_request import UpdatePersistentVolumeRequest as UpdatePersistentVolumeRequest
from koyeb.api.models.update_secret_reply import UpdateSecretReply as UpdateSecretReply
from koyeb.api.models.update_service import UpdateService as UpdateService
from koyeb.api.models.update_service_reply import UpdateServiceReply as UpdateServiceReply
from koyeb.api.models.update_snapshot_reply import UpdateSnapshotReply as UpdateSnapshotReply
from koyeb.api.models.update_snapshot_request import UpdateSnapshotRequest as UpdateSnapshotRequest
from koyeb.api.models.update_user_request_user_update_body import UpdateUserRequestUserUpdateBody as UpdateUserRequestUserUpdateBody
from koyeb.api.models.update_user_settings_reply import UpdateUserSettingsReply as UpdateUserSettingsReply
from koyeb.api.models.update_user_settings_request import UpdateUserSettingsRequest as UpdateUserSettingsRequest
from koyeb.api.models.upsert_signup_qualification_reply import UpsertSignupQualificationReply as UpsertSignupQualificationReply
from koyeb.api.models.upsert_signup_qualification_request import UpsertSignupQualificationRequest as UpsertSignupQualificationRequest
from koyeb.api.models.usage import Usage as Usage
from koyeb.api.models.usage_details import UsageDetails as UsageDetails
from koyeb.api.models.user import User as User
from koyeb.api.models.user_flags import UserFlags as UserFlags
from koyeb.api.models.user_reply import UserReply as UserReply
from koyeb.api.models.user_role_role import UserRoleRole as UserRoleRole
from koyeb.api.models.user_settings import UserSettings as UserSettings
from koyeb.api.models.verify_docker_image_reply import VerifyDockerImageReply as VerifyDockerImageReply
from koyeb.api.models.verify_docker_image_reply_err_code import VerifyDockerImageReplyErrCode as VerifyDockerImageReplyErrCode

