# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr, field_validator
from typing import List, Optional, Union
from typing_extensions import Annotated
from koyeb.api.models.get_instance_reply import GetInstanceReply
from koyeb.api.models.list_instance_events_reply import ListInstanceEventsReply
from koyeb.api.models.list_instances_reply import ListInstancesReply
from koyeb.api.models.stream_result_of_exec_command_reply import StreamResultOfExecCommandReply

from koyeb.api.api_client import ApiClient, RequestSerialized
from koyeb.api.api_response import ApiResponse
from koyeb.api.rest import RESTResponseType


class InstancesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def exec_command(
        self,
        id: Annotated[Optional[StrictStr], Field(description="ID of the resource to exec on.")] = None,
        body_command: Annotated[Optional[List[StrictStr]], Field(description="Command to exec. Mandatory in the first frame sent")] = None,
        body_tty_size_height: Optional[StrictInt] = None,
        body_tty_size_width: Optional[StrictInt] = None,
        body_stdin_data: Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="Data is base64 encoded")] = None,
        body_stdin_close: Annotated[Optional[StrictBool], Field(description="Indicate last data frame")] = None,
        body_disable_tty: Annotated[Optional[StrictBool], Field(description="Disable TTY. It's enough to specify it in the first frame")] = None,
        id_type: Annotated[Optional[StrictStr], Field(description="When specified, it is used to determine if the kind of resource the id refers to. If missing, defaults to the instance id.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> StreamResultOfExecCommandReply:
        """Exec Command

        This endpoint opens a websocket. Once open, all frames going through the websocket should be formatted in JSON. Input frames should match the format specified below. Output frames will match the response schema.

        :param id: ID of the resource to exec on.
        :type id: str
        :param body_command: Command to exec. Mandatory in the first frame sent
        :type body_command: List[str]
        :param body_tty_size_height:
        :type body_tty_size_height: int
        :param body_tty_size_width:
        :type body_tty_size_width: int
        :param body_stdin_data: Data is base64 encoded
        :type body_stdin_data: bytearray
        :param body_stdin_close: Indicate last data frame
        :type body_stdin_close: bool
        :param body_disable_tty: Disable TTY. It's enough to specify it in the first frame
        :type body_disable_tty: bool
        :param id_type: When specified, it is used to determine if the kind of resource the id refers to. If missing, defaults to the instance id.
        :type id_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._exec_command_serialize(
            id=id,
            body_command=body_command,
            body_tty_size_height=body_tty_size_height,
            body_tty_size_width=body_tty_size_width,
            body_stdin_data=body_stdin_data,
            body_stdin_close=body_stdin_close,
            body_disable_tty=body_disable_tty,
            id_type=id_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StreamResultOfExecCommandReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def exec_command_with_http_info(
        self,
        id: Annotated[Optional[StrictStr], Field(description="ID of the resource to exec on.")] = None,
        body_command: Annotated[Optional[List[StrictStr]], Field(description="Command to exec. Mandatory in the first frame sent")] = None,
        body_tty_size_height: Optional[StrictInt] = None,
        body_tty_size_width: Optional[StrictInt] = None,
        body_stdin_data: Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="Data is base64 encoded")] = None,
        body_stdin_close: Annotated[Optional[StrictBool], Field(description="Indicate last data frame")] = None,
        body_disable_tty: Annotated[Optional[StrictBool], Field(description="Disable TTY. It's enough to specify it in the first frame")] = None,
        id_type: Annotated[Optional[StrictStr], Field(description="When specified, it is used to determine if the kind of resource the id refers to. If missing, defaults to the instance id.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[StreamResultOfExecCommandReply]:
        """Exec Command

        This endpoint opens a websocket. Once open, all frames going through the websocket should be formatted in JSON. Input frames should match the format specified below. Output frames will match the response schema.

        :param id: ID of the resource to exec on.
        :type id: str
        :param body_command: Command to exec. Mandatory in the first frame sent
        :type body_command: List[str]
        :param body_tty_size_height:
        :type body_tty_size_height: int
        :param body_tty_size_width:
        :type body_tty_size_width: int
        :param body_stdin_data: Data is base64 encoded
        :type body_stdin_data: bytearray
        :param body_stdin_close: Indicate last data frame
        :type body_stdin_close: bool
        :param body_disable_tty: Disable TTY. It's enough to specify it in the first frame
        :type body_disable_tty: bool
        :param id_type: When specified, it is used to determine if the kind of resource the id refers to. If missing, defaults to the instance id.
        :type id_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._exec_command_serialize(
            id=id,
            body_command=body_command,
            body_tty_size_height=body_tty_size_height,
            body_tty_size_width=body_tty_size_width,
            body_stdin_data=body_stdin_data,
            body_stdin_close=body_stdin_close,
            body_disable_tty=body_disable_tty,
            id_type=id_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StreamResultOfExecCommandReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def exec_command_without_preload_content(
        self,
        id: Annotated[Optional[StrictStr], Field(description="ID of the resource to exec on.")] = None,
        body_command: Annotated[Optional[List[StrictStr]], Field(description="Command to exec. Mandatory in the first frame sent")] = None,
        body_tty_size_height: Optional[StrictInt] = None,
        body_tty_size_width: Optional[StrictInt] = None,
        body_stdin_data: Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="Data is base64 encoded")] = None,
        body_stdin_close: Annotated[Optional[StrictBool], Field(description="Indicate last data frame")] = None,
        body_disable_tty: Annotated[Optional[StrictBool], Field(description="Disable TTY. It's enough to specify it in the first frame")] = None,
        id_type: Annotated[Optional[StrictStr], Field(description="When specified, it is used to determine if the kind of resource the id refers to. If missing, defaults to the instance id.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Exec Command

        This endpoint opens a websocket. Once open, all frames going through the websocket should be formatted in JSON. Input frames should match the format specified below. Output frames will match the response schema.

        :param id: ID of the resource to exec on.
        :type id: str
        :param body_command: Command to exec. Mandatory in the first frame sent
        :type body_command: List[str]
        :param body_tty_size_height:
        :type body_tty_size_height: int
        :param body_tty_size_width:
        :type body_tty_size_width: int
        :param body_stdin_data: Data is base64 encoded
        :type body_stdin_data: bytearray
        :param body_stdin_close: Indicate last data frame
        :type body_stdin_close: bool
        :param body_disable_tty: Disable TTY. It's enough to specify it in the first frame
        :type body_disable_tty: bool
        :param id_type: When specified, it is used to determine if the kind of resource the id refers to. If missing, defaults to the instance id.
        :type id_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._exec_command_serialize(
            id=id,
            body_command=body_command,
            body_tty_size_height=body_tty_size_height,
            body_tty_size_width=body_tty_size_width,
            body_stdin_data=body_stdin_data,
            body_stdin_close=body_stdin_close,
            body_disable_tty=body_disable_tty,
            id_type=id_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StreamResultOfExecCommandReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _exec_command_serialize(
        self,
        id,
        body_command,
        body_tty_size_height,
        body_tty_size_width,
        body_stdin_data,
        body_stdin_close,
        body_disable_tty,
        id_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'body.command': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if body_command is not None:
            
            _query_params.append(('body.command', body_command))
            
        if body_tty_size_height is not None:
            
            _query_params.append(('body.tty_size.height', body_tty_size_height))
            
        if body_tty_size_width is not None:
            
            _query_params.append(('body.tty_size.width', body_tty_size_width))
            
        if body_stdin_data is not None:
            
            _query_params.append(('body.stdin.data', body_stdin_data))
            
        if body_stdin_close is not None:
            
            _query_params.append(('body.stdin.close', body_stdin_close))
            
        if body_disable_tty is not None:
            
            _query_params.append(('body.disableTty', body_disable_tty))
            
        if id_type is not None:
            
            _query_params.append(('id_type', id_type))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    '*/*'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/streams/instances/exec',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_instance(
        self,
        id: Annotated[StrictStr, Field(description="The id of the instance")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetInstanceReply:
        """Get Instance


        :param id: The id of the instance (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_instance_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInstanceReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_instance_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="The id of the instance")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetInstanceReply]:
        """Get Instance


        :param id: The id of the instance (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_instance_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInstanceReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_instance_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The id of the instance")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Instance


        :param id: The id of the instance (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_instance_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInstanceReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_instance_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    '*/*'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/instances/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_instance_events(
        self,
        instance_ids: Annotated[Optional[List[StrictStr]], Field(description="(Optional) Filter on list of instance id")] = None,
        types: Annotated[Optional[List[StrictStr]], Field(description="(Optional) Filter on instance event types")] = None,
        limit: Annotated[Optional[StrictStr], Field(description="(Optional) The number of items to return")] = None,
        offset: Annotated[Optional[StrictStr], Field(description="(Optional) The offset in the list of item to return")] = None,
        order: Annotated[Optional[StrictStr], Field(description="(Optional) Sorts the list in the ascending or the descending order")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListInstanceEventsReply:
        """List Instance events


        :param instance_ids: (Optional) Filter on list of instance id
        :type instance_ids: List[str]
        :param types: (Optional) Filter on instance event types
        :type types: List[str]
        :param limit: (Optional) The number of items to return
        :type limit: str
        :param offset: (Optional) The offset in the list of item to return
        :type offset: str
        :param order: (Optional) Sorts the list in the ascending or the descending order
        :type order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_instance_events_serialize(
            instance_ids=instance_ids,
            types=types,
            limit=limit,
            offset=offset,
            order=order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInstanceEventsReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_instance_events_with_http_info(
        self,
        instance_ids: Annotated[Optional[List[StrictStr]], Field(description="(Optional) Filter on list of instance id")] = None,
        types: Annotated[Optional[List[StrictStr]], Field(description="(Optional) Filter on instance event types")] = None,
        limit: Annotated[Optional[StrictStr], Field(description="(Optional) The number of items to return")] = None,
        offset: Annotated[Optional[StrictStr], Field(description="(Optional) The offset in the list of item to return")] = None,
        order: Annotated[Optional[StrictStr], Field(description="(Optional) Sorts the list in the ascending or the descending order")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListInstanceEventsReply]:
        """List Instance events


        :param instance_ids: (Optional) Filter on list of instance id
        :type instance_ids: List[str]
        :param types: (Optional) Filter on instance event types
        :type types: List[str]
        :param limit: (Optional) The number of items to return
        :type limit: str
        :param offset: (Optional) The offset in the list of item to return
        :type offset: str
        :param order: (Optional) Sorts the list in the ascending or the descending order
        :type order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_instance_events_serialize(
            instance_ids=instance_ids,
            types=types,
            limit=limit,
            offset=offset,
            order=order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInstanceEventsReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_instance_events_without_preload_content(
        self,
        instance_ids: Annotated[Optional[List[StrictStr]], Field(description="(Optional) Filter on list of instance id")] = None,
        types: Annotated[Optional[List[StrictStr]], Field(description="(Optional) Filter on instance event types")] = None,
        limit: Annotated[Optional[StrictStr], Field(description="(Optional) The number of items to return")] = None,
        offset: Annotated[Optional[StrictStr], Field(description="(Optional) The offset in the list of item to return")] = None,
        order: Annotated[Optional[StrictStr], Field(description="(Optional) Sorts the list in the ascending or the descending order")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Instance events


        :param instance_ids: (Optional) Filter on list of instance id
        :type instance_ids: List[str]
        :param types: (Optional) Filter on instance event types
        :type types: List[str]
        :param limit: (Optional) The number of items to return
        :type limit: str
        :param offset: (Optional) The offset in the list of item to return
        :type offset: str
        :param order: (Optional) Sorts the list in the ascending or the descending order
        :type order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_instance_events_serialize(
            instance_ids=instance_ids,
            types=types,
            limit=limit,
            offset=offset,
            order=order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInstanceEventsReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_instance_events_serialize(
        self,
        instance_ids,
        types,
        limit,
        offset,
        order,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'instance_ids': 'multi',
            'types': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if instance_ids is not None:
            
            _query_params.append(('instance_ids', instance_ids))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order is not None:
            
            _query_params.append(('order', order))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    '*/*'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/instance_events',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_instances(
        self,
        app_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on application id")] = None,
        service_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on service id")] = None,
        deployment_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on deployment id")] = None,
        regional_deployment_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on regional deployment id")] = None,
        allocation_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on allocation id")] = None,
        replica_index: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on replica index")] = None,
        statuses: Annotated[Optional[List[StrictStr]], Field(description="(Optional) Filter on instance statuses")] = None,
        limit: Annotated[Optional[StrictStr], Field(description="(Optional) The number of items to return")] = None,
        offset: Annotated[Optional[StrictStr], Field(description="(Optional) The offset in the list of item to return")] = None,
        order: Annotated[Optional[StrictStr], Field(description="(Optional) Sorts the list in the ascending or the descending order")] = None,
        starting_time: Annotated[Optional[datetime], Field(description="(Optional) The starting time of the period of running instance")] = None,
        ending_time: Annotated[Optional[datetime], Field(description="(Optional) The ending time of the period of running instance")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListInstancesReply:
        """List Instances


        :param app_id: (Optional) Filter on application id
        :type app_id: str
        :param service_id: (Optional) Filter on service id
        :type service_id: str
        :param deployment_id: (Optional) Filter on deployment id
        :type deployment_id: str
        :param regional_deployment_id: (Optional) Filter on regional deployment id
        :type regional_deployment_id: str
        :param allocation_id: (Optional) Filter on allocation id
        :type allocation_id: str
        :param replica_index: (Optional) Filter on replica index
        :type replica_index: str
        :param statuses: (Optional) Filter on instance statuses
        :type statuses: List[str]
        :param limit: (Optional) The number of items to return
        :type limit: str
        :param offset: (Optional) The offset in the list of item to return
        :type offset: str
        :param order: (Optional) Sorts the list in the ascending or the descending order
        :type order: str
        :param starting_time: (Optional) The starting time of the period of running instance
        :type starting_time: datetime
        :param ending_time: (Optional) The ending time of the period of running instance
        :type ending_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_instances_serialize(
            app_id=app_id,
            service_id=service_id,
            deployment_id=deployment_id,
            regional_deployment_id=regional_deployment_id,
            allocation_id=allocation_id,
            replica_index=replica_index,
            statuses=statuses,
            limit=limit,
            offset=offset,
            order=order,
            starting_time=starting_time,
            ending_time=ending_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInstancesReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_instances_with_http_info(
        self,
        app_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on application id")] = None,
        service_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on service id")] = None,
        deployment_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on deployment id")] = None,
        regional_deployment_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on regional deployment id")] = None,
        allocation_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on allocation id")] = None,
        replica_index: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on replica index")] = None,
        statuses: Annotated[Optional[List[StrictStr]], Field(description="(Optional) Filter on instance statuses")] = None,
        limit: Annotated[Optional[StrictStr], Field(description="(Optional) The number of items to return")] = None,
        offset: Annotated[Optional[StrictStr], Field(description="(Optional) The offset in the list of item to return")] = None,
        order: Annotated[Optional[StrictStr], Field(description="(Optional) Sorts the list in the ascending or the descending order")] = None,
        starting_time: Annotated[Optional[datetime], Field(description="(Optional) The starting time of the period of running instance")] = None,
        ending_time: Annotated[Optional[datetime], Field(description="(Optional) The ending time of the period of running instance")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListInstancesReply]:
        """List Instances


        :param app_id: (Optional) Filter on application id
        :type app_id: str
        :param service_id: (Optional) Filter on service id
        :type service_id: str
        :param deployment_id: (Optional) Filter on deployment id
        :type deployment_id: str
        :param regional_deployment_id: (Optional) Filter on regional deployment id
        :type regional_deployment_id: str
        :param allocation_id: (Optional) Filter on allocation id
        :type allocation_id: str
        :param replica_index: (Optional) Filter on replica index
        :type replica_index: str
        :param statuses: (Optional) Filter on instance statuses
        :type statuses: List[str]
        :param limit: (Optional) The number of items to return
        :type limit: str
        :param offset: (Optional) The offset in the list of item to return
        :type offset: str
        :param order: (Optional) Sorts the list in the ascending or the descending order
        :type order: str
        :param starting_time: (Optional) The starting time of the period of running instance
        :type starting_time: datetime
        :param ending_time: (Optional) The ending time of the period of running instance
        :type ending_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_instances_serialize(
            app_id=app_id,
            service_id=service_id,
            deployment_id=deployment_id,
            regional_deployment_id=regional_deployment_id,
            allocation_id=allocation_id,
            replica_index=replica_index,
            statuses=statuses,
            limit=limit,
            offset=offset,
            order=order,
            starting_time=starting_time,
            ending_time=ending_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInstancesReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_instances_without_preload_content(
        self,
        app_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on application id")] = None,
        service_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on service id")] = None,
        deployment_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on deployment id")] = None,
        regional_deployment_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on regional deployment id")] = None,
        allocation_id: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on allocation id")] = None,
        replica_index: Annotated[Optional[StrictStr], Field(description="(Optional) Filter on replica index")] = None,
        statuses: Annotated[Optional[List[StrictStr]], Field(description="(Optional) Filter on instance statuses")] = None,
        limit: Annotated[Optional[StrictStr], Field(description="(Optional) The number of items to return")] = None,
        offset: Annotated[Optional[StrictStr], Field(description="(Optional) The offset in the list of item to return")] = None,
        order: Annotated[Optional[StrictStr], Field(description="(Optional) Sorts the list in the ascending or the descending order")] = None,
        starting_time: Annotated[Optional[datetime], Field(description="(Optional) The starting time of the period of running instance")] = None,
        ending_time: Annotated[Optional[datetime], Field(description="(Optional) The ending time of the period of running instance")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Instances


        :param app_id: (Optional) Filter on application id
        :type app_id: str
        :param service_id: (Optional) Filter on service id
        :type service_id: str
        :param deployment_id: (Optional) Filter on deployment id
        :type deployment_id: str
        :param regional_deployment_id: (Optional) Filter on regional deployment id
        :type regional_deployment_id: str
        :param allocation_id: (Optional) Filter on allocation id
        :type allocation_id: str
        :param replica_index: (Optional) Filter on replica index
        :type replica_index: str
        :param statuses: (Optional) Filter on instance statuses
        :type statuses: List[str]
        :param limit: (Optional) The number of items to return
        :type limit: str
        :param offset: (Optional) The offset in the list of item to return
        :type offset: str
        :param order: (Optional) Sorts the list in the ascending or the descending order
        :type order: str
        :param starting_time: (Optional) The starting time of the period of running instance
        :type starting_time: datetime
        :param ending_time: (Optional) The ending time of the period of running instance
        :type ending_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_instances_serialize(
            app_id=app_id,
            service_id=service_id,
            deployment_id=deployment_id,
            regional_deployment_id=regional_deployment_id,
            allocation_id=allocation_id,
            replica_index=replica_index,
            statuses=statuses,
            limit=limit,
            offset=offset,
            order=order,
            starting_time=starting_time,
            ending_time=ending_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInstancesReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_instances_serialize(
        self,
        app_id,
        service_id,
        deployment_id,
        regional_deployment_id,
        allocation_id,
        replica_index,
        statuses,
        limit,
        offset,
        order,
        starting_time,
        ending_time,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'statuses': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if app_id is not None:
            
            _query_params.append(('app_id', app_id))
            
        if service_id is not None:
            
            _query_params.append(('service_id', service_id))
            
        if deployment_id is not None:
            
            _query_params.append(('deployment_id', deployment_id))
            
        if regional_deployment_id is not None:
            
            _query_params.append(('regional_deployment_id', regional_deployment_id))
            
        if allocation_id is not None:
            
            _query_params.append(('allocation_id', allocation_id))
            
        if replica_index is not None:
            
            _query_params.append(('replica_index', replica_index))
            
        if statuses is not None:
            
            _query_params.append(('statuses', statuses))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order is not None:
            
            _query_params.append(('order', order))
            
        if starting_time is not None:
            if isinstance(starting_time, datetime):
                _query_params.append(
                    (
                        'starting_time',
                        starting_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('starting_time', starting_time))
            
        if ending_time is not None:
            if isinstance(ending_time, datetime):
                _query_params.append(
                    (
                        'ending_time',
                        ending_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('ending_time', ending_time))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    '*/*'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/instances',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


