# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from koyeb.api.models.get_metrics_reply import GetMetricsReply

from koyeb.api.api_client import ApiClient, RequestSerialized
from koyeb.api.api_response import ApiResponse
from koyeb.api.rest import RESTResponseType


class MetricsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_metrics(
        self,
        service_id: Annotated[Optional[StrictStr], Field(description="ID of the service to query instances metrics for. Ignored if instance_id is set.")] = None,
        instance_id: Annotated[Optional[StrictStr], Field(description="ID of the instance to query metrics for.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Metric to query.")] = None,
        start: Annotated[Optional[datetime], Field(description="(Optional) Defaults to an hour prior to end.")] = None,
        end: Annotated[Optional[datetime], Field(description="(Optional) Defaults to now.")] = None,
        step: Annotated[Optional[StrictStr], Field(description="(Optional) Must be a valid duration in hours (h) or minutes (m). Defaulst to 5m.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMetricsReply:
        """Get Metrics


        :param service_id: ID of the service to query instances metrics for. Ignored if instance_id is set.
        :type service_id: str
        :param instance_id: ID of the instance to query metrics for.
        :type instance_id: str
        :param name: Metric to query.
        :type name: str
        :param start: (Optional) Defaults to an hour prior to end.
        :type start: datetime
        :param end: (Optional) Defaults to now.
        :type end: datetime
        :param step: (Optional) Must be a valid duration in hours (h) or minutes (m). Defaulst to 5m.
        :type step: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metrics_serialize(
            service_id=service_id,
            instance_id=instance_id,
            name=name,
            start=start,
            end=end,
            step=step,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricsReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_metrics_with_http_info(
        self,
        service_id: Annotated[Optional[StrictStr], Field(description="ID of the service to query instances metrics for. Ignored if instance_id is set.")] = None,
        instance_id: Annotated[Optional[StrictStr], Field(description="ID of the instance to query metrics for.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Metric to query.")] = None,
        start: Annotated[Optional[datetime], Field(description="(Optional) Defaults to an hour prior to end.")] = None,
        end: Annotated[Optional[datetime], Field(description="(Optional) Defaults to now.")] = None,
        step: Annotated[Optional[StrictStr], Field(description="(Optional) Must be a valid duration in hours (h) or minutes (m). Defaulst to 5m.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMetricsReply]:
        """Get Metrics


        :param service_id: ID of the service to query instances metrics for. Ignored if instance_id is set.
        :type service_id: str
        :param instance_id: ID of the instance to query metrics for.
        :type instance_id: str
        :param name: Metric to query.
        :type name: str
        :param start: (Optional) Defaults to an hour prior to end.
        :type start: datetime
        :param end: (Optional) Defaults to now.
        :type end: datetime
        :param step: (Optional) Must be a valid duration in hours (h) or minutes (m). Defaulst to 5m.
        :type step: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metrics_serialize(
            service_id=service_id,
            instance_id=instance_id,
            name=name,
            start=start,
            end=end,
            step=step,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricsReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_metrics_without_preload_content(
        self,
        service_id: Annotated[Optional[StrictStr], Field(description="ID of the service to query instances metrics for. Ignored if instance_id is set.")] = None,
        instance_id: Annotated[Optional[StrictStr], Field(description="ID of the instance to query metrics for.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Metric to query.")] = None,
        start: Annotated[Optional[datetime], Field(description="(Optional) Defaults to an hour prior to end.")] = None,
        end: Annotated[Optional[datetime], Field(description="(Optional) Defaults to now.")] = None,
        step: Annotated[Optional[StrictStr], Field(description="(Optional) Must be a valid duration in hours (h) or minutes (m). Defaulst to 5m.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Metrics


        :param service_id: ID of the service to query instances metrics for. Ignored if instance_id is set.
        :type service_id: str
        :param instance_id: ID of the instance to query metrics for.
        :type instance_id: str
        :param name: Metric to query.
        :type name: str
        :param start: (Optional) Defaults to an hour prior to end.
        :type start: datetime
        :param end: (Optional) Defaults to now.
        :type end: datetime
        :param step: (Optional) Must be a valid duration in hours (h) or minutes (m). Defaulst to 5m.
        :type step: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metrics_serialize(
            service_id=service_id,
            instance_id=instance_id,
            name=name,
            start=start,
            end=end,
            step=step,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricsReply",
            '400': "ErrorWithFields",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
            '503': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_metrics_serialize(
        self,
        service_id,
        instance_id,
        name,
        start,
        end,
        step,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if service_id is not None:
            
            _query_params.append(('service_id', service_id))
            
        if instance_id is not None:
            
            _query_params.append(('instance_id', instance_id))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if start is not None:
            if isinstance(start, datetime):
                _query_params.append(
                    (
                        'start',
                        start.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start', start))
            
        if end is not None:
            if isinstance(end, datetime):
                _query_params.append(
                    (
                        'end',
                        end.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end', end))
            
        if step is not None:
            
            _query_params.append(('step', step))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    '*/*'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/streams/metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


